/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.odds.adapters;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.GridLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewGroupKt;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemOddsRowBinding;
import io.streamlayer.sdk.databinding.SlrItemOddsSeeMoreBinding;
import io.streamlayer.sdk.databinding.SlrItemOddsTableColumnTitlesBinding;
import io.streamlayer.sdk.databinding.SlrItemOddsTableHeaderBinding;
import io.streamlayer.sdk.databinding.SlrItemOddsTableRowBinding;
import io.streamlayer.sdk.databinding.SlrItemOddsTableViewAllBinding;
import io.streamlayer.sdk.model.odds.Game;
import io.streamlayer.sdk.odds.OddsData;
import io.streamlayer.sdk.odds.OddsDataRow;
import io.streamlayer.sdk.odds.OddsDataRowElement;
import io.streamlayer.sdk.odds.OddsDataSeeMore;
import io.streamlayer.sdk.odds.OddsDataTable;
import io.streamlayer.sdk.odds.OddsDataTableHeader;
import io.streamlayer.sdk.odds.OddsDataTableRow;
import io.streamlayer.sdk.odds.OddsDataViewAll;
import io.streamlayer.sdk.odds.OpenedBet;
import io.streamlayer.sdk.odds.adapters.OddsDataComparator;
import io.streamlayer.sdk.odds.adapters.SelectableBetViewHolder;
import io.streamlayer.sdk.odds.views.OddsRowItemView;
import io.streamlayer.sdk.odds.views.OddsViewExtensions;
import io.streamlayer.sdk.predictions.view.ExtensionsKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006456789Bk\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0016J\u0018\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u001fH\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0016J \u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J(\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020*2\u0006\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u001fH\u0002J\u0014\u00102\u001a\u00020\t2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lio/streamlayer/sdk/odds/adapters/OddsDataAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "primaryColor", "", "textColor", "toggleTable", "Lkotlin/Function1;", "Lio/streamlayer/sdk/odds/OddsDataTable;", "", "viewAll", "seeMore", "openBet", "Lio/streamlayer/sdk/odds/OpenedBet;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "game", "Lio/streamlayer/sdk/model/odds/Game;", "getGame", "()Lio/streamlayer/sdk/model/odds/Game;", "setGame", "(Lio/streamlayer/sdk/model/odds/Game;)V", "oddsData", "", "Lio/streamlayer/sdk/odds/OddsData;", "openedBets", "", "getOpenedBets", "()Ljava/util/List;", "setOpenedBets", "(Ljava/util/List;)V", "getItemCount", "", "getItemViewType", "position", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setClickListener", "variant", "Landroidx/constraintlayout/widget/ConstraintLayout;", "row", "Lio/streamlayer/sdk/odds/OddsDataRow;", "rowElement", "Lio/streamlayer/sdk/odds/OddsDataRowElement;", "betTitle", "variantTitle", "bet", "setItems", "list", "RowViewHolder", "SeeMoreViewHolder", "TableColumnsViewHolder", "TableRowViewHolder", "TableTitleViewHolder", "TableViewAllViewHolder", "sdk_originalVonageRelease"})
public final class OddsDataAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final String primaryColor;
    @Nullable
    private final String textColor;
    @NotNull
    private final Function1<OddsDataTable, Unit> toggleTable;
    @NotNull
    private final Function1<OddsDataTable, Unit> viewAll;
    @NotNull
    private final Function1<String, Unit> seeMore;
    @Nullable
    private final Function1<OpenedBet, Unit> openBet;
    @NotNull
    private final List<OddsData> oddsData;
    @NotNull
    private List<OpenedBet> openedBets;
    @Nullable
    private Game game;

    public OddsDataAdapter(@NotNull String string2, @Nullable String string3, @NotNull Function1<? super OddsDataTable, Unit> function1, @NotNull Function1<? super OddsDataTable, Unit> function12, @NotNull Function1<? super String, Unit> function13, @Nullable Function1<? super OpenedBet, Unit> function14) {
        OddsDataAdapter oddsDataAdapter = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"primaryColor");
        Intrinsics.checkNotNullParameter(function1, (String)"toggleTable");
        Intrinsics.checkNotNullParameter(function12, (String)"viewAll");
        Intrinsics.checkNotNullParameter(function13, (String)"seeMore");
        this.primaryColor = string2;
        this.textColor = string3;
        this.toggleTable = function1;
        this.viewAll = function12;
        this.seeMore = function13;
        oddsDataAdapter.openBet = function14;
        oddsDataAdapter.oddsData = new ArrayList<OddsData>();
        oddsDataAdapter.openedBets = CollectionsKt.emptyList();
    }

    public /* synthetic */ OddsDataAdapter(String string2, String string3, Function1 function1, Function1 function12, Function1 function13, Function1 function14, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function14 = null;
        }
        this(string2, string3, (Function1<? super OddsDataTable, Unit>)function1, (Function1<? super OddsDataTable, Unit>)function12, (Function1<? super String, Unit>)function13, (Function1<? super OpenedBet, Unit>)function14);
    }

    private final void setClickListener(ConstraintLayout constraintLayout, OddsDataRow oddsDataRow, OddsDataRowElement oddsDataRowElement) {
        constraintLayout.setOnClickListener(arg_0 -> OddsDataAdapter.setClickListener$lambda$2(this, oddsDataRowElement, oddsDataRow, arg_0));
    }

    private final void setClickListener(ConstraintLayout constraintLayout, String string2, String string3, int n) {
        constraintLayout.setOnClickListener(arg_0 -> OddsDataAdapter.setClickListener$lambda$3(this, string3, string2, n, arg_0));
    }

    private static final void setClickListener$lambda$2(OddsDataAdapter oddsDataAdapter, OddsDataRowElement object, OddsDataRow object2, View function1) {
        Intrinsics.checkNotNullParameter((Object)((Object)oddsDataAdapter), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)object, (String)"$rowElement");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"$row");
        function1 = oddsDataAdapter.openBet;
        if (function1 != null) {
            OddsDataRow oddsDataRow = object2;
            String string2 = ((OddsDataRowElement)object).getName();
            String string3 = oddsDataRow.getTitle();
            Object object3 = oddsDataAdapter.game;
            object3 = object3 != null ? ((Game)object3).getTitle() : null;
            Object object4 = object2;
            float f = ((OddsDataRowElement)object).getValue();
            object = oddsDataAdapter.game;
            ((OpenedBet)object4)(string2, string3, (String)object3, f, null, (Game)object, 0.0, 0.0, null, null, 976, null);
            function1.invoke(object4);
        }
    }

    private static final void setClickListener$lambda$3(OddsDataAdapter oddsDataAdapter, String string2, String string3, int n, View function1) {
        Intrinsics.checkNotNullParameter((Object)((Object)oddsDataAdapter), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"$variantTitle");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"$betTitle");
        function1 = oddsDataAdapter.openBet;
        if (function1 != null) {
            Object object = oddsDataAdapter.game;
            object = object != null ? ((Game)object).getTitle() : null;
            float f = n;
            Game game2 = oddsDataAdapter.game;
            OpenedBet openedBet = new OpenedBet(string2, string3, (String)object, f, null, game2, 0.0, 0.0, null, null, 976, null);
            function1.invoke((Object)openedBet);
        }
    }

    @NotNull
    public final List<OpenedBet> getOpenedBets() {
        return this.openedBets;
    }

    public final void setOpenedBets(@NotNull List<OpenedBet> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.openedBets = list2;
    }

    @Nullable
    public final Game getGame() {
        return this.game;
    }

    public final void setGame(@Nullable Game game2) {
        this.game = game2;
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup object, int n) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)object, (String)"parent");
        switch (n) {
            default: {
                throw new Exception("no such view type");
            }
            case 5: {
                SeeMoreViewHolder seeMoreViewHolder;
                viewHolder = seeMoreViewHolder;
                OddsDataAdapter oddsDataAdapter = object2;
                Object object2 = SlrItemOddsSeeMoreBinding.inflate(LayoutInflater.from((Context)object.getContext()), (ViewGroup)object, false);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
                seeMoreViewHolder = oddsDataAdapter.new SeeMoreViewHolder((SlrItemOddsSeeMoreBinding)object2);
                break;
            }
            case 4: {
                TableViewAllViewHolder tableViewAllViewHolder;
                viewHolder = tableViewAllViewHolder;
                OddsDataAdapter oddsDataAdapter = object2;
                Object object2 = SlrItemOddsTableViewAllBinding.inflate(LayoutInflater.from((Context)object.getContext()), (ViewGroup)object, false);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
                tableViewAllViewHolder = oddsDataAdapter.new TableViewAllViewHolder((SlrItemOddsTableViewAllBinding)object2);
                break;
            }
            case 3: {
                TableColumnsViewHolder tableColumnsViewHolder;
                viewHolder = tableColumnsViewHolder;
                OddsDataAdapter oddsDataAdapter = object2;
                Object object2 = SlrItemOddsTableColumnTitlesBinding.inflate(LayoutInflater.from((Context)object.getContext()), (ViewGroup)object, false);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
                tableColumnsViewHolder = oddsDataAdapter.new TableColumnsViewHolder((SlrItemOddsTableColumnTitlesBinding)object2);
                break;
            }
            case 2: {
                TableTitleViewHolder tableTitleViewHolder;
                viewHolder = tableTitleViewHolder;
                OddsDataAdapter oddsDataAdapter = object2;
                Object object2 = SlrItemOddsTableHeaderBinding.inflate(LayoutInflater.from((Context)object.getContext()), (ViewGroup)object, false);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
                tableTitleViewHolder = oddsDataAdapter.new TableTitleViewHolder((SlrItemOddsTableHeaderBinding)object2);
                break;
            }
            case 1: {
                TableRowViewHolder tableRowViewHolder;
                object = SlrItemOddsTableRowBinding.inflate(LayoutInflater.from((Context)object.getContext()), (ViewGroup)object, false);
                Context context = ((SlrItemOddsTableRowBinding)object).getRoot().getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"root.context");
                viewHolder = OddsViewExtensions.createBorder$default(OddsViewExtensions.INSTANCE, context, 0, null, 6, null);
                ((SlrItemOddsTableRowBinding)object).slVariant1.setBackground((Drawable)viewHolder);
                ((SlrItemOddsTableRowBinding)object).slVariant2.setBackground((Drawable)viewHolder);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026  }\n                    }");
                viewHolder = tableRowViewHolder;
                tableRowViewHolder = (OddsDataAdapter)((Object)object2).new TableRowViewHolder((SlrItemOddsTableRowBinding)object);
                break;
            }
            case 0: {
                RowViewHolder rowViewHolder;
                object = SlrItemOddsRowBinding.inflate(LayoutInflater.from((Context)object.getContext()), (ViewGroup)object, false);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
                viewHolder = rowViewHolder;
                rowViewHolder = (OddsDataAdapter)((Object)object2).new RowViewHolder((SlrItemOddsRowBinding)object);
            }
        }
        return viewHolder;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        RecyclerView.ViewHolder viewHolder2 = viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"holder");
        if (viewHolder2 instanceof RowViewHolder) {
            RowViewHolder rowViewHolder = (RowViewHolder)viewHolder;
            OddsData oddsData = this.oddsData.get(n);
            Intrinsics.checkNotNull((Object)oddsData, (String)"null cannot be cast to non-null type io.streamlayer.sdk.odds.OddsDataRow");
            rowViewHolder.bind((OddsDataRow)oddsData);
        } else if (viewHolder instanceof TableRowViewHolder) {
            TableRowViewHolder tableRowViewHolder = (TableRowViewHolder)viewHolder;
            OddsData oddsData = this.oddsData.get(n);
            Intrinsics.checkNotNull((Object)oddsData, (String)"null cannot be cast to non-null type io.streamlayer.sdk.odds.OddsDataTableRow");
            tableRowViewHolder.bind((OddsDataTableRow)oddsData);
        } else if (viewHolder instanceof TableTitleViewHolder) {
            TableTitleViewHolder tableTitleViewHolder = (TableTitleViewHolder)viewHolder;
            OddsData oddsData = this.oddsData.get(n);
            Intrinsics.checkNotNull((Object)oddsData, (String)"null cannot be cast to non-null type io.streamlayer.sdk.odds.OddsDataTable");
            tableTitleViewHolder.bind((OddsDataTable)oddsData);
        } else if (viewHolder instanceof TableColumnsViewHolder) {
            TableColumnsViewHolder tableColumnsViewHolder = (TableColumnsViewHolder)viewHolder;
            OddsData oddsData = this.oddsData.get(n);
            Intrinsics.checkNotNull((Object)oddsData, (String)"null cannot be cast to non-null type io.streamlayer.sdk.odds.OddsDataTableHeader");
            tableColumnsViewHolder.bind((OddsDataTableHeader)oddsData);
        } else if (viewHolder instanceof TableViewAllViewHolder) {
            TableViewAllViewHolder tableViewAllViewHolder = (TableViewAllViewHolder)viewHolder;
            OddsData oddsData = this.oddsData.get(n);
            Intrinsics.checkNotNull((Object)oddsData, (String)"null cannot be cast to non-null type io.streamlayer.sdk.odds.OddsDataViewAll");
            tableViewAllViewHolder.bind((OddsDataViewAll)oddsData);
        } else if (viewHolder instanceof SeeMoreViewHolder) {
            SeeMoreViewHolder seeMoreViewHolder = (SeeMoreViewHolder)viewHolder;
            OddsData oddsData = this.oddsData.get(n);
            Intrinsics.checkNotNull((Object)oddsData, (String)"null cannot be cast to non-null type io.streamlayer.sdk.odds.OddsDataSeeMore");
            seeMoreViewHolder.bind((OddsDataSeeMore)oddsData);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getItemViewType(int n) {
        void var1_2;
        OddsData oddsData = this.oddsData.get((int)var1_2);
        if (oddsData instanceof OddsDataRow) {
            return 0;
        }
        if (oddsData instanceof OddsDataTableRow) {
            return 1;
        }
        if (oddsData instanceof OddsDataTable) {
            return 2;
        }
        if (oddsData instanceof OddsDataTableHeader) {
            return 3;
        }
        if (oddsData instanceof OddsDataViewAll) {
            return 4;
        }
        if (!(oddsData instanceof OddsDataSeeMore)) return 0;
        return 5;
    }

    public int getItemCount() {
        return this.oddsData.size();
    }

    public final void setItems(@NotNull List<? extends OddsData> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new OddsDataComparator(this.oddsData, list2));
        OddsDataAdapter oddsDataAdapter = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(OddsDataComparator(oddsData, list))");
        oddsDataAdapter.oddsData.clear();
        oddsDataAdapter.oddsData.addAll(list2);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)oddsDataAdapter);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\u0014\u0010\u0015\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/streamlayer/sdk/odds/adapters/OddsDataAdapter$RowViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lio/streamlayer/sdk/odds/adapters/SelectableBetViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemOddsRowBinding;", "(Lio/streamlayer/sdk/odds/adapters/OddsDataAdapter;Lio/streamlayer/sdk/databinding/SlrItemOddsRowBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemOddsRowBinding;", "row", "Lio/streamlayer/sdk/odds/OddsDataRow;", "bind", "", "getVariants", "", "Lio/streamlayer/sdk/odds/views/OddsRowItemView;", "select", "openedBet", "Lio/streamlayer/sdk/odds/OpenedBet;", "selected", "", "unselectAll", "setViewSelected", "sdk_originalVonageRelease"})
    @SourceDebugExtension(value={"SMAP\nOddsDataAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OddsDataAdapter.kt\nio/streamlayer/sdk/odds/adapters/OddsDataAdapter$RowViewHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,379:1\n1864#2,3:380\n1855#2,2:383\n1549#2:385\n1620#2,3:386\n1855#2,2:389\n1864#2,3:391\n329#3,4:394\n*S KotlinDebug\n*F\n+ 1 OddsDataAdapter.kt\nio/streamlayer/sdk/odds/adapters/OddsDataAdapter$RowViewHolder\n*L\n139#1:380,3\n166#1:383,2\n170#1:385\n170#1:386,3\n173#1:389,2\n179#1:391,3\n148#1:394,4\n*E\n"})
    public final class RowViewHolder
    extends RecyclerView.ViewHolder
    implements SelectableBetViewHolder {
        @NotNull
        private final SlrItemOddsRowBinding binding;
        @Nullable
        private OddsDataRow row;

        public RowViewHolder(SlrItemOddsRowBinding slrItemOddsRowBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemOddsRowBinding, (String)"binding");
            super((View)slrItemOddsRowBinding.getRoot());
            this.binding = slrItemOddsRowBinding;
        }

        private final List<OddsRowItemView> getVariants() {
            ArrayList<OddsRowItemView> arrayList;
            GridLayout gridLayout = ((RowViewHolder)((Object)iterator)).binding.slContainer;
            Intrinsics.checkNotNullExpressionValue((Object)gridLayout, (String)"binding.slContainer");
            Iterator iterator = SequencesKt.toList((Sequence)ViewGroupKt.getChildren((ViewGroup)gridLayout));
            ArrayList<OddsRowItemView> arrayList2 = arrayList;
            arrayList = new ArrayList<OddsRowItemView>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                View view2 = (View)iterator.next();
                Intrinsics.checkNotNull((Object)view2, (String)"null cannot be cast to non-null type io.streamlayer.sdk.odds.views.OddsRowItemView");
                arrayList2.add((OddsRowItemView)view2);
            }
            return arrayList2;
        }

        private final void setViewSelected(OddsRowItemView oddsRowItemView, boolean bl) {
            int n;
            GradientDrawable gradientDrawable;
            if (bl) {
                Context context = oddsRowItemView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                gradientDrawable = OddsViewExtensions.createSelected$default(OddsViewExtensions.INSTANCE, context, 0, OddsDataAdapter.this.primaryColor, 2, null);
            } else {
                Context context = oddsRowItemView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                gradientDrawable = OddsViewExtensions.createBorder$default(OddsViewExtensions.INSTANCE, context, 0, OddsDataAdapter.this.primaryColor, 2, null);
            }
            OddsRowItemView oddsRowItemView2 = oddsRowItemView;
            oddsRowItemView2.setBackground((Drawable)gradientDrawable);
            TextView textView = oddsRowItemView2.getValue();
            if (bl && Intrinsics.areEqual((Object)OddsDataAdapter.this.textColor, (Object)OddsDataAdapter.this.primaryColor)) {
                n = ContextCompat.getColor((Context)oddsRowItemView.getContext(), (int)R.color.slr_white);
            } else {
                Context context = oddsRowItemView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                n = OddsViewExtensions.INSTANCE.getColor(context, OddsDataAdapter.this.textColor);
            }
            textView.setTextColor(n);
        }

        private static final void bind$lambda$5$lambda$3$lambda$2$lambda$1(OddsRowItemView oddsRowItemView, int n, OddsDataRow oddsDataRow) {
            OddsRowItemView oddsRowItemView2 = oddsRowItemView;
            Intrinsics.checkNotNullParameter((Object)((Object)oddsRowItemView2), (String)"$this_apply");
            ViewGroup.LayoutParams layoutParams = oddsRowItemView2.getLayoutParams();
            if (layoutParams != null) {
                layoutParams = (GridLayout.LayoutParams)layoutParams;
                layoutParams.columnSpec = GridLayout.spec((int)Integer.MIN_VALUE, (float)1.0f);
                layoutParams.setGravity(119);
                layoutParams.width = 0;
                layoutParams.height = -2;
                int n2 = n % oddsDataRow.getColumns() > 0 ? ViewExtensionsKt.getDp(8.0f) : 0;
                n = n / oddsDataRow.getColumns() > 0 ? ViewExtensionsKt.getDp(8.0f) : 0;
                layoutParams.setMargins(n2, n, 0, 0);
                oddsRowItemView.setLayoutParams(layoutParams);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.widget.GridLayout.LayoutParams");
        }

        @NotNull
        public final SlrItemOddsRowBinding getBinding() {
            return this.binding;
        }

        @SuppressLint(value={"SetTextI18n"})
        public final void bind(@Nullable OddsDataRow object) {
            this.row = object;
            SlrItemOddsRowBinding slrItemOddsRowBinding = this.binding;
            OddsDataAdapter oddsDataAdapter = OddsDataAdapter.this;
            TextView textView = slrItemOddsRowBinding.slTitle;
            String string2 = object != null ? ((OddsDataRow)((Object)object)).getTitle() : null;
            textView.setText((CharSequence)string2);
            slrItemOddsRowBinding.slContainer.removeAllViews();
            if (object != null) {
                slrItemOddsRowBinding.slContainer.setColumnCount(((OddsDataRow)((Object)object)).getColumns());
                OddsViewExtensions oddsViewExtensions = OddsViewExtensions.INSTANCE;
                textView = slrItemOddsRowBinding.getRoot().getContext();
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"root.context");
                int n = oddsViewExtensions.getColor((Context)textView, oddsDataAdapter.textColor);
                Context context = slrItemOddsRowBinding.getRoot().getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"root.context");
                string2 = OddsViewExtensions.createBorder$default(oddsViewExtensions, context, 0, null, 6, null);
                int n2 = 0;
                for (Object t : ((OddsDataRow)((Object)object)).getElements()) {
                    OddsRowItemView oddsRowItemView;
                    OddsRowItemView oddsRowItemView2;
                    int n3 = n2 + 1;
                    if (n2 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    OddsDataRowElement object2 = (OddsDataRowElement)t;
                    GridLayout gridLayout = slrItemOddsRowBinding.slContainer;
                    OddsRowItemView oddsRowItemView3 = oddsRowItemView2 = oddsRowItemView;
                    Context context2 = slrItemOddsRowBinding.getRoot().getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"root.context");
                    oddsRowItemView3(context2, null, 0, 6, null);
                    oddsRowItemView3.getName().setText((CharSequence)object2.getName());
                    oddsRowItemView3.getValue().setText((CharSequence)OtherExtensionsKt.toSignedString(object2.getValue()));
                    oddsRowItemView3.getValue().setTextColor(n);
                    oddsDataAdapter.setClickListener(oddsRowItemView3, object, object2);
                    oddsRowItemView2.setBackground((Drawable)string2);
                    oddsRowItemView.post(() -> RowViewHolder.bind$lambda$5$lambda$3$lambda$2$lambda$1(oddsRowItemView, n2, object));
                    gridLayout.addView((View)oddsRowItemView);
                    n2 = n3;
                }
            }
            this.unselectAll();
            object = oddsDataAdapter.getOpenedBets().iterator();
            while (object.hasNext()) {
                this.select((OpenedBet)object.next(), true);
            }
        }

        @Override
        public void unselectAll() {
            Iterator iterator = this.getVariants().iterator();
            while (iterator.hasNext()) {
                this.setViewSelected((OddsRowItemView)((Object)iterator.next()), false);
            }
        }

        @Override
        public void select(@NotNull OpenedBet openedBet, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)openedBet, (String)"openedBet");
            OddsDataRow oddsDataRow = this.row;
            if (oddsDataRow != null && Intrinsics.areEqual((Object)oddsDataRow.getTitle(), (Object)openedBet.getBetTitle())) {
                int n = 0;
                for (Object t : this.getVariants()) {
                    if (n++ < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    OddsRowItemView object = (OddsRowItemView)((Object)t);
                    OddsDataRowElement oddsDataRowElement = oddsDataRow.variant(n);
                    if (!(oddsDataRowElement != null && oddsDataRowElement.isForOpenedBet(openedBet))) continue;
                    this.setViewSelected(object, bl);
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\r\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\rH\u0002J(\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0016J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/streamlayer/sdk/odds/adapters/OddsDataAdapter$TableRowViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lio/streamlayer/sdk/odds/adapters/SelectableBetViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemOddsTableRowBinding;", "(Lio/streamlayer/sdk/odds/adapters/OddsDataAdapter;Lio/streamlayer/sdk/databinding/SlrItemOddsTableRowBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemOddsTableRowBinding;", "row", "Lio/streamlayer/sdk/odds/OddsDataTableRow;", "bind", "", "isLastInTable", "", "()Ljava/lang/Boolean;", "select", "openedBet", "Lio/streamlayer/sdk/odds/OpenedBet;", "selected", "setVariant1Selected", "setVariant2Selected", "setVariantSelected", "container", "Landroidx/constraintlayout/widget/ConstraintLayout;", "valueView", "Landroid/widget/TextView;", "smallValueView", "unselectAll", "toValueString", "", "", "sdk_originalVonageRelease"})
    @SourceDebugExtension(value={"SMAP\nOddsDataAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OddsDataAdapter.kt\nio/streamlayer/sdk/odds/adapters/OddsDataAdapter$TableRowViewHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,379:1\n1#2:380\n1855#3,2:381\n*S KotlinDebug\n*F\n+ 1 OddsDataAdapter.kt\nio/streamlayer/sdk/odds/adapters/OddsDataAdapter$TableRowViewHolder\n*L\n239#1:381,2\n*E\n"})
    public final class TableRowViewHolder
    extends RecyclerView.ViewHolder
    implements SelectableBetViewHolder {
        @NotNull
        private final SlrItemOddsTableRowBinding binding;
        @Nullable
        private OddsDataTableRow row;

        public TableRowViewHolder(SlrItemOddsTableRowBinding slrItemOddsTableRowBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemOddsTableRowBinding, (String)"binding");
            super((View)slrItemOddsTableRowBinding.getRoot());
            this.binding = slrItemOddsTableRowBinding;
        }

        private final String toValueString(int n) {
            return n == 0 ? "-" : OtherExtensionsKt.toSignedString(n);
        }

        private final void setVariantSelected(boolean bl, ConstraintLayout constraintLayout, TextView textView, TextView textView2) {
            int n;
            GradientDrawable gradientDrawable;
            if (bl) {
                Context context = constraintLayout.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"container.context");
                gradientDrawable = OddsViewExtensions.createSelected$default(OddsViewExtensions.INSTANCE, context, 0, OddsDataAdapter.this.primaryColor, 2, null);
            } else {
                Context context = constraintLayout.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"container.context");
                gradientDrawable = OddsViewExtensions.createBorder$default(OddsViewExtensions.INSTANCE, context, 0, OddsDataAdapter.this.primaryColor, 2, null);
            }
            constraintLayout.setBackground((Drawable)gradientDrawable);
            if (bl && Intrinsics.areEqual((Object)OddsDataAdapter.this.textColor, (Object)OddsDataAdapter.this.primaryColor)) {
                n = ContextCompat.getColor((Context)constraintLayout.getContext(), (int)R.color.slr_white);
            } else {
                Context context = constraintLayout.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"container.context");
                n = OddsViewExtensions.INSTANCE.getColor(context, OddsDataAdapter.this.textColor);
            }
            textView.setTextColor(n);
            textView2.setTextColor(n);
        }

        private final void setVariant1Selected(boolean bl) {
            TableRowViewHolder tableRowViewHolder = tableRowViewHolder3;
            TableRowViewHolder tableRowViewHolder2 = tableRowViewHolder3;
            TableRowViewHolder tableRowViewHolder3 = tableRowViewHolder2.binding.slVariant1;
            Intrinsics.checkNotNullExpressionValue((Object)tableRowViewHolder3, (String)"binding.slVariant1");
            TextView textView = tableRowViewHolder2.binding.slValue1;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slValue1");
            TextView textView2 = tableRowViewHolder2.binding.slSmallValue1;
            Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.slSmallValue1");
            tableRowViewHolder.setVariantSelected(bl, (ConstraintLayout)tableRowViewHolder3, textView, textView2);
        }

        private final void setVariant2Selected(boolean bl) {
            TableRowViewHolder tableRowViewHolder = tableRowViewHolder3;
            TableRowViewHolder tableRowViewHolder2 = tableRowViewHolder3;
            TableRowViewHolder tableRowViewHolder3 = tableRowViewHolder2.binding.slVariant2;
            Intrinsics.checkNotNullExpressionValue((Object)tableRowViewHolder3, (String)"binding.slVariant2");
            TextView textView = tableRowViewHolder2.binding.slValue2;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slValue2");
            TextView textView2 = tableRowViewHolder2.binding.slSmallValue2;
            Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.slSmallValue2");
            tableRowViewHolder.setVariantSelected(bl, (ConstraintLayout)tableRowViewHolder3, textView, textView2);
        }

        @NotNull
        public final SlrItemOddsTableRowBinding getBinding() {
            return this.binding;
        }

        @SuppressLint(value={"SetTextI18n"})
        public final void bind(@Nullable OddsDataTableRow oddsDataTableRow) {
            String string2;
            this.row = oddsDataTableRow;
            SlrItemOddsTableRowBinding slrItemOddsTableRowBinding = this.binding;
            OddsDataAdapter oddsDataAdapter = OddsDataAdapter.this;
            TextView textView = slrItemOddsTableRowBinding.slName;
            if (oddsDataTableRow == null || (string2 = oddsDataTableRow.getRowName()) == null) {
                string2 = "";
            }
            textView.setText((CharSequence)string2);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (oddsDataTableRow instanceof OddsDataTableRow.OverUnder) {
                SlrItemOddsTableRowBinding slrItemOddsTableRowBinding2 = slrItemOddsTableRowBinding;
                OddsDataTableRow.OverUnder overUnder = (OddsDataTableRow.OverUnder)oddsDataTableRow;
                slrItemOddsTableRowBinding2.slHeader1.setText((CharSequence)overUnder.getOverHeader());
                slrItemOddsTableRowBinding2.slHeader2.setText((CharSequence)overUnder.getUnderHeader());
                slrItemOddsTableRowBinding2.slSmallValue1.setText((CharSequence)this.toValueString(overUnder.getValue1()));
                slrItemOddsTableRowBinding2.slSmallValue2.setText((CharSequence)this.toValueString(overUnder.getValue2()));
                bl = true;
                bl3 = true;
            } else {
                String string3;
                TextView textView2 = slrItemOddsTableRowBinding.slValue1;
                if (oddsDataTableRow == null || (string3 = this.toValueString(oddsDataTableRow.getValue1())) == null) {
                    string3 = "";
                }
                textView2.setText((CharSequence)string3);
                textView2 = slrItemOddsTableRowBinding.slValue2;
                if (oddsDataTableRow == null || (string3 = this.toValueString(oddsDataTableRow.getValue2())) == null) {
                    string3 = "";
                }
                textView2.setText((CharSequence)string3);
                bl2 = true;
            }
            SlrItemOddsTableRowBinding slrItemOddsTableRowBinding3 = slrItemOddsTableRowBinding;
            TextView textView3 = slrItemOddsTableRowBinding3.slHeader1;
            Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"slHeader1");
            ViewExtensionsKt.visibleIf((View)textView3, bl);
            TextView textView4 = slrItemOddsTableRowBinding3.slHeader2;
            Intrinsics.checkNotNullExpressionValue((Object)textView4, (String)"slHeader2");
            ViewExtensionsKt.visibleIf((View)textView4, bl);
            TextView textView5 = slrItemOddsTableRowBinding3.slSmallValue1;
            Intrinsics.checkNotNullExpressionValue((Object)textView5, (String)"slSmallValue1");
            ViewExtensionsKt.visibleIf((View)textView5, bl3);
            TextView textView6 = slrItemOddsTableRowBinding3.slSmallValue2;
            Intrinsics.checkNotNullExpressionValue((Object)textView6, (String)"slSmallValue2");
            ViewExtensionsKt.visibleIf((View)textView6, bl3);
            TextView textView7 = slrItemOddsTableRowBinding3.slValue1;
            Intrinsics.checkNotNullExpressionValue((Object)textView7, (String)"slValue1");
            ViewExtensionsKt.visibleIf((View)textView7, bl2);
            TextView textView8 = slrItemOddsTableRowBinding3.slValue2;
            Intrinsics.checkNotNullExpressionValue((Object)textView8, (String)"slValue2");
            ViewExtensionsKt.visibleIf((View)textView8, bl2);
            Context context = slrItemOddsTableRowBinding.getRoot().getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"root.context");
            int n = OddsViewExtensions.INSTANCE.getColor(context, oddsDataAdapter.textColor);
            slrItemOddsTableRowBinding3.slValue1.setTextColor(n);
            slrItemOddsTableRowBinding3.slValue2.setTextColor(n);
            slrItemOddsTableRowBinding3.slSmallValue1.setTextColor(n);
            slrItemOddsTableRowBinding3.slSmallValue2.setTextColor(n);
            if (oddsDataTableRow != null) {
                OddsDataTableRow oddsDataTableRow2 = oddsDataTableRow;
                OddsDataTableRow oddsDataTableRow3 = oddsDataTableRow;
                ConstraintLayout constraintLayout = slrItemOddsTableRowBinding.slVariant1;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"slVariant1");
                String string4 = oddsDataTableRow3.getBetTitle1();
                String string5 = oddsDataTableRow3.getRowName();
                int n2 = oddsDataTableRow3.getValue1();
                oddsDataAdapter.setClickListener(constraintLayout, string4, string5, n2);
                constraintLayout = slrItemOddsTableRowBinding.slVariant2;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"slVariant2");
                string4 = oddsDataTableRow2.getBetTitle2();
                string5 = oddsDataTableRow2.getRowName();
                n2 = oddsDataTableRow2.getValue2();
                oddsDataAdapter.setClickListener(constraintLayout, string4, string5, n2);
            }
            slrItemOddsTableRowBinding = slrItemOddsTableRowBinding.getRoot();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = oddsDataTableRow != null && oddsDataTableRow.getLastInTable() ? 0 : ViewExtensionsKt.getDp(16.0f);
            slrItemOddsTableRowBinding.setPadding(n3, n4, n5, n6);
            this.unselectAll();
            Iterator iterator = oddsDataAdapter.getOpenedBets().iterator();
            while (iterator.hasNext()) {
                this.select((OpenedBet)iterator.next(), true);
            }
        }

        @Nullable
        public final Boolean isLastInTable() {
            OddsDataTableRow oddsDataTableRow = ((TableRowViewHolder)((Object)oddsDataTableRow)).row;
            return oddsDataTableRow != null ? Boolean.valueOf(oddsDataTableRow.getLastInTable()) : null;
        }

        @Override
        public void unselectAll() {
            TableRowViewHolder tableRowViewHolder = this;
            tableRowViewHolder.setVariant1Selected(false);
            tableRowViewHolder.setVariant2Selected(false);
        }

        @Override
        public void select(@NotNull OpenedBet openedBet, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)openedBet, (String)"openedBet");
            OddsDataTableRow oddsDataTableRow = this.row;
            if (oddsDataTableRow != null) {
                if (oddsDataTableRow.isForOpenedBet1(openedBet)) {
                    this.setVariant1Selected(bl);
                } else if (oddsDataTableRow.isForOpenedBet2(openedBet)) {
                    this.setVariant2Selected(bl);
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\r\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/sdk/odds/adapters/OddsDataAdapter$TableTitleViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemOddsTableHeaderBinding;", "(Lio/streamlayer/sdk/odds/adapters/OddsDataAdapter;Lio/streamlayer/sdk/databinding/SlrItemOddsTableHeaderBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemOddsTableHeaderBinding;", "table", "Lio/streamlayer/sdk/odds/OddsDataTable;", "bind", "", "isExpanded", "", "()Ljava/lang/Boolean;", "sdk_originalVonageRelease"})
    public final class TableTitleViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemOddsTableHeaderBinding binding;
        @Nullable
        private OddsDataTable table;

        public TableTitleViewHolder(SlrItemOddsTableHeaderBinding slrItemOddsTableHeaderBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemOddsTableHeaderBinding, (String)"binding");
            super((View)slrItemOddsTableHeaderBinding.getRoot());
            this.binding = slrItemOddsTableHeaderBinding;
        }

        private static final void bind$lambda$0(OddsDataAdapter oddsDataAdapter, OddsDataTable oddsDataTable, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)oddsDataAdapter), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)oddsDataTable, (String)"$table");
            oddsDataAdapter.toggleTable.invoke((Object)oddsDataTable);
        }

        @NotNull
        public final SlrItemOddsTableHeaderBinding getBinding() {
            return this.binding;
        }

        public final void bind(@NotNull OddsDataTable oddsDataTable) {
            TableTitleViewHolder tableTitleViewHolder = this;
            OddsDataTable oddsDataTable2 = oddsDataTable;
            Intrinsics.checkNotNullParameter((Object)oddsDataTable2, (String)"table");
            tableTitleViewHolder.table = oddsDataTable2;
            tableTitleViewHolder.binding.slTitle.setText((CharSequence)oddsDataTable.getHeader().getTitle());
            ImageView imageView2 = tableTitleViewHolder.binding.slToggle;
            int n = oddsDataTable.getExpanded() ? R.drawable.slr_ic_odds_toggle_expanded : R.drawable.slr_ic_odds_toggle_collapsed;
            imageView2.setImageResource(n);
            this.binding.slToggle.setOnClickListener(arg_0 -> TableTitleViewHolder.bind$lambda$0(OddsDataAdapter.this, oddsDataTable, arg_0));
        }

        @Nullable
        public final Boolean isExpanded() {
            OddsDataTable oddsDataTable = ((TableTitleViewHolder)((Object)oddsDataTable)).table;
            return oddsDataTable != null ? Boolean.valueOf(oddsDataTable.getExpanded()) : null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/sdk/odds/adapters/OddsDataAdapter$TableColumnsViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemOddsTableColumnTitlesBinding;", "(Lio/streamlayer/sdk/odds/adapters/OddsDataAdapter;Lio/streamlayer/sdk/databinding/SlrItemOddsTableColumnTitlesBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemOddsTableColumnTitlesBinding;", "bind", "", "header", "Lio/streamlayer/sdk/odds/OddsDataTableHeader;", "sdk_originalVonageRelease"})
    private final class TableColumnsViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemOddsTableColumnTitlesBinding binding;

        public TableColumnsViewHolder(SlrItemOddsTableColumnTitlesBinding slrItemOddsTableColumnTitlesBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemOddsTableColumnTitlesBinding, (String)"binding");
            super((View)slrItemOddsTableColumnTitlesBinding.getRoot());
            this.binding = slrItemOddsTableColumnTitlesBinding;
        }

        @NotNull
        public final SlrItemOddsTableColumnTitlesBinding getBinding() {
            return this.binding;
        }

        public final void bind(@NotNull OddsDataTableHeader oddsDataTableHeader) {
            TableColumnsViewHolder tableColumnsViewHolder = this;
            Intrinsics.checkNotNullParameter((Object)oddsDataTableHeader, (String)"header");
            tableColumnsViewHolder.binding.slColumn1.setText((CharSequence)oddsDataTableHeader.getColumn1());
            tableColumnsViewHolder.binding.slColumn2.setText((CharSequence)oddsDataTableHeader.getColumn2());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/sdk/odds/adapters/OddsDataAdapter$TableViewAllViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemOddsTableViewAllBinding;", "(Lio/streamlayer/sdk/odds/adapters/OddsDataAdapter;Lio/streamlayer/sdk/databinding/SlrItemOddsTableViewAllBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemOddsTableViewAllBinding;", "bind", "", "viewAll", "Lio/streamlayer/sdk/odds/OddsDataViewAll;", "sdk_originalVonageRelease"})
    public final class TableViewAllViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemOddsTableViewAllBinding binding;

        public TableViewAllViewHolder(SlrItemOddsTableViewAllBinding slrItemOddsTableViewAllBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemOddsTableViewAllBinding, (String)"binding");
            super((View)slrItemOddsTableViewAllBinding.getRoot());
            this.binding = slrItemOddsTableViewAllBinding;
        }

        private static final void bind$lambda$0(OddsDataAdapter oddsDataAdapter, OddsDataViewAll oddsDataViewAll, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)oddsDataAdapter), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)oddsDataViewAll, (String)"$viewAll");
            oddsDataAdapter.viewAll.invoke((Object)oddsDataViewAll.getTable());
        }

        @NotNull
        public final SlrItemOddsTableViewAllBinding getBinding() {
            return this.binding;
        }

        public final void bind(@NotNull OddsDataViewAll oddsDataViewAll) {
            Intrinsics.checkNotNullParameter((Object)oddsDataViewAll, (String)"viewAll");
            this.binding.slToggle.setOnClickListener(arg_0 -> TableViewAllViewHolder.bind$lambda$0(OddsDataAdapter.this, oddsDataViewAll, arg_0));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/sdk/odds/adapters/OddsDataAdapter$SeeMoreViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemOddsSeeMoreBinding;", "(Lio/streamlayer/sdk/odds/adapters/OddsDataAdapter;Lio/streamlayer/sdk/databinding/SlrItemOddsSeeMoreBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemOddsSeeMoreBinding;", "bind", "", "seeMore", "Lio/streamlayer/sdk/odds/OddsDataSeeMore;", "sdk_originalVonageRelease"})
    @SourceDebugExtension(value={"SMAP\nOddsDataAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OddsDataAdapter.kt\nio/streamlayer/sdk/odds/adapters/OddsDataAdapter$SeeMoreViewHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,379:1\n1#2:380\n*E\n"})
    private final class SeeMoreViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemOddsSeeMoreBinding binding;

        public SeeMoreViewHolder(SlrItemOddsSeeMoreBinding slrItemOddsSeeMoreBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemOddsSeeMoreBinding, (String)"binding");
            super((View)slrItemOddsSeeMoreBinding.getRoot());
            this.binding = slrItemOddsSeeMoreBinding;
        }

        private static final void bind$lambda$1(OddsDataAdapter oddsDataAdapter, OddsDataSeeMore oddsDataSeeMore, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)oddsDataAdapter), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)oddsDataSeeMore, (String)"$seeMore");
            oddsDataAdapter.seeMore.invoke((Object)oddsDataSeeMore.getLink());
        }

        @NotNull
        public final SlrItemOddsSeeMoreBinding getBinding() {
            return this.binding;
        }

        public final void bind(@NotNull OddsDataSeeMore oddsDataSeeMore) {
            OddsDataSeeMore oddsDataSeeMore2 = oddsDataSeeMore;
            Intrinsics.checkNotNullParameter((Object)oddsDataSeeMore2, (String)"seeMore");
            String string2 = oddsDataSeeMore2.getIcon();
            if (string2 != null) {
                ImageView imageView2 = this.binding.slSeeMoreIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.slSeeMoreIcon");
                ExtensionsKt.load(imageView2, string2);
            }
            this.binding.getRoot().setOnClickListener(arg_0 -> SeeMoreViewHolder.bind$lambda$1(OddsDataAdapter.this, oddsDataSeeMore, arg_0));
        }
    }
}

