/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.calls.recent;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.textview.MaterialTextView;
import io.streamlayer.common.interfaces.CategoryData;
import io.streamlayer.common.interfaces.ShareInviteView;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.common.recyclerview.CategoryViewHolder;
import io.streamlayer.common.recyclerview.InviteShareViewHolder;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.calls.recent.UserAvatarsAdapter;
import io.streamlayer.sdk.messaging.MessagingExtensionsKt;
import io.streamlayer.sdk.model.calls.CallConnectionStatus;
import io.streamlayer.sdk.model.calls.CallParticipantStatus;
import io.streamlayer.sdk.model.calls.CallStatus;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.calls.WatchPartyKt;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u001a\u001b\u001c\u001d\u001eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0014\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "listener", "Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartiesInteractionListener;", "(Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartiesInteractionListener;)V", "avatarsRecyclerPool", "Landroidx/recyclerview/widget/RecyclerView$RecycledViewPool;", "listItems", "", "Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem;", "getItem", "position", "", "getItemCount", "getItemViewType", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setData", "watchParties", "", "RecentCallViewHolder", "ShowMoreViewHolder", "WatchPartiesDiffUtil", "WatchPartiesInteractionListener", "WatchPartyItem", "sdk_originalVoximplantRelease"})
public final class WatchPartiesAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final RecyclerView.RecycledViewPool avatarsRecyclerPool;
    private final List<WatchPartyItem> listItems;
    private final WatchPartiesInteractionListener listener;

    public WatchPartiesAdapter(@NotNull WatchPartiesInteractionListener watchPartiesInteractionListener) {
        ArrayList arrayList;
        RecyclerView.RecycledViewPool recycledViewPool;
        Intrinsics.checkParameterIsNotNull((Object)watchPartiesInteractionListener, (String)"listener");
        object.listener = watchPartiesInteractionListener;
        Object object = recycledViewPool;
        recycledViewPool = new RecyclerView.RecycledViewPool();
        v1.avatarsRecyclerPool = object;
        object = arrayList;
        arrayList = new ArrayList();
        v1.listItems = object;
    }

    public final void setData(@NotNull List<? extends WatchPartyItem> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"watchParties");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new WatchPartiesDiffUtil(this.listItems, list));
        WatchPartiesAdapter watchPartiesAdapter = this;
        Intrinsics.checkExpressionValueIsNotNull((Object)diffResult, (String)"DiffUtil.calculateDiff(W\u2026listItems, watchParties))");
        watchPartiesAdapter.listItems.clear();
        watchPartiesAdapter.listItems.addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)watchPartiesAdapter);
    }

    @NotNull
    public final WatchPartyItem getItem(int n) {
        return this.listItems.get(n);
    }

    public int getItemViewType(int n) {
        block6: {
            int n2;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            Object object = object.listItems.get(n);
                            if (!(object instanceof WatchPartyItem.Data)) break block2;
                            n2 = 0;
                            break block3;
                        }
                        if (!(object instanceof WatchPartyItem.Category)) break block4;
                        n2 = 1;
                        break block3;
                    }
                    if (!(object instanceof WatchPartyItem.Invite)) break block5;
                    n2 = 2;
                    break block3;
                }
                if (!(object instanceof WatchPartyItem.ShowMore)) break block6;
                n2 = -1;
            }
            return n2;
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkParameterIsNotNull((Object)viewGroup, (String)"parent");
        switch (n) {
            default: {
                throw new Exception("Unsupported View type");
            }
            case 2: {
                InviteShareViewHolder inviteShareViewHolder;
                viewHolder = inviteShareViewHolder;
                WatchPartiesAdapter watchPartiesAdapter = watchPartiesAdapter2;
                WatchPartiesAdapter watchPartiesAdapter2 = ExtensionsKt.inflate(viewGroup, R.layout.slr_item_watch_party_share);
                inviteShareViewHolder = new InviteShareViewHolder((View)watchPartiesAdapter2, watchPartiesAdapter.listener);
                break;
            }
            case 1: {
                CategoryViewHolder categoryViewHolder;
                viewHolder = categoryViewHolder;
                categoryViewHolder = new CategoryViewHolder(ExtensionsKt.inflate(viewGroup, R.layout.slr_item_watch_party_category));
                break;
            }
            case 0: {
                RecentCallViewHolder recentCallViewHolder;
                viewHolder = recentCallViewHolder;
                recentCallViewHolder = new RecentCallViewHolder(watchPartiesAdapter2, ExtensionsKt.inflate(viewGroup, R.layout.slr_item_watch_party));
                break;
            }
            case -1: {
                ShowMoreViewHolder showMoreViewHolder;
                viewHolder = showMoreViewHolder;
                showMoreViewHolder = watchPartiesAdapter2.new ShowMoreViewHolder(ExtensionsKt.inflate(viewGroup, R.layout.slr_item_watch_party_show_more));
            }
        }
        return viewHolder;
    }

    public int getItemCount() {
        return this.listItems.size();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder object, int n) {
        void var2_4;
        Object object2;
        Object object3 = object;
        Intrinsics.checkParameterIsNotNull((Object)object3, (String)"holder");
        if (object3 instanceof RecentCallViewHolder) {
            WatchPartiesAdapter watchPartiesAdapter = object2;
            object2 = (RecentCallViewHolder)((Object)object);
            WatchPartyItem watchPartyItem = watchPartiesAdapter.getItem((int)var2_4);
            if (watchPartyItem == null) throw new TypeCastException("null cannot be cast to non-null type io.streamlayer.sdk.calls.recent.WatchPartiesAdapter.WatchPartyItem.Data");
            ((RecentCallViewHolder)((Object)object2)).bind(((WatchPartyItem.Data)watchPartyItem).getWatchParty());
            return;
        } else {
            if (!(object instanceof CategoryViewHolder)) return;
            Object object4 = object2;
            object2 = (CategoryViewHolder)((Object)object);
            WatchPartyItem watchPartyItem = ((WatchPartiesAdapter)((Object)object4)).getItem((int)var2_4);
            if (watchPartyItem == null) throw new TypeCastException("null cannot be cast to non-null type io.streamlayer.sdk.calls.recent.WatchPartiesAdapter.WatchPartyItem.Category");
            ((CategoryViewHolder)((Object)object2)).bind((WatchPartyItem.Category)watchPartyItem);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$ShowMoreViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter;Landroid/view/View;)V", "sdk_originalVoximplantRelease"})
    public final class ShowMoreViewHolder
    extends RecyclerView.ViewHolder {
        public ShowMoreViewHolder(View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view);
            ((MaterialButton)view.findViewById(R.id.slWatchPartyShowMoreTV)).setOnClickListener(new View.OnClickListener(){

                public final void onClick(View view) {
                    1 v0 = this;
                    int n = v0.WatchPartiesAdapter.this.listItems.size() - 1;
                    v0.WatchPartiesAdapter.this.listItems.remove(n);
                    v0.WatchPartiesAdapter.this.notifyItemRemoved(n);
                    v0.WatchPartiesAdapter.this.listener.showMore();
                }
            });
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$RecentCallViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter;Landroid/view/View;)V", "participantsAdapter", "Lio/streamlayer/sdk/calls/recent/UserAvatarsAdapter;", "bind", "", "watchParty", "Lio/streamlayer/sdk/model/calls/WatchParty;", "sdk_originalVoximplantRelease"})
    public final class RecentCallViewHolder
    extends RecyclerView.ViewHolder {
        private final UserAvatarsAdapter participantsAdapter;
        final /* synthetic */ WatchPartiesAdapter this$0;

        public RecentCallViewHolder(@NotNull WatchPartiesAdapter watchPartiesAdapter, View view) {
            View view2 = view;
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            this.this$0 = watchPartiesAdapter;
            super(view);
            this.participantsAdapter = new UserAvatarsAdapter();
            RecyclerView recyclerView = (RecyclerView)view2.findViewById(R.id.slWatchPartyParticipantsRV);
            Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"itemView.slWatchPartyParticipantsRV");
            recyclerView.setAdapter((RecyclerView.Adapter)this.participantsAdapter);
            ((RecyclerView)view2.findViewById(R.id.slWatchPartyParticipantsRV)).setRecycledViewPool(watchPartiesAdapter.avatarsRecyclerPool);
            watchPartiesAdapter = (MaterialButton)view2.findViewById(R.id.slWatchPartyJoinBtn);
            if (watchPartiesAdapter != null) {
                View.OnClickListener onClickListener;
                WatchPartiesAdapter watchPartiesAdapter2 = watchPartiesAdapter;
                watchPartiesAdapter = onClickListener;
                onClickListener = new View.OnClickListener(){

                    public final void onClick(View object) {
                        object = this;
                        if ((object = ((RecentCallViewHolder)((Object)object)).this$0.getItem(object.getLayoutPosition())) != null) {
                            if (WatchPartyKt.isActive((WatchParty)(object = ((WatchPartyItem.Data)object).getWatchParty()))) {
                                this$0.listener.onWatchPartyJoinClick(((WatchParty)object).getData());
                            } else {
                                this$0.listener.onWatchPartyStartClick(((WatchParty)object).getData());
                            }
                            return;
                        }
                        throw new TypeCastException("null cannot be cast to non-null type io.streamlayer.sdk.calls.recent.WatchPartiesAdapter.WatchPartyItem.Data");
                    }
                };
                watchPartiesAdapter2.setOnClickListener((View.OnClickListener)watchPartiesAdapter);
            }
        }

        public final void bind(@NotNull WatchParty watchParty) {
            int n;
            ArrayList arrayList;
            RecentCallViewHolder recentCallViewHolder;
            Object object;
            Iterator iterator;
            WatchParty watchParty2 = watchParty;
            Intrinsics.checkParameterIsNotNull((Object)watchParty2, (String)"watchParty");
            Object object2 = watchParty2.getStatus();
            if (object2 != null && (object2 = ((CallStatus)object2).getParticipantStatuses()) != null) {
                ArrayList arrayList2;
                ArrayList arrayList3;
                Object object3 = object2;
                object2 = arrayList3;
                arrayList3 = new ArrayList();
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (!((CallParticipantStatus)object).getWasParticipant()) continue;
                    object2.add(object);
                }
                iterator = arrayList2;
                arrayList2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    iterator.add(((CallParticipantStatus)object2.next()).getUserId());
                }
            } else {
                iterator = CollectionsKt.emptyList();
            }
            WatchParty watchParty3 = watchParty;
            object2 = recentCallViewHolder.participantsAdapter;
            object = watchParty3.getData();
            Object object4 = watchParty3.getOwner();
            object4 = object4 != null ? ((TinodeContact)object4).getChatUserId() : null;
            List<TinodeContact> list = MessagingExtensionsKt.participantsWithoutUser((Chat)object, (String)object4);
            object = arrayList;
            arrayList = new ArrayList();
            for (Object t : list) {
                if (!iterator.contains(((TinodeContact)t).getChatUserId())) continue;
                object.add(t);
            }
            object2.setItems((List)object);
            recentCallViewHolder = recentCallViewHolder.itemView;
            object2 = watchParty.getOwner();
            if (object2 != null) {
                iterator = (AppCompatImageView)recentCallViewHolder.findViewById(R.id.slWatchPartyIV);
                Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"slWatchPartyIV");
                ProfileExtensionsKt.loadContactAvatarWithStatus$default((ImageView)iterator, (TinodeContact)object2, WatchPartyKt.isActive(watchParty), null, 4, null);
            }
            object2 = (MaterialTextView)recentCallViewHolder.findViewById(R.id.slWatchPartyNameTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"slWatchPartyNameTV");
            iterator = watchParty.getOwner();
            if (iterator == null || (iterator = ((TinodeContact)((Object)iterator)).getChatName()) == null) {
                iterator = watchParty.getData().getName();
            }
            RecentCallViewHolder recentCallViewHolder2 = recentCallViewHolder;
            object2.setText((CharSequence)((Object)iterator));
            MaterialTextView materialTextView = (MaterialTextView)recentCallViewHolder2.findViewById(R.id.slWatchPartyGameTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)materialTextView, (String)"slWatchPartyGameTV");
            materialTextView.setText((CharSequence)"NFL BAL v ATL");
            MaterialTextView materialTextView2 = (MaterialTextView)recentCallViewHolder2.findViewById(R.id.slWatchPartyGameTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)materialTextView2, (String)"slWatchPartyGameTV");
            ExtensionsKt.visibleIf((View)materialTextView2, WatchPartyKt.isActive(watchParty));
            object2 = watchParty.getStatus();
            if (!(object2 == null || (object2 = ((CallStatus)object2).getParticipantStatuses()) == null || object2 instanceof Collection && object2.isEmpty())) {
                n = 0;
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    if (!((CallParticipantStatus)iterator.next()).getWasParticipant() || ++n >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
            } else {
                n = 0;
            }
            n = n >= 9 ? 1 : 0;
            if (WatchPartyKt.isActive(watchParty) && n != 0) {
                MaterialButton materialButton = (MaterialButton)recentCallViewHolder.findViewById(R.id.slWatchPartyJoinBtn);
                int n2 = ExtensionsKt.getDp(7.0f);
                materialButton.setPadding(n2, n2, n2, n2);
                materialButton.setBackgroundColor(ContextCompat.getColor((Context)materialButton.getContext(), (int)R.color.slr_gray700));
                materialButton.setText(R.string.slr_party_full);
                materialButton.setEnabled(false);
            } else if (WatchPartyKt.isActive(watchParty)) {
                MaterialButton materialButton = (MaterialButton)recentCallViewHolder.findViewById(R.id.slWatchPartyJoinBtn);
                int n3 = ExtensionsKt.getDp(7.0f);
                materialButton.setPadding(n3, n3, n3, n3);
                materialButton.setBackgroundColor(ContextCompat.getColor((Context)materialButton.getContext(), (int)R.color.slr_primaryBlue));
                materialButton.setText(R.string.slr_join_party);
                materialButton.setIconResource(R.drawable.slr_ic_watch_party);
                materialButton.setEnabled(true);
            } else {
                MaterialButton materialButton = (MaterialButton)recentCallViewHolder.findViewById(R.id.slWatchPartyJoinBtn);
                int n4 = ExtensionsKt.getDp(5.0f);
                materialButton.setPadding(n4, n4, n4, n4);
                materialButton.setBackgroundColor(ContextCompat.getColor((Context)materialButton.getContext(), (int)R.color.slr_primaryBlue));
                materialButton.setText(R.string.slr_start);
                materialButton.setIcon(null);
                materialButton.setEnabled(true);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartiesDiffUtil;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldItems", "", "Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem;", "newItems", "(Ljava/util/List;Ljava/util/List;)V", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "getNewListSize", "getOldListSize", "sdk_originalVoximplantRelease"})
    private static final class WatchPartiesDiffUtil
    extends DiffUtil.Callback {
        private final List<WatchPartyItem> oldItems;
        private final List<WatchPartyItem> newItems;

        public WatchPartiesDiffUtil(@NotNull List<? extends WatchPartyItem> list, @NotNull List<? extends WatchPartyItem> list2) {
            Intrinsics.checkParameterIsNotNull(list, (String)"oldItems");
            Intrinsics.checkParameterIsNotNull(list2, (String)"newItems");
            this.oldItems = list;
            this.newItems = list2;
        }

        public boolean areItemsTheSame(int n, int n2) {
            WatchPartyItem watchPartyItem = object.oldItems.get(n);
            Object object = object.newItems.get(n2);
            return watchPartyItem instanceof WatchPartyItem.Data && object instanceof WatchPartyItem.Data && Intrinsics.areEqual((Object)((WatchPartyItem.Data)watchPartyItem).getWatchParty().getData().getChatId(), (Object)((WatchPartyItem.Data)object).getWatchParty().getData().getChatId()) || watchPartyItem instanceof WatchPartyItem.Category && object instanceof WatchPartyItem.Category && Intrinsics.areEqual((Object)((WatchPartyItem.Category)watchPartyItem).getTitle(), (Object)((WatchPartyItem.Category)object).getTitle()) || watchPartyItem instanceof WatchPartyItem.Invite && object instanceof WatchPartyItem.Invite;
        }

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean areContentsTheSame(int n, int n2) {
            void var2_4;
            void var1_2;
            WatchPartyItem watchPartyItem = this.oldItems.get((int)var1_2);
            WatchPartyItem watchPartyItem2 = this.newItems.get((int)var2_4);
            if (watchPartyItem instanceof WatchPartyItem.Data && watchPartyItem2 instanceof WatchPartyItem.Data) {
                WatchPartyItem.Data data = (WatchPartyItem.Data)watchPartyItem;
                WatchPartyItem.Data data2 = (WatchPartyItem.Data)watchPartyItem2;
                if (Intrinsics.areEqual((Object)data.getWatchParty().getData().getUpdatedAt(), (Object)data2.getWatchParty().getData().getUpdatedAt()) && Intrinsics.areEqual(data.getWatchParty().getData().getParticipants(), data2.getWatchParty().getData().getParticipants()) && Intrinsics.areEqual((Object)data.getWatchParty().getOwner(), (Object)data2.getWatchParty().getOwner())) {
                    void var3_14;
                    void var2_9;
                    CallStatus callStatus = data.getWatchParty().getStatus();
                    if (callStatus != null) {
                        CallConnectionStatus callConnectionStatus = callStatus.getStatus();
                    } else {
                        Object var2_8 = null;
                    }
                    CallStatus callStatus2 = data2.getWatchParty().getStatus();
                    if (callStatus2 != null) {
                        CallConnectionStatus callConnectionStatus = callStatus2.getStatus();
                    } else {
                        Object var3_13 = null;
                    }
                    if (var2_9 == var3_14) return true;
                }
            }
            if (watchPartyItem instanceof WatchPartyItem.Category && watchPartyItem2 instanceof WatchPartyItem.Category) {
                if (Intrinsics.areEqual((Object)((WatchPartyItem.Category)watchPartyItem).getTitle(), (Object)((WatchPartyItem.Category)watchPartyItem2).getTitle())) return true;
            }
            if (!(watchPartyItem instanceof WatchPartyItem.Invite)) return false;
            if (!(watchPartyItem2 instanceof WatchPartyItem.Invite)) return false;
            return true;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0007\u001a\u00020\u0003H\u0016\u00a8\u0006\b"}, d2={"Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartiesInteractionListener;", "Lio/streamlayer/common/interfaces/ShareInviteView;", "onWatchPartyJoinClick", "", "item", "Lio/streamlayer/sdk/model/messaging/Chat;", "onWatchPartyStartClick", "showMore", "sdk_originalVoximplantRelease"})
    public static interface WatchPartiesInteractionListener
    extends ShareInviteView {
        public void onWatchPartyStartClick(@NotNull Chat var1);

        public void onWatchPartyJoinClick(@NotNull Chat var1);

        public void showMore();

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void showMore(WatchPartiesInteractionListener watchPartiesInteractionListener) {
            }

            public static void onShareInviteCodeClick(WatchPartiesInteractionListener watchPartiesInteractionListener) {
                ShareInviteView.DefaultImpls.onShareInviteCodeClick(watchPartiesInteractionListener);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem;", "", "()V", "Category", "Data", "Invite", "ShowMore", "Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem$Data;", "Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem$Category;", "Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem$Invite;", "Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem$ShowMore;", "sdk_originalVoximplantRelease"})
    public static abstract class WatchPartyItem {
        private WatchPartyItem() {
        }

        public /* synthetic */ WatchPartyItem(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem$Data;", "Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem;", "watchParty", "Lio/streamlayer/sdk/model/calls/WatchParty;", "(Lio/streamlayer/sdk/model/calls/WatchParty;)V", "getWatchParty", "()Lio/streamlayer/sdk/model/calls/WatchParty;", "sdk_originalVoximplantRelease"})
        public static final class Data
        extends WatchPartyItem {
            @NotNull
            private final WatchParty watchParty;

            public Data(@NotNull WatchParty watchParty) {
                Intrinsics.checkParameterIsNotNull((Object)watchParty, (String)"watchParty");
                super(null);
                this.watchParty = watchParty;
            }

            @NotNull
            public final WatchParty getWatchParty() {
                return this.watchParty;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem$Category;", "Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem;", "Lio/streamlayer/common/interfaces/CategoryData;", "title", "", "info", "(Ljava/lang/String;Ljava/lang/String;)V", "getInfo", "()Ljava/lang/String;", "getTitle", "sdk_originalVoximplantRelease"})
        public static final class Category
        extends WatchPartyItem
        implements CategoryData {
            @NotNull
            private final String title;
            @Nullable
            private final String info;

            public Category(@NotNull String string2, @Nullable String string3) {
                Intrinsics.checkParameterIsNotNull((Object)string2, (String)"title");
                super(null);
                this.title = string2;
                this.info = string3;
            }

            @Override
            @NotNull
            public String getTitle() {
                return this.title;
            }

            @Override
            @Nullable
            public String getInfo() {
                return this.info;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem$Invite;", "Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem;", "()V", "sdk_originalVoximplantRelease"})
        public static final class Invite
        extends WatchPartyItem {
            public static final Invite INSTANCE = new Invite();

            private Invite() {
                super(null);
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem$ShowMore;", "Lio/streamlayer/sdk/calls/recent/WatchPartiesAdapter$WatchPartyItem;", "()V", "sdk_originalVoximplantRelease"})
        public static final class ShowMore
        extends WatchPartyItem {
            public static final ShowMore INSTANCE = new ShowMore();

            private ShowMore() {
                super(null);
            }
        }
    }
}

