/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.deeplink;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import androidx.appcompat.app.AppCompatActivity;
import io.streamlayer.sdk.base.StreamLayerBaseFragment;
import io.streamlayer.sdk.model.deeplink.Payload;
import io.streamlayer.utils.NavigationUtils;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0004J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/streamlayer/sdk/deeplink/StreamLayerDeeplinkHandler;", "", "()V", "DEEP_LINK_NAV_GRAPH_DATA", "", "DEEP_LINK_PAYLOAD_DATA", "HTTPS", "INVITE_PATH", "INVITE_REF_CODE", "UNIVERSAL_LINK_HOST", "buildDeepLinkIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "destinationUri", "Landroid/net/Uri;", "payload", "Lio/streamlayer/sdk/model/deeplink/Payload;", "buildDeepLinkIntent$sdk_originalVoximplantRelease", "findHostFragment", "Lio/streamlayer/sdk/base/StreamLayerBaseFragment;", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "getDeepLinkPayloadData", "intent", "getDeepLinkUri", "handleDeepLinkIntent", "", "sdkId", "isUniversalLink", "uri", "skdId", "sdk_originalVoximplantRelease"})
public final class StreamLayerDeeplinkHandler {
    private static final String DEEP_LINK_NAV_GRAPH_DATA = "deep_link_graph_data";
    private static final String DEEP_LINK_PAYLOAD_DATA = "deep_link_payload_data";
    private static final String HTTPS = "https";
    private static final String UNIVERSAL_LINK_HOST = "deeplink.streamlayer.io";
    private static final String INVITE_PATH = "/invite";
    private static final String INVITE_REF_CODE = "refCode";
    public static final StreamLayerDeeplinkHandler INSTANCE = new StreamLayerDeeplinkHandler();

    private final StreamLayerBaseFragment findHostFragment(AppCompatActivity appCompatActivity) {
        return (StreamLayerBaseFragment)appCompatActivity.getSupportFragmentManager().findFragmentByTag("StreamLayerFragment");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Uri getDeepLinkUri(Intent object) {
        StreamLayerDeeplinkHandler streamLayerDeeplinkHandler = (Uri)object.getParcelableExtra(DEEP_LINK_NAV_GRAPH_DATA);
        if (streamLayerDeeplinkHandler != null) return streamLayerDeeplinkHandler;
        streamLayerDeeplinkHandler = object.getData();
        if (streamLayerDeeplinkHandler == null) return null;
        StreamLayerDeeplinkHandler streamLayerDeeplinkHandler2 = streamLayerDeeplinkHandler;
        Intrinsics.checkExpressionValueIsNotNull((Object)streamLayerDeeplinkHandler2, (String)"it");
        String string = streamLayerDeeplinkHandler2.getPath();
        if (string == null) return null;
        if (!StringsKt.startsWith$default((String)string, (String)INVITE_PATH, (boolean)false, (int)2, null)) return null;
        return NavigationUtils.INSTANCE.buildInvitesDeepLink(streamLayerDeeplinkHandler.getQueryParameter(INVITE_REF_CODE));
    }

    private final Payload getDeepLinkPayloadData(Intent intent) {
        return (Payload)intent.getSerializableExtra(DEEP_LINK_PAYLOAD_DATA);
    }

    private final boolean isUniversalLink(Uri uri, String string) {
        return Intrinsics.areEqual((Object)uri.getScheme(), (Object)HTTPS) && Intrinsics.areEqual((Object)uri.getHost(), (Object)(string + ".deeplink.streamlayer.io"));
    }

    private StreamLayerDeeplinkHandler() {
    }

    public static final /* synthetic */ StreamLayerBaseFragment access$findHostFragment(StreamLayerDeeplinkHandler streamLayerDeeplinkHandler, AppCompatActivity appCompatActivity) {
        return streamLayerDeeplinkHandler.findHostFragment(appCompatActivity);
    }

    public static final /* synthetic */ Uri access$getDeepLinkUri(StreamLayerDeeplinkHandler streamLayerDeeplinkHandler, Intent intent) {
        return streamLayerDeeplinkHandler.getDeepLinkUri(intent);
    }

    public static final /* synthetic */ Payload access$getDeepLinkPayloadData(StreamLayerDeeplinkHandler streamLayerDeeplinkHandler, Intent intent) {
        return streamLayerDeeplinkHandler.getDeepLinkPayloadData(intent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean handleDeepLinkIntent(@NotNull Intent intent, @NotNull AppCompatActivity appCompatActivity, @NotNull String string) {
        boolean bl;
        Function0<Boolean> function0;
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        Intrinsics.checkParameterIsNotNull((Object)appCompatActivity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"sdkId");
        Function0<Boolean> function02 = function0;
        function0 = new Function0<Boolean>(appCompatActivity, intent){
            final /* synthetic */ AppCompatActivity $activity;
            final /* synthetic */ Intent $intent;
            {
                this.$activity = appCompatActivity;
                this.$intent = intent;
                super(0);
            }

            public final boolean invoke() {
                StreamLayerBaseFragment streamLayerBaseFragment = StreamLayerDeeplinkHandler.access$findHostFragment(StreamLayerDeeplinkHandler.INSTANCE, this.$activity);
                if (streamLayerBaseFragment != null) {
                    streamLayerBaseFragment.processDeeplink$sdk_originalVoximplantRelease(StreamLayerDeeplinkHandler.access$getDeepLinkUri(StreamLayerDeeplinkHandler.INSTANCE, this.$intent), StreamLayerDeeplinkHandler.access$getDeepLinkPayloadData(StreamLayerDeeplinkHandler.INSTANCE, this.$intent));
                    this.$intent.setData(null);
                    return true;
                }
                throw new IllegalStateException("StreamLayerFragment or StreamLayerLiteFragment are not found! Please add android:tag=\"StreamLayerFragment\" to your FragmentContainerView");
            }
        };
        appCompatActivity = intent.getData();
        if (Intrinsics.areEqual((Object)(appCompatActivity != null ? appCompatActivity.getScheme() : null), (Object)"streamlayer")) {
            bl = (Boolean)function02.invoke();
            return bl;
        } else {
            if (intent.getData() == null) return false;
            if ((intent = intent.getData()) == null) {
                Intrinsics.throwNpe();
            }
            Intent intent2 = intent;
            Intrinsics.checkExpressionValueIsNotNull((Object)intent2, (String)"intent.data!!");
            if (!this.isUniversalLink((Uri)intent2, string)) return false;
            bl = (Boolean)function02.invoke();
        }
        return bl;
    }

    @NotNull
    public final Intent buildDeepLinkIntent$sdk_originalVoximplantRelease(@NotNull Context context, @Nullable Uri uri, @Nullable Payload payload) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("streamlayer://" + context.getPackageName())));
        intent.putExtra(DEEP_LINK_NAV_GRAPH_DATA, (Parcelable)uri);
        intent.putExtra(DEEP_LINK_PAYLOAD_DATA, (Serializable)payload);
        return intent;
    }
}

