/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.voximplant;

import com.voximplant.sdk.call.CallSettings;
import com.voximplant.sdk.call.ICall;
import com.voximplant.sdk.call.ICallListener;
import com.voximplant.sdk.call.VideoFlags;
import com.voximplant.sdk.client.IClient;
import io.streamlayer.common.client.CallClientWrapper;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/streamlayer/common/data/voximplant/VoximplantCallManager;", "", "clientWrapper", "Lio/streamlayer/common/client/CallClientWrapper;", "(Lio/streamlayer/common/client/CallClientWrapper;)V", "client", "Lcom/voximplant/sdk/client/IClient;", "mCalls", "Ljava/util/HashMap;", "", "Lcom/voximplant/sdk/call/ICall;", "createCall", "topicId", "isVideoEnabled", "", "listener", "Lcom/voximplant/sdk/call/ICallListener;", "endCall", "", "sdk_originalVoximplantRelease"})
public final class VoximplantCallManager {
    private final IClient client;
    private final HashMap<String, ICall> mCalls;

    @Inject
    public VoximplantCallManager(@NotNull CallClientWrapper callClientWrapper) {
        VoximplantCallManager voximplantCallManager = this;
        Intrinsics.checkParameterIsNotNull((Object)callClientWrapper, (String)"clientWrapper");
        voximplantCallManager.client = callClientWrapper.getVoximplantClient();
        voximplantCallManager.mCalls = new HashMap();
    }

    public final void endCall(@NotNull String string2, @Nullable ICallListener iCallListener) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        ICall iCall = this.mCalls.get(string2);
        if (iCall != null) {
            if (iCallListener != null) {
                iCall.removeCallListener(iCallListener);
            }
            iCall.hangup(null);
        }
        this.mCalls.remove(string2);
    }

    @Nullable
    public final ICall createCall(@NotNull String string2, boolean bl, @Nullable ICallListener iCallListener) {
        CallSettings callSettings;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        String cfr_ignored_0 = "create call: topicId" + string2 + " isVideoEnabled=" + bl;
        CallSettings callSettings2 = callSettings;
        new CallSettings().videoFlags = new VideoFlags(true, bl);
        ICall iCall = this.client.callConference("conf_" + string2, callSettings2);
        if (iCall != null) {
            ICall iCall2 = iCall;
            String cfr_ignored_1 = "call created: " + iCall;
            this.mCalls.put(string2, iCall);
            iCall2.addCallListener(iCallListener);
            iCall2.start();
            return iCall2;
        }
        return null;
    }
}

