/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.notifications;

import android.net.Uri;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationKt$WhenMappings;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.utils.GsonUtil;
import io.streamlayer.utils.NavigationUtils;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"deepLink", "Landroid/net/Uri;", "Lio/streamlayer/sdk/model/notifications/Notification;", "isCallType", "", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "sdk_originalVoximplantRelease"})
public final class NotificationKt {
    public static final boolean isCallType(@NotNull NotificationType notificationType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)notificationType), (String)"$this$isCallType");
        return ArraysKt.contains((Object[])new NotificationType[]{NotificationType.WatchParty}, (Object)((Object)notificationType));
    }

    @Nullable
    public static final Uri deepLink(@NotNull Notification object) {
        Uri uri;
        Notification notification = object;
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"$this$deepLink");
        switch (NotificationKt$WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()]) {
            default: {
                uri = null;
                break;
            }
            case 4: {
                uri = NavigationUtils.INSTANCE.buildTweetDeepLink(((Notification)object).getSourceUniqueId());
                break;
            }
            case 3: {
                uri = NavigationUtils.INSTANCE.buildVoiceCallsDeepLink();
                break;
            }
            case 2: {
                object = (ChatMessage)GsonUtil.INSTANCE.getDefaultGson().fromJson(((Notification)object).getDataJson(), ChatMessage.class);
                NavigationUtils navigationUtils = NavigationUtils.INSTANCE;
                object = object != null ? ((ChatMessage)object).getTopicId() : null;
                uri = navigationUtils.buildChatMessageDeepLink((String)object);
                break;
            }
            case 1: {
                uri = NavigationUtils.INSTANCE.buildChatMessageDeepLink(NotificationUtilKt.fromWaveSourceId(((Notification)object).getSourceUniqueId()));
            }
        }
        return uri;
    }
}

