/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.voximplant;

import com.voximplant.sdk.client.AuthParams;
import com.voximplant.sdk.client.ClientState;
import com.voximplant.sdk.client.IClient;
import com.voximplant.sdk.client.IClientLoginListener;
import com.voximplant.sdk.client.IClientSessionListener;
import com.voximplant.sdk.client.LoginError;
import io.streamlayer.common.data.voximplant.AuthError;
import io.streamlayer.common.data.voximplant.CallClientWrapper;
import io.streamlayer.common.data.voximplant.VoximplantClientManagerKt;
import io.streamlayer.common.session.CallAuthDetails;
import io.streamlayer.common.session.SessionPrefImpl;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bJ\b\u0010\u0018\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0002J\u0006\u0010\u001a\u001a\u00020\u0010J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u0012\u0010\u001d\u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u000bH\u0016J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0016J \u0010*\u001a\u00020\u00102\u0018\b\u0002\u0010+\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000eJ\b\u0010,\u001a\u00020\u0010H\u0002J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/streamlayer/common/data/voximplant/VoximplantClientManager;", "Lcom/voximplant/sdk/client/IClientSessionListener;", "Lcom/voximplant/sdk/client/IClientLoginListener;", "clientWrapper", "Lio/streamlayer/common/data/voximplant/CallClientWrapper;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "(Lio/streamlayer/common/data/voximplant/CallClientWrapper;Lio/streamlayer/common/session/SessionPrefImpl;)V", "client", "Lcom/voximplant/sdk/client/IClient;", "mPassword", "", "mUsername", "reconnectCompletion", "Lkotlin/Function1;", "Lio/streamlayer/common/data/voximplant/AuthError;", "", "isTokenExpired", "", "lifeTime", "", "login", "voximplantUserId", "password", "loginTokensExist", "loginWithToken", "logout", "onConnectionClosed", "onConnectionEstablished", "onConnectionFailed", "p0", "onLoginFailed", "reason", "Lcom/voximplant/sdk/client/LoginError;", "onLoginSuccessful", "displayName", "authParams", "Lcom/voximplant/sdk/client/AuthParams;", "onOneTimeKeyGenerated", "key", "onRefreshTokenFailed", "onRefreshTokenSuccess", "reconnectIfNeeded", "callback", "safeConnect", "saveAuthDetailsToSharedPreferences", "sdk_originalRelease"})
public final class VoximplantClientManager
implements IClientSessionListener,
IClientLoginListener {
    private final IClient client;
    private String mUsername;
    private String mPassword;
    private Function1<? super AuthError, Unit> reconnectCompletion;
    private final CallClientWrapper clientWrapper;
    private final SessionPrefImpl session;

    public static /* synthetic */ void reconnectIfNeeded$default(VoximplantClientManager voximplantClientManager, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        voximplantClientManager.reconnectIfNeeded((Function1<? super AuthError, Unit>)function1);
    }

    private final void safeConnect() {
        if (this.client.getClientState() == ClientState.DISCONNECTED) {
            try {
                this.client.connect();
            }
            catch (IllegalStateException illegalStateException) {
                String cfr_ignored_0 = "login: exception on connect: " + illegalStateException;
            }
        }
    }

    private final void loginWithToken() {
        VoximplantClientManager voximplantClientManager = object;
        voximplantClientManager.safeConnect();
        if (voximplantClientManager.client.getClientState() == ClientState.CONNECTED && ((VoximplantClientManager)object).loginTokensExist()) {
            Object object;
            VoximplantClientManager voximplantClientManager2 = object;
            voximplantClientManager2.mUsername = voximplantClientManager2.session.getTinodeUserId();
            CallAuthDetails callAuthDetails = voximplantClientManager2.session.getCallAuthDetails();
            if (!voximplantClientManager2.isTokenExpired(callAuthDetails.getAccessExpired())) {
                object = ((VoximplantClientManager)object).mUsername;
                ((VoximplantClientManager)object).client.loginWithAccessToken((String)object, callAuthDetails.getAccessToken());
            } else if (!((VoximplantClientManager)object).isTokenExpired(callAuthDetails.getRefreshExpired())) {
                object = ((VoximplantClientManager)object).mUsername;
                ((VoximplantClientManager)object).client.refreshToken((String)object, callAuthDetails.getRefreshToken());
            }
        }
    }

    private final void saveAuthDetailsToSharedPreferences(AuthParams authParams) {
        this.session.setCallAuthDetails(VoximplantClientManagerKt.toDomain(authParams));
    }

    private final boolean isTokenExpired(long l) {
        return System.currentTimeMillis() - this.session.getCallAuthDetails().getRefreshExpired() > l * (long)1000;
    }

    private final boolean loginTokensExist() {
        CallAuthDetails callAuthDetails = ((VoximplantClientManager)((Object)callAuthDetails)).session.getCallAuthDetails();
        return callAuthDetails.getAccessToken() != null && callAuthDetails.getRefreshToken() != null;
    }

    @Inject
    public VoximplantClientManager(@NotNull CallClientWrapper callClientWrapper, @NotNull SessionPrefImpl sessionPrefImpl) {
        Intrinsics.checkParameterIsNotNull((Object)callClientWrapper, (String)"clientWrapper");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        this.clientWrapper = callClientWrapper;
        this.session = sessionPrefImpl;
        callClientWrapper = callClientWrapper.getVoximplantClient();
        this.client = callClientWrapper;
        callClientWrapper.setClientLoginListener(this);
        this.client.setClientSessionListener((IClientSessionListener)this);
    }

    public final void login(@NotNull String string2, @NotNull String string3) {
        VoximplantClientManager voximplantClientManager = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"voximplantUserId");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"password");
        this.mUsername = string2;
        voximplantClientManager.mPassword = string3;
        voximplantClientManager.safeConnect();
        if (voximplantClientManager.client.getClientState() == ClientState.CONNECTED) {
            this.client.login(string2, string3);
        }
    }

    public final void logout() {
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            this.client.disconnect();
        }
    }

    public final void reconnectIfNeeded(@Nullable Function1<? super AuthError, Unit> function1) {
        if (this.client.getClientState() == ClientState.DISCONNECTED && this.loginTokensExist()) {
            this.reconnectCompletion = function1;
            this.safeConnect();
        } else if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke(null);
        }
    }

    public void onConnectionEstablished() {
        String string2;
        String string3 = this.mUsername;
        if (string3 != null && (string2 = this.mPassword) != null) {
            this.client.login(string3, string2);
        } else {
            this.loginWithToken();
        }
    }

    public void onConnectionFailed(@Nullable String function1) {
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onConnectionClosed() {
        this.mPassword = null;
    }

    public void onLoginSuccessful(@NotNull String function1, @NotNull AuthParams authParams) {
        VoximplantClientManager voximplantClientManager = this;
        AuthParams authParams2 = authParams;
        Intrinsics.checkParameterIsNotNull((Object)function1, (String)"displayName");
        Intrinsics.checkParameterIsNotNull((Object)authParams2, (String)"authParams");
        String cfr_ignored_0 = "Login success: " + (String)function1;
        voximplantClientManager.saveAuthDetailsToSharedPreferences(authParams2);
        function1 = voximplantClientManager.reconnectCompletion;
        if (function1 != null) {
            Unit cfr_ignored_1 = (Unit)function1.invoke(null);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginFailed(@NotNull LoginError object) {
        LoginError loginError = object;
        Intrinsics.checkParameterIsNotNull((Object)loginError, (String)"reason");
        object = VoximplantClientManagerKt.access$makeAuthError(loginError);
        String cfr_ignored_0 = "Login failed: " + ((AuthError)((Object)object)).getDescription();
        Function1<? super AuthError, Unit> function1 = this.reconnectCompletion;
        if (function1 != null) {
            Unit cfr_ignored_1 = (Unit)function1.invoke(object);
        }
        this.reconnectCompletion = null;
    }

    public void onOneTimeKeyGenerated(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"key");
    }

    public void onRefreshTokenFailed(@NotNull LoginError loginError) {
        LoginError loginError2 = loginError;
        Intrinsics.checkParameterIsNotNull((Object)loginError2, (String)"reason");
        String cfr_ignored_0 = "Refresh token failed: " + VoximplantClientManagerKt.access$makeAuthError(loginError2).getDescription();
    }

    public void onRefreshTokenSuccess(@NotNull AuthParams authParams) {
        VoximplantClientManager voximplantClientManager = this;
        Intrinsics.checkParameterIsNotNull((Object)authParams, (String)"authParams");
        voximplantClientManager.saveAuthDetailsToSharedPreferences(authParams);
        voximplantClientManager.loginWithToken();
    }
}

