/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.notifications;

import io.reactivex.Completable;
import io.reactivex.Observable;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.repository.RxRepoExtKt;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import io.streamlayer.sdk.repository.notifications.NotificationRepoImpl;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002J\u001a\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000f0\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0016\u0010\u0016\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/streamlayer/sdk/repository/notifications/NotificationRepoImpl;", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "(Lio/streamlayer/common/data/database/AppDatabase;)V", "deleteAllNotifications", "", "deleteNotification", "Lio/reactivex/Completable;", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "notificationId", "", "deleteNotifications", "items", "", "getNotifications", "Lio/reactivex/Observable;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "saveNotification", "item", "saveNotificationGetId", "saveNotifications", "upsertNotificationBySourceId", "sdk_originalRelease"})
public final class NotificationRepoImpl
implements NotificationRepo {
    private final AppDatabase database;

    private final void saveNotifications(List<Notification> list) {
        this.database.notificationDao().saveNotifications(list);
    }

    private final void deleteNotifications(List<Notification> list) {
        this.database.notificationDao().deleteNotifications(list);
    }

    @Inject
    public NotificationRepoImpl(@NotNull AppDatabase appDatabase) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"database");
        this.database = appDatabase;
    }

    public static final /* synthetic */ AppDatabase access$getDatabase$p(NotificationRepoImpl notificationRepoImpl) {
        return notificationRepoImpl.database;
    }

    public static final /* synthetic */ void access$saveNotifications(NotificationRepoImpl notificationRepoImpl, List list) {
        notificationRepoImpl.saveNotifications(list);
    }

    @Override
    @NotNull
    public Observable<ResourceState<List<Notification>>> getNotifications() {
        return RxRepoExtKt.twoSideCall(new Function0<Observable<List<? extends Notification>>>(this){
            final /* synthetic */ NotificationRepoImpl this$0;
            {
                this.this$0 = notificationRepoImpl;
                super(0);
            }

            @NotNull
            public final Observable<List<Notification>> invoke() {
                return NotificationRepoImpl.access$getDatabase$p(this.this$0).notificationDao().getNotifications();
            }
        }, getNotifications.2.INSTANCE, new Function1<List<? extends Notification>, Unit>(this){
            final /* synthetic */ NotificationRepoImpl this$0;
            {
                this.this$0 = notificationRepoImpl;
                super(1);
            }

            public final void invoke(@NotNull List<Notification> list) {
                Intrinsics.checkParameterIsNotNull(list, (String)"it");
                NotificationRepoImpl.access$saveNotifications(this.this$0, list);
            }
        });
    }

    @Override
    @NotNull
    public Completable deleteNotification(long l) {
        return this.database.notificationDao().deleteNotification(l);
    }

    @Override
    @NotNull
    public Completable deleteNotification(@NotNull Notification notification) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        return this.database.notificationDao().deleteNotification(notification);
    }

    @Override
    public void deleteAllNotifications() {
        this.database.notificationDao().deleteAllNotifications();
    }

    @Override
    public void saveNotification(@NotNull Notification notification) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"item");
        this.database.notificationDao().saveNotifications(CollectionsKt.listOf((Object)notification));
    }

    @Override
    public long saveNotificationGetId(@NotNull Notification notification) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"item");
        return this.database.notificationDao().saveNotification(notification);
    }

    @Override
    public void upsertNotificationBySourceId(@NotNull Notification notification) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"item");
        Notification notification2 = this.database.notificationDao().getNotification(notification.getSourceUniqueId());
        if (notification2 != null) {
            notification.setId(notification2.getId());
            this.database.notificationDao().updateNotifications(CollectionsKt.listOf((Object)notification));
        } else {
            this.database.notificationDao().saveNotification(notification);
        }
    }
}

