/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.content.ContextCompat;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.common.views.SLDottedLinearProgress;
import io.streamlayer.sdk.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0014J\b\u0010$\u001a\u00020\u001aH\u0002J\u0018\u0010%\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0006\u0010'\u001a\u00020\u001aJ\u0006\u0010(\u001a\u00020\u001aR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\r\u00a8\u0006)"}, d2={"Lio/streamlayer/common/views/SLDottedLinearProgress;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "", "dotSize", "getDotSize", "()F", "setDotSize", "(F)V", "dotsNumber", "innerMargin", "paint", "Landroid/graphics/Paint;", "runnable", "Ljava/lang/Runnable;", "selectedDot", "stepDots", "getStepDots", "drawDots", "", "canvas", "Landroid/graphics/Canvas;", "measureDimension", "desiredSize", "measureSpec", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "redrawDots", "setPaintAlpha", "dotNumber", "show", "stop", "sdk_originalRelease"})
public final class SLDottedLinearProgress
extends View {
    private final Paint paint;
    private float dotSize;
    private float innerMargin;
    private final float stepDots;
    private final int dotsNumber;
    private int selectedDot;
    private final Runnable runnable;
    private HashMap _$_findViewCache;

    private final void redrawDots() {
        SLDottedLinearProgress sLDottedLinearProgress = this;
        sLDottedLinearProgress.postDelayed(sLDottedLinearProgress.runnable, 380L);
    }

    private final int measureDimension(int n, int n2) {
        int n3 = View.MeasureSpec.getMode((int)n2);
        n2 = View.MeasureSpec.getSize((int)n2);
        if (n3 != 0x40000000) {
            n2 = n3 == Integer.MIN_VALUE ? RangesKt.coerceAtMost((int)n, (int)n2) : n;
        }
        return n2;
    }

    private final void drawDots(Canvas canvas) {
        int n;
        SLDottedLinearProgress sLDottedLinearProgress = this;
        float f = (float)sLDottedLinearProgress.getWidth() / 2.0f;
        float f2 = (float)sLDottedLinearProgress.getHeight() / 2.0f;
        float f3 = sLDottedLinearProgress.innerMargin;
        int n2 = sLDottedLinearProgress.dotsNumber;
        for (int j = 0; j < n2; ++j) {
            float f4 = f3;
            SLDottedLinearProgress sLDottedLinearProgress2 = this;
            float f5 = f3;
            SLDottedLinearProgress sLDottedLinearProgress3 = this;
            SLDottedLinearProgress sLDottedLinearProgress4 = this;
            sLDottedLinearProgress4.setPaintAlpha(sLDottedLinearProgress4.selectedDot, j);
            float f6 = sLDottedLinearProgress3.dotSize;
            Paint paint = sLDottedLinearProgress3.paint;
            canvas.drawCircle(f3 += f, f2, f6, paint);
            f3 = f - f5;
            f6 = sLDottedLinearProgress2.dotSize;
            paint = sLDottedLinearProgress2.paint;
            canvas.drawCircle(f3, f2, f6, paint);
            f3 = f4 + this.stepDots;
        }
        this.selectedDot = n = this.selectedDot + 1;
        if (n > this.dotsNumber) {
            this.selectedDot = 0;
        }
    }

    private final void setPaintAlpha(int n, int n2) {
        if (n == n2) {
            this.paint.setAlpha(255);
        } else if (Math.abs(n -= n2) == 1) {
            this.paint.setAlpha(150);
        } else if (Math.abs(n) == 2) {
            this.paint.setAlpha(110);
        } else if (Math.abs(n) == 3) {
            this.paint.setAlpha(100);
        } else if (Math.abs(n) > 4) {
            this.paint.setAlpha(90);
        }
    }

    @JvmOverloads
    public SLDottedLinearProgress(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        SLDottedLinearProgress sLDottedLinearProgress = this;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attributeSet, n);
        this.paint = new Paint();
        this.dotSize = 10.0f;
        this.innerMargin = 55.0f;
        this.stepDots = 55.0f;
        this.dotsNumber = 4;
        this.runnable = new Runnable(this){
            final /* synthetic */ SLDottedLinearProgress this$0;
            {
                this.this$0 = sLDottedLinearProgress;
            }

            public final void run() {
                runnable.1 v0 = this;
                v0.this$0.invalidate();
                SLDottedLinearProgress.access$redrawDots(v0.this$0);
            }
        };
        Intrinsics.checkExpressionValueIsNotNull((Object)R.styleable.SLDottedLinearProgress, (String)"R.styleable.SLDottedLinearProgress");
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SLDottedLinearProgress, 0, 0);
        this.innerMargin = typedArray.getDimensionPixelSize(R.styleable.SLDottedLinearProgress_slrInnerMargin, 55);
        typedArray.recycle();
        sLDottedLinearProgress.paint.setFlags(1);
        sLDottedLinearProgress.paint.setStyle(Paint.Style.FILL);
        Context context2 = context;
        sLDottedLinearProgress.paint.setColor(ContextCompat.getColor((Context)context2, (int)ExtensionsKt.resoleAttributeResId(context2, R.attr.slrOverlayDotLoaderColor, R.color.slr_white)));
    }

    public /* synthetic */ SLDottedLinearProgress(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public SLDottedLinearProgress(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public SLDottedLinearProgress(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$redrawDots(SLDottedLinearProgress sLDottedLinearProgress) {
        sLDottedLinearProgress.redrawDots();
    }

    public final float getDotSize() {
        return this.dotSize;
    }

    public final void setDotSize(float f) {
        this.dotSize = f;
        this.invalidate();
    }

    public final float getStepDots() {
        return this.stepDots;
    }

    public final void show() {
        SLDottedLinearProgress sLDottedLinearProgress = this;
        ExtensionsKt.visible(sLDottedLinearProgress);
        sLDottedLinearProgress.redrawDots();
    }

    public final void stop() {
        SLDottedLinearProgress sLDottedLinearProgress = this;
        sLDottedLinearProgress.removeCallbacks(sLDottedLinearProgress.runnable);
        ExtensionsKt.gone(sLDottedLinearProgress);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        SLDottedLinearProgress sLDottedLinearProgress = this;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        sLDottedLinearProgress.drawDots(canvas);
    }

    protected void onMeasure(int n, int n2) {
        SLDottedLinearProgress sLDottedLinearProgress = this;
        int n3 = this.getSuggestedMinimumHeight() + this.getPaddingTop() + this.getPaddingBottom();
        n = sLDottedLinearProgress.measureDimension(sLDottedLinearProgress.getSuggestedMinimumWidth() + this.getPaddingLeft() + this.getPaddingRight(), n);
        sLDottedLinearProgress.setMeasuredDimension(n, sLDottedLinearProgress.measureDimension(n3, n2));
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            View view2;
            view = view2;
            view2 = new HashMap();
            this._$_findViewCache = view;
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            SLDottedLinearProgress sLDottedLinearProgress = this;
            view = sLDottedLinearProgress.findViewById(n);
            sLDottedLinearProgress._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        HashMap hashMap = ((SLDottedLinearProgress)((Object)hashMap))._$_findViewCache;
        if (hashMap != null) {
            hashMap.clear();
        }
    }
}

