/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.profile;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatSpinner;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentViewModelLazyKt;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.fragment.FragmentKt;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.request.RequestOptions;
import com.google.android.material.card.MaterialCardView;
import io.streamlayer.common.mvvm.BaseFragment;
import io.streamlayer.common.mvvm.ResourceStateObserver;
import io.streamlayer.common.mvvm.basemodels.BaseError;
import io.streamlayer.common.mvvm.basemodels.ResponseCodes;
import io.streamlayer.common.views.SLROptionButton;
import io.streamlayer.sdk.MainNavGraphDirections;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.StreamLayerConfig;
import io.streamlayer.sdk.auth.AuthType;
import io.streamlayer.sdk.auth.AuthViewModel;
import io.streamlayer.sdk.model.auth.User;
import io.streamlayer.sdk.model.sdksettings.VisibleStatus;
import io.streamlayer.sdk.profile.ProfileFragment;
import io.streamlayer.sdk.profile.ProfileFragment$WhenMappings;
import io.streamlayer.sdk.profile.ProfileFragmentDirections;
import io.streamlayer.sdk.profile.SettingsViewModel;
import io.streamlayer.utils.AcronymDrawable;
import io.streamlayer.utils.ExtensionsKt;
import io.streamlayer.utils.NavigationUtils;
import java.util.HashMap;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J&\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001a\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0002J\b\u0010\u001f\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lio/streamlayer/sdk/profile/ProfileFragment;", "Lio/streamlayer/common/mvvm/BaseFragment;", "()V", "PROD", "", "STAGE", "profileViewModel", "Lio/streamlayer/sdk/auth/AuthViewModel;", "getProfileViewModel", "()Lio/streamlayer/sdk/auth/AuthViewModel;", "profileViewModel$delegate", "Lkotlin/Lazy;", "settingsViewModel", "Lio/streamlayer/sdk/profile/SettingsViewModel;", "getSettingsViewModel", "()Lio/streamlayer/sdk/profile/SettingsViewModel;", "settingsViewModel$delegate", "bind", "", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onViewCreated", "view", "preNavigate", "setupUI", "sdk_originalRelease"})
public final class ProfileFragment
extends BaseFragment {
    private final Lazy profileViewModel$delegate;
    private final Lazy settingsViewModel$delegate;
    private final String PROD;
    private final String STAGE;
    private HashMap _$_findViewCache;

    private final AuthViewModel getProfileViewModel() {
        return (AuthViewModel)((Object)this.profileViewModel$delegate.getValue());
    }

    private final SettingsViewModel getSettingsViewModel() {
        return (SettingsViewModel)((Object)this.settingsViewModel$delegate.getValue());
    }

    private final void preNavigate() {
        if (!this.getSession().isLoggedIn()) {
            FragmentKt.findNavController((Fragment)this).navigate(MainNavGraphDirections.Companion.actionAuthStart(AuthType.Profile.INSTANCE), NavigationUtils.INSTANCE.fadeNavOptionsBuilder().build());
        }
    }

    private final void setupUI() {
        ProfileFragment profileFragment = this;
        ExtensionsKt.setupToolbarWithNavController$default(profileFragment, 0, R.drawable.slr_ic_profile, null, 0, 0, 0, false, 125, null);
        ((MaterialCardView)profileFragment._$_findCachedViewById(R.id.slProfile)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ ProfileFragment this$0;
            {
                this.this$0 = profileFragment;
            }

            public final void onClick(View view) {
                FragmentKt.findNavController((Fragment)this.this$0).navigate(ProfileFragmentDirections.Companion.actionFragmentProfileToFragmentProfileEdit());
            }
        });
        ((SLROptionButton)profileFragment._$_findCachedViewById(R.id.slAlertsAction)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ ProfileFragment this$0;
            {
                this.this$0 = profileFragment;
            }

            public final void onClick(View view) {
                FragmentKt.findNavController((Fragment)this.this$0).navigate(ProfileFragmentDirections.Companion.actionFragmentProfileToProfileAlertsFragment());
            }
        });
        ((SLROptionButton)profileFragment._$_findCachedViewById(R.id.slStatusAction)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ ProfileFragment this$0;
            {
                this.this$0 = profileFragment;
            }

            public final void onClick(View view) {
                FragmentKt.findNavController((Fragment)this.this$0).navigate(ProfileFragmentDirections.Companion.actionFragmentProfileToFragmentProfileStatus());
            }
        });
        ((SLROptionButton)profileFragment._$_findCachedViewById(R.id.slSoundsAction)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ ProfileFragment this$0;
            {
                this.this$0 = profileFragment;
            }

            public final void onClick(View view) {
                FragmentKt.findNavController((Fragment)this.this$0).navigate(ProfileFragmentDirections.Companion.actionFragmentProfileToProfileSoundsFragment());
            }
        });
        if (Intrinsics.areEqual((Object)"original", (Object)"staging")) {
            ArrayAdapter arrayAdapter;
            Ref.ObjectRef objectRef;
            ProfileFragment profileFragment2 = this;
            ConstraintLayout constraintLayout = (ConstraintLayout)profileFragment2._$_findCachedViewById(R.id.choiceEnvironmentContainer);
            Intrinsics.checkExpressionValueIsNotNull((Object)constraintLayout, (String)"choiceEnvironmentContainer");
            constraintLayout.setVisibility(0);
            Ref.ObjectRef objectRef2 = objectRef;
            new Ref.ObjectRef().element = null;
            List list = CollectionsKt.listOf((Object[])new String[]{this.PROD, this.STAGE});
            ArrayAdapter arrayAdapter2 = arrayAdapter;
            new ArrayAdapter((Context)this.requireActivity(), 17367048, list).setDropDownViewResource(R.layout.spinner_dropdown_layout);
            AppCompatSpinner appCompatSpinner = (AppCompatSpinner)profileFragment2._$_findCachedViewById(R.id.environmentSpinner);
            Intrinsics.checkExpressionValueIsNotNull((Object)appCompatSpinner, (String)"environmentSpinner");
            appCompatSpinner.setAdapter((SpinnerAdapter)arrayAdapter2);
            Context context = this.requireContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"requireContext()");
            int n = StreamLayerConfig.INSTANCE.getCurrentEnvironmentPosition(context);
            ((AppCompatSpinner)profileFragment2._$_findCachedViewById(R.id.environmentSpinner)).setSelection(n);
            AppCompatSpinner appCompatSpinner2 = (AppCompatSpinner)profileFragment2._$_findCachedViewById(R.id.environmentSpinner);
            Intrinsics.checkExpressionValueIsNotNull((Object)appCompatSpinner2, (String)"environmentSpinner");
            appCompatSpinner2.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(this, objectRef2, list){
                final /* synthetic */ ProfileFragment this$0;
                final /* synthetic */ Ref.ObjectRef $type;
                final /* synthetic */ List $list;
                {
                    this.this$0 = profileFragment;
                    this.$type = objectRef;
                    this.$list = list;
                }

                public void onNothingSelected(@Nullable AdapterView<?> adapterView) {
                }

                public void onItemSelected(@Nullable AdapterView<?> objectRef, @Nullable View object, int n, long l) {
                    setupUI.5 v0 = object2;
                    objectRef = v0.$type;
                    object = (String)v0.$list.get(n);
                    Object object2 = Intrinsics.areEqual((Object)object, (Object)ProfileFragment.access$getPROD$p(object2.this$0)) ? StreamLayerConfig.EnvironmentType.PRODUCTION : (Intrinsics.areEqual((Object)object, (Object)ProfileFragment.access$getSTAGE$p(object2.this$0)) ? StreamLayerConfig.EnvironmentType.STAGING : StreamLayerConfig.EnvironmentType.PRODUCTION);
                    objectRef.element = object2;
                }
            });
            ((Button)profileFragment2._$_findCachedViewById(R.id.startButton)).setOnClickListener(new View.OnClickListener(this, objectRef2){
                final /* synthetic */ ProfileFragment this$0;
                final /* synthetic */ Ref.ObjectRef $type;
                {
                    this.this$0 = profileFragment;
                    this.$type = objectRef;
                }

                public final void onClick(View object) {
                    setupUI.6 v0 = this;
                    object = StreamLayerConfig.INSTANCE;
                    Context context = v0.this$0.requireContext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"requireContext()");
                    Object object2 = v0.$type.element;
                    if (object2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"type");
                    }
                    ((StreamLayerConfig)object).setEnvironment(context, (StreamLayerConfig.EnvironmentType)((Object)object2));
                    TextView textView = (TextView)this.this$0._$_findCachedViewById(R.id.envAlert);
                    Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"envAlert");
                    textView.setVisibility(0);
                }
            });
        }
    }

    private final void bind() {
        Function1<BaseError, Unit> function1;
        Function1<BaseError, Unit> function12;
        ProfileFragment profileFragment = this;
        Object object = function12;
        function12 = new Function1<BaseError, Unit>(this){
            final /* synthetic */ ProfileFragment this$0;
            {
                this.this$0 = profileFragment;
                super(1);
            }

            public final void invoke(@NotNull BaseError baseError) {
                BaseError baseError2 = baseError;
                Intrinsics.checkParameterIsNotNull((Object)baseError2, (String)"it");
                if (baseError2.getErrorCode() != ResponseCodes.UNAUTHORIZED.getCode()) {
                    this.this$0.showError(baseError.getErrorMessage());
                }
            }
        };
        profileFragment.getProfileViewModel().getUser().observe(this.getViewLifecycleOwner(), new ResourceStateObserver(this, (Function1)new Function1<User, Unit>(this){
            final /* synthetic */ ProfileFragment this$0;
            {
                this.this$0 = profileFragment;
                super(1);
            }

            public final void invoke(@Nullable User user) {
                if (user != null) {
                    User user2 = user;
                    bind.1 v1 = this;
                    AppCompatTextView appCompatTextView = (AppCompatTextView)v1.this$0._$_findCachedViewById(R.id.slProfileName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)appCompatTextView, (String)"slProfileName");
                    appCompatTextView.setText((CharSequence)user.getName());
                    user = Glide.with((View)((AppCompatImageView)v1.this$0._$_findCachedViewById(R.id.slProfileAvatar))).load(user.getAvatar()).apply(new RequestOptions().circleCrop());
                    String string2 = user2.getName();
                    if (string2 == null) {
                        string2 = "";
                    }
                    ((RequestBuilder)user.error(new AcronymDrawable(string2, 0.0f, false, null, null, null, null, 126, null))).into((ImageView)((AppCompatImageView)this.this$0._$_findCachedViewById(R.id.slProfileAvatar)));
                }
            }
        }, null, (Function1)object, false, 20, null));
        LiveData liveData = Transformations.distinctUntilChanged(profileFragment.getSettingsViewModel().getVisibleStatus());
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        object = function1;
        function1 = new Function1<BaseError, Unit>(this){
            final /* synthetic */ ProfileFragment this$0;
            {
                this.this$0 = profileFragment;
                super(1);
            }

            public final void invoke(@NotNull BaseError baseError) {
                BaseError baseError2 = baseError;
                Intrinsics.checkParameterIsNotNull((Object)baseError2, (String)"it");
                if (baseError2.getErrorCode() != ResponseCodes.UNAUTHORIZED.getCode()) {
                    this.this$0.showError(baseError.getErrorMessage());
                }
            }
        };
        liveData.observe(this.getViewLifecycleOwner(), new ResourceStateObserver(this, (Function1)new Function1<VisibleStatus, Unit>(this){
            final /* synthetic */ ProfileFragment this$0;
            {
                this.this$0 = profileFragment;
                super(1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void invoke(@Nullable VisibleStatus visibleStatus2) {
                if (visibleStatus2 == null) return;
                SLROptionButton sLROptionButton = (SLROptionButton)sLROptionButton.this$0._$_findCachedViewById(R.id.slStatusAction);
                int n = ProfileFragment$WhenMappings.$EnumSwitchMapping$0[visibleStatus2.ordinal()];
                if (n != 1) {
                    if (n != 2) throw new NoWhenBranchMatchedException();
                    n = R.string.slr_profile_status_incognito;
                } else {
                    n = R.string.slr_profile_status_visible;
                }
                sLROptionButton.setStatus(n);
            }
        }, null, (Function1)object, false, 20, null));
    }

    public ProfileFragment() {
        Function0<ViewModelProvider.Factory> function0;
        Function0<Fragment> function02;
        Function0<ViewModelProvider.Factory> function03;
        Function0<Fragment> function04;
        ProfileFragment profileFragment = this;
        Object object = function04;
        function04 = new Function0<Fragment>(this){
            final /* synthetic */ ProfileFragment this$0;
            {
                this.this$0 = profileFragment;
                super(0);
            }

            @NotNull
            public final Fragment invoke() {
                Fragment fragment = this.this$0.requireParentFragment();
                Intrinsics.checkExpressionValueIsNotNull((Object)fragment, (String)"requireParentFragment()");
                return fragment;
            }
        };
        Object object2 = function03;
        function03 = new Function0<ViewModelProvider.Factory>(this){
            final /* synthetic */ ProfileFragment this$0;
            {
                this.this$0 = profileFragment;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                return this.this$0.getViewModelFactory();
            }
        };
        profileFragment.profileViewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)profileFragment, (KClass)Reflection.getOrCreateKotlinClass(AuthViewModel.class), (Function0)new Function0<ViewModelStore>((Function0)object){
            final /* synthetic */ Function0 $ownerProducer;
            {
                this.$ownerProducer = function0;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = ((ViewModelStoreOwner)this.$ownerProducer.invoke()).getViewModelStore();
                Intrinsics.checkExpressionValueIsNotNull((Object)viewModelStore, (String)"ownerProducer().viewModelStore");
                return viewModelStore;
            }
        }, (Function0)object2);
        object = function02;
        function02 = new Function0<Fragment>(this){
            final /* synthetic */ ProfileFragment this$0;
            {
                this.this$0 = profileFragment;
                super(0);
            }

            @NotNull
            public final Fragment invoke() {
                Fragment fragment = this.this$0.requireParentFragment().requireParentFragment();
                Intrinsics.checkExpressionValueIsNotNull((Object)fragment, (String)"requireParentFragment().requireParentFragment()");
                return fragment;
            }
        };
        object2 = function0;
        function0 = new Function0<ViewModelProvider.Factory>(this){
            final /* synthetic */ ProfileFragment this$0;
            {
                this.this$0 = profileFragment;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                return this.this$0.getViewModelFactory();
            }
        };
        profileFragment.settingsViewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)profileFragment, (KClass)Reflection.getOrCreateKotlinClass(SettingsViewModel.class), (Function0)new Function0<ViewModelStore>((Function0)object){
            final /* synthetic */ Function0 $ownerProducer;
            {
                this.$ownerProducer = function0;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = ((ViewModelStoreOwner)this.$ownerProducer.invoke()).getViewModelStore();
                Intrinsics.checkExpressionValueIsNotNull((Object)viewModelStore, (String)"ownerProducer().viewModelStore");
                return viewModelStore;
            }
        }, (Function0)object2);
        profileFragment.PROD = "PROD";
        profileFragment.STAGE = "STAGE";
    }

    public static final /* synthetic */ String access$getPROD$p(ProfileFragment profileFragment) {
        return profileFragment.PROD;
    }

    public static final /* synthetic */ String access$getSTAGE$p(ProfileFragment profileFragment) {
        return profileFragment.STAGE;
    }

    public void onCreate(@Nullable Bundle bundle) {
        ProfileFragment profileFragment = this;
        super.onCreate(bundle);
        profileFragment.getSettingsViewModel().fetchSettings();
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        LayoutInflater layoutInflater2 = layoutInflater;
        Intrinsics.checkParameterIsNotNull((Object)layoutInflater2, (String)"inflater");
        return layoutInflater2.inflate(R.layout.slr_fragment_profile, viewGroup, false);
    }

    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle bundle) {
        ProfileFragment profileFragment = this;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super.onViewCreated(view, bundle);
        profileFragment.preNavigate();
        profileFragment.setupUI();
        profileFragment.bind();
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            View view2;
            view = view2;
            view2 = new HashMap();
            this._$_findViewCache = view;
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.getView();
            if (view == null) {
                return null;
            }
            view = view.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        HashMap hashMap = ((ProfileFragment)((Object)hashMap))._$_findViewCache;
        if (hashMap != null) {
            hashMap.clear();
        }
    }

    @Override
    public /* synthetic */ void onDestroyView() {
        ProfileFragment profileFragment = this;
        super.onDestroyView();
        profileFragment._$_clearFindViewByIdCache();
    }
}

