/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.messaging;

import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import androidx.room.Update;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.calls.WatchPartyRelation;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatKt;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageKt;
import io.streamlayer.sdk.model.messaging.ChatMessageRelation;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageUpdate;
import io.streamlayer.sdk.model.messaging.ChatOwnerCrossRef;
import io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef;
import io.streamlayer.sdk.model.messaging.ChatRelation;
import io.streamlayer.sdk.model.messaging.WaveMessage;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.messaging.MessagingDao;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\ba\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H'\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H'\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\fH'\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H'\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u0017\u001a\u00020\u0011H'\u00a2\u0006\u0004\b\u001a\u0010\u001bJ%\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00182\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0019H'\u00a2\u0006\u0004\b\u001e\u0010\u001fJ-\u0010!\u001a\u0010\u0012\f\u0012\n  *\u0004\u0018\u00010\u00020\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b!\u0010\u001fJ\u0017\u0010\"\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H'\u00a2\u0006\u0004\b\"\u0010\u0010J#\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001d0#2\u0006\u0010\u0017\u001a\u00020\u0011H'\u00a2\u0006\u0004\b$\u0010%J3\u0010&\u001a\u001e\u0012\f\u0012\n  *\u0004\u0018\u00010\u00190\u0019\u0012\f\u0012\n  *\u0004\u0018\u00010\u00020\u00020#2\u0006\u0010\u0017\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b&\u0010%J=\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u0006\u0010\u0017\u001a\u00020\u00112\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u00192\u0006\u0010)\u001a\u00020\u0019H'\u00a2\u0006\u0004\b*\u0010+J=\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00112\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u00192\u0006\u0010)\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b,\u0010+JC\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00070-2\u0006\u0010\u0017\u001a\u00020\u00112\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u00192\u0006\u0010)\u001a\u00020\u0019H'\u00a2\u0006\u0004\b.\u0010/Js\u00100\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0002  *\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00070\u0007  *\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0002  *\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00070\u0007\u0018\u00010-0-2\u0006\u0010\u0017\u001a\u00020\u00112\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u00192\u0006\u0010)\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b0\u0010/J\u001b\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u00070-H'\u00a2\u0006\u0004\b2\u00103JU\u00107\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u000206  *\n\u0012\u0004\u0012\u000206\u0018\u00010\u00070\u0007  *\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u000206  *\n\u0012\u0004\u0012\u000206\u0018\u00010\u00070\u0007\u0018\u00010-0-2\b\b\u0002\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b7\u00108J\u001d\u00109\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002060\u0007H\u0017\u00a2\u0006\u0004\b9\u0010\u000bJ\u0017\u0010;\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020:H'\u00a2\u0006\u0004\b;\u0010<J\u001d\u0010=\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002060\u0007H'\u00a2\u0006\u0004\b=\u0010\u000bJ\u000f\u0010>\u001a\u00020\tH'\u00a2\u0006\u0004\b>\u0010?J\u001d\u0010@\u001a\b\u0012\u0004\u0012\u0002010-2\u0006\u0010\u0012\u001a\u00020\u0011H'\u00a2\u0006\u0004\b@\u0010AJ;\u0010B\u001a&\u0012\f\u0012\n  *\u0004\u0018\u00010606  *\u0012\u0012\f\u0012\n  *\u0004\u0018\u00010606\u0018\u00010-0-2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\bB\u0010AJ\u0017\u0010C\u001a\u0002042\u0006\u0010\u0012\u001a\u00020\u0011H'\u00a2\u0006\u0004\bC\u0010DJ%\u0010G\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010F\u001a\b\u0012\u0004\u0012\u00020E0\u0007H\u0017\u00a2\u0006\u0004\bG\u0010HJ\u001d\u0010J\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020I0\u0007H'\u00a2\u0006\u0004\bJ\u0010\u000bJ\u001b\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0\u00070-H'\u00a2\u0006\u0004\bL\u00103JK\u0010N\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020M  *\n\u0012\u0004\u0012\u00020M\u0018\u00010\u00070\u0007  *\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020M  *\n\u0012\u0004\u0012\u00020M\u0018\u00010\u00070\u0007\u0018\u00010-0-H\u0016\u00a2\u0006\u0004\bN\u00103J\u001d\u0010O\u001a\b\u0012\u0004\u0012\u00020K0-2\u0006\u0010\u0012\u001a\u00020\u0011H'\u00a2\u0006\u0004\bO\u0010AJ;\u0010P\u001a&\u0012\f\u0012\n  *\u0004\u0018\u00010M0M  *\u0012\u0012\f\u0012\n  *\u0004\u0018\u00010M0M\u0018\u00010-0-2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\bP\u0010AJ\u0017\u0010R\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020QH'\u00a2\u0006\u0004\bR\u0010SJ!\u0010W\u001a\u0004\u0018\u00010Q2\u0006\u0010T\u001a\u00020\u00112\u0006\u0010V\u001a\u00020UH'\u00a2\u0006\u0004\bW\u0010XJ\u0017\u0010Y\u001a\u00020\t2\u0006\u0010V\u001a\u00020UH'\u00a2\u0006\u0004\bY\u0010ZJ\u0017\u0010[\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020QH'\u00a2\u0006\u0004\b[\u0010\\\u00a8\u0006]"}, d2={"Lio/streamlayer/sdk/repository/messaging/MessagingDao;", "", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "item", "", "saveChatMessage", "(Lio/streamlayer/sdk/model/messaging/ChatMessage;)J", "", "items", "", "saveChatMessages", "(Ljava/util/List;)V", "Lio/streamlayer/sdk/model/messaging/ChatMessageUpdate;", "updateChatMessage", "(Lio/streamlayer/sdk/model/messaging/ChatMessageUpdate;)V", "saveOrUpdateChatMessage", "(Lio/streamlayer/sdk/model/messaging/ChatMessage;)V", "", "chatId", "Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;", "status", "deleteMessages", "(Ljava/lang/String;Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;)V", "topicId", "Lio/reactivex/Maybe;", "", "getLastSeqId", "(Ljava/lang/String;)Lio/reactivex/Maybe;", "seq", "Lio/streamlayer/sdk/model/messaging/ChatMessageRelation;", "getChatMessageRelation", "(Ljava/lang/String;I)Lio/reactivex/Maybe;", "kotlin.jvm.PlatformType", "getChatMessage", "deleteChatMessage", "Landroidx/paging/DataSource$Factory;", "getChatMessagesRelationLiveData", "(Ljava/lang/String;)Landroidx/paging/DataSource$Factory;", "getChatMessagesLiveData", "beforeSeqId", "sinceSeqId", "limit", "getChatMessagesRelationList", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;I)Ljava/util/List;", "getChatMessagesList", "Lio/reactivex/Observable;", "getChatMessagesRelation", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;I)Lio/reactivex/Observable;", "getChatMessages", "Lio/streamlayer/sdk/model/messaging/ChatRelation;", "getChatsRelation", "()Lio/reactivex/Observable;", "", "isCall", "Lio/streamlayer/sdk/model/messaging/Chat;", "getChats", "(Z)Lio/reactivex/Observable;", "saveChats", "Lio/streamlayer/sdk/model/messaging/ChatOwnerCrossRef;", "saveChatOwner", "(Lio/streamlayer/sdk/model/messaging/ChatOwnerCrossRef;)V", "weakSaveChats", "deleteChats", "()V", "getChatRelation", "(Ljava/lang/String;)Lio/reactivex/Observable;", "getChat", "isChatExist", "(Ljava/lang/String;)Z", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "participants", "saveChatParticipants", "(Ljava/lang/String;Ljava/util/List;)V", "Lio/streamlayer/sdk/model/messaging/ChatParticipantCrossRef;", "saveChatParticipantCrossRefs", "Lio/streamlayer/sdk/model/calls/WatchPartyRelation;", "getWatchPartiesRelation", "Lio/streamlayer/sdk/model/calls/WatchParty;", "getWatchParties", "observeWatchPartyRelation", "observeWatchParty", "Lio/streamlayer/sdk/model/messaging/WaveMessage;", "saveWaveMessage", "(Lio/streamlayer/sdk/model/messaging/WaveMessage;)J", "chatUserId", "Ljava/util/Date;", "date", "getWaveByIdAndDate", "(Ljava/lang/String;Ljava/util/Date;)Lio/streamlayer/sdk/model/messaging/WaveMessage;", "deleteWaveEvents", "(Ljava/util/Date;)V", "deleteWaveMessage", "(Lio/streamlayer/sdk/model/messaging/WaveMessage;)V", "sdk_originalRelease"})
@Dao
public interface MessagingDao {
    @Insert(onConflict=5)
    public long saveChatMessage(@NotNull ChatMessage var1);

    @Insert(onConflict=1)
    public void saveChatMessages(@NotNull List<ChatMessage> var1);

    @Update(entity=ChatMessage.class)
    public void updateChatMessage(@NotNull ChatMessageUpdate var1);

    public void saveOrUpdateChatMessage(@NotNull ChatMessage var1);

    @Query(value="DELETE FROM ChatMessage WHERE chatMessageTopicId = :chatId AND status = :status")
    public void deleteMessages(@NotNull String var1, @NotNull ChatMessageStatus var2);

    @Query(value="SELECT ChatMessage.chatMessageSeq FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = :topicId ORDER BY ChatMessage.chatMessageSeq DESC LIMIT 1")
    @NotNull
    public Maybe<Integer> getLastSeqId(@NotNull String var1);

    @Transaction
    @Query(value="SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = :topicId AND ChatMessage.chatMessageSeq = :seq")
    @NotNull
    public Maybe<ChatMessageRelation> getChatMessageRelation(@NotNull String var1, int var2);

    @NotNull
    public Maybe<ChatMessage> getChatMessage(@NotNull String var1, int var2);

    @Delete
    public void deleteChatMessage(@NotNull ChatMessage var1);

    @Transaction
    @Query(value="SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = :topicId ORDER BY ChatMessage.chatMessageSeq DESC")
    @NotNull
    public DataSource.Factory<Integer, ChatMessageRelation> getChatMessagesRelationLiveData(@NotNull String var1);

    @NotNull
    public DataSource.Factory<Integer, ChatMessage> getChatMessagesLiveData(@NotNull String var1);

    @Transaction
    @Query(value="SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = :topicId AND (chatMessageSeq < :beforeSeqId OR :beforeSeqId IS NULL) AND (chatMessageSeq >= :sinceSeqId OR :sinceSeqId IS NULL) ORDER BY ChatMessage.chatMessageSeq DESC LIMIT :limit")
    @NotNull
    public List<ChatMessageRelation> getChatMessagesRelationList(@NotNull String var1, @Nullable Integer var2, @Nullable Integer var3, int var4);

    @NotNull
    public List<ChatMessage> getChatMessagesList(@NotNull String var1, @Nullable Integer var2, @Nullable Integer var3, int var4);

    @Transaction
    @Query(value="SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = :topicId AND (chatMessageSeq < :beforeSeqId OR :beforeSeqId IS NULL) AND (chatMessageSeq >= :sinceSeqId OR :sinceSeqId IS NULL) ORDER BY ChatMessage.chatMessageSeq DESC LIMIT :limit")
    @NotNull
    public Observable<List<ChatMessageRelation>> getChatMessagesRelation(@NotNull String var1, @Nullable Integer var2, @Nullable Integer var3, int var4);

    public Observable<List<ChatMessage>> getChatMessages(@NotNull String var1, @Nullable Integer var2, @Nullable Integer var3, int var4);

    @Transaction
    @Query(value="SELECT * FROM Chat ORDER BY Chat.updatedAt DESC")
    @NotNull
    public Observable<List<ChatRelation>> getChatsRelation();

    public Observable<List<Chat>> getChats(boolean var1);

    @Transaction
    public void saveChats(@NotNull List<Chat> var1);

    @Insert(onConflict=1)
    public void saveChatOwner(@NotNull ChatOwnerCrossRef var1);

    @Insert(onConflict=1)
    public void weakSaveChats(@NotNull List<Chat> var1);

    @Query(value="DELETE FROM Chat")
    public void deleteChats();

    @Transaction
    @Query(value="SELECT * FROM Chat WHERE Chat.chatId = :chatId")
    @NotNull
    public Observable<ChatRelation> getChatRelation(@NotNull String var1);

    public Observable<Chat> getChat(@NotNull String var1);

    @Query(value="SELECT EXISTS(SELECT * FROM Chat WHERE Chat.chatId = :chatId)")
    public boolean isChatExist(@NotNull String var1);

    @Transaction
    public void saveChatParticipants(@NotNull String var1, @NotNull List<TinodeContact> var2);

    @Insert(onConflict=1)
    public void saveChatParticipantCrossRefs(@NotNull List<ChatParticipantCrossRef> var1);

    @Transaction
    @Query(value="SELECT * FROM Chat ORDER BY Chat.updatedAt DESC")
    @NotNull
    public Observable<List<WatchPartyRelation>> getWatchPartiesRelation();

    public Observable<List<WatchParty>> getWatchParties();

    @Query(value="SELECT * FROM Chat WHERE Chat.chatId = :chatId")
    @NotNull
    public Observable<WatchPartyRelation> observeWatchPartyRelation(@NotNull String var1);

    public Observable<WatchParty> observeWatchParty(@NotNull String var1);

    @Insert(onConflict=1)
    public long saveWaveMessage(@NotNull WaveMessage var1);

    @Query(value="SELECT * FROM WaveMessage WHERE chatUserId = :chatUserId AND sentAt >= :date")
    @Nullable
    public WaveMessage getWaveByIdAndDate(@NotNull String var1, @NotNull Date var2);

    @Query(value="DELETE FROM WaveMessage WHERE sentAt <= :date")
    public void deleteWaveEvents(@NotNull Date var1);

    @Delete
    public void deleteWaveMessage(@NotNull WaveMessage var1);

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public static final class DefaultImpls {
        public static void saveOrUpdateChatMessage(MessagingDao messagingDao, @NotNull ChatMessage chatMessage) {
            ChatMessage chatMessage2 = chatMessage;
            Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"item");
            if (messagingDao.saveChatMessage(chatMessage2) == -1L) {
                messagingDao.updateChatMessage(ChatMessageKt.toUpdateEntity(chatMessage));
            }
        }

        @NotNull
        public static Maybe<ChatMessage> getChatMessage(MessagingDao messagingDao, @NotNull String string2, int n) {
            String string3 = string2;
            Intrinsics.checkParameterIsNotNull((Object)string3, (String)"topicId");
            Maybe maybe = messagingDao.getChatMessageRelation(string3, n).map((Function)getChatMessage.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)maybe, (String)"getChatMessageRelation(t\u2026eq).map { it.toDomain() }");
            return maybe;
        }

        @NotNull
        public static DataSource.Factory<Integer, ChatMessage> getChatMessagesLiveData(MessagingDao messagingDao, @NotNull String string2) {
            String string3 = string2;
            Intrinsics.checkParameterIsNotNull((Object)string3, (String)"topicId");
            DataSource.Factory factory = messagingDao.getChatMessagesRelationLiveData(string3).map((androidx.arch.core.util.Function)getChatMessagesLiveData.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)factory, (String)"getChatMessagesRelationL\u2026Id).map { it.toDomain() }");
            return factory;
        }

        public static /* synthetic */ List getChatMessagesRelationList$default(MessagingDao messagingDao, String string2, Integer n, Integer n2, int n3, int n4, Object object) {
            if (object == null) {
                if ((n4 & 2) != 0) {
                    n = null;
                }
                if ((n4 & 4) != 0) {
                    n2 = null;
                }
                return messagingDao.getChatMessagesRelationList(string2, n, n2, n3);
            }
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getChatMessagesRelationList");
        }

        @NotNull
        public static List<ChatMessage> getChatMessagesList(MessagingDao iterator, @NotNull String object, @Nullable Integer n, @Nullable Integer n2, int n3) {
            ArrayList arrayList;
            String string2 = object;
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
            iterator = iterator.getChatMessagesRelationList(string2, n, n2, n3);
            object = arrayList;
            arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object.add(ChatMessageKt.toDomain((ChatMessageRelation)iterator.next()));
            }
            return object;
        }

        public static /* synthetic */ List getChatMessagesList$default(MessagingDao messagingDao, String string2, Integer n, Integer n2, int n3, int n4, Object object) {
            if (object == null) {
                if ((n4 & 2) != 0) {
                    n = null;
                }
                if ((n4 & 4) != 0) {
                    n2 = null;
                }
                return messagingDao.getChatMessagesList(string2, n, n2, n3);
            }
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getChatMessagesList");
        }

        public static /* synthetic */ Observable getChatMessagesRelation$default(MessagingDao messagingDao, String string2, Integer n, Integer n2, int n3, int n4, Object object) {
            if (object == null) {
                if ((n4 & 2) != 0) {
                    n = null;
                }
                if ((n4 & 4) != 0) {
                    n2 = null;
                }
                return messagingDao.getChatMessagesRelation(string2, n, n2, n3);
            }
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getChatMessagesRelation");
        }

        public static Observable<List<ChatMessage>> getChatMessages(MessagingDao messagingDao, @NotNull String string2, @Nullable Integer n, @Nullable Integer n2, int n3) {
            String string3 = string2;
            Intrinsics.checkParameterIsNotNull((Object)string3, (String)"topicId");
            return messagingDao.getChatMessagesRelation(string3, n, n2, n3).map((Function)getChatMessages.1.INSTANCE);
        }

        public static /* synthetic */ Observable getChatMessages$default(MessagingDao messagingDao, String string2, Integer n, Integer n2, int n3, int n4, Object object) {
            if (object == null) {
                if ((n4 & 2) != 0) {
                    n = null;
                }
                if ((n4 & 4) != 0) {
                    n2 = null;
                }
                return messagingDao.getChatMessages(string2, n, n2, n3);
            }
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getChatMessages");
        }

        public static Observable<List<Chat>> getChats(MessagingDao messagingDao, boolean bl) {
            return messagingDao.getChatsRelation().map(new Function<T, R>(bl){
                final /* synthetic */ boolean $isCall;
                {
                    this.$isCall = bl;
                }

                @NotNull
                public final List<Chat> apply(@NotNull List<ChatRelation> object) {
                    ArrayList<E> arrayList;
                    Object object2;
                    ArrayList<E> arrayList2;
                    ArrayList<Chat> arrayList3;
                    List<ChatRelation> list = object;
                    Intrinsics.checkParameterIsNotNull(list, (String)"it");
                    Iterator<T> iterator = arrayList3;
                    arrayList3 = new ArrayList<Chat>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
                    object = list.iterator();
                    while (object.hasNext()) {
                        iterator.add(ChatKt.toDomain((ChatRelation)object.next()));
                    }
                    object = arrayList2;
                    arrayList2 = new ArrayList<E>();
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        object2 = iterator.next();
                        if (!(((Chat)object2).getParticipants().isEmpty() ^ true)) continue;
                        object.add(object2);
                    }
                    Object object3 = object;
                    object = arrayList;
                    arrayList = new ArrayList<E>();
                    iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        object2 = iterator.next();
                        Chat chat = (Chat)object2;
                        if (!(this.$isCall ? chat.isCallChat() : !chat.isCallChat())) continue;
                        object.add(object2);
                    }
                    return CollectionsKt.sortedWith((Iterable)object, new Comparator<T>(){

                        public final int compare(T object, T object2) {
                            Object object3 = (Chat)object2;
                            if ((object2 = ((Chat)object3).getLastMessage()) == null || (object2 = ((ChatMessage)object2).getDate()) == null) {
                                object2 = ((Chat)object3).getTouchedAt();
                            }
                            object3 = (Chat)object;
                            object = ((Chat)object3).getLastMessage();
                            if (object == null || (object = ((ChatMessage)object).getDate()) == null) {
                                object = ((Chat)object3).getTouchedAt();
                            }
                            return ComparisonsKt.compareValues((Comparable)object2, (Comparable)object);
                        }
                    });
                }
            });
        }

        public static /* synthetic */ Observable getChats$default(MessagingDao messagingDao, boolean bl, int n, Object object) {
            if (object == null) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                return messagingDao.getChats(bl);
            }
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getChats");
        }

        @Transaction
        public static void saveChats(MessagingDao messagingDao, @NotNull List<Chat> list) {
            Intrinsics.checkParameterIsNotNull(list, (String)"items");
            messagingDao.weakSaveChats(list);
        }

        public static Observable<Chat> getChat(MessagingDao messagingDao, @NotNull String string2) {
            String string3 = string2;
            Intrinsics.checkParameterIsNotNull((Object)string3, (String)"chatId");
            return messagingDao.getChatRelation(string3).map((Function)getChat.1.INSTANCE);
        }

        @Transaction
        public static void saveChatParticipants(MessagingDao messagingDao, @NotNull String string2, @NotNull List<TinodeContact> object) {
            ArrayList<ChatParticipantCrossRef> arrayList;
            List<TinodeContact> list = object;
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
            Intrinsics.checkParameterIsNotNull(list, (String)"participants");
            ArrayList<ChatParticipantCrossRef> arrayList2 = arrayList;
            arrayList = new ArrayList<ChatParticipantCrossRef>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
            for (TinodeContact tinodeContact : list) {
                arrayList2.add(new ChatParticipantCrossRef(string2, tinodeContact.getChatUserId()));
            }
            messagingDao.saveChatParticipantCrossRefs(arrayList2);
        }

        public static Observable<List<WatchParty>> getWatchParties(MessagingDao messagingDao) {
            return messagingDao.getWatchPartiesRelation().map((Function)getWatchParties.1.INSTANCE);
        }

        public static Observable<WatchParty> observeWatchParty(MessagingDao messagingDao, @NotNull String string2) {
            String string3 = string2;
            Intrinsics.checkParameterIsNotNull((Object)string3, (String)"chatId");
            return messagingDao.observeWatchPartyRelation(string3).map((Function)observeWatchParty.1.INSTANCE);
        }
    }
}

