/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.deeplink;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import androidx.appcompat.app.AppCompatActivity;
import com.google.gson.JsonSyntaxException;
import io.streamlayer.sdk.base.StreamLayerBaseFragment;
import io.streamlayer.sdk.deeplink.DeepLinkRoute;
import io.streamlayer.sdk.model.deeplink.DeepLink;
import io.streamlayer.sdk.model.deeplink.InviteData;
import io.streamlayer.sdk.model.deeplink.Payload;
import io.streamlayer.sdk.model.deeplink.ReferralLink;
import io.streamlayer.utils.GsonUtil;
import io.streamlayer.utils.NavigationUtils;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J3\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u000f8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\u000f8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b \u0010\u001f\u00a8\u0006#"}, d2={"Lio/streamlayer/sdk/deeplink/DeepLinkHandler;", "", "Landroidx/appcompat/app/AppCompatActivity;", "activity", "Lio/streamlayer/sdk/base/StreamLayerBaseFragment;", "findHostFragment", "(Landroidx/appcompat/app/AppCompatActivity;)Lio/streamlayer/sdk/base/StreamLayerBaseFragment;", "Landroid/content/Intent;", "intent", "Lio/streamlayer/sdk/model/deeplink/DeepLink;", "getDeepLink", "(Landroid/content/Intent;)Lio/streamlayer/sdk/model/deeplink/DeepLink;", "", "handleDeepLinkIntent", "(Landroid/content/Intent;Landroidx/appcompat/app/AppCompatActivity;)Z", "", "json", "handleReferralDeepLink", "(Ljava/lang/String;Landroidx/appcompat/app/AppCompatActivity;)Z", "Landroid/content/Context;", "context", "Lio/streamlayer/sdk/deeplink/DeepLinkRoute;", "route", "Landroid/net/Uri;", "destinationUri", "Lio/streamlayer/sdk/model/deeplink/Payload;", "payload", "buildDeepLinkIntent$sdk_originalRelease", "(Landroid/content/Context;Lio/streamlayer/sdk/deeplink/DeepLinkRoute;Landroid/net/Uri;Lio/streamlayer/sdk/model/deeplink/Payload;)Landroid/content/Intent;", "buildDeepLinkIntent", "DEEP_LINK_NAV_GRAPH_DATA", "Ljava/lang/String;", "DEEP_LINK_PAYLOAD_DATA", "<init>", "()V", "sdk_originalRelease"})
public final class DeepLinkHandler {
    private static final String DEEP_LINK_NAV_GRAPH_DATA = "deep_link_graph_data";
    private static final String DEEP_LINK_PAYLOAD_DATA = "deep_link_payload_data";
    public static final DeepLinkHandler INSTANCE = new DeepLinkHandler();

    private final StreamLayerBaseFragment findHostFragment(AppCompatActivity appCompatActivity) {
        return (StreamLayerBaseFragment)appCompatActivity.getSupportFragmentManager().findFragmentByTag("StreamLayerFragment");
    }

    private final DeepLink getDeepLink(Intent intent) {
        DeepLink deepLink;
        DeepLinkHandler deepLinkHandler = (Uri)intent.getParcelableExtra(DEEP_LINK_NAV_GRAPH_DATA);
        if (deepLinkHandler != null) {
            DeepLink deepLink2;
            deepLink = deepLink2;
            deepLink2 = new DeepLink((Uri)deepLinkHandler, (Payload)intent.getSerializableExtra(DEEP_LINK_PAYLOAD_DATA));
        } else {
            deepLink = null;
        }
        return deepLink;
    }

    private DeepLinkHandler() {
    }

    public final boolean handleDeepLinkIntent(@NotNull Intent intent, @NotNull AppCompatActivity object) {
        boolean bl;
        block2: {
            block0: {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                    Intrinsics.checkParameterIsNotNull((Object)object, (String)"activity");
                    Uri uri = intent.getData();
                    if (!Intrinsics.areEqual((Object)(uri != null ? uri.getScheme() : null), (Object)"streamlayer")) break block0;
                    if ((this = ((DeepLinkHandler)this).findHostFragment((AppCompatActivity)object)) == null) break block1;
                    object = INSTANCE.getDeepLink(intent);
                    if (object == null) break block0;
                    ((StreamLayerBaseFragment)((Object)this)).processDeepLink$sdk_originalRelease((DeepLink)object);
                    intent.setData(null);
                    bl = true;
                    break block2;
                }
                throw new IllegalStateException("StreamLayerFragment or StreamLayerLiteFragment are not found! Please add android:tag=\"StreamLayerFragment\" to your FragmentContainerView");
            }
            bl = false;
        }
        return bl;
    }

    public final boolean handleReferralDeepLink(@NotNull String string2, @NotNull AppCompatActivity appCompatActivity) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"json");
            Intrinsics.checkParameterIsNotNull((Object)appCompatActivity, (String)"activity");
            try {
                InviteData inviteData = ((ReferralLink)GsonUtil.INSTANCE.getDefaultGson().fromJson(string2, ReferralLink.class)).getData();
                if (inviteData == null) break block3;
            }
            catch (JsonSyntaxException jsonSyntaxException) {}
            appCompatActivity.startActivity(INSTANCE.buildDeepLinkIntent$sdk_originalRelease((Context)appCompatActivity, DeepLinkRoute.INVITE, NavigationUtils.INSTANCE.buildInviteDeepLink(), new Payload.Invite(inviteData)));
            bl = true;
        }
        bl = false;
        return bl;
    }

    @NotNull
    public final Intent buildDeepLinkIntent$sdk_originalRelease(@NotNull Context context, @NotNull DeepLinkRoute deepLinkRoute, @Nullable Uri uri, @Nullable Payload payload) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deepLinkRoute), (String)"route");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("streamlayer://" + context.getPackageName() + deepLinkRoute.getValue())));
        intent.putExtra(DEEP_LINK_NAV_GRAPH_DATA, (Parcelable)uri);
        intent.putExtra(DEEP_LINK_PAYLOAD_DATA, (Serializable)payload);
        return intent;
    }
}

