/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.callstatus;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.calls.CallConnectionStatus;
import io.streamlayer.sdk.model.calls.CallParticipantStatus;
import io.streamlayer.sdk.model.calls.CallStatus;
import io.streamlayer.sdk.model.calls.ParticipantStatus;
import io.streamlayer.sdk.model.tinodecontact.TinodePres;
import io.streamlayer.sdk.repository.callstatus.CallStatusRepo;
import io.streamlayer.sdk.repository.callstatus.CallStatusRepoImplKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u00020\u00158\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lio/streamlayer/sdk/repository/callstatus/CallStatusRepoImpl;", "Lio/streamlayer/sdk/repository/callstatus/CallStatusRepo;", "", "Lio/streamlayer/sdk/model/calls/ParticipantStatus;", "states", "Lio/streamlayer/sdk/model/calls/CallConnectionStatus;", "reduceParticipantCallStates", "(Ljava/util/List;)Lio/streamlayer/sdk/model/calls/CallConnectionStatus;", "Lio/streamlayer/sdk/model/tinodecontact/TinodePres;", "presence", "Lio/reactivex/Observable;", "Lio/streamlayer/sdk/model/calls/CallStatus;", "processParticipantPresence", "(Lio/streamlayer/sdk/model/tinodecontact/TinodePres;)Lio/reactivex/Observable;", "", "callId", "observeCallStatus", "(Ljava/lang/String;)Lio/reactivex/Observable;", "Lio/streamlayer/common/session/SessionPrefImpl;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "Lio/streamlayer/common/data/database/AppDatabase;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "<init>", "(Lio/streamlayer/common/data/database/AppDatabase;Lio/streamlayer/common/session/SessionPrefImpl;)V", "sdk_originalRelease"})
public final class CallStatusRepoImpl
implements CallStatusRepo {
    private final AppDatabase database;
    private final SessionPrefImpl session;

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private final CallConnectionStatus reduceParticipantCallStates(List<? extends ParticipantStatus> list) {
        CallConnectionStatus callConnectionStatus;
        block11: {
            boolean bl;
            block8: {
                Iterator iterator;
                boolean bl2;
                boolean bl3;
                block7: {
                    Iterator iterator2;
                    if (list.contains((Object)ParticipantStatus.Online)) {
                        callConnectionStatus = CallConnectionStatus.Connected;
                        return callConnectionStatus;
                    }
                    boolean bl4 = true;
                    do {
                        block10: {
                            block9: {
                                if (!bl4 || (bl4 = false)) break block9;
                                bl3 = list instanceof Collection;
                                if (bl3 && list.isEmpty()) break block10;
                                iterator2 = list.iterator();
                            }
                            if (iterator2.hasNext()) continue;
                        }
                        bl2 = false;
                        break block7;
                    } while (!((ParticipantStatus)((Object)iterator2.next()) == ParticipantStatus.Pending));
                    bl2 = true;
                }
                if (bl2) {
                    callConnectionStatus = CallConnectionStatus.Connecting;
                    return callConnectionStatus;
                }
                if (list.isEmpty()) break block11;
                boolean bl5 = true;
                do {
                    block13: {
                        block12: {
                            if (!bl5 || (bl5 = false)) break block12;
                            if (bl3 && list.isEmpty()) break block13;
                            iterator = list.iterator();
                        }
                        if (iterator.hasNext()) continue;
                    }
                    bl = true;
                    break block8;
                } while ((ParticipantStatus)((Object)iterator.next()) == ParticipantStatus.Pending);
                bl = false;
            }
            if (!bl) {
                callConnectionStatus = CallConnectionStatus.Ended;
                return callConnectionStatus;
            }
        }
        callConnectionStatus = CallConnectionStatus.Idle;
        return callConnectionStatus;
    }

    @Inject
    public CallStatusRepoImpl(@NotNull AppDatabase appDatabase, @NotNull SessionPrefImpl sessionPrefImpl) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        this.database = appDatabase;
        this.session = sessionPrefImpl;
    }

    public static final /* synthetic */ CallConnectionStatus access$reduceParticipantCallStates(CallStatusRepoImpl callStatusRepoImpl, List list) {
        return callStatusRepoImpl.reduceParticipantCallStates(list);
    }

    public static final /* synthetic */ SessionPrefImpl access$getSession$p(CallStatusRepoImpl callStatusRepoImpl) {
        return callStatusRepoImpl.session;
    }

    public static final /* synthetic */ AppDatabase access$getDatabase$p(CallStatusRepoImpl callStatusRepoImpl) {
        return callStatusRepoImpl.database;
    }

    @Override
    @NotNull
    public Observable<CallStatus> processParticipantPresence(@NotNull TinodePres tinodePres) {
        Intrinsics.checkParameterIsNotNull((Object)tinodePres, (String)"presence");
        Observable observable = this.database.callDao().getCallStatus(tinodePres.getTopic()).defaultIfEmpty((Object)new CallStatus(tinodePres.getTopic(), CallConnectionStatus.Idle, CollectionsKt.emptyList())).flatMapObservable(new Function<T, ObservableSource<? extends R>>(this, tinodePres){
            final /* synthetic */ CallStatusRepoImpl this$0;
            final /* synthetic */ TinodePres $presence;
            {
                this.this$0 = callStatusRepoImpl;
                this.$presence = tinodePres;
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Observable<CallStatus> apply(@NotNull CallStatus callStatus) {
                ArrayList<E> arrayList;
                ArrayList<E> arrayList2;
                Iterator<T> iterator;
                Object object;
                boolean bl;
                Object object22;
                CallStatus callStatus2 = callStatus;
                Intrinsics.checkParameterIsNotNull((Object)callStatus2, (String)"callStatus");
                List list = CollectionsKt.toMutableList(callStatus2.getParticipantStatuses());
                if (!(list instanceof Collection) || !list.isEmpty()) {
                    for (Object object22 : list) {
                        if (!Intrinsics.areEqual((Object)this.$presence.getChatUserId(), (Object)((CallParticipantStatus)object22).getUserId())) continue;
                        bl = false;
                        break;
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    object = CallStatusRepoImplKt.toCallParticipantStatus(this.$presence);
                    if (((CallParticipantStatus)object).getStatus() == ParticipantStatus.Online) {
                        ((CallParticipantStatus)object).setWasParticipant(true);
                    }
                    list.add(object);
                } else {
                    block12: {
                        for (Object object22 : list) {
                            iterator = (CallParticipantStatus)object22;
                            if (!Intrinsics.areEqual((Object)this.$presence.getChatUserId(), (Object)((CallParticipantStatus)((Object)iterator)).getUserId())) continue;
                            break block12;
                        }
                        object22 = null;
                    }
                    object = object22;
                    if (object != null) {
                        list.remove(object);
                        object = CallParticipantStatus.copy$default((CallParticipantStatus)object, null, CallStatusRepoImplKt.toParticipantStatus(this.$presence), 1, null);
                        if (((CallParticipantStatus)object).getStatus() == ParticipantStatus.Online) {
                            ((CallParticipantStatus)object).setWasParticipant(true);
                        }
                        list.add(object);
                    }
                }
                object = null;
                object22 = this.this$0;
                iterator = arrayList2;
                arrayList2 = new ArrayList<E>();
                for (T t : list) {
                    if (!(Intrinsics.areEqual((Object)((CallParticipantStatus)t).getUserId(), (Object)CallStatusRepoImpl.access$getSession$p(this.this$0).getTinodeUserId()) ^ true)) continue;
                    iterator.add(t);
                }
                ArrayList<E> arrayList3 = arrayList;
                arrayList = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
                iterator = iterator.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        CallStatus callStatus3 = CallStatus.copy$default(callStatus, (String)object, CallStatusRepoImpl.access$reduceParticipantCallStates((CallStatusRepoImpl)object22, CollectionsKt.toList((Iterable)arrayList3)), list, 1, null);
                        CallStatusRepoImpl.access$getDatabase$p(this.this$0).callDao().saveCallStatus(callStatus3);
                        return Observable.just((Object)callStatus3);
                    }
                    arrayList3.add(((CallParticipantStatus)iterator.next()).getStatus());
                }
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"database.callDao().getCa\u2026CallStatus)\n            }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<CallStatus> observeCallStatus(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"callId");
        Observable observable = this.database.callDao().observeCallStatus(string2).defaultIfEmpty((Object)new CallStatus(string2, CallConnectionStatus.Idle, CollectionsKt.emptyList()));
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"database.callDao()\n     \u2026tatus.Idle, emptyList()))");
        return observable;
    }
}

