/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.usecases;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import io.reactivex.Notification;
import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.scheduler.SchedulerProvider;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.repository.messaging.MessagingRepo;
import io.streamlayer.sdk.repository.watchparty.WatchPartyRepo;
import io.streamlayer.sdk.usecases.WatchPartyUseCase;
import io.streamlayer.sdk.usecases.WatchPartyUseCaseKt;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00030\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00030\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fR(\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00030\u00108\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0014\u001a\u00020\u00138\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lio/streamlayer/sdk/usecases/WatchPartyUseCase;", "", "Landroidx/lifecycle/LiveData;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "", "Lio/streamlayer/sdk/model/calls/WatchParty;", "activeWatchParties", "()Landroidx/lifecycle/LiveData;", "Lio/reactivex/Observable;", "observeWatchParties", "()Lio/reactivex/Observable;", "Lio/streamlayer/sdk/model/messaging/Chat;", "chat", "", "subscribeToPresence", "(Lio/streamlayer/sdk/model/messaging/Chat;)V", "Landroidx/lifecycle/MutableLiveData;", "_activeWatchParties", "Landroidx/lifecycle/MutableLiveData;", "Lio/reactivex/disposables/CompositeDisposable;", "compositeDisposable", "Lio/reactivex/disposables/CompositeDisposable;", "getCompositeDisposable", "()Lio/reactivex/disposables/CompositeDisposable;", "Lio/streamlayer/sdk/repository/watchparty/WatchPartyRepo;", "watchPartyRepo", "Lio/streamlayer/sdk/repository/watchparty/WatchPartyRepo;", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "messageRepo", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "schedulers", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "<init>", "(Lio/streamlayer/sdk/repository/watchparty/WatchPartyRepo;Lio/streamlayer/common/scheduler/SchedulerProvider;Lio/streamlayer/sdk/repository/messaging/MessagingRepo;)V", "sdk_originalRelease"})
public final class WatchPartyUseCase {
    @NotNull
    private final CompositeDisposable compositeDisposable;
    private final MutableLiveData<ResourceState<List<WatchParty>>> _activeWatchParties;
    private final WatchPartyRepo watchPartyRepo;
    private final SchedulerProvider schedulers;
    private final MessagingRepo messageRepo;

    @Inject
    public WatchPartyUseCase(@NotNull WatchPartyRepo watchPartyRepo, @NotNull SchedulerProvider schedulerProvider, @NotNull MessagingRepo messagingRepo) {
        MutableLiveData mutableLiveData;
        CompositeDisposable compositeDisposable;
        Intrinsics.checkParameterIsNotNull((Object)watchPartyRepo, (String)"watchPartyRepo");
        Intrinsics.checkParameterIsNotNull((Object)schedulerProvider, (String)"schedulers");
        Intrinsics.checkParameterIsNotNull((Object)messagingRepo, (String)"messageRepo");
        watchPartyUseCase.watchPartyRepo = watchPartyRepo;
        watchPartyUseCase.schedulers = schedulerProvider;
        watchPartyUseCase.messageRepo = messagingRepo;
        WatchPartyUseCase watchPartyUseCase = compositeDisposable;
        compositeDisposable = new CompositeDisposable();
        v1.compositeDisposable = watchPartyUseCase;
        watchPartyUseCase = mutableLiveData;
        mutableLiveData = new MutableLiveData();
        v1._activeWatchParties = watchPartyUseCase;
    }

    public static final /* synthetic */ MutableLiveData access$get_activeWatchParties$p(WatchPartyUseCase watchPartyUseCase) {
        return watchPartyUseCase._activeWatchParties;
    }

    @NotNull
    public final CompositeDisposable getCompositeDisposable() {
        return this.compositeDisposable;
    }

    @NotNull
    public final LiveData<ResourceState<List<WatchParty>>> activeWatchParties() {
        LiveData liveData = Transformations.distinctUntilChanged(this._activeWatchParties);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        return liveData;
    }

    @NotNull
    public final Observable<ResourceState<List<WatchParty>>> observeWatchParties() {
        Observable observable = this.watchPartyRepo.getWatchParties().distinctUntilChanged().doOnEach(new Consumer<Notification<ResourceState<? extends List<? extends WatchParty>>>>(this){
            final /* synthetic */ WatchPartyUseCase this$0;
            {
                this.this$0 = watchPartyUseCase;
            }

            public final void accept(Notification<ResourceState<List<WatchParty>>> notification) {
                MutableLiveData mutableLiveData = WatchPartyUseCase.access$get_activeWatchParties$p(this.this$0);
                Notification<ResourceState<List<WatchParty>>> notification2 = notification;
                Intrinsics.checkExpressionValueIsNotNull(notification2, (String)"it");
                mutableLiveData.postValue(notification2.getValue());
            }
        }).subscribeOn(this.schedulers.io());
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"watchPartyRepo.getWatchP\u2026scribeOn(schedulers.io())");
        return observable;
    }

    public final void subscribeToPresence(@Nullable Chat object) {
        WatchPartyUseCaseKt.access$getTAG$p();
        String cfr_ignored_0 = "subscribeToPresence chat " + object;
        if (object == null) {
            return;
        }
        Chat chat = object;
        object = chat.getChatId();
        this.compositeDisposable.add(this.messageRepo.subscribeToPresence((String)object, chat.isCallChat()).subscribeOn(this.schedulers.io()).subscribe((Consumer)subscribeToPresence.1.INSTANCE, (Consumer)subscribeToPresence.2.INSTANCE));
    }
}

