/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.fs;

import android.content.Context;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.functions.Action;
import io.streamlayer.common.data.fs.FileSystem;
import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0016\u0010\u000e\u001a\u00020\u00068V@\u0016X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lio/streamlayer/common/data/fs/FileSystemImpl;", "Lio/streamlayer/common/data/fs/FileSystem;", "", "name", "extension", "Lio/reactivex/Observable;", "Ljava/io/File;", "createTempFile", "(Ljava/lang/String;Ljava/lang/String;)Lio/reactivex/Observable;", "Lio/reactivex/Completable;", "deleteTempFile", "(Ljava/lang/String;Ljava/lang/String;)Lio/reactivex/Completable;", "getCacheDirectory", "()Ljava/io/File;", "cacheDirectory", "Landroid/content/Context;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "sdk_originalRelease"})
public final class FileSystemImpl
implements FileSystem {
    private final Context context;

    @Inject
    public FileSystemImpl(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @NotNull
    public File getCacheDirectory() {
        File file = this.context.getCacheDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.cacheDir");
        return file;
    }

    @Override
    @NotNull
    public Observable<File> createTempFile(@NotNull String string, @NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"extension");
        Observable observable = Observable.fromCallable(new Callable<T>(this, string, string2){
            final /* synthetic */ FileSystemImpl this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ String $extension;
            {
                this.this$0 = fileSystemImpl;
                this.$name = string;
                this.$extension = string2;
            }

            public final File call() {
                return File.createTempFile(this.$name, this.$extension, this.this$0.getCacheDirectory());
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.fromCallable \u2026cacheDirectory)\n        }");
        return observable;
    }

    @Override
    @NotNull
    public Completable deleteTempFile(@NotNull String string, @NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"extension");
        Completable completable = Completable.fromAction((Action)new Action(this, string, string2){
            final /* synthetic */ FileSystemImpl this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ String $extension;
            {
                this.this$0 = fileSystemImpl;
                this.$name = string;
                this.$extension = string2;
            }

            public final void run() {
                File file;
                File file2 = file;
                if (new File(this.this$0.getCacheDirectory(), this.$name + '.' + this.$extension).exists()) {
                    file2.delete();
                }
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.fromAction {\u2026)\n            }\n        }");
        return completable;
    }
}

