/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.mvvm.pagination;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.paging.LivePagedListBuilder;
import androidx.paging.PagedList;
import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;
import io.streamlayer.common.mvvm.basemodels.BaseError;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.mvvm.pagination.GenericPaginationDataSource;
import io.streamlayer.common.mvvm.pagination.GenericPaginationDataSourceFactory;
import io.streamlayer.common.mvvm.pagination.GenericPaginationParams;
import io.streamlayer.common.mvvm.pagination.PaginationBuilderKt;
import io.streamlayer.common.mvvm.pagination.PaginationBuilderKt$WhenMappings;
import io.streamlayer.common.mvvm.pagination.PaginationBuilderKt$buildLivePagedListWithState$1$$special$;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a|\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000f\"\b\b\u0000\u0010\u0001*\u00020\u0000\"\u0004\b\u0001\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u000329\u0010\f\u001a5\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\n0\t0\u00052\u0006\u0010\u000e\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a#\u0010\u0013\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001aM\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00180\n0\u0017\"\b\b\u0000\u0010\u0001*\u00020\u0000\"\u0004\b\u0001\u0010\u00022\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001aU\u0010 \u001a\u00020\u001f\"\b\b\u0000\u0010\u0001*\u00020\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00180\u00172\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00180\n0\u001dH\u0000\u00a2\u0006\u0004\b \u0010!\u00a8\u0006\""}, d2={"", "DataType", "PaginationParams", "Lio/streamlayer/common/mvvm/pagination/GenericPaginationParams;", "paginationParams", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "params", "Lio/reactivex/Observable;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "", "call", "Lio/reactivex/disposables/CompositeDisposable;", "compositeDisposable", "Lio/streamlayer/common/mvvm/pagination/GenericPaginationDataSourceFactory;", "generatePaginationDataSourceFactory", "(Lio/streamlayer/common/mvvm/pagination/GenericPaginationParams;Lkotlin/jvm/functions/Function1;Lio/reactivex/disposables/CompositeDisposable;)Lio/streamlayer/common/mvvm/pagination/GenericPaginationDataSourceFactory;", "Landroidx/paging/PagedList$Config;", "generateDefaultPaginationConfig", "(Lio/streamlayer/common/mvvm/pagination/GenericPaginationParams;)Landroidx/paging/PagedList$Config;", "dataSourceFactory", "paginationConfig", "Landroidx/lifecycle/LiveData;", "Landroidx/paging/PagedList;", "buildLivePagedListWithState", "(Lio/streamlayer/common/mvvm/pagination/GenericPaginationDataSourceFactory;Landroidx/paging/PagedList$Config;)Landroidx/lifecycle/LiveData;", "fetchState", "pagedDataList", "Landroidx/lifecycle/MediatorLiveData;", "mergedSource", "", "setMergedSourceDataByFetchState", "(Lio/streamlayer/common/mvvm/basemodels/ResourceState;Landroidx/lifecycle/LiveData;Landroidx/lifecycle/MediatorLiveData;)V", "sdk_originalRelease"})
public final class PaginationBuilderKt {
    @NotNull
    public static final <DataType, PaginationParams> GenericPaginationDataSourceFactory<DataType, PaginationParams> generatePaginationDataSourceFactory(@NotNull GenericPaginationParams<PaginationParams> genericPaginationParams, @NotNull Function1<? super GenericPaginationParams<PaginationParams>, ? extends Observable<ResourceState<List<DataType>>>> function1, @NotNull CompositeDisposable compositeDisposable) {
        Intrinsics.checkParameterIsNotNull(genericPaginationParams, (String)"paginationParams");
        Intrinsics.checkParameterIsNotNull(function1, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)compositeDisposable, (String)"compositeDisposable");
        return new GenericPaginationDataSourceFactory(genericPaginationParams, function1, compositeDisposable);
    }

    @NotNull
    public static final <PaginationParams> PagedList.Config generateDefaultPaginationConfig(@NotNull GenericPaginationParams<PaginationParams> genericPaginationParams) {
        Intrinsics.checkParameterIsNotNull(genericPaginationParams, (String)"paginationParams");
        return new PagedList.Config.Builder().setPageSize(genericPaginationParams.getPageSize()).setInitialLoadSizeHint(genericPaginationParams.getPageSize() * 2).setEnablePlaceholders(false).build();
    }

    @NotNull
    public static final <DataType, PaginationParams> LiveData<ResourceState<PagedList<DataType>>> buildLivePagedListWithState(@NotNull GenericPaginationDataSourceFactory<DataType, PaginationParams> mediatorLiveData, @NotNull PagedList.Config config) {
        Observer observer;
        MediatorLiveData mediatorLiveData2;
        Ref.ObjectRef objectRef;
        Intrinsics.checkParameterIsNotNull(mediatorLiveData, (String)"dataSourceFactory");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"paginationConfig");
        config = new LivePagedListBuilder(mediatorLiveData, config).build();
        Ref.ObjectRef objectRef2 = objectRef;
        objectRef2();
        objectRef.element = mediatorLiveData.getFetchState();
        mediatorLiveData = mediatorLiveData2;
        mediatorLiveData();
        Observer observer2 = observer;
        observer = new Observer<S>(mediatorLiveData, objectRef2, (LiveData)config){
            final /* synthetic */ MediatorLiveData $mergedSource;
            final /* synthetic */ Ref.ObjectRef $fetchState;
            final /* synthetic */ LiveData $pagedDataList;
            {
                this.$mergedSource = mediatorLiveData;
                this.$fetchState = objectRef;
                this.$pagedDataList = liveData;
            }

            public final void onChanged(PagedList<DataType> pagedList) {
                Object object = pagedList != null ? pagedList.getDataSource() : null;
                if (!(object instanceof GenericPaginationDataSource)) {
                    object = null;
                }
                if ((object = (GenericPaginationDataSource)((Object)object)) != null) {
                    buildLivePagedListWithState.1 v0 = this_;
                    v0.$mergedSource.removeSource((LiveData)((MutableLiveData)this_.$fetchState.element));
                    v0.$fetchState.element = object.getFetchState();
                    v0.$mergedSource.addSource((LiveData)((MutableLiveData)this_.$fetchState.element), new Observer<S>(this_){
                        final /* synthetic */ buildLivePagedListWithState.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void onChanged(ResourceState<? extends DataType> resourceState) {
                            Intrinsics.checkExpressionValueIsNotNull(resourceState, (String)"newFetchState");
                            buildLivePagedListWithState.1 v0 = this_.this$0;
                            buildLivePagedListWithState$1$$special$$inlined$let$lambda$1 this_ = v0.$pagedDataList;
                            PaginationBuilderKt.setMergedSourceDataByFetchState(resourceState, this_, v0.$mergedSource);
                        }
                    });
                }
                if ((object = (object = (ResourceState)((MutableLiveData)this_.$fetchState.element).getValue()) != null ? object.getStatus() : null) != null) {
                    int n = PaginationBuilderKt$WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
                    if (n != 1) {
                        if (n != 2) {
                            if (n == 3) {
                                buildLivePagedListWithState.1 v1 = this_;
                                buildLivePagedListWithState.1 this_ = v1.$mergedSource;
                                ResourceState.Companion companion = ResourceState.Companion;
                                Object object2 = (ResourceState)((MutableLiveData)v1.$fetchState.element).getValue();
                                if (object2 == null || (object2 = ((ResourceState)object2).getError()) == null) {
                                    BaseError baseError;
                                    object2 = baseError;
                                    baseError = new BaseError(null, 0, null, 7, null);
                                }
                                this_.setValue(companion.error((BaseError)object2, pagedList));
                            }
                        } else {
                            this_.$mergedSource.setValue(ResourceState.Companion.loading(pagedList));
                        }
                    } else {
                        this_.$mergedSource.setValue(ResourceState.Companion.success(pagedList));
                    }
                }
            }
        };
        mediatorLiveData2.addSource((LiveData)config, observer2);
        return mediatorLiveData2;
    }

    public static final <DataType> void setMergedSourceDataByFetchState(@NotNull ResourceState<? extends DataType> object, @NotNull LiveData<PagedList<DataType>> object2, @NotNull MediatorLiveData<ResourceState<PagedList<DataType>>> mediatorLiveData) {
        Intrinsics.checkParameterIsNotNull(object, (String)"fetchState");
        Intrinsics.checkParameterIsNotNull(object2, (String)"pagedDataList");
        Intrinsics.checkParameterIsNotNull(mediatorLiveData, (String)"mergedSource");
        int n = PaginationBuilderKt$WhenMappings.$EnumSwitchMapping$1[((ResourceState)object).getStatus().ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    ResourceState<DataType> resourceState = object;
                    object = ResourceState.Companion;
                    object2 = object2.getValue();
                    BaseError baseError = resourceState.getError();
                    if (baseError == null) {
                        BaseError baseError2;
                        baseError = baseError2;
                        baseError2 = new BaseError(null, 0, null, 7, null);
                    }
                    mediatorLiveData.setValue(((ResourceState.Companion)object).error(baseError, object2));
                }
            } else {
                mediatorLiveData.setValue(ResourceState.Companion.loading(object2.getValue()));
            }
        } else {
            mediatorLiveData.setValue(ResourceState.Companion.success(object2.getValue()));
        }
    }
}

