/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.session;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.lifecycle.LiveData;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import com.google.gson.reflect.TypeToken;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.streamlayer.common.session.CallAuthDetails;
import io.streamlayer.common.session.LiveDataSession;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.auth.User;
import io.streamlayer.sdk.model.auth.VoximplantUser;
import io.streamlayer.sdk.model.sdksettings.ClientSettings;
import io.streamlayer.sdk.model.sdksettings.OrganizationSettings;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.utils.GsonUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Lambda;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0001\u0018\u0000 \u00a0\u00012\u00020\u0001:\u0002\u00a0\u0001B\u0013\b\u0007\u0012\u0006\u0010f\u001a\u00020e\u00a2\u0006\u0006\b\u009e\u0001\u0010\u009f\u0001J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0015\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00170\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001dH\u0016\u00a2\u0006\u0004\b!\u0010\u001fJ\u0015\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0016\u00a2\u0006\u0004\b\"\u0010\u001fJ\u000f\u0010#\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b#\u0010\u0004J\u0017\u0010%\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b*\u0010&J\u001f\u0010,\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010/\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b/\u0010&J\u001f\u00101\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b1\u0010-J\u000f\u00102\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b2\u00103J\u0017\u00105\u001a\u00020\u00022\b\u00104\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b5\u0010(J\r\u00106\u001a\u00020\u0007\u00a2\u0006\u0004\b6\u0010\u000eJ\u0017\u00108\u001a\u00020\u00022\b\u00107\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b8\u00109J\u0015\u0010<\u001a\b\u0012\u0004\u0012\u00020;0:H\u0016\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010?\u001a\u00020\u00022\u0006\u0010>\u001a\u00020;H\u0016\u00a2\u0006\u0004\b?\u0010@J\u001b\u0010B\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070A0:H\u0016\u00a2\u0006\u0004\bB\u0010=J\u0017\u0010D\u001a\u00020\u00022\u0006\u0010C\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\bD\u0010EJ\u0015\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00130:H\u0016\u00a2\u0006\u0004\bF\u0010=J\u0015\u0010G\u001a\b\u0012\u0004\u0012\u00020 0:H\u0016\u00a2\u0006\u0004\bG\u0010=J\u0015\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dH\u0016\u00a2\u0006\u0004\bH\u0010\u001fJ\u0017\u0010I\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001dH\u0016\u00a2\u0006\u0004\bI\u0010\u001fJ\u001f\u0010K\u001a\u00020\u00022\u0006\u0010J\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\bK\u0010LJ\u0017\u0010M\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\bM\u0010&R$\u0010Q\u001a\u00020\u00072\u0006\u0010N\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bO\u0010\u000e\"\u0004\bP\u0010ER)\u0010U\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050A0\u001d8V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bR\u0010S\u001a\u0004\bT\u0010\u001fR\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00058V@\u0016X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u00103R(\u0010Y\u001a\u0004\u0018\u00010\u00052\b\u0010N\u001a\u0004\u0018\u00010\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bW\u00103\"\u0004\bX\u0010(R(\u0010]\u001a\u0004\u0018\u00010 2\b\u0010N\u001a\u0004\u0018\u00010 8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bG\u0010Z\"\u0004\b[\u0010\\R$\u0010`\u001a\u00020\u00052\u0006\u0010N\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b^\u00103\"\u0004\b_\u0010(R$\u0010a\u001a\u0004\u0018\u00010\u00058\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\ba\u0010b\u001a\u0004\bc\u00103\"\u0004\bd\u0010(R\u0016\u0010f\u001a\u00020e8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bf\u0010gR\u0016\u0010i\u001a\u00020h8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bi\u0010jR(\u0010p\u001a\u0004\u0018\u00010k2\b\u0010N\u001a\u0004\u0018\u00010k8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bl\u0010m\"\u0004\bn\u0010oR$\u0010q\u001a\u00020\u00172\u0006\u0010N\u001a\u00020\u00178V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bq\u0010\u0019\"\u0004\br\u0010sR(\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bF\u0010t\"\u0004\bu\u0010vR(\u0010y\u001a\u0004\u0018\u00010\u00052\b\u0010N\u001a\u0004\u0018\u00010\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bw\u00103\"\u0004\bx\u0010(R(\u0010|\u001a\u0004\u0018\u00010\u00052\b\u0010N\u001a\u0004\u0018\u00010\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bz\u00103\"\u0004\b{\u0010(R$\u0010\u007f\u001a\u00020\u00052\u0006\u0010N\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b}\u00103\"\u0004\b~\u0010(R!\u0010\u0083\u0001\u001a\u00020h8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\u000f\n\u0005\b\u0080\u0001\u0010S\u001a\u0006\b\u0081\u0001\u0010\u0082\u0001R/\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u0084\u00012\t\u0010N\u001a\u0005\u0018\u00010\u0084\u00018V@VX\u0096\u000e\u00a2\u0006\u0010\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001\"\u0006\b\u0087\u0001\u0010\u0088\u0001R(\u0010\u008c\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001d8V@\u0016X\u0096\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u008a\u0001\u0010S\u001a\u0005\b\u008b\u0001\u0010\u001fR5\u0010\u0091\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050A2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00050A8V@VX\u0096\u000e\u00a2\u0006\u0010\u001a\u0006\b\u008d\u0001\u0010\u008e\u0001\"\u0006\b\u008f\u0001\u0010\u0090\u0001R+\u0010\u0097\u0001\u001a\u00030\u0092\u00012\u0007\u0010N\u001a\u00030\u0092\u00018V@VX\u0096\u000e\u00a2\u0006\u0010\u001a\u0006\b\u0093\u0001\u0010\u0094\u0001\"\u0006\b\u0095\u0001\u0010\u0096\u0001R+\u0010\u009d\u0001\u001a\u00030\u0098\u00012\u0007\u0010N\u001a\u00030\u0098\u00018V@VX\u0096\u000e\u00a2\u0006\u0010\u001a\u0006\b\u0099\u0001\u0010\u009a\u0001\"\u0006\b\u009b\u0001\u0010\u009c\u0001\u00a8\u0006\u00a1\u0001"}, d2={"Lio/streamlayer/common/session/SessionPrefImpl;", "Lio/streamlayer/common/session/Session;", "", "clearLastReadMessageSequences", "()V", "", "topicId", "", "getLastReadMessageSeq", "(Ljava/lang/String;)I", "seqId", "setLastReadMessageSeq", "(Ljava/lang/String;I)V", "incrementTotalUnreadMessagesCount", "()I", "count", "decreaseTotalUnreadMessagesCount", "(I)I", "token", "Lio/streamlayer/sdk/model/auth/User;", "user", "setLoggedIn", "(Ljava/lang/String;Lio/streamlayer/sdk/model/auth/User;)V", "", "isLoggedIn", "()Z", "Lio/streamlayer/common/session/LiveDataSession;", "getUserLoggedInListener", "()Lio/streamlayer/common/session/LiveDataSession;", "Landroidx/lifecycle/LiveData;", "getUserListener", "()Landroidx/lifecycle/LiveData;", "Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "getClientSettingsListener", "getTotalUnreadMessagesCountListener", "logout", "permission", "checkPermissionAsked", "(Ljava/lang/String;)Z", "setPermissionAsked", "(Ljava/lang/String;)V", "stepName", "shouldSkipOnboardingStep", "skip", "setSkipOnboardingStep", "(Ljava/lang/String;Z)V", "tipSet", "isTipsShown", "shown", "setTipsShown", "apiBaseUrl", "()Ljava/lang/String;", "baseUrl", "setApiBaseUrl", "apiBasePort", "basePort", "setApiBasePort", "(Ljava/lang/Integer;)V", "Lio/reactivex/Observable;", "Lio/streamlayer/sdk/model/sdksettings/OrganizationSettings;", "getOrganizationSettings", "()Lio/reactivex/Observable;", "settings", "saveOrganizationSettings", "(Lio/streamlayer/sdk/model/sdksettings/OrganizationSettings;)V", "", "getInvitedContactIds", "contactId", "addInvitedContact", "(I)V", "getUser", "getClientSettings", "getSportsEventChangeListener", "getClientSettingsChangeListener", "muted", "setTopicMuted", "(ZLjava/lang/String;)V", "isTopicMuted", "value", "getTotalUnreadMessagesCount", "setTotalUnreadMessagesCount", "totalUnreadMessagesCount", "twitterAccountsListener$delegate", "Lkotlin/Lazy;", "getTwitterAccountsListener", "twitterAccountsListener", "getToken", "getTinodeUserId", "setTinodeUserId", "tinodeUserId", "()Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "setClientSettings", "(Lio/streamlayer/sdk/model/sdksettings/ClientSettings;)V", "clientSettings", "getCurrentEventId", "setCurrentEventId", "currentEventId", "activeCallId", "Ljava/lang/String;", "getActiveCallId", "setActiveCallId", "Landroid/content/Context;", "context", "Landroid/content/Context;", "Landroid/content/SharedPreferences;", "mSharedPreferences", "Landroid/content/SharedPreferences;", "Lio/streamlayer/sdk/model/auth/VoximplantUser;", "getVoximplantUser", "()Lio/streamlayer/sdk/model/auth/VoximplantUser;", "setVoximplantUser", "(Lio/streamlayer/sdk/model/auth/VoximplantUser;)V", "voximplantUser", "isFirebaseTokenChanged", "setFirebaseTokenChanged", "(Z)V", "()Lio/streamlayer/sdk/model/auth/User;", "setUser", "(Lio/streamlayer/sdk/model/auth/User;)V", "getCurrentSponsorAdUrl", "setCurrentSponsorAdUrl", "currentSponsorAdUrl", "getSdkKey", "setSdkKey", "sdkKey", "getFirebaseToken", "setFirebaseToken", "firebaseToken", "mEncryptedSharedPreferences$delegate", "getMEncryptedSharedPreferences", "()Landroid/content/SharedPreferences;", "mEncryptedSharedPreferences", "Lio/streamlayer/sdk/model/sports/EventSummary;", "getCurrentEvent", "()Lio/streamlayer/sdk/model/sports/EventSummary;", "setCurrentEvent", "(Lio/streamlayer/sdk/model/sports/EventSummary;)V", "currentEvent", "currentEventIdListener$delegate", "getCurrentEventIdListener", "currentEventIdListener", "getTwitterAccounts", "()Ljava/util/List;", "setTwitterAccounts", "(Ljava/util/List;)V", "twitterAccounts", "", "getLastPhoneContactSyncTimestamp", "()J", "setLastPhoneContactSyncTimestamp", "(J)V", "lastPhoneContactSyncTimestamp", "Lio/streamlayer/common/session/CallAuthDetails;", "getCallAuthDetails", "()Lio/streamlayer/common/session/CallAuthDetails;", "setCallAuthDetails", "(Lio/streamlayer/common/session/CallAuthDetails;)V", "callAuthDetails", "<init>", "(Landroid/content/Context;)V", "Companion", "sdk_originalRelease"})
public final class SessionPrefImpl
implements Session {
    private static final String KEY_SDK_KEY = "sdk_key";
    private static final String KEY_USER = "session_user";
    private static final String KEY_TINODE_USER_ID = "session_tinode_user_id";
    private static final String KEY_TOKEN = "session_token";
    private static final String KEY_TWITTER_ACCOUNTS = "session_twitter_accounts";
    private static final String KEY_CLIENT_SETTINGS = "session_client_settings";
    private static final String KEY_CURRENT_EVENT_ID = "current_event_id";
    private static final String KEY_CURRENT_EVENT = "current_event";
    private static final String KEY_MUTED_TOPIC = "muted_topic_";
    private static final String KEY_LAST_PHONE_CONTACT_SYNC_QUERY = "last_phone_contact_sync_timestamp";
    private static final String KEY_TOTAL_UNREAD_MESSAGES = "total_unread_messages";
    private static final String KEY_TOPIC_UNREAD_MESSAGES = "topic_unread_messages_";
    private static final String KEY_VOXIMPLANT_USER = "slr_voximplant_user";
    private static final String KEY_VOXIMPLANT_AUTH_DETAILS = "voximplant_auth_details";
    public static final Companion Companion = new Companion(null);
    private final SharedPreferences mSharedPreferences;
    private final Lazy mEncryptedSharedPreferences$delegate;
    @NotNull
    private final Lazy twitterAccountsListener$delegate;
    @NotNull
    private final Lazy currentEventIdListener$delegate;
    @Nullable
    private String activeCallId;
    private final Context context;

    private final SharedPreferences getMEncryptedSharedPreferences() {
        return (SharedPreferences)this.mEncryptedSharedPreferences$delegate.getValue();
    }

    private final void clearLastReadMessageSequences() {
        SessionPrefImpl sessionPrefImpl = sessionPrefImpl2;
        SessionPrefImpl sessionPrefImpl2 = sessionPrefImpl.mSharedPreferences.edit();
        Map map2 = sessionPrefImpl.mSharedPreferences.getAll();
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"mSharedPreferences.all");
        for (Map.Entry entry : map2.entrySet()) {
            Object k = entry.getKey();
            Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
            if (!StringsKt.startsWith$default((String)((String)k), (String)KEY_TOPIC_UNREAD_MESSAGES, (boolean)false, (int)2, null)) continue;
            sessionPrefImpl2.remove((String)entry.getKey());
        }
        sessionPrefImpl2.apply();
    }

    @Inject
    public SessionPrefImpl(@NotNull Context context) {
        SessionPrefImpl sessionPrefImpl = this;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        SharedPreferences sharedPreferences = context.getSharedPreferences("io.streamlayer.sdk_session", 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026xt.MODE_PRIVATE\n        )");
        sessionPrefImpl.mSharedPreferences = sharedPreferences;
        sessionPrefImpl.mEncryptedSharedPreferences$delegate = LazyKt.lazy((Function0)new Function0<SharedPreferences>(this){
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(0);
            }

            @NotNull
            public final SharedPreferences invoke() {
                mEncryptedSharedPreferences.2 this_ = EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV;
                EncryptedSharedPreferences.PrefValueEncryptionScheme prefValueEncryptionScheme = EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM;
                return EncryptedSharedPreferences.create((Context)SessionPrefImpl.access$getContext$p(this_.this$0), (String)"io.streamlayer.sdk_encrypted_session", (MasterKey)new MasterKey.Builder(SessionPrefImpl.access$getContext$p(this_.this$0), "_androidx_security_master_key_").setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build(), (EncryptedSharedPreferences.PrefKeyEncryptionScheme)this_, (EncryptedSharedPreferences.PrefValueEncryptionScheme)prefValueEncryptionScheme);
            }
        });
        sessionPrefImpl.twitterAccountsListener$delegate = LazyKt.lazy((Function0)new Function0<LiveDataSession<? super Set<? extends String>, List<? extends String>>>(this){
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(0);
            }

            @NotNull
            public final LiveDataSession<Set<String>, List<String>> invoke() {
                Lambda lambda2 = twitterAccountsListener.1.INSTANCE;
                return new LiveDataSession<Set<String>, List<String>>(true, SessionPrefImpl.access$getMSharedPreferences$p(lambda2.this$0), "session_twitter_accounts", (Function1<Set<String>, List<String>>)lambda2);
            }
        });
        sessionPrefImpl.currentEventIdListener$delegate = LazyKt.lazy((Function0)new Function0<LiveDataSession<? super String, String>>(this){
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(0);
            }

            @NotNull
            public final LiveDataSession<String, String> invoke() {
                return new LiveDataSession<String, String>(true, SessionPrefImpl.access$getMSharedPreferences$p(this.this$0), "current_event_id", null, 8, null);
            }
        });
    }

    public static final /* synthetic */ SharedPreferences access$getMSharedPreferences$p(SessionPrefImpl sessionPrefImpl) {
        return sessionPrefImpl.mSharedPreferences;
    }

    public static final /* synthetic */ Context access$getContext$p(SessionPrefImpl sessionPrefImpl) {
        return sessionPrefImpl.context;
    }

    @Override
    @Nullable
    public String getSdkKey() {
        return this.mSharedPreferences.getString(KEY_SDK_KEY, null);
    }

    @Override
    public void setSdkKey(@Nullable String string2) {
        this.mSharedPreferences.edit().putString(KEY_SDK_KEY, string2).apply();
    }

    @Override
    @Nullable
    public String getToken() {
        return this.mSharedPreferences.getString(KEY_TOKEN, null);
    }

    @Override
    @Nullable
    public User getUser() {
        return (User)GsonUtil.INSTANCE.getDefaultGson().fromJson(this.mSharedPreferences.getString(KEY_USER, null), User.class);
    }

    @Override
    public void setUser(@Nullable User user) {
        this.mSharedPreferences.edit().putString(KEY_USER, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)user)).apply();
    }

    @Override
    @Nullable
    public VoximplantUser getVoximplantUser() {
        return (VoximplantUser)GsonUtil.INSTANCE.getDefaultGson().fromJson(this.getMEncryptedSharedPreferences().getString(KEY_VOXIMPLANT_USER, null), VoximplantUser.class);
    }

    @Override
    public void setVoximplantUser(@Nullable VoximplantUser voximplantUser) {
        this.getMEncryptedSharedPreferences().edit().putString(KEY_VOXIMPLANT_USER, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)voximplantUser)).apply();
    }

    @Override
    @Nullable
    public String getTinodeUserId() {
        return this.mSharedPreferences.getString(KEY_TINODE_USER_ID, null);
    }

    @Override
    public void setTinodeUserId(@Nullable String string2) {
        this.mSharedPreferences.edit().putString(KEY_TINODE_USER_ID, string2).apply();
    }

    @Override
    @Nullable
    public ClientSettings getClientSettings() {
        return (ClientSettings)GsonUtil.INSTANCE.getDefaultGson().fromJson(this.mSharedPreferences.getString(KEY_CLIENT_SETTINGS, null), ClientSettings.class);
    }

    @Override
    public void setClientSettings(@Nullable ClientSettings clientSettings2) {
        this.mSharedPreferences.edit().putString(KEY_CLIENT_SETTINGS, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)clientSettings2)).apply();
    }

    @Override
    @NotNull
    public String getFirebaseToken() {
        Object object = ((SessionPrefImpl)object).mSharedPreferences.getString("firebase_token", "");
        if (object == null) {
            object = "";
        }
        return object;
    }

    @Override
    public void setFirebaseToken(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"value");
        this.mSharedPreferences.edit().putString("firebase_token", string2).apply();
    }

    @Override
    public boolean isFirebaseTokenChanged() {
        return this.mSharedPreferences.getBoolean("firebase_token_changed", true);
    }

    @Override
    public void setFirebaseTokenChanged(boolean bl) {
        this.mSharedPreferences.edit().putBoolean("firebase_token_changed", bl).apply();
    }

    @Override
    @Nullable
    public String getCurrentSponsorAdUrl() {
        return this.mSharedPreferences.getString("current_sponsor_ad_url", null);
    }

    @Override
    public void setCurrentSponsorAdUrl(@Nullable String string2) {
        this.mSharedPreferences.edit().putString("current_sponsor_ad_url", string2).apply();
    }

    @Override
    @NotNull
    public List<String> getTwitterAccounts() {
        Object object = ((SessionPrefImpl)object).mSharedPreferences.getStringSet(KEY_TWITTER_ACCOUNTS, null);
        if (object == null) {
            object = SetsKt.emptySet();
        }
        return CollectionsKt.toList((Iterable)object);
    }

    @Override
    public void setTwitterAccounts(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"value");
        this.mSharedPreferences.edit().putStringSet(KEY_TWITTER_ACCOUNTS, CollectionsKt.toSet(list)).apply();
    }

    @Override
    @NotNull
    public LiveData<List<String>> getTwitterAccountsListener() {
        return (LiveData)this.twitterAccountsListener$delegate.getValue();
    }

    @Override
    @NotNull
    public LiveData<String> getCurrentEventIdListener() {
        return (LiveData)this.currentEventIdListener$delegate.getValue();
    }

    @Override
    @NotNull
    public String getCurrentEventId() {
        Object object = ((SessionPrefImpl)object).mSharedPreferences.getString(KEY_CURRENT_EVENT_ID, "4756");
        if (object == null) {
            object = "4756";
        }
        return object;
    }

    @Override
    public void setCurrentEventId(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"value");
        this.mSharedPreferences.edit().putString(KEY_CURRENT_EVENT_ID, string2).apply();
    }

    @Override
    @Nullable
    public EventSummary getCurrentEvent() {
        return (EventSummary)GsonUtil.INSTANCE.getDefaultGson().fromJson(this.mSharedPreferences.getString(KEY_CURRENT_EVENT, null), EventSummary.class);
    }

    @Override
    public void setCurrentEvent(@Nullable EventSummary eventSummary) {
        this.mSharedPreferences.edit().putString(KEY_CURRENT_EVENT, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)eventSummary)).apply();
    }

    @Override
    public long getLastPhoneContactSyncTimestamp() {
        return this.mSharedPreferences.getLong(KEY_LAST_PHONE_CONTACT_SYNC_QUERY, 0L);
    }

    @Override
    public void setLastPhoneContactSyncTimestamp(long l) {
        this.mSharedPreferences.edit().putLong(KEY_LAST_PHONE_CONTACT_SYNC_QUERY, l).apply();
    }

    @Override
    public int getTotalUnreadMessagesCount() {
        return this.mSharedPreferences.getInt(KEY_TOTAL_UNREAD_MESSAGES, 0);
    }

    @Override
    public void setTotalUnreadMessagesCount(int n) {
        this.mSharedPreferences.edit().putInt(KEY_TOTAL_UNREAD_MESSAGES, n).apply();
    }

    @Override
    @Nullable
    public String getActiveCallId() {
        return this.activeCallId;
    }

    @Override
    public void setActiveCallId(@Nullable String string2) {
        this.activeCallId = string2;
    }

    @Override
    public int getLastReadMessageSeq(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        return this.mSharedPreferences.getInt(KEY_TOPIC_UNREAD_MESSAGES + string2, 0);
    }

    @Override
    public void setLastReadMessageSeq(@NotNull String string2, int n) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        this.mSharedPreferences.edit().putInt(KEY_TOPIC_UNREAD_MESSAGES + string2, n).apply();
    }

    public final int incrementTotalUnreadMessagesCount() {
        int n = this.getTotalUnreadMessagesCount() + 1;
        this.setTotalUnreadMessagesCount(n);
        return n;
    }

    public final int decreaseTotalUnreadMessagesCount(int n) {
        SessionPrefImpl sessionPrefImpl = this;
        sessionPrefImpl.setTotalUnreadMessagesCount(Math.max(0, sessionPrefImpl.getTotalUnreadMessagesCount() - n));
        return sessionPrefImpl.getTotalUnreadMessagesCount();
    }

    @Override
    public void setLoggedIn(@Nullable String string2, @Nullable User user) {
        this.mSharedPreferences.edit().putString(KEY_TOKEN, string2).putString(KEY_USER, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)user)).apply();
    }

    @Override
    public boolean isLoggedIn() {
        String string2 = this.getToken();
        return !(string2 == null || string2.length() == 0) && this.getUser() != null;
    }

    @NotNull
    public LiveDataSession<String, Boolean> getUserLoggedInListener() {
        Object object = getUserLoggedInListener.1.INSTANCE;
        return new LiveDataSession<String, Boolean>(true, object.mSharedPreferences, KEY_TOKEN, (Function1<String, Boolean>)object);
    }

    @Override
    @NotNull
    public LiveData<User> getUserListener() {
        Object object = getUserListener.1.INSTANCE;
        return new LiveDataSession(true, object.mSharedPreferences, KEY_USER, object);
    }

    @Override
    @NotNull
    public LiveData<ClientSettings> getClientSettingsListener() {
        Object object = getClientSettingsListener.1.INSTANCE;
        return new LiveDataSession(true, object.mSharedPreferences, KEY_CLIENT_SETTINGS, object);
    }

    @Override
    @NotNull
    public LiveData<Integer> getTotalUnreadMessagesCountListener() {
        return new LiveDataSession(true, this.mSharedPreferences, KEY_TOTAL_UNREAD_MESSAGES, null, 8, null);
    }

    @Override
    public void logout() {
        SessionPrefImpl sessionPrefImpl = this;
        sessionPrefImpl.setLoggedIn(null, null);
        sessionPrefImpl.setTinodeUserId(null);
        sessionPrefImpl.setClientSettings(null);
        sessionPrefImpl.setFirebaseTokenChanged(true);
        sessionPrefImpl.setTotalUnreadMessagesCount(0);
        sessionPrefImpl.setLastPhoneContactSyncTimestamp(0L);
        sessionPrefImpl.setVoximplantUser(null);
        sessionPrefImpl.clearLastReadMessageSequences();
    }

    @Override
    public boolean checkPermissionAsked(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"permission");
        return this.mSharedPreferences.contains("PERMISSION_ASKED_" + string2);
    }

    @Override
    public void setPermissionAsked(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"permission");
        this.mSharedPreferences.edit().putBoolean("PERMISSION_ASKED_" + string2, true).apply();
    }

    @Override
    public boolean shouldSkipOnboardingStep(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"stepName");
        return this.mSharedPreferences.getBoolean("onboarding_step_skip_" + string2, false);
    }

    @Override
    public void setSkipOnboardingStep(@NotNull String string2, boolean bl) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"stepName");
        this.mSharedPreferences.edit().putBoolean("onboarding_step_skip_" + string2, bl).apply();
    }

    @Override
    public boolean isTipsShown(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"tipSet");
        return this.mSharedPreferences.getBoolean(string2 + "_tips_shown", false);
    }

    @Override
    public void setTipsShown(@NotNull String string2, boolean bl) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"tipSet");
        this.mSharedPreferences.edit().putBoolean(string2 + "_tips_shown", bl).apply();
    }

    @Nullable
    public final String apiBaseUrl() {
        return this.mSharedPreferences.getString("abu", null);
    }

    public final void setApiBaseUrl(@Nullable String string2) {
        if (string2 != null) {
            this.mSharedPreferences.edit().putString("abu", string2).apply();
        } else {
            this.mSharedPreferences.edit().remove("abu").apply();
        }
    }

    public final int apiBasePort() {
        return this.mSharedPreferences.getInt("abp", 0);
    }

    public final void setApiBasePort(@Nullable Integer n) {
        if (n != null) {
            this.mSharedPreferences.edit().putInt("abp", n.intValue()).apply();
        } else {
            this.mSharedPreferences.edit().remove("abp").apply();
        }
    }

    @Override
    @NotNull
    public Observable<OrganizationSettings> getOrganizationSettings() {
        SessionPrefImpl sessionPrefImpl;
        if (sessionPrefImpl.mSharedPreferences.contains("organization_settings")) {
            sessionPrefImpl = Observable.just((Object)GsonUtil.INSTANCE.getDefaultGson().fromJson(sessionPrefImpl.mSharedPreferences.getString("organization_settings", "[]"), OrganizationSettings.class));
            Intrinsics.checkExpressionValueIsNotNull((Object)sessionPrefImpl, (String)"Observable.just(\n       \u2026          )\n            )");
        } else {
            sessionPrefImpl = Observable.empty();
            Intrinsics.checkExpressionValueIsNotNull((Object)sessionPrefImpl, (String)"Observable.empty()");
        }
        return sessionPrefImpl;
    }

    @Override
    public void saveOrganizationSettings(@NotNull OrganizationSettings organizationSettings) {
        Intrinsics.checkParameterIsNotNull((Object)organizationSettings, (String)"settings");
        this.mSharedPreferences.edit().putString("organization_settings", GsonUtil.INSTANCE.getDefaultGson().toJson((Object)organizationSettings)).apply();
    }

    @Override
    @NotNull
    public Observable<List<Integer>> getInvitedContactIds() {
        SessionPrefImpl sessionPrefImpl;
        if (sessionPrefImpl.mSharedPreferences.contains("invited_contact_ids")) {
            sessionPrefImpl = Observable.fromCallable(new Callable<T>(sessionPrefImpl){
                final /* synthetic */ SessionPrefImpl this$0;
                {
                    this.this$0 = sessionPrefImpl;
                }

                public final List<Integer> call() {
                    return (List)GsonUtil.INSTANCE.getDefaultGson().fromJson(SessionPrefImpl.access$getMSharedPreferences$p(this.this$0).getString("invited_contact_ids", "[]"), new TypeToken<ArrayList<Integer>>(){}.getType());
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)sessionPrefImpl, (String)"Observable.fromCallable<\u2026          )\n            }");
        } else {
            sessionPrefImpl = Observable.just((Object)CollectionsKt.emptyList());
            Intrinsics.checkExpressionValueIsNotNull((Object)sessionPrefImpl, (String)"Observable.just(listOf())");
        }
        return sessionPrefImpl;
    }

    @Override
    public void addInvitedContact(int n) {
        ArrayList<Integer> arrayList;
        Object object = arrayList;
        arrayList = new ArrayList<Integer>();
        if (this.mSharedPreferences.contains("invited_contact_ids")) {
            object = new TypeToken<ArrayList<Integer>>(){}.getType();
            object = GsonUtil.INSTANCE.getDefaultGson().fromJson(this.mSharedPreferences.getString("invited_contact_ids", "[]"), (Type)object);
            if (object != null) {
                object = (ArrayList)object;
            } else {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.ArrayList<kotlin.Int> /* = java.util.ArrayList<kotlin.Int> */");
            }
        }
        ((ArrayList)object).add(n);
        this.mSharedPreferences.edit().putString("invited_contact_ids", GsonUtil.INSTANCE.getDefaultGson().toJson(object)).apply();
    }

    @Override
    @NotNull
    public Observable<User> getUser() {
        Observable observable = Observable.create(new ObservableOnSubscribe<T>(this){
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
            }

            public final void subscribe(@NotNull ObservableEmitter<User> observableEmitter) {
                Intrinsics.checkParameterIsNotNull(observableEmitter, (String)"it");
                User user = user.this$0.getUser();
                if (user != null) {
                    observableEmitter.onNext((Object)user);
                }
                observableEmitter.onComplete();
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.create {\n    \u2026it.onComplete()\n        }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<ClientSettings> getClientSettings() {
        Observable observable = Observable.create(new ObservableOnSubscribe<T>(this){
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
            }

            public final void subscribe(@NotNull ObservableEmitter<ClientSettings> observableEmitter) {
                Intrinsics.checkParameterIsNotNull(observableEmitter, (String)"it");
                ClientSettings clientSettings2 = clientSettings2.this$0.getClientSettings();
                if (clientSettings2 != null) {
                    observableEmitter.onNext((Object)clientSettings2);
                }
                observableEmitter.onComplete();
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.create {\n    \u2026it.onComplete()\n        }");
        return observable;
    }

    @Override
    @NotNull
    public LiveData<String> getSportsEventChangeListener() {
        return new LiveDataSession(true, this.mSharedPreferences, KEY_TOKEN, null, 8, null);
    }

    @Override
    @NotNull
    public LiveData<ClientSettings> getClientSettingsChangeListener() {
        Object object = getClientSettingsChangeListener.1.INSTANCE;
        return new LiveDataSession(false, object.mSharedPreferences, KEY_CLIENT_SETTINGS, object);
    }

    @Override
    public void setTopicMuted(boolean bl, @NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        this.mSharedPreferences.edit().putBoolean(KEY_MUTED_TOPIC + string2, bl).apply();
    }

    @Override
    public boolean isTopicMuted(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        return this.mSharedPreferences.getBoolean(KEY_MUTED_TOPIC + string2, false);
    }

    @Override
    @NotNull
    public CallAuthDetails getCallAuthDetails() {
        Object object = GsonUtil.INSTANCE.getDefaultGson().fromJson(this.mSharedPreferences.getString(KEY_VOXIMPLANT_AUTH_DETAILS, "{}"), CallAuthDetails.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"GsonUtil.defaultGson.fro\u2026ils::class.java\n        )");
        return (CallAuthDetails)object;
    }

    @Override
    public void setCallAuthDetails(@NotNull CallAuthDetails callAuthDetails) {
        Intrinsics.checkParameterIsNotNull((Object)callAuthDetails, (String)"value");
        this.mSharedPreferences.edit().putString(KEY_VOXIMPLANT_AUTH_DETAILS, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)callAuthDetails)).apply();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0005\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0016\u0010\u0006\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0004R\u0016\u0010\u0007\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0004R\u0016\u0010\b\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0004R\u0016\u0010\t\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0004R\u0016\u0010\n\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0004R\u0016\u0010\u000b\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0004R\u0016\u0010\f\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0004R\u0016\u0010\r\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0004R\u0016\u0010\u000e\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0004R\u0016\u0010\u000f\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0004R\u0016\u0010\u0010\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0004R\u0016\u0010\u0011\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0004\u00a8\u0006\u0014"}, d2={"Lio/streamlayer/common/session/SessionPrefImpl$Companion;", "", "", "KEY_CLIENT_SETTINGS", "Ljava/lang/String;", "KEY_CURRENT_EVENT", "KEY_CURRENT_EVENT_ID", "KEY_LAST_PHONE_CONTACT_SYNC_QUERY", "KEY_MUTED_TOPIC", "KEY_SDK_KEY", "KEY_TINODE_USER_ID", "KEY_TOKEN", "KEY_TOPIC_UNREAD_MESSAGES", "KEY_TOTAL_UNREAD_MESSAGES", "KEY_TWITTER_ACCOUNTS", "KEY_USER", "KEY_VOXIMPLANT_AUTH_DETAILS", "KEY_VOXIMPLANT_USER", "<init>", "()V", "sdk_originalRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

