/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.chat;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.emoji.widget.EmojiEditText;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentContainerView;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentViewModelLazyKt;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.NavArgsLazy;
import androidx.paging.PagedList;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.mvvm.BaseFragment;
import io.streamlayer.common.mvvm.Event;
import io.streamlayer.common.mvvm.ResourceStateObserver;
import io.streamlayer.common.mvvm.basemodels.BaseError;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.mvvm.basemodels.Status;
import io.streamlayer.common.views.SLREmptyStatusView;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.calls.call.WatchPartyRouter;
import io.streamlayer.sdk.main.StreamLayerViewModel;
import io.streamlayer.sdk.messaging.ChatInviteViewModel;
import io.streamlayer.sdk.messaging.MessagingExtensionsKt;
import io.streamlayer.sdk.messaging.chat.ChatViewModel;
import io.streamlayer.sdk.messaging.chat.MessagingAdapter;
import io.streamlayer.sdk.messaging.chat.MessagingChatFragment;
import io.streamlayer.sdk.messaging.chat.MessagingChatFragment$setupUI$;
import io.streamlayer.sdk.messaging.chat.MessagingChatFragmentArgs;
import io.streamlayer.sdk.messaging.chat.ResendMessageDialog;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.usecases.CreateChatType;
import io.streamlayer.utils.ExtensionsKt;
import io.streamlayer.utils.TopSheetBehavior;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b4\u0010\bJ\u0019\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\bJ\u001d\u0010\u000e\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0014\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0006J-\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ!\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00192\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001f\u0010\bJ\u000f\u0010 \u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b \u0010\bJ\u0017\u0010\"\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\"\u0010\u0006R\u001d\u0010(\u001a\u00020#8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001d\u0010-\u001a\u00020)8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010%\u001a\u0004\b+\u0010,R\u0016\u0010/\u001a\u00020.8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0016\u00102\u001a\u0002018\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b2\u00103\u00a8\u00065"}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingChatFragment;", "Lio/streamlayer/common/mvvm/BaseFragment;", "Landroid/os/Bundle;", "savedInstanceState", "", "setupUI", "(Landroid/os/Bundle;)V", "submitMessage", "()V", "bind", "showMessagesEmpty", "Landroidx/paging/PagedList;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "messages", "showMessages", "(Landroidx/paging/PagedList;)V", "Lio/streamlayer/sdk/model/messaging/Chat;", "chat", "setCallButton", "(Lio/streamlayer/sdk/model/messaging/Chat;)V", "onCreate", "Landroid/view/LayoutInflater;", "inflater", "Landroid/view/ViewGroup;", "container", "Landroid/view/View;", "onCreateView", "(Landroid/view/LayoutInflater;Landroid/view/ViewGroup;Landroid/os/Bundle;)Landroid/view/View;", "view", "onViewCreated", "(Landroid/view/View;Landroid/os/Bundle;)V", "onResume", "onPause", "outState", "onSaveInstanceState", "Lio/streamlayer/sdk/messaging/chat/ChatViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "getViewModel", "()Lio/streamlayer/sdk/messaging/chat/ChatViewModel;", "viewModel", "Lio/streamlayer/sdk/main/StreamLayerViewModel;", "streamLayerViewModel$delegate", "getStreamLayerViewModel", "()Lio/streamlayer/sdk/main/StreamLayerViewModel;", "streamLayerViewModel", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;", "messagingAdapter", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;", "Landroidx/recyclerview/widget/LinearLayoutManager;", "chatLayoutManager", "Landroidx/recyclerview/widget/LinearLayoutManager;", "<init>", "sdk_originalRelease"})
public final class MessagingChatFragment
extends BaseFragment {
    private final Lazy streamLayerViewModel$delegate;
    private final Lazy viewModel$delegate;
    private MessagingAdapter messagingAdapter;
    private LinearLayoutManager chatLayoutManager;
    private HashMap _$_findViewCache;

    private final StreamLayerViewModel getStreamLayerViewModel() {
        return (StreamLayerViewModel)this.streamLayerViewModel$delegate.getValue();
    }

    private final ChatViewModel getViewModel() {
        return (ChatViewModel)((Object)this.viewModel$delegate.getValue());
    }

    private final void setupUI(Bundle object) {
        MessagingAdapter messagingAdapter;
        Function1<ChatMessage, Unit> function1;
        MessagingChatFragment messagingChatFragment = this;
        ExtensionsKt.setupToolbarWithNavController$default(messagingChatFragment, 0, null, null, 0, 0, 0, false, 127, null);
        TopSheetBehavior<FragmentContainerView> topSheetBehavior = TopSheetBehavior.from((FragmentContainerView)messagingChatFragment._$_findCachedViewById(R.id.chatParticipantsOverlayContainer));
        topSheetBehavior.setTopSheetCallback(new TopSheetBehavior.TopSheetCallback(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
            }

            public void onSlide(@NotNull View view, float f, @Nullable Boolean bl) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"topSheet");
            }

            public void onStateChanged(@NotNull View view, int n) {
                float f;
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"topSheet");
                if (n != 3) {
                    if (n != 4) {
                        return;
                    }
                    f = 0.0f;
                } else {
                    f = 90.0f;
                }
                ((AppCompatImageView)this.this$0._$_findCachedViewById(R.id.toolbarChatChevron)).animate().rotation(f).start();
            }
        });
        if (object != null) {
            TopSheetBehavior<FragmentContainerView> topSheetBehavior2 = topSheetBehavior;
            int n = object.getInt("participantsSheetState");
            Intrinsics.checkExpressionValueIsNotNull(topSheetBehavior2, (String)"overlayBehavior");
            topSheetBehavior2.setState(n);
        }
        TopSheetBehavior<FragmentContainerView> topSheetBehavior3 = topSheetBehavior;
        object = (AppCompatImageView)this._$_findCachedViewById(R.id.toolbarChatChevron);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"toolbarChatChevron");
        Intrinsics.checkExpressionValueIsNotNull(topSheetBehavior3, (String)"overlayBehavior");
        float f = topSheetBehavior3.getState() == 3 ? 90.0f : 0.0f;
        object.setRotation(f);
        object = function1;
        function1 = new Function1<ChatMessage, Unit>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(1);
            }

            public final void invoke(@NotNull ChatMessage chatMessage) {
                ResendMessageDialog resendMessageDialog;
                Function0<Unit> function0;
                Function0<Unit> function02;
                setupUI.alertClickListener.1 v0 = object;
                Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"message");
                Function0<Unit> function03 = function02;
                function02 = new Function0<Unit>(object, chatMessage){
                    final /* synthetic */ setupUI.alertClickListener.1 this$0;
                    final /* synthetic */ ChatMessage $message;
                    {
                        this.this$0 = var1_1;
                        this.$message = chatMessage;
                        super(0);
                    }

                    public final void invoke() {
                        setupUI.alertClickListener.resendClickHandler.1 v0 = this;
                        AnalyticsRepo.DefaultImpls.triggerInteractionEvent$default(v0.this$0.this$0.getAnalyticsRepo(), null, null, 3, null);
                        MessagingChatFragment.access$getViewModel$p(v0.this$0.this$0).resendMessage(this.$message);
                    }
                };
                Function0<Unit> function04 = function0;
                function0 = new Function0<Unit>(object, chatMessage){
                    final /* synthetic */ setupUI.alertClickListener.1 this$0;
                    final /* synthetic */ ChatMessage $message;
                    {
                        this.this$0 = var1_1;
                        this.$message = chatMessage;
                        super(0);
                    }

                    public final void invoke() {
                        setupUI.alertClickListener.removeClickHandler.1 v0 = this;
                        AnalyticsRepo.DefaultImpls.triggerInteractionEvent$default(v0.this$0.this$0.getAnalyticsRepo(), null, null, 3, null);
                        MessagingChatFragment.access$getViewModel$p(v0.this$0.this$0).removeMessage(this.$message);
                    }
                };
                Object object = resendMessageDialog;
                resendMessageDialog = new ResendMessageDialog(function03, (Function0<? extends Object>)function04);
                chatMessage = v0.this$0.getActivity();
                if (chatMessage != null && (chatMessage = chatMessage.getSupportFragmentManager()) != null) {
                    object.show((FragmentManager)chatMessage, null);
                }
            }
        };
        String string2 = this.getSession().getTinodeUserId();
        if (string2 == null) {
            string2 = "";
        }
        this.messagingAdapter = messagingAdapter = new MessagingAdapter(string2, (Function1<? super ChatMessage, Unit>)object);
        if (messagingAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messagingAdapter");
        }
        MessagingChatFragment messagingChatFragment2 = this;
        messagingAdapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
            }

            public void onItemRangeInserted(int n, int n2) {
                super.onItemRangeInserted(n, n2);
                if (n == 0 && MessagingChatFragment.access$getChatLayoutManager$p(this.this$0).findFirstVisibleItemPosition() < 2) {
                    MessagingChatFragment.access$getChatLayoutManager$p(this.this$0).scrollToPosition(0);
                }
            }
        });
        messagingChatFragment2.chatLayoutManager = new LinearLayoutManager(this.requireContext(), 1, true);
        object = (RecyclerView)messagingChatFragment2._$_findCachedViewById(R.id.messagesList);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"messagesList");
        messagingAdapter = messagingChatFragment2.chatLayoutManager;
        if (messagingAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatLayoutManager");
        }
        MessagingChatFragment messagingChatFragment3 = this;
        object.setLayoutManager((RecyclerView.LayoutManager)messagingAdapter);
        EmojiEditText emojiEditText = (EmojiEditText)messagingChatFragment3._$_findCachedViewById(R.id.chatMessageInput);
        Intrinsics.checkExpressionValueIsNotNull((Object)emojiEditText, (String)"chatMessageInput");
        emojiEditText.addTextChangedListener(new TextWatcher(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
            }

            public void afterTextChanged(@Nullable Editable editable) {
                setupUI$$inlined$addTextChangedListener$1 this_ = (ImageButton)this_.this$0._$_findCachedViewById(R.id.chatMessageSendFAB);
                Intrinsics.checkExpressionValueIsNotNull((Object)this_, (String)"chatMessageSendFAB");
                boolean bl = editable == null || editable.length() == 0;
                io.streamlayer.common.kotlin.ExtensionsKt.visibleIfElse$default((View)this_, bl ^ true, 0, 2, null);
            }

            public void beforeTextChanged(@Nullable CharSequence charSequence, int n, int n2, int n3) {
            }

            public void onTextChanged(@Nullable CharSequence charSequence, int n, int n2, int n3) {
            }
        });
        ((ImageButton)messagingChatFragment3._$_findCachedViewById(R.id.chatMessageSendFAB)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
            }

            public final void onClick(View view) {
                setupUI.5 v0 = this;
                AnalyticsRepo.DefaultImpls.triggerInteractionEvent$default(v0.this$0.getAnalyticsRepo(), null, null, 3, null);
                MessagingChatFragment.access$submitMessage(v0.this$0);
            }
        });
        ((ConstraintLayout)messagingChatFragment3._$_findCachedViewById(R.id.toolbarTitleContainer)).setOnClickListener(new View.OnClickListener(this, topSheetBehavior){
            final /* synthetic */ MessagingChatFragment this$0;
            final /* synthetic */ TopSheetBehavior $overlayBehavior;
            {
                this.this$0 = messagingChatFragment;
                this.$overlayBehavior = topSheetBehavior;
            }

            public final void onClick(View view) {
                setupUI.6 v0 = this;
                AnalyticsRepo.DefaultImpls.triggerInteractionEvent$default(v0.this$0.getAnalyticsRepo(), null, null, 3, null);
                TopSheetBehavior topSheetBehavior = v0.$overlayBehavior;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)topSheetBehavior), (String)"overlayBehavior");
                if (topSheetBehavior.getState() == 3) {
                    setupUI.6 v2 = this;
                    ((AppCompatImageView)v2.this$0._$_findCachedViewById(R.id.toolbarChatChevron)).animate().rotation(0.0f).start();
                    TopSheetBehavior topSheetBehavior2 = v2.$overlayBehavior;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)topSheetBehavior2), (String)"overlayBehavior");
                    topSheetBehavior2.setState(4);
                } else {
                    setupUI.6 v4 = this;
                    ((AppCompatImageView)v4.this$0._$_findCachedViewById(R.id.toolbarChatChevron)).animate().rotation(90.0f).start();
                    TopSheetBehavior topSheetBehavior3 = v4.$overlayBehavior;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)topSheetBehavior3), (String)"overlayBehavior");
                    topSheetBehavior3.setState(3);
                }
            }
        });
        ((RecyclerView)messagingChatFragment3._$_findCachedViewById(R.id.messagesList)).addOnScrollListener(new RecyclerView.OnScrollListener(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
            }

            public void onScrolled(@NotNull RecyclerView object, int n, int n2) {
                Intrinsics.checkParameterIsNotNull((Object)object, (String)"recyclerView");
                super.onScrolled((RecyclerView)object, n, n2);
                if (n2 < 0 && MessagingChatFragment.access$getChatLayoutManager$p(chatViewModel2.this$0).findLastVisibleItemPosition() > MessagingChatFragment.access$getMessagingAdapter$p(chatViewModel2.this$0).getItemCount() - 30) {
                    setupUI.7 v0 = chatViewModel2;
                    ChatViewModel chatViewModel2 = MessagingChatFragment.access$getViewModel$p(v0.this$0);
                    object = MessagingChatFragment.access$getMessagingAdapter$p(v0.this$0).getCurrentList();
                    int n3 = object != null && (object = (ChatMessage)CollectionsKt.last((List)object)) != null ? ((ChatMessage)object).getSeq() : -1;
                    chatViewModel2.loadBefore(n3);
                }
            }
        });
    }

    private final void submitMessage() {
        MessagingChatFragment messagingChatFragment = string2;
        EmojiEditText emojiEditText = (EmojiEditText)messagingChatFragment._$_findCachedViewById(R.id.chatMessageInput);
        Intrinsics.checkExpressionValueIsNotNull((Object)emojiEditText, (String)"chatMessageInput");
        String string2 = emojiEditText.getText().toString();
        EmojiEditText emojiEditText2 = (EmojiEditText)messagingChatFragment._$_findCachedViewById(R.id.chatMessageInput);
        Intrinsics.checkExpressionValueIsNotNull((Object)emojiEditText2, (String)"chatMessageInput");
        emojiEditText2.setText(null);
        messagingChatFragment.getViewModel().sendMessage(string2);
    }

    private final void bind() {
        Function1<BaseError, Unit> function1;
        MessagingChatFragment messagingChatFragment = this;
        Function1<BaseError, Unit> function12 = function1;
        function1 = new Function1<BaseError, Unit>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(1);
            }

            public final void invoke(@NotNull BaseError baseError) {
                bind.2 v0 = this;
                Intrinsics.checkParameterIsNotNull((Object)baseError, (String)"it");
                v0.this$0.showProgressCircle(false);
                v0.this$0.showError(baseError.getErrorMessage());
                RecyclerView recyclerView = (RecyclerView)v0.this$0._$_findCachedViewById(R.id.messagesList);
                Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"messagesList");
                if (recyclerView.getAdapter() == null) {
                    RecyclerView recyclerView2 = (RecyclerView)this.this$0._$_findCachedViewById(R.id.messagesList);
                    Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView2, (String)"messagesList");
                    recyclerView2.setAdapter((RecyclerView.Adapter)MessagingChatFragment.access$getMessagingAdapter$p(this.this$0));
                }
            }
        };
        messagingChatFragment.getViewModel().getChat().observe(this.getViewLifecycleOwner(), new ResourceStateObserver(this, (Function1)new Function1<Chat, Unit>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(1);
            }

            public final void invoke(@Nullable Chat chat) {
                if (chat != null) {
                    Object object;
                    String string2 = this.this$0.getSession().getTinodeUserId();
                    if (string2 == null) {
                        string2 = "";
                    }
                    ChatType chatType = ChatType.P2P;
                    if (chat.getChatType() != chatType && MessagingExtensionsKt.participantsWithoutUser(chat, string2).size() != 1) {
                        bind.1 v0 = this;
                        object = (AppCompatTextView)v0.this$0._$_findCachedViewById(R.id.toolbarTitle);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"toolbarTitle");
                        Object object2 = v0.this$0.getContext();
                        object2 = object2 != null ? object2.getString(R.string.slr_messaging_chat_group_title, new Object[]{MessagingExtensionsKt.participantsWithoutUser(chat, string2).size()}) : null;
                        object.setText((CharSequence)object2);
                        ImageView imageView = (ImageView)this.this$0._$_findCachedViewById(R.id.toolbarChatAvatar);
                        Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"toolbarChatAvatar");
                        io.streamlayer.common.kotlin.ExtensionsKt.gone((View)imageView);
                    } else {
                        bind.1 v2 = this;
                        AppCompatTextView appCompatTextView = (AppCompatTextView)v2.this$0._$_findCachedViewById(R.id.toolbarTitle);
                        Intrinsics.checkExpressionValueIsNotNull((Object)appCompatTextView, (String)"toolbarTitle");
                        MessagingExtensionsKt.setChatName((TextView)appCompatTextView, chat, string2);
                        ImageView imageView = (ImageView)v2.this$0._$_findCachedViewById(R.id.toolbarChatAvatar);
                        Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"toolbarChatAvatar");
                        MessagingExtensionsKt.loadChatImage(imageView, chat, string2);
                        ImageView imageView2 = (ImageView)v2.this$0._$_findCachedViewById(R.id.toolbarChatAvatar);
                        Intrinsics.checkExpressionValueIsNotNull((Object)imageView2, (String)"toolbarChatAvatar");
                        io.streamlayer.common.kotlin.ExtensionsKt.visible((View)imageView2);
                    }
                    object = MessagingChatFragment.access$getMessagingAdapter$p(this.this$0);
                    if (chat.getChatType() != chatType && MessagingExtensionsKt.participantsWithoutUser(chat, string2).size() != 1) {
                        chatType = ChatType.Group;
                    }
                    ((MessagingAdapter)((Object)object)).setMode(chatType);
                    RecyclerView recyclerView = (RecyclerView)this.this$0._$_findCachedViewById(R.id.messagesList);
                    Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"messagesList");
                    if (recyclerView.getAdapter() == null) {
                        RecyclerView recyclerView2 = (RecyclerView)this.this$0._$_findCachedViewById(R.id.messagesList);
                        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView2, (String)"messagesList");
                        recyclerView2.setAdapter((RecyclerView.Adapter)MessagingChatFragment.access$getMessagingAdapter$p(this.this$0));
                    }
                    bind.1 v8 = this;
                    int n = chat.getSeq() - this.this$0.getSession().getLastReadMessageSeq(chat.getChatId());
                    v8.this$0.getSession().decreaseTotalUnreadMessagesCount(n);
                    Chat chat2 = chat;
                    String string3 = chat2.getChatId();
                    v8.this$0.getSession().setLastReadMessageSeq(string3, chat2.getSeq());
                    MessagingChatFragment.access$setCallButton(v8.this$0, chat);
                }
            }
        }, null, (Function1)function12, false, 20, null));
        messagingChatFragment.getViewModel().getChatMessages().observe(this.getViewLifecycleOwner(), new Observer<PagedList<ChatMessage>>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
            }

            public final void onChanged(PagedList<ChatMessage> pagedList) {
                PagedList<ChatMessage> pagedList2 = pagedList;
                pagedList2.toString();
                boolean bl = pagedList2 == null || pagedList.isEmpty();
                if (bl) {
                    MessagingChatFragment.access$showMessagesEmpty(this.this$0);
                } else {
                    MessagingChatFragment.access$showMessages(this.this$0, pagedList);
                }
            }
        });
        messagingChatFragment.getViewModel().getLoading().observe(this.getViewLifecycleOwner(), new ResourceStateObserver(this, (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(1);
            }

            public final void invoke(@Nullable Boolean bl) {
                MessagingChatFragment messagingChatFragment = messagingChatFragment.this$0;
                boolean bl2 = bl != null ? bl : false;
                messagingChatFragment.showProgressCircle(bl2);
            }
        }, null, null, false, 28, null));
        messagingChatFragment.getViewModel().getNetworkConnectionLiveData().observe(this.getViewLifecycleOwner(), new Observer<Boolean>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
            }

            public final void onChanged(Boolean bl) {
                View view = this.this$0._$_findCachedViewById(R.id.slWaitingNetworkView);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"slWaitingNetworkView");
                io.streamlayer.common.kotlin.ExtensionsKt.visibleIf(view, bl ^ true);
            }
        });
        messagingChatFragment.getViewModel().getShowCallButton().observe(this.getViewLifecycleOwner(), new ResourceStateObserver(this, (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(1);
            }

            public final void invoke(@Nullable Boolean bl) {
                if (bl != null) {
                    boolean bl2 = bl;
                    AppCompatImageButton appCompatImageButton = (AppCompatImageButton)this.this$0._$_findCachedViewById(R.id.toolbarRightOptionBtn);
                    Intrinsics.checkExpressionValueIsNotNull((Object)appCompatImageButton, (String)"toolbarRightOptionBtn");
                    io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)appCompatImageButton, bl2);
                }
            }
        }, null, null, false, 28, null));
        messagingChatFragment.getViewModel().getCreatedChat().observe(this.getViewLifecycleOwner(), new Observer<ResourceState<? extends Event<? extends Chat>>>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
            }

            public final void onChanged(ResourceState<? extends Event<Chat>> object) {
                Object object2 = this.this$0;
                boolean bl = ((ResourceState)object).getStatus() == Status.LOADING;
                ((BaseFragment)object2).showLoader(bl);
                object2 = ((ResourceState)object).getError();
                if (object2 != null && (object2 = ((BaseError)object2).getErrorMessage()) != null) {
                    this.this$0.showError((String)object2);
                }
                if ((object = ((ResourceState)object).getData()) != null && (object = (Chat)((Event)object).getContentIfNotHandled()) != null && (this = MessagingChatFragment.access$getStreamLayerViewModel$p(this.this$0).getWatchPartyRouter()) != null) {
                    WatchPartyRouter.openWatchParty$default((WatchPartyRouter)this, ((Chat)object).getChatId(), null, 2, null);
                }
            }
        });
    }

    private final void showMessagesEmpty() {
        MessagingChatFragment messagingChatFragment = this;
        RecyclerView recyclerView = (RecyclerView)messagingChatFragment._$_findCachedViewById(R.id.messagesList);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"messagesList");
        io.streamlayer.common.kotlin.ExtensionsKt.invisible((View)recyclerView);
        SLREmptyStatusView sLREmptyStatusView = (SLREmptyStatusView)messagingChatFragment._$_findCachedViewById(R.id.messagingChatEmpty);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sLREmptyStatusView), (String)"messagingChatEmpty");
        io.streamlayer.common.kotlin.ExtensionsKt.visible((View)sLREmptyStatusView);
    }

    private final void showMessages(PagedList<ChatMessage> pagedList) {
        Runnable runnable2;
        MessagingAdapter messagingAdapter = this.messagingAdapter;
        if (messagingAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messagingAdapter");
        }
        boolean bl = messagingAdapter.getItemCount() == 0;
        Object object = this.messagingAdapter;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messagingAdapter");
        }
        MessagingAdapter messagingAdapter2 = object;
        object = runnable2;
        runnable2 = new Runnable(this, bl){
            final /* synthetic */ MessagingChatFragment this$0;
            final /* synthetic */ boolean $firstSubmit;
            {
                this.this$0 = messagingChatFragment;
                this.$firstSubmit = bl;
            }

            public final void run() {
                if (this.$firstSubmit) {
                    showMessages.1 v0 = this;
                    SLREmptyStatusView sLREmptyStatusView = (SLREmptyStatusView)v0.this$0._$_findCachedViewById(R.id.messagingChatEmpty);
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sLREmptyStatusView), (String)"messagingChatEmpty");
                    io.streamlayer.common.kotlin.ExtensionsKt.invisible((View)sLREmptyStatusView);
                    RecyclerView recyclerView = (RecyclerView)v0.this$0._$_findCachedViewById(R.id.messagesList);
                    Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"messagesList");
                    io.streamlayer.common.kotlin.ExtensionsKt.visible((View)recyclerView);
                }
            }
        };
        messagingAdapter2.submitList(pagedList, (Runnable)object);
    }

    private final void setCallButton(Chat chat) {
        ((AppCompatImageButton)this._$_findCachedViewById(R.id.toolbarRightOptionBtn)).setOnClickListener(new View.OnClickListener(this, chat){
            final /* synthetic */ MessagingChatFragment this$0;
            final /* synthetic */ Chat $chat;
            {
                this.this$0 = messagingChatFragment;
                this.$chat = chat;
            }

            public final void onClick(View view) {
                ArrayList<String> arrayList;
                if (MessagingExtensionsKt.participantsWithoutUser(object.$chat, object.this$0.getSession().getTinodeUserId()).size() > 8) {
                    MessagingChatFragment messagingChatFragment = object.this$0;
                    String string2 = messagingChatFragment.getResources().getString(R.string.slr_max_count_of_participants_is_reached, new Object[]{String.valueOf(9)});
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resources.getString(\n   \u2026g()\n                    )");
                    messagingChatFragment.showError(string2);
                    return;
                }
                setCallButton.1 v2 = object;
                Object object = MessagingChatFragment.access$getViewModel$p(v2.this$0);
                view = null;
                Object object2 = v2.$chat.getParticipants();
                ArrayList<String> arrayList2 = arrayList;
                arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    arrayList2.add(((TinodeContact)object2.next()).getChatUserId());
                }
                Object object3 = object;
                object = CreateChatType.Call;
                ChatInviteViewModel.createAndInvite$default((ChatInviteViewModel)((Object)object3), (String)view, arrayList2, null, (CreateChatType)((Object)object), 5, null);
            }
        });
    }

    public MessagingChatFragment() {
        Function0<Fragment> function0;
        Function0<ViewModelProvider.Factory> function02;
        Function0<ViewModelProvider.Factory> function03;
        Function0<Fragment> function04;
        MessagingChatFragment messagingChatFragment = this;
        Object object = function04;
        function04 = new Function0<Fragment>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(0);
            }

            @NotNull
            public final Fragment invoke() {
                Fragment fragment = this.this$0.requireParentFragment().requireParentFragment();
                Intrinsics.checkExpressionValueIsNotNull((Object)fragment, (String)"requireParentFragment().requireParentFragment()");
                return fragment;
            }
        };
        Object object2 = function03;
        function03 = new Function0<ViewModelProvider.Factory>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                return this.this$0.getViewModelFactory();
            }
        };
        messagingChatFragment.streamLayerViewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)messagingChatFragment, (KClass)Reflection.getOrCreateKotlinClass(StreamLayerViewModel.class), (Function0)new Function0<ViewModelStore>((Function0)object){
            final /* synthetic */ Function0 $ownerProducer;
            {
                this.$ownerProducer = function0;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = ((ViewModelStoreOwner)this.$ownerProducer.invoke()).getViewModelStore();
                Intrinsics.checkExpressionValueIsNotNull((Object)viewModelStore, (String)"ownerProducer().viewModelStore");
                return viewModelStore;
            }
        }, (Function0)object2);
        object = function02;
        function02 = new Function0<ViewModelProvider.Factory>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                return this.this$0.getViewModelFactory();
            }
        };
        object2 = function0;
        function0 = new Function0<Fragment>((Fragment)this){
            final /* synthetic */ Fragment $this_viewModels;
            {
                this.$this_viewModels = fragment;
                super(0);
            }

            @NotNull
            public final Fragment invoke() {
                return this.$this_viewModels;
            }
        };
        messagingChatFragment.viewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)messagingChatFragment, (KClass)Reflection.getOrCreateKotlinClass(ChatViewModel.class), (Function0)new Function0<ViewModelStore>((Function0)object2){
            final /* synthetic */ Function0 $ownerProducer;
            {
                this.$ownerProducer = function0;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = ((ViewModelStoreOwner)this.$ownerProducer.invoke()).getViewModelStore();
                Intrinsics.checkExpressionValueIsNotNull((Object)viewModelStore, (String)"ownerProducer().viewModelStore");
                return viewModelStore;
            }
        }, (Function0)object);
    }

    public static final /* synthetic */ ChatViewModel access$getViewModel$p(MessagingChatFragment messagingChatFragment) {
        return messagingChatFragment.getViewModel();
    }

    public static final /* synthetic */ LinearLayoutManager access$getChatLayoutManager$p(MessagingChatFragment messagingChatFragment) {
        messagingChatFragment = messagingChatFragment.chatLayoutManager;
        if (messagingChatFragment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatLayoutManager");
        }
        return messagingChatFragment;
    }

    public static final /* synthetic */ void access$setChatLayoutManager$p(MessagingChatFragment messagingChatFragment, LinearLayoutManager linearLayoutManager) {
        messagingChatFragment.chatLayoutManager = linearLayoutManager;
    }

    public static final /* synthetic */ void access$submitMessage(MessagingChatFragment messagingChatFragment) {
        messagingChatFragment.submitMessage();
    }

    public static final /* synthetic */ MessagingAdapter access$getMessagingAdapter$p(MessagingChatFragment object) {
        object = object.messagingAdapter;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messagingAdapter");
        }
        return object;
    }

    public static final /* synthetic */ void access$setMessagingAdapter$p(MessagingChatFragment messagingChatFragment, MessagingAdapter messagingAdapter) {
        messagingChatFragment.messagingAdapter = messagingAdapter;
    }

    public static final /* synthetic */ void access$setCallButton(MessagingChatFragment messagingChatFragment, Chat chat) {
        messagingChatFragment.setCallButton(chat);
    }

    public static final /* synthetic */ void access$showMessagesEmpty(MessagingChatFragment messagingChatFragment) {
        messagingChatFragment.showMessagesEmpty();
    }

    public static final /* synthetic */ void access$showMessages(MessagingChatFragment messagingChatFragment, PagedList pagedList) {
        messagingChatFragment.showMessages((PagedList<ChatMessage>)pagedList);
    }

    public static final /* synthetic */ StreamLayerViewModel access$getStreamLayerViewModel$p(MessagingChatFragment messagingChatFragment) {
        return messagingChatFragment.getStreamLayerViewModel();
    }

    public void onCreate(@Nullable Bundle bundle) {
        MessagingChatFragment messagingChatFragment = this;
        super.onCreate(bundle);
        messagingChatFragment.getViewModel().init(((MessagingChatFragmentArgs)new NavArgsLazy(Reflection.getOrCreateKotlinClass(MessagingChatFragmentArgs.class), (Function0)new Function0<Bundle>((Fragment)this){
            final /* synthetic */ Fragment $this_navArgs;
            {
                this.$this_navArgs = fragment;
                super(0);
            }

            @NotNull
            public final Bundle invoke() {
                Bundle bundle = this.$this_navArgs.getArguments();
                if (bundle != null) {
                    return bundle;
                }
                throw new IllegalStateException("Fragment " + this.$this_navArgs + " has null arguments");
            }
        }).getValue()).getChatId());
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        LayoutInflater layoutInflater2 = layoutInflater;
        Intrinsics.checkParameterIsNotNull((Object)layoutInflater2, (String)"inflater");
        return layoutInflater2.inflate(R.layout.slr_fragment_chat, viewGroup, false);
    }

    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle bundle) {
        MessagingChatFragment messagingChatFragment = this;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super.onViewCreated(view, bundle);
        messagingChatFragment.setupUI(bundle);
        messagingChatFragment.bind();
    }

    public void onResume() {
        MessagingChatFragment messagingChatFragment = this;
        super.onResume();
        messagingChatFragment.getInAppNotificationsService().pauseNotifications(true, ((MessagingChatFragmentArgs)new NavArgsLazy(Reflection.getOrCreateKotlinClass(MessagingChatFragmentArgs.class), (Function0)new Function0<Bundle>((Fragment)this){
            final /* synthetic */ Fragment $this_navArgs;
            {
                this.$this_navArgs = fragment;
                super(0);
            }

            @NotNull
            public final Bundle invoke() {
                Bundle bundle = this.$this_navArgs.getArguments();
                if (bundle != null) {
                    return bundle;
                }
                throw new IllegalStateException("Fragment " + this.$this_navArgs + " has null arguments");
            }
        }).getValue()).getChatId());
    }

    public void onPause() {
        MessagingChatFragment messagingChatFragment = this;
        super.onPause();
        messagingChatFragment.getInAppNotificationsService().pauseNotifications(false, ((MessagingChatFragmentArgs)new NavArgsLazy(Reflection.getOrCreateKotlinClass(MessagingChatFragmentArgs.class), (Function0)new Function0<Bundle>((Fragment)this){
            final /* synthetic */ Fragment $this_navArgs;
            {
                this.$this_navArgs = fragment;
                super(0);
            }

            @NotNull
            public final Bundle invoke() {
                Bundle bundle = this.$this_navArgs.getArguments();
                if (bundle != null) {
                    return bundle;
                }
                throw new IllegalStateException("Fragment " + this.$this_navArgs + " has null arguments");
            }
        }).getValue()).getChatId());
    }

    public void onSaveInstanceState(@NotNull Bundle bundle) {
        MessagingChatFragment messagingChatFragment = messagingChatFragment2;
        Bundle bundle2 = bundle;
        Intrinsics.checkParameterIsNotNull((Object)bundle2, (String)"outState");
        super.onSaveInstanceState(bundle2);
        MessagingChatFragment messagingChatFragment2 = (FragmentContainerView)messagingChatFragment._$_findCachedViewById(R.id.chatParticipantsOverlayContainer);
        if (messagingChatFragment2 != null) {
            TopSheetBehavior<MessagingChatFragment> topSheetBehavior = TopSheetBehavior.from(messagingChatFragment2);
            Intrinsics.checkExpressionValueIsNotNull(topSheetBehavior, (String)"TopSheetBehavior.from(it)");
            bundle.putInt("participantsSheetState", topSheetBehavior.getState());
        }
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            View view2;
            view = view2;
            view2 = new HashMap();
            this._$_findViewCache = view;
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.getView();
            if (view == null) {
                return null;
            }
            view = view.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        HashMap hashMap = ((MessagingChatFragment)((Object)hashMap))._$_findViewCache;
        if (hashMap != null) {
            hashMap.clear();
        }
    }

    @Override
    public /* synthetic */ void onDestroyView() {
        MessagingChatFragment messagingChatFragment = this;
        super.onDestroyView();
        messagingChatFragment._$_clearFindViewByIdCache();
    }
}

