/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.messaging;

import android.database.Cursor;
import androidx.collection.ArrayMap;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.calls.WatchPartyConnectionStatus;
import io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus;
import io.streamlayer.sdk.model.calls.WatchPartyRelation;
import io.streamlayer.sdk.model.calls.WatchPartyStatus;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageRelation;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageUpdate;
import io.streamlayer.sdk.model.messaging.ChatOwnerCrossRef;
import io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef;
import io.streamlayer.sdk.model.messaging.ChatRelation;
import io.streamlayer.sdk.model.messaging.WaveMessage;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.model.tinodecontact.TinodePhoto;
import io.streamlayer.sdk.model.tinodecontact.TopicPublicData;
import io.streamlayer.sdk.repository.messaging.MessagingDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public final class MessagingDao_Impl
implements MessagingDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage;
    private final Converters __converters;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage_1;
    private final EntityInsertionAdapter<ChatOwnerCrossRef> __insertionAdapterOfChatOwnerCrossRef;
    private final EntityInsertionAdapter<Chat> __insertionAdapterOfChat;
    private final EntityInsertionAdapter<ChatParticipantCrossRef> __insertionAdapterOfChatParticipantCrossRef;
    private final EntityInsertionAdapter<WaveMessage> __insertionAdapterOfWaveMessage;
    private final EntityDeletionOrUpdateAdapter<ChatMessage> __deletionAdapterOfChatMessage;
    private final EntityDeletionOrUpdateAdapter<WaveMessage> __deletionAdapterOfWaveMessage;
    private final EntityDeletionOrUpdateAdapter<ChatMessageUpdate> __updateAdapterOfChatMessageUpdateAsChatMessage;
    private final SharedSQLiteStatement __preparedStmtOfDeleteMessages;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChats;
    private final SharedSQLiteStatement __preparedStmtOfDeleteWaveEvents;

    public MessagingDao_Impl(RoomDatabase roomDatabase) {
        SharedSQLiteStatement sharedSQLiteStatement;
        SharedSQLiteStatement sharedSQLiteStatement2;
        SharedSQLiteStatement sharedSQLiteStatement3;
        EntityDeletionOrUpdateAdapter<ChatMessageUpdate> entityDeletionOrUpdateAdapter;
        EntityDeletionOrUpdateAdapter<WaveMessage> entityDeletionOrUpdateAdapter2;
        EntityDeletionOrUpdateAdapter<ChatMessage> entityDeletionOrUpdateAdapter3;
        EntityInsertionAdapter<WaveMessage> entityInsertionAdapter;
        EntityInsertionAdapter<ChatParticipantCrossRef> entityInsertionAdapter2;
        EntityInsertionAdapter<Chat> entityInsertionAdapter3;
        EntityInsertionAdapter<ChatOwnerCrossRef> entityInsertionAdapter4;
        EntityInsertionAdapter<ChatMessage> entityInsertionAdapter5;
        EntityInsertionAdapter<ChatMessage> entityInsertionAdapter6;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter6;
        entityInsertionAdapter6 = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `ChatMessage` (`chatMessageTopicId`,`chatMessageSeq`,`senderUserId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                long l = chatMessage.getSeq();
                supportSQLiteStatement.bindLong(2, l);
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, chatMessage.getSenderUserId());
                }
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(4, l3);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, (String)object);
                }
            }
        };
        this.__insertionAdapterOfChatMessage = converters2;
        converters2 = entityInsertionAdapter5;
        entityInsertionAdapter5 = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatMessage` (`chatMessageTopicId`,`chatMessageSeq`,`senderUserId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                long l = chatMessage.getSeq();
                supportSQLiteStatement.bindLong(2, l);
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, chatMessage.getSenderUserId());
                }
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(4, l3);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, (String)object);
                }
            }
        };
        this.__insertionAdapterOfChatMessage_1 = converters2;
        converters2 = entityInsertionAdapter4;
        entityInsertionAdapter4 = new EntityInsertionAdapter<ChatOwnerCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatOwnerCrossRef` (`chatId`,`chatUserId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatOwnerCrossRef chatOwnerCrossRef) {
                if (chatOwnerCrossRef.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatOwnerCrossRef.getChatId());
                }
                if (chatOwnerCrossRef.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatOwnerCrossRef.getChatUserId());
                }
            }
        };
        this.__insertionAdapterOfChatOwnerCrossRef = converters2;
        converters2 = entityInsertionAdapter3;
        entityInsertionAdapter3 = new EntityInsertionAdapter<Chat>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Chat` (`chatId`,`name`,`seq`,`readSeq`,`recvSeq`,`updatedAt`,`touchedAt`,`externalId`,`fn`,`title`,`tags`,`watchPartyStreamId`,`data`,`format`,`want`,`given`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Chat chat) {
                Object object;
                if (chat.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chat.getChatId());
                }
                if (chat.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chat.getName());
                }
                long l = chat.getSeq();
                supportSQLiteStatement.bindLong(3, l);
                l = chat.getReadSeq();
                supportSQLiteStatement.bindLong(4, l);
                l = chat.getRecvSeq();
                supportSQLiteStatement.bindLong(5, l);
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chat.getUpdatedAt());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(6, l3);
                }
                Long l4 = object.MessagingDao_Impl.this.__converters.dateToString(chat.getTouchedAt());
                if (l4 == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    long l5 = l4;
                    supportSQLiteStatement.bindLong(7, l5);
                }
                TopicPublicData topicPublicData = chat.getPublicDataData();
                if (topicPublicData != null) {
                    if (topicPublicData.getExternalId() == null) {
                        supportSQLiteStatement.bindNull(8);
                    } else {
                        supportSQLiteStatement.bindString(8, topicPublicData.getExternalId());
                    }
                    if (topicPublicData.getFn() == null) {
                        supportSQLiteStatement.bindNull(9);
                    } else {
                        supportSQLiteStatement.bindString(9, topicPublicData.getFn());
                    }
                    if (topicPublicData.getTitle() == null) {
                        supportSQLiteStatement.bindNull(10);
                    } else {
                        supportSQLiteStatement.bindString(10, topicPublicData.getTitle());
                    }
                    object = object.MessagingDao_Impl.this.__converters.stringListToString(topicPublicData.getTags());
                    if (object == null) {
                        supportSQLiteStatement.bindNull(11);
                    } else {
                        supportSQLiteStatement.bindString(11, (String)object);
                    }
                    if (topicPublicData.getWatchPartyStreamId() == null) {
                        supportSQLiteStatement.bindNull(12);
                    } else {
                        supportSQLiteStatement.bindString(12, topicPublicData.getWatchPartyStreamId());
                    }
                    object = topicPublicData.getPhoto();
                    if (object != null) {
                        if (((TinodePhoto)object).getData() == null) {
                            supportSQLiteStatement.bindNull(13);
                        } else {
                            supportSQLiteStatement.bindString(13, ((TinodePhoto)object).getData());
                        }
                        if (((TinodePhoto)object).getFormat() == null) {
                            supportSQLiteStatement.bindNull(14);
                        } else {
                            supportSQLiteStatement.bindString(14, ((TinodePhoto)object).getFormat());
                        }
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                        supportSQLiteStatement2.bindNull(13);
                        supportSQLiteStatement2.bindNull(14);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                    supportSQLiteStatement3.bindNull(8);
                    supportSQLiteStatement3.bindNull(9);
                    supportSQLiteStatement3.bindNull(10);
                    supportSQLiteStatement3.bindNull(11);
                    supportSQLiteStatement3.bindNull(12);
                    supportSQLiteStatement3.bindNull(13);
                    supportSQLiteStatement3.bindNull(14);
                }
                object = chat.getAccess();
                if (object != null) {
                    if (((Access)object).getWant() == null) {
                        supportSQLiteStatement.bindNull(15);
                    } else {
                        supportSQLiteStatement.bindString(15, ((Access)object).getWant());
                    }
                    if (((Access)object).getGiven() == null) {
                        supportSQLiteStatement.bindNull(16);
                    } else {
                        supportSQLiteStatement.bindString(16, ((Access)object).getGiven());
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement4 = supportSQLiteStatement;
                    supportSQLiteStatement4.bindNull(15);
                    supportSQLiteStatement4.bindNull(16);
                }
            }
        };
        this.__insertionAdapterOfChat = converters2;
        converters2 = entityInsertionAdapter2;
        entityInsertionAdapter2 = new EntityInsertionAdapter<ChatParticipantCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatParticipantCrossRef` (`chatId`,`chatUserId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatParticipantCrossRef chatParticipantCrossRef) {
                if (chatParticipantCrossRef.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatParticipantCrossRef.getChatId());
                }
                if (chatParticipantCrossRef.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatParticipantCrossRef.getChatUserId());
                }
            }
        };
        this.__insertionAdapterOfChatParticipantCrossRef = converters2;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<WaveMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `WaveMessage` (`chatUserId`,`userName`,`userAvatar`,`sentAt`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WaveMessage waveMessage) {
                if (waveMessage.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, waveMessage.getChatUserId());
                }
                if (waveMessage.getUserName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, waveMessage.getUserName());
                }
                if (waveMessage.getUserAvatar() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, waveMessage.getUserAvatar());
                }
                Long l = l.MessagingDao_Impl.this.__converters.dateToString(waveMessage.getSentAt());
                if (l == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    long l2 = l;
                    supportSQLiteStatement.bindLong(4, l2);
                }
            }
        };
        this.__insertionAdapterOfWaveMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter3;
        entityDeletionOrUpdateAdapter3 = new EntityDeletionOrUpdateAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `ChatMessage` WHERE `chatMessageTopicId` = ? AND `chatMessageSeq` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                long l = chatMessage.getSeq();
                supportSQLiteStatement.bindLong(2, l);
            }
        };
        this.__deletionAdapterOfChatMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter2;
        entityDeletionOrUpdateAdapter2 = new EntityDeletionOrUpdateAdapter<WaveMessage>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `WaveMessage` WHERE `chatUserId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WaveMessage waveMessage) {
                if (waveMessage.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, waveMessage.getChatUserId());
                }
            }
        };
        this.__deletionAdapterOfWaveMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter;
        entityDeletionOrUpdateAdapter = new EntityDeletionOrUpdateAdapter<ChatMessageUpdate>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `ChatMessage` SET `chatMessageTopicId` = ?,`chatMessageSeq` = ?,`status` = ? WHERE `chatMessageTopicId` = ? AND `chatMessageSeq` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessageUpdate chatMessageUpdate) {
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessageUpdate.getTopicId());
                }
                long l = chatMessageUpdate.getSeq();
                supportSQLiteStatement.bindLong(2, l);
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessageUpdate.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, chatMessageUpdate.getTopicId());
                }
                long l2 = chatMessageUpdate.getSeq();
                supportSQLiteStatement.bindLong(5, l2);
            }
        };
        this.__updateAdapterOfChatMessageUpdateAsChatMessage = converters2;
        converters2 = sharedSQLiteStatement3;
        sharedSQLiteStatement3 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatMessage WHERE chatMessageTopicId = ? AND status = ?";
            }
        };
        this.__preparedStmtOfDeleteMessages = converters2;
        converters2 = sharedSQLiteStatement2;
        sharedSQLiteStatement2 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Chat";
            }
        };
        this.__preparedStmtOfDeleteChats = converters2;
        converters2 = sharedSQLiteStatement;
        sharedSQLiteStatement = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM WaveMessage WHERE sentAt <= ?";
            }
        };
        this.__preparedStmtOfDeleteWaveEvents = converters2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact(ArrayMap<String, TinodeContact> var1_1) {
        block60: {
            var2_2 = var1_1.keySet();
            if (var2_2.isEmpty()) {
                return;
            }
            if (var1_1.size() > 999) {
                var2_2 = v0;
                v0 = new ArrayMap(999);
                var3_5 = 0;
                var5_10 = var1_1.size();
                for (var4_7 = 0; var4_7 < var5_10; ++var4_7) {
                    var2_2.put(var1_1.keyAt(var4_7), null);
                    if (++var3_5 != 999) continue;
                    this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)var2_2);
                    var1_1.putAll((Map)var2_2);
                    var2_2 = v1;
                    v1 = new ArrayMap(999);
                    var3_5 = 0;
                }
                if (var3_5 > 0) {
                    this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)var2_2);
                    var1_1.putAll((Map)var2_2);
                }
                return;
            }
            v2 = StringUtil.newStringBuilder();
            v2.append("SELECT `chatUserId`,`chatToken`,`chatExpiration`,`chatName`,`online`,`lastFullSync`,`photoData`,`privateData`,`externalId`,`fn`,`title`,`tags`,`watchPartyStreamId`,`data`,`format` FROM `TinodeContact` WHERE `chatUserId` IN (");
            var2_3 = var2_2.size();
            StringUtil.appendPlaceholders((StringBuilder)v2, (int)var2_3);
            v2.append(")");
            var2_4 = RoomSQLiteQuery.acquire((String)v2.toString(), (int)(var2_3 + 0));
            var3_6 = 1;
            for (String var5_11 : var2_2) {
                if (var5_11 == null) {
                    var2_4.bindNull(var3_6);
                } else {
                    var2_4.bindString(var3_6, var5_11);
                }
                ++var3_6;
            }
            var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)false, null);
            var3_6 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatUserId");
            if (var3_6 != -1) break block60;
            var2_4.close();
            return;
        }
        v3 = var2_4;
        v4 = v3;
        v5 = v3;
        v6 = v3;
        v7 = v3;
        v8 = v3;
        v9 = v3;
        v10 = v3;
        v11 = v3;
        v12 = v3;
        v13 = v3;
        v14 = v3;
        v15 = v3;
        v16 = v3;
        v17 = v3;
        var4_9 = CursorUtil.getColumnIndexOrThrow((Cursor)v3, (String)"chatUserId");
        var5_12 = CursorUtil.getColumnIndexOrThrow((Cursor)v15, (String)"chatToken");
        var6_13 = CursorUtil.getColumnIndexOrThrow((Cursor)v16, (String)"chatExpiration");
        var7_14 = CursorUtil.getColumnIndexOrThrow((Cursor)v17, (String)"chatName");
        var8_15 = CursorUtil.getColumnIndexOrThrow((Cursor)v13, (String)"online");
        var9_16 = CursorUtil.getColumnIndexOrThrow((Cursor)v14, (String)"lastFullSync");
        var10_17 = CursorUtil.getColumnIndexOrThrow((Cursor)v11, (String)"photoData");
        var11_18 = CursorUtil.getColumnIndexOrThrow((Cursor)v12, (String)"privateData");
        var12_19 = CursorUtil.getColumnIndexOrThrow((Cursor)v9, (String)"externalId");
        var13_20 = CursorUtil.getColumnIndexOrThrow((Cursor)v10, (String)"fn");
        var14_21 = CursorUtil.getColumnIndexOrThrow((Cursor)v7, (String)"title");
        var15_22 = CursorUtil.getColumnIndexOrThrow((Cursor)v8, (String)"tags");
        var16_23 = CursorUtil.getColumnIndexOrThrow((Cursor)v5, (String)"watchPartyStreamId");
        var17_24 = CursorUtil.getColumnIndexOrThrow((Cursor)v6, (String)"data");
        try {
            var18_25 = CursorUtil.getColumnIndexOrThrow((Cursor)v4, (String)"format");
        }
        catch (Throwable v48) {
            var2_4.close();
            throw v48;
        }
        while (true) {
            block67: {
                block66: {
                    block65: {
                        block64: {
                            block63: {
                                block62: {
                                    block61: {
                                        if (!var2_4.moveToNext()) break;
                                        v18 = var1_1;
                                        var19_26 = var2_4.getString(var3_6);
                                        if (!v18.containsKey((Object)var19_26)) continue;
                                        v19 = var2_4;
                                        v20 = var6_13;
                                        v21 = var2_4;
                                        v22 = var5_12;
                                        var20_27 = var2_4.getString(var4_9);
                                        var21_28 = v21.getString(v22);
                                        if (!v19.isNull(v20)) break block61;
                                        var22_29 /* !! */  = null;
                                        break block62;
                                    }
                                    var22_29 /* !! */  = var2_4.getLong(var6_13);
                                }
                                v23 = var2_4;
                                v24 = var8_15;
                                v25 = var2_4;
                                v26 = var7_14;
                                var22_29 /* !! */  = this.__converters.timestampToDate(var22_29 /* !! */ );
                                var23_30 = v25.getString(v26);
                                var24_31 = v23.getInt(v24) != 0;
                                if (!var2_4.isNull(var9_16)) break block63;
                                var25_32 /* !! */  = null;
                                break block64;
                            }
                            var25_32 /* !! */  = var2_4.getLong(var9_16);
                        }
                        v27 = var2_4;
                        v28 = var12_19;
                        v29 = var2_4;
                        v30 = var11_18;
                        v31 = var2_4;
                        v32 = var10_17;
                        var25_32 /* !! */  = this.__converters.timestampToDate(var25_32 /* !! */ );
                        var26_33 = v31.getString(v32);
                        var27_34 = v29.getString(v30);
                        if (!v27.isNull(v28)) break block65;
                        if (!var2_4.isNull(var13_20)) break block65;
                        if (!var2_4.isNull(var14_21)) break block65;
                        if (!var2_4.isNull(var15_22)) break block65;
                        if (!var2_4.isNull(var16_23)) break block65;
                        if (!var2_4.isNull(var17_24)) break block65;
                        if (!var2_4.isNull(var18_25)) break block65;
                        var28_35 = null;
                        var33_40 = var28_35;
                        ** GOTO lbl206
                    }
                    v33 = var2_4;
                    v34 = var17_24;
                    v35 = var2_4;
                    v36 = var16_23;
                    v37 = this;
                    v38 = var2_4;
                    v39 = var15_22;
                    v40 = var2_4;
                    v41 = var14_21;
                    v42 = var2_4;
                    v43 = var13_20;
                    var28_35 = var2_4.getString(var12_19);
                    var29_36 = v42.getString(v43);
                    var30_37 = v40.getString(v41);
                    var31_38 = v38.getString(v39);
                    var31_38 = v37.__converters.stringToStringList((String)var31_38);
                    var32_39 = v35.getString(v36);
                    if (!v33.isNull(v34)) break block66;
                    if (!var2_4.isNull(var18_25)) break block66;
                    var35_42 = var33_40 = null;
                    break block67;
                }
                v44 = var2_4;
                v45 = var18_25;
                var33_40 = var2_4.getString(var17_24);
                var34_41 = v44.getString(v45);
                var35_42 = v46;
                v46 = new TinodePhoto((String)var33_40, var34_41);
            }
            var33_40 = v47;
            v47 = new TopicPublicData(var28_35, var29_36, var30_37, (TinodePhoto)var35_42, (List<String>)var31_38, var32_39);
lbl206:
            // 2 sources

            var1_1.put((Object)var19_26, (Object)new TinodeContact(var20_27, var21_28, (Date)var22_29 /* !! */ , var23_30, var24_31, (Date)var25_32 /* !! */ , var26_33, var27_34, (TopicPublicData)var33_40));
        }
        var2_4.close();
        return;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1(ArrayMap<String, ArrayList<TinodeContact>> var1_1) {
        var2_2 = var1_1.keySet();
        if (var2_2.isEmpty()) {
            return;
        }
        if (var1_1.size() > 999) {
            var2_2 = v0;
            v0 = new ArrayMap(999);
            var3_5 = 0;
            var5_11 = var1_1.size();
            for (var4_8 = 0; var4_8 < var5_11; ++var4_8) {
                v1 = var1_1;
                var3_6 = v1.keyAt(var4_8);
                var2_2.put(var3_6, v1.valueAt(var4_8));
                if (++var3_5 != 999) continue;
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)var2_2);
                var2_2 = v2;
                v2 = new ArrayMap(999);
                var3_5 = 0;
            }
            if (var3_5 > 0) {
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)var2_2);
            }
            return;
        }
        v3 = StringUtil.newStringBuilder();
        v3.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`chatToken` AS `chatToken`,`TinodeContact`.`chatExpiration` AS `chatExpiration`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`lastFullSync` AS `lastFullSync`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`fn` AS `fn`,`TinodeContact`.`title` AS `title`,`TinodeContact`.`tags` AS `tags`,`TinodeContact`.`watchPartyStreamId` AS `watchPartyStreamId`,`TinodeContact`.`data` AS `data`,`TinodeContact`.`format` AS `format`,_junction.`chatId` FROM `ChatParticipantCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        var2_3 = var2_2.size();
        StringUtil.appendPlaceholders((StringBuilder)v3, (int)var2_3);
        v3.append(")");
        var2_4 = RoomSQLiteQuery.acquire((String)v3.toString(), (int)(var2_3 + 0));
        var3_7 = 1;
        for (String var5_12 : var2_2) {
            if (var5_12 == null) {
                var2_4.bindNull(var3_7);
            } else {
                var2_4.bindString(var3_7, var5_12);
            }
            ++var3_7;
        }
        var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)false, null);
        var3_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"chatUserId");
        var4_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"chatToken");
        var5_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"chatExpiration");
        var6_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"chatName");
        var7_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"online");
        var8_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"lastFullSync");
        var9_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"photoData");
        var10_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"privateData");
        var11_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"externalId");
        var12_20 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"fn");
        var13_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"title");
        var14_22 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"tags");
        var15_23 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"watchPartyStreamId");
        var16_24 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"data");
        try {
            var17_25 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"format");
        }
        catch (Throwable v33) {
            var2_4.close();
            throw v33;
        }
        while (true) {
            block64: {
                block63: {
                    block62: {
                        block61: {
                            block60: {
                                block59: {
                                    block58: {
                                        if (!var2_4.moveToNext()) break;
                                        var18_26 = (ArrayList)var1_1.get((Object)var2_4.getString(15));
                                        if (var18_26 == null) continue;
                                        v4 = var2_4;
                                        v5 = var5_13;
                                        v6 = var2_4;
                                        v7 = var4_10;
                                        var19_27 = var2_4.getString(var3_7);
                                        var20_28 = v6.getString(v7);
                                        if (!v4.isNull(v5)) break block58;
                                        var21_29 /* !! */  = null;
                                        break block59;
                                    }
                                    var21_29 /* !! */  = var2_4.getLong(var5_13);
                                }
                                v8 = var2_4;
                                v9 = var7_15;
                                v10 = var2_4;
                                v11 = var6_14;
                                var21_29 /* !! */  = this.__converters.timestampToDate(var21_29 /* !! */ );
                                var22_30 = v10.getString(v11);
                                var23_31 = v8.getInt(v9) != 0;
                                if (!var2_4.isNull(var8_16)) break block60;
                                var24_32 /* !! */  = null;
                                break block61;
                            }
                            var24_32 /* !! */  = var2_4.getLong(var8_16);
                        }
                        v12 = var2_4;
                        v13 = var11_19;
                        v14 = var2_4;
                        v15 = var10_18;
                        v16 = var2_4;
                        v17 = var9_17;
                        var24_32 /* !! */  = this.__converters.timestampToDate(var24_32 /* !! */ );
                        var25_33 = v16.getString(v17);
                        var26_34 = v14.getString(v15);
                        if (!v12.isNull(v13)) break block62;
                        if (!var2_4.isNull(var12_20)) break block62;
                        if (!var2_4.isNull(var13_21)) break block62;
                        if (!var2_4.isNull(var14_22)) break block62;
                        if (!var2_4.isNull(var15_23)) break block62;
                        if (!var2_4.isNull(var16_24)) break block62;
                        if (!var2_4.isNull(var17_25)) break block62;
                        var27_35 = null;
                        var32_40 = var27_35;
                        ** GOTO lbl183
                    }
                    v18 = var2_4;
                    v19 = var16_24;
                    v20 = var2_4;
                    v21 = var15_23;
                    v22 = this;
                    v23 = var2_4;
                    v24 = var14_22;
                    v25 = var2_4;
                    v26 = var13_21;
                    v27 = var2_4;
                    v28 = var12_20;
                    var27_35 = var2_4.getString(var11_19);
                    var28_36 = v27.getString(v28);
                    var29_37 = v25.getString(v26);
                    var30_38 = v23.getString(v24);
                    var30_38 = v22.__converters.stringToStringList((String)var30_38);
                    var31_39 = v20.getString(v21);
                    if (!v18.isNull(v19)) break block63;
                    if (!var2_4.isNull(var17_25)) break block63;
                    var34_42 = var32_40 = null;
                    break block64;
                }
                v29 = var2_4;
                v30 = var17_25;
                var32_40 = var2_4.getString(var16_24);
                var33_41 = v29.getString(v30);
                var34_42 = v31;
                v31 = new TinodePhoto((String)var32_40, var33_41);
            }
            var32_40 = v32;
            v32 = new TopicPublicData(var27_35, var28_36, var29_37, (TinodePhoto)var34_42, (List<String>)var30_38, var31_39);
lbl183:
            // 2 sources

            var18_26.add(new TinodeContact(var19_27, var20_28, (Date)var21_29 /* !! */ , var22_30, var23_31, (Date)var24_32 /* !! */ , var25_33, var26_34, (TopicPublicData)var32_40));
        }
        var2_4.close();
        return;
    }

    private void __fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage(ArrayMap<String, ArrayList<ChatMessage>> arrayMap) {
        int n;
        int n2;
        RoomSQLiteQuery roomSQLiteQuery;
        block34: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n3 = 0;
                int n4 = arrayMap.size();
                for (int j = 0; j < n4; ++j) {
                    ArrayMap arrayMap3;
                    ArrayMap<String, ArrayList<ChatMessage>> arrayMap4 = arrayMap;
                    Object object = arrayMap4.keyAt(j);
                    set.put(object, arrayMap4.valueAt(j));
                    if (++n3 != 999) continue;
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatMessageTopicId`,`chatMessageSeq`,`senderUserId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status` FROM `ChatMessage` WHERE `chatMessageTopicId` IN (");
            int n5 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
            n2 = 1;
            for (String string2 : set) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                ++n2;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatMessageTopicId");
            if (n2 != -1) break block34;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery7 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery8 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery9 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery10 = roomSQLiteQuery2;
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery2, (String)"chatMessageTopicId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery8, (String)"chatMessageSeq");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery9, (String)"senderUserId");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery10, (String)"date");
        int n10 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery6, (String)"text");
        int n11 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery7, (String)"type");
        int n12 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery4, (String)"subtype");
        int n13 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery5, (String)"replyTo");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery3, (String)"status");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            Object object;
            String string3;
            int n14;
            String string4;
            Cloneable cloneable;
            block36: {
                block35: {
                    if (!roomSQLiteQuery.moveToNext()) break;
                    cloneable = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(n2));
                    if (cloneable == null) continue;
                    RoomSQLiteQuery roomSQLiteQuery11 = roomSQLiteQuery;
                    int n15 = n9;
                    RoomSQLiteQuery roomSQLiteQuery12 = roomSQLiteQuery;
                    int n16 = n8;
                    RoomSQLiteQuery roomSQLiteQuery13 = roomSQLiteQuery;
                    int n17 = n7;
                    string4 = roomSQLiteQuery.getString(n6);
                    n14 = roomSQLiteQuery13.getInt(n17);
                    string3 = roomSQLiteQuery12.getString(n16);
                    if (!roomSQLiteQuery11.isNull(n15)) break block35;
                    object = null;
                    break block36;
                }
                object = roomSQLiteQuery.getLong(n9);
            }
            ArrayList arrayList = cloneable;
            MessagingDao_Impl messagingDao_Impl = this;
            RoomSQLiteQuery roomSQLiteQuery14 = roomSQLiteQuery;
            int n18 = n;
            RoomSQLiteQuery roomSQLiteQuery15 = roomSQLiteQuery;
            int n19 = n13;
            RoomSQLiteQuery roomSQLiteQuery16 = roomSQLiteQuery;
            int n20 = n12;
            RoomSQLiteQuery roomSQLiteQuery17 = roomSQLiteQuery;
            int n21 = n11;
            RoomSQLiteQuery roomSQLiteQuery18 = roomSQLiteQuery;
            int n22 = n10;
            cloneable = this.__converters.timestampToDate((Long)object);
            object = roomSQLiteQuery18.getString(n22);
            String string5 = roomSQLiteQuery17.getString(n21);
            String string6 = roomSQLiteQuery16.getString(n20);
            String string7 = roomSQLiteQuery15.getString(n19);
            Object object2 = roomSQLiteQuery14.getString(n18);
            object2 = messagingDao_Impl.__converters.stringToChatStatus((String)object2);
            arrayList.add(new ChatMessage(string4, n14, string3, (Date)cloneable, (String)object, string5, string6, string7, (ChatMessageStatus)((Object)object2)));
        }
        roomSQLiteQuery.close();
        return;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_2(ArrayMap<String, TinodeContact> var1_1) {
        var2_2 = var1_1.keySet();
        if (var2_2.isEmpty()) {
            return;
        }
        if (var1_1.size() > 999) {
            var2_2 = v0;
            v0 = new ArrayMap(999);
            var3_5 = 0;
            var5_10 = var1_1.size();
            for (var4_7 = 0; var4_7 < var5_10; ++var4_7) {
                var2_2.put(var1_1.keyAt(var4_7), null);
                if (++var3_5 != 999) continue;
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_2((ArrayMap<String, TinodeContact>)var2_2);
                var1_1.putAll((Map)var2_2);
                var2_2 = v1;
                v1 = new ArrayMap(999);
                var3_5 = 0;
            }
            if (var3_5 > 0) {
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_2((ArrayMap<String, TinodeContact>)var2_2);
                var1_1.putAll((Map)var2_2);
            }
            return;
        }
        v2 = StringUtil.newStringBuilder();
        v2.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`chatToken` AS `chatToken`,`TinodeContact`.`chatExpiration` AS `chatExpiration`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`lastFullSync` AS `lastFullSync`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`fn` AS `fn`,`TinodeContact`.`title` AS `title`,`TinodeContact`.`tags` AS `tags`,`TinodeContact`.`watchPartyStreamId` AS `watchPartyStreamId`,`TinodeContact`.`data` AS `data`,`TinodeContact`.`format` AS `format`,_junction.`chatId` FROM `ChatOwnerCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        var2_3 = var2_2.size();
        StringUtil.appendPlaceholders((StringBuilder)v2, (int)var2_3);
        v2.append(")");
        var2_4 = RoomSQLiteQuery.acquire((String)v2.toString(), (int)(var2_3 + 0));
        var3_6 = 1;
        for (String var5_11 : var2_2) {
            if (var5_11 == null) {
                var2_4.bindNull(var3_6);
            } else {
                var2_4.bindString(var3_6, var5_11);
            }
            ++var3_6;
        }
        var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)false, null);
        var3_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"chatUserId");
        var4_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"chatToken");
        var5_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"chatExpiration");
        var6_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"chatName");
        var7_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"online");
        var8_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"lastFullSync");
        var9_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"photoData");
        var10_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"privateData");
        var11_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"externalId");
        var12_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"fn");
        var13_20 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"title");
        var14_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"tags");
        var15_22 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"watchPartyStreamId");
        var16_23 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"data");
        try {
            var17_24 = CursorUtil.getColumnIndexOrThrow((Cursor)var2_4, (String)"format");
        }
        catch (Throwable v33) {
            var2_4.close();
            throw v33;
        }
        while (true) {
            block65: {
                block64: {
                    block63: {
                        block62: {
                            block61: {
                                block60: {
                                    block59: {
                                        if (!var2_4.moveToNext()) break;
                                        v3 = var1_1;
                                        var18_25 = var2_4.getString(15);
                                        if (!v3.containsKey((Object)var18_25)) continue;
                                        v4 = var2_4;
                                        v5 = var5_12;
                                        v6 = var2_4;
                                        v7 = var4_9;
                                        var19_26 = var2_4.getString(var3_6);
                                        var20_27 = v6.getString(v7);
                                        if (!v4.isNull(v5)) break block59;
                                        var21_28 /* !! */  = null;
                                        break block60;
                                    }
                                    var21_28 /* !! */  = var2_4.getLong(var5_12);
                                }
                                v8 = var2_4;
                                v9 = var7_14;
                                v10 = var2_4;
                                v11 = var6_13;
                                var21_28 /* !! */  = this.__converters.timestampToDate(var21_28 /* !! */ );
                                var22_29 = v10.getString(v11);
                                var23_30 = v8.getInt(v9) != 0;
                                if (!var2_4.isNull(var8_15)) break block61;
                                var24_31 /* !! */  = null;
                                break block62;
                            }
                            var24_31 /* !! */  = var2_4.getLong(var8_15);
                        }
                        v12 = var2_4;
                        v13 = var11_18;
                        v14 = var2_4;
                        v15 = var10_17;
                        v16 = var2_4;
                        v17 = var9_16;
                        var24_31 /* !! */  = this.__converters.timestampToDate(var24_31 /* !! */ );
                        var25_32 = v16.getString(v17);
                        var26_33 = v14.getString(v15);
                        if (!v12.isNull(v13)) break block63;
                        if (!var2_4.isNull(var12_19)) break block63;
                        if (!var2_4.isNull(var13_20)) break block63;
                        if (!var2_4.isNull(var14_21)) break block63;
                        if (!var2_4.isNull(var15_22)) break block63;
                        if (!var2_4.isNull(var16_23)) break block63;
                        if (!var2_4.isNull(var17_24)) break block63;
                        var27_34 = null;
                        var32_39 = var27_34;
                        ** GOTO lbl185
                    }
                    v18 = var2_4;
                    v19 = var16_23;
                    v20 = var2_4;
                    v21 = var15_22;
                    v22 = this;
                    v23 = var2_4;
                    v24 = var14_21;
                    v25 = var2_4;
                    v26 = var13_20;
                    v27 = var2_4;
                    v28 = var12_19;
                    var27_34 = var2_4.getString(var11_18);
                    var28_35 = v27.getString(v28);
                    var29_36 = v25.getString(v26);
                    var30_37 = v23.getString(v24);
                    var30_37 = v22.__converters.stringToStringList((String)var30_37);
                    var31_38 = v20.getString(v21);
                    if (!v18.isNull(v19)) break block64;
                    if (!var2_4.isNull(var17_24)) break block64;
                    var34_41 = var32_39 = null;
                    break block65;
                }
                v29 = var2_4;
                v30 = var17_24;
                var32_39 = var2_4.getString(var16_23);
                var33_40 = v29.getString(v30);
                var34_41 = v31;
                v31 = new TinodePhoto((String)var32_39, var33_40);
            }
            var32_39 = v32;
            v32 = new TopicPublicData(var27_34, var28_35, var29_36, (TinodePhoto)var34_41, (List<String>)var30_37, var31_38);
lbl185:
            // 2 sources

            var1_1.put((Object)var18_25, (Object)new TinodeContact(var19_26, var20_27, (Date)var21_28 /* !! */ , var22_29, var23_30, (Date)var24_31 /* !! */ , var25_32, var26_33, (TopicPublicData)var32_39));
        }
        var2_4.close();
        return;
    }

    private void __fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus(ArrayMap<String, WatchPartyStatus> arrayMap) {
        int n;
        int n2;
        RoomSQLiteQuery roomSQLiteQuery;
        block22: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n3 = 0;
                int n4 = arrayMap.size();
                for (int j = 0; j < n4; ++j) {
                    ArrayMap arrayMap3;
                    set.put(arrayMap.keyAt(j), null);
                    if (++n3 != 999) continue;
                    this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)set);
                    arrayMap.putAll((Map)((Object)set));
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)set);
                    arrayMap.putAll((Map)((Object)set));
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatId`,`status`,`participantStatuses` FROM `WatchPartyStatus` WHERE `chatId` IN (");
            int n5 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
            n2 = 1;
            for (String string2 : set) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                ++n2;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatId");
            if (n2 != -1) break block22;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery2, (String)"chatId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery4, (String)"status");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery3, (String)"participantStatuses");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            if (!roomSQLiteQuery.moveToNext()) break;
            ArrayMap<String, WatchPartyStatus> arrayMap4 = arrayMap;
            String string3 = roomSQLiteQuery.getString(n2);
            if (!arrayMap4.containsKey((Object)string3)) continue;
            ArrayMap<String, WatchPartyStatus> arrayMap5 = arrayMap;
            String string4 = string3;
            MessagingDao_Impl messagingDao_Impl = this;
            RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery;
            int n8 = n;
            MessagingDao_Impl messagingDao_Impl2 = this;
            RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery;
            int n9 = n7;
            string3 = roomSQLiteQuery.getString(n6);
            Object object = roomSQLiteQuery6.getString(n9);
            object = messagingDao_Impl2.__converters.stringToWatchPartyConnectionStatus((String)object);
            Object object2 = roomSQLiteQuery5.getString(n8);
            object2 = messagingDao_Impl.__converters.stringToParticipantStatuses((String)object2);
            arrayMap5.put((Object)string4, (Object)new WatchPartyStatus(string3, (WatchPartyConnectionStatus)((Object)object), (List<WatchPartyParticipantStatus>)object2));
        }
        roomSQLiteQuery.close();
        return;
    }

    static /* synthetic */ void access$300(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)arrayMap);
    }

    static /* synthetic */ void access$400(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)arrayMap);
    }

    static /* synthetic */ void access$500(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_2((ArrayMap<String, TinodeContact>)arrayMap);
    }

    static /* synthetic */ void access$600(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)arrayMap);
    }

    @Override
    public long saveChatMessage(ChatMessage chatMessage) {
        long l;
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            l = messagingDao_Impl.__insertionAdapterOfChatMessage.insertAndReturnId((Object)chatMessage);
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.setTransactionSuccessful();
            messagingDao_Impl2.__db.endTransaction();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        return l;
    }

    @Override
    public void saveChatMessages(List<ChatMessage> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatMessage_1.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatOwner(ChatOwnerCrossRef chatOwnerCrossRef) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatOwnerCrossRef.insert((Object)chatOwnerCrossRef);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveChats(List<Chat> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChat.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatParticipantCrossRefs(List<ChatParticipantCrossRef> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatParticipantCrossRef.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public long saveWaveMessage(WaveMessage waveMessage) {
        long l;
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            l = messagingDao_Impl.__insertionAdapterOfWaveMessage.insertAndReturnId((Object)waveMessage);
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.setTransactionSuccessful();
            messagingDao_Impl2.__db.endTransaction();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        return l;
    }

    @Override
    public void deleteChatMessage(ChatMessage chatMessage) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__deletionAdapterOfChatMessage.handle((Object)chatMessage);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteWaveMessage(WaveMessage waveMessage) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__deletionAdapterOfWaveMessage.handle((Object)waveMessage);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateChatMessage(ChatMessageUpdate chatMessageUpdate) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__updateAdapterOfChatMessageUpdateAsChatMessage.handle((Object)chatMessageUpdate);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChats(List<Chat> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__db.beginTransaction();
        try {
            MessagingDao.DefaultImpls.saveChats(messagingDao_Impl, list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatParticipants(String string2, List<TinodeContact> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__db.beginTransaction();
        try {
            MessagingDao.DefaultImpls.saveChatParticipants(messagingDao_Impl, string2, list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteMessages(String string2, ChatMessageStatus object) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteMessages.acquire();
        int n = 1;
        if (string2 == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, string2);
        }
        int n2 = 2;
        object = this.__converters.chatStatusToString((ChatMessageStatus)((Object)object));
        if (object == null) {
            supportSQLiteStatement.bindNull(n2);
        } else {
            supportSQLiteStatement.bindString(n2, (String)object);
        }
        MessagingDao_Impl messagingDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl3 = this;
            messagingDao_Impl3.__db.endTransaction();
            messagingDao_Impl3.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl2.__db.setTransactionSuccessful();
        messagingDao_Impl2.__db.endTransaction();
        messagingDao_Impl2.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
    }

    @Override
    public void deleteChats() {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteChats.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.endTransaction();
            messagingDao_Impl2.__preparedStmtOfDeleteChats.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
        messagingDao_Impl.__preparedStmtOfDeleteChats.release(supportSQLiteStatement);
    }

    @Override
    public void deleteWaveEvents(Date comparable) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteWaveEvents.acquire();
        int n = 1;
        comparable = messagingDao_Impl.__converters.dateToString((Date)comparable);
        if (comparable == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindLong(n, ((Long)comparable).longValue());
        }
        MessagingDao_Impl messagingDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl3 = this;
            messagingDao_Impl3.__db.endTransaction();
            messagingDao_Impl3.__preparedStmtOfDeleteWaveEvents.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl2.__db.setTransactionSuccessful();
        messagingDao_Impl2.__db.endTransaction();
        messagingDao_Impl2.__preparedStmtOfDeleteWaveEvents.release(supportSQLiteStatement);
    }

    @Override
    public Maybe<Integer> getLastSeqId(String string2) {
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT ChatMessage.chatMessageSeq FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? ORDER BY ChatMessage.chatMessageSeq DESC LIMIT 1", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        return Maybe.fromCallable((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Integer n;
                block5: {
                    block4: {
                        13 this_ = DBUtil.query((RoomDatabase)this_.MessagingDao_Impl.this.__db, (SupportSQLiteQuery)this_.roomSQLiteQuery, (boolean)false, null);
                        try {
                            if (!this_.moveToFirst()) break block4;
                        }
                        catch (Throwable throwable) {
                            this_.close();
                            throw throwable;
                        }
                        if (this_.isNull(0)) break block4;
                        n = this_.getInt(0);
                        break block5;
                    }
                    n = null;
                }
                this_.close();
                return n;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        });
    }

    @Override
    public Maybe<ChatMessageRelation> getChatMessageRelation(String string2, int n) {
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? AND ChatMessage.chatMessageSeq = ?", (int)2);
        int n2 = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, string2);
        }
        long l = n;
        roomSQLiteQuery.bindLong(2, l);
        return Maybe.fromCallable((Callable)new Callable<ChatMessageRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public ChatMessageRelation call() throws Exception {
                block50: {
                    block46: {
                        block49: {
                            block48: {
                                block47: {
                                    v0 = this;
                                    MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                                    var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                    var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageTopicId");
                                    var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageSeq");
                                    var4_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"senderUserId");
                                    var5_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"date");
                                    var6_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"text");
                                    var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                                    var8_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"subtype");
                                    var9_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"replyTo");
                                    var10_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"status");
                                    var11_20 = v1;
                                    v1 = new ArrayMap();
                                    ** while (var1_1.moveToNext())
lbl-1000:
                                    // 1 sources

                                    {
                                        var11_20.put((Object)var1_1.getString(var4_7), null);
                                        continue;
                                    }
lbl32:
                                    // 2 sources

                                    v2 = var1_1;
                                    v3 = this;
                                    var1_1.moveToPosition(-1);
                                    MessagingDao_Impl.access$200(v3.MessagingDao_Impl.this, var11_20);
                                    if (!v2.moveToFirst()) break block46;
                                    if (!var1_1.isNull(var2_2)) break block47;
                                    if (!var1_1.isNull(var3_5)) break block47;
                                    if (!var1_1.isNull(var4_7)) break block47;
                                    if (!var1_1.isNull(var5_8)) break block47;
                                    if (!var1_1.isNull(var6_10)) break block47;
                                    if (!var1_1.isNull(var7_12)) break block47;
                                    if (!var1_1.isNull(var8_14)) break block47;
                                    if (!var1_1.isNull(var9_16)) break block47;
                                    if (!var1_1.isNull(var10_18)) break block47;
                                    var13_21 = var2_3 = null;
                                    ** GOTO lbl108
                                }
                                v4 = var1_1;
                                v5 = var5_8;
                                v6 = var1_1;
                                v7 = var4_7;
                                v8 = var1_1;
                                v9 = var3_5;
                                var2_3 = var1_1.getString(var2_2);
                                var3_5 = v8.getInt(v9);
                                var12_22 = v6.getString(v7);
                                if (!v4.isNull(v5)) break block48;
                                var5_9 /* !! */  = null;
                                break block49;
                            }
                            var5_9 /* !! */  = var1_1.getLong(var5_8);
                        }
                        v10 = this;
                        v11 = var1_1;
                        v12 = var10_18;
                        v13 = var1_1;
                        v14 = var9_16;
                        v15 = var1_1;
                        v16 = var8_14;
                        v17 = var1_1;
                        v18 = var7_12;
                        v19 = var1_1;
                        v20 = var6_10;
                        var5_9 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var5_9 /* !! */ );
                        var6_11 = v19.getString(v20);
                        var7_13 = v17.getString(v18);
                        var8_15 = v15.getString(v16);
                        var9_17 = v13.getString(v14);
                        var10_19 /* !! */  = v11.getString(v12);
                        var10_19 /* !! */  = MessagingDao_Impl.access$000(v10.MessagingDao_Impl.this).stringToChatStatus(var10_19 /* !! */ );
                        var13_21 = v21;
                        v21 = new ChatMessage((String)var2_3, var3_5, var12_22, (Date)var5_9 /* !! */ , var6_11, var7_13, var8_15, var9_17, (ChatMessageStatus)var10_19 /* !! */ );
lbl108:
                        // 2 sources

                        var2_3 = (TinodeContact)var11_20.get((Object)var1_1.getString(var4_7));
                        var3_6 = v22;
                        v22 = new ChatMessageRelation((ChatMessage)var13_21, (TinodeContact)var2_3);
                        break block50;
                    }
                    var3_6 = null;
                }
                v23 = var3_6;
                v24 = this;
                v25 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v25.close();
                {
                    catch (Throwable v26) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v26;
                    }
                }
                MessagingDao_Impl.access$100(v24.MessagingDao_Impl.this).endTransaction();
                return v23;
                catch (Throwable var2_4) {
                    var1_1.close();
                    throw var2_4;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        });
    }

    @Override
    public DataSource.Factory<Integer, ChatMessageRelation> getChatMessagesRelationLiveData(String string2) {
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? ORDER BY ChatMessage.chatMessageSeq DESC", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        return new DataSource.Factory<Integer, ChatMessageRelation>(){

            public LimitOffsetDataSource<ChatMessageRelation> create() {
                15 v0 = this_;
                15 this_ = v0.MessagingDao_Impl.this.__db;
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                stringArray[0] = "TinodeContact";
                stringArray[1] = "ChatMessage";
                return new LimitOffsetDataSource<ChatMessageRelation>((RoomDatabase)this_, v0.roomSQLiteQuery, true, stringArray2){

                    protected List<ChatMessageRelation> convertRows(Cursor cursor) {
                        ArrayList<ChatMessageRelation> arrayList;
                        ArrayMap arrayMap;
                        Cursor cursor2 = cursor;
                        int n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"chatMessageTopicId");
                        int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"chatMessageSeq");
                        int n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"senderUserId");
                        int n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"date");
                        int n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"text");
                        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"type");
                        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"subtype");
                        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"replyTo");
                        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"status");
                        ArrayMap arrayMap2 = arrayMap;
                        arrayMap = new ArrayMap();
                        while (cursor.moveToNext()) {
                            arrayMap2.put((Object)cursor.getString(n3), null);
                        }
                        cursor.moveToPosition(-1);
                        MessagingDao_Impl.this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)arrayMap2);
                        ArrayList<ChatMessageRelation> arrayList2 = arrayList;
                        arrayList = new ArrayList<ChatMessageRelation>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Object object;
                            Object object2;
                            if (cursor.isNull(n) && cursor.isNull(n2) && cursor.isNull(n3) && cursor.isNull(n4) && cursor.isNull(n5) && cursor.isNull(n6) && cursor.isNull(n7) && cursor.isNull(n8) && cursor.isNull(n9)) {
                                object = object2 = null;
                            } else {
                                ChatMessage chatMessage;
                                object2 = cursor.getString(n);
                                int n10 = cursor.getInt(n2);
                                String string2 = cursor.getString(n3);
                                Comparable<Long> comparable = cursor.isNull(n4) ? null : Long.valueOf(cursor.getLong(n4));
                                comparable = MessagingDao_Impl.this.__converters.timestampToDate((Long)comparable);
                                String string3 = cursor.getString(n5);
                                String string4 = cursor.getString(n6);
                                String string5 = cursor.getString(n7);
                                String string6 = cursor.getString(n8);
                                Object object3 = cursor.getString(n9);
                                object3 = MessagingDao_Impl.this.__converters.stringToChatStatus((String)object3);
                                object = chatMessage;
                                chatMessage = new ChatMessage((String)object2, n10, string2, (Date)comparable, string3, string4, string5, string6, (ChatMessageStatus)((Object)object3));
                            }
                            object2 = (TinodeContact)arrayMap2.get((Object)cursor.getString(n3));
                            arrayList2.add(new ChatMessageRelation((ChatMessage)object, (TinodeContact)object2));
                        }
                        return arrayList2;
                    }
                };
            }
        };
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public List<ChatMessageRelation> getChatMessagesRelationList(String var1_1, Integer var2_5, Integer var3_8, int var4_10) {
        var5_11 = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? AND (chatMessageSeq < ? OR ? IS NULL) AND (chatMessageSeq >= ? OR ? IS NULL) ORDER BY ChatMessage.chatMessageSeq DESC LIMIT ?", (int)6);
        var6_12 = 1;
        if (var1_1 == null) {
            var5_11.bindNull(var6_12);
        } else {
            var5_11.bindString(var6_12, var1_1);
        }
        var1_2 = 2;
        if (var2_5 == null) {
            var5_11.bindNull(var1_2);
        } else {
            var5_11.bindLong(var1_2, (long)var2_5.intValue());
        }
        var1_2 = 3;
        if (var2_5 == null) {
            var5_11.bindNull(var1_2);
        } else {
            var5_11.bindLong(var1_2, (long)var2_5.intValue());
        }
        var1_2 = 4;
        if (var3_8 == null) {
            var5_11.bindNull(var1_2);
        } else {
            var5_11.bindLong(var1_2, (long)var3_8.intValue());
        }
        var1_2 = 5;
        if (var3_8 == null) {
            var5_11.bindNull(var1_2);
        } else {
            var5_11.bindLong(var1_2, (long)var3_8.intValue());
        }
        v0 = this;
        var1_3 = var4_10;
        var5_11.bindLong(6, var1_3);
        v0.__db.assertNotSuspendingTransaction();
        v0.__db.beginTransaction();
        var1_4 = DBUtil.query((RoomDatabase)v0.__db, (SupportSQLiteQuery)var5_11, (boolean)true, null);
        var2_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"chatMessageTopicId");
        var3_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"chatMessageSeq");
        var4_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"senderUserId");
        var6_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"date");
        var7_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"text");
        var8_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"type");
        var9_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"subtype");
        var10_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"replyTo");
        var11_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"status");
        var12_18 = v1;
        v1 = new ArrayMap();
        ** while (var1_4.moveToNext())
lbl-1000:
        // 1 sources

        {
            var12_18.put((Object)var1_4.getString(var4_10), null);
            continue;
        }
lbl61:
        // 2 sources

        v2 = this;
        v3 = var12_18;
        var1_4.moveToPosition(-1);
        v2.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)v3);
        var13_19 = v4;
        v4 = new ArrayList<ChatMessageRelation>(var1_4.getCount());
        ** while (var1_4.moveToNext())
lbl-1000:
        // 1 sources

        {
            block59: {
                block58: {
                    block57: {
                        if (!var1_4.isNull(var2_6)) break block57;
                        if (!var1_4.isNull(var3_9)) break block57;
                        if (!var1_4.isNull(var4_10)) break block57;
                        if (!var1_4.isNull(var6_12)) break block57;
                        if (!var1_4.isNull(var7_13)) break block57;
                        if (!var1_4.isNull(var8_14)) break block57;
                        if (!var1_4.isNull(var9_15)) break block57;
                        if (!var1_4.isNull(var10_16)) break block57;
                        if (!var1_4.isNull(var11_17)) break block57;
                        var23_29 = var14_20 = null;
                        ** GOTO lbl140
                    }
                    v5 = var1_4;
                    v6 = var6_12;
                    v7 = var1_4;
                    v8 = var4_10;
                    v9 = var1_4;
                    v10 = var3_9;
                    var14_20 = var1_4.getString(var2_6);
                    var15_21 = v9.getInt(v10);
                    var16_22 = v7.getString(v8);
                    if (!v5.isNull(v6)) break block58;
                    var17_23 /* !! */  = null;
                    break block59;
                }
                var17_23 /* !! */  = var1_4.getLong(var6_12);
            }
            v11 = this;
            v12 = var1_4;
            v13 = var11_17;
            v14 = var1_4;
            v15 = var10_16;
            v16 = var1_4;
            v17 = var9_15;
            v18 = var1_4;
            v19 = var8_14;
            v20 = var1_4;
            v21 = var7_13;
            var17_23 /* !! */  = this.__converters.timestampToDate(var17_23 /* !! */ );
            var18_24 = v20.getString(v21);
            var19_25 = v18.getString(v19);
            var20_26 = v16.getString(v17);
            var21_27 = v14.getString(v15);
            var22_28 /* !! */  = v12.getString(v13);
            var22_28 /* !! */  = v11.__converters.stringToChatStatus(var22_28 /* !! */ );
            var23_29 = v22;
            v22 = new ChatMessage((String)var14_20, var15_21, var16_22, (Date)var17_23 /* !! */ , var18_24, var19_25, var20_26, var21_27, (ChatMessageStatus)var22_28 /* !! */ );
lbl140:
            // 2 sources

            v23 = var13_19;
            var14_20 = (TinodeContact)var12_18.get((Object)var1_4.getString(var4_10));
            v23.add(new ChatMessageRelation((ChatMessage)var23_29, (TinodeContact)var14_20));
            continue;
        }
lbl147:
        // 2 sources

        v24 = var13_19;
        v25 = this;
        v26 = var5_11;
        v27 = var1_4;
        this.__db.setTransactionSuccessful();
        v27.close();
        v26.release();
        {
            catch (Throwable v28) {
                this.__db.endTransaction();
                throw v28;
            }
        }
        v25.__db.endTransaction();
        return v24;
        catch (Throwable var2_7) {
            var1_4.close();
            var5_11.release();
            throw var2_7;
        }
    }

    @Override
    public Observable<List<ChatMessageRelation>> getChatMessagesRelation(String string2, Integer object, Integer n, int n2) {
        Callable<List<ChatMessageRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? AND (chatMessageSeq < ? OR ? IS NULL) AND (chatMessageSeq >= ? OR ? IS NULL) ORDER BY ChatMessage.chatMessageSeq DESC LIMIT ?", (int)6);
        int n3 = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n3);
        } else {
            roomSQLiteQuery.bindString(n3, string2);
        }
        int n4 = 2;
        if (object == null) {
            roomSQLiteQuery.bindNull(n4);
        } else {
            roomSQLiteQuery.bindLong(n4, (long)((Integer)object).intValue());
        }
        n4 = 3;
        if (object == null) {
            roomSQLiteQuery.bindNull(n4);
        } else {
            roomSQLiteQuery.bindLong(n4, (long)((Integer)object).intValue());
        }
        n4 = 4;
        if (n == null) {
            roomSQLiteQuery.bindNull(n4);
        } else {
            roomSQLiteQuery.bindLong(n4, (long)n.intValue());
        }
        n4 = 5;
        if (n == null) {
            roomSQLiteQuery.bindNull(n4);
        } else {
            roomSQLiteQuery.bindLong(n4, (long)n.intValue());
        }
        long l = n2;
        roomSQLiteQuery.bindLong(6, l);
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "TinodeContact";
        stringArray[1] = "ChatMessage";
        object = callable;
        callable = new Callable<List<ChatMessageRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<ChatMessageRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageTopicId");
                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageSeq");
                var4_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"senderUserId");
                var5_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"date");
                var6_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"text");
                var7_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                var8_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"subtype");
                var9_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"replyTo");
                var10_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"status");
                var11_12 = v1;
                v1 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    var11_12.put((Object)var1_1.getString(var4_5), null);
                    continue;
                }
lbl32:
                // 2 sources

                v2 = this;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$200(v2.MessagingDao_Impl.this, var11_12);
                var12_13 = v3;
                v3 = new ArrayList<ChatMessageRelation>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block49: {
                        block48: {
                            block47: {
                                if (!var1_1.isNull(var2_2)) break block47;
                                if (!var1_1.isNull(var3_4)) break block47;
                                if (!var1_1.isNull(var4_5)) break block47;
                                if (!var1_1.isNull(var5_6)) break block47;
                                if (!var1_1.isNull(var6_7)) break block47;
                                if (!var1_1.isNull(var7_8)) break block47;
                                if (!var1_1.isNull(var8_9)) break block47;
                                if (!var1_1.isNull(var9_10)) break block47;
                                if (!var1_1.isNull(var10_11)) break block47;
                                var22_23 = var13_14 = null;
                                ** GOTO lbl110
                            }
                            v4 = var1_1;
                            v5 = var5_6;
                            v6 = var1_1;
                            v7 = var4_5;
                            v8 = var1_1;
                            v9 = var3_4;
                            var13_14 = var1_1.getString(var2_2);
                            var14_15 = v8.getInt(v9);
                            var15_16 = v6.getString(v7);
                            if (!v4.isNull(v5)) break block48;
                            var16_17 /* !! */  = null;
                            break block49;
                        }
                        var16_17 /* !! */  = var1_1.getLong(var5_6);
                    }
                    v10 = this;
                    v11 = var1_1;
                    v12 = var10_11;
                    v13 = var1_1;
                    v14 = var9_10;
                    v15 = var1_1;
                    v16 = var8_9;
                    v17 = var1_1;
                    v18 = var7_8;
                    v19 = var1_1;
                    v20 = var6_7;
                    var16_17 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var16_17 /* !! */ );
                    var17_18 = v19.getString(v20);
                    var18_19 = v17.getString(v18);
                    var19_20 = v15.getString(v16);
                    var20_21 = v13.getString(v14);
                    var21_22 /* !! */  = v11.getString(v12);
                    var21_22 /* !! */  = MessagingDao_Impl.access$000(v10.MessagingDao_Impl.this).stringToChatStatus(var21_22 /* !! */ );
                    var22_23 = v21;
                    v21 = new ChatMessage((String)var13_14, var14_15, var15_16, (Date)var16_17 /* !! */ , var17_18, var18_19, var19_20, var20_21, (ChatMessageStatus)var21_22 /* !! */ );
lbl110:
                    // 2 sources

                    v22 = var12_13;
                    var13_14 = (TinodeContact)var11_12.get((Object)var1_1.getString(var4_5));
                    v22.add(new ChatMessageRelation((ChatMessage)var22_23, (TinodeContact)var13_14));
                    continue;
                }
lbl117:
                // 2 sources

                v23 = var12_13;
                v24 = this;
                v25 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v25.close();
                {
                    catch (Throwable v26) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v26;
                    }
                }
                MessagingDao_Impl.access$100(v24.MessagingDao_Impl.this).endTransaction();
                return v23;
                catch (Throwable var2_3) {
                    var1_1.close();
                    throw var2_3;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)object);
    }

    @Override
    public Observable<List<ChatRelation>> getChatsRelation() {
        Callable<List<ChatRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Chat ORDER BY Chat.updatedAt DESC", (int)0);
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = "ChatParticipantCrossRef";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "ChatMessage";
        stringArray[3] = "Chat";
        Callable<List<ChatRelation>> callable2 = callable;
        callable = new Callable<List<ChatRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<ChatRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                var4_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                var5_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                var6_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                var7_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                var8_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                var9_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"externalId");
                var10_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"fn");
                var11_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"title");
                var12_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"tags");
                var13_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                var14_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"data");
                var15_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"format");
                var16_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                var17_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                var18_19 = v1;
                v1 = new ArrayMap();
                var19_20 = v2;
                v2 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block93: {
                        v3 = var18_19;
                        var20_21 = var1_1.getString(var2_2);
                        if ((ArrayList)v3.get(var20_21) != null) break block93;
                        var18_19.put(var20_21, new ArrayList<E>());
                    }
                    v4 = var19_20;
                    var20_21 = var1_1.getString(var2_2);
                    if ((ArrayList)v4.get(var20_21) != null) continue;
                    var19_20.put(var20_21, new ArrayList<E>());
                    continue;
                }
lbl63:
                // 2 sources

                v5 = this;
                v6 = v5;
                v7 = v5;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$300(v6.MessagingDao_Impl.this, var18_19);
                MessagingDao_Impl.access$400(v7.MessagingDao_Impl.this, var19_20);
                var20_21 = v8;
                v8 = new ArrayList<E>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block103: {
                        block102: {
                            block101: {
                                block100: {
                                    block99: {
                                        block98: {
                                            block97: {
                                                block96: {
                                                    block95: {
                                                        block94: {
                                                            if (!var1_1.isNull(var2_2)) break block94;
                                                            if (!var1_1.isNull(var3_4)) break block94;
                                                            if (!var1_1.isNull(var4_5)) break block94;
                                                            if (!var1_1.isNull(var5_6)) break block94;
                                                            if (!var1_1.isNull(var6_7)) break block94;
                                                            if (!var1_1.isNull(var7_8)) break block94;
                                                            if (!var1_1.isNull(var8_9)) break block94;
                                                            if (!var1_1.isNull(var9_10)) break block94;
                                                            if (!var1_1.isNull(var10_11)) break block94;
                                                            if (!var1_1.isNull(var11_12)) break block94;
                                                            if (!var1_1.isNull(var12_13)) break block94;
                                                            if (!var1_1.isNull(var13_14)) break block94;
                                                            if (!var1_1.isNull(var14_15)) break block94;
                                                            if (!var1_1.isNull(var15_16)) break block94;
                                                            if (!var1_1.isNull(var16_17)) break block94;
                                                            if (!var1_1.isNull(var17_18)) break block94;
                                                            var28_29 = var21_22 = null;
                                                            ** GOTO lbl233
                                                        }
                                                        v9 = var1_1;
                                                        v10 = var7_8;
                                                        v11 = var1_1;
                                                        v12 = var6_7;
                                                        v13 = var1_1;
                                                        v14 = var5_6;
                                                        v15 = var1_1;
                                                        v16 = var4_5;
                                                        v17 = var1_1;
                                                        v18 = var3_4;
                                                        var21_22 = var1_1.getString(var2_2);
                                                        var22_23 = v17.getString(v18);
                                                        var23_24 = v15.getInt(v16);
                                                        var24_25 = v13.getInt(v14);
                                                        var25_26 = v11.getInt(v12);
                                                        if (!v9.isNull(v10)) break block95;
                                                        var26_27 /* !! */  = null;
                                                        break block96;
                                                    }
                                                    var26_27 /* !! */  = var1_1.getLong(var7_8);
                                                }
                                                v19 = var1_1;
                                                v20 = var8_9;
                                                var26_27 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var26_27 /* !! */ );
                                                if (!v19.isNull(v20)) break block97;
                                                var27_28 /* !! */  = null;
                                                break block98;
                                            }
                                            var27_28 /* !! */  = var1_1.getLong(var8_9);
                                        }
                                        v21 = var1_1;
                                        v22 = var9_10;
                                        var27_28 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var27_28 /* !! */ );
                                        if (!v21.isNull(v22)) break block99;
                                        if (!var1_1.isNull(var10_11)) break block99;
                                        if (!var1_1.isNull(var11_12)) break block99;
                                        if (!var1_1.isNull(var12_13)) break block99;
                                        if (!var1_1.isNull(var13_14)) break block99;
                                        if (!var1_1.isNull(var14_15)) break block99;
                                        if (!var1_1.isNull(var15_16)) break block99;
                                        var33_34 = var28_29 = null;
                                        ** GOTO lbl214
                                    }
                                    v23 = var1_1;
                                    v24 = var14_15;
                                    v25 = var1_1;
                                    v26 = var13_14;
                                    v27 = this;
                                    v28 = var1_1;
                                    v29 = var12_13;
                                    v30 = var1_1;
                                    v31 = var11_12;
                                    v32 = var1_1;
                                    v33 = var10_11;
                                    var28_29 = var1_1.getString(var9_10);
                                    var29_30 = v32.getString(v33);
                                    var30_31 = v30.getString(v31);
                                    var31_32 = v28.getString(v29);
                                    var31_32 = MessagingDao_Impl.access$000(v27.MessagingDao_Impl.this).stringToStringList((String)var31_32);
                                    var32_33 = v25.getString(v26);
                                    if (!v23.isNull(v24)) break block100;
                                    if (!var1_1.isNull(var15_16)) break block100;
                                    var35_36 = var33_34 = null;
                                    break block101;
                                }
                                v34 = var1_1;
                                v35 = var15_16;
                                var33_34 = var1_1.getString(var14_15);
                                var34_35 = v34.getString(v35);
                                var35_36 = v36;
                                v36 = new TinodePhoto((String)var33_34, var34_35);
                            }
                            var33_34 = v37;
                            v37 = new TopicPublicData((String)var28_29, var29_30, (String)var30_31, (TinodePhoto)var35_36, (List<String>)var31_32, var32_33);
lbl214:
                            // 2 sources

                            if (!var1_1.isNull(var16_17)) break block102;
                            if (!var1_1.isNull(var17_18)) break block102;
                            var30_31 = var28_29 = null;
                            break block103;
                        }
                        v38 = var1_1;
                        v39 = var17_18;
                        var28_29 = var1_1.getString(var16_17);
                        var29_30 = v38.getString(v39);
                        var30_31 = v40;
                        v40 = new Access((String)var28_29, var29_30);
                    }
                    var28_29 = v41;
                    v41 = new Chat((String)var21_22, (String)var22_23, var23_24, var24_25, var25_26, (Date)var26_27 /* !! */ , (Date)var27_28 /* !! */ , (TopicPublicData)var33_34, (Access)var30_31);
lbl233:
                    // 2 sources

                    var21_22 = (ArrayList)var18_19.get((Object)var1_1.getString(var2_2));
                    if (var21_22 != null) ** GOTO lbl238
                    var21_22 = v42;
                    v42 = new ArrayList<E>();
lbl238:
                    // 2 sources

                    if ((var22_23 = (ArrayList)var19_20.get((Object)var1_1.getString(var2_2))) != null) ** GOTO lbl242
                    var22_23 = v43;
                    v43 = new ArrayList<E>();
lbl242:
                    // 2 sources

                    var20_21.add(new ChatRelation((Chat)var28_29, (List<TinodeContact>)var21_22, (List<ChatMessage>)var22_23));
                    continue;
                }
lbl246:
                // 2 sources

                v44 = var20_21;
                v45 = this;
                v46 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v46.close();
                {
                    catch (Throwable v47) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v47;
                    }
                }
                MessagingDao_Impl.access$100(v45.MessagingDao_Impl.this).endTransaction();
                return v44;
                catch (Throwable var2_3) {
                    var1_1.close();
                    throw var2_3;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<ChatRelation> getChatRelation(String stringArray) {
        Callable<ChatRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Chat WHERE Chat.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[4];
        stringArray = stringArray2;
        stringArray2[0] = "ChatParticipantCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "ChatMessage";
        stringArray2[3] = "Chat";
        Callable<ChatRelation> callable2 = callable;
        callable = new Callable<ChatRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public ChatRelation call() throws Exception {
                block105: {
                    block93: {
                        block104: {
                            block103: {
                                block102: {
                                    block101: {
                                        block100: {
                                            block99: {
                                                block98: {
                                                    block97: {
                                                        block96: {
                                                            block95: {
                                                                block94: {
                                                                    v0 = this;
                                                                    MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                                                                    var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                    var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                    var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                    var4_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                    var5_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                    var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                    var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                    var8_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                    var9_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"externalId");
                                                                    var10_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"fn");
                                                                    var11_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"title");
                                                                    var12_24 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"tags");
                                                                    var13_26 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                    var14_28 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"data");
                                                                    var15_30 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"format");
                                                                    var16_32 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                    var17_33 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                    var18_34 = v1;
                                                                    v1 = new ArrayMap();
                                                                    var19_35 = v2;
                                                                    v2 = new ArrayMap();
                                                                    ** while (var1_1.moveToNext())
lbl-1000:
                                                                    // 1 sources

                                                                    {
                                                                        block92: {
                                                                            v3 = var18_34;
                                                                            var20_36 = var1_1.getString(var2_2);
                                                                            if ((ArrayList)v3.get((Object)var20_36) != null) break block92;
                                                                            var18_34.put((Object)var20_36, new ArrayList<E>());
                                                                        }
                                                                        v4 = var19_35;
                                                                        var20_36 = var1_1.getString(var2_2);
                                                                        if ((ArrayList)v4.get((Object)var20_36) != null) continue;
                                                                        var19_35.put((Object)var20_36, new ArrayList<E>());
                                                                        continue;
                                                                    }
lbl63:
                                                                    // 2 sources

                                                                    v5 = var1_1;
                                                                    v6 = this;
                                                                    v7 = v6;
                                                                    v8 = v6;
                                                                    var1_1.moveToPosition(-1);
                                                                    MessagingDao_Impl.access$300(v7.MessagingDao_Impl.this, var18_34);
                                                                    MessagingDao_Impl.access$400(v8.MessagingDao_Impl.this, var19_35);
                                                                    if (!v5.moveToFirst()) break block93;
                                                                    if (!var1_1.isNull(var2_2)) break block94;
                                                                    if (!var1_1.isNull(var3_5)) break block94;
                                                                    if (!var1_1.isNull(var4_7)) break block94;
                                                                    if (!var1_1.isNull(var5_10)) break block94;
                                                                    if (!var1_1.isNull(var6_11)) break block94;
                                                                    if (!var1_1.isNull(var7_12)) break block94;
                                                                    if (!var1_1.isNull(var8_14)) break block94;
                                                                    if (!var1_1.isNull(var9_16)) break block94;
                                                                    if (!var1_1.isNull(var10_18)) break block94;
                                                                    if (!var1_1.isNull(var11_21)) break block94;
                                                                    if (!var1_1.isNull(var12_24)) break block94;
                                                                    if (!var1_1.isNull(var13_26)) break block94;
                                                                    if (!var1_1.isNull(var14_28)) break block94;
                                                                    if (!var1_1.isNull(var15_30)) break block94;
                                                                    if (!var1_1.isNull(var16_32)) break block94;
                                                                    if (!var1_1.isNull(var17_33)) break block94;
                                                                    var9_17 = var3_6 = null;
                                                                    ** GOTO lbl231
                                                                }
                                                                v9 = var1_1;
                                                                v10 = var7_12;
                                                                v11 = var1_1;
                                                                v12 = var6_11;
                                                                v13 = var1_1;
                                                                v14 = var5_10;
                                                                v15 = var1_1;
                                                                v16 = var4_7;
                                                                v17 = var1_1;
                                                                v18 = var3_5;
                                                                var3_6 = var1_1.getString(var2_2);
                                                                var4_8 = v17.getString(v18);
                                                                var5_10 = v15.getInt(v16);
                                                                var6_11 = v13.getInt(v14);
                                                                var20_37 = v11.getInt(v12);
                                                                if (!v9.isNull(v10)) break block95;
                                                                var7_13 /* !! */  = null;
                                                                break block96;
                                                            }
                                                            var7_13 /* !! */  = var1_1.getLong(var7_12);
                                                        }
                                                        v19 = var1_1;
                                                        v20 = var8_14;
                                                        var7_13 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var7_13 /* !! */ );
                                                        if (!v19.isNull(v20)) break block97;
                                                        var8_15 /* !! */  = null;
                                                        break block98;
                                                    }
                                                    var8_15 /* !! */  = var1_1.getLong(var8_14);
                                                }
                                                v21 = var1_1;
                                                v22 = var9_16;
                                                var8_15 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var8_15 /* !! */ );
                                                if (!v21.isNull(v22)) break block99;
                                                if (!var1_1.isNull(var10_18)) break block99;
                                                if (!var1_1.isNull(var11_21)) break block99;
                                                if (!var1_1.isNull(var12_24)) break block99;
                                                if (!var1_1.isNull(var13_26)) break block99;
                                                if (!var1_1.isNull(var14_28)) break block99;
                                                if (!var1_1.isNull(var15_30)) break block99;
                                                var14_29 = var9_17 = null;
                                                ** GOTO lbl212
                                            }
                                            v23 = var1_1;
                                            v24 = var14_28;
                                            v25 = var1_1;
                                            v26 = var13_26;
                                            v27 = this;
                                            v28 = var1_1;
                                            v29 = var12_24;
                                            v30 = var1_1;
                                            v31 = var11_21;
                                            v32 = var1_1;
                                            v33 = var10_18;
                                            var9_17 = var1_1.getString(var9_16);
                                            var10_19 = v32.getString(v33);
                                            var11_22 = v30.getString(v31);
                                            var12_25 = v28.getString(v29);
                                            var12_25 = MessagingDao_Impl.access$000(v27.MessagingDao_Impl.this).stringToStringList((String)var12_25);
                                            var13_27 = v25.getString(v26);
                                            if (!v23.isNull(v24)) break block100;
                                            if (!var1_1.isNull(var15_30)) break block100;
                                            var21_38 = var14_29 = null;
                                            break block101;
                                        }
                                        v34 = var1_1;
                                        v35 = var15_30;
                                        var14_29 = var1_1.getString(var14_28);
                                        var15_31 = v34.getString(v35);
                                        var21_38 = v36;
                                        v36 = new TinodePhoto((String)var14_29, var15_31);
                                    }
                                    var14_29 = v37;
                                    v37 = new TopicPublicData((String)var9_17, var10_19, var11_22, (TinodePhoto)var21_38, (List<String>)var12_25, var13_27);
lbl212:
                                    // 2 sources

                                    if (!var1_1.isNull(var16_32)) break block102;
                                    if (!var1_1.isNull(var17_33)) break block102;
                                    var11_23 = var9_17 = null;
                                    break block103;
                                }
                                v38 = var1_1;
                                v39 = var17_33;
                                var9_17 = var1_1.getString(var16_32);
                                var10_20 = v38.getString(v39);
                                var11_23 = v40;
                                v40 = new Access((String)var9_17, var10_20);
                            }
                            var9_17 = v41;
                            v41 = new Chat((String)var3_6, var4_8, var5_10, var6_11, var20_37, (Date)var7_13 /* !! */ , (Date)var8_15 /* !! */ , (TopicPublicData)var14_29, (Access)var11_23);
lbl231:
                            // 2 sources

                            var3_6 = (ArrayList)var18_34.get((Object)var1_1.getString(var2_2));
                            if (var3_6 != null) ** GOTO lbl236
                            var3_6 = v42;
                            v42 = new ArrayList<E>();
lbl236:
                            // 2 sources

                            if ((var2_3 = (ArrayList)var19_35.get((Object)var1_1.getString(var2_2))) != null) break block104;
                            var2_3 = v43;
                            v43 = new ArrayList<E>();
                        }
                        var4_9 = v44;
                        v44 = new ChatRelation((Chat)var9_17, (List<TinodeContact>)var3_6, var2_3);
                        break block105;
                    }
                    var4_9 = null;
                }
                v45 = var4_9;
                v46 = this;
                v47 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v47.close();
                {
                    catch (Throwable v48) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v48;
                    }
                }
                MessagingDao_Impl.access$100(v46.MessagingDao_Impl.this).endTransaction();
                return v45;
                catch (Throwable var2_4) {
                    var1_1.close();
                    throw var2_4;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public boolean isChatExist(String string2) {
        boolean bl;
        RoomSQLiteQuery roomSQLiteQuery;
        block6: {
            block5: {
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT EXISTS(SELECT * FROM Chat WHERE Chat.chatId = ?)", (int)1);
                int n = 1;
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n);
                } else {
                    roomSQLiteQuery.bindString(n, string2);
                }
                MessagingDao_Impl messagingDao_Impl = messagingDao_Impl2;
                messagingDao_Impl.__db.assertNotSuspendingTransaction();
                MessagingDao_Impl messagingDao_Impl2 = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    if (!messagingDao_Impl2.moveToFirst()) break block5;
                }
                catch (Throwable throwable) {
                    messagingDao_Impl2.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                if (messagingDao_Impl2.getInt(0) == 0) break block5;
                bl = true;
                break block6;
            }
            bl = false;
        }
        messagingDao_Impl2.close();
        roomSQLiteQuery.release();
        return bl;
    }

    @Override
    public Observable<List<WatchPartyRelation>> getWatchPartiesRelation() {
        Callable<List<WatchPartyRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Chat ORDER BY Chat.updatedAt DESC", (int)0);
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "ChatOwnerCrossRef";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "WatchPartyStatus";
        stringArray[3] = "ChatParticipantCrossRef";
        stringArray[4] = "ChatMessage";
        stringArray[5] = "Chat";
        Callable<List<WatchPartyRelation>> callable2 = callable;
        callable = new Callable<List<WatchPartyRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<WatchPartyRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                var4_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                var5_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                var6_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                var7_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                var8_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                var9_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"externalId");
                var10_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"fn");
                var11_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"title");
                var12_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"tags");
                var13_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                var14_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"data");
                var15_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"format");
                var16_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                var17_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                var18_19 = v1;
                v1 = new ArrayMap();
                var19_20 = v2;
                v2 = new ArrayMap();
                var20_21 = v3;
                v3 = new ArrayMap();
                var21_22 = v4;
                v4 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block116: {
                        v5 = var20_21;
                        v6 = var1_1;
                        v7 = var2_2;
                        v8 = var19_20;
                        v9 = var1_1;
                        v10 = var2_2;
                        var18_19.put((Object)var1_1.getString(var2_2), null);
                        v8.put((Object)v9.getString(v10), null);
                        var22_23 = v6.getString(v7);
                        if ((ArrayList)v5.get(var22_23) != null) break block116;
                        var20_21.put(var22_23, new ArrayList<E>());
                    }
                    v11 = var21_22;
                    var22_23 = var1_1.getString(var2_2);
                    if ((ArrayList)v11.get(var22_23) != null) continue;
                    var21_22.put(var22_23, new ArrayList<E>());
                    continue;
                }
lbl80:
                // 2 sources

                v12 = this;
                v13 = v12;
                v14 = v12;
                v15 = v12;
                v16 = v12;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$500(v13.MessagingDao_Impl.this, var18_19);
                MessagingDao_Impl.access$600(v14.MessagingDao_Impl.this, var19_20);
                MessagingDao_Impl.access$300(v15.MessagingDao_Impl.this, var20_21);
                MessagingDao_Impl.access$400(v16.MessagingDao_Impl.this, var21_22);
                var22_23 = v17;
                v17 = new ArrayList<E>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block128: {
                        block127: {
                            block126: {
                                block125: {
                                    block124: {
                                        block123: {
                                            block122: {
                                                block121: {
                                                    block120: {
                                                        block119: {
                                                            block118: {
                                                                block117: {
                                                                    if (!var1_1.isNull(var2_2)) break block117;
                                                                    if (!var1_1.isNull(var3_4)) break block117;
                                                                    if (!var1_1.isNull(var4_5)) break block117;
                                                                    if (!var1_1.isNull(var5_6)) break block117;
                                                                    if (!var1_1.isNull(var6_7)) break block117;
                                                                    if (!var1_1.isNull(var7_8)) break block117;
                                                                    if (!var1_1.isNull(var8_9)) break block117;
                                                                    if (!var1_1.isNull(var9_10)) break block117;
                                                                    if (!var1_1.isNull(var10_11)) break block117;
                                                                    if (!var1_1.isNull(var11_12)) break block117;
                                                                    if (!var1_1.isNull(var12_13)) break block117;
                                                                    if (!var1_1.isNull(var13_14)) break block117;
                                                                    if (!var1_1.isNull(var14_15)) break block117;
                                                                    if (!var1_1.isNull(var15_16)) break block117;
                                                                    if (!var1_1.isNull(var16_17)) break block117;
                                                                    if (!var1_1.isNull(var17_18)) break block117;
                                                                    var25_26 = var23_24 = null;
                                                                    ** GOTO lbl302
                                                                }
                                                                if (!var1_1.isNull(var2_2)) break block118;
                                                                if (!var1_1.isNull(var3_4)) break block118;
                                                                if (!var1_1.isNull(var4_5)) break block118;
                                                                if (!var1_1.isNull(var5_6)) break block118;
                                                                if (!var1_1.isNull(var6_7)) break block118;
                                                                if (!var1_1.isNull(var7_8)) break block118;
                                                                if (!var1_1.isNull(var8_9)) break block118;
                                                                if (!var1_1.isNull(var9_10)) break block118;
                                                                if (!var1_1.isNull(var10_11)) break block118;
                                                                if (!var1_1.isNull(var11_12)) break block118;
                                                                if (!var1_1.isNull(var12_13)) break block118;
                                                                if (!var1_1.isNull(var13_14)) break block118;
                                                                if (!var1_1.isNull(var14_15)) break block118;
                                                                if (!var1_1.isNull(var15_16)) break block118;
                                                                if (!var1_1.isNull(var16_17)) break block118;
                                                                if (!var1_1.isNull(var17_18)) break block118;
                                                                var30_33 = var23_24 = null;
                                                                ** GOTO lbl289
                                                            }
                                                            v18 = var1_1;
                                                            v19 = var7_8;
                                                            v20 = var1_1;
                                                            v21 = var6_7;
                                                            v22 = var1_1;
                                                            v23 = var5_6;
                                                            v24 = var1_1;
                                                            v25 = var4_5;
                                                            v26 = var1_1;
                                                            v27 = var3_4;
                                                            var23_24 = var1_1.getString(var2_2);
                                                            var24_25 = v26.getString(v27);
                                                            var25_27 = v24.getInt(v25);
                                                            var26_29 = v22.getInt(v23);
                                                            var27_30 = v20.getInt(v21);
                                                            if (!v18.isNull(v19)) break block119;
                                                            var28_31 /* !! */  = null;
                                                            break block120;
                                                        }
                                                        var28_31 /* !! */  = var1_1.getLong(var7_8);
                                                    }
                                                    v28 = var1_1;
                                                    v29 = var8_9;
                                                    var28_31 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var28_31 /* !! */ );
                                                    if (!v28.isNull(v29)) break block121;
                                                    var29_32 /* !! */  = null;
                                                    break block122;
                                                }
                                                var29_32 /* !! */  = var1_1.getLong(var8_9);
                                            }
                                            v30 = var1_1;
                                            v31 = var9_10;
                                            var29_32 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var29_32 /* !! */ );
                                            if (!v30.isNull(v31)) break block123;
                                            if (!var1_1.isNull(var10_11)) break block123;
                                            if (!var1_1.isNull(var11_12)) break block123;
                                            if (!var1_1.isNull(var12_13)) break block123;
                                            if (!var1_1.isNull(var13_14)) break block123;
                                            if (!var1_1.isNull(var14_15)) break block123;
                                            if (!var1_1.isNull(var15_16)) break block123;
                                            var35_38 = var30_33 = null;
                                            ** GOTO lbl270
                                        }
                                        v32 = var1_1;
                                        v33 = var14_15;
                                        v34 = var1_1;
                                        v35 = var13_14;
                                        v36 = this;
                                        v37 = var1_1;
                                        v38 = var12_13;
                                        v39 = var1_1;
                                        v40 = var11_12;
                                        v41 = var1_1;
                                        v42 = var10_11;
                                        var30_33 = var1_1.getString(var9_10);
                                        var31_34 = v41.getString(v42);
                                        var32_35 = v39.getString(v40);
                                        var33_36 = v37.getString(v38);
                                        var33_36 = MessagingDao_Impl.access$000(v36.MessagingDao_Impl.this).stringToStringList((String)var33_36);
                                        var34_37 = v34.getString(v35);
                                        if (!v32.isNull(v33)) break block124;
                                        if (!var1_1.isNull(var15_16)) break block124;
                                        var37_40 = var35_38 = null;
                                        break block125;
                                    }
                                    v43 = var1_1;
                                    v44 = var15_16;
                                    var35_38 = var1_1.getString(var14_15);
                                    var36_39 = v43.getString(v44);
                                    var37_40 = v45;
                                    v45 = new TinodePhoto((String)var35_38, var36_39);
                                }
                                var35_38 = v46;
                                v46 = new TopicPublicData((String)var30_33, var31_34, (String)var32_35, (TinodePhoto)var37_40, (List<String>)var33_36, var34_37);
lbl270:
                                // 2 sources

                                if (!var1_1.isNull(var16_17)) break block126;
                                if (!var1_1.isNull(var17_18)) break block126;
                                var32_35 = var30_33 = null;
                                break block127;
                            }
                            v47 = var1_1;
                            v48 = var17_18;
                            var30_33 = var1_1.getString(var16_17);
                            var31_34 = v47.getString(v48);
                            var32_35 = v49;
                            v49 = new Access((String)var30_33, var31_34);
                        }
                        var30_33 = v50;
                        v50 = new Chat((String)var23_24, (String)var24_25, var25_27, var26_29, var27_30, (Date)var28_31 /* !! */ , (Date)var29_32 /* !! */ , (TopicPublicData)var35_38, (Access)var32_35);
lbl289:
                        // 2 sources

                        var23_24 = (ArrayList)var20_21.get((Object)var1_1.getString(var2_2));
                        if (var23_24 != null) ** GOTO lbl294
                        var23_24 = v51;
                        v51 = new ArrayList<E>();
lbl294:
                        // 2 sources

                        if ((var24_25 = (ArrayList)var21_22.get((Object)var1_1.getString(var2_2))) != null) break block128;
                        var24_25 = v52;
                        v52 = new ArrayList<E>();
                    }
                    var25_26 = v53;
                    v53 = new ChatRelation((Chat)var30_33, (List<TinodeContact>)var23_24, (List<ChatMessage>)var24_25);
lbl302:
                    // 2 sources

                    v54 = var22_23;
                    v55 = var19_20;
                    v56 = var1_1;
                    v57 = var2_2;
                    var23_24 = (TinodeContact)var18_19.get((Object)var1_1.getString(var2_2));
                    var24_25 = (WatchPartyStatus)v55.get((Object)v56.getString(v57));
                    v54.add(new WatchPartyRelation((ChatRelation)var25_26, (TinodeContact)var23_24, (WatchPartyStatus)var24_25));
                    continue;
                }
lbl314:
                // 2 sources

                v58 = var22_23;
                v59 = this;
                v60 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v60.close();
                {
                    catch (Throwable v61) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v61;
                    }
                }
                MessagingDao_Impl.access$100(v59.MessagingDao_Impl.this).endTransaction();
                return v58;
                catch (Throwable var2_3) {
                    var1_1.close();
                    throw var2_3;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<WatchPartyRelation> observeWatchPartyRelation(String stringArray) {
        Callable<WatchPartyRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Chat WHERE Chat.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[6];
        stringArray = stringArray2;
        stringArray2[0] = "ChatOwnerCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "WatchPartyStatus";
        stringArray2[3] = "ChatParticipantCrossRef";
        stringArray2[4] = "ChatMessage";
        stringArray2[5] = "Chat";
        Callable<WatchPartyRelation> callable2 = callable;
        callable = new Callable<WatchPartyRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public WatchPartyRelation call() throws Exception {
                block124: {
                    block111: {
                        block123: {
                            block122: {
                                block121: {
                                    block120: {
                                        block119: {
                                            block118: {
                                                block117: {
                                                    block116: {
                                                        block115: {
                                                            block114: {
                                                                block113: {
                                                                    block112: {
                                                                        var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                        var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                        var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                        var4_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                        var5_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                        var6_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                        var7_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                        var8_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                        var9_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"externalId");
                                                                        var10_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"fn");
                                                                        var11_24 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"title");
                                                                        var12_26 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"tags");
                                                                        var13_28 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                        var14_30 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"data");
                                                                        var15_32 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"format");
                                                                        var16_34 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                        var17_35 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                        var18_36 = v0;
                                                                        v0 = new ArrayMap();
                                                                        var19_37 = v1;
                                                                        v1 = new ArrayMap();
                                                                        var20_38 = v2;
                                                                        v2 = new ArrayMap();
                                                                        var21_39 = v3;
                                                                        try {
                                                                            v3 = new ArrayMap();
                                                                            ** while (var1_1.moveToNext())
                                                                        }
                                                                        catch (Throwable v4) {
                                                                            var1_1.close();
                                                                            throw v4;
                                                                        }
lbl-1000:
                                                                        // 1 sources

                                                                        {
                                                                            block110: {
                                                                                v5 = var20_38;
                                                                                v6 = var1_1;
                                                                                v7 = var2_2;
                                                                                v8 = var19_37;
                                                                                v9 = var1_1;
                                                                                v10 = var2_2;
                                                                                var18_36.put((Object)var1_1.getString(var2_2), null);
                                                                                v8.put((Object)v9.getString(v10), null);
                                                                                var22_40 = v6.getString(v7);
                                                                                if ((ArrayList)v5.get((Object)var22_40) != null) break block110;
                                                                                var20_38.put((Object)var22_40, new ArrayList<E>());
                                                                            }
                                                                            v11 = var21_39;
                                                                            var22_40 = var1_1.getString(var2_2);
                                                                            if ((ArrayList)v11.get((Object)var22_40) != null) continue;
                                                                            var21_39.put((Object)var22_40, new ArrayList<E>());
                                                                            continue;
                                                                        }
lbl80:
                                                                        // 2 sources

                                                                        v12 = var1_1;
                                                                        v13 = this;
                                                                        v14 = v13;
                                                                        v15 = v13;
                                                                        v16 = v13;
                                                                        v17 = v13;
                                                                        var1_1.moveToPosition(-1);
                                                                        MessagingDao_Impl.access$500(v14.MessagingDao_Impl.this, var18_36);
                                                                        MessagingDao_Impl.access$600(v15.MessagingDao_Impl.this, var19_37);
                                                                        MessagingDao_Impl.access$300(v16.MessagingDao_Impl.this, var20_38);
                                                                        MessagingDao_Impl.access$400(v17.MessagingDao_Impl.this, var21_39);
                                                                        if (!v12.moveToFirst()) break block111;
                                                                        if (!var1_1.isNull(var2_2)) break block112;
                                                                        if (!var1_1.isNull(var3_4)) break block112;
                                                                        if (!var1_1.isNull(var4_8)) break block112;
                                                                        if (!var1_1.isNull(var5_11)) break block112;
                                                                        if (!var1_1.isNull(var6_13)) break block112;
                                                                        if (!var1_1.isNull(var7_14)) break block112;
                                                                        if (!var1_1.isNull(var8_16)) break block112;
                                                                        if (!var1_1.isNull(var9_18)) break block112;
                                                                        if (!var1_1.isNull(var10_21)) break block112;
                                                                        if (!var1_1.isNull(var11_24)) break block112;
                                                                        if (!var1_1.isNull(var12_26)) break block112;
                                                                        if (!var1_1.isNull(var13_28)) break block112;
                                                                        if (!var1_1.isNull(var14_30)) break block112;
                                                                        if (!var1_1.isNull(var15_32)) break block112;
                                                                        if (!var1_1.isNull(var16_34)) break block112;
                                                                        if (!var1_1.isNull(var17_35)) break block112;
                                                                        var5_12 = this = null;
                                                                        ** GOTO lbl300
                                                                    }
                                                                    if (!var1_1.isNull(var2_2)) break block113;
                                                                    if (!var1_1.isNull(var3_4)) break block113;
                                                                    if (!var1_1.isNull(var4_8)) break block113;
                                                                    if (!var1_1.isNull(var5_11)) break block113;
                                                                    if (!var1_1.isNull(var6_13)) break block113;
                                                                    if (!var1_1.isNull(var7_14)) break block113;
                                                                    if (!var1_1.isNull(var8_16)) break block113;
                                                                    if (!var1_1.isNull(var9_18)) break block113;
                                                                    if (!var1_1.isNull(var10_21)) break block113;
                                                                    if (!var1_1.isNull(var11_24)) break block113;
                                                                    if (!var1_1.isNull(var12_26)) break block113;
                                                                    if (!var1_1.isNull(var13_28)) break block113;
                                                                    if (!var1_1.isNull(var14_30)) break block113;
                                                                    if (!var1_1.isNull(var15_32)) break block113;
                                                                    if (!var1_1.isNull(var16_34)) break block113;
                                                                    if (!var1_1.isNull(var17_35)) break block113;
                                                                    this = null;
                                                                    ** GOTO lbl287
                                                                }
                                                                v18 = var1_1;
                                                                v19 = var7_14;
                                                                v20 = var1_1;
                                                                v21 = var6_13;
                                                                v22 = var1_1;
                                                                v23 = var5_11;
                                                                v24 = var1_1;
                                                                v25 = var4_8;
                                                                v26 = var1_1;
                                                                v27 = var3_4;
                                                                var3_5 = var1_1.getString(var2_2);
                                                                var4_9 = v26.getString(v27);
                                                                var5_11 = v24.getInt(v25);
                                                                var6_13 = v22.getInt(v23);
                                                                var22_41 = v20.getInt(v21);
                                                                if (!v18.isNull(v19)) break block114;
                                                                var7_15 /* !! */  = null;
                                                                break block115;
                                                            }
                                                            var7_15 /* !! */  = var1_1.getLong(var7_14);
                                                        }
                                                        v28 = var1_1;
                                                        v29 = var8_16;
                                                        var7_15 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var7_15 /* !! */ );
                                                        if (!v28.isNull(v29)) break block116;
                                                        var8_17 /* !! */  = null;
                                                        break block117;
                                                    }
                                                    var8_17 /* !! */  = var1_1.getLong(var8_16);
                                                }
                                                v30 = var1_1;
                                                v31 = var9_18;
                                                var8_17 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var8_17 /* !! */ );
                                                if (!v30.isNull(v31)) break block118;
                                                if (!var1_1.isNull(var10_21)) break block118;
                                                if (!var1_1.isNull(var11_24)) break block118;
                                                if (!var1_1.isNull(var12_26)) break block118;
                                                if (!var1_1.isNull(var13_28)) break block118;
                                                if (!var1_1.isNull(var14_30)) break block118;
                                                if (!var1_1.isNull(var15_32)) break block118;
                                                var13_29 = this = null;
                                                ** GOTO lbl268
                                            }
                                            v32 = var1_1;
                                            v33 = var14_30;
                                            v34 = var1_1;
                                            v35 = var13_28;
                                            v36 = this;
                                            v37 = var1_1;
                                            v38 = var12_26;
                                            v39 = var1_1;
                                            v40 = var11_24;
                                            v41 = var1_1;
                                            v42 = var10_21;
                                            this = var1_1.getString(var9_18);
                                            var9_19 = v41.getString(v42);
                                            var10_22 = v39.getString(v40);
                                            var11_25 = v37.getString(v38);
                                            var11_25 = MessagingDao_Impl.access$000(v36.MessagingDao_Impl.this).stringToStringList((String)var11_25);
                                            var12_27 = v34.getString(v35);
                                            if (!v32.isNull(v33)) break block119;
                                            if (!var1_1.isNull(var15_32)) break block119;
                                            var15_33 = var13_29 = null;
                                            break block120;
                                        }
                                        v43 = var1_1;
                                        v44 = var15_32;
                                        var13_29 = var1_1.getString(var14_30);
                                        var14_31 = v43.getString(v44);
                                        var15_33 = v45;
                                        v45 = new TinodePhoto((String)var13_29, var14_31);
                                    }
                                    var13_29 = v46;
                                    v46 = new TopicPublicData((String)this, var9_19, var10_22, (TinodePhoto)var15_33, (List<String>)var11_25, var12_27);
lbl268:
                                    // 2 sources

                                    if (!var1_1.isNull(var16_34)) break block121;
                                    if (!var1_1.isNull(var17_35)) break block121;
                                    var10_23 = this = null;
                                    break block122;
                                }
                                v47 = var1_1;
                                v48 = var17_35;
                                this = var1_1.getString(var16_34);
                                var9_20 = v47.getString(v48);
                                var10_23 = v49;
                                v49 = new Access((String)this, var9_20);
                            }
                            this = v50;
                            v50 = new Chat(var3_5, var4_9, var5_11, var6_13, var22_41, (Date)var7_15 /* !! */ , (Date)var8_17 /* !! */ , (TopicPublicData)var13_29, (Access)var10_23);
lbl287:
                            // 2 sources

                            var3_6 = (ArrayList)var20_38.get((Object)var1_1.getString(var2_2));
                            if (var3_6 != null) ** GOTO lbl292
                            var3_6 = v51;
                            v51 = new ArrayList<E>();
lbl292:
                            // 2 sources

                            if ((var4_10 = (ArrayList)var21_39.get((Object)var1_1.getString(var2_2))) != null) break block123;
                            var4_10 = v52;
                            v52 = new ArrayList<E>();
                        }
                        var5_12 = v53;
                        v53 = new ChatRelation((Chat)this, var3_6, var4_10);
lbl300:
                        // 2 sources

                        v54 = var19_37;
                        v55 = var1_1;
                        v56 = var2_2;
                        this = (TinodeContact)var18_36.get((Object)var1_1.getString(var2_2));
                        var2_3 = (WatchPartyStatus)v54.get((Object)v55.getString(v56));
                        var3_7 = v57;
                        v57 = new WatchPartyRelation((ChatRelation)var5_12, (TinodeContact)this, var2_3);
                        break block124;
                    }
                    var3_7 = null;
                }
                var1_1.close();
                return var3_7;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public WaveMessage getWaveByIdAndDate(String string2, Date comparable) {
        Object object;
        Cursor cursor;
        RoomSQLiteQuery roomSQLiteQuery;
        block21: {
            block18: {
                WaveMessage waveMessage;
                String string3;
                String string4;
                String string5;
                block20: {
                    int n;
                    block19: {
                        int n2;
                        roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WaveMessage WHERE chatUserId = ? AND sentAt >= ?", (int)2);
                        int n3 = 1;
                        if (string2 == null) {
                            roomSQLiteQuery.bindNull(n3);
                        } else {
                            roomSQLiteQuery.bindString(n3, string2);
                        }
                        int n4 = 2;
                        comparable = ((MessagingDao_Impl)((Object)date)).__converters.dateToString((Date)comparable);
                        if (comparable == null) {
                            roomSQLiteQuery.bindNull(n4);
                        } else {
                            roomSQLiteQuery.bindLong(n4, ((Long)comparable).longValue());
                        }
                        MessagingDao_Impl messagingDao_Impl = date;
                        messagingDao_Impl.__db.assertNotSuspendingTransaction();
                        cursor = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                        try {
                            n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatUserId");
                        }
                        catch (Throwable throwable) {
                            cursor.close();
                            roomSQLiteQuery.release();
                            throw throwable;
                        }
                        n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userName");
                        int n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userAvatar");
                        n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sentAt");
                        if (!cursor.moveToFirst()) break block18;
                        Cursor cursor2 = cursor;
                        int n6 = n;
                        Cursor cursor3 = cursor;
                        int n7 = n5;
                        Cursor cursor4 = cursor;
                        int n8 = n3;
                        string5 = cursor.getString(n2);
                        string4 = cursor4.getString(n8);
                        string3 = cursor3.getString(n7);
                        if (!cursor2.isNull(n6)) break block19;
                        object = null;
                        break block20;
                    }
                    object = cursor.getLong(n);
                }
                Date date = ((MessagingDao_Impl)((Object)date)).__converters.timestampToDate((Long)object);
                object = waveMessage;
                waveMessage = new WaveMessage(string5, string4, string3, date);
                break block21;
            }
            object = null;
        }
        cursor.close();
        roomSQLiteQuery.release();
        return object;
    }

    @Override
    public void saveOrUpdateChatMessage(ChatMessage chatMessage) {
        MessagingDao.DefaultImpls.saveOrUpdateChatMessage(this, chatMessage);
    }

    @Override
    public Maybe<ChatMessage> getChatMessage(String string2, int n) {
        return MessagingDao.DefaultImpls.getChatMessage(this, string2, n);
    }

    @Override
    public DataSource.Factory<Integer, ChatMessage> getChatMessagesLiveData(String string2) {
        return MessagingDao.DefaultImpls.getChatMessagesLiveData(this, string2);
    }

    @Override
    public List<ChatMessage> getChatMessagesList(String string2, Integer n, Integer n2, int n3) {
        return MessagingDao.DefaultImpls.getChatMessagesList(this, string2, n, n2, n3);
    }

    @Override
    public Observable<List<ChatMessage>> getChatMessages(String string2, Integer n, Integer n2, int n3) {
        return MessagingDao.DefaultImpls.getChatMessages(this, string2, n, n2, n3);
    }

    @Override
    public Observable<List<Chat>> getChats(boolean bl) {
        return MessagingDao.DefaultImpls.getChats(this, bl);
    }

    @Override
    public Observable<Chat> getChat(String string2) {
        return MessagingDao.DefaultImpls.getChat(this, string2);
    }

    @Override
    public Observable<List<WatchParty>> getWatchParties() {
        return MessagingDao.DefaultImpls.getWatchParties(this);
    }

    @Override
    public Observable<WatchParty> observeWatchParty(String string2) {
        return MessagingDao.DefaultImpls.observeWatchParty(this, string2);
    }
}

