/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.utils;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.SoundPool;
import io.streamlayer.sdk.R;
import javax.inject.Singleton;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\"\u0010#J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004R\u001d\u0010\u000b\u001a\u00020\u00068B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\u00108\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0017\u001a\u00020\u00138B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\b\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020\u00138B@\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0016\u00a8\u0006$"}, d2={"Lio/streamlayer/utils/RingtonePlayer;", "", "", "ring", "()V", "dismiss", "Landroid/media/AudioManager;", "audioManager$delegate", "Lkotlin/Lazy;", "getAudioManager", "()Landroid/media/AudioManager;", "audioManager", "Landroid/media/SoundPool;", "kotlin.jvm.PlatformType", "soundPool", "Landroid/media/SoundPool;", "", "soundRingtone", "I", "", "maxVolume$delegate", "getMaxVolume", "()F", "maxVolume", "", "isPlaying", "Z", "playbackId", "Ljava/lang/Integer;", "Landroid/content/Context;", "context", "Landroid/content/Context;", "getCurrentVolume", "currentVolume", "<init>", "(Landroid/content/Context;)V", "sdk_originalRelease"})
public final class RingtonePlayer {
    private final Lazy audioManager$delegate;
    private boolean isPlaying;
    private final SoundPool soundPool;
    private final int soundRingtone;
    private Integer playbackId;
    private final Lazy maxVolume$delegate;
    private final Context context;

    private final AudioManager getAudioManager() {
        return (AudioManager)this.audioManager$delegate.getValue();
    }

    private final float getMaxVolume() {
        return ((Number)this.maxVolume$delegate.getValue()).floatValue();
    }

    private final float getCurrentVolume() {
        return this.getAudioManager().getStreamMaxVolume(2);
    }

    public RingtonePlayer(@NotNull Context context) {
        SoundPool soundPool;
        RingtonePlayer ringtonePlayer = this;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ringtonePlayer.context = context;
        ringtonePlayer.audioManager$delegate = LazyKt.lazy((Function0)new Function0<AudioManager>(this){
            final /* synthetic */ RingtonePlayer this$0;
            {
                this.this$0 = ringtonePlayer;
                super(0);
            }

            @NotNull
            public final AudioManager invoke() {
                Object object = RingtonePlayer.access$getContext$p(object.this$0).getSystemService("audio");
                if (object != null) {
                    return (AudioManager)object;
                }
                throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
            }
        });
        this.soundPool = soundPool = new SoundPool.Builder().setAudioAttributes(new AudioAttributes.Builder().setUsage(6).setContentType(4).build()).build();
        ringtonePlayer.soundRingtone = soundPool.load(context, R.raw.slr_call_ringtone, 1);
        ringtonePlayer.maxVolume$delegate = LazyKt.lazy((Function0)new Function0<Float>(this){
            final /* synthetic */ RingtonePlayer this$0;
            {
                this.this$0 = ringtonePlayer;
                super(0);
            }

            public final float invoke() {
                return RingtonePlayer.access$getAudioManager$p(this.this$0).getStreamMaxVolume(2);
            }
        });
    }

    public static final /* synthetic */ Context access$getContext$p(RingtonePlayer ringtonePlayer) {
        return ringtonePlayer.context;
    }

    public static final /* synthetic */ AudioManager access$getAudioManager$p(RingtonePlayer ringtonePlayer) {
        return ringtonePlayer.getAudioManager();
    }

    public final void ring() {
        float f;
        if (this.isPlaying) {
            return;
        }
        RingtonePlayer ringtonePlayer = this;
        ringtonePlayer.isPlaying = true;
        float f2 = f = ringtonePlayer.getCurrentVolume() / this.getMaxVolume();
        ringtonePlayer.playbackId = ringtonePlayer.soundPool.play(this.soundRingtone, f2, f2, 1, -1, 1.0f);
    }

    public final void dismiss() {
        this.isPlaying = false;
        Integer n = this.playbackId;
        if (n != null) {
            int n2 = n;
            this.soundPool.stop(n2);
            this.playbackId = null;
        }
    }
}

