/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import io.streamlayer.common.dagger.components.DaggerStreamLayerComponent;
import io.streamlayer.common.dagger.components.StreamLayerComponent;
import io.streamlayer.common.dagger.modules.ApiServiceModule;
import io.streamlayer.common.dagger.modules.ContextModule;
import io.streamlayer.sdk.Environment;
import io.streamlayer.sdk.StreamLayer;
import io.streamlayer.sdk.StreamLayerConfig$WhenMappings;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001%B\t\b\u0002\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\t8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u00188\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\t8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0017R\u0016\u0010\u001d\u001a\u00020\u00188\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001aR\u0016\u0010\u001e\u001a\u00020\t8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0017R\u0016\u0010\u001f\u001a\u00020\u00188\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001aR\u0016\u0010 \u001a\u00020\u00188\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b \u0010\u001aR\u0016\u0010!\u001a\u00020\u00188\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b!\u0010\u001aR\u0016\u0010\"\u001a\u00020\t8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\"\u0010\u0017\u00a8\u0006&"}, d2={"Lio/streamlayer/sdk/StreamLayerConfig;", "", "Lio/streamlayer/sdk/StreamLayerConfig$EnvironmentType;", "environmentType", "Lio/streamlayer/sdk/Environment;", "buildEnvironment", "(Lio/streamlayer/sdk/StreamLayerConfig$EnvironmentType;)Lio/streamlayer/sdk/Environment;", "Landroid/content/Context;", "context", "", "", "isEnvChanged", "", "initialize", "(Landroid/content/Context;IZ)V", "(Landroid/content/Context;Lio/streamlayer/sdk/StreamLayerConfig$EnvironmentType;Z)V", "checkAndHandleEnvironment", "(Landroid/content/Context;)V", "setEnvironment", "(Landroid/content/Context;Lio/streamlayer/sdk/StreamLayerConfig$EnvironmentType;)V", "getCurrentEnvironmentPosition", "(Landroid/content/Context;)I", "STAGE_GRPC_PORT", "I", "", "PROD_CHAT_GRPC_URL", "Ljava/lang/String;", "STAGE_CHAT_GRPC_URL", "STAGE_CHAT_GRPC_PORT", "PROD_GRPC_URL", "PROD_GRPC_PORT", "STAGE_GRPC_URL", "PROD_SDK_KEY", "STAGING_SDK_KEY", "PROD_CHAT_GRPC_PORT", "<init>", "()V", "EnvironmentType", "sdk_originalRelease"})
public final class StreamLayerConfig {
    private static final String PROD_GRPC_URL = "grpc.streamlayer.io";
    private static final int PROD_GRPC_PORT = 443;
    private static final String PROD_CHAT_GRPC_URL = "chat.streamlayer.io";
    private static final int PROD_CHAT_GRPC_PORT = 443;
    private static final String STAGE_GRPC_URL = "grpc.next.streamlayer.io";
    private static final int STAGE_GRPC_PORT = 443;
    private static final String STAGE_CHAT_GRPC_URL = "chat.next.streamlayer.io";
    private static final int STAGE_CHAT_GRPC_PORT = 443;
    private static final String PROD_SDK_KEY = "16ab1e23f2a8682d3c176c611c4ee2c1afaa962ee20b6f451b4293cd5a67bf5a";
    private static final String STAGING_SDK_KEY = "71b11eb81f490f1133bc9c7ab0cfe0509ba209e62ce12e304976911c9591cfc1";
    public static final StreamLayerConfig INSTANCE = new StreamLayerConfig();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Environment buildEnvironment(EnvironmentType environmentType) {
        Environment environment;
        int n = StreamLayerConfig$WhenMappings.$EnumSwitchMapping$0[environmentType.ordinal()];
        if (n != 1) {
            Environment environment2;
            if (n != 2) throw new NoWhenBranchMatchedException();
            environment = environment2;
            environment2 = new Environment(STAGE_GRPC_URL, 443, STAGE_CHAT_GRPC_URL, 443, STAGING_SDK_KEY);
            return environment;
        } else {
            Environment environment3;
            environment = environment3;
            environment3 = new Environment(PROD_GRPC_URL, 443, PROD_CHAT_GRPC_URL, 443, PROD_SDK_KEY);
        }
        return environment;
    }

    private StreamLayerConfig() {
    }

    public final void initialize(@NotNull Context context, int n, boolean bl) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        EnvironmentType environmentType = EnvironmentType.PRODUCTION;
        if (n == environmentType.ordinal()) {
            this.initialize(context, environmentType, bl);
        } else {
            EnvironmentType environmentType2 = EnvironmentType.STAGING;
            if (n == environmentType2.ordinal()) {
                this.initialize(context, environmentType2, bl);
            }
        }
    }

    public final void initialize(@NotNull Context context, @NotNull EnvironmentType object, boolean bl) {
        EnvironmentType environmentType = object;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environmentType), (String)"environmentType");
        Environment environment = ((StreamLayerConfig)((Object)environment)).buildEnvironment(environmentType);
        object = StreamLayer.INSTANCE;
        StreamLayerComponent streamLayerComponent = DaggerStreamLayerComponent.builder().contextModule(new ContextModule(context)).apiServiceModule(new ApiServiceModule(environment)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)streamLayerComponent, (String)"DaggerStreamLayerCompone\u2026nt))\n            .build()");
        ((StreamLayer)object).setComponent$sdk_originalRelease(streamLayerComponent);
        if (bl) {
            ((StreamLayer)object).getComponent$sdk_originalRelease().getSessionPrefImpl().logout();
        }
        ((StreamLayer)object).getComponent$sdk_originalRelease().getSessionPrefImpl().setSdkKey(environment.getSdkKey());
    }

    public final void checkAndHandleEnvironment(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        SharedPreferences sharedPreferences = context2.getSharedPreferences("environment_pref", 0);
        if (sharedPreferences.contains("environment_type")) {
            SharedPreferences sharedPreferences2 = sharedPreferences;
            int n = sharedPreferences2.getInt("environment_type", 1);
            this.initialize(context, n, sharedPreferences2.getBoolean("is_environment_changed", false));
            sharedPreferences.edit().remove("is_environment_changed").apply();
        }
    }

    public final void setEnvironment(@NotNull Context context, @NotNull EnvironmentType environmentType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environmentType), (String)"environmentType");
        SharedPreferences.Editor editor = context.getSharedPreferences("environment_pref", 0).edit();
        editor.putInt("environment_type", environmentType.ordinal());
        editor.putBoolean("is_environment_changed", true);
        editor.apply();
    }

    public final int getCurrentEnvironmentPosition(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        return context2.getSharedPreferences("environment_pref", 0).getInt("environment_type", 1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/sdk/StreamLayerConfig$EnvironmentType;", "", "<init>", "(Ljava/lang/String;I)V", "PRODUCTION", "STAGING", "sdk_originalRelease"})
    public static final class EnvironmentType
    extends Enum<EnvironmentType> {
        public static final /* enum */ EnvironmentType PRODUCTION;
        public static final /* enum */ EnvironmentType STAGING;
        private static final /* synthetic */ EnvironmentType[] $VALUES;

        static {
            EnvironmentType environmentType;
            EnvironmentType environmentType2;
            EnvironmentType[] environmentTypeArray = new EnvironmentType[2];
            EnvironmentType environmentType3 = environmentType2;
            PRODUCTION = new EnvironmentType();
            environmentTypeArray[0] = environmentType3;
            environmentType3 = environmentType;
            STAGING = new EnvironmentType();
            environmentTypeArray[1] = environmentType3;
            $VALUES = environmentTypeArray;
        }

        public static EnvironmentType[] values() {
            return (EnvironmentType[])$VALUES.clone();
        }

        public static EnvironmentType valueOf(String string2) {
            return Enum.valueOf(EnvironmentType.class, string2);
        }
    }
}

