/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.voximplant;

import com.voximplant.sdk.call.CallSettings;
import com.voximplant.sdk.call.ICall;
import com.voximplant.sdk.call.ICallListener;
import com.voximplant.sdk.call.VideoCodec;
import com.voximplant.sdk.call.VideoFlags;
import com.voximplant.sdk.client.AuthParams;
import com.voximplant.sdk.client.ClientState;
import com.voximplant.sdk.client.IClient;
import com.voximplant.sdk.client.IClientLoginListener;
import com.voximplant.sdk.client.IClientSessionListener;
import com.voximplant.sdk.client.LoginError;
import io.streamlayer.common.data.voximplant.AuthError;
import io.streamlayer.common.data.voximplant.CallClientWrapper;
import io.streamlayer.common.data.voximplant.VoximplantClientManagerKt;
import io.streamlayer.common.session.CallAuthDetails;
import io.streamlayer.common.session.SessionPrefImpl;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0007\u0012\u0006\u0010<\u001a\u00020;\u0012\u0006\u0010C\u001a\u00020B\u00a2\u0006\u0004\bD\u0010EJ\u000f\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0005J\u0017\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0005J'\u0010\u001b\u001a\u00020\u00032\u0018\b\u0002\u0010\u001a\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u0005J\u0019\u0010\u001f\u001a\u00020\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b!\u0010\u0005J\u001f\u0010#\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010'\u001a\u00020\u00032\u0006\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b*\u0010 J\u0017\u0010+\u001a\u00020\u00032\u0006\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b+\u0010(J\u0017\u0010,\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b,\u0010\nJ)\u00102\u001a\u0004\u0018\u0001012\u0006\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\r2\b\u00100\u001a\u0004\u0018\u00010/\u00a2\u0006\u0004\b2\u00103J\u001f\u00105\u001a\u00020\u00032\u0006\u00104\u001a\u0002012\b\u00100\u001a\u0004\u0018\u00010/\u00a2\u0006\u0004\b5\u00106R\u0018\u00107\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R&\u00109\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0016\u0010<\u001a\u00020;8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0016\u0010?\u001a\u00020>8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u0018\u0010A\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u00108\u00a8\u0006F"}, d2={"Lio/streamlayer/common/data/voximplant/VoximplantClientManager;", "Lcom/voximplant/sdk/client/IClientSessionListener;", "Lcom/voximplant/sdk/client/IClientLoginListener;", "", "safeConnect", "()V", "loginWithToken", "Lcom/voximplant/sdk/client/AuthParams;", "authParams", "saveAuthDetailsToSharedPreferences", "(Lcom/voximplant/sdk/client/AuthParams;)V", "", "lifeTime", "", "isTokenExpired", "(J)Z", "loginTokensExist", "()Z", "", "voximplantUserId", "password", "login", "(Ljava/lang/String;Ljava/lang/String;)V", "logout", "Lkotlin/Function1;", "Lio/streamlayer/common/data/voximplant/AuthError;", "callback", "reconnectIfNeeded", "(Lkotlin/jvm/functions/Function1;)V", "onConnectionEstablished", "p0", "onConnectionFailed", "(Ljava/lang/String;)V", "onConnectionClosed", "displayName", "onLoginSuccessful", "(Ljava/lang/String;Lcom/voximplant/sdk/client/AuthParams;)V", "Lcom/voximplant/sdk/client/LoginError;", "reason", "onLoginFailed", "(Lcom/voximplant/sdk/client/LoginError;)V", "key", "onOneTimeKeyGenerated", "onRefreshTokenFailed", "onRefreshTokenSuccess", "topicId", "isVideoEnabled", "Lcom/voximplant/sdk/call/ICallListener;", "listener", "Lcom/voximplant/sdk/call/ICall;", "createCall", "(Ljava/lang/String;ZLcom/voximplant/sdk/call/ICallListener;)Lcom/voximplant/sdk/call/ICall;", "call", "endCall", "(Lcom/voximplant/sdk/call/ICall;Lcom/voximplant/sdk/call/ICallListener;)V", "mPassword", "Ljava/lang/String;", "reconnectCompletion", "Lkotlin/jvm/functions/Function1;", "Lio/streamlayer/common/session/SessionPrefImpl;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "Lcom/voximplant/sdk/client/IClient;", "client", "Lcom/voximplant/sdk/client/IClient;", "mUsername", "Lio/streamlayer/common/data/voximplant/CallClientWrapper;", "clientWrapper", "<init>", "(Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/common/data/voximplant/CallClientWrapper;)V", "sdk_originalRelease"})
public final class VoximplantClientManager
implements IClientSessionListener,
IClientLoginListener {
    private final IClient client;
    private String mUsername;
    private String mPassword;
    private Function1<? super AuthError, Unit> reconnectCompletion;
    private final SessionPrefImpl session;

    public static /* synthetic */ void reconnectIfNeeded$default(VoximplantClientManager voximplantClientManager, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        voximplantClientManager.reconnectIfNeeded((Function1<? super AuthError, Unit>)function1);
    }

    private final void safeConnect() {
        if (this.client.getClientState() == ClientState.DISCONNECTED) {
            try {
                this.client.connect();
            }
            catch (IllegalStateException illegalStateException) {
                String cfr_ignored_0 = "login: exception on connect: " + illegalStateException;
            }
        }
    }

    private final void loginWithToken() {
        VoximplantClientManager voximplantClientManager = object;
        voximplantClientManager.safeConnect();
        if (voximplantClientManager.client.getClientState() == ClientState.CONNECTED && ((VoximplantClientManager)object).loginTokensExist()) {
            Object object;
            VoximplantClientManager voximplantClientManager2 = object;
            voximplantClientManager2.mUsername = voximplantClientManager2.session.getTinodeUserId();
            CallAuthDetails callAuthDetails = voximplantClientManager2.session.getCallAuthDetails();
            if (!voximplantClientManager2.isTokenExpired(callAuthDetails.getAccessExpired())) {
                object = ((VoximplantClientManager)object).mUsername;
                ((VoximplantClientManager)object).client.loginWithAccessToken((String)object, callAuthDetails.getAccessToken());
            } else if (!((VoximplantClientManager)object).isTokenExpired(callAuthDetails.getRefreshExpired())) {
                object = ((VoximplantClientManager)object).mUsername;
                ((VoximplantClientManager)object).client.refreshToken((String)object, callAuthDetails.getRefreshToken());
            }
        }
    }

    private final void saveAuthDetailsToSharedPreferences(AuthParams authParams) {
        this.session.setCallAuthDetails(VoximplantClientManagerKt.toDomain(authParams));
    }

    private final boolean isTokenExpired(long l) {
        return System.currentTimeMillis() - this.session.getCallAuthDetails().getRefreshExpired() > l * (long)1000;
    }

    private final boolean loginTokensExist() {
        CallAuthDetails callAuthDetails = ((VoximplantClientManager)((Object)callAuthDetails)).session.getCallAuthDetails();
        return callAuthDetails.getAccessToken() != null && callAuthDetails.getRefreshToken() != null;
    }

    @Inject
    public VoximplantClientManager(@NotNull SessionPrefImpl sessionPrefImpl, @NotNull CallClientWrapper callClientWrapper) {
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)callClientWrapper, (String)"clientWrapper");
        this.session = sessionPrefImpl;
        this.client = callClientWrapper.getVoximplantClient();
        this.client.setClientLoginListener((IClientLoginListener)this);
        this.client.setClientSessionListener((IClientSessionListener)this);
    }

    public final void login(@NotNull String string2, @NotNull String string3) {
        VoximplantClientManager voximplantClientManager = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"voximplantUserId");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"password");
        this.mUsername = string2;
        voximplantClientManager.mPassword = string3;
        voximplantClientManager.safeConnect();
        if (voximplantClientManager.client.getClientState() == ClientState.CONNECTED) {
            this.client.login(string2, string3);
        }
    }

    public final void logout() {
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            this.client.disconnect();
        }
    }

    public final void reconnectIfNeeded(@Nullable Function1<? super AuthError, Unit> function1) {
        if (this.client.getClientState() != ClientState.LOGGED_IN) {
            this.reconnectCompletion = function1;
        }
        if (this.client.getClientState() == ClientState.DISCONNECTED && this.loginTokensExist()) {
            this.safeConnect();
        } else if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke(null);
        }
    }

    public void onConnectionEstablished() {
        String string2;
        String string3 = this.mUsername;
        if (string3 != null && (string2 = this.mPassword) != null) {
            this.client.login(string3, string2);
        } else {
            this.loginWithToken();
        }
    }

    public void onConnectionFailed(@Nullable String function1) {
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onConnectionClosed() {
        this.mPassword = null;
    }

    public void onLoginSuccessful(@NotNull String function1, @NotNull AuthParams authParams) {
        VoximplantClientManager voximplantClientManager = this;
        AuthParams authParams2 = authParams;
        Intrinsics.checkParameterIsNotNull((Object)function1, (String)"displayName");
        Intrinsics.checkParameterIsNotNull((Object)authParams2, (String)"authParams");
        String cfr_ignored_0 = "Login success: " + (String)function1;
        voximplantClientManager.saveAuthDetailsToSharedPreferences(authParams2);
        function1 = voximplantClientManager.reconnectCompletion;
        if (function1 != null) {
            Unit cfr_ignored_1 = (Unit)function1.invoke(null);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginFailed(@NotNull LoginError object) {
        LoginError loginError = object;
        Intrinsics.checkParameterIsNotNull((Object)loginError, (String)"reason");
        object = VoximplantClientManagerKt.access$makeAuthError(loginError);
        String cfr_ignored_0 = "Login failed: " + ((AuthError)((Object)object)).getDescription();
        Function1<? super AuthError, Unit> function1 = this.reconnectCompletion;
        if (function1 != null) {
            Unit cfr_ignored_1 = (Unit)function1.invoke(object);
        }
        this.reconnectCompletion = null;
    }

    public void onOneTimeKeyGenerated(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"key");
    }

    public void onRefreshTokenFailed(@NotNull LoginError loginError) {
        LoginError loginError2 = loginError;
        Intrinsics.checkParameterIsNotNull((Object)loginError2, (String)"reason");
        String cfr_ignored_0 = "Refresh token failed: " + VoximplantClientManagerKt.access$makeAuthError(loginError2).getDescription();
    }

    public void onRefreshTokenSuccess(@NotNull AuthParams authParams) {
        VoximplantClientManager voximplantClientManager = this;
        Intrinsics.checkParameterIsNotNull((Object)authParams, (String)"authParams");
        voximplantClientManager.saveAuthDetailsToSharedPreferences(authParams);
        voximplantClientManager.loginWithToken();
    }

    @Nullable
    public final ICall createCall(@NotNull String string2, boolean bl, @Nullable ICallListener iCallListener) {
        CallSettings callSettings;
        VoximplantClientManager voximplantClientManager = voximplantClientManager2;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        VoximplantClientManager voximplantClientManager2 = callSettings;
        new CallSettings().videoFlags = new VideoFlags(true, bl);
        new CallSettings().preferredVideoCodec = VideoCodec.VP8;
        voximplantClientManager2 = voximplantClientManager.client.callConference("conf_" + string2, (CallSettings)voximplantClientManager2);
        if (voximplantClientManager2 != null) {
            VoximplantClientManager voximplantClientManager3 = voximplantClientManager2;
            voximplantClientManager3.addCallListener(iCallListener);
            voximplantClientManager3.start();
        }
        return voximplantClientManager2;
    }

    public final void endCall(@NotNull ICall iCall, @Nullable ICallListener iCallListener) {
        Intrinsics.checkParameterIsNotNull((Object)iCall, (String)"call");
        if (iCallListener != null) {
            iCall.removeCallListener(iCallListener);
        }
        iCall.hangup(null);
    }
}

