/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.chats;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.bornfight.utils.adapters.GenericAdapter;
import com.google.android.material.textview.MaterialTextView;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.common.views.SLRNotificationBadge;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.messaging.chats.MessagingChatsAdapter;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import io.streamlayer.utils.AcronymDrawable;
import io.streamlayer.utils.DateUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001f B\u0017\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001d\u0010\u001eJ!\u0010\u0006\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\n\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u00020\u00158\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006!"}, d2={"Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter;", "Lcom/bornfight/utils/adapters/GenericAdapter;", "Lio/streamlayer/sdk/model/messaging/Chat;", "Lkotlin/Function1;", "", "listener", "setOnChatSelectedListener", "(Lkotlin/jvm/functions/Function1;)V", "", "listItems", "setItems", "(Ljava/util/List;)V", "", "viewType", "getLayoutId", "(I)I", "Landroid/view/View;", "view", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "getViewHolder", "(Landroid/view/View;I)Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/common/session/SessionPrefImpl;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "onChatSelectedListener", "Lkotlin/jvm/functions/Function1;", "", "currentUserId", "Ljava/lang/String;", "<init>", "(Ljava/lang/String;Lio/streamlayer/common/session/SessionPrefImpl;)V", "ChatsDiffCallback", "ViewHolder", "sdk_originalRelease"})
public final class MessagingChatsAdapter
extends GenericAdapter<Chat> {
    private Function1<? super Chat, Unit> onChatSelectedListener;
    private final String currentUserId;
    private final SessionPrefImpl session;

    public MessagingChatsAdapter(@NotNull String string2, @NotNull SessionPrefImpl sessionPrefImpl) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"currentUserId");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        this.currentUserId = string2;
        this.session = sessionPrefImpl;
    }

    public static final /* synthetic */ void access$setOnChatSelectedListener$p(MessagingChatsAdapter messagingChatsAdapter, Function1 function1) {
        messagingChatsAdapter.onChatSelectedListener = function1;
    }

    public final void setOnChatSelectedListener(@NotNull Function1<? super Chat, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"listener");
        this.onChatSelectedListener = function1;
    }

    public void setItems(@NotNull List<Chat> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"listItems");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new ChatsDiffCallback(this.getListItems(), list));
        MessagingChatsAdapter messagingChatsAdapter = this;
        Intrinsics.checkExpressionValueIsNotNull((Object)diffResult, (String)"DiffUtil.calculateDiff(C\u2026is.listItems, listItems))");
        messagingChatsAdapter.getListItems().clear();
        messagingChatsAdapter.getListItems().addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)messagingChatsAdapter);
    }

    protected int getLayoutId(int n) {
        return R.layout.slr_item_messaging_chat;
    }

    @NotNull
    protected GenericAdapter.GenericViewHolder<Chat> getViewHolder(@NotNull View view, int n) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return new ViewHolder(view);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter$ViewHolder;", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/messaging/Chat;", "data", "", "getChatName", "(Lio/streamlayer/sdk/model/messaging/Chat;)Ljava/lang/String;", "", "loadImage", "(Lio/streamlayer/sdk/model/messaging/Chat;)V", "", "getUnreadMessagesCount", "(Lio/streamlayer/sdk/model/messaging/Chat;)I", "bind", "Landroid/view/View;", "itemView", "<init>", "(Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter;Landroid/view/View;)V", "sdk_originalRelease"})
    public final class ViewHolder
    extends GenericAdapter.GenericViewHolder<Chat> {
        private final String getChatName(Chat chat) {
            Object object;
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            for (Object t : chat.getParticipants()) {
                if (!(Intrinsics.areEqual((Object)((TinodeContact)t).getChatUserId(), (Object)((ViewHolder)((Object)object)).MessagingChatsAdapter.this.currentUserId) ^ true)) continue;
                arrayList2.add(t);
            }
            if (chat.getChatType() == ChatType.P2P) {
                return chat.getName();
            }
            if (arrayList2.size() <= 1) {
                object = (TinodeContact)CollectionsKt.firstOrNull(arrayList2);
                if (object == null || (object = ((TinodeContact)object).getChatName()) == null) {
                    object = chat.getName();
                }
                return object;
            }
            object = getChatName.1.INSTANCE;
            return CollectionsKt.joinToString$default(arrayList2, (CharSequence)", ", null, null, (int)0, null, (Function1)object, (int)30, null);
        }

        private final void loadImage(Chat chat) {
            ArrayList arrayList;
            Object object = arrayList;
            arrayList = new ArrayList();
            for (Object t : chat.getParticipants()) {
                if (!(Intrinsics.areEqual((Object)((TinodeContact)t).getChatUserId(), (Object)MessagingChatsAdapter.this.currentUserId) ^ true)) continue;
                object.add(t);
            }
            if (chat.getChatType() != ChatType.P2P && object.size() != 1) {
                ViewHolder viewHolder = this;
                View view = viewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                ((AppCompatImageView)view.findViewById(R.id.chatAvatar)).setBackgroundResource(R.drawable.slr_shape_circle);
                View view2 = viewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView");
                ((AppCompatImageView)view2.findViewById(R.id.chatAvatar)).setImageResource(R.drawable.slr_ic_contact_group);
            } else if ((object = (TinodeContact)CollectionsKt.firstOrNull(object)) != null) {
                ViewHolder viewHolder = this;
                View view = viewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                AppCompatImageView appCompatImageView = (AppCompatImageView)view.findViewById(R.id.chatAvatar);
                Intrinsics.checkExpressionValueIsNotNull((Object)appCompatImageView, (String)"itemView.chatAvatar");
                appCompatImageView.setBackground(null);
                View view3 = viewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"itemView");
                AppCompatImageView appCompatImageView2 = (AppCompatImageView)view3.findViewById(R.id.chatAvatar);
                Intrinsics.checkExpressionValueIsNotNull((Object)appCompatImageView2, (String)"itemView.chatAvatar");
                ProfileExtensionsKt.loadContactAvatar$default((ImageView)appCompatImageView2, (TinodeContact)object, null, 2, null);
            } else {
                ViewHolder viewHolder = this;
                View view = viewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                AppCompatImageView appCompatImageView = (AppCompatImageView)view.findViewById(R.id.chatAvatar);
                Intrinsics.checkExpressionValueIsNotNull((Object)appCompatImageView, (String)"itemView.chatAvatar");
                appCompatImageView.setBackground(null);
                View view4 = viewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"itemView");
                ((AppCompatImageView)view4.findViewById(R.id.chatAvatar)).setImageDrawable((Drawable)new AcronymDrawable(chat.getName(), 0.0f, false, null, null, null, null, 126, null));
            }
        }

        private final int getUnreadMessagesCount(Chat chat) {
            int n = MessagingChatsAdapter.this.session.getLastReadMessageSeq(chat.getChatId());
            return n != 0 ? chat.getSeq() - n : 0;
        }

        public ViewHolder(View view) {
            View.OnClickListener onClickListener;
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view);
            MessagingChatsAdapter.this = onClickListener;
            onClickListener = new View.OnClickListener(){

                public final void onClick(View view) {
                    view = object.MessagingChatsAdapter.this.onChatSelectedListener;
                    if (view != null) {
                        Object object = object.this;
                        Unit cfr_ignored_0 = (Unit)view.invoke(((ViewHolder)((Object)object)).MessagingChatsAdapter.this.getItem(object.getLayoutPosition()));
                    }
                }
            };
            view.setOnClickListener((View.OnClickListener)MessagingChatsAdapter.this);
        }

        public void bind(@NotNull Chat chat) {
            ViewHolder viewHolder = this;
            Chat chat2 = chat;
            Intrinsics.checkParameterIsNotNull((Object)chat2, (String)"data");
            viewHolder.loadImage(chat2);
            View view = viewHolder.itemView;
            Object object = (MaterialTextView)view.findViewById(R.id.chatName);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"chatName");
            object.setText((CharSequence)this.getChatName(chat));
            object = chat.getLastMessage();
            MaterialTextView materialTextView = (MaterialTextView)view.findViewById(R.id.chatMessage);
            Intrinsics.checkExpressionValueIsNotNull((Object)materialTextView, (String)"chatMessage");
            String string2 = object != null ? ((ChatMessage)object).getText() : null;
            materialTextView.setText((CharSequence)string2);
            materialTextView = (MaterialTextView)view.findViewById(R.id.chatTime);
            Intrinsics.checkExpressionValueIsNotNull((Object)materialTextView, (String)"chatTime");
            object = (object != null ? ((ChatMessage)object).getDate() : null) != null ? DateUtil.INSTANCE.toRelativeTimeString(((ChatMessage)object).getDate()) : (chat.getUpdatedAt() != null ? DateUtil.INSTANCE.toRelativeTimeString(chat.getUpdatedAt()) : "");
            materialTextView.setText((CharSequence)object);
            int n = this.getUnreadMessagesCount(chat);
            if (n > 0) {
                View view2 = view;
                ((SLRNotificationBadge)view2.findViewById(R.id.chatUnreadCount)).show(n);
                MaterialTextView materialTextView2 = (MaterialTextView)view2.findViewById(R.id.chatMessage);
                Intrinsics.checkExpressionValueIsNotNull((Object)materialTextView2, (String)"chatMessage");
                materialTextView2.setTypeface(Typeface.create((String)"sans-serif-medium", (int)0));
                ((MaterialTextView)view2.findViewById(R.id.chatMessage)).setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)R.color.slr_white));
            } else {
                View view3 = view;
                ((SLRNotificationBadge)view3.findViewById(R.id.chatUnreadCount)).hide();
                MaterialTextView materialTextView3 = (MaterialTextView)view3.findViewById(R.id.chatMessage);
                Intrinsics.checkExpressionValueIsNotNull((Object)materialTextView3, (String)"chatMessage");
                materialTextView3.setTypeface(Typeface.create((String)"sans-serif", (int)0));
                ((MaterialTextView)view3.findViewById(R.id.chatMessage)).setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)R.color.slr_gray900));
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u001f\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0007R\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter$ChatsDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "", "oldItemPosition", "newItemPosition", "", "areItemsTheSame", "(II)Z", "getOldListSize", "()I", "getNewListSize", "areContentsTheSame", "", "Lio/streamlayer/sdk/model/messaging/Chat;", "newItems", "Ljava/util/List;", "oldItems", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "sdk_originalRelease"})
    private static final class ChatsDiffCallback
    extends DiffUtil.Callback {
        private final List<Chat> oldItems;
        private final List<Chat> newItems;

        public ChatsDiffCallback(@NotNull List<Chat> list, @NotNull List<Chat> list2) {
            Intrinsics.checkParameterIsNotNull(list, (String)"oldItems");
            Intrinsics.checkParameterIsNotNull(list2, (String)"newItems");
            this.oldItems = list;
            this.newItems = list2;
        }

        public boolean areItemsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldItems.get(n).getChatId(), (Object)this.newItems.get(n2).getChatId());
        }

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean areContentsTheSame(int n, int n2) {
            Chat chat = ((ChatsDiffCallback)((Object)chat2)).oldItems.get(n);
            Chat chat2 = ((ChatsDiffCallback)((Object)chat2)).newItems.get(n2);
            if (chat.getSeq() != chat2.getSeq()) return false;
            Object object = chat.getLastMessage();
            object = object != null ? Integer.valueOf(((ChatMessage)object).getSeq()) : null;
            Object object2 = chat2.getLastMessage();
            object2 = object2 != null ? Integer.valueOf(((ChatMessage)object2).getSeq()) : null;
            if (!Intrinsics.areEqual((Object)object, (Object)object2)) return false;
            if (chat.getParticipants().size() != chat2.getParticipants().size()) return false;
            return true;
        }
    }
}

