/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.utils;

import com.github.marlonlom.utilities.timeago.TimeAgo;
import io.streamlayer.utils.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u0006J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\bJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\bJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\bJ\u001d\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\bJ\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0006J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0016\u0010\bR\u001d\u0010\u001c\u001a\u00020\u00178B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001f\u001a\u00020\u00178B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0019\u001a\u0004\b\u001e\u0010\u001bR\u001d\u0010\"\u001a\u00020\u00178B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0019\u001a\u0004\b!\u0010\u001bR\u001d\u0010%\u001a\u00020\u00178B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0019\u001a\u0004\b$\u0010\u001bR\u001d\u0010(\u001a\u00020\u00178B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0019\u001a\u0004\b'\u0010\u001bR\u001d\u0010+\u001a\u00020\u00178B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0019\u001a\u0004\b*\u0010\u001b\u00a8\u0006."}, d2={"Lio/streamlayer/utils/DateUtil;", "", "", "value", "Ljava/util/Date;", "fromString", "(Ljava/lang/String;)Ljava/util/Date;", "toDateTimeString", "(Ljava/util/Date;)Ljava/lang/String;", "toDateString", "dateFromString", "toShort", "toWeekDay", "toDayMonth", "date1", "date2", "", "isSameDay", "(Ljava/util/Date;Ljava/util/Date;)Z", "toRelativeTimeString", "fromTwitterStringToDate", "date", "fromDateToTwitterString", "Ljava/text/SimpleDateFormat;", "fullDateFormat$delegate", "Lkotlin/Lazy;", "getFullDateFormat", "()Ljava/text/SimpleDateFormat;", "fullDateFormat", "twitterDateFormat$delegate", "getTwitterDateFormat", "twitterDateFormat", "shortDateFormat$delegate", "getShortDateFormat", "shortDateFormat", "weekDayFormat$delegate", "getWeekDayFormat", "weekDayFormat", "dayMonthFormat$delegate", "getDayMonthFormat", "dayMonthFormat", "dateFormat$delegate", "getDateFormat", "dateFormat", "<init>", "()V", "sdk_originalRelease"})
public final class DateUtil {
    private static final Lazy fullDateFormat$delegate;
    private static final Lazy twitterDateFormat$delegate;
    private static final Lazy dateFormat$delegate;
    private static final Lazy shortDateFormat$delegate;
    private static final Lazy weekDayFormat$delegate;
    private static final Lazy dayMonthFormat$delegate;
    public static final DateUtil INSTANCE;

    private final SimpleDateFormat getFullDateFormat() {
        return (SimpleDateFormat)fullDateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getTwitterDateFormat() {
        return (SimpleDateFormat)twitterDateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getDateFormat() {
        return (SimpleDateFormat)dateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getShortDateFormat() {
        return (SimpleDateFormat)shortDateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getWeekDayFormat() {
        return (SimpleDateFormat)weekDayFormat$delegate.getValue();
    }

    private final SimpleDateFormat getDayMonthFormat() {
        return (SimpleDateFormat)dayMonthFormat$delegate.getValue();
    }

    private DateUtil() {
    }

    static {
        INSTANCE = new DateUtil();
        fullDateFormat$delegate = LazyKt.lazy((Function0)fullDateFormat.2.INSTANCE);
        twitterDateFormat$delegate = LazyKt.lazy((Function0)twitterDateFormat.2.INSTANCE);
        dateFormat$delegate = LazyKt.lazy((Function0)dateFormat.2.INSTANCE);
        shortDateFormat$delegate = LazyKt.lazy((Function0)shortDateFormat.2.INSTANCE);
        weekDayFormat$delegate = LazyKt.lazy((Function0)weekDayFormat.2.INSTANCE);
        dayMonthFormat$delegate = LazyKt.lazy((Function0)dayMonthFormat.2.INSTANCE);
    }

    @Nullable
    public final Date fromString(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"value");
        return this.getFullDateFormat().parse(string2);
    }

    @Nullable
    public final String toDateTimeString(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"value");
        return this.getFullDateFormat().format(date);
    }

    @NotNull
    public final String toDateString(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"value");
        String string2 = this.getDateFormat().format(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dateFormat.format(value)");
        return string2;
    }

    @Nullable
    public final Date dateFromString(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"value");
        return this.getDateFormat().parse(string2);
    }

    @Nullable
    public final String toShort(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"value");
        return this.getShortDateFormat().format(date);
    }

    @Nullable
    public final String toWeekDay(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"value");
        return this.getWeekDayFormat().format(date);
    }

    @Nullable
    public final String toDayMonth(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"value");
        return this.getDayMonthFormat().format(date);
    }

    public final boolean isSameDay(@NotNull Date date, @NotNull Date date2) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date1");
        Intrinsics.checkParameterIsNotNull((Object)date2, (String)"date2");
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"cal1");
        calendar.setTime(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"cal2");
        calendar2.setTime(date2);
        return calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1);
    }

    @NotNull
    public final String toRelativeTimeString(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"value");
        return TimeAgo.Companion.using$default((TimeAgo.Companion)TimeAgo.Companion, (long)date.getTime(), null, (int)2, null);
    }

    @Nullable
    public final Date fromTwitterStringToDate(@Nullable String string2) {
        if (string2 == null) {
            return null;
        }
        return this.getTwitterDateFormat().parse(string2);
    }

    @Nullable
    public final String fromDateToTwitterString(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        return this.getTwitterDateFormat().format(date);
    }
}

