/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main;

import android.content.Context;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.streamlayer.common.data.tinode.TinodeService;
import io.streamlayer.common.mvvm.BaseViewModel;
import io.streamlayer.common.mvvm.basemodels.BaseError;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.mvvm.basemodels.Status;
import io.streamlayer.common.network.NetworkConnectionLiveData;
import io.streamlayer.common.scheduler.SchedulerProvider;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.common.tooltips.ViewTooltipSession;
import io.streamlayer.common.tooltips.ViewTooltipShownHandler;
import io.streamlayer.common.tooltips.ViewTooltipType;
import io.streamlayer.sdk.StreamLayerSettings;
import io.streamlayer.sdk.calls.call.WatchPartyRouter;
import io.streamlayer.sdk.main.StreamLayerViewModel;
import io.streamlayer.sdk.main.StreamLayerViewModel$WhenMappings;
import io.streamlayer.sdk.main.ViewTooltipState;
import io.streamlayer.sdk.model.advertising.AdvertisingData;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.model.sdksettings.CommonKt;
import io.streamlayer.sdk.model.sdksettings.OrganizationSettings;
import io.streamlayer.sdk.model.sdksettings.SdkOverlay;
import io.streamlayer.sdk.model.sdksettings.SdkOverlaySettings;
import io.streamlayer.sdk.model.sdksettings.SdkOverlayType;
import io.streamlayer.sdk.model.sdksettings.StreamData;
import io.streamlayer.sdk.model.sdksettings.TwitterOverlaySettings;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventSummaryResponseData;
import io.streamlayer.sdk.repository.advertising.AdvertisingRepo;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.repository.auth.AuthRepo;
import io.streamlayer.sdk.repository.customsettings.CustomSettingsRepo;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import io.streamlayer.sdk.repository.sdksettings.SdkSettingsRepo;
import io.streamlayer.sdk.repository.sports.events.SportEventsRepo;
import io.streamlayer.sdk.usecases.WaveUseCase;
import io.streamlayer.utils.RingtonePlayer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a5\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001s\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u007f\b\u0007\u0012\u0006\u0010w\u001a\u00020v\u0012\u0006\u0010z\u001a\u00020y\u0012\u0006\u0010\\\u001a\u00020[\u0012\u0006\u0010l\u001a\u00020k\u0012\u0006\u0010C\u001a\u00020B\u0012\u0006\u0010b\u001a\u00020a\u0012\u0006\u00109\u001a\u000208\u0012\u0006\u0010Q\u001a\u00020P\u0012\u0006\u0010}\u001a\u00020|\u0012\u0006\u0010U\u001a\u00020T\u0012\u0006\u00106\u001a\u000205\u0012\u0006\u0010e\u001a\u00020d\u0012\b\u0010\u008b\u0001\u001a\u00030\u008a\u0001\u0012\b\u0010\u0091\u0001\u001a\u00030\u0090\u0001\u00a2\u0006\u0006\b\u0092\u0001\u0010\u0093\u0001J\u000f\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0005J\u000f\u0010\f\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\f\u0010\u0005J\u000f\u0010\r\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\r\u0010\u0005J\u000f\u0010\u000e\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0005J\u000f\u0010\u000f\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0005J\u000f\u0010\u0010\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0005J\u001f\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0005J\u0015\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u0003\u00a2\u0006\u0004\b\u001c\u0010\u0005J\r\u0010\u001d\u001a\u00020\u0003\u00a2\u0006\u0004\b\u001d\u0010\u0005J\u0017\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010\"\u001a\u00020\u00032\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010&\u001a\u00020\u00032\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b(\u0010\u0005R%\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*0)8\u0006@\u0006\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b&\u0010.R\u001c\u00101\u001a\b\u0012\u0004\u0012\u0002000/8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u001f\u00103\u001a\b\u0012\u0004\u0012\u00020 0)8\u0006@\u0006\u00a2\u0006\f\n\u0004\b3\u0010-\u001a\u0004\b4\u0010.R\u0016\u00106\u001a\u0002058\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u00109\u001a\u0002088\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R(\u0010;\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00060*0/8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u00102R\u001f\u0010=\u001a\b\u0012\u0004\u0012\u00020<0)8\u0006@\u0006\u00a2\u0006\f\n\u0004\b=\u0010-\u001a\u0004\b>\u0010.R%\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020?0*0)8\u0006@\u0006\u00a2\u0006\f\n\u0004\b@\u0010-\u001a\u0004\bA\u0010.R\u0016\u0010C\u001a\u00020B8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u001f\u0010E\u001a\b\u0012\u0004\u0012\u00020 0)8\u0006@\u0006\u00a2\u0006\f\n\u0004\bE\u0010-\u001a\u0004\bF\u0010.R\"\u0010G\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bG\u0010H\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u0016\u0010N\u001a\u00020M8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bN\u0010OR\u0016\u0010Q\u001a\u00020P8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bQ\u0010RR\u0016\u0010S\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bS\u0010HR\u0016\u0010U\u001a\u00020T8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bU\u0010VR\"\u0010W\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020?0*0/8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bW\u00102R\u0018\u0010Y\u001a\u0004\u0018\u00010X8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bY\u0010ZR\u0016\u0010\\\u001a\u00020[8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\\\u0010]R\u001c\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00110^8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b_\u0010`R\u0016\u0010b\u001a\u00020a8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bb\u0010cR\u0016\u0010e\u001a\u00020d8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\be\u0010fR\"\u0010h\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020g0*0/8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bh\u00102R+\u0010i\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00060*0)8\u0006@\u0006\u00a2\u0006\f\n\u0004\bi\u0010-\u001a\u0004\bj\u0010.R\u0016\u0010l\u001a\u00020k8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bl\u0010mR%\u0010n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020g0*0)8\u0006@\u0006\u00a2\u0006\f\n\u0004\bn\u0010-\u001a\u0004\bo\u0010.R\u0018\u0010q\u001a\u0004\u0018\u00010p8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bq\u0010rR\u0016\u0010t\u001a\u00020s8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bt\u0010uR\u0016\u0010w\u001a\u00020v8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bw\u0010xR\u0016\u0010z\u001a\u00020y8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bz\u0010{R\u0016\u0010}\u001a\u00020|8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b}\u0010~R+\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u007f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0080\u0001\u0010\u0081\u0001\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001\"\u0006\b\u0084\u0001\u0010\u0085\u0001R+\u0010\u0088\u0001\u001a\u0014\u0012\u0004\u0012\u00020\u00110\u0086\u0001j\t\u0012\u0004\u0012\u00020\u0011`\u0087\u00018\u0002@\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0088\u0001\u0010\u0089\u0001R\u001a\u0010\u008b\u0001\u001a\u00030\u008a\u00018\u0002@\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008b\u0001\u0010\u008c\u0001R\u001a\u0010\u008d\u0001\u001a\u0004\u0018\u00010X8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008d\u0001\u0010ZR\"\u0010\u008e\u0001\u001a\b\u0012\u0004\u0012\u0002000)8\u0006@\u0006\u00a2\u0006\u000e\n\u0005\b\u008e\u0001\u0010-\u001a\u0005\b\u008f\u0001\u0010.\u00a8\u0006\u0094\u0001"}, d2={"Lio/streamlayer/sdk/main/StreamLayerViewModel;", "Lio/streamlayer/common/mvvm/BaseViewModel;", "Lio/streamlayer/common/tooltips/ViewTooltipShownHandler;", "", "loadSdkOverlays", "()V", "", "Lio/streamlayer/sdk/model/sdksettings/SdkOverlay;", "list", "addCustomOverlays", "(Ljava/util/List;)Ljava/util/List;", "loadAdvertisingData", "checkFirebaseTokenUpdated", "loadNotifications", "loadWaveMessages", "loadChainOfTooltips", "getNextTooltip", "Lio/streamlayer/common/tooltips/ViewTooltipType;", "type", "", "delay", "startTooltipTimer", "(Lio/streamlayer/common/tooltips/ViewTooltipType;J)V", "startAnalyticsSession", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "dismissNotification", "(Lio/streamlayer/sdk/model/notifications/Notification;)V", "dismissAllNotifications", "overlayWasClosed", "tooltipWasShown", "(Lio/streamlayer/common/tooltips/ViewTooltipType;)V", "", "online", "setOnlineStatus", "(Z)V", "", "streamId", "getStreamData", "(Ljava/lang/String;)V", "onCleared", "Landroidx/lifecycle/LiveData;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "Lio/streamlayer/sdk/model/sdksettings/StreamData;", "streamData", "Landroidx/lifecycle/LiveData;", "()Landroidx/lifecycle/LiveData;", "Landroidx/lifecycle/MutableLiveData;", "Lio/streamlayer/sdk/main/ViewTooltipState;", "_viewTooltipData", "Landroidx/lifecycle/MutableLiveData;", "userLoggedIn", "getUserLoggedIn", "Lio/streamlayer/sdk/repository/customsettings/CustomSettingsRepo;", "customRepo", "Lio/streamlayer/sdk/repository/customsettings/CustomSettingsRepo;", "Lio/streamlayer/common/tooltips/ViewTooltipSession;", "viewTooltipSession", "Lio/streamlayer/common/tooltips/ViewTooltipSession;", "_notificationsData", "", "unreadMessagesCount", "getUnreadMessagesCount", "Lio/streamlayer/sdk/model/sdksettings/OrganizationSettings;", "sdkOverlaysList", "getSdkOverlaysList", "Lio/streamlayer/common/session/SessionPrefImpl;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "networkConnectionLiveData", "getNetworkConnectionLiveData", "overlayOpenedAt", "J", "getOverlayOpenedAt", "()J", "setOverlayOpenedAt", "(J)V", "Lio/streamlayer/common/network/NetworkConnectionLiveData;", "_networkConnectionLiveData", "Lio/streamlayer/common/network/NetworkConnectionLiveData;", "Lio/streamlayer/utils/RingtonePlayer;", "ringtonePlayer", "Lio/streamlayer/utils/RingtonePlayer;", "lastShownTooltipClosedAt", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "analyticsRepo", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "_sdkOverlaysList", "Lio/reactivex/disposables/Disposable;", "streamDataDisposable", "Lio/reactivex/disposables/Disposable;", "Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;", "advertisingRepo", "Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;", "", "chainOfTooltips", "Ljava/util/List;", "Lio/streamlayer/common/data/tinode/TinodeService;", "tinode", "Lio/streamlayer/common/data/tinode/TinodeService;", "Lio/streamlayer/sdk/usecases/WaveUseCase;", "waveUseCase", "Lio/streamlayer/sdk/usecases/WaveUseCase;", "Lio/streamlayer/sdk/model/advertising/AdvertisingData;", "_advertisingData", "notificationsData", "getNotificationsData", "Lio/streamlayer/sdk/repository/auth/AuthRepo;", "authRepo", "Lio/streamlayer/sdk/repository/auth/AuthRepo;", "advertisingData", "getAdvertisingData", "Lkotlinx/coroutines/Job;", "sessionHeartbeatJob", "Lkotlinx/coroutines/Job;", "io/streamlayer/sdk/main/StreamLayerViewModel$_streamData$1", "_streamData", "Lio/streamlayer/sdk/main/StreamLayerViewModel$_streamData$1;", "Lio/streamlayer/sdk/repository/sdksettings/SdkSettingsRepo;", "sdkSettingsRepo", "Lio/streamlayer/sdk/repository/sdksettings/SdkSettingsRepo;", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "notificationsRepo", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "schedulers", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "Lio/streamlayer/sdk/calls/call/WatchPartyRouter;", "watchPartyRouter", "Lio/streamlayer/sdk/calls/call/WatchPartyRouter;", "getWatchPartyRouter", "()Lio/streamlayer/sdk/calls/call/WatchPartyRouter;", "setWatchPartyRouter", "(Lio/streamlayer/sdk/calls/call/WatchPartyRouter;)V", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "tooltipsOrder", "Ljava/util/ArrayList;", "Lio/streamlayer/sdk/repository/sports/events/SportEventsRepo;", "sportEventsRepo", "Lio/streamlayer/sdk/repository/sports/events/SportEventsRepo;", "tooltipTimerDisposable", "viewTooltipData", "getViewTooltipData", "Landroid/content/Context;", "context", "<init>", "(Lio/streamlayer/sdk/repository/sdksettings/SdkSettingsRepo;Lio/streamlayer/sdk/repository/notifications/NotificationRepo;Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;Lio/streamlayer/sdk/repository/auth/AuthRepo;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/common/data/tinode/TinodeService;Lio/streamlayer/common/tooltips/ViewTooltipSession;Lio/streamlayer/utils/RingtonePlayer;Lio/streamlayer/common/scheduler/SchedulerProvider;Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;Lio/streamlayer/sdk/repository/customsettings/CustomSettingsRepo;Lio/streamlayer/sdk/usecases/WaveUseCase;Lio/streamlayer/sdk/repository/sports/events/SportEventsRepo;Landroid/content/Context;)V", "sdk_originalRelease"})
public final class StreamLayerViewModel
extends BaseViewModel
implements ViewTooltipShownHandler {
    private final ArrayList<ViewTooltipType> tooltipsOrder;
    private final NetworkConnectionLiveData _networkConnectionLiveData;
    @NotNull
    private final LiveData<Boolean> networkConnectionLiveData;
    private final MutableLiveData<ResourceState<OrganizationSettings>> _sdkOverlaysList;
    @NotNull
    private final LiveData<ResourceState<OrganizationSettings>> sdkOverlaysList;
    @NotNull
    private final LiveData<Boolean> userLoggedIn;
    @NotNull
    private final LiveData<Integer> unreadMessagesCount;
    private final MutableLiveData<ResourceState<AdvertisingData>> _advertisingData;
    @NotNull
    private final LiveData<ResourceState<AdvertisingData>> advertisingData;
    private final _streamData.1 _streamData;
    @NotNull
    private final LiveData<ResourceState<StreamData>> streamData;
    private final MutableLiveData<ResourceState<List<Notification>>> _notificationsData;
    @NotNull
    private final LiveData<ResourceState<List<Notification>>> notificationsData;
    private final MutableLiveData<ViewTooltipState> _viewTooltipData;
    @NotNull
    private final LiveData<ViewTooltipState> viewTooltipData;
    private List<ViewTooltipType> chainOfTooltips;
    private long lastShownTooltipClosedAt;
    private long overlayOpenedAt;
    private Job sessionHeartbeatJob;
    @Nullable
    private WatchPartyRouter watchPartyRouter;
    private Disposable tooltipTimerDisposable;
    private Disposable streamDataDisposable;
    private final SdkSettingsRepo sdkSettingsRepo;
    private final NotificationRepo notificationsRepo;
    private final AdvertisingRepo advertisingRepo;
    private final AuthRepo authRepo;
    private final SessionPrefImpl session;
    private final TinodeService tinode;
    private final ViewTooltipSession viewTooltipSession;
    private final RingtonePlayer ringtonePlayer;
    private final SchedulerProvider schedulers;
    private final AnalyticsRepo analyticsRepo;
    private final CustomSettingsRepo customRepo;
    private final WaveUseCase waveUseCase;
    private final SportEventsRepo sportEventsRepo;

    private final void loadSdkOverlays() {
        Function0<Observable<ResourceState<? extends OrganizationSettings>>> function0;
        StreamLayerViewModel streamLayerViewModel2 = this;
        MutableLiveData<ResourceState<OrganizationSettings>> mutableLiveData = streamLayerViewModel2._sdkOverlaysList;
        Function0<Observable<ResourceState<? extends OrganizationSettings>>> function02 = function0;
        function0 = new Function0<Observable<ResourceState<? extends OrganizationSettings>>>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel2;
                super(0);
            }

            public final Observable<ResourceState<OrganizationSettings>> invoke() {
                Observable observable2 = StreamLayerViewModel.access$getSdkSettingsRepo$p(this.this$0).getOrganizationSettings().map(new Function<T, R>(this){
                    final /* synthetic */ loadSdkOverlays.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final ResourceState<OrganizationSettings> apply(@NotNull ResourceState<OrganizationSettings> object) {
                        Object object2;
                        OrganizationSettings organizationSettings;
                        ResourceState<OrganizationSettings> resourceState = object;
                        Intrinsics.checkParameterIsNotNull(resourceState, (String)"it");
                        OrganizationSettings organizationSettings2 = resourceState.getData();
                        if (organizationSettings2 != null) {
                            OrganizationSettings organizationSettings3;
                            organizationSettings = organizationSettings3;
                            object2 = StreamLayerViewModel.access$addCustomOverlays(object2.this$0.this$0, organizationSettings2.getOverlays());
                            organizationSettings3 = new OrganizationSettings((List<SdkOverlay>)object2, organizationSettings2.getButtonIcon());
                        } else {
                            organizationSettings = null;
                        }
                        ResourceState<OrganizationSettings> resourceState2 = object;
                        object2 = resourceState2.getStatus();
                        object = resourceState2.getError();
                        return new ResourceState<OrganizationSettings>((Status)((Object)object2), organizationSettings, (BaseError)object);
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)observable2, (String)"sdkSettingsRepo.getOrgan\u2026.error)\n                }");
                return observable2;
            }
        };
        BaseViewModel.observableCall$default(streamLayerViewModel2, mutableLiveData, (Function0)function02, null, null, null, 28, null);
    }

    private final List<SdkOverlay> addCustomOverlays(List<SdkOverlay> arrayList) {
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayList<SdkOverlay> arrayList4;
        StreamLayerViewModel streamLayerViewModel2 = arrayList4;
        arrayList4 = arrayList3;
        arrayList4();
        arrayList3.addAll(CollectionsKt.sortedWith(CommonKt.withProfileItem(arrayList), new Comparator<T>(){

            public final int compare(T t, T t2) {
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(((SdkOverlay)t).getPosition()), (Comparable)Integer.valueOf(((SdkOverlay)t2).getPosition()));
            }
        }));
        arrayList = arrayList2;
        arrayList2 = new ArrayList();
        for (Object t : streamLayerViewModel2.customRepo.getCustomOverlays()) {
            Object object = ((SdkOverlay)t).getSettings();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if ((object = ((SdkOverlaySettings)object).getParams()) == null) {
                Intrinsics.throwNpe();
            }
            if (!((StreamLayerSettings.CustomOverlay)object).getOnBottomMenu()) continue;
            arrayList.add(t);
        }
        ArrayList<SdkOverlay> arrayList5 = arrayList4;
        arrayList5.addAll(CollectionsKt.sortedWith(arrayList, new Comparator<T>(){

            public final int compare(T t, T t2) {
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(((SdkOverlay)t).getPosition()), (Comparable)Integer.valueOf(((SdkOverlay)t2).getPosition()));
            }
        }));
        return arrayList5;
    }

    private final void loadAdvertisingData() {
        Function0<Observable<ResourceState<? extends AdvertisingData>>> function0;
        StreamLayerViewModel streamLayerViewModel2 = this;
        MutableLiveData<ResourceState<AdvertisingData>> mutableLiveData = streamLayerViewModel2._advertisingData;
        Function0<Observable<ResourceState<? extends AdvertisingData>>> function02 = function0;
        function0 = new Function0<Observable<ResourceState<? extends AdvertisingData>>>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel2;
                super(0);
            }

            @NotNull
            public final Observable<ResourceState<AdvertisingData>> invoke() {
                return StreamLayerViewModel.access$getAdvertisingRepo$p(this.this$0).getAdvertisingData();
            }
        };
        BaseViewModel.observableCall$default(streamLayerViewModel2, mutableLiveData, (Function0)function02, null, null, null, 28, null);
    }

    private final void checkFirebaseTokenUpdated() {
        if (this.session.isLoggedIn() && this.session.isFirebaseTokenChanged()) {
            Function0<Observable<ResourceState<? extends Boolean>>> function0;
            Function0<Observable<ResourceState<? extends Boolean>>> function02 = function0;
            function0 = new Function0<Observable<ResourceState<? extends Boolean>>>(this){
                final /* synthetic */ StreamLayerViewModel this$0;
                {
                    this.this$0 = streamLayerViewModel2;
                    super(0);
                }

                public final Observable<ResourceState<Boolean>> invoke() {
                    return StreamLayerViewModel.access$getAuthRepo$p(this.this$0).uploadFirebaseToken(StreamLayerViewModel.access$getSession$p(this.this$0).getFirebaseToken()).map(new Function<T, R>(this){
                        final /* synthetic */ checkFirebaseTokenUpdated.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        @NotNull
                        public final ResourceState<Boolean> apply(@NotNull ResourceState<Boolean> resourceState) {
                            ResourceState<Boolean> resourceState2 = resourceState;
                            Intrinsics.checkParameterIsNotNull(resourceState2, (String)"it");
                            if (Intrinsics.areEqual((Object)resourceState2.getData(), (Object)Boolean.TRUE)) {
                                StreamLayerViewModel.access$getSession$p(this.this$0.this$0).setFirebaseTokenChanged(false);
                            }
                            return resourceState;
                        }
                    });
                }
            };
            BaseViewModel.observableCall$default(this, (Function0)function02, null, null, null, 14, null);
        }
    }

    private final void loadNotifications() {
        Function0<Observable<ResourceState<? extends List<? extends Notification>>>> function0;
        StreamLayerViewModel streamLayerViewModel2 = this;
        MutableLiveData<ResourceState<List<Notification>>> mutableLiveData = streamLayerViewModel2._notificationsData;
        Function0<Observable<ResourceState<? extends List<? extends Notification>>>> function02 = function0;
        function0 = new Function0<Observable<ResourceState<? extends List<? extends Notification>>>>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel2;
                super(0);
            }

            public final Observable<ResourceState<List<Notification>>> invoke() {
                Observable observable2 = StreamLayerViewModel.access$getNotificationsRepo$p(this.this$0).getNotifications().doOnNext(new Consumer<ResourceState<? extends List<? extends Notification>>>(this){
                    final /* synthetic */ loadNotifications.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void accept(ResourceState<? extends List<Notification>> iterator) {
                        if ((iterator = ((ResourceState)((Object)iterator)).getData()) != null) {
                            iterator = iterator.iterator();
                            while (iterator.hasNext()) {
                                Long l;
                                Notification notification = (Notification)iterator.next();
                                if (notification.getType() != NotificationType.Custom || (l = notification.getId()) == null) continue;
                                long l2 = l;
                                notification.setCustomBuilder(StreamLayerViewModel.access$getCustomRepo$p(this.this$0.this$0).notificationBuilderById(l2));
                            }
                        }
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)observable2, (String)"notificationsRepo.getNot\u2026  }\n                    }");
                return observable2;
            }
        };
        BaseViewModel.observableCall$default(streamLayerViewModel2, mutableLiveData, (Function0)function02, null, null, null, 28, null);
    }

    private final void loadWaveMessages() {
        this.waveUseCase.subscribeToWaveMessages().subscribeOn(this.schedulers.io()).observeOn(this.schedulers.ui(), true).doOnSubscribe(new Consumer<Disposable>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel2;
            }

            public final void accept(Disposable disposable) {
                StreamLayerViewModel.access$getCompositeDisposable$p(this.this$0).add(disposable);
            }
        }).subscribe((Consumer)loadWaveMessages.2.INSTANCE, (Consumer)loadWaveMessages.3.INSTANCE);
    }

    private final void loadChainOfTooltips() {
        this.getCompositeDisposable().add(Observable.fromIterable(this.tooltipsOrder).filter(new Predicate<ViewTooltipType>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel2;
            }

            public final boolean test(@NotNull ViewTooltipType viewTooltipType) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)viewTooltipType), (String)"it");
                return StreamLayerViewModel.access$getViewTooltipSession$p(this.this$0).canShow(viewTooltipType);
            }
        }).toList().subscribeOn(this.schedulers.io()).observeOn(this.schedulers.ui()).subscribe(new Consumer<List<ViewTooltipType>>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel2;
            }

            public final void accept(List<ViewTooltipType> list) {
                loadChainOfTooltips.2 v0 = this;
                StreamLayerViewModel.access$getChainOfTooltips$p(v0.this$0).clear();
                List list2 = StreamLayerViewModel.access$getChainOfTooltips$p(v0.this$0);
                List<ViewTooltipType> list3 = list;
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"it");
                list2.addAll(list3);
                StreamLayerViewModel.access$getNextTooltip(v0.this$0);
            }
        }));
    }

    private final void getNextTooltip() {
        Function1<ViewTooltipType, Unit> function1;
        Function1<ViewTooltipType, Unit> function12 = function1;
        function1 = new Function1<ViewTooltipType, Unit>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel2;
                super(1);
            }

            public final void invoke(@Nullable ViewTooltipType viewTooltipType) {
                Disposable disposable = StreamLayerViewModel.access$getTooltipTimerDisposable$p(this.this$0);
                if (disposable != null) {
                    disposable.dispose();
                }
                StreamLayerViewModel.access$get_viewTooltipData$p(this.this$0).setValue((Object)new ViewTooltipState(viewTooltipType));
            }
        };
        if (this.chainOfTooltips.isEmpty()) {
            function12.invoke(null);
            return;
        }
        ViewTooltipType viewTooltipType = this.chainOfTooltips.get(0);
        switch (StreamLayerViewModel$WhenMappings.$EnumSwitchMapping$0[viewTooltipType.ordinal()]) {
            default: {
                break;
            }
            case 4: {
                function12.invoke((Object)viewTooltipType);
                break;
            }
            case 3: {
                long l = System.currentTimeMillis() - this.lastShownTooltipClosedAt - 5000L;
                if (l >= 0L) {
                    function12.invoke((Object)viewTooltipType);
                    break;
                }
                function12.invoke(null);
                l = Math.abs(l);
                l = Math.min(5000L, l);
                this.startTooltipTimer(viewTooltipType, l);
                break;
            }
            case 2: {
                long l = this.overlayOpenedAt;
                long l2 = System.currentTimeMillis() - l - 5000L;
                if (l2 >= 0L && l != 0L) {
                    function12.invoke((Object)viewTooltipType);
                    break;
                }
                function12.invoke(null);
                l = Math.abs(l2);
                l = Math.min(5000L, l);
                this.startTooltipTimer(viewTooltipType, l);
                break;
            }
            case 1: {
                function12.invoke((Object)viewTooltipType);
            }
        }
    }

    private final void startTooltipTimer(ViewTooltipType viewTooltipType, long l) {
        Disposable disposable = this.tooltipTimerDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this.tooltipTimerDisposable = Observable.just((Object)((Object)viewTooltipType)).delay(l, TimeUnit.MILLISECONDS).subscribeOn(this.schedulers.io()).observeOn(this.schedulers.ui()).doOnSubscribe(new Consumer<Disposable>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel2;
            }

            public final void accept(Disposable disposable) {
                startTooltipTimer.1 v0 = this;
                StreamLayerViewModel.access$setTooltipTimerDisposable$p(v0.this$0, disposable);
                StreamLayerViewModel.access$getCompositeDisposable$p(v0.this$0).add(disposable);
            }
        }).subscribe(new Consumer<ViewTooltipType>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel2;
            }

            public final void accept(ViewTooltipType viewTooltipType) {
                StreamLayerViewModel.access$getNextTooltip(this.this$0);
            }
        });
    }

    private final void startAnalyticsSession() {
        if (this.sessionHeartbeatJob == null) {
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
            function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ StreamLayerViewModel this$0;
                {
                    this.this$0 = streamLayerViewModel2;
                    super(2, continuation);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    int n = this.label;
                    if (n != 0) {
                        if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        Object object3 = object;
                        object = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)object3);
                    } else {
                        ResultKt.throwOnFailure((Object)object);
                        object = this.p$;
                    }
                    while (CoroutineScopeKt.isActive((CoroutineScope)object)) {
                        ResourceState resourceState = (ResourceState)StreamLayerViewModel.access$get_streamData$p(this.this$0).getValue();
                        if ((resourceState != null ? (StreamData)resourceState.getData() : null) != null) {
                            StreamLayerViewModel.access$getAnalyticsRepo$p(this.this$0).triggerSessionHeartbeat();
                        }
                        startAnalyticsSession.1 v1 = this;
                        v1.L$0 = object;
                        v1.label = 1;
                        if (DelayKt.delay((long)60000L, (Continuation)this) != object2) continue;
                        return object2;
                    }
                    return Unit.INSTANCE;
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                    Intrinsics.checkParameterIsNotNull(continuation, (String)"completion");
                    new /* invalid duplicate definition of identical inner class */.p$ = (CoroutineScope)object;
                    return new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            };
            this.sessionHeartbeatJob = BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)function22, (int)3, null);
        }
    }

    @Inject
    public StreamLayerViewModel(@NotNull SdkSettingsRepo sdkSettingsRepo, @NotNull NotificationRepo notificationRepo, @NotNull AdvertisingRepo advertisingRepo, @NotNull AuthRepo authRepo, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull TinodeService tinodeService, @NotNull ViewTooltipSession viewTooltipSession, @NotNull RingtonePlayer ringtonePlayer, @NotNull SchedulerProvider schedulerProvider, @NotNull AnalyticsRepo analyticsRepo, @NotNull CustomSettingsRepo customSettingsRepo, @NotNull WaveUseCase waveUseCase, @NotNull SportEventsRepo sportEventsRepo, @NotNull Context context) {
        MediatorLiveData<ResourceState<? extends StreamData>> mediatorLiveData;
        StreamLayerViewModel streamLayerViewModel2 = this;
        StreamLayerViewModel streamLayerViewModel3 = this;
        Intrinsics.checkParameterIsNotNull((Object)sdkSettingsRepo, (String)"sdkSettingsRepo");
        Intrinsics.checkParameterIsNotNull((Object)notificationRepo, (String)"notificationsRepo");
        Intrinsics.checkParameterIsNotNull((Object)advertisingRepo, (String)"advertisingRepo");
        Intrinsics.checkParameterIsNotNull((Object)authRepo, (String)"authRepo");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)tinodeService, (String)"tinode");
        Intrinsics.checkParameterIsNotNull((Object)viewTooltipSession, (String)"viewTooltipSession");
        Intrinsics.checkParameterIsNotNull((Object)ringtonePlayer, (String)"ringtonePlayer");
        Intrinsics.checkParameterIsNotNull((Object)schedulerProvider, (String)"schedulers");
        Intrinsics.checkParameterIsNotNull((Object)analyticsRepo, (String)"analyticsRepo");
        Intrinsics.checkParameterIsNotNull((Object)customSettingsRepo, (String)"customRepo");
        Intrinsics.checkParameterIsNotNull((Object)waveUseCase, (String)"waveUseCase");
        Intrinsics.checkParameterIsNotNull((Object)sportEventsRepo, (String)"sportEventsRepo");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(schedulerProvider);
        this.sdkSettingsRepo = sdkSettingsRepo;
        this.notificationsRepo = notificationRepo;
        this.advertisingRepo = advertisingRepo;
        this.authRepo = authRepo;
        this.session = sessionPrefImpl;
        this.tinode = tinodeService;
        this.viewTooltipSession = viewTooltipSession;
        this.ringtonePlayer = ringtonePlayer;
        this.schedulers = schedulerProvider;
        this.analyticsRepo = analyticsRepo;
        this.customRepo = customSettingsRepo;
        this.waveUseCase = waveUseCase;
        streamLayerViewModel3.sportEventsRepo = sportEventsRepo;
        streamLayerViewModel3.tooltipsOrder = CollectionsKt.arrayListOf((Object[])new ViewTooltipType[]{ViewTooltipType.MAIN_MENU, ViewTooltipType.OVERLAY_DISMISS, ViewTooltipType.WHOS_WATCHING, ViewTooltipType.NOTIFICATION});
        this._networkConnectionLiveData = new NetworkConnectionLiveData(context);
        LiveData liveData = Transformations.distinctUntilChanged((LiveData)this._networkConnectionLiveData);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        streamLayerViewModel3.networkConnectionLiveData = liveData;
        this._sdkOverlaysList = new MutableLiveData();
        LiveData liveData2 = Transformations.distinctUntilChanged((LiveData)this._sdkOverlaysList);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData2, (String)"Transformations.distinctUntilChanged(this)");
        streamLayerViewModel3.sdkOverlaysList = liveData2;
        this.userLoggedIn = sessionPrefImpl.getUserLoggedInListener();
        streamLayerViewModel2.unreadMessagesCount = sessionPrefImpl.getTotalUnreadMessagesCountListener();
        this._advertisingData = new MutableLiveData();
        LiveData liveData3 = Transformations.distinctUntilChanged((LiveData)this._advertisingData);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData3, (String)"Transformations.distinctUntilChanged(this)");
        streamLayerViewModel2.advertisingData = liveData3;
        sdkSettingsRepo = mediatorLiveData;
        streamLayerViewModel2._streamData = new MediatorLiveData<ResourceState<? extends StreamData>>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                Observer<String> observer;
                this.this$0 = object;
                LiveData liveData = Transformations.distinctUntilChanged(StreamLayerViewModel.access$getSession$p((StreamLayerViewModel)object).getCurrentEventIdListener());
                Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
                object = observer;
                observer = new Observer<String>(this){
                    final /* synthetic */ _streamData.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void onChanged(@Nullable String string2) {
                        if (!(string2 == null || StringsKt.isBlank((CharSequence)string2))) {
                            _streamData.1 v0 = this;
                            v0.this$0.this$0.getStreamData(string2);
                            StreamLayerViewModel.access$startAnalyticsSession(v0.this$0.this$0);
                            StreamLayerViewModel.access$getAnalyticsRepo$p(v0.this$0.this$0).triggerLaunchButtonInitEvent();
                        }
                    }
                };
                this.addSource(liveData, (Observer)object);
            }
        };
        streamLayerViewModel2.streamData = sdkSettingsRepo;
        this._notificationsData = new MutableLiveData();
        LiveData liveData4 = Transformations.distinctUntilChanged((LiveData)this._notificationsData);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData4, (String)"Transformations.distinctUntilChanged(this)");
        streamLayerViewModel2.notificationsData = liveData4;
        this._viewTooltipData = new MutableLiveData();
        LiveData liveData5 = Transformations.distinctUntilChanged((LiveData)this._viewTooltipData);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData5, (String)"Transformations.distinctUntilChanged(this)");
        streamLayerViewModel2.viewTooltipData = liveData5;
        streamLayerViewModel2.chainOfTooltips = new ArrayList<ViewTooltipType>();
        streamLayerViewModel2.loadSdkOverlays();
        streamLayerViewModel2.loadAdvertisingData();
        streamLayerViewModel2.loadChainOfTooltips();
        streamLayerViewModel2.loadNotifications();
        streamLayerViewModel2.loadWaveMessages();
        streamLayerViewModel2.checkFirebaseTokenUpdated();
    }

    public static final /* synthetic */ SdkSettingsRepo access$getSdkSettingsRepo$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.sdkSettingsRepo;
    }

    public static final /* synthetic */ List access$addCustomOverlays(StreamLayerViewModel streamLayerViewModel2, List list) {
        return streamLayerViewModel2.addCustomOverlays(list);
    }

    public static final /* synthetic */ AdvertisingRepo access$getAdvertisingRepo$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.advertisingRepo;
    }

    public static final /* synthetic */ AuthRepo access$getAuthRepo$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.authRepo;
    }

    public static final /* synthetic */ SessionPrefImpl access$getSession$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.session;
    }

    public static final /* synthetic */ NotificationRepo access$getNotificationsRepo$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.notificationsRepo;
    }

    public static final /* synthetic */ CustomSettingsRepo access$getCustomRepo$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.customRepo;
    }

    public static final /* synthetic */ CompositeDisposable access$getCompositeDisposable$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.getCompositeDisposable();
    }

    public static final /* synthetic */ ViewTooltipSession access$getViewTooltipSession$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.viewTooltipSession;
    }

    public static final /* synthetic */ List access$getChainOfTooltips$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.chainOfTooltips;
    }

    public static final /* synthetic */ void access$setChainOfTooltips$p(StreamLayerViewModel streamLayerViewModel2, List list) {
        streamLayerViewModel2.chainOfTooltips = list;
    }

    public static final /* synthetic */ void access$getNextTooltip(StreamLayerViewModel streamLayerViewModel2) {
        streamLayerViewModel2.getNextTooltip();
    }

    public static final /* synthetic */ Disposable access$getTooltipTimerDisposable$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.tooltipTimerDisposable;
    }

    public static final /* synthetic */ void access$setTooltipTimerDisposable$p(StreamLayerViewModel streamLayerViewModel2, Disposable disposable) {
        streamLayerViewModel2.tooltipTimerDisposable = disposable;
    }

    public static final /* synthetic */ MutableLiveData access$get_viewTooltipData$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2._viewTooltipData;
    }

    public static final /* synthetic */ TinodeService access$getTinode$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.tinode;
    }

    public static final /* synthetic */ Disposable access$getStreamDataDisposable$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.streamDataDisposable;
    }

    public static final /* synthetic */ void access$setStreamDataDisposable$p(StreamLayerViewModel streamLayerViewModel2, Disposable disposable) {
        streamLayerViewModel2.streamDataDisposable = disposable;
    }

    public static final /* synthetic */ _streamData.1 access$get_streamData$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2._streamData;
    }

    public static final /* synthetic */ SportEventsRepo access$getSportEventsRepo$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.sportEventsRepo;
    }

    public static final /* synthetic */ AnalyticsRepo access$getAnalyticsRepo$p(StreamLayerViewModel streamLayerViewModel2) {
        return streamLayerViewModel2.analyticsRepo;
    }

    public static final /* synthetic */ void access$startAnalyticsSession(StreamLayerViewModel streamLayerViewModel2) {
        streamLayerViewModel2.startAnalyticsSession();
    }

    @NotNull
    public final LiveData<Boolean> getNetworkConnectionLiveData() {
        return this.networkConnectionLiveData;
    }

    @NotNull
    public final LiveData<ResourceState<OrganizationSettings>> getSdkOverlaysList() {
        return this.sdkOverlaysList;
    }

    @NotNull
    public final LiveData<Boolean> getUserLoggedIn() {
        return this.userLoggedIn;
    }

    @NotNull
    public final LiveData<Integer> getUnreadMessagesCount() {
        return this.unreadMessagesCount;
    }

    @NotNull
    public final LiveData<ResourceState<AdvertisingData>> getAdvertisingData() {
        return this.advertisingData;
    }

    @NotNull
    public final LiveData<ResourceState<StreamData>> getStreamData() {
        return this.streamData;
    }

    @NotNull
    public final LiveData<ResourceState<List<Notification>>> getNotificationsData() {
        return this.notificationsData;
    }

    @NotNull
    public final LiveData<ViewTooltipState> getViewTooltipData() {
        return this.viewTooltipData;
    }

    public final long getOverlayOpenedAt() {
        return this.overlayOpenedAt;
    }

    public final void setOverlayOpenedAt(long l) {
        this.overlayOpenedAt = l;
    }

    @Nullable
    public final WatchPartyRouter getWatchPartyRouter() {
        return this.watchPartyRouter;
    }

    public final void setWatchPartyRouter(@Nullable WatchPartyRouter watchPartyRouter) {
        this.watchPartyRouter = watchPartyRouter;
    }

    public final void dismissNotification(@NotNull Notification notification) {
        StreamLayerViewModel streamLayerViewModel2 = this;
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        BaseViewModel.completableCall$default(streamLayerViewModel2, streamLayerViewModel2._notificationsData, (Function0)new Function0<Completable>(this, notification){
            final /* synthetic */ StreamLayerViewModel this$0;
            final /* synthetic */ Notification $notification;
            {
                this.this$0 = streamLayerViewModel2;
                this.$notification = notification;
                super(0);
            }

            @NotNull
            public final Completable invoke() {
                return StreamLayerViewModel.access$getNotificationsRepo$p(this.this$0).deleteNotification(this.$notification);
            }
        }, null, null, null, 28, null);
        if (notification.getType() == NotificationType.WatchParty) {
            this.ringtonePlayer.dismiss();
        }
    }

    public final void dismissAllNotifications() {
        StreamLayerViewModel streamLayerViewModel2 = this;
        streamLayerViewModel2.notificationsRepo.deleteAllNotifications();
        streamLayerViewModel2.ringtonePlayer.dismiss();
    }

    public final void overlayWasClosed() {
        if (this.chainOfTooltips.isEmpty() ^ true) {
            ViewTooltipType viewTooltipType = ViewTooltipType.OVERLAY_DISMISS;
            if (this.chainOfTooltips.get(0) == viewTooltipType) {
                Disposable disposable = this.tooltipTimerDisposable;
                if (disposable != null) {
                    disposable.dispose();
                }
                this.tooltipWasShown(viewTooltipType);
            }
        }
    }

    @Override
    public void tooltipWasShown(@NotNull ViewTooltipType viewTooltipType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)viewTooltipType), (String)"type");
        if (this.chainOfTooltips.isEmpty()) {
            return;
        }
        if (viewTooltipType == this.chainOfTooltips.get(0)) {
            StreamLayerViewModel streamLayerViewModel2 = this;
            streamLayerViewModel2.chainOfTooltips.remove(0);
            streamLayerViewModel2.lastShownTooltipClosedAt = System.currentTimeMillis();
            streamLayerViewModel2.viewTooltipSession.wasShown(viewTooltipType);
            streamLayerViewModel2.getNextTooltip();
        }
    }

    public final void setOnlineStatus(boolean bl) {
        Function0<Observable<ResourceState<? extends Boolean>>> function0;
        Function0<Observable<ResourceState<? extends Boolean>>> function02 = function0;
        function0 = new Function0<Observable<ResourceState<? extends Boolean>>>(this, bl){
            final /* synthetic */ StreamLayerViewModel this$0;
            final /* synthetic */ boolean $online;
            {
                this.this$0 = streamLayerViewModel2;
                this.$online = bl;
                super(0);
            }

            public final Observable<ResourceState<Boolean>> invoke() {
                return (this.$online ? StreamLayerViewModel.access$getTinode$p(this.this$0).triggerOnlineStatus() : StreamLayerViewModel.access$getTinode$p(this.this$0).triggerOfflineStatus()).doOnError((Consumer)setOnlineStatus.1.INSTANCE).map((Function)setOnlineStatus.2.INSTANCE);
            }
        };
        BaseViewModel.observableCall$default(this, (Function0)function02, null, null, null, 14, null);
    }

    public final void getStreamData(@NotNull String string2) {
        Function1<ResourceState<? extends EventSummaryResponseData>, Unit> function1;
        Function0<Observable<ResourceState<? extends EventSummaryResponseData>>> function0;
        Function1<ResourceState<? extends StreamData>, Unit> function12;
        Function1<Disposable, Unit> function13;
        Function0<Observable<ResourceState<? extends StreamData>>> function02;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"streamId");
        Object object = this.streamDataDisposable;
        if (object != null) {
            object.dispose();
        }
        StreamLayerViewModel streamLayerViewModel2 = this;
        object = streamLayerViewModel2._streamData;
        Function0<Observable<ResourceState<? extends StreamData>>> function03 = function02;
        function02 = new Function0<Observable<ResourceState<? extends StreamData>>>(this, string2){
            final /* synthetic */ StreamLayerViewModel this$0;
            final /* synthetic */ String $streamId;
            {
                this.this$0 = streamLayerViewModel2;
                this.$streamId = string2;
                super(0);
            }

            @NotNull
            public final Observable<ResourceState<StreamData>> invoke() {
                return StreamLayerViewModel.access$getSdkSettingsRepo$p(this.this$0).getStreamInfo(this.$streamId);
            }
        };
        Function1<Disposable, Unit> function14 = function13;
        function13 = new Function1<Disposable, Unit>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel2;
                super(1);
            }

            public final void invoke(@NotNull Disposable disposable) {
                getStreamData.2 v0 = this;
                Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
                StreamLayerViewModel.access$setStreamDataDisposable$p(v0.this$0, disposable);
                StreamLayerViewModel.access$getCompositeDisposable$p(v0.this$0).add(disposable);
            }
        };
        Function1<ResourceState<? extends StreamData>, Unit> function15 = function12;
        function12 = new Function1<ResourceState<? extends StreamData>, Unit>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel2;
                super(1);
            }

            public final void invoke(@NotNull ResourceState<StreamData> resourceState) {
                ResourceState<StreamData> resourceState2 = resourceState;
                Intrinsics.checkParameterIsNotNull(resourceState2, (String)"it");
                StreamData streamData = resourceState2.getData();
                if (streamData != null) {
                    SessionPrefImpl sessionPrefImpl;
                    block3: {
                        for (T t : resourceState.getData().getAttributes().getOverlays()) {
                            sessionPrefImpl = (SessionPrefImpl)t;
                            if (!(((SdkOverlay)t).getType() == SdkOverlayType.Twitter)) continue;
                            break block3;
                        }
                        sessionPrefImpl = null;
                    }
                    List<String> list = (SdkOverlay)((Object)sessionPrefImpl);
                    sessionPrefImpl = StreamLayerViewModel.access$getSession$p(this.this$0);
                    if (list == null || (list = ((SdkOverlay)((Object)list)).getSettings()) == null || (list = ((SdkOverlaySettings)((Object)list)).getTwitter()) == null || (list = ((TwitterOverlaySettings)((Object)list)).getAccounts()) == null) {
                        list = CollectionsKt.emptyList();
                    }
                    sessionPrefImpl.setTwitterAccounts(list);
                    streamData.getAttributes().setOverlays(StreamLayerViewModel.access$addCustomOverlays(this.this$0, streamData.getAttributes().getOverlays()));
                }
                StreamLayerViewModel.access$get_streamData$p(this.this$0).setValue(resourceState);
            }
        };
        BaseViewModel.observableCall$default(streamLayerViewModel2, (MutableLiveData)object, (Function0)function03, (Function1)function14, (Function1)function15, null, 16, null);
        object = function0;
        function0 = new Function0<Observable<ResourceState<? extends EventSummaryResponseData>>>(this, string2){
            final /* synthetic */ StreamLayerViewModel this$0;
            final /* synthetic */ String $streamId;
            {
                this.this$0 = streamLayerViewModel2;
                this.$streamId = string2;
                super(0);
            }

            @NotNull
            public final Observable<ResourceState<EventSummaryResponseData>> invoke() {
                return StreamLayerViewModel.access$getSportEventsRepo$p(this.this$0).getEventSummaryResponseData(Long.parseLong(this.$streamId));
            }
        };
        string2 = function1;
        function1 = new Function1<ResourceState<? extends EventSummaryResponseData>, Unit>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel2;
                super(1);
            }

            public final void invoke(@NotNull ResourceState<EventSummaryResponseData> object) {
                ResourceState<EventSummaryResponseData> resourceState = object;
                Intrinsics.checkParameterIsNotNull(resourceState, (String)"it");
                object = resourceState.getData();
                if (object != null && (object = ((EventSummaryResponseData)object).getEventSummary()) != null) {
                    StreamLayerViewModel.access$getSession$p(this.this$0).setCurrentEvent((EventSummary)object);
                }
            }
        };
        BaseViewModel.observableCall$default(streamLayerViewModel2, (Function0)object, null, (Function1)string2, null, 10, null);
    }

    @Override
    protected void onCleared() {
        StreamLayerViewModel streamLayerViewModel2 = this;
        streamLayerViewModel2.notificationsRepo.deleteAllNotifications();
        streamLayerViewModel2.setOnlineStatus(false);
        streamLayerViewModel2.tinode.disconnect();
        streamLayerViewModel2.ringtonePlayer.dismiss();
        Job job = streamLayerViewModel2.sessionHeartbeatJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        super.onCleared();
    }
}

