/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.deeplink;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import androidx.appcompat.app.AppCompatActivity;
import io.streamlayer.sdk.main.StreamLayerFragment;
import io.streamlayer.sdk.model.notifications.Payload;
import io.streamlayer.utils.NavigationUtils;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/streamlayer/sdk/deeplink/StreamLayerDeeplinkHandler;", "", "()V", "DEEP_LINK_NAV_GRAPH_DATA", "", "DEEP_LINK_PAYLOAD_DATA", "buildDeepLinkIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "destinationUri", "Landroid/net/Uri;", "payload", "Lio/streamlayer/sdk/model/notifications/Payload;", "buildDeepLinkIntent$sdk_originalVoximplantRelease", "findHostFragment", "Lio/streamlayer/sdk/main/StreamLayerFragment;", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "getDeepLinkPayloadData", "intent", "getDeepLinkUri", "handleDeepLinkIntent", "", "sdk_originalVoximplantRelease"})
public final class StreamLayerDeeplinkHandler {
    @NotNull
    public static final String DEEP_LINK_NAV_GRAPH_DATA = "deep_link_graph_data";
    @NotNull
    public static final String DEEP_LINK_PAYLOAD_DATA = "deep_link_payload_data";
    public static final StreamLayerDeeplinkHandler INSTANCE = new StreamLayerDeeplinkHandler();

    private final StreamLayerFragment findHostFragment(AppCompatActivity appCompatActivity) {
        return (StreamLayerFragment)appCompatActivity.getSupportFragmentManager().findFragmentByTag("StreamLayerFragment");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Uri getDeepLinkUri(Intent intent) {
        Object object = (Uri)intent.getParcelableExtra(DEEP_LINK_NAV_GRAPH_DATA);
        if (object != null) return object;
        object = intent.getData();
        if (object == null) return null;
        StreamLayerDeeplinkHandler streamLayerDeeplinkHandler = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)streamLayerDeeplinkHandler, (String)"it");
        object = streamLayerDeeplinkHandler.getPath();
        if (object == null) return null;
        if (!StringsKt.startsWith$default((String)object, (String)"/invites", (boolean)false, (int)2, null)) return null;
        return NavigationUtils.INSTANCE.buildInvitesDeepLink(null);
    }

    private final Payload getDeepLinkPayloadData(Intent intent) {
        return (Payload)intent.getSerializableExtra(DEEP_LINK_PAYLOAD_DATA);
    }

    private StreamLayerDeeplinkHandler() {
    }

    public final boolean handleDeepLinkIntent(@NotNull Intent intent, @NotNull AppCompatActivity object) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"activity");
        Uri uri = intent.getData();
        if (Intrinsics.areEqual((Object)(uri != null ? uri.getScheme() : null), (Object)"streamlayer")) {
            if ((object = streamLayerDeeplinkHandler2.findHostFragment((AppCompatActivity)object)) != null) {
                StreamLayerDeeplinkHandler streamLayerDeeplinkHandler = streamLayerDeeplinkHandler2;
                StreamLayerDeeplinkHandler streamLayerDeeplinkHandler2 = streamLayerDeeplinkHandler.getDeepLinkUri(intent);
                StreamLayerFragment.triggerDeepLink$sdk_originalVoximplantRelease$default((StreamLayerFragment)((Object)object), (Uri)streamLayerDeeplinkHandler2, streamLayerDeeplinkHandler.getDeepLinkPayloadData(intent), false, 4, null);
                return true;
            }
            throw new IllegalStateException("StreamLayerFragment not found! Please add android:tag=\"StreamLayerFragment\" to your FragmentContainerView");
        }
        return false;
    }

    @NotNull
    public final Intent buildDeepLinkIntent$sdk_originalVoximplantRelease(@NotNull Context context, @Nullable Uri uri, @Nullable Payload payload) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("streamlayer://" + context.getPackageName())));
        intent.putExtra(DEEP_LINK_NAV_GRAPH_DATA, (Parcelable)uri);
        intent.putExtra(DEEP_LINK_PAYLOAD_DATA, (Serializable)payload);
        return intent;
    }
}

