/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.messaging;

import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.model.tinodecontact.TopicPublicData;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\b\u0081\b\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0019\u001a\u00020\u0006\u0012\u0006\u0010\u001a\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u001b\u001a\u00020\n\u0012\b\b\u0002\u0010\u001c\u001a\u00020\n\u0012\b\b\u0002\u0010\u001d\u001a\u00020\n\u0012\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0013\u0012\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\bL\u0010MJ\u001a\u0010\u0004\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ\u0010\u0010\u000b\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\fJ\u0010\u0010\u000e\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018Jr\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u00062\b\b\u0002\u0010\u001a\u001a\u00020\u00062\b\b\u0002\u0010\u001b\u001a\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\n2\b\b\u0002\u0010\u001d\u001a\u00020\n2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0016H\u00c6\u0001\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010$\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b$\u0010\bJ\u0010\u0010%\u001a\u00020\nH\u00d6\u0001\u00a2\u0006\u0004\b%\u0010\fR\u0019\u0010\u001a\u001a\u00020\u00068\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010&\u001a\u0004\b'\u0010\bR\u001e\u0010!\u001a\u0004\u0018\u00010\u00168\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b!\u0010(\u001a\u0004\b)\u0010\u0018R\u0013\u0010*\u001a\u00020\u00038F@\u0006\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001b\u0010\u001e\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010,\u001a\u0004\b-\u0010\u0011R\u001e\u0010 \u001a\u0004\u0018\u00010\u00138\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b \u0010.\u001a\u0004\b/\u0010\u0015R(\u00102\u001a\b\u0012\u0004\u0012\u000201008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0013\u00108\u001a\u00020\u00038F@\u0006\u00a2\u0006\u0006\u001a\u0004\b8\u0010+R\u0019\u0010\u001d\u001a\u00020\n8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001d\u00109\u001a\u0004\b:\u0010\fR$\u0010<\u001a\u0004\u0018\u00010;8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\"\u0010\u001b\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u00109\u001a\u0004\bB\u0010\f\"\u0004\bC\u0010DR\u001c\u0010\u0019\u001a\u00020\u00068\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010&\u001a\u0004\bE\u0010\bR\u0013\u0010I\u001a\u00020F8F@\u0006\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0019\u0010\u001c\u001a\u00020\n8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001c\u00109\u001a\u0004\bJ\u0010\fR\u001b\u0010\u001f\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010,\u001a\u0004\bK\u0010\u0011\u00a8\u0006N"}, d2={"Lio/streamlayer/sdk/model/messaging/Chat;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "component1", "()Ljava/lang/String;", "component2", "", "component3", "()I", "component4", "component5", "Ljava/util/Date;", "component6", "()Ljava/util/Date;", "component7", "Lio/streamlayer/sdk/model/tinodecontact/TopicPublicData;", "component8", "()Lio/streamlayer/sdk/model/tinodecontact/TopicPublicData;", "Lio/streamlayer/sdk/model/messaging/Access;", "component9", "()Lio/streamlayer/sdk/model/messaging/Access;", "chatId", "name", "seq", "readSeq", "recvSeq", "updatedAt", "touchedAt", "publicDataData", "access", "copy", "(Ljava/lang/String;Ljava/lang/String;IIILjava/util/Date;Ljava/util/Date;Lio/streamlayer/sdk/model/tinodecontact/TopicPublicData;Lio/streamlayer/sdk/model/messaging/Access;)Lio/streamlayer/sdk/model/messaging/Chat;", "toString", "hashCode", "Ljava/lang/String;", "getName", "Lio/streamlayer/sdk/model/messaging/Access;", "getAccess", "isCallChat", "()Z", "Ljava/util/Date;", "getUpdatedAt", "Lio/streamlayer/sdk/model/tinodecontact/TopicPublicData;", "getPublicDataData", "", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "participants", "Ljava/util/List;", "getParticipants", "()Ljava/util/List;", "setParticipants", "(Ljava/util/List;)V", "isOwner", "I", "getRecvSeq", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "lastMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "getLastMessage", "()Lio/streamlayer/sdk/model/messaging/ChatMessage;", "setLastMessage", "(Lio/streamlayer/sdk/model/messaging/ChatMessage;)V", "getSeq", "setSeq", "(I)V", "getChatId", "Lio/streamlayer/sdk/model/messaging/ChatType;", "getChatType", "()Lio/streamlayer/sdk/model/messaging/ChatType;", "chatType", "getReadSeq", "getTouchedAt", "<init>", "(Ljava/lang/String;Ljava/lang/String;IIILjava/util/Date;Ljava/util/Date;Lio/streamlayer/sdk/model/tinodecontact/TopicPublicData;Lio/streamlayer/sdk/model/messaging/Access;)V", "sdk_originalRelease"})
@Entity
public final class Chat {
    @Ignore
    @NotNull
    private List<TinodeContact> participants;
    @Ignore
    @Nullable
    private ChatMessage lastMessage;
    @PrimaryKey
    @NotNull
    private final String chatId;
    @NotNull
    private final String name;
    private int seq;
    private final int readSeq;
    private final int recvSeq;
    @Nullable
    private final Date updatedAt;
    @Nullable
    private final Date touchedAt;
    @Embedded
    @Nullable
    private final TopicPublicData publicDataData;
    @Embedded
    @Nullable
    private final Access access;

    public Chat(@NotNull String string, @NotNull String string2, int n, int n2, int n3, @Nullable Date date, @Nullable Date date2, @Nullable TopicPublicData topicPublicData, @Nullable Access access) {
        Chat chat = this;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"chatId");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"name");
        this.chatId = string;
        this.name = string2;
        this.seq = n;
        this.readSeq = n2;
        this.recvSeq = n3;
        this.updatedAt = date;
        this.touchedAt = date2;
        this.publicDataData = topicPublicData;
        chat.access = access;
        chat.participants = CollectionsKt.emptyList();
    }

    public /* synthetic */ Chat(String string, String string2, int n, int n2, int n3, Date date, Date date2, TopicPublicData topicPublicData, Access access, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x20) != 0) {
            date = null;
        }
        if ((n4 & 0x40) != 0) {
            date2 = null;
        }
        if ((n4 & 0x80) != 0) {
            topicPublicData = null;
        }
        if ((n4 & 0x100) != 0) {
            access = null;
        }
        this(string, string2, n, n2, n3, date, date2, topicPublicData, access);
    }

    public static /* synthetic */ Chat copy$default(Chat chat, String string, String string2, int n, int n2, int n3, Date date, Date date2, TopicPublicData topicPublicData, Access access, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = chat.chatId;
        }
        if ((n4 & 2) != 0) {
            string2 = chat.name;
        }
        if ((n4 & 4) != 0) {
            n = chat.seq;
        }
        if ((n4 & 8) != 0) {
            n2 = chat.readSeq;
        }
        if ((n4 & 0x10) != 0) {
            n3 = chat.recvSeq;
        }
        if ((n4 & 0x20) != 0) {
            date = chat.updatedAt;
        }
        if ((n4 & 0x40) != 0) {
            date2 = chat.touchedAt;
        }
        if ((n4 & 0x80) != 0) {
            topicPublicData = chat.publicDataData;
        }
        if ((n4 & 0x100) != 0) {
            access = chat.access;
        }
        return chat.copy(string, string2, n, n2, n3, date, date2, topicPublicData, access);
    }

    @NotNull
    public final ChatType getChatType() {
        return StringsKt.startsWith$default((String)this.chatId, (String)"usr", (boolean)false, (int)2, null) ? ChatType.P2P : (StringsKt.startsWith$default((String)this.chatId, (String)"grp", (boolean)false, (int)2, null) ? ChatType.Group : ChatType.Unknown);
    }

    public final boolean isCallChat() {
        Object object = ((Chat)object).publicDataData;
        return object != null && (object = ((TopicPublicData)object).getTags()) != null && object.contains("voiceChatDev7:");
    }

    public final boolean isOwner() {
        Object object = ((Chat)object).access;
        return object != null && (object = ((Access)object).getGiven()) != null && StringsKt.contains$default((CharSequence)object, (CharSequence)"O", (boolean)false, (int)2, null);
    }

    @NotNull
    public final List<TinodeContact> getParticipants() {
        return this.participants;
    }

    public final void setParticipants(@NotNull List<TinodeContact> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.participants = list;
    }

    @Nullable
    public final ChatMessage getLastMessage() {
        return this.lastMessage;
    }

    public final void setLastMessage(@Nullable ChatMessage chatMessage) {
        this.lastMessage = chatMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        if (!super.equals(object)) return false;
        if (!(object instanceof Chat)) return false;
        Object object2 = ((Chat)object2).lastMessage;
        object2 = object2 != null ? Integer.valueOf(((ChatMessage)object2).getSeq()) : null;
        object = ((Chat)object).lastMessage;
        object = object != null ? Integer.valueOf(((ChatMessage)object).getSeq()) : null;
        if (!Intrinsics.areEqual((Object)object2, (Object)object)) return false;
        return true;
    }

    @NotNull
    public final String getChatId() {
        return this.chatId;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getSeq() {
        return this.seq;
    }

    public final void setSeq(int n) {
        this.seq = n;
    }

    public final int getReadSeq() {
        return this.readSeq;
    }

    public final int getRecvSeq() {
        return this.recvSeq;
    }

    @Nullable
    public final Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public final Date getTouchedAt() {
        return this.touchedAt;
    }

    @Nullable
    public final TopicPublicData getPublicDataData() {
        return this.publicDataData;
    }

    @Nullable
    public final Access getAccess() {
        return this.access;
    }

    @NotNull
    public final String component1() {
        return this.chatId;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    public final int component3() {
        return this.seq;
    }

    public final int component4() {
        return this.readSeq;
    }

    public final int component5() {
        return this.recvSeq;
    }

    @Nullable
    public final Date component6() {
        return this.updatedAt;
    }

    @Nullable
    public final Date component7() {
        return this.touchedAt;
    }

    @Nullable
    public final TopicPublicData component8() {
        return this.publicDataData;
    }

    @Nullable
    public final Access component9() {
        return this.access;
    }

    @NotNull
    public final Chat copy(@NotNull String string, @NotNull String string2, int n, int n2, int n3, @Nullable Date date, @Nullable Date date2, @Nullable TopicPublicData topicPublicData, @Nullable Access access) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"chatId");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"name");
        return new Chat(string, string2, n, n2, n3, date, date2, topicPublicData, access);
    }

    @NotNull
    public String toString() {
        return "Chat(chatId=" + this.chatId + ", name=" + this.name + ", seq=" + this.seq + ", readSeq=" + this.readSeq + ", recvSeq=" + this.recvSeq + ", updatedAt=" + this.updatedAt + ", touchedAt=" + this.touchedAt + ", publicDataData=" + this.publicDataData + ", access=" + this.access + ")";
    }

    public int hashCode() {
        String string = this.chatId;
        int n = (string != null ? string.hashCode() : 0) * 31;
        String string2 = this.name;
        int n2 = string2 != null ? string2.hashCode() : 0;
        n = ((((n + n2) * 31 + Integer.hashCode(this.seq)) * 31 + Integer.hashCode(this.readSeq)) * 31 + Integer.hashCode(this.recvSeq)) * 31;
        Date date = this.updatedAt;
        int n3 = date != null ? ((Object)date).hashCode() : 0;
        n = (n + n3) * 31;
        Date date2 = this.touchedAt;
        int n4 = date2 != null ? ((Object)date2).hashCode() : 0;
        n = (n + n4) * 31;
        TopicPublicData topicPublicData = this.publicDataData;
        int n5 = topicPublicData != null ? ((Object)topicPublicData).hashCode() : 0;
        int n6 = (n + n5) * 31;
        Access access = this.access;
        int n7 = access != null ? ((Object)access).hashCode() : 0;
        return n6 + n7;
    }
}

