/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.annotation.RequiresApi;
import io.streamlayer.common.data.notifications.NotificationChannelsHelper$WhenMappings;
import io.streamlayer.sdk.R;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\f\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u0006R\u0016\u0010\u000e\u001a\u00020\t8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\u00108\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\t8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lio/streamlayer/common/data/notifications/NotificationChannelsHelper;", "", "Landroid/content/Context;", "context", "", "setupChannels", "(Landroid/content/Context;)V", "Lio/streamlayer/common/data/notifications/NotificationChannelsHelper$Channel;", "channel", "", "getChannelName", "(Landroid/content/Context;Lio/streamlayer/common/data/notifications/NotificationChannelsHelper$Channel;)Ljava/lang/String;", "getChannelDescription", "initChannels", "CHANNELS_VERSION", "Ljava/lang/String;", "", "VERSION", "I", "PREFS_NAME", "<init>", "()V", "Channel", "sdk_originalRelease"})
public final class NotificationChannelsHelper {
    private static final String PREFS_NAME = "SL_NOTIF_CHANNELS";
    private static final String CHANNELS_VERSION = "channels_version";
    private static final int VERSION = 1;
    public static final NotificationChannelsHelper INSTANCE = new NotificationChannelsHelper();

    @RequiresApi(api=26)
    private final void setupChannels(Context context) {
        Object object = context.getSystemService("notification");
        if (object != null) {
            object = (NotificationManager)object;
            for (Channel channel : Channel.values()) {
                NotificationChannel notificationChannel;
                Object object2;
                NotificationChannel notificationChannel2 = object2 = notificationChannel;
                object2 = channel.name();
                notificationChannel2((String)object2, (CharSequence)this.getChannelName(context, channel), 4);
                notificationChannel.setDescription(this.getChannelDescription(context, channel));
                object.createNotificationChannel(notificationChannel);
            }
            return;
        }
        throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
    }

    private final String getChannelName(Context context, Channel channel) {
        if (NotificationChannelsHelper$WhenMappings.$EnumSwitchMapping$0[channel.ordinal()] == 1) {
            String string2 = context.getString(R.string.slr_streamlayer);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.string.slr_streamlayer)");
            return string2;
        }
        throw new NoWhenBranchMatchedException();
    }

    private final String getChannelDescription(Context context, Channel channel) {
        if (NotificationChannelsHelper$WhenMappings.$EnumSwitchMapping$1[channel.ordinal()] == 1) {
            String string2 = context.getString(R.string.slr_notif_channels_info);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.stri\u2026.slr_notif_channels_info)");
            return string2;
        }
        throw new NoWhenBranchMatchedException();
    }

    private NotificationChannelsHelper() {
    }

    public final void initChannels(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        SharedPreferences sharedPreferences = context2.getSharedPreferences(PREFS_NAME, 0);
        if (Build.VERSION.SDK_INT >= 26 && 1 > sharedPreferences.getInt(CHANNELS_VERSION, 0)) {
            sharedPreferences.edit().putInt(CHANNELS_VERSION, 1).apply();
            this.setupChannels(context);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/streamlayer/common/data/notifications/NotificationChannelsHelper$Channel;", "", "<init>", "(Ljava/lang/String;I)V", "streamlayer", "sdk_originalRelease"})
    public static final class Channel
    extends Enum<Channel> {
        public static final /* enum */ Channel streamlayer;
        private static final /* synthetic */ Channel[] $VALUES;

        static {
            Channel channel;
            Channel[] channelArray = new Channel[1];
            Channel channel2 = channel;
            streamlayer = new Channel();
            channelArray[0] = channel2;
            $VALUES = channelArray;
        }

        public static Channel[] values() {
            return (Channel[])$VALUES.clone();
        }

        public static Channel valueOf(String string2) {
            return Enum.valueOf(Channel.class, string2);
        }
    }
}

