/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.notifications;

import android.net.Uri;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationKt$WhenMappings;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.utils.GsonUtil;
import io.streamlayer.utils.NavigationUtils;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005*\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/streamlayer/sdk/model/notifications/NotificationType;", "", "isCallType", "(Lio/streamlayer/sdk/model/notifications/NotificationType;)Z", "Lio/streamlayer/sdk/model/notifications/Notification;", "Landroid/net/Uri;", "deepLink", "(Lio/streamlayer/sdk/model/notifications/Notification;)Landroid/net/Uri;", "sdk_originalRelease"})
public final class NotificationKt {
    public static final boolean isCallType(@NotNull NotificationType notificationType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)notificationType), (String)"$this$isCallType");
        return ArraysKt.contains((Object[])new NotificationType[]{NotificationType.WatchParty}, (Object)((Object)notificationType));
    }

    @Nullable
    public static final Uri deepLink(@NotNull Notification object) {
        Uri uri;
        Notification notification = object;
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"$this$deepLink");
        switch (NotificationKt$WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()]) {
            default: {
                uri = null;
                break;
            }
            case 4: {
                uri = NavigationUtils.INSTANCE.buildTweetDeepLink(((Notification)object).getSourceUniqueId());
                break;
            }
            case 3: {
                uri = NavigationUtils.INSTANCE.buildWatchPartyDeepLink(null);
                break;
            }
            case 2: {
                object = (ChatMessage)GsonUtil.INSTANCE.getDefaultGson().fromJson(((Notification)object).getDataJson(), ChatMessage.class);
                NavigationUtils navigationUtils = NavigationUtils.INSTANCE;
                object = object != null ? ((ChatMessage)object).getTopicId() : null;
                uri = navigationUtils.buildChatMessageDeepLink((String)object);
                break;
            }
            case 1: {
                uri = NavigationUtils.INSTANCE.buildChatMessageDeepLink(NotificationUtilKt.fromWaveSourceId(((Notification)object).getSourceUniqueId()));
            }
        }
        return uri;
    }
}

