/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.voximplant;

import com.voximplant.sdk.call.CallSettings;
import com.voximplant.sdk.call.ICall;
import com.voximplant.sdk.call.ICallListener;
import com.voximplant.sdk.call.IEndpoint;
import com.voximplant.sdk.call.IQualityIssueListener;
import com.voximplant.sdk.call.QualityIssueLevel;
import com.voximplant.sdk.call.VideoFlags;
import com.voximplant.sdk.client.IClient;
import com.voximplant.sdk.client.IClientIncomingCallListener;
import io.streamlayer.common.client.VoiceClientWrapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000bJ\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016J(\u0010\u0015\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0017H\u0016J0\u0010\u0018\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J:\u0010\u001b\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0017H\u0016J(\u0010\u001f\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0017H\u0016J\u001c\u0010 \u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u0010#\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010$\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016J,\u0010%\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u001a2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0'H\u0016J,\u0010(\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0016J\u001c\u0010.\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lio/streamlayer/common/data/voximplant/VoximplantCallManager;", "Lcom/voximplant/sdk/client/IClientIncomingCallListener;", "Lcom/voximplant/sdk/call/ICallListener;", "Lcom/voximplant/sdk/call/IQualityIssueListener;", "clientWrapper", "Lio/streamlayer/common/client/VoiceClientWrapper;", "(Lio/streamlayer/common/client/VoiceClientWrapper;)V", "client", "Lcom/voximplant/sdk/client/IClient;", "mCalls", "Ljava/util/HashMap;", "", "Lcom/voximplant/sdk/call/ICall;", "createCall", "topicId", "endAllCalls", "", "endCall", "callId", "onCallAudioStarted", "call", "onCallConnected", "headers", "", "onCallDisconnected", "answeredElsewhere", "", "onCallFailed", "code", "", "description", "onCallRinging", "onEndpointAdded", "endpoint", "Lcom/voximplant/sdk/call/IEndpoint;", "onICECompleted", "onICETimeout", "onIncomingCall", "video", "", "onLowBandwidth", "level", "Lcom/voximplant/sdk/call/QualityIssueLevel;", "targetBitrate", "", "actualBitrate", "onNoAudioSignal", "sdk_originalVoximplantRelease"})
public final class VoximplantCallManager
implements IClientIncomingCallListener,
ICallListener,
IQualityIssueListener {
    private final IClient client;
    private final HashMap<String, ICall> mCalls;

    @Inject
    public VoximplantCallManager(@NotNull VoiceClientWrapper voiceClientWrapper) {
        Intrinsics.checkParameterIsNotNull((Object)voiceClientWrapper, (String)"clientWrapper");
        this.client = voiceClientWrapper.getVoximplantClient();
        this.mCalls = new HashMap();
        this.client.setClientIncomingCallListener((IClientIncomingCallListener)this);
    }

    public final void endCall(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"callId");
        ICall iCall = this.mCalls.get(string2);
        if (iCall != null) {
            iCall.hangup(null);
        }
        this.mCalls.remove(string2);
    }

    @Nullable
    public final ICall createCall(@NotNull String string2) {
        CallSettings callSettings;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        String cfr_ignored_0 = "create call: " + string2;
        CallSettings callSettings2 = callSettings;
        new CallSettings().videoFlags = new VideoFlags(false, false);
        callSettings2 = this.client.callConference("conf_" + string2, callSettings2);
        if (callSettings2 != null) {
            CallSettings callSettings3 = callSettings2;
            VoximplantCallManager voximplantCallManager = this;
            String cfr_ignored_1 = "call created: " + callSettings2;
            voximplantCallManager.mCalls.put(string2, (ICall)callSettings2);
            callSettings2.addCallListener((ICallListener)voximplantCallManager);
            callSettings3.setQualityIssueListener((IQualityIssueListener)this);
            callSettings3.start();
            return callSettings3;
        }
        return null;
    }

    public final void endAllCalls() {
        Iterator iterator = ((VoximplantCallManager)((Object)iterator)).mCalls.entrySet().iterator();
        while (iterator.hasNext()) {
            ((ICall)((Map.Entry)iterator.next()).getValue()).hangup(null);
        }
    }

    public void onIncomingCall(@NotNull ICall iCall, boolean bl, @NotNull Map<String, String> map2) {
        VoximplantCallManager voximplantCallManager = this;
        Intrinsics.checkParameterIsNotNull((Object)iCall, (String)"call");
        Intrinsics.checkParameterIsNotNull(map2, (String)"headers");
        HashMap<String, ICall> hashMap = voximplantCallManager.mCalls;
        String string2 = iCall.getCallId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"call.callId");
        hashMap.put(string2, iCall);
        iCall.addCallListener((ICallListener)voximplantCallManager);
        iCall.setQualityIssueListener((IQualityIssueListener)this);
        String cfr_ignored_0 = "Incoming call " + iCall;
    }

    public void onCallRinging(@Nullable ICall iCall, @Nullable Map<String, String> map2) {
        String cfr_ignored_0 = "Call ringing: " + iCall;
    }

    public void onCallConnected(@Nullable ICall iCall, @Nullable Map<String, String> map2) {
        String cfr_ignored_0 = "Call connected: " + iCall;
    }

    public void onCallDisconnected(@Nullable ICall iCall, @Nullable Map<String, String> map2, boolean bl) {
        String cfr_ignored_0 = "Call disconnected: " + iCall + ", answeredElsewhere: " + bl;
    }

    public void onCallAudioStarted(@Nullable ICall iCall) {
        String cfr_ignored_0 = "Call audio started: " + String.valueOf(iCall);
    }

    public void onCallFailed(@Nullable ICall iCall, int n, @Nullable String string2, @Nullable Map<String, String> map2) {
        String cfr_ignored_0 = "Call failed: " + iCall + ", code: " + n + ", description: " + string2;
    }

    public void onEndpointAdded(@Nullable ICall iCall, @Nullable IEndpoint iEndpoint) {
        String cfr_ignored_0 = "Endpoint added: " + iCall + ", endpoint: " + iEndpoint;
    }

    public void onICECompleted(@Nullable ICall iCall) {
        String cfr_ignored_0 = "On ICE completed: " + iCall;
    }

    public void onICETimeout(@Nullable ICall iCall) {
        String cfr_ignored_0 = "On ICE timeout: " + iCall;
    }

    public void onNoAudioSignal(@Nullable ICall iCall, @Nullable QualityIssueLevel qualityIssueLevel) {
        String cfr_ignored_0 = "On NoAudioSignal: " + iCall + ", level: " + qualityIssueLevel;
    }

    public void onLowBandwidth(@Nullable ICall iCall, @Nullable QualityIssueLevel qualityIssueLevel, double d, double d2) {
        String cfr_ignored_0 = "On LowBandwith: " + iCall + ", level: " + qualityIssueLevel + ", target: " + d + ", actual: " + d2;
    }
}

