/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.SoundPool;
import io.streamlayer.common.data.notifications.InAppNotificationsService$WhenMappings;
import io.streamlayer.common.data.notifications.NotificationUtil;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.calls.call.CallConnectionStatus;
import io.streamlayer.sdk.messaging.MessagingExtensionsKt;
import io.streamlayer.sdk.model.analytics.AnalyticsDataKt;
import io.streamlayer.sdk.model.analytics.CommonKind;
import io.streamlayer.sdk.model.analytics.NotificationType;
import io.streamlayer.sdk.model.calls.CallStatus;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.sdksettings.ClientSettings;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import io.streamlayer.utils.RingtonePlayer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/J\u0016\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020\"2\u0006\u00102\u001a\u00020\u0014J\b\u00103\u001a\u00020 H\u0002J\u0010\u00104\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u00105\u001a\u00020 2\u0006\u0010#\u001a\u00020$J\u0010\u00106\u001a\u00020 2\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020 2\u0006\u00107\u001a\u000208H\u0002J\b\u0010:\u001a\u00020 H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006;"}, d2={"Lio/streamlayer/common/data/notifications/InAppNotificationsService;", "", "context", "Landroid/content/Context;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "notificationsRepo", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "analyticsRepo", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "ringtonePlayer", "Lio/streamlayer/utils/RingtonePlayer;", "(Landroid/content/Context;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/sdk/repository/notifications/NotificationRepo;Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;Lio/streamlayer/utils/RingtonePlayer;)V", "generalSound", "", "lastTimestampSoundPlayed", "", "messageSound", "pausedTopicsNotifications", "", "", "settings", "Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "getSettings", "()Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "soundPool", "Landroid/media/SoundPool;", "kotlin.jvm.PlatformType", "tinodeUserId", "getTinodeUserId", "()Ljava/lang/String;", "disconnect", "", "isSoundEnabled", "", "type", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "notifyCall", "voiceChat", "Lio/streamlayer/sdk/model/messaging/Chat;", "callStatus", "Lio/streamlayer/sdk/model/calls/CallStatus;", "notifyChatMessage", "chatMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "notifyTweet", "tweet", "Lio/streamlayer/sdk/model/social/Tweet;", "pauseNotifications", "pause", "chatId", "playCallRingtone", "playNotificationSound", "playSound", "showInAppNotification", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "showNotification", "stopCallRingtone", "sdk_originalVoximplantRelease"})
public final class InAppNotificationsService {
    private final List<String> pausedTopicsNotifications;
    private long lastTimestampSoundPlayed;
    private final SoundPool soundPool;
    private final int generalSound;
    private final int messageSound;
    private final Context context;
    private final SessionPrefImpl session;
    private final NotificationRepo notificationsRepo;
    private final AnalyticsRepo analyticsRepo;
    private final RingtonePlayer ringtonePlayer;

    private final String getTinodeUserId() {
        return this.session.getTinodeUserId();
    }

    private final ClientSettings getSettings() {
        return this.session.getClientSettings();
    }

    private final void showNotification(Notification notification) {
        if (NotificationUtil.INSTANCE.isNotificationEnabled$sdk_originalVoximplantRelease(this.session, notification) && NotificationUtil.INSTANCE.isAppInForeground()) {
            this.showInAppNotification(notification);
        }
    }

    private final void showInAppNotification(Notification notification) {
        if (ArraysKt.contains((Object[])new io.streamlayer.sdk.model.notifications.NotificationType[]{io.streamlayer.sdk.model.notifications.NotificationType.Call, io.streamlayer.sdk.model.notifications.NotificationType.GroupCall, io.streamlayer.sdk.model.notifications.NotificationType.GroupCallActive, io.streamlayer.sdk.model.notifications.NotificationType.MissedCall, io.streamlayer.sdk.model.notifications.NotificationType.MissedGroupCall}, (Object)((Object)notification.getType()))) {
            this.notificationsRepo.upsertNotificationBySourceId(notification);
        } else {
            this.notificationsRepo.saveNotification(notification);
        }
        InAppNotificationsService inAppNotificationsService = this;
        inAppNotificationsService.playSound(notification.getType());
        AnalyticsRepo.DefaultImpls.triggerNotificationEvent$default(inAppNotificationsService.analyticsRepo, NotificationType.IN_APP, AnalyticsDataKt.toKind(notification.getType()), CommonKind.NOTIFICATION_RECEIVED, null, 8, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean isSoundEnabled(io.streamlayer.sdk.model.notifications.NotificationType notificationType) {
        switch (InAppNotificationsService$WhenMappings.$EnumSwitchMapping$1[notificationType.ordinal()]) {
            case 5: {
                Object object = ((InAppNotificationsService)object).getSettings();
                if (object == null) return false;
                if (!((ClientSettings)object).getFriendsSound()) return false;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                Object object = ((InAppNotificationsService)object).getSettings();
                if (object == null) return false;
                if (!((ClientSettings)object).getCallsSound()) return false;
                break;
            }
            case 1: {
                Object object = ((InAppNotificationsService)object).getSettings();
                if (object == null) return false;
                if (!((ClientSettings)object).getMessagesSound()) return false;
            }
        }
        return true;
    }

    private final void playNotificationSound(io.streamlayer.sdk.model.notifications.NotificationType notificationType) {
        long l = System.currentTimeMillis();
        if (l > this.lastTimestampSoundPlayed + (long)1200) {
            this.lastTimestampSoundPlayed = l;
            int n = InAppNotificationsService$WhenMappings.$EnumSwitchMapping$2[notificationType.ordinal()] != 1 ? this.generalSound : this.messageSound;
            this.soundPool.play(n, 1.0f, 1.0f, 0, 0, 1.0f);
        }
    }

    private final void playCallRingtone() {
        this.ringtonePlayer.ring();
    }

    private final void stopCallRingtone() {
        this.ringtonePlayer.dismiss();
    }

    @Inject
    public InAppNotificationsService(@NotNull Context context, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull NotificationRepo notificationRepo, @NotNull AnalyticsRepo analyticsRepo, @NotNull RingtonePlayer ringtonePlayer) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)notificationRepo, (String)"notificationsRepo");
        Intrinsics.checkParameterIsNotNull((Object)analyticsRepo, (String)"analyticsRepo");
        Intrinsics.checkParameterIsNotNull((Object)ringtonePlayer, (String)"ringtonePlayer");
        this.context = context;
        this.session = sessionPrefImpl;
        this.notificationsRepo = notificationRepo;
        this.analyticsRepo = analyticsRepo;
        this.ringtonePlayer = ringtonePlayer;
        this.pausedTopicsNotifications = new ArrayList<String>();
        context = new SoundPool.Builder().setMaxStreams(2).setAudioAttributes(new AudioAttributes.Builder().setUsage(5).setContentType(4).build()).build();
        this.soundPool = context;
        this.generalSound = context.load(this.context, R.raw.slr_general_notification, 1);
        this.messageSound = this.soundPool.load(this.context, R.raw.slr_message_notification, 1);
    }

    public final void notifyChatMessage(@NotNull ChatMessage object) {
        ChatMessage chatMessage = object;
        Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"chatMessage");
        if (!Intrinsics.areEqual((Object)chatMessage.getSenderUserId(), (Object)this.getTinodeUserId()) && !StringsKt.isBlank((CharSequence)((ChatMessage)object).getText())) {
            ChatMessage chatMessage2 = object;
            object = chatMessage2.getTopicId();
            Notification notification = NotificationUtilKt.toNotification$default(chatMessage2, null, 1, null);
            if (!this.pausedTopicsNotifications.contains(object)) {
                this.session.incrementTotalUnreadMessagesCount();
                this.showNotification(notification);
            }
            return;
        }
    }

    public final void notifyCall(@NotNull Chat chat, @NotNull CallStatus object) {
        Notification notification;
        Object object2;
        Date date;
        ArrayList<String> arrayList;
        CallStatus callStatus = object;
        Chat chat2 = chat;
        Intrinsics.checkParameterIsNotNull((Object)chat, (String)"voiceChat");
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"callStatus");
        String cfr_ignored_0 = "notifyCall: " + chat + ' ' + object;
        object = chat.getChatId();
        Object object3 = MessagingExtensionsKt.participantsWithoutUser(chat2, this.session.getTinodeUserId());
        chat2.getLastMessage();
        Object object4 = callStatus.getStatus();
        boolean bl = object4 == CallConnectionStatus.Connected;
        boolean bl2 = object4 == CallConnectionStatus.Ended;
        Long l = null;
        Object object5 = arrayList;
        arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault(object3, (int)10));
        Object object6 = object3.iterator();
        while (object6.hasNext()) {
            object5.add(((TinodeContact)object6.next()).getChatName());
        }
        object5 = CollectionsKt.joinToString$default(object5, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        switch (InAppNotificationsService$WhenMappings.$EnumSwitchMapping$0[object4.ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 4: {
                object4 = this.context.getString(R.string.slr_missed_voice_chat);
                break;
            }
            case 3: {
                if (object3.size() != 1) {
                    object4 = this.context.getString(R.string.slr_active_call);
                    break;
                }
                object4 = this.context.getString(R.string.slr_incoming_voice_chat);
                break;
            }
            case 2: {
                object4 = this.context.getString(R.string.slr_incoming_voice_chat);
                break;
            }
            case 1: {
                object4 = this.context.getString(R.string.slr_incoming_voice_chat);
            }
        }
        String string2 = (!bl2 && object3.size() > 1 && bl ? io.streamlayer.sdk.model.notifications.NotificationType.GroupCallActive : (!bl2 && object3.size() > 1 && !bl ? io.streamlayer.sdk.model.notifications.NotificationType.GroupCall : (!bl2 ? io.streamlayer.sdk.model.notifications.NotificationType.Call : (bl2 && object3.size() > 1 ? io.streamlayer.sdk.model.notifications.NotificationType.MissedGroupCall : io.streamlayer.sdk.model.notifications.NotificationType.MissedCall)))).name();
        Date date2 = date;
        date = new Date();
        object6 = "topic_" + chat.getChatId();
        if (object3.size() == 1) {
            List<TinodeContact> list = object3;
            object3 = NotificationIcon.Companion;
            object2 = ((TinodeContact)CollectionsKt.first(list)).getPhotoData();
            String string3 = ((TinodeContact)CollectionsKt.first(list)).getChatName();
            if (string3 == null) {
                string3 = "";
            }
            object3 = ((NotificationIcon.Companion)object3).buildAvatarIcon((String)object2, string3);
        } else {
            object3 = null;
        }
        object2 = notification;
        notification = new Notification(l, (String)object5, (String)object4, string2, date2, (String)object6, chat, (NotificationIcon)object3);
        if (!this.pausedTopicsNotifications.contains(object)) {
            this.showNotification((Notification)object2);
        }
        if (ArraysKt.contains((Object[])new io.streamlayer.sdk.model.notifications.NotificationType[]{io.streamlayer.sdk.model.notifications.NotificationType.MissedCall, io.streamlayer.sdk.model.notifications.NotificationType.MissedGroupCall}, (Object)((Object)((Notification)object2).getType()))) {
            this.session.setTopicMuted(true, (String)object);
        }
    }

    public final void notifyTweet(@NotNull Tweet tweet) {
        Tweet tweet2 = tweet;
        Intrinsics.checkParameterIsNotNull((Object)tweet2, (String)"tweet");
        this.showNotification(NotificationUtilKt.toNotification(tweet2));
    }

    public final void playSound(@NotNull io.streamlayer.sdk.model.notifications.NotificationType notificationType) {
        io.streamlayer.sdk.model.notifications.NotificationType notificationType2 = notificationType;
        Intrinsics.checkParameterIsNotNull((Object)((Object)notificationType2), (String)"type");
        if (!this.isSoundEnabled(notificationType2)) {
            return;
        }
        if (ArraysKt.contains((Object[])new io.streamlayer.sdk.model.notifications.NotificationType[]{io.streamlayer.sdk.model.notifications.NotificationType.Call, io.streamlayer.sdk.model.notifications.NotificationType.GroupCall}, (Object)((Object)notificationType))) {
            this.playCallRingtone();
        } else if (ArraysKt.contains((Object[])new io.streamlayer.sdk.model.notifications.NotificationType[]{io.streamlayer.sdk.model.notifications.NotificationType.MissedCall, io.streamlayer.sdk.model.notifications.NotificationType.MissedGroupCall}, (Object)((Object)notificationType))) {
            this.stopCallRingtone();
        } else {
            this.playNotificationSound(notificationType);
        }
    }

    public final void disconnect() {
        this.notificationsRepo.deleteAllNotifications();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void pauseNotifications(boolean bl, @NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        if (bl) {
            this.pausedTopicsNotifications.add(string2);
            return;
        }
        try {
            Result.constructor-impl((Object)this.pausedTopicsNotifications.remove(string2));
            return;
        }
        catch (Throwable throwable) {
            Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return;
        }
    }
}

