/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.chat;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.format.DateUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.common.mvvm.pagination.GenericPagedListAdapter;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.messaging.chat.MessagingAdapter$MessageViewHolder$WhenMappings;
import io.streamlayer.sdk.messaging.chat.MessagingAdapterKt;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import io.streamlayer.utils.AvatarUtil;
import io.streamlayer.utils.DateUtil;
import io.streamlayer.utils.EmojiUtil;
import java.util.Date;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0019\u001a\u001bB#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0014J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0011H\u0014R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "userId", "", "alertClickHandle", "Lkotlin/Function1;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "value", "Lio/streamlayer/sdk/model/messaging/ChatType;", "mode", "getMode", "()Lio/streamlayer/sdk/model/messaging/ChatType;", "setMode", "(Lio/streamlayer/sdk/model/messaging/ChatType;)V", "getItemViewType", "", "position", "getLayoutId", "viewType", "getViewHolder", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter$GenericViewHolder;", "view", "Landroid/view/View;", "MessageReceiverViewHolder", "MessageSenderViewHolder", "MessageViewHolder", "sdk_originalVoximplantRelease"})
public final class MessagingAdapter
extends GenericPagedListAdapter<ChatMessage> {
    @NotNull
    private ChatType mode;
    private final String userId;
    private final Function1<ChatMessage, Unit> alertClickHandle;

    public MessagingAdapter(@NotNull String string2, @NotNull Function1<? super ChatMessage, Unit> function1) {
        MessagingAdapter messagingAdapter = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"userId");
        Intrinsics.checkParameterIsNotNull(function1, (String)"alertClickHandle");
        super(MessagingAdapterKt.access$getDiffItemCallback$p());
        this.userId = string2;
        messagingAdapter.alertClickHandle = function1;
        messagingAdapter.mode = ChatType.P2P;
    }

    public static final /* synthetic */ ChatMessage access$getItem(MessagingAdapter messagingAdapter, int n) {
        return (ChatMessage)messagingAdapter.getItem(n);
    }

    @NotNull
    public final ChatType getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull ChatType chatType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)chatType), (String)"value");
        if (this.mode != chatType) {
            this.mode = chatType;
            this.notifyDataSetChanged();
        }
    }

    @Override
    protected int getLayoutId(int n) {
        return n != 0 ? (n != 1 ? (n != 2 ? 0 : R.layout.slr_item_chat_receiver) : R.layout.slr_item_chat_receiver) : R.layout.slr_item_chat_sender;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected GenericPagedListAdapter.GenericViewHolder<ChatMessage> getViewHolder(@NotNull View view, int n) {
        void var3_9;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (n != 0) {
            if (n != 1) {
                MessageReceiverViewHolder messageReceiverViewHolder;
                if (n != 2) throw new RuntimeException("Unsupported item view type: " + n);
                ((ConstraintLayout)view.findViewById(R.id.chatMessageContainer)).setBackgroundResource(R.drawable.slr_shape_chat_bubble_contact);
                Function1<ChatMessage, Unit> function1 = this.alertClickHandle;
                MessageReceiverViewHolder messageReceiverViewHolder2 = messageReceiverViewHolder;
                messageReceiverViewHolder = new MessageReceiverViewHolder(view, true, function1);
                return var3_9;
            } else {
                MessageReceiverViewHolder messageReceiverViewHolder;
                ((ConstraintLayout)view.findViewById(R.id.chatMessageContainer)).setBackgroundResource(R.drawable.slr_shape_chat_bubble_contact_p2p);
                Function1<ChatMessage, Unit> function1 = this.alertClickHandle;
                MessageReceiverViewHolder messageReceiverViewHolder3 = messageReceiverViewHolder;
                messageReceiverViewHolder = new MessageReceiverViewHolder(view, false, function1);
            }
            return var3_9;
        } else {
            MessageSenderViewHolder messageSenderViewHolder;
            MessageSenderViewHolder messageSenderViewHolder2 = messageSenderViewHolder;
            Function1<ChatMessage, Unit> function1 = this.alertClickHandle;
            messageSenderViewHolder = new MessageSenderViewHolder(view, function1);
        }
        return var3_9;
    }

    public int getItemViewType(int n) {
        block2: {
            block6: {
                int n2;
                block4: {
                    block5: {
                        block3: {
                            ChatMessage chatMessage = (ChatMessage)this.getItem(n);
                            if (chatMessage == null) break block2;
                            ChatMessage chatMessage2 = chatMessage;
                            Intrinsics.checkExpressionValueIsNotNull((Object)chatMessage2, (String)"getItem(position) ?: ret\u2026getItemViewType(position)");
                            boolean bl = Intrinsics.areEqual((Object)chatMessage2.getSenderUserId(), (Object)this.userId);
                            n = bl ? 1 : 0;
                            if (!bl) break block3;
                            n2 = 0;
                            break block4;
                        }
                        if (n != 0 || this.mode != ChatType.Group) break block5;
                        n2 = 2;
                        break block4;
                    }
                    if (n != 0 || this.mode != ChatType.P2P) break block6;
                    n2 = 1;
                }
                return n2;
            }
            throw new RuntimeException("Unsupported state. isCurrentUser: " + (n != 0) + "; mode: " + (Object)((Object)this.mode));
        }
        return super.getItemViewType(n);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b\u00a6\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0002H\u0016J\n\u0010#\u001a\u0004\u0018\u00010\u0002H\u0004J\n\u0010$\u001a\u0004\u0018\u00010\u0002H\u0004R\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0011\u0010\rR\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u0019\u0010\u0016R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u000f\u001a\u0004\b\u001f\u0010\r\u00a8\u0006%"}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageViewHolder;", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "itemView", "Landroid/view/View;", "alertClickHandle", "Lkotlin/Function1;", "", "(Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;Landroid/view/View;Lkotlin/jvm/functions/Function1;)V", "getAlertClickHandle", "()Lkotlin/jvm/functions/Function1;", "chatAlertImage", "getChatAlertImage", "()Landroid/view/View;", "chatAlertImage$delegate", "Lkotlin/Lazy;", "chatMessageContainer", "getChatMessageContainer", "chatMessageContainer$delegate", "chatMessageContent", "Landroid/widget/TextView;", "getChatMessageContent", "()Landroid/widget/TextView;", "chatMessageContent$delegate", "chatTimestamp", "getChatTimestamp", "chatTimestamp$delegate", "defaultBackground", "Landroid/graphics/drawable/Drawable;", "sendingFailedText", "kotlin.jvm.PlatformType", "getSendingFailedText", "sendingFailedText$delegate", "bind", "message", "getNextMessage", "getPreviousMessage", "sdk_originalVoximplantRelease"})
    public abstract class MessageViewHolder
    extends GenericPagedListAdapter.GenericViewHolder<ChatMessage> {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        private final Lazy chatTimestamp$delegate;
        private final Lazy chatMessageContent$delegate;
        private final Lazy chatMessageContainer$delegate;
        private final Lazy chatAlertImage$delegate;
        private final Lazy sendingFailedText$delegate;
        private final Drawable defaultBackground;
        @NotNull
        private final Function1<ChatMessage, Unit> alertClickHandle;

        static {
            $$delegatedProperties = new KProperty[]{Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MessageViewHolder.class), "chatTimestamp", "getChatTimestamp()Landroid/widget/TextView;")), Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MessageViewHolder.class), "chatMessageContent", "getChatMessageContent()Landroid/widget/TextView;")), Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MessageViewHolder.class), "chatMessageContainer", "getChatMessageContainer()Landroid/view/View;")), Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MessageViewHolder.class), "chatAlertImage", "getChatAlertImage()Landroid/view/View;")), Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MessageViewHolder.class), "sendingFailedText", "getSendingFailedText()Landroid/view/View;"))};
        }

        private final TextView getChatTimestamp() {
            KProperty cfr_ignored_0 = $$delegatedProperties[0];
            return (TextView)this.chatTimestamp$delegate.getValue();
        }

        private final TextView getChatMessageContent() {
            KProperty cfr_ignored_0 = $$delegatedProperties[1];
            return (TextView)this.chatMessageContent$delegate.getValue();
        }

        private final View getChatMessageContainer() {
            KProperty cfr_ignored_0 = $$delegatedProperties[2];
            return (View)this.chatMessageContainer$delegate.getValue();
        }

        private final View getChatAlertImage() {
            KProperty cfr_ignored_0 = $$delegatedProperties[3];
            return (View)this.chatAlertImage$delegate.getValue();
        }

        private final View getSendingFailedText() {
            KProperty cfr_ignored_0 = $$delegatedProperties[4];
            return (View)this.sendingFailedText$delegate.getValue();
        }

        public MessageViewHolder(@NotNull View view, Function1<? super ChatMessage, Unit> function1) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            Intrinsics.checkParameterIsNotNull(function1, (String)"alertClickHandle");
            super(view);
            this.alertClickHandle = function1;
            this.chatTimestamp$delegate = LazyKt.lazy((Function0)new Function0<TextView>(view){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view;
                    super(0);
                }

                public final TextView invoke() {
                    return (TextView)this.$itemView.findViewById(R.id.chatTimestamp);
                }
            });
            this.chatMessageContent$delegate = LazyKt.lazy((Function0)new Function0<TextView>(view){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view;
                    super(0);
                }

                public final TextView invoke() {
                    return (TextView)this.$itemView.findViewById(R.id.chatMessageContent);
                }
            });
            this.chatMessageContainer$delegate = LazyKt.lazy((Function0)new Function0<View>(view){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view;
                    super(0);
                }

                public final View invoke() {
                    return this.$itemView.findViewById(R.id.chatMessageContainer);
                }
            });
            this.chatAlertImage$delegate = LazyKt.lazy((Function0)new Function0<View>(view){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view;
                    super(0);
                }

                public final View invoke() {
                    return this.$itemView.findViewById(R.id.alert);
                }
            });
            this.sendingFailedText$delegate = LazyKt.lazy((Function0)new Function0<View>(view){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view;
                    super(0);
                }

                public final View invoke() {
                    return this.$itemView.findViewById(R.id.sendingFailedMessage);
                }
            });
            Drawable drawable2 = this.getChatMessageContainer().getBackground();
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"chatMessageContainer.background");
            this.defaultBackground = drawable2;
        }

        @Nullable
        protected final ChatMessage getPreviousMessage() {
            Object object;
            MessagingAdapter messagingAdapter = object.MessagingAdapter.this;
            int n = object.getLayoutPosition();
            try {
                object = Result.constructor-impl((Object)MessagingAdapter.access$getItem(messagingAdapter, n + 1));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                object = null;
            }
            return (ChatMessage)object;
        }

        @Nullable
        protected final ChatMessage getNextMessage() {
            Object object;
            MessagingAdapter messagingAdapter = object.MessagingAdapter.this;
            int n = object.getLayoutPosition();
            try {
                object = Result.constructor-impl((Object)MessagingAdapter.access$getItem(messagingAdapter, n - 1));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                object = null;
            }
            return (ChatMessage)object;
        }

        @Override
        public void bind(@NotNull ChatMessage chatMessage) {
            block18: {
                block17: {
                    block16: {
                        Object object;
                        ChatMessage chatMessage2 = chatMessage;
                        Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"message");
                        if (chatMessage2.getDate() != null) {
                            TextView textView = this.getChatTimestamp();
                            View view = this.itemView;
                            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                            textView.setText(DateUtils.getRelativeDateTimeString((Context)view.getContext(), (long)chatMessage.getDate().getTime(), (long)86400000L, (long)86400000L, (int)0));
                        }
                        MessagingAdapter messagingAdapter = MessagingAdapter.this;
                        int n = this.getLayoutPosition();
                        try {
                            object = Result.constructor-impl((Object)MessagingAdapter.access$getItem(messagingAdapter, n + 1));
                        }
                        catch (Throwable throwable) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        if (Result.isFailure-impl((Object)object)) {
                            object = null;
                        }
                        object = (ChatMessage)object;
                        int n2 = chatMessage.getDate() != null && ((object != null ? ((ChatMessage)object).getDate() : null) == null || !DateUtil.INSTANCE.isSameDay((Date)(object = ((ChatMessage)object).getDate()), chatMessage.getDate())) ? 1 : 0;
                        ExtensionsKt.visibleIf((View)this.getChatTimestamp(), n2 != 0);
                        n2 = MessagingAdapter$MessageViewHolder$WhenMappings.$EnumSwitchMapping$0[chatMessage.getStatus().ordinal()];
                        if (n2 != 1) {
                            if (n2 != 2) {
                                if (n2 != 3) {
                                    MessageViewHolder messageViewHolder = this;
                                    View view = messageViewHolder.itemView;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                                    view.setAlpha(1.0f);
                                    messageViewHolder.getChatAlertImage().setVisibility(8);
                                    View view2 = messageViewHolder.getSendingFailedText();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"sendingFailedText");
                                    view2.setVisibility(8);
                                } else {
                                    MessageViewHolder messageViewHolder = this;
                                    messageViewHolder.getChatAlertImage().setVisibility(8);
                                    View view = messageViewHolder.getSendingFailedText();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"sendingFailedText");
                                    view.setVisibility(8);
                                }
                            } else {
                                MessageViewHolder messageViewHolder = this;
                                messageViewHolder.getChatAlertImage().setVisibility(0);
                                View view = messageViewHolder.getSendingFailedText();
                                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"sendingFailedText");
                                view.setVisibility(0);
                                messageViewHolder.getChatAlertImage().setOnClickListener(new View.OnClickListener(this, chatMessage){
                                    final /* synthetic */ MessageViewHolder this$0;
                                    final /* synthetic */ ChatMessage $message;
                                    {
                                        this.this$0 = messageViewHolder;
                                        this.$message = chatMessage;
                                    }

                                    public final void onClick(View view) {
                                        this.this$0.getAlertClickHandle().invoke((Object)this.$message);
                                    }
                                });
                            }
                        } else {
                            MessageViewHolder messageViewHolder = this;
                            View view = messageViewHolder.itemView;
                            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                            view.setAlpha(0.7f);
                            messageViewHolder.getChatAlertImage().setVisibility(8);
                            View view3 = messageViewHolder.getSendingFailedText();
                            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"sendingFailedText");
                            view3.setVisibility(8);
                        }
                        if (!EmojiUtil.INSTANCE.isEmojiOnly(chatMessage.getText())) break block16;
                        n2 = EmojiUtil.INSTANCE.getEmojiCount(chatMessage.getText());
                        float f = n2 == 1 ? 60.0f : (n2 <= 3 ? 30.0f : 14.0f);
                        MessageViewHolder messageViewHolder = this;
                        messageViewHolder.getChatMessageContent().setTextSize(1, f);
                        View view = messageViewHolder.getChatMessageContainer();
                        Drawable drawable2 = n2 <= 3 ? null : this.defaultBackground;
                        view.setBackground(drawable2);
                        int n3 = n2 <= 3 ? 0 : ExtensionsKt.getDp(16.0f);
                        if (n2 <= 3) {
                            View view4 = this.getChatMessageContainer();
                            n2 = view4.getPaddingTop();
                            int n4 = view4.getPaddingBottom();
                            view4.setPadding(n3, n2, n3, n4);
                        }
                        break block17;
                    }
                    View view = this.getChatMessageContainer();
                    view.setBackground(this.defaultBackground);
                    int n = ExtensionsKt.getDp(16.0f);
                    int n5 = view.getPaddingTop();
                    int n6 = ExtensionsKt.getDp(16.0f);
                    int n7 = view.getPaddingBottom();
                    view.setPadding(n, n5, n6, n7);
                    ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                    if (layoutParams == null) break block18;
                    ConstraintLayout.LayoutParams layoutParams2 = (ConstraintLayout.LayoutParams)layoutParams;
                    View view5 = this.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"itemView");
                    Context context = view5.getContext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"itemView.context");
                    int n8 = (int)context.getResources().getDimension(R.dimen.slr_chat_message_margin);
                    layoutParams2.setMargins(0, n8, 0, n8);
                    view.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
                    this.getChatMessageContent().setTextSize(2, 14.0f);
                }
                this.getChatMessageContent().setText((CharSequence)chatMessage.getText());
                return;
            }
            throw new TypeCastException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }

        @NotNull
        public final Function1<ChatMessage, Unit> getAlertClickHandle() {
            return this.alertClickHandle;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageSenderViewHolder;", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageViewHolder;", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;", "itemView", "Landroid/view/View;", "alertClickHandle", "Lkotlin/Function1;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "", "(Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;Landroid/view/View;Lkotlin/jvm/functions/Function1;)V", "sdk_originalVoximplantRelease"})
    public final class MessageSenderViewHolder
    extends MessageViewHolder {
        public MessageSenderViewHolder(@NotNull View view, Function1<? super ChatMessage, Unit> function1) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            Intrinsics.checkParameterIsNotNull(function1, (String)"alertClickHandle");
            super(view, function1);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageReceiverViewHolder;", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageViewHolder;", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;", "itemView", "Landroid/view/View;", "isGroup", "", "alertClickHandle", "Lkotlin/Function1;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "", "(Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;Landroid/view/View;ZLkotlin/jvm/functions/Function1;)V", "bind", "message", "sdk_originalVoximplantRelease"})
    public final class MessageReceiverViewHolder
    extends MessageViewHolder {
        private final boolean isGroup;

        public MessageReceiverViewHolder(View view, @NotNull boolean bl, Function1<? super ChatMessage, Unit> function1) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            Intrinsics.checkParameterIsNotNull(function1, (String)"alertClickHandle");
            super(view, function1);
            this.isGroup = bl;
        }

        @Override
        public void bind(@NotNull ChatMessage object) {
            MessageReceiverViewHolder messageReceiverViewHolder = this;
            ChatMessage chatMessage = object;
            Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"message");
            super.bind(chatMessage);
            TinodeContact tinodeContact = ((ChatMessage)object).getSender();
            View view = messageReceiverViewHolder.itemView;
            if (messageReceiverViewHolder.isGroup && tinodeContact != null) {
                Object object2 = this.getPreviousMessage();
                object2 = object2 != null ? ((ChatMessage)object2).getSenderUserId() : null;
                boolean bl = Intrinsics.areEqual((Object)object2, (Object)((ChatMessage)object).getSenderUserId());
                object2 = this.getNextMessage();
                if (!Intrinsics.areEqual((Object)(object2 != null ? ((ChatMessage)object2).getSenderUserId() : null), (Object)((ChatMessage)object).getSenderUserId())) {
                    View view2 = view;
                    ImageView imageView = (ImageView)view2.findViewById(R.id.chatMessageAuthorAvatar);
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"chatMessageAuthorAvatar");
                    ProfileExtensionsKt.loadContactAvatar$default(imageView, tinodeContact, null, 2, null);
                    ImageView imageView2 = (ImageView)view2.findViewById(R.id.chatMessageAuthorAvatar);
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView2, (String)"chatMessageAuthorAvatar");
                    ExtensionsKt.visible((View)imageView2);
                } else {
                    ImageView imageView = (ImageView)view.findViewById(R.id.chatMessageAuthorAvatar);
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"chatMessageAuthorAvatar");
                    ExtensionsKt.invisible((View)imageView);
                }
                if (!bl) {
                    View view3 = view;
                    TextView textView = (TextView)view3.findViewById(R.id.chatMessageAuthorName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"chatMessageAuthorName");
                    textView.setText((CharSequence)tinodeContact.getChatName());
                    TextView textView2 = (TextView)view3.findViewById(R.id.chatMessageAuthorName);
                    object = tinodeContact.getChatName();
                    int n = object != null ? AvatarUtil.INSTANCE.getColor((String)object) : -1;
                    textView2.setTextColor(n);
                    TextView textView3 = (TextView)view.findViewById(R.id.chatMessageAuthorName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)textView3, (String)"chatMessageAuthorName");
                    ExtensionsKt.visible((View)textView3);
                } else {
                    TextView textView = (TextView)view.findViewById(R.id.chatMessageAuthorName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"chatMessageAuthorName");
                    ExtensionsKt.gone((View)textView);
                }
            } else {
                View view4 = view;
                ImageView imageView = (ImageView)view4.findViewById(R.id.chatMessageAuthorAvatar);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"chatMessageAuthorAvatar");
                ExtensionsKt.gone((View)imageView);
                TextView textView = (TextView)view4.findViewById(R.id.chatMessageAuthorName);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"chatMessageAuthorName");
                ExtensionsKt.gone((View)textView);
            }
        }
    }
}

