/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main;

import android.content.Context;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.streamlayer.common.data.tinode.TinodeService;
import io.streamlayer.common.mvvm.BaseViewModel;
import io.streamlayer.common.mvvm.basemodels.BaseError;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.mvvm.basemodels.Status;
import io.streamlayer.common.network.NetworkConnectionLiveData;
import io.streamlayer.common.scheduler.SchedulerProvider;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.common.tooltips.ViewTooltipSession;
import io.streamlayer.common.tooltips.ViewTooltipType;
import io.streamlayer.sdk.StreamLayerSettings;
import io.streamlayer.sdk.main.StreamLayerViewModel;
import io.streamlayer.sdk.main.StreamLayerViewModel$WhenMappings;
import io.streamlayer.sdk.main.ViewTooltipState;
import io.streamlayer.sdk.model.advertising.AdvertisingData;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.model.sdksettings.CommonKt;
import io.streamlayer.sdk.model.sdksettings.OrganizationSettings;
import io.streamlayer.sdk.model.sdksettings.SdkOverlay;
import io.streamlayer.sdk.model.sdksettings.SdkOverlaySettings;
import io.streamlayer.sdk.model.sdksettings.SdkOverlayType;
import io.streamlayer.sdk.model.sdksettings.StreamData;
import io.streamlayer.sdk.model.sdksettings.TwitterOverlaySettings;
import io.streamlayer.sdk.repository.advertising.AdvertisingRepo;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.repository.auth.AuthRepo;
import io.streamlayer.sdk.repository.customsettings.CustomSettingsRepo;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import io.streamlayer.sdk.repository.sdksettings.SdkSettingsRepo;
import io.streamlayer.utils.RingtonePlayer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\r*\u0001'\b\u0000\u0018\u00002\u00020\u0001Bg\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u001c\u0010R\u001a\b\u0012\u0004\u0012\u00020S0\"2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020S0\"H\u0002J\b\u0010U\u001a\u00020VH\u0002J\u0006\u0010W\u001a\u00020VJ\u000e\u0010X\u001a\u00020V2\u0006\u0010Y\u001a\u00020#J\b\u0010Z\u001a\u00020VH\u0002J\b\u0010[\u001a\u00020VH\u0002J\u000e\u0010D\u001a\u00020V2\u0006\u0010\\\u001a\u00020]J\b\u0010^\u001a\u00020VH\u0002J\b\u0010_\u001a\u00020VH\u0002J\b\u0010`\u001a\u00020VH\u0002J\b\u0010a\u001a\u00020VH\u0014J\u0006\u0010b\u001a\u00020VJ\u000e\u0010c\u001a\u00020V2\u0006\u0010d\u001a\u000205J\b\u0010e\u001a\u00020VH\u0002J\u0018\u0010f\u001a\u00020V2\u0006\u0010g\u001a\u0002012\u0006\u0010h\u001a\u000203H\u0002J\u000e\u0010i\u001a\u00020V2\u0006\u0010g\u001a\u000201R\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u00104\u001a\b\u0012\u0004\u0012\u0002050,\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010.R#\u00107\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0\u001d0,\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010.R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010>\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u001d0,\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u0004\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010B\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020C0\u001d0,\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010.R\u0010\u0010E\u001a\u0004\u0018\u00010FX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u0004\u0018\u00010FX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010H\u001a\u0012\u0012\u0004\u0012\u0002010Ij\b\u0012\u0004\u0012\u000201`JX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010K\u001a\b\u0012\u0004\u0012\u00020L0,\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010.R\u0017\u0010N\u001a\b\u0012\u0004\u0012\u0002050,\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010.R\u0017\u0010P\u001a\b\u0012\u0004\u0012\u00020*0,\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010.R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lio/streamlayer/sdk/main/StreamLayerViewModel;", "Lio/streamlayer/common/mvvm/BaseViewModel;", "sdkSettingsRepo", "Lio/streamlayer/sdk/repository/sdksettings/SdkSettingsRepo;", "notificationsRepo", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "advertisingRepo", "Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;", "authRepo", "Lio/streamlayer/sdk/repository/auth/AuthRepo;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "tinode", "Lio/streamlayer/common/data/tinode/TinodeService;", "viewTooltipSession", "Lio/streamlayer/common/tooltips/ViewTooltipSession;", "ringtonePlayer", "Lio/streamlayer/utils/RingtonePlayer;", "schedulers", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "analyticsRepo", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "customRepo", "Lio/streamlayer/sdk/repository/customsettings/CustomSettingsRepo;", "context", "Landroid/content/Context;", "(Lio/streamlayer/sdk/repository/sdksettings/SdkSettingsRepo;Lio/streamlayer/sdk/repository/notifications/NotificationRepo;Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;Lio/streamlayer/sdk/repository/auth/AuthRepo;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/common/data/tinode/TinodeService;Lio/streamlayer/common/tooltips/ViewTooltipSession;Lio/streamlayer/utils/RingtonePlayer;Lio/streamlayer/common/scheduler/SchedulerProvider;Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;Lio/streamlayer/sdk/repository/customsettings/CustomSettingsRepo;Landroid/content/Context;)V", "_advertisingData", "Landroidx/lifecycle/MutableLiveData;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "Lio/streamlayer/sdk/model/advertising/AdvertisingData;", "_networkConnectionLiveData", "Lio/streamlayer/common/network/NetworkConnectionLiveData;", "_notificationsData", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "_sdkOverlaysList", "Lio/streamlayer/sdk/model/sdksettings/OrganizationSettings;", "_streamData", "io/streamlayer/sdk/main/StreamLayerViewModel$_streamData$1", "Lio/streamlayer/sdk/main/StreamLayerViewModel$_streamData$1;", "_viewTooltipData", "Lio/streamlayer/sdk/main/ViewTooltipState;", "advertisingData", "Landroidx/lifecycle/LiveData;", "getAdvertisingData", "()Landroidx/lifecycle/LiveData;", "chainOfTooltips", "", "Lio/streamlayer/common/tooltips/ViewTooltipType;", "lastShownTooltipClosedAt", "", "networkConnectionLiveData", "", "getNetworkConnectionLiveData", "notificationsData", "getNotificationsData", "overlayOpenedAt", "getOverlayOpenedAt", "()J", "setOverlayOpenedAt", "(J)V", "sdkOverlaysList", "getSdkOverlaysList", "sessionHeartbeatJob", "Lkotlinx/coroutines/Job;", "streamData", "Lio/streamlayer/sdk/model/sdksettings/StreamData;", "getStreamData", "streamDataDisposable", "Lio/reactivex/disposables/Disposable;", "tooltipTimerDisposable", "tooltipsOrder", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "unreadMessagesCount", "", "getUnreadMessagesCount", "userLoggedIn", "getUserLoggedIn", "viewTooltipData", "getViewTooltipData", "addCustomOverlays", "Lio/streamlayer/sdk/model/sdksettings/SdkOverlay;", "list", "checkFirebaseTokenUpdated", "", "dismissAllNotifications", "dismissNotification", "notification", "getNextTooltip", "getNotifications", "streamId", "", "loadAdvertisingData", "loadChainOfTooltips", "loadSdkOverlays", "onCleared", "overlayWasClosed", "setOnlineStatus", "online", "startAnalyticsSession", "startTooltipTimer", "type", "delay", "tooltipWasShown", "sdk_originalVoximplantRelease"})
public final class StreamLayerViewModel
extends BaseViewModel {
    private final ArrayList<ViewTooltipType> tooltipsOrder;
    private final NetworkConnectionLiveData _networkConnectionLiveData;
    @NotNull
    private final LiveData<Boolean> networkConnectionLiveData;
    private final MutableLiveData<ResourceState<OrganizationSettings>> _sdkOverlaysList;
    @NotNull
    private final LiveData<ResourceState<OrganizationSettings>> sdkOverlaysList;
    @NotNull
    private final LiveData<Boolean> userLoggedIn;
    @NotNull
    private final LiveData<Integer> unreadMessagesCount;
    private final MutableLiveData<ResourceState<AdvertisingData>> _advertisingData;
    @NotNull
    private final LiveData<ResourceState<AdvertisingData>> advertisingData;
    private final _streamData.1 _streamData;
    @NotNull
    private final LiveData<ResourceState<StreamData>> streamData;
    private final MutableLiveData<ResourceState<List<Notification>>> _notificationsData;
    @NotNull
    private final LiveData<ResourceState<List<Notification>>> notificationsData;
    private final MutableLiveData<ViewTooltipState> _viewTooltipData;
    @NotNull
    private final LiveData<ViewTooltipState> viewTooltipData;
    private List<ViewTooltipType> chainOfTooltips;
    private long lastShownTooltipClosedAt;
    private long overlayOpenedAt;
    private Job sessionHeartbeatJob;
    private Disposable tooltipTimerDisposable;
    private Disposable streamDataDisposable;
    private final SdkSettingsRepo sdkSettingsRepo;
    private final NotificationRepo notificationsRepo;
    private final AdvertisingRepo advertisingRepo;
    private final AuthRepo authRepo;
    private final SessionPrefImpl session;
    private final TinodeService tinode;
    private final ViewTooltipSession viewTooltipSession;
    private final RingtonePlayer ringtonePlayer;
    private final SchedulerProvider schedulers;
    private final AnalyticsRepo analyticsRepo;
    private final CustomSettingsRepo customRepo;

    private final void loadSdkOverlays() {
        Function0<Observable<ResourceState<? extends OrganizationSettings>>> function0;
        StreamLayerViewModel streamLayerViewModel = this;
        MutableLiveData<ResourceState<OrganizationSettings>> mutableLiveData = streamLayerViewModel._sdkOverlaysList;
        Function0<Observable<ResourceState<? extends OrganizationSettings>>> function02 = function0;
        function0 = new Function0<Observable<ResourceState<? extends OrganizationSettings>>>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel;
                super(0);
            }

            public final Observable<ResourceState<OrganizationSettings>> invoke() {
                Observable observable = StreamLayerViewModel.access$getSdkSettingsRepo$p(this.this$0).getOrganizationSettings().map(new Function<T, R>(this){
                    final /* synthetic */ loadSdkOverlays.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final ResourceState<OrganizationSettings> apply(@NotNull ResourceState<OrganizationSettings> object) {
                        Object object2;
                        OrganizationSettings organizationSettings;
                        ResourceState<OrganizationSettings> resourceState = object;
                        Intrinsics.checkParameterIsNotNull(resourceState, (String)"it");
                        OrganizationSettings organizationSettings2 = resourceState.getData();
                        if (organizationSettings2 != null) {
                            OrganizationSettings organizationSettings3;
                            organizationSettings = organizationSettings3;
                            object2 = StreamLayerViewModel.access$addCustomOverlays(object2.this$0.this$0, organizationSettings2.getOverlays());
                            organizationSettings3 = new OrganizationSettings((List<SdkOverlay>)object2, organizationSettings2.getButtonIcon());
                        } else {
                            organizationSettings = null;
                        }
                        ResourceState<OrganizationSettings> resourceState2 = object;
                        object2 = resourceState2.getStatus();
                        object = resourceState2.getError();
                        return new ResourceState<OrganizationSettings>((Status)((Object)object2), organizationSettings, (BaseError)object);
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sdkSettingsRepo.getOrgan\u2026.error)\n                }");
                return observable;
            }
        };
        BaseViewModel.observableCall$default(streamLayerViewModel, mutableLiveData, (Function0)function02, null, null, null, 28, null);
    }

    private final List<SdkOverlay> addCustomOverlays(List<SdkOverlay> arrayList) {
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayList arrayList4;
        StreamLayerViewModel streamLayerViewModel = arrayList4;
        arrayList4 = arrayList3;
        arrayList4();
        arrayList3.addAll(CollectionsKt.sortedWith(CommonKt.withProfileItem(arrayList), new Comparator<T>(){

            public final int compare(T t, T t2) {
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(((SdkOverlay)t).getPosition()), (Comparable)Integer.valueOf(((SdkOverlay)t2).getPosition()));
            }
        }));
        arrayList = arrayList2;
        arrayList2 = new ArrayList();
        for (Object t : streamLayerViewModel.customRepo.getCustomOverlays()) {
            Object object = ((SdkOverlay)t).getSettings();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if ((object = ((SdkOverlaySettings)object).getParams()) == null) {
                Intrinsics.throwNpe();
            }
            if (!((StreamLayerSettings.CustomOverlay)object).getOnBottomMenu()) continue;
            arrayList.add(t);
        }
        ArrayList arrayList5 = arrayList4;
        arrayList5.addAll(CollectionsKt.sortedWith(arrayList, new Comparator<T>(){

            public final int compare(T t, T t2) {
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(((SdkOverlay)t).getPosition()), (Comparable)Integer.valueOf(((SdkOverlay)t2).getPosition()));
            }
        }));
        return arrayList5;
    }

    private final void loadAdvertisingData() {
        Function0<Observable<ResourceState<? extends AdvertisingData>>> function0;
        StreamLayerViewModel streamLayerViewModel = this;
        MutableLiveData<ResourceState<AdvertisingData>> mutableLiveData = streamLayerViewModel._advertisingData;
        Function0<Observable<ResourceState<? extends AdvertisingData>>> function02 = function0;
        function0 = new Function0<Observable<ResourceState<? extends AdvertisingData>>>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel;
                super(0);
            }

            @NotNull
            public final Observable<ResourceState<AdvertisingData>> invoke() {
                return StreamLayerViewModel.access$getAdvertisingRepo$p(this.this$0).getAdvertisingData();
            }
        };
        BaseViewModel.observableCall$default(streamLayerViewModel, mutableLiveData, (Function0)function02, null, null, null, 28, null);
    }

    private final void checkFirebaseTokenUpdated() {
        if (this.session.isLoggedIn() && this.session.isFirebaseTokenChanged()) {
            Function0<Observable<ResourceState<? extends Boolean>>> function0;
            Function0<Observable<ResourceState<? extends Boolean>>> function02 = function0;
            function0 = new Function0<Observable<ResourceState<? extends Boolean>>>(this){
                final /* synthetic */ StreamLayerViewModel this$0;
                {
                    this.this$0 = streamLayerViewModel;
                    super(0);
                }

                public final Observable<ResourceState<Boolean>> invoke() {
                    return StreamLayerViewModel.access$getAuthRepo$p(this.this$0).uploadFirebaseToken(StreamLayerViewModel.access$getSession$p(this.this$0).getFirebaseToken()).map(new Function<T, R>(this){
                        final /* synthetic */ checkFirebaseTokenUpdated.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        @NotNull
                        public final ResourceState<Boolean> apply(@NotNull ResourceState<Boolean> resourceState) {
                            ResourceState<Boolean> resourceState2 = resourceState;
                            Intrinsics.checkParameterIsNotNull(resourceState2, (String)"it");
                            if (Intrinsics.areEqual((Object)resourceState2.getData(), (Object)Boolean.TRUE)) {
                                StreamLayerViewModel.access$getSession$p(this.this$0.this$0).setFirebaseTokenChanged(false);
                            }
                            return resourceState;
                        }
                    });
                }
            };
            BaseViewModel.observableCall$default(this, (Function0)function02, null, null, null, 14, null);
        }
    }

    private final void getNotifications() {
        Function0<Observable<ResourceState<? extends List<? extends Notification>>>> function0;
        StreamLayerViewModel streamLayerViewModel = this;
        MutableLiveData<ResourceState<List<Notification>>> mutableLiveData = streamLayerViewModel._notificationsData;
        Function0<Observable<ResourceState<? extends List<? extends Notification>>>> function02 = function0;
        function0 = new Function0<Observable<ResourceState<? extends List<? extends Notification>>>>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel;
                super(0);
            }

            public final Observable<ResourceState<List<Notification>>> invoke() {
                Observable observable = StreamLayerViewModel.access$getNotificationsRepo$p(this.this$0).getNotifications().doOnNext(new Consumer<ResourceState<? extends List<? extends Notification>>>(this){
                    final /* synthetic */ getNotifications.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void accept(ResourceState<? extends List<Notification>> iterator) {
                        if ((iterator = ((ResourceState)((Object)iterator)).getData()) != null) {
                            iterator = iterator.iterator();
                            while (iterator.hasNext()) {
                                Long l;
                                Notification notification = (Notification)iterator.next();
                                if (notification.getType() != NotificationType.Custom || (l = notification.getId()) == null) continue;
                                long l2 = l;
                                notification.setCustomBuilder(StreamLayerViewModel.access$getCustomRepo$p(this.this$0.this$0).notificationBuilderById(l2));
                            }
                        }
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"notificationsRepo.getNot\u2026  }\n                    }");
                return observable;
            }
        };
        BaseViewModel.observableCall$default(streamLayerViewModel, mutableLiveData, (Function0)function02, null, null, null, 28, null);
    }

    private final void loadChainOfTooltips() {
        this.getCompositeDisposable().add(Observable.fromIterable(this.tooltipsOrder).filter(new Predicate<ViewTooltipType>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel;
            }

            public final boolean test(@NotNull ViewTooltipType viewTooltipType) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)viewTooltipType), (String)"it");
                return StreamLayerViewModel.access$getViewTooltipSession$p(this.this$0).canShow(viewTooltipType);
            }
        }).toList().subscribeOn(this.schedulers.io()).observeOn(this.schedulers.ui()).subscribe(new Consumer<List<ViewTooltipType>>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel;
            }

            public final void accept(List<ViewTooltipType> list) {
                loadChainOfTooltips.2 v0 = this;
                StreamLayerViewModel.access$getChainOfTooltips$p(v0.this$0).clear();
                List list2 = StreamLayerViewModel.access$getChainOfTooltips$p(v0.this$0);
                List<ViewTooltipType> list3 = list;
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"it");
                list2.addAll(list3);
                StreamLayerViewModel.access$getNextTooltip(v0.this$0);
            }
        }));
    }

    private final void getNextTooltip() {
        Function1<ViewTooltipType, Unit> function1;
        Function1<ViewTooltipType, Unit> function12 = function1;
        function1 = new Function1<ViewTooltipType, Unit>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel;
                super(1);
            }

            public final void invoke(@Nullable ViewTooltipType viewTooltipType) {
                Disposable disposable = StreamLayerViewModel.access$getTooltipTimerDisposable$p(this.this$0);
                if (disposable != null) {
                    disposable.dispose();
                }
                StreamLayerViewModel.access$get_viewTooltipData$p(this.this$0).setValue((Object)new ViewTooltipState(viewTooltipType));
            }
        };
        if (this.chainOfTooltips.isEmpty()) {
            function12.invoke(null);
            return;
        }
        ViewTooltipType viewTooltipType = this.chainOfTooltips.get(0);
        switch (StreamLayerViewModel$WhenMappings.$EnumSwitchMapping$0[viewTooltipType.ordinal()]) {
            default: {
                break;
            }
            case 4: {
                function12.invoke((Object)viewTooltipType);
                break;
            }
            case 3: {
                long l = System.currentTimeMillis() - this.lastShownTooltipClosedAt - 5000L;
                if (l >= 0L) {
                    function12.invoke((Object)viewTooltipType);
                    break;
                }
                function12.invoke(null);
                l = Math.abs(l);
                l = Math.min(5000L, l);
                this.startTooltipTimer(viewTooltipType, l);
                break;
            }
            case 2: {
                long l = this.overlayOpenedAt;
                long l2 = System.currentTimeMillis() - l - 5000L;
                if (l2 >= 0L && l != 0L) {
                    function12.invoke((Object)viewTooltipType);
                    break;
                }
                function12.invoke(null);
                l = Math.abs(l2);
                l = Math.min(5000L, l);
                this.startTooltipTimer(viewTooltipType, l);
                break;
            }
            case 1: {
                function12.invoke((Object)viewTooltipType);
            }
        }
    }

    private final void startTooltipTimer(ViewTooltipType viewTooltipType, long l) {
        Disposable disposable = this.tooltipTimerDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this.tooltipTimerDisposable = Observable.just((Object)((Object)viewTooltipType)).delay(l, TimeUnit.MILLISECONDS).subscribeOn(this.schedulers.io()).observeOn(this.schedulers.ui()).doOnSubscribe(new Consumer<Disposable>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel;
            }

            public final void accept(Disposable disposable) {
                startTooltipTimer.1 v0 = this;
                StreamLayerViewModel.access$setTooltipTimerDisposable$p(v0.this$0, disposable);
                StreamLayerViewModel.access$getCompositeDisposable$p(v0.this$0).add(disposable);
            }
        }).subscribe(new Consumer<ViewTooltipType>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel;
            }

            public final void accept(ViewTooltipType viewTooltipType) {
                StreamLayerViewModel.access$getNextTooltip(this.this$0);
            }
        });
    }

    private final void startAnalyticsSession() {
        if (this.sessionHeartbeatJob == null) {
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
            function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ StreamLayerViewModel this$0;
                {
                    this.this$0 = streamLayerViewModel;
                    super(2, continuation);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    int n = this.label;
                    if (n != 0) {
                        if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        Object object3 = object;
                        object = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)object3);
                    } else {
                        ResultKt.throwOnFailure((Object)object);
                        object = this.p$;
                    }
                    while (CoroutineScopeKt.isActive((CoroutineScope)object)) {
                        ResourceState resourceState = (ResourceState)StreamLayerViewModel.access$get_streamData$p(this.this$0).getValue();
                        if ((resourceState != null ? (StreamData)resourceState.getData() : null) != null) {
                            StreamLayerViewModel.access$getAnalyticsRepo$p(this.this$0).triggerSessionHeartbeat();
                        }
                        startAnalyticsSession.1 v1 = this;
                        v1.L$0 = object;
                        v1.label = 1;
                        if (DelayKt.delay((long)60000L, (Continuation)this) != object2) continue;
                        return object2;
                    }
                    return Unit.INSTANCE;
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                    Intrinsics.checkParameterIsNotNull(continuation, (String)"completion");
                    new /* invalid duplicate definition of identical inner class */.p$ = (CoroutineScope)object;
                    return new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            };
            this.sessionHeartbeatJob = BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)function22, (int)3, null);
        }
    }

    @Inject
    public StreamLayerViewModel(@NotNull SdkSettingsRepo sdkSettingsRepo, @NotNull NotificationRepo notificationRepo, @NotNull AdvertisingRepo advertisingRepo, @NotNull AuthRepo authRepo, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull TinodeService tinodeService, @NotNull ViewTooltipSession viewTooltipSession, @NotNull RingtonePlayer ringtonePlayer, @NotNull SchedulerProvider schedulerProvider, @NotNull AnalyticsRepo analyticsRepo, @NotNull CustomSettingsRepo customSettingsRepo, @NotNull Context context) {
        MediatorLiveData<ResourceState<? extends StreamData>> mediatorLiveData;
        StreamLayerViewModel streamLayerViewModel = this;
        Intrinsics.checkParameterIsNotNull((Object)sdkSettingsRepo, (String)"sdkSettingsRepo");
        Intrinsics.checkParameterIsNotNull((Object)notificationRepo, (String)"notificationsRepo");
        Intrinsics.checkParameterIsNotNull((Object)advertisingRepo, (String)"advertisingRepo");
        Intrinsics.checkParameterIsNotNull((Object)authRepo, (String)"authRepo");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)tinodeService, (String)"tinode");
        Intrinsics.checkParameterIsNotNull((Object)viewTooltipSession, (String)"viewTooltipSession");
        Intrinsics.checkParameterIsNotNull((Object)ringtonePlayer, (String)"ringtonePlayer");
        Intrinsics.checkParameterIsNotNull((Object)schedulerProvider, (String)"schedulers");
        Intrinsics.checkParameterIsNotNull((Object)analyticsRepo, (String)"analyticsRepo");
        Intrinsics.checkParameterIsNotNull((Object)customSettingsRepo, (String)"customRepo");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(schedulerProvider);
        this.sdkSettingsRepo = sdkSettingsRepo;
        this.notificationsRepo = notificationRepo;
        this.advertisingRepo = advertisingRepo;
        this.authRepo = authRepo;
        this.session = sessionPrefImpl;
        this.tinode = tinodeService;
        this.viewTooltipSession = viewTooltipSession;
        this.ringtonePlayer = ringtonePlayer;
        this.schedulers = schedulerProvider;
        this.analyticsRepo = analyticsRepo;
        streamLayerViewModel.customRepo = customSettingsRepo;
        streamLayerViewModel.tooltipsOrder = CollectionsKt.arrayListOf((Object[])new ViewTooltipType[]{ViewTooltipType.MAIN_MENU, ViewTooltipType.OVERLAY_DISMISS, ViewTooltipType.WHOS_WATCHING, ViewTooltipType.NOTIFICATION});
        this._networkConnectionLiveData = new NetworkConnectionLiveData(context);
        LiveData liveData = Transformations.distinctUntilChanged((LiveData)this._networkConnectionLiveData);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        streamLayerViewModel.networkConnectionLiveData = liveData;
        this._sdkOverlaysList = new MutableLiveData();
        LiveData liveData2 = Transformations.distinctUntilChanged((LiveData)this._sdkOverlaysList);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData2, (String)"Transformations.distinctUntilChanged(this)");
        streamLayerViewModel.sdkOverlaysList = liveData2;
        streamLayerViewModel.userLoggedIn = streamLayerViewModel.session.getUserLoggedInListener();
        streamLayerViewModel.unreadMessagesCount = streamLayerViewModel.session.getTotalUnreadMessagesCountListener();
        this._advertisingData = new MutableLiveData();
        LiveData liveData3 = Transformations.distinctUntilChanged((LiveData)this._advertisingData);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData3, (String)"Transformations.distinctUntilChanged(this)");
        streamLayerViewModel.advertisingData = liveData3;
        sdkSettingsRepo = mediatorLiveData;
        streamLayerViewModel._streamData = new MediatorLiveData<ResourceState<? extends StreamData>>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                Observer<String> observer;
                this.this$0 = streamLayerViewModel;
                LiveData liveData = Transformations.distinctUntilChanged(StreamLayerViewModel.access$getSession$p(streamLayerViewModel).getCurrentEventIdListener());
                Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
                streamLayerViewModel = observer;
                observer = new Observer<String>(this){
                    final /* synthetic */ _streamData.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void onChanged(@Nullable String string2) {
                        if (!(string2 == null || StringsKt.isBlank((CharSequence)string2))) {
                            _streamData.1 v0 = this;
                            v0.this$0.this$0.getStreamData(string2);
                            StreamLayerViewModel.access$startAnalyticsSession(v0.this$0.this$0);
                            StreamLayerViewModel.access$getAnalyticsRepo$p(v0.this$0.this$0).triggerLaunchButtonInitEvent();
                        }
                    }
                };
                this.addSource(liveData, (Observer)streamLayerViewModel);
            }
        };
        streamLayerViewModel.streamData = sdkSettingsRepo;
        this._notificationsData = new MutableLiveData();
        LiveData liveData4 = Transformations.distinctUntilChanged((LiveData)this._notificationsData);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData4, (String)"Transformations.distinctUntilChanged(this)");
        streamLayerViewModel.notificationsData = liveData4;
        this._viewTooltipData = new MutableLiveData();
        LiveData liveData5 = Transformations.distinctUntilChanged((LiveData)this._viewTooltipData);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData5, (String)"Transformations.distinctUntilChanged(this)");
        streamLayerViewModel.viewTooltipData = liveData5;
        streamLayerViewModel.chainOfTooltips = new ArrayList<ViewTooltipType>();
        streamLayerViewModel.loadSdkOverlays();
        streamLayerViewModel.loadAdvertisingData();
        streamLayerViewModel.loadChainOfTooltips();
        streamLayerViewModel.getNotifications();
        streamLayerViewModel.checkFirebaseTokenUpdated();
    }

    public static final /* synthetic */ SdkSettingsRepo access$getSdkSettingsRepo$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.sdkSettingsRepo;
    }

    public static final /* synthetic */ List access$addCustomOverlays(StreamLayerViewModel streamLayerViewModel, List list) {
        return streamLayerViewModel.addCustomOverlays(list);
    }

    public static final /* synthetic */ AdvertisingRepo access$getAdvertisingRepo$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.advertisingRepo;
    }

    public static final /* synthetic */ AuthRepo access$getAuthRepo$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.authRepo;
    }

    public static final /* synthetic */ SessionPrefImpl access$getSession$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.session;
    }

    public static final /* synthetic */ NotificationRepo access$getNotificationsRepo$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.notificationsRepo;
    }

    public static final /* synthetic */ CustomSettingsRepo access$getCustomRepo$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.customRepo;
    }

    public static final /* synthetic */ ViewTooltipSession access$getViewTooltipSession$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.viewTooltipSession;
    }

    public static final /* synthetic */ List access$getChainOfTooltips$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.chainOfTooltips;
    }

    public static final /* synthetic */ void access$setChainOfTooltips$p(StreamLayerViewModel streamLayerViewModel, List list) {
        streamLayerViewModel.chainOfTooltips = list;
    }

    public static final /* synthetic */ void access$getNextTooltip(StreamLayerViewModel streamLayerViewModel) {
        streamLayerViewModel.getNextTooltip();
    }

    public static final /* synthetic */ Disposable access$getTooltipTimerDisposable$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.tooltipTimerDisposable;
    }

    public static final /* synthetic */ void access$setTooltipTimerDisposable$p(StreamLayerViewModel streamLayerViewModel, Disposable disposable) {
        streamLayerViewModel.tooltipTimerDisposable = disposable;
    }

    public static final /* synthetic */ MutableLiveData access$get_viewTooltipData$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel._viewTooltipData;
    }

    public static final /* synthetic */ CompositeDisposable access$getCompositeDisposable$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.getCompositeDisposable();
    }

    public static final /* synthetic */ TinodeService access$getTinode$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.tinode;
    }

    public static final /* synthetic */ Disposable access$getStreamDataDisposable$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.streamDataDisposable;
    }

    public static final /* synthetic */ void access$setStreamDataDisposable$p(StreamLayerViewModel streamLayerViewModel, Disposable disposable) {
        streamLayerViewModel.streamDataDisposable = disposable;
    }

    public static final /* synthetic */ _streamData.1 access$get_streamData$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel._streamData;
    }

    public static final /* synthetic */ AnalyticsRepo access$getAnalyticsRepo$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.analyticsRepo;
    }

    public static final /* synthetic */ void access$startAnalyticsSession(StreamLayerViewModel streamLayerViewModel) {
        streamLayerViewModel.startAnalyticsSession();
    }

    @NotNull
    public final LiveData<Boolean> getNetworkConnectionLiveData() {
        return this.networkConnectionLiveData;
    }

    @NotNull
    public final LiveData<ResourceState<OrganizationSettings>> getSdkOverlaysList() {
        return this.sdkOverlaysList;
    }

    @NotNull
    public final LiveData<Boolean> getUserLoggedIn() {
        return this.userLoggedIn;
    }

    @NotNull
    public final LiveData<Integer> getUnreadMessagesCount() {
        return this.unreadMessagesCount;
    }

    @NotNull
    public final LiveData<ResourceState<AdvertisingData>> getAdvertisingData() {
        return this.advertisingData;
    }

    @NotNull
    public final LiveData<ResourceState<StreamData>> getStreamData() {
        return this.streamData;
    }

    @NotNull
    public final LiveData<ResourceState<List<Notification>>> getNotificationsData() {
        return this.notificationsData;
    }

    @NotNull
    public final LiveData<ViewTooltipState> getViewTooltipData() {
        return this.viewTooltipData;
    }

    public final long getOverlayOpenedAt() {
        return this.overlayOpenedAt;
    }

    public final void setOverlayOpenedAt(long l) {
        this.overlayOpenedAt = l;
    }

    public final void dismissNotification(@NotNull Notification notification) {
        StreamLayerViewModel streamLayerViewModel = this;
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        BaseViewModel.completableCall$default(streamLayerViewModel, streamLayerViewModel._notificationsData, (Function0)new Function0<Completable>(this, notification){
            final /* synthetic */ StreamLayerViewModel this$0;
            final /* synthetic */ Notification $notification;
            {
                this.this$0 = streamLayerViewModel;
                this.$notification = notification;
                super(0);
            }

            @NotNull
            public final Completable invoke() {
                return StreamLayerViewModel.access$getNotificationsRepo$p(this.this$0).deleteNotification(this.$notification);
            }
        }, null, null, null, 28, null);
        if (ArraysKt.contains((Object[])new NotificationType[]{NotificationType.Call, NotificationType.GroupCall, NotificationType.GroupCallActive}, (Object)((Object)notification.getType()))) {
            this.ringtonePlayer.dismiss();
        }
    }

    public final void dismissAllNotifications() {
        StreamLayerViewModel streamLayerViewModel = this;
        streamLayerViewModel.notificationsRepo.deleteAllNotifications();
        streamLayerViewModel.ringtonePlayer.dismiss();
    }

    public final void overlayWasClosed() {
        if (this.chainOfTooltips.isEmpty() ^ true && this.chainOfTooltips.get(0) == ViewTooltipType.OVERLAY_DISMISS) {
            Disposable disposable = this.tooltipTimerDisposable;
            if (disposable != null) {
                disposable.dispose();
            }
            this.tooltipWasShown(ViewTooltipType.OVERLAY_DISMISS);
        }
    }

    public final void tooltipWasShown(@NotNull ViewTooltipType viewTooltipType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)viewTooltipType), (String)"type");
        if (this.chainOfTooltips.isEmpty()) {
            return;
        }
        if (viewTooltipType == this.chainOfTooltips.get(0)) {
            StreamLayerViewModel streamLayerViewModel = this;
            streamLayerViewModel.chainOfTooltips.remove(0);
            streamLayerViewModel.lastShownTooltipClosedAt = System.currentTimeMillis();
            streamLayerViewModel.viewTooltipSession.wasShown(viewTooltipType);
            streamLayerViewModel.getNextTooltip();
        }
    }

    public final void setOnlineStatus(boolean bl) {
        Function0<Observable<ResourceState<? extends Boolean>>> function0;
        Function0<Observable<ResourceState<? extends Boolean>>> function02 = function0;
        function0 = new Function0<Observable<ResourceState<? extends Boolean>>>(this, bl){
            final /* synthetic */ StreamLayerViewModel this$0;
            final /* synthetic */ boolean $online;
            {
                this.this$0 = streamLayerViewModel;
                this.$online = bl;
                super(0);
            }

            public final Observable<ResourceState<Boolean>> invoke() {
                return (this.$online ? StreamLayerViewModel.access$getTinode$p(this.this$0).triggerOnlineStatus() : StreamLayerViewModel.access$getTinode$p(this.this$0).triggerOfflineStatus()).doOnError((Consumer)setOnlineStatus.1.INSTANCE).map((Function)setOnlineStatus.2.INSTANCE);
            }
        };
        BaseViewModel.observableCall$default(this, (Function0)function02, null, null, null, 14, null);
    }

    public final void getStreamData(@NotNull String string2) {
        Function1<ResourceState<? extends StreamData>, Unit> function1;
        Function1<Disposable, Unit> function12;
        Function0<Observable<ResourceState<? extends StreamData>>> function0;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"streamId");
        Object object = this.streamDataDisposable;
        if (object != null) {
            object.dispose();
        }
        StreamLayerViewModel streamLayerViewModel = this;
        object = streamLayerViewModel._streamData;
        Function0<Observable<ResourceState<? extends StreamData>>> function02 = function0;
        function0 = new Function0<Observable<ResourceState<? extends StreamData>>>(this, string2){
            final /* synthetic */ StreamLayerViewModel this$0;
            final /* synthetic */ String $streamId;
            {
                this.this$0 = streamLayerViewModel;
                this.$streamId = string2;
                super(0);
            }

            @NotNull
            public final Observable<ResourceState<StreamData>> invoke() {
                return StreamLayerViewModel.access$getSdkSettingsRepo$p(this.this$0).getStreamInfo(this.$streamId);
            }
        };
        string2 = function12;
        function12 = new Function1<Disposable, Unit>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel;
                super(1);
            }

            public final void invoke(@NotNull Disposable disposable) {
                getStreamData.2 v0 = this;
                Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
                StreamLayerViewModel.access$setStreamDataDisposable$p(v0.this$0, disposable);
                StreamLayerViewModel.access$getCompositeDisposable$p(v0.this$0).add(disposable);
            }
        };
        Function1<ResourceState<? extends StreamData>, Unit> function13 = function1;
        function1 = new Function1<ResourceState<? extends StreamData>, Unit>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel;
                super(1);
            }

            public final void invoke(@NotNull ResourceState<StreamData> resourceState) {
                ResourceState<StreamData> resourceState2 = resourceState;
                Intrinsics.checkParameterIsNotNull(resourceState2, (String)"it");
                StreamData streamData = resourceState2.getData();
                if (streamData != null) {
                    SessionPrefImpl sessionPrefImpl;
                    block3: {
                        for (T t : resourceState.getData().getAttributes().getOverlays()) {
                            sessionPrefImpl = (SessionPrefImpl)t;
                            if (!(((SdkOverlay)t).getType() == SdkOverlayType.Twitter)) continue;
                            break block3;
                        }
                        sessionPrefImpl = null;
                    }
                    List<String> list = (SdkOverlay)((Object)sessionPrefImpl);
                    sessionPrefImpl = StreamLayerViewModel.access$getSession$p(this.this$0);
                    if (list == null || (list = ((SdkOverlay)((Object)list)).getSettings()) == null || (list = ((SdkOverlaySettings)((Object)list)).getTwitter()) == null || (list = ((TwitterOverlaySettings)((Object)list)).getAccounts()) == null) {
                        list = CollectionsKt.emptyList();
                    }
                    sessionPrefImpl.setTwitterAccounts(list);
                    streamData.getAttributes().setOverlays(StreamLayerViewModel.access$addCustomOverlays(this.this$0, streamData.getAttributes().getOverlays()));
                }
                StreamLayerViewModel.access$get_streamData$p(this.this$0).setValue(resourceState);
            }
        };
        BaseViewModel.observableCall$default(streamLayerViewModel, (MutableLiveData)object, (Function0)function02, (Function1)string2, (Function1)function13, null, 16, null);
    }

    @Override
    protected void onCleared() {
        StreamLayerViewModel streamLayerViewModel = this;
        streamLayerViewModel.notificationsRepo.deleteAllNotifications();
        streamLayerViewModel.setOnlineStatus(false);
        streamLayerViewModel.tinode.disconnect();
        streamLayerViewModel.ringtonePlayer.dismiss();
        Job job = streamLayerViewModel.sessionHeartbeatJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        super.onCleared();
    }
}

