/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.calls.call;

import android.content.Context;
import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.Transformations;
import com.voximplant.sdk.Voximplant;
import com.voximplant.sdk.call.CallException;
import com.voximplant.sdk.call.ICall;
import com.voximplant.sdk.call.ICallCompletionHandler;
import com.voximplant.sdk.call.ICallListener;
import com.voximplant.sdk.call.IEndpoint;
import com.voximplant.sdk.call.IEndpointListener;
import com.voximplant.sdk.call.IVideoStream;
import com.voximplant.sdk.hardware.AudioDevice;
import com.voximplant.sdk.hardware.IAudioDeviceEventsListener;
import com.voximplant.sdk.hardware.IAudioDeviceManager;
import com.voximplant.sdk.hardware.ICameraManager;
import com.voximplant.sdk.hardware.VideoQuality;
import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.streamlayer.common.data.voximplant.AuthError;
import io.streamlayer.common.data.voximplant.VoximplantCallManager;
import io.streamlayer.common.data.voximplant.VoximplantClientManager;
import io.streamlayer.common.mvvm.BaseViewModel;
import io.streamlayer.common.mvvm.basemodels.BaseError;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.scheduler.SchedulerProvider;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.calls.call.CallViewModel;
import io.streamlayer.sdk.calls.call.CallViewModel$toggleCamera$;
import io.streamlayer.sdk.calls.call.ParticipantStatusesLiveData;
import io.streamlayer.sdk.calls.call.video.model.CallController;
import io.streamlayer.sdk.model.analytics.CommonKind;
import io.streamlayer.sdk.model.auth.VoximplantUser;
import io.streamlayer.sdk.model.calls.CallConnectionStatus;
import io.streamlayer.sdk.model.calls.CallIdiom;
import io.streamlayer.sdk.model.calls.CallParticipantStatus;
import io.streamlayer.sdk.model.calls.ParticipantStatus;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.repository.call.CallRepo;
import io.streamlayer.sdk.repository.messaging.MessagingRepo;
import io.streamlayer.utils.RingtonePlayer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b*\u0001 \b\u0000\u0018\u00002\u00020\u00012\u00020\u0002BO\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010J\u001a\u00020K2\u0006\u0010C\u001a\u00020BJ\u0010\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u000209H\u0016J\b\u0010N\u001a\u00020KH\u0002J\u0016\u0010O\u001a\u00020K2\u0006\u0010C\u001a\u00020B2\u0006\u0010P\u001a\u00020QJ\b\u0010R\u001a\u00020KH\u0002J\b\u0010S\u001a\u00020KH\u0002J\b\u0010T\u001a\u00020KH\u0002J\b\u0010U\u001a\u00020KH\u0014J\b\u0010V\u001a\u00020KH\u0002J\b\u0010W\u001a\u00020KH\u0002J\u0010\u0010X\u001a\u00020K2\u0006\u0010C\u001a\u00020BH\u0002J\b\u0010Y\u001a\u00020KH\u0002J\u0006\u0010Z\u001a\u00020KJ\b\u0010[\u001a\u00020KH\u0016R\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u001b0\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0*\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010,R\u001d\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002040\u00180*\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010,R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00108\u001a\b\u0012\u0004\u0012\u0002090*\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010,R\u000e\u0010:\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010>\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020?0\u001b0\u00180*\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010,R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010C\u001a\u00020B2\u0006\u0010A\u001a\u00020B@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lio/streamlayer/sdk/calls/call/CallViewModel;", "Lio/streamlayer/common/mvvm/BaseViewModel;", "Lio/streamlayer/sdk/calls/call/video/model/CallController$Listener;", "context", "Landroid/content/Context;", "messagingRepo", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "callRepo", "Lio/streamlayer/sdk/repository/call/CallRepo;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "schedulers", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "ringtonePlayer", "Lio/streamlayer/utils/RingtonePlayer;", "voximplantClientManager", "Lio/streamlayer/common/data/voximplant/VoximplantClientManager;", "voxImplantCallManager", "Lio/streamlayer/common/data/voximplant/VoximplantCallManager;", "analyticsRepo", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "(Landroid/content/Context;Lio/streamlayer/sdk/repository/messaging/MessagingRepo;Lio/streamlayer/sdk/repository/call/CallRepo;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/common/scheduler/SchedulerProvider;Lio/streamlayer/utils/RingtonePlayer;Lio/streamlayer/common/data/voximplant/VoximplantClientManager;Lio/streamlayer/common/data/voximplant/VoximplantCallManager;Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;)V", "_call", "Landroidx/lifecycle/MutableLiveData;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "Lio/streamlayer/sdk/model/messaging/Chat;", "_callMessages", "", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "_callStartedAt", "", "_callState", "io/streamlayer/sdk/calls/call/CallViewModel$_callState$1", "Lio/streamlayer/sdk/calls/call/CallViewModel$_callState$1;", "_latestMessage", "_participantStatuses", "Lio/streamlayer/sdk/calls/call/ParticipantStatusesLiveData;", "_participants", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "activeCall", "Lcom/voximplant/sdk/call/ICall;", "call", "Landroidx/lifecycle/LiveData;", "getCall", "()Landroidx/lifecycle/LiveData;", "callControlVM", "Lio/streamlayer/sdk/calls/call/video/model/CallController;", "getCallControlVM", "()Lio/streamlayer/sdk/calls/call/video/model/CallController;", "callStartedAt", "getCallStartedAt", "callState", "Lio/streamlayer/sdk/model/calls/CallConnectionStatus;", "getCallState", "cameraManager", "Lcom/voximplant/sdk/hardware/ICameraManager;", "isCallActive", "", "isSendAudioEnabled", "isSendVideoEnabled", "mAudioDeviceManager", "Lcom/voximplant/sdk/hardware/IAudioDeviceManager;", "participantStatuses", "Lio/streamlayer/sdk/model/calls/CallParticipantStatus;", "getParticipantStatuses", "<set-?>", "", "topicId", "getTopicId", "()Ljava/lang/String;", "voxCallListener", "Lcom/voximplant/sdk/call/ICallListener;", "voxEndpointListener", "Lcom/voximplant/sdk/call/IEndpointListener;", "declineCall", "", "endCall", "needAnalytics", "getOldVoiceMessages", "init", "scope", "Lkotlinx/coroutines/CoroutineScope;", "observeParticipants", "observeVoiceCall", "observeVoiceMessages", "onCleared", "resetCall", "resetMicrophone", "startCall", "startRingingTimer", "toggleCamera", "toggleMicrophone", "sdk_originalVoximplantRelease"})
public final class CallViewModel
extends BaseViewModel
implements CallController.Listener {
    @NotNull
    private String topicId;
    private final MutableLiveData<Long> _callStartedAt;
    @NotNull
    private final LiveData<Long> callStartedAt;
    private final MutableLiveData<ResourceState<Chat>> _call;
    @NotNull
    private final LiveData<ResourceState<Chat>> call;
    private final MutableLiveData<List<ChatMessage>> _callMessages;
    private final MutableLiveData<ChatMessage> _latestMessage;
    @NotNull
    private final CallController callControlVM;
    private final ParticipantStatusesLiveData _participantStatuses;
    @NotNull
    private final LiveData<ResourceState<List<CallParticipantStatus>>> participantStatuses;
    private final _callState.1 _callState;
    @NotNull
    private final LiveData<ResourceState<CallConnectionStatus>> callState;
    private final MutableLiveData<ResourceState<List<TinodeContact>>> _participants;
    @NotNull
    private final LiveData<Boolean> isCallActive;
    private final IEndpointListener voxEndpointListener;
    private final ICallListener voxCallListener;
    private ICall activeCall;
    private boolean isSendVideoEnabled;
    private boolean isSendAudioEnabled;
    private final ICameraManager cameraManager;
    private final IAudioDeviceManager mAudioDeviceManager;
    private final Context context;
    private final MessagingRepo messagingRepo;
    private final CallRepo callRepo;
    private final SessionPrefImpl session;
    private final SchedulerProvider schedulers;
    private final RingtonePlayer ringtonePlayer;
    private final VoximplantClientManager voximplantClientManager;
    private final VoximplantCallManager voxImplantCallManager;
    private final AnalyticsRepo analyticsRepo;

    private final void startCall(String string2) {
        this.voximplantClientManager.reconnectIfNeeded((Function1<? super AuthError, Unit>)new Function1<AuthError, Unit>(this, string2){
            final /* synthetic */ CallViewModel this$0;
            final /* synthetic */ String $topicId;
            {
                this.this$0 = callViewModel;
                this.$topicId = string2;
                super(1);
            }

            public final void invoke(@Nullable AuthError authError) {
                if (authError == null) {
                    startCall.1 v0 = this;
                    BaseViewModel.observableCall$default(v0.this$0, (Function0)new Function0<Observable<ResourceState<? extends Boolean>>>(this){
                        final /* synthetic */ startCall.1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }

                        @NotNull
                        public final Observable<ResourceState<Boolean>> invoke() {
                            return CallRepo.DefaultImpls.sendCallIdiom$default(CallViewModel.access$getCallRepo$p(this.this$0.this$0), this.this$0.$topicId, CallIdiom.ADD_ME, null, null, 12, null);
                        }
                    }, null, null, null, 14, null);
                    CallViewModel callViewModel = v0.this$0;
                    CallViewModel.access$setActiveCall$p(callViewModel, CallViewModel.access$getVoxImplantCallManager$p(callViewModel).createCall(this.$topicId));
                    authError = CallViewModel.access$getActiveCall$p(v0.this$0);
                    if (authError != null) {
                        authError.addCallListener(CallViewModel.access$getVoxCallListener$p(this.this$0));
                        CallViewModel.access$setSendVideoEnabled$p(this.this$0, false);
                    }
                }
            }
        });
    }

    private final void startRingingTimer() {
        this.ringtonePlayer.ring();
        TimeUnit timeUnit = TimeUnit.SECONDS;
        Observable.timer((long)30L, (TimeUnit)timeUnit).subscribeOn(this.schedulers.io()).observeOn(this.schedulers.ui()).doOnSubscribe(new Consumer<Disposable>(this){
            final /* synthetic */ CallViewModel this$0;
            {
                this.this$0 = callViewModel;
            }

            public final void accept(Disposable disposable) {
                CallViewModel.access$getCompositeDisposable$p(this.this$0).add(disposable);
            }
        }).subscribe(new Consumer<Long>(this){
            final /* synthetic */ CallViewModel this$0;
            {
                this.this$0 = callViewModel;
            }

            public final void accept(Long l) {
                if (Intrinsics.areEqual((Object)((Boolean)this.this$0.isCallActive().getValue()), (Object)Boolean.FALSE)) {
                    startRingingTimer.2 v0 = this;
                    CallController.Listener.DefaultImpls.endCall$default(v0.this$0, false, 1, null);
                    CallViewModel.access$getRingtonePlayer$p(v0.this$0).dismiss();
                }
            }
        }, (Consumer)startRingingTimer.3.INSTANCE);
    }

    private final void observeParticipants() {
        Function1<ResourceState<? extends List<? extends TinodeContact>>, Unit> function1;
        Function0<Observable<ResourceState<? extends List<? extends TinodeContact>>>> function0;
        CallViewModel callViewModel = this;
        MutableLiveData<ResourceState<List<TinodeContact>>> mutableLiveData = callViewModel._participants;
        Function0<Observable<ResourceState<? extends List<? extends TinodeContact>>>> function02 = function0;
        function0 = new Function0<Observable<ResourceState<? extends List<? extends TinodeContact>>>>(this){
            final /* synthetic */ CallViewModel this$0;
            {
                this.this$0 = callViewModel;
                super(0);
            }

            public final Observable<ResourceState<List<TinodeContact>>> invoke() {
                Observable observable = CallViewModel.access$getMessagingRepo$p(this.this$0).getParticipants(this.this$0.getTopicId()).distinctUntilChanged();
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"messagingRepo.getPartici\u2026d).distinctUntilChanged()");
                return observable;
            }
        };
        Function1<ResourceState<? extends List<? extends TinodeContact>>, Unit> function12 = function1;
        function1 = new Function1<ResourceState<? extends List<? extends TinodeContact>>, Unit>(this){
            final /* synthetic */ CallViewModel this$0;
            {
                this.this$0 = callViewModel;
                super(1);
            }

            public final void invoke(@NotNull ResourceState<? extends List<TinodeContact>> resourceState) {
                observeParticipants.2 v0 = this;
                Intrinsics.checkParameterIsNotNull(resourceState, (String)"it");
                CallViewModel.access$get_participants$p(v0.this$0).setValue(resourceState);
                CallViewModel.access$get_participantStatuses$p(v0.this$0).withParticipants((LiveData<ResourceState<List<TinodeContact>>>)CallViewModel.access$get_participants$p(this.this$0));
            }
        };
        BaseViewModel.observableCall$default(callViewModel, mutableLiveData, (Function0)function02, null, (Function1)function12, null, 20, null);
    }

    private final void observeVoiceCall() {
        Function0<Observable<ResourceState<? extends Chat>>> function0;
        CallViewModel callViewModel = this;
        MutableLiveData<ResourceState<Chat>> mutableLiveData = callViewModel._call;
        Function0<Observable<ResourceState<? extends Chat>>> function02 = function0;
        function0 = new Function0<Observable<ResourceState<? extends Chat>>>(this){
            final /* synthetic */ CallViewModel this$0;
            {
                this.this$0 = callViewModel;
                super(0);
            }

            public final Observable<ResourceState<Chat>> invoke() {
                Observable observable = CallViewModel.access$getMessagingRepo$p(this.this$0).getChat(this.this$0.getTopicId()).doOnNext(new Consumer<ResourceState<? extends Chat>>(this){
                    final /* synthetic */ observeVoiceCall.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void accept(ResourceState<Chat> object) {
                        if ((object = ((ResourceState)object).getData()) != null) {
                            this.this$0.this$0.getCallControlVM().setCall((Chat)object);
                        }
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"messagingRepo.getChat(to\u2026          }\n            }");
                return observable;
            }
        };
        BaseViewModel.observableCall$default(callViewModel, mutableLiveData, (Function0)function02, null, null, null, 28, null);
    }

    private final void observeVoiceMessages() {
        CallViewModel callViewModel = this;
        CompositeDisposable compositeDisposable = callViewModel.getCompositeDisposable();
        CallRepo callRepo = callViewModel.callRepo;
        String string2 = callViewModel.topicId;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"topicId");
        }
        compositeDisposable.add(callRepo.observeCallMessages(string2, this.session.getTinodeUserId()).subscribeOn(this.schedulers.io()).observeOn(this.schedulers.ui()).subscribe(new Consumer<ChatMessage>(this){
            final /* synthetic */ CallViewModel this$0;
            {
                this.this$0 = callViewModel;
            }

            public final void accept(ChatMessage chatMessage) {
                observeVoiceMessages.1 v0 = this;
                CallViewModel.access$get_latestMessage$p(v0.this$0).setValue((Object)chatMessage);
                CallViewModel.access$get_participantStatuses$p(v0.this$0).withLatestMessage((LiveData<ChatMessage>)CallViewModel.access$get_latestMessage$p(this.this$0));
            }
        }, (Consumer)observeVoiceMessages.2.INSTANCE));
    }

    private final void getOldVoiceMessages() {
        CallViewModel callViewModel = this;
        CompositeDisposable compositeDisposable = callViewModel.getCompositeDisposable();
        CallRepo callRepo = callViewModel.callRepo;
        String string2 = callViewModel.topicId;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"topicId");
        }
        compositeDisposable.add(callRepo.getOldCallMessages(string2).subscribeOn(this.schedulers.io()).observeOn(this.schedulers.ui()).subscribe(new Consumer<List<? extends ChatMessage>>(this){
            final /* synthetic */ CallViewModel this$0;
            {
                this.this$0 = callViewModel;
            }

            public final void accept(List<ChatMessage> list) {
                getOldVoiceMessages.1 v0 = this;
                CallViewModel.access$get_callMessages$p(v0.this$0).setValue(list);
                CallViewModel.access$get_participantStatuses$p(v0.this$0).withPreviousMessages((LiveData<List<ChatMessage>>)CallViewModel.access$get_callMessages$p(this.this$0));
            }
        }, (Consumer)getOldVoiceMessages.2.INSTANCE));
    }

    private final void resetCall() {
        CallViewModel callViewModel = this;
        callViewModel.ringtonePlayer.dismiss();
        Object object = callViewModel.callRepo;
        String string2 = callViewModel.topicId;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"topicId");
        }
        CallRepo.DefaultImpls.sendCallIdiom$default((CallRepo)object, string2, CallIdiom.END, null, null, 12, null).subscribeOn(this.schedulers.io()).subscribe((Consumer)resetCall.1.INSTANCE, (Consumer)resetCall.2.INSTANCE);
        object = this.activeCall;
        if (object != null) {
            object.removeCallListener(this.voxCallListener);
        }
        CallViewModel callViewModel2 = this;
        object = callViewModel2.voxImplantCallManager;
        string2 = callViewModel2.topicId;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"topicId");
        }
        CallViewModel callViewModel3 = this;
        ((VoximplantCallManager)object).endCall(string2);
        callViewModel3.activeCall = null;
        callViewModel3.isSendVideoEnabled = false;
        callViewModel3._participantStatuses.removeSource((LiveData)this._participants);
        callViewModel3._participantStatuses.removeSource((LiveData)this._callMessages);
        callViewModel3._participantStatuses.removeSource((LiveData)this._call);
        callViewModel3._participantStatuses.invalidate();
        callViewModel3._call.postValue(ResourceState.Companion.success(null));
        callViewModel3._callStartedAt.setValue(null);
        callViewModel3.session.setActiveCallId(null);
        object = callViewModel3.session;
        boolean bl = true;
        String string3 = callViewModel3.topicId;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"topicId");
        }
        ((SessionPrefImpl)object).setTopicMuted(bl, string3);
        this.getCompositeDisposable().clear();
    }

    private final void resetMicrophone() {
        ICall iCall = this.activeCall;
        if (iCall != null) {
            iCall.sendAudio(true);
        }
        this.isSendAudioEnabled = true;
        this.callControlVM.postMicrophoneStatus(false);
    }

    @Inject
    public CallViewModel(@NotNull Context object, @NotNull MessagingRepo messagingRepo, @NotNull CallRepo callRepo, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull SchedulerProvider schedulerProvider, @NotNull RingtonePlayer ringtonePlayer, @NotNull VoximplantClientManager voximplantClientManager, @NotNull VoximplantCallManager voximplantCallManager, @NotNull AnalyticsRepo analyticsRepo) {
        CallController callController;
        CallViewModel callViewModel = this;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)messagingRepo, (String)"messagingRepo");
        Intrinsics.checkParameterIsNotNull((Object)callRepo, (String)"callRepo");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)schedulerProvider, (String)"schedulers");
        Intrinsics.checkParameterIsNotNull((Object)ringtonePlayer, (String)"ringtonePlayer");
        Intrinsics.checkParameterIsNotNull((Object)voximplantClientManager, (String)"voximplantClientManager");
        Intrinsics.checkParameterIsNotNull((Object)voximplantCallManager, (String)"voxImplantCallManager");
        Intrinsics.checkParameterIsNotNull((Object)analyticsRepo, (String)"analyticsRepo");
        super(schedulerProvider);
        this.context = object;
        this.messagingRepo = messagingRepo;
        this.callRepo = callRepo;
        this.session = sessionPrefImpl;
        this.schedulers = schedulerProvider;
        this.ringtonePlayer = ringtonePlayer;
        this.voximplantClientManager = voximplantClientManager;
        this.voxImplantCallManager = voximplantCallManager;
        callViewModel.analyticsRepo = analyticsRepo;
        this._callStartedAt = new MutableLiveData();
        LiveData liveData = Transformations.distinctUntilChanged((LiveData)this._callStartedAt);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        callViewModel.callStartedAt = liveData;
        this._call = new MutableLiveData();
        LiveData liveData2 = Transformations.distinctUntilChanged((LiveData)this._call);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData2, (String)"Transformations.distinctUntilChanged(this)");
        callViewModel.call = liveData2;
        callViewModel._callMessages = new MutableLiveData();
        callViewModel._latestMessage = new MutableLiveData();
        object = callController;
        CallViewModel callViewModel2 = this;
        callViewModel.callControlVM = new CallController(callViewModel2, callViewModel2.session);
        this._participantStatuses = new ParticipantStatusesLiveData((CallController)object);
        LiveData liveData3 = Transformations.map((LiveData)this._participantStatuses, new Function<List<? extends CallParticipantStatus>, ResourceState<? extends List<? extends CallParticipantStatus>>>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object apply(Object object) {
                List list = (List)object;
                list.toString();
                return ResourceState.Companion.success(list);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData3, (String)"Transformations.map(this) { transform(it) }");
        LiveData liveData4 = Transformations.distinctUntilChanged((LiveData)liveData3);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData4, (String)"Transformations.distinctUntilChanged(this)");
        callViewModel.participantStatuses = liveData4;
        this._callState = new MediatorLiveData<ResourceState<? extends CallConnectionStatus>>(this){
            final /* synthetic */ CallViewModel this$0;

            private final CallConnectionStatus reduceParticipantCallStates(List<? extends ParticipantStatus> list) {
                return list.contains((Object)((Object)ParticipantStatus.OnCall)) ? CallConnectionStatus.Connected : (list.contains((Object)((Object)ParticipantStatus.Connecting)) ? CallConnectionStatus.Connecting : CallConnectionStatus.Idle);
            }
            {
                Observer<List<? extends CallParticipantStatus>> observer;
                this.this$0 = object;
                object = CallViewModel.access$get_participantStatuses$p(object);
                Observer<List<? extends CallParticipantStatus>> observer2 = observer;
                observer = new Observer<List<? extends CallParticipantStatus>>(this){
                    final /* synthetic */ _callState.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void onChanged(List<CallParticipantStatus> object) {
                        ArrayList<ParticipantStatus> arrayList;
                        ArrayList<E> arrayList2;
                        Iterator<T> iterator = object;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"participantStatuses");
                        Object object3 = arrayList2;
                        arrayList2 = new ArrayList<E>();
                        Object object4 = iterator.iterator();
                        while (object4.hasNext()) {
                            T object22 = object4.next();
                            if (!(Intrinsics.areEqual((Object)((CallParticipantStatus)object22).getUserId(), (Object)CallViewModel.access$getSession$p(this.this$0.this$0).getTinodeUserId()) ^ true)) continue;
                            object3.add(object22);
                        }
                        object4 = this.this$0;
                        ResourceState.Companion companion = ResourceState.Companion;
                        ArrayList<ParticipantStatus> arrayList3 = arrayList;
                        arrayList = new ArrayList<ParticipantStatus>(CollectionsKt.collectionSizeOrDefault(object3, (int)10));
                        object3 = object3.iterator();
                        while (object3.hasNext()) {
                            arrayList3.add(((CallParticipantStatus)object3.next()).getStatus());
                        }
                        object4.postValue(companion.success(_callState.1.access$reduceParticipantCallStates(object4, arrayList3)));
                        object = object.iterator();
                        while (object.hasNext()) {
                            Object object2 = object3 = (CallParticipantStatus)object.next();
                            object3 = ((CallParticipantStatus)object2).getUserId();
                            this.this$0.this$0.getCallControlVM().updateCallContactStatus((String)object3, ((CallParticipantStatus)object2).getStatus());
                        }
                    }
                };
                this.addSource((LiveData)object, observer2);
            }

            public static final /* synthetic */ CallConnectionStatus access$reduceParticipantCallStates(_callState.1 var0, List list) {
                return var0.reduceParticipantCallStates(list);
            }
        };
        LiveData liveData5 = Transformations.distinctUntilChanged((LiveData)this._callState);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData5, (String)"Transformations.distinctUntilChanged(this)");
        callViewModel.callState = liveData5;
        callViewModel._participants = new MutableLiveData();
        LiveData liveData6 = Transformations.distinctUntilChanged((LiveData)new MediatorLiveData<Boolean>(this){
            final /* synthetic */ CallViewModel this$0;

            private final void checkState(CallConnectionStatus callConnectionStatus) {
                if (callConnectionStatus == CallConnectionStatus.Connected) {
                    this.postValue(Boolean.TRUE);
                } else {
                    this.postValue(Boolean.FALSE);
                }
            }

            static /* synthetic */ void checkState$default(isCallActive.1 var0, CallConnectionStatus object, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = (ResourceState)CallViewModel.access$get_callState$p(var0.this$0).getValue();
                    object = object != null ? (CallConnectionStatus)((Object)((ResourceState)object).getData()) : null;
                }
                var0.checkState((CallConnectionStatus)((Object)object));
            }
            {
                Observer<ResourceState<? extends CallConnectionStatus>> observer;
                this.this$0 = object;
                object = CallViewModel.access$get_callState$p(object);
                Observer<ResourceState<? extends CallConnectionStatus>> observer2 = observer;
                observer = new Observer<ResourceState<? extends CallConnectionStatus>>(this){
                    final /* synthetic */ isCallActive.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void onChanged(ResourceState<? extends CallConnectionStatus> object) {
                        if ((object = object.getData()) != null) {
                            isCallActive.1.access$checkState(this.this$0, object);
                        }
                    }
                };
                this.addSource((LiveData)object, observer2);
            }

            public static final /* synthetic */ void access$checkState(isCallActive.1 var0, CallConnectionStatus callConnectionStatus) {
                var0.checkState(callConnectionStatus);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData6, (String)"Transformations.distinctUntilChanged(this)");
        callViewModel.isCallActive = liveData6;
        callViewModel.voxEndpointListener = new IEndpointListener(this){
            final /* synthetic */ CallViewModel this$0;
            {
                this.this$0 = callViewModel;
            }

            public void onRemoteVideoStreamAdded(@Nullable IEndpoint iEndpoint, @Nullable IVideoStream iVideoStream) {
                if (iEndpoint != null && iVideoStream != null) {
                    CallController callController = this.this$0.getCallControlVM();
                    String string2 = iEndpoint.getUserName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"endpoint.userName");
                    callController.provideCallContactVideoSource(string2, iVideoStream);
                }
            }

            public void onRemoteVideoStreamRemoved(@Nullable IEndpoint iEndpoint, @Nullable IVideoStream iVideoStream) {
                if (iEndpoint != null) {
                    CallController callController = this.this$0.getCallControlVM();
                    String string2 = iEndpoint.getUserName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.userName");
                    callController.removeCallContactVideoSource(string2);
                }
            }

            public void onEndpointRemoved(@Nullable IEndpoint iEndpoint) {
                if (iEndpoint != null) {
                    iEndpoint.setEndpointListener(null);
                }
            }
        };
        callViewModel.voxCallListener = new ICallListener(this){
            final /* synthetic */ CallViewModel this$0;
            {
                this.this$0 = callViewModel;
            }

            public void onCallDisconnected(@Nullable ICall iCall, @Nullable Map<String, String> map2, boolean bl) {
                CallViewModel.access$getCompositeDisposable$p(this.this$0).add(Observable.just((Object)Boolean.TRUE).observeOn(CallViewModel.access$getSchedulers$p(this.this$0).ui()).subscribe(new Consumer<Boolean>(this){
                    final /* synthetic */ voxCallListener.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void accept(Boolean object) {
                        CallViewModel callViewModel = callViewModel.this$0.this$0;
                        object = (ResourceState)CallViewModel.access$get_call$p(callViewModel).getValue();
                        boolean bl = (object != null ? (Chat)((ResourceState)object).getData() : null) != null;
                        callViewModel.endCall(bl);
                    }
                }, (Consumer)voxCallListener.onCallDisconnected.2.INSTANCE));
            }

            public void onEndpointAdded(@Nullable ICall object, @Nullable IEndpoint iEndpoint) {
                CharSequence charSequence = new StringBuilder().append("onEndpointAdded call: ").append(object).append(", user:");
                String string2 = iEndpoint != null ? iEndpoint.getUserName() : null;
                charSequence.append(string2).toString();
                charSequence = iEndpoint != null ? iEndpoint.getEndpointId() : null;
                object = object != null ? object.getCallId() : null;
                if (Intrinsics.areEqual((Object)charSequence, (Object)object) ^ true) {
                    voxCallListener.1 v0 = this;
                    CallViewModel.access$getRingtonePlayer$p(v0.this$0).dismiss();
                    if (CallViewModel.access$get_callStartedAt$p(v0.this$0).getValue() == null) {
                        CallViewModel.access$get_callStartedAt$p(this.this$0).postValue((Object)System.currentTimeMillis());
                    }
                    if (iEndpoint != null) {
                        iEndpoint.setEndpointListener(CallViewModel.access$getVoxEndpointListener$p(this.this$0));
                    }
                }
            }

            public void onLocalVideoStreamAdded(@Nullable ICall iCall, @Nullable IVideoStream iVideoStream) {
                this.this$0.getCallControlVM().provideLocalSource(iVideoStream);
            }

            public void onLocalVideoStreamRemoved(@Nullable ICall iCall, @Nullable IVideoStream iVideoStream) {
                this.this$0.getCallControlVM().releaseLocalSource();
            }

            public void onCallFailed(@Nullable ICall iCall, int n, @Nullable String string2, @Nullable Map<String, String> map2) {
                voxCallListener.1 v0 = this;
                CallViewModel.access$get_callState$p(v0.this$0).postValue(ResourceState.Companion.error$default(ResourceState.Companion, new BaseError("Call failed: " + string2, 0, null, 6, null), null, 2, null));
                CallViewModel.access$getCompositeDisposable$p(v0.this$0).add(Observable.just((Object)Boolean.TRUE).observeOn(CallViewModel.access$getSchedulers$p(this.this$0).ui()).subscribe(new Consumer<Boolean>(this){
                    final /* synthetic */ voxCallListener.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void accept(Boolean object) {
                        CallViewModel callViewModel = callViewModel.this$0.this$0;
                        object = (ResourceState)CallViewModel.access$get_call$p(callViewModel).getValue();
                        boolean bl = (object != null ? (Chat)((ResourceState)object).getData() : null) != null;
                        callViewModel.endCall(bl);
                    }
                }, (Consumer)voxCallListener.onCallFailed.2.INSTANCE));
            }
        };
        callViewModel.isSendAudioEnabled = true;
        ICameraManager iCameraManager = Voximplant.getCameraManager((Context)callViewModel.context);
        Intrinsics.checkExpressionValueIsNotNull((Object)iCameraManager, (String)"Voximplant.getCameraManager(context)");
        callViewModel.cameraManager = iCameraManager;
        IAudioDeviceManager iAudioDeviceManager = Voximplant.getAudioDeviceManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)iAudioDeviceManager, (String)"Voximplant.getAudioDeviceManager()");
        callViewModel.mAudioDeviceManager = iAudioDeviceManager;
        object = callViewModel.session.getVoximplantUser();
        if (object != null) {
            Object object2 = object;
            object = ((VoximplantUser)object2).getUsername();
            this.voximplantClientManager.login((String)object, ((VoximplantUser)object2).getPassword());
        }
        CallViewModel callViewModel3 = this;
        callViewModel3.cameraManager.setCamera(1, VideoQuality.VIDEO_QUALITY_HIGH);
        callViewModel3.mAudioDeviceManager.addAudioDeviceEventsListener(new IAudioDeviceEventsListener(){

            public void onAudioDeviceChanged(@Nullable AudioDevice audioDevice) {
            }

            public void onAudioDeviceListChanged(@Nullable List<AudioDevice> list) {
                mAudioDeviceManager.selectAudioDevice(AudioDevice.SPEAKER);
            }
        });
    }

    public static final /* synthetic */ String access$getTopicId$p(CallViewModel object) {
        object = ((CallViewModel)object).topicId;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"topicId");
        }
        return object;
    }

    public static final /* synthetic */ void access$setTopicId$p(CallViewModel callViewModel, String string2) {
        callViewModel.topicId = string2;
    }

    public static final /* synthetic */ CallRepo access$getCallRepo$p(CallViewModel callViewModel) {
        return callViewModel.callRepo;
    }

    public static final /* synthetic */ ICall access$getActiveCall$p(CallViewModel callViewModel) {
        return callViewModel.activeCall;
    }

    public static final /* synthetic */ void access$setActiveCall$p(CallViewModel callViewModel, ICall iCall) {
        callViewModel.activeCall = iCall;
    }

    public static final /* synthetic */ VoximplantCallManager access$getVoxImplantCallManager$p(CallViewModel callViewModel) {
        return callViewModel.voxImplantCallManager;
    }

    public static final /* synthetic */ ICallListener access$getVoxCallListener$p(CallViewModel callViewModel) {
        return callViewModel.voxCallListener;
    }

    public static final /* synthetic */ boolean access$isSendVideoEnabled$p(CallViewModel callViewModel) {
        return callViewModel.isSendVideoEnabled;
    }

    public static final /* synthetic */ void access$setSendVideoEnabled$p(CallViewModel callViewModel, boolean bl) {
        callViewModel.isSendVideoEnabled = bl;
    }

    public static final /* synthetic */ CompositeDisposable access$getCompositeDisposable$p(CallViewModel callViewModel) {
        return callViewModel.getCompositeDisposable();
    }

    public static final /* synthetic */ RingtonePlayer access$getRingtonePlayer$p(CallViewModel callViewModel) {
        return callViewModel.ringtonePlayer;
    }

    public static final /* synthetic */ MessagingRepo access$getMessagingRepo$p(CallViewModel callViewModel) {
        return callViewModel.messagingRepo;
    }

    public static final /* synthetic */ MutableLiveData access$get_participants$p(CallViewModel callViewModel) {
        return callViewModel._participants;
    }

    public static final /* synthetic */ ParticipantStatusesLiveData access$get_participantStatuses$p(CallViewModel callViewModel) {
        return callViewModel._participantStatuses;
    }

    public static final /* synthetic */ MutableLiveData access$get_latestMessage$p(CallViewModel callViewModel) {
        return callViewModel._latestMessage;
    }

    public static final /* synthetic */ MutableLiveData access$get_callMessages$p(CallViewModel callViewModel) {
        return callViewModel._callMessages;
    }

    public static final /* synthetic */ SessionPrefImpl access$getSession$p(CallViewModel callViewModel) {
        return callViewModel.session;
    }

    public static final /* synthetic */ _callState.1 access$get_callState$p(CallViewModel callViewModel) {
        return callViewModel._callState;
    }

    public static final /* synthetic */ SchedulerProvider access$getSchedulers$p(CallViewModel callViewModel) {
        return callViewModel.schedulers;
    }

    public static final /* synthetic */ MutableLiveData access$get_call$p(CallViewModel callViewModel) {
        return callViewModel._call;
    }

    public static final /* synthetic */ MutableLiveData access$get_callStartedAt$p(CallViewModel callViewModel) {
        return callViewModel._callStartedAt;
    }

    public static final /* synthetic */ IEndpointListener access$getVoxEndpointListener$p(CallViewModel callViewModel) {
        return callViewModel.voxEndpointListener;
    }

    @NotNull
    public final String getTopicId() {
        String string2 = ((CallViewModel)((Object)string2)).topicId;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"topicId");
        }
        return string2;
    }

    @NotNull
    public final LiveData<Long> getCallStartedAt() {
        return this.callStartedAt;
    }

    @NotNull
    public final LiveData<ResourceState<Chat>> getCall() {
        return this.call;
    }

    @NotNull
    public final CallController getCallControlVM() {
        return this.callControlVM;
    }

    @NotNull
    public final LiveData<ResourceState<List<CallParticipantStatus>>> getParticipantStatuses() {
        return this.participantStatuses;
    }

    @NotNull
    public final LiveData<ResourceState<CallConnectionStatus>> getCallState() {
        return this.callState;
    }

    @NotNull
    public final LiveData<Boolean> isCallActive() {
        return this.isCallActive;
    }

    public final void init(@NotNull String string2, @NotNull CoroutineScope object) {
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
                Intrinsics.checkParameterIsNotNull((Object)object, (String)"scope");
                object = this.topicId;
                if (object == null) break block5;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"topicId");
                }
                if (!(Intrinsics.areEqual((Object)object, (Object)string2) ^ true)) break block6;
            }
            CallViewModel callViewModel = this;
            callViewModel._participantStatuses.setValue(CollectionsKt.emptyList());
            callViewModel.resetMicrophone();
            callViewModel.mAudioDeviceManager.selectAudioDevice(AudioDevice.SPEAKER);
            if (callViewModel.activeCall != null) {
                this.resetCall();
            }
            CallViewModel callViewModel2 = this;
            CallViewModel callViewModel3 = this;
            callViewModel3.session.setActiveCallId(string2);
            callViewModel3.session.setTopicMuted(true, string2);
            callViewModel3.callControlVM.postMicrophoneStatus(this.isSendAudioEnabled ^ true);
            callViewModel3._callState.postValue(ResourceState.Companion.success(CallConnectionStatus.Idle));
            this.topicId = string2;
            this.getCompositeDisposable().clear();
            callViewModel2.startCall(string2);
            callViewModel2.observeVoiceCall();
            callViewModel2.observeParticipants();
            callViewModel2.getOldVoiceMessages();
            callViewModel2.observeVoiceMessages();
            callViewModel2.startRingingTimer();
        }
    }

    public final void declineCall(@NotNull String string2) {
        CallViewModel callViewModel = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        callViewModel.ringtonePlayer.dismiss();
        callViewModel.session.setTopicMuted(true, string2);
        BaseViewModel.observableCall$default(callViewModel, (Function0)new Function0<Observable<ResourceState<? extends Boolean>>>(this, string2){
            final /* synthetic */ CallViewModel this$0;
            final /* synthetic */ String $topicId;
            {
                this.this$0 = callViewModel;
                this.$topicId = string2;
                super(0);
            }

            @NotNull
            public final Observable<ResourceState<Boolean>> invoke() {
                return CallRepo.DefaultImpls.sendCallIdiom$default(CallViewModel.access$getCallRepo$p(this.this$0), this.$topicId, CallIdiom.DECLINE, null, null, 12, null);
            }
        }, null, null, null, 14, null);
        AnalyticsRepo.DefaultImpls.triggerCallEvent$default(callViewModel.analyticsRepo, null, CommonKind.CALL_FINISHED, null, 5, null);
    }

    @Override
    public void toggleMicrophone() {
        boolean bl;
        CallViewModel callViewModel = this;
        AnalyticsRepo.DefaultImpls.triggerInteractionEvent$default(callViewModel.analyticsRepo, null, null, 3, null);
        callViewModel.isSendAudioEnabled = bl = callViewModel.isSendAudioEnabled ^ true;
        ICall iCall = callViewModel.activeCall;
        if (iCall != null) {
            iCall.sendAudio(bl);
        }
        this.callControlVM.postMicrophoneStatus(this.isSendAudioEnabled ^ true);
    }

    public final void toggleCamera() {
        CallViewModel callViewModel = this;
        AnalyticsRepo.DefaultImpls.triggerInteractionEvent$default(callViewModel.analyticsRepo, null, null, 3, null);
        ICall iCall = callViewModel.activeCall;
        if (iCall != null) {
            ICallCompletionHandler iCallCompletionHandler;
            boolean bl = this.isSendVideoEnabled ^ true;
            ICallCompletionHandler iCallCompletionHandler2 = iCallCompletionHandler;
            iCallCompletionHandler = new ICallCompletionHandler(bl, this){
                final /* synthetic */ boolean $sendVideo;
                final /* synthetic */ CallViewModel this$0;
                {
                    this.$sendVideo = bl;
                    this.this$0 = callViewModel;
                }

                public void onFailure(@Nullable CallException callException) {
                }

                public void onComplete() {
                    toggleCamera$$inlined$let$lambda$1 v0 = this;
                    CallViewModel.access$setSendVideoEnabled$p(v0.this$0, this.$sendVideo);
                    v0.this$0.getCallControlVM().postCameraStatus(this.$sendVideo);
                }
            };
            iCall.sendVideo(bl, iCallCompletionHandler2);
        }
    }

    @Override
    public void endCall(boolean bl) {
        this._callState.setValue(ResourceState.Companion.success(CallConnectionStatus.Ended));
        if (bl) {
            AnalyticsRepo.DefaultImpls.triggerCallEvent$default(this.analyticsRepo, null, CommonKind.CALL_FINISHED, null, 5, null);
        }
        CallViewModel callViewModel = this;
        callViewModel.resetCall();
        callViewModel.callControlVM.endCall();
        callViewModel._callState.setValue(ResourceState.Companion.success(CallConnectionStatus.Ended));
    }

    @Override
    protected void onCleared() {
        CallViewModel callViewModel = this;
        super.onCleared();
        callViewModel.voxImplantCallManager.endAllCalls();
        callViewModel.voximplantClientManager.logout();
    }
}

