/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.notifications;

import android.content.Context;
import android.content.res.ColorStateList;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Chronometer;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.bornfight.utils.adapters.GenericAdapter;
import com.google.android.material.button.MaterialButton;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.main.notifications.NotificationsAdapter$NotificationCallViewHolder$WhenMappings;
import io.streamlayer.sdk.main.notifications.NotificationsAdapter$NotificationViewHolder$WhenMappings;
import io.streamlayer.sdk.main.notifications.NotificationsAdapter$WhenMappings;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationAction;
import io.streamlayer.sdk.model.notifications.NotificationBuilder;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationKt;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import io.streamlayer.utils.ExtensionsKt;
import io.streamlayer.utils.GsonUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u001b\u001c\u001d\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0014J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u000eH\u0014J\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J\u0014\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;", "Lcom/bornfight/utils/adapters/GenericAdapter;", "Lio/streamlayer/sdk/model/notifications/Notification;", "()V", "listener", "Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;", "getListener", "()Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;", "setListener", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;)V", "checkActiveCalls", "", "getItemAndRemove", "position", "", "getItemViewType", "getLayoutId", "viewType", "getViewHolder", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "view", "Landroid/view/View;", "setItems", "listItems", "", "updateItems", "", "NotificationCallViewHolder", "NotificationCustomViewHolder", "NotificationDiffUtilCallback", "NotificationViewHolder", "OnItemInteractionListener", "sdk_originalVoximplantRelease"})
public final class NotificationsAdapter
extends GenericAdapter<Notification> {
    @Nullable
    private OnItemInteractionListener listener;

    private final void checkActiveCalls() {
        if (this.getListItems().size() > 2 && NotificationKt.isCallMissedType(((Notification)this.getListItems().get(0)).getType()) && NotificationKt.isCallingType(((Notification)this.getListItems().get(1)).getType())) {
            NotificationsAdapter notificationsAdapter = this;
            Collections.swap(notificationsAdapter.getListItems(), 0, 1);
            notificationsAdapter.notifyItemRangeChanged(0, 2);
        }
    }

    @Nullable
    public final OnItemInteractionListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable OnItemInteractionListener onItemInteractionListener) {
        this.listener = onItemInteractionListener;
    }

    public void setItems(@NotNull List<Notification> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"listItems");
        if (!this.getListItems().containsAll(list)) {
            super.setItems(list);
        }
    }

    @NotNull
    public final Notification getItemAndRemove(int n) {
        Notification notification = (Notification)this.getListItems().remove(n);
        this.notifyItemRemoved(n);
        return notification;
    }

    public final boolean updateItems(@NotNull List<Notification> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"listItems");
        if (this.getItemCount() == 0) {
            super.setItems(CollectionsKt.sortedWith(list, new Comparator<T>(){

                public final int compare(T t, T t2) {
                    return ComparisonsKt.compareValues((Comparable)Boolean.valueOf(NotificationKt.isCallType(((Notification)t).getType()) ^ true), (Comparable)Boolean.valueOf(NotificationKt.isCallType(((Notification)t2).getType()) ^ true));
                }
            }));
            return true;
        }
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new NotificationDiffUtilCallback(this.getListItems(), list));
        NotificationsAdapter notificationsAdapter = this;
        Intrinsics.checkExpressionValueIsNotNull((Object)diffResult, (String)"DiffUtil.calculateDiff(N\u2026is.listItems, listItems))");
        notificationsAdapter.setItems(CollectionsKt.sortedWith(list, new Comparator<T>(){

            public final int compare(T t, T t2) {
                return ComparisonsKt.compareValues((Comparable)Boolean.valueOf(NotificationKt.isCallType(((Notification)t).getType()) ^ true), (Comparable)Boolean.valueOf(NotificationKt.isCallType(((Notification)t2).getType()) ^ true));
            }
        }));
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)notificationsAdapter);
        this.checkActiveCalls();
        return false;
    }

    public int getItemViewType(int n) {
        int n2;
        switch (NotificationsAdapter$WhenMappings.$EnumSwitchMapping$0[((Notification)this.getItem(n)).getType().ordinal()]) {
            default: {
                n2 = 1;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
            }
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getLayoutId(int n) {
        int n2;
        if (n != 1) {
            if (n != 2) {
                if (n != 3) throw new RuntimeException("Invalid ViewHolder type: " + n);
                n2 = R.layout.slr_item_notification_custom;
                return n2;
            } else {
                n2 = R.layout.slr_item_notification_call;
            }
            return n2;
        } else {
            n2 = R.layout.slr_item_notification;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected GenericAdapter.GenericViewHolder<Notification> getViewHolder(@NotNull View view, int n) {
        GenericAdapter.GenericViewHolder genericViewHolder;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (n != 1) {
            if (n != 2) {
                NotificationCustomViewHolder notificationCustomViewHolder;
                if (n != 3) throw new RuntimeException("Invalid ViewHolder type: " + n);
                genericViewHolder = notificationCustomViewHolder;
                notificationCustomViewHolder = new NotificationCustomViewHolder(view);
                return genericViewHolder;
            } else {
                NotificationCallViewHolder notificationCallViewHolder;
                genericViewHolder = notificationCallViewHolder;
                notificationCallViewHolder = new NotificationCallViewHolder(view);
            }
            return genericViewHolder;
        } else {
            NotificationViewHolder notificationViewHolder;
            genericViewHolder = notificationViewHolder;
            notificationViewHolder = new NotificationViewHolder(view);
        }
        return genericViewHolder;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationDiffUtilCallback;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldList", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "newList", "(Ljava/util/List;Ljava/util/List;)V", "getNewList", "()Ljava/util/List;", "getOldList", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "getNewListSize", "getOldListSize", "sdk_originalVoximplantRelease"})
    public static final class NotificationDiffUtilCallback
    extends DiffUtil.Callback {
        @NotNull
        private final List<Notification> oldList;
        @NotNull
        private final List<Notification> newList;

        public NotificationDiffUtilCallback(@NotNull List<Notification> list, @NotNull List<Notification> list2) {
            Intrinsics.checkParameterIsNotNull(list, (String)"oldList");
            Intrinsics.checkParameterIsNotNull(list2, (String)"newList");
            this.oldList = list;
            this.newList = list2;
        }

        public boolean areItemsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldList.get(n).getSourceUniqueId(), (Object)this.newList.get(n2).getSourceUniqueId());
        }

        public int getOldListSize() {
            return this.oldList.size();
        }

        public int getNewListSize() {
            return this.newList.size();
        }

        public boolean areContentsTheSame(int n, int n2) {
            Notification notification = object.oldList.get(n);
            Object object = object.newList.get(n2);
            return notification.getType() == notification.getType() && Intrinsics.areEqual((Object)notification, (Object)object);
        }

        @NotNull
        public final List<Notification> getOldList() {
            return this.oldList;
        }

        @NotNull
        public final List<Notification> getNewList() {
            return this.newList;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$OnItemInteractionListener;", "", "onNotificationActionClick", "", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "action", "Lio/streamlayer/sdk/model/notifications/NotificationAction;", "onNotificationClick", "sdk_originalVoximplantRelease"})
    public static interface OnItemInteractionListener {
        public void onNotificationClick(@NotNull Notification var1);

        public void onNotificationActionClick(@NotNull Notification var1, @NotNull NotificationAction var2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationCustomViewHolder;", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/notifications/Notification;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;Landroid/view/View;)V", "bind", "", "data", "sdk_originalVoximplantRelease"})
    public final class NotificationCustomViewHolder
    extends GenericAdapter.GenericViewHolder<Notification> {
        public NotificationCustomViewHolder(View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void bind(@NotNull Notification notification) {
            LayoutInflater layoutInflater;
            Notification notification2 = notification;
            Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"data");
            NotificationBuilder notificationBuilder = notification2.getCustomBuilder();
            if (notificationBuilder == null) return;
            if (notificationBuilder.getLayoutId() != null) {
                View view = notificationCustomViewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                layoutInflater = LayoutInflater.from((Context)view.getContext());
                Integer n = notificationBuilder.getLayoutId();
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                int n2 = n;
                View view2 = notificationCustomViewHolder.itemView;
                if (view2 == null) throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
                layoutInflater = layoutInflater.inflate(n2, (ViewGroup)view2, false);
            } else {
                String string2;
                NotificationCustomViewHolder notificationCustomViewHolder = notificationCustomViewHolder;
                View view = notificationCustomViewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                layoutInflater = LayoutInflater.from((Context)view.getContext());
                int n = R.layout.slr_item_notification;
                View view3 = notificationCustomViewHolder.itemView;
                if (view3 == null) throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
                layoutInflater = layoutInflater.inflate(n, (ViewGroup)view3, false);
                Intrinsics.checkExpressionValueIsNotNull((Object)layoutInflater, (String)"this");
                TextView textView = (TextView)layoutInflater.findViewById(R.id.slNotifTitleTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"this.slNotifTitleTV");
                textView.setText((CharSequence)notificationBuilder.getTitle());
                TextView textView2 = (TextView)layoutInflater.findViewById(R.id.slNotifDescriptionTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"this.slNotifDescriptionTV");
                textView2.setText((CharSequence)notificationBuilder.getDescription());
                Integer n3 = notificationBuilder.getIconBackgroundColor();
                if (n3 != null) {
                    int n4 = n3;
                    ImageView imageView = (ImageView)layoutInflater.findViewById(R.id.slNotifIconIV);
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"slNotifIconIV");
                    View view4 = notificationCustomViewHolder.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"itemView");
                    imageView.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)((ViewGroup)view4).getContext(), (int)n4)));
                }
                if ((string2 = notificationBuilder.getIconUrl()) != null) {
                    ImageView imageView = (ImageView)layoutInflater.findViewById(R.id.slNotifIconIV);
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"slNotifIconIV");
                    io.streamlayer.common.kotlin.ExtensionsKt.loadUrl$default(imageView, string2, false, null, null, 14, null);
                }
            }
            View view = notificationCustomViewHolder.itemView;
            if (view == null) throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout");
            LayoutInflater layoutInflater2 = layoutInflater;
            ((FrameLayout)view).addView((View)layoutInflater);
            layoutInflater2.setOnClickListener(new View.OnClickListener(notificationCustomViewHolder, notification){
                final /* synthetic */ NotificationCustomViewHolder this$0;
                final /* synthetic */ Notification $data$inlined;
                {
                    this.this$0 = notificationCustomViewHolder;
                    this.$data$inlined = notification;
                }

                public final void onClick(View object) {
                    object = this.this$0.NotificationsAdapter.this.getListener();
                    if (object != null) {
                        object.onNotificationClick(this.$data$inlined);
                    }
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)layoutInflater2, (String)"view");
            NotificationCustomViewHolder notificationCustomViewHolder = layoutInflater2.getLayoutParams();
            if (notificationCustomViewHolder == null) throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
            notificationCustomViewHolder = (FrameLayout.LayoutParams)notificationCustomViewHolder;
            v10.gravity = 80;
            layoutInflater.setLayoutParams((ViewGroup.LayoutParams)notificationCustomViewHolder);
            notificationBuilder.bindView((View)layoutInflater);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0096\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationViewHolder;", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/notifications/Notification;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;Landroid/view/View;)V", "bind", "", "data", "getColor", "", "type", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "getIcon", "sdk_originalVoximplantRelease"})
    public class NotificationViewHolder
    extends GenericAdapter.GenericViewHolder<Notification> {
        @DrawableRes
        private final int getIcon(NotificationType notificationType) {
            int n;
            switch (NotificationsAdapter$NotificationViewHolder$WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 12: {
                    n = 0;
                    break;
                }
                case 11: {
                    n = R.drawable.slr_ic_profile;
                    break;
                }
                case 10: {
                    n = R.drawable.slr_ic_chat;
                    break;
                }
                case 9: {
                    n = R.drawable.slr_ic_twitter;
                    break;
                }
                case 8: {
                    n = R.drawable.slr_ic_chat;
                    break;
                }
                case 7: {
                    n = R.drawable.slr_ic_betting;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n = R.drawable.slr_ic_call;
                    break;
                }
                case 1: {
                    n = R.drawable.slr_ic_chat;
                }
            }
            return n;
        }

        @ColorRes
        private final int getColor(NotificationType notificationType) {
            int n;
            switch (NotificationsAdapter$NotificationViewHolder$WhenMappings.$EnumSwitchMapping$1[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 12: {
                    n = 0;
                    break;
                }
                case 11: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 10: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 9: {
                    n = R.color.slr_twitter;
                    break;
                }
                case 8: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 7: {
                    n = R.color.slr_orange;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n = 17170445;
                    break;
                }
                case 1: {
                    n = R.color.slr_primaryBlue;
                }
            }
            return n;
        }

        public NotificationViewHolder(View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view);
            ((FrameLayout)view.findViewById(R.id.slNotificationHolder)).setOnTouchListener((View.OnTouchListener)1.INSTANCE);
        }

        public void bind(@NotNull Notification notification) {
            NotificationViewHolder notificationViewHolder = this;
            Intrinsics.checkParameterIsNotNull((Object)notification, (String)"data");
            View view = notificationViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
            TextView textView = (TextView)view.findViewById(R.id.slNotifTitleTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"itemView.slNotifTitleTV");
            textView.setText((CharSequence)notification.getTitle());
            View view2 = notificationViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView");
            TextView textView2 = (TextView)view2.findViewById(R.id.slNotifDescriptionTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"itemView.slNotifDescriptionTV");
            textView2.setText((CharSequence)notification.getDescription());
            Object object = notification.getNotificationIcon();
            if (object != null && (object = ((NotificationIcon)object).getAvatarUrl()) != null) {
                View view3 = this.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"itemView");
                ImageView imageView = (ImageView)view3.findViewById(R.id.slNotifIconIV);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"itemView.slNotifIconIV");
                io.streamlayer.common.kotlin.ExtensionsKt.loadUrl$default(imageView, (String)object, false, this.getIcon(notification.getType()), null, 10, null);
            } else {
                View view4 = this.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"itemView");
                ((ImageView)view4.findViewById(R.id.slNotifIconIV)).setImageResource(this.getIcon(notification.getType()));
            }
            View view5 = this.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"itemView");
            ImageView imageView = (ImageView)view5.findViewById(R.id.slNotifIconIV);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"itemView.slNotifIconIV");
            View view6 = this.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view6, (String)"itemView");
            imageView.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)view6.getContext(), (int)this.getColor(notification.getType()))));
            if (!ArraysKt.contains((Object[])new NotificationType[]{NotificationType.Call, NotificationType.GroupCall, NotificationType.MissedCall, NotificationType.MissedGroupCall}, (Object)((Object)notification.getType()))) {
                View view7 = this.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view7, (String)"itemView");
                ((ConstraintLayout)view7.findViewById(R.id.slNotification)).setOnClickListener(new View.OnClickListener(this, notification){
                    final /* synthetic */ NotificationViewHolder this$0;
                    final /* synthetic */ Notification $data;
                    {
                        this.this$0 = notificationViewHolder;
                        this.$data = notification;
                    }

                    public final void onClick(View object) {
                        object = this.this$0.NotificationsAdapter.this.getListener();
                        if (object != null) {
                            object.onNotificationClick(this.$data);
                        }
                    }
                });
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationCallViewHolder;", "Lio/streamlayer/sdk/main/notifications/NotificationsAdapter$NotificationViewHolder;", "Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/main/notifications/NotificationsAdapter;Landroid/view/View;)V", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVoximplantRelease"})
    public final class NotificationCallViewHolder
    extends NotificationViewHolder {
        public NotificationCallViewHolder(View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view);
        }

        @Override
        public void bind(@NotNull Notification object) {
            NotificationCallViewHolder notificationCallViewHolder = notificationCallViewHolder2;
            Intrinsics.checkParameterIsNotNull((Object)object, (String)"data");
            View view = notificationCallViewHolder.itemView;
            ((MaterialButton)view.findViewById(R.id.slNotifCallAcceptBtn)).setOnClickListener(new View.OnClickListener(notificationCallViewHolder2, (Notification)object){
                final /* synthetic */ NotificationCallViewHolder this$0;
                final /* synthetic */ Notification $data$inlined;
                {
                    this.this$0 = notificationCallViewHolder;
                    this.$data$inlined = notification;
                }

                public final void onClick(View object) {
                    object = this.this$0.NotificationsAdapter.this.getListener();
                    if (object != null) {
                        object.onNotificationActionClick(this.$data$inlined, NotificationAction.AcceptCall);
                    }
                }
            });
            ((MaterialButton)view.findViewById(R.id.slNotifCallDeclineBtn)).setOnClickListener(new View.OnClickListener(notificationCallViewHolder2, (Notification)object){
                final /* synthetic */ NotificationCallViewHolder this$0;
                final /* synthetic */ Notification $data$inlined;
                {
                    this.this$0 = notificationCallViewHolder;
                    this.$data$inlined = notification;
                }

                public final void onClick(View object) {
                    object = this.this$0.NotificationsAdapter.this.getListener();
                    if (object != null) {
                        object.onNotificationActionClick(this.$data$inlined, NotificationAction.DeclineCall);
                    }
                }
            });
            ((MaterialButton)view.findViewById(R.id.slNotifCallTextActionBtn)).setOnClickListener(new View.OnClickListener(notificationCallViewHolder2, (Notification)object){
                final /* synthetic */ NotificationCallViewHolder this$0;
                final /* synthetic */ Notification $data$inlined;
                {
                    this.this$0 = notificationCallViewHolder;
                    this.$data$inlined = notification;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void onClick(View view) {
                    NotificationAction notificationAction;
                    int n = NotificationsAdapter$NotificationCallViewHolder$WhenMappings.$EnumSwitchMapping$0[this.$data$inlined.getType().ordinal()];
                    if (n != 1 && n != 2) {
                        if (n != 3) throw new RuntimeException("Unsupported action for this button");
                        notificationAction = NotificationAction.AcceptCall;
                    } else {
                        notificationAction = NotificationAction.CallBack;
                    }
                    OnItemInteractionListener onItemInteractionListener = this.this$0.NotificationsAdapter.this.getListener();
                    if (onItemInteractionListener == null) return;
                    onItemInteractionListener.onNotificationActionClick(this.$data$inlined, notificationAction);
                }
            });
            NotificationCallViewHolder notificationCallViewHolder2 = notificationCallViewHolder.itemView;
            boolean bl = ArraysKt.contains((Object[])new NotificationType[]{NotificationType.MissedCall, NotificationType.MissedGroupCall, NotificationType.GroupCallActive}, (Object)((Object)((Notification)object).getType()));
            MaterialButton materialButton = (MaterialButton)notificationCallViewHolder2.findViewById(R.id.slNotifCallAcceptBtn);
            Intrinsics.checkExpressionValueIsNotNull((Object)materialButton, (String)"slNotifCallAcceptBtn");
            io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)materialButton, bl ^ true);
            MaterialButton materialButton2 = (MaterialButton)notificationCallViewHolder2.findViewById(R.id.slNotifCallDeclineBtn);
            Intrinsics.checkExpressionValueIsNotNull((Object)materialButton2, (String)"slNotifCallDeclineBtn");
            io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)materialButton2, bl ^ true);
            MaterialButton materialButton3 = (MaterialButton)notificationCallViewHolder2.findViewById(R.id.slNotifCallTextActionBtn);
            Intrinsics.checkExpressionValueIsNotNull((Object)materialButton3, (String)"slNotifCallTextActionBtn");
            io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)materialButton3, bl);
            MaterialButton materialButton4 = (MaterialButton)notificationCallViewHolder2.findViewById(R.id.slNotifCallTextActionBtn);
            Intrinsics.checkExpressionValueIsNotNull((Object)materialButton4, (String)"slNotifCallTextActionBtn");
            int n = NotificationsAdapter$NotificationCallViewHolder$WhenMappings.$EnumSwitchMapping$1[((Notification)object).getType().ordinal()];
            Object object2 = n != 1 ? (n != 2 ? (n != 3 ? "" : notificationCallViewHolder2.getContext().getString(R.string.slr_join)) : notificationCallViewHolder2.getContext().getString(R.string.slr_call_back)) : notificationCallViewHolder2.getContext().getString(R.string.slr_call_back);
            materialButton4.setText((CharSequence)object2);
            int n2 = NotificationsAdapter$NotificationCallViewHolder$WhenMappings.$EnumSwitchMapping$2[((Notification)object).getType().ordinal()];
            if (n2 != 1) {
                if (n2 != 2) {
                    ((ImageView)notificationCallViewHolder2.findViewById(R.id.slNotifIconIV)).setImageResource(R.drawable.slr_ic_call_incoming_colored);
                } else {
                    ImageView imageView = (ImageView)notificationCallViewHolder2.findViewById(R.id.slNotifIconIV);
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"slNotifIconIV");
                    object2 = ((Notification)object).getNotificationIcon();
                    object2 = object2 != null ? ((NotificationIcon)object2).getAvatarUrl() : null;
                    Object object3 = ((Notification)object).getNotificationIcon();
                    object3 = object3 != null ? ((NotificationIcon)object3).getAvatarName() : null;
                    ProfileExtensionsKt.loadUserAvatar$default(imageView, (String)object2, (String)object3, null, 4, null);
                }
            } else {
                ((ImageView)notificationCallViewHolder2.findViewById(R.id.slNotifIconIV)).setImageResource(R.drawable.slr_ic_contact_group);
            }
            ImageView imageView = (ImageView)notificationCallViewHolder2.findViewById(R.id.slNotifCallStatusIV);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"slNotifCallStatusIV");
            boolean bl2 = ((Notification)object).getType() == NotificationType.GroupCallActive;
            io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)imageView, bl2);
            imageView = (Chronometer)notificationCallViewHolder2.findViewById(R.id.slNotifCallChronometer);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"slNotifCallChronometer");
            bl2 = ((Notification)object).getType() == NotificationType.GroupCallActive;
            io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)imageView, bl2);
            object = (Chat)GsonUtil.INSTANCE.getDefaultGson().fromJson(((Notification)object).getDataJson(), Chat.class);
            if (object != null) {
                notificationCallViewHolder2 = (Chronometer)notificationCallViewHolder2.findViewById(R.id.slNotifCallChronometer);
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)notificationCallViewHolder2), (String)"slNotifCallChronometer");
                object = ((Chat)object).getUpdatedAt();
                object = object != null ? Long.valueOf(((Date)object).getTime()) : null;
                ExtensionsKt.startTimer((Chronometer)notificationCallViewHolder2, (Long)object);
            }
        }
    }
}

