/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.tinode;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.stub.StreamObserver;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.PublishSubject;
import io.streamlayer.common.data.grpc.ChatGrpcService;
import io.streamlayer.common.data.tinode.TinodeService;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatKt;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.model.tinodecontact.TinodeContactKt;
import io.streamlayer.sdk.model.tinodecontact.TinodePres;
import io.streamlayer.sdk.model.tinodecontact.TinodeUserPublic;
import io.streamlayer.utils.GsonUtil;
import io.streamlayer.utils.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pbx.Model;
import pbx.NodeGrpc;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001:\u0004VWXYB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0002J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010\u0015\u001a\u00020\u0010J\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0010H\u0002J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0015\u001a\u00020\u0010J\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0&0\u001aJ\u0012\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0&0\u001aJ\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001aJ2\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010\u0015\u001a\u00020\u00102\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020,2\b\b\u0002\u0010.\u001a\u00020,J\b\u0010/\u001a\u00020\u0010H\u0002J\u001a\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0&0\u001a2\u0006\u0010\u0015\u001a\u00020\u0010J\u0012\u00101\u001a\u0004\u0018\u00010\u00112\u0006\u0010#\u001a\u00020\u0010H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u0002030\u001a2\u0006\u00104\u001a\u00020\u0010H\u0002J\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u0010J\b\u00107\u001a\u00020\u001fH\u0002J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u00109\u001a\u00020\u0010H\u0002J\u0006\u0010:\u001a\u00020!J\u001e\u0010;\u001a\u00020!2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010<\u001a\u00020\u000bH\u0002J0\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u00102\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100@J(\u0010=\u001a\b\u0012\u0004\u0012\u00020A0\u001a2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u000b2\b\b\u0002\u0010B\u001a\u00020\u001fH\u0002J \u0010C\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0012\u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100&0&J\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010F\u001a\u00020\u001fJ\u001e\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u001aJ\u0012\u0010J\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0&0\u001aJ\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020L0\u001a2\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u001e\u0010M\u001a\b\u0012\u0004\u0012\u00020I0\u001a2\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001aJ\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001aJ\u0014\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010\u0015\u001a\u00020\u0010J\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0\u001a2\u0006\u0010S\u001a\u00020\u001dJ\u001e\u0010T\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010\u0015\u001a\u00020\u00102\b\b\u0002\u0010U\u001a\u00020\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lio/streamlayer/common/data/tinode/TinodeService;", "", "grpcService", "Lio/streamlayer/common/data/grpc/ChatGrpcService;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "(Lio/streamlayer/common/data/grpc/ChatGrpcService;Lio/streamlayer/common/session/SessionPrefImpl;)V", "compositeDisposable", "Lio/reactivex/disposables/CompositeDisposable;", "mClient", "Lio/grpc/stub/StreamObserver;", "Lpbx/Model$ClientMsg;", "messageId", "Ljava/util/concurrent/atomic/AtomicInteger;", "requestMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lio/streamlayer/common/data/tinode/TinodeService$ClientRequest;", "state", "Lio/streamlayer/common/data/tinode/TinodeService$State;", "buildPermissionString", "topicId", "access", "Lio/streamlayer/sdk/model/messaging/Access;", "client", "createTopic", "Lio/reactivex/Observable;", "Lio/streamlayer/sdk/model/messaging/Chat;", "info", "Lio/streamlayer/sdk/model/tinodecontact/TinodeUserPublic;", "deleteTopic", "", "disconnect", "", "dismissRequest", "id", "getChat", "getChats", "", "getContacts", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "getFndContacts", "getMessages", "sinceId", "", "beforeId", "limit", "getNextId", "getParticipants", "getRequest", "hi", "Lpbx/Model$ServerCtrl;", "fcmToken", "inviteUserToTopic", "userId", "isChannelAvailable", "login", "token", "refreshContacts", "sendClientMsg", "msg", "sendMessage", "content", "head", "", "Lio/streamlayer/common/data/tinode/TinodeService$ServerResponse;", "overrideRequest", "setFndTopicPhoneNumbers", "phoneNumbers", "setPresenceEnabled", "visible", "setSubscriptionToTopic", "subscribeToContactPresence", "Lio/streamlayer/sdk/model/tinodecontact/TinodePres;", "subscribeToFnd", "subscribeToTopic", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "subscribeToTopicPresence", "triggerOfflineStatus", "triggerOnlineStatus", "unsubscribeFromTopic", "updatePublicInfo", "Lpbx/Model$ServerMeta;", "publicInfo", "updateTopicPermission", "permissions", "ClientRequest", "ServerResponse", "ServerResponseListener", "State", "sdk_originalVoximplantRelease"})
public final class TinodeService {
    private State state;
    private StreamObserver<Model.ClientMsg> mClient;
    private final AtomicInteger messageId;
    private final ConcurrentHashMap<String, ClientRequest> requestMap;
    private CompositeDisposable compositeDisposable;
    private final ChatGrpcService grpcService;
    private final SessionPrefImpl session;

    private final StreamObserver<Model.ClientMsg> client() {
        if (this.mClient == null) {
            this.mClient = NodeGrpc.newStub((Channel)this.grpcService.getManagedChannel()).messageLoop((StreamObserver)new StreamObserver<Model.ServerMsg>(this){
                final /* synthetic */ TinodeService this$0;
                {
                    this.this$0 = tinodeService;
                }

                public void onNext(@Nullable Model.ServerMsg serverMsg) {
                    if (serverMsg != null) {
                        Object object;
                        if (serverMsg.hasCtrl()) {
                            Model.ServerCtrl serverCtrl = serverMsg.getCtrl();
                            Intrinsics.checkExpressionValueIsNotNull((Object)serverCtrl, (String)"it.ctrl");
                            String string2 = serverCtrl.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.ctrl.id");
                            object = TinodeService.access$getRequest(object.this$0, string2);
                            if (object != null && (object = ((ClientRequest)object).getListener()) != null) {
                                Object object2 = object;
                                object = serverMsg.getCtrl();
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.ctrl");
                                object2.onCtrl((Model.ServerCtrl)object);
                            }
                        } else if (serverMsg.hasMeta()) {
                            Model.ServerMeta serverMeta = serverMsg.getMeta();
                            Intrinsics.checkExpressionValueIsNotNull((Object)serverMeta, (String)"it.meta");
                            String string3 = serverMeta.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.meta.id");
                            object = TinodeService.access$getRequest(object.this$0, string3);
                            if (object != null && (object = ((ClientRequest)object).getListener()) != null) {
                                Object object3 = object;
                                object = serverMsg.getMeta();
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.meta");
                                object3.onMeta((Model.ServerMeta)object);
                            }
                        } else if (serverMsg.hasData()) {
                            Model.ServerData serverData = serverMsg.getData();
                            Intrinsics.checkExpressionValueIsNotNull((Object)serverData, (String)"it.data");
                            String string4 = serverData.getTopic();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it.data.topic");
                            object = TinodeService.access$getRequest(object.this$0, string4);
                            if (object != null && (object = ((ClientRequest)object).getListener()) != null) {
                                Object object4 = object;
                                object = serverMsg.getData();
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.data");
                                object4.onData((Model.ServerData)object);
                            }
                        } else if (serverMsg.hasInfo()) {
                            Model.ServerInfo serverInfo = serverMsg.getInfo();
                            Intrinsics.checkExpressionValueIsNotNull((Object)serverInfo, (String)"it.info");
                            String string5 = serverInfo.getTopic();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"it.info.topic");
                            object = TinodeService.access$getRequest(object.this$0, string5);
                            if (object != null && (object = ((ClientRequest)object).getListener()) != null) {
                                Object object5 = object;
                                object = serverMsg.getInfo();
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.info");
                                object5.onInfo((Model.ServerInfo)object);
                            }
                        } else if (serverMsg.hasPres()) {
                            Model.ServerPres serverPres = serverMsg.getPres();
                            Intrinsics.checkExpressionValueIsNotNull((Object)serverPres, (String)"it.pres");
                            String string6 = serverPres.getTopic();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"it.pres.topic");
                            object = TinodeService.access$getRequest(object.this$0, string6);
                            if (object != null && (object = ((ClientRequest)object).getListener()) != null) {
                                Object object6 = object;
                                object = serverMsg.getPres();
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.pres");
                                object6.onPres((Model.ServerPres)object);
                            }
                        } else {
                            Logger.INSTANCE.log("TinodeService", "Received unknown server message: " + serverMsg);
                        }
                    }
                }

                public void onError(@Nullable Throwable throwable) {
                    Logger.INSTANCE.logException("TinodeService", "onError", throwable);
                    Collection<V> collection = TinodeService.access$getRequestMap$p(this.this$0).values();
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"requestMap.values");
                    Iterator<T> iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Throwable throwable2;
                        ServerResponseListener serverResponseListener = ((ClientRequest)iterator.next()).getListener();
                        if (throwable != null) {
                            throwable2 = throwable;
                        } else {
                            Throwable throwable3;
                            throwable2 = throwable3;
                            throwable3 = new Throwable("TinodeSource Unknown error");
                        }
                        serverResponseListener.onError(throwable2);
                    }
                    this.this$0.disconnect();
                }

                public void onCompleted() {
                    Logger.INSTANCE.log("TinodeService", "onCompleted");
                    Iterator<Map.Entry<K, V>> iterator = TinodeService.access$getRequestMap$p(this.this$0).entrySet().iterator();
                    while (iterator.hasNext()) {
                        ((ClientRequest)iterator.next().getValue()).getListener().onCompleted();
                    }
                    this.this$0.disconnect();
                }
            });
        }
        if (this.state == State.NOT_CONNECTED && this.session.isLoggedIn() && this.isChannelAvailable()) {
            TinodeService tinodeService = this;
            tinodeService.state = State.CONNECTING;
            CompositeDisposable compositeDisposable = tinodeService.compositeDisposable;
            Observable<Model.ServerCtrl> observable = tinodeService.hi(tinodeService.session.getFirebaseToken());
            String string2 = tinodeService.session.getToken();
            if (string2 == null) {
                string2 = "";
            }
            compositeDisposable.add(observable.zipWith(this.login(string2), (BiFunction)client.2.INSTANCE).subscribe(new Consumer<Pair<? extends Model.ServerCtrl, ? extends Boolean>>(this){
                final /* synthetic */ TinodeService this$0;
                {
                    this.this$0 = tinodeService;
                }

                public final void accept(Pair<Model.ServerCtrl, Boolean> pair) {
                    TinodeService.access$setState$p(this.this$0, State.CONNECTED);
                }
            }, new Consumer<Throwable>(this){
                final /* synthetic */ TinodeService this$0;
                {
                    this.this$0 = tinodeService;
                }

                public final void accept(Throwable throwable) {
                    TinodeService.access$setState$p(this.this$0, State.NOT_CONNECTED);
                    Logger.INSTANCE.logException("TinodeService", "Client intialization error", throwable);
                }
            }));
        } else if (!this.isChannelAvailable()) {
            this.mClient = null;
        }
        return this.mClient;
    }

    private final boolean isChannelAvailable() {
        return CollectionsKt.listOf((Object[])new ConnectivityState[]{ConnectivityState.IDLE, ConnectivityState.READY, ConnectivityState.CONNECTING}).contains(this.grpcService.getManagedChannel().getState(true));
    }

    private final Observable<ServerResponse> sendMessage(String string2, Model.ClientMsg clientMsg, boolean bl) {
        StreamObserver<Model.ClientMsg> streamObserver = this.client();
        if (streamObserver != null) {
            Ref.ObjectRef objectRef;
            Ref.ObjectRef objectRef2 = objectRef;
            objectRef2();
            ClientRequest clientRequest = this.requestMap.get(string2);
            objectRef.element = clientRequest;
            if (clientRequest == null) {
                ClientRequest clientRequest2;
                ClientRequest clientRequest3 = clientRequest2;
                objectRef2.element = new ClientRequest(string2, clientMsg);
                this.requestMap.put(string2, clientRequest3);
                this.sendClientMsg(streamObserver, clientMsg);
            } else if (bl) {
                this.sendClientMsg(streamObserver, clientMsg);
            }
            Observable observable = ((ClientRequest)objectRef2.element).getResponseStream().doOnSubscribe(new Consumer<Disposable>(objectRef2){
                final /* synthetic */ Ref.ObjectRef $clientRequest;
                {
                    this.$clientRequest = objectRef;
                }

                public final void accept(Disposable disposable) {
                    ClientRequest clientRequest = (ClientRequest)this.$clientRequest.element;
                    clientRequest.setNumOfListeners(clientRequest.getNumOfListeners() + 1);
                }
            }).doOnDispose(new Action(this, string2){
                final /* synthetic */ TinodeService this$0;
                final /* synthetic */ String $id;
                {
                    this.this$0 = tinodeService;
                    this.$id = string2;
                }

                public final void run() {
                    TinodeService.access$dismissRequest(this.this$0, this.$id);
                }
            }).doOnError(new Consumer<Throwable>(this, string2){
                final /* synthetic */ TinodeService this$0;
                final /* synthetic */ String $id;
                {
                    this.this$0 = tinodeService;
                    this.$id = string2;
                }

                public final void accept(Throwable throwable) {
                    TinodeService.access$dismissRequest(this.this$0, this.$id);
                }
            }).doOnComplete(new Action(this, string2){
                final /* synthetic */ TinodeService this$0;
                final /* synthetic */ String $id;
                {
                    this.this$0 = tinodeService;
                    this.$id = string2;
                }

                public final void run() {
                    TinodeService.access$dismissRequest(this.this$0, this.$id);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"clientRequest.responseSt\u2026te { dismissRequest(id) }");
            return observable;
        }
        Observable observable = Observable.error((Throwable)new IOException("Service not connected, check your connection."));
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.error(IOExcep\u2026check your connection.\"))");
        return observable;
    }

    static /* synthetic */ Observable sendMessage$default(TinodeService tinodeService, String string2, Model.ClientMsg clientMsg, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return tinodeService.sendMessage(string2, clientMsg, bl);
    }

    private final void sendClientMsg(StreamObserver<Model.ClientMsg> streamObserver, Model.ClientMsg clientMsg) {
        if (this.session.isLoggedIn()) {
            try {
                streamObserver.onNext((Object)clientMsg);
            }
            catch (IllegalStateException illegalStateException) {
                Logger.INSTANCE.log("TinodeService", "sendMessage: Client closed");
            }
        }
    }

    private final String getNextId() {
        return String.valueOf(this.messageId.incrementAndGet());
    }

    private final ClientRequest getRequest(String string2) {
        return this.requestMap.get(string2);
    }

    private final void dismissRequest(String string2) {
        ClientRequest clientRequest = this.requestMap.get(string2);
        if (clientRequest != null) {
            ClientRequest clientRequest2 = clientRequest;
            clientRequest2.setNumOfListeners(clientRequest2.getNumOfListeners() + -1);
            if (clientRequest2.getNumOfListeners() == 0) {
                this.requestMap.remove(string2);
            }
        }
    }

    private final Observable<Model.ServerCtrl> hi(String string2) {
        TinodeService tinodeService = this;
        String string3 = tinodeService.getNextId();
        Model.ClientMsg.Builder builder = Model.ClientMsg.newBuilder();
        Model.ClientMsg.Builder builder2 = Model.ClientMsg.newBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"Model.ClientMsg.newBuilder()");
        Model.ClientHi.Builder builder3 = builder2.getHiBuilder().setId(string3).setVer("0.16.5-rc.2").setPlatform("android").setDeviceId(string2);
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        string2 = builder.setHi(builder3.setLang(locale.getLanguage())).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string3, (Model.ClientMsg)string2, false, 4, null).filter((Predicate)hi.1.INSTANCE).flatMap(new Function<T, ObservableSource<? extends R>>(this, string3){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
            }

            @NotNull
            public final Observable<Model.ServerCtrl> apply(@NotNull ServerResponse serverResponse) {
                Intrinsics.checkParameterIsNotNull((Object)serverResponse, (String)"it");
                TinodeService.access$dismissRequest(this.this$0, this.$id);
                return Observable.just((Object)serverResponse.getCtrl());
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026st(it.ctrl)\n            }");
        return observable;
    }

    private final Observable<Boolean> login(String string2) {
        TinodeService tinodeService = this;
        String string3 = tinodeService.getNextId();
        Model.ClientMsg.Builder builder = Model.ClientMsg.newBuilder();
        Model.ClientMsg.Builder builder2 = Model.ClientMsg.newBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"Model.ClientMsg.newBuilder()");
        string2 = builder.setLogin(builder2.getLoginBuilder().setId(string3).setScheme("rest").setSecret(ByteString.copyFrom((String)string2, (String)"UTF-8"))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string3, (Model.ClientMsg)string2, false, 4, null).filter((Predicate)login.1.INSTANCE).flatMap(new Function<T, ObservableSource<? extends R>>(this, string3){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
            }

            @NotNull
            public final Observable<Boolean> apply(@NotNull ServerResponse serverResponse) {
                ServerResponse serverResponse2 = serverResponse;
                Intrinsics.checkParameterIsNotNull((Object)serverResponse2, (String)"it");
                Object object = serverResponse2.getCtrl();
                object = object != null && (object = object.getParamsMap()) != null ? (ByteString)object.get("user") : null;
                if (object != null) {
                    TinodeService.access$getSession$p(this_.this$0).setTinodeUserId((String)GsonUtil.INSTANCE.getDefaultGson().fromJson(object.toString("UTF-8"), String.class));
                }
                TinodeService.access$dismissRequest(this_.this$0, this_.$id);
                login.2 this_ = serverResponse.getCtrl();
                return Observable.just((Object)(this_ != null && this_.getCode() == 200 ? 1 : 0));
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026ode == 200)\n            }");
        return observable;
    }

    private final String buildPermissionString(String string2, Access access) {
        String string3;
        if (StringsKt.startsWith$default((String)string2, (String)"grp", (boolean)false, (int)2, null) && access != null) {
            Set set = CollectionsKt.toMutableSet((Iterable)CollectionsKt.intersect((Iterable)StringsKt.toSet((CharSequence)access.getWant()), (Iterable)StringsKt.toSet((CharSequence)access.getGiven())));
            set.add(Character.valueOf('S'));
            set.remove(Character.valueOf('P'));
            set.add(Character.valueOf('A'));
            string3 = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        } else {
            string3 = StringsKt.startsWith$default((String)string2, (String)"grp", (boolean)false, (int)2, null) && access == null ? "JWRAS" : null;
        }
        return string3;
    }

    public static /* synthetic */ Observable getMessages$default(TinodeService tinodeService, String string2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        return tinodeService.getMessages(string2, n, n2, n3);
    }

    public static /* synthetic */ Observable updateTopicPermission$default(TinodeService tinodeService, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "JWRPAS";
        }
        return tinodeService.updateTopicPermission(string2, string3);
    }

    @Inject
    public TinodeService(@NotNull ChatGrpcService chatGrpcService, @NotNull SessionPrefImpl sessionPrefImpl) {
        TinodeService tinodeService = this;
        Intrinsics.checkParameterIsNotNull((Object)chatGrpcService, (String)"grpcService");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        this.grpcService = chatGrpcService;
        tinodeService.session = sessionPrefImpl;
        RxJavaPlugins.setErrorHandler((Consumer)1.INSTANCE);
        tinodeService.state = State.NOT_CONNECTED;
        tinodeService.messageId = new AtomicInteger();
        tinodeService.requestMap = new ConcurrentHashMap(16, 0.75f, 4);
        tinodeService.compositeDisposable = new CompositeDisposable();
    }

    public static final /* synthetic */ ClientRequest access$getRequest(TinodeService tinodeService, String string2) {
        return tinodeService.getRequest(string2);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getRequestMap$p(TinodeService tinodeService) {
        return tinodeService.requestMap;
    }

    public static final /* synthetic */ State access$getState$p(TinodeService tinodeService) {
        return tinodeService.state;
    }

    public static final /* synthetic */ void access$setState$p(TinodeService tinodeService, State state) {
        tinodeService.state = state;
    }

    public static final /* synthetic */ void access$dismissRequest(TinodeService tinodeService, String string2) {
        tinodeService.dismissRequest(string2);
    }

    public static final /* synthetic */ SessionPrefImpl access$getSession$p(TinodeService tinodeService) {
        return tinodeService.session;
    }

    @NotNull
    public final Observable<Boolean> setFndTopicPhoneNumbers(@NotNull List<? extends List<String>> object) {
        TinodeService tinodeService = this;
        Intrinsics.checkParameterIsNotNull(object, (String)"phoneNumbers");
        String string2 = tinodeService.getNextId();
        object = GsonUtil.INSTANCE.getDefaultGson().toJson((Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.flatten(object), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        object = Model.ClientMsg.newBuilder().setSet(Model.ClientSet.newBuilder().setId(string2).setTopic("fnd").setQuery(Model.SetQuery.newBuilder().setDesc(Model.SetDesc.newBuilder().setPrivate(ByteString.copyFrom((String)object, (String)"UTF-8"))))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string2, (Model.ClientMsg)object, false, 4, null).filter((Predicate)setFndTopicPhoneNumbers.1.INSTANCE).map(new Function<T, R>(this, string2){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
            }

            public final boolean apply(@NotNull ServerResponse serverResponse) {
                Intrinsics.checkParameterIsNotNull((Object)serverResponse, (String)"it");
                TinodeService.access$dismissRequest(this_.this$0, this_.$id);
                setFndTopicPhoneNumbers.2 this_ = serverResponse.getCtrl();
                return this_ != null && this_.getCode() == 200;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026code == 200\n            }");
        return observable;
    }

    @NotNull
    public final Observable<List<TinodeContact>> getContacts() {
        TinodeService tinodeService = tinodeService2;
        TinodeService tinodeService2 = Model.ClientMsg.newBuilder().setSub(Model.ClientSub.newBuilder().setId("me").setTopic("me").setGetQuery(Model.GetQuery.newBuilder().setWhat("sub"))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)tinodeService2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, "me", (Model.ClientMsg)tinodeService2, false, 4, null).filter((Predicate)getContacts.1.INSTANCE).map((Function)getContacts.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026?.map { it.toDomain() } }");
        return observable;
    }

    public final void refreshContacts() {
        TinodeService tinodeService = tinodeService2;
        TinodeService tinodeService2 = Model.ClientMsg.newBuilder().setGet(Model.ClientGet.newBuilder().setId("me").setTopic("me").setQuery(Model.GetQuery.newBuilder().setWhat("sub"))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)tinodeService2, (String)"message");
        tinodeService.sendMessage("me", (Model.ClientMsg)tinodeService2, true);
    }

    @NotNull
    public final Observable<TinodePres> subscribeToContactPresence() {
        TinodeService tinodeService = tinodeService2;
        TinodeService tinodeService2 = Model.ClientMsg.newBuilder().setSub(Model.ClientSub.newBuilder().setId("me").setTopic("me").setGetQuery(Model.GetQuery.newBuilder().setWhat("sub"))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)tinodeService2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, "me", (Model.ClientMsg)tinodeService2, false, 4, null).filter((Predicate)subscribeToContactPresence.1.INSTANCE).map((Function)subscribeToContactPresence.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026p { it.pres?.toDomain() }");
        return observable;
    }

    @NotNull
    public final Observable<List<TinodeContact>> subscribeToFnd() {
        TinodeService tinodeService = tinodeService2;
        TinodeService tinodeService2 = Model.ClientMsg.newBuilder().setSub(Model.ClientSub.newBuilder().setId("fnd").setTopic("fnd").setGetQuery(Model.GetQuery.newBuilder().setWhat("sub"))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)tinodeService2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, "fnd", (Model.ClientMsg)tinodeService2, false, 4, null).filter((Predicate)subscribeToFnd.1.INSTANCE).map((Function)subscribeToFnd.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026?.map { it.toDomain() } }");
        return observable;
    }

    @NotNull
    public final Observable<Boolean> getFndContacts() {
        TinodeService tinodeService = this;
        String string2 = tinodeService.getNextId();
        Model.ClientMsg clientMsg = Model.ClientMsg.newBuilder().setGet(Model.ClientGet.newBuilder().setId(string2).setTopic("fnd").setQuery(Model.GetQuery.newBuilder().setWhat("sub"))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)clientMsg, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string2, clientMsg, false, 4, null).filter((Predicate)getFndContacts.1.INSTANCE).map(new Function<T, R>(this, string2){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
            }

            public final boolean apply(@NotNull ServerResponse serverResponse) {
                Intrinsics.checkParameterIsNotNull((Object)serverResponse, (String)"it");
                TinodeService.access$dismissRequest(this_.this$0, this_.$id);
                getFndContacts.2 this_ = serverResponse.getCtrl();
                return this_ != null && this_.getCode() == 200;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026code == 200\n            }");
        return observable;
    }

    @NotNull
    public final Observable<Boolean> setSubscriptionToTopic(@NotNull String string2, @Nullable Access object) {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"topicId");
        object = tinodeService2.buildPermissionString(string3, (Access)object);
        String string4 = tinodeService2.getNextId();
        Model.ClientMsg.Builder builder = Model.ClientMsg.newBuilder();
        string2 = Model.ClientSub.newBuilder().setId(string4).setTopic(string2);
        if (object != null) {
            string2.setSetQuery(Model.SetQuery.newBuilder().setSub(Model.SetSub.newBuilder().setMode((String)object)));
        }
        TinodeService tinodeService = tinodeService2;
        TinodeService tinodeService2 = builder.setSub((Model.ClientSub.Builder)string2).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)tinodeService2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string4, (Model.ClientMsg)tinodeService2, false, 4, null).filter((Predicate)setSubscriptionToTopic.1.INSTANCE).map((Function)setSubscriptionToTopic.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026 { it.ctrl?.code == 200 }");
        return observable;
    }

    @NotNull
    public final Observable<ChatMessage> subscribeToTopic(@NotNull String string2, @Nullable Access object) {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"topicId");
        object = tinodeService2.buildPermissionString(string3, (Access)object);
        Model.ClientMsg.Builder builder = Model.ClientMsg.newBuilder();
        Model.ClientSub.Builder builder2 = Model.ClientSub.newBuilder().setId(string2).setTopic(string2);
        if (object != null) {
            builder2.setSetQuery(Model.SetQuery.newBuilder().setSub(Model.SetSub.newBuilder().setMode((String)object)));
        }
        TinodeService tinodeService = tinodeService2;
        TinodeService tinodeService2 = builder.setSub(builder2).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)tinodeService2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string2, (Model.ClientMsg)tinodeService2, false, 4, null).filter((Predicate)subscribeToTopic.1.INSTANCE).map((Function)subscribeToTopic.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026          }\n            }");
        return observable;
    }

    @NotNull
    public final Observable<TinodePres> subscribeToTopicPresence(@NotNull String string2, @Nullable Access object) {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"topicId");
        object = tinodeService2.buildPermissionString(string3, (Access)object);
        Model.ClientMsg.Builder builder = Model.ClientMsg.newBuilder();
        Model.ClientSub.Builder builder2 = Model.ClientSub.newBuilder().setId(string2).setTopic(string2);
        if (object != null) {
            builder2.setSetQuery(Model.SetQuery.newBuilder().setSub(Model.SetSub.newBuilder().setMode((String)object)));
        }
        TinodeService tinodeService = tinodeService2;
        TinodeService tinodeService2 = builder.setSub(builder2).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)tinodeService2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string2, (Model.ClientMsg)tinodeService2, false, 4, null).filter((Predicate)subscribeToTopicPresence.1.INSTANCE).map((Function)subscribeToTopicPresence.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026p { it.pres?.toDomain() }");
        return observable;
    }

    @NotNull
    public final Observable<Boolean> unsubscribeFromTopic(@NotNull String string2) {
        TinodeService tinodeService = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        String string3 = tinodeService.getNextId();
        Model.ClientMsg clientMsg = Model.ClientMsg.newBuilder().setLeave(Model.ClientLeave.newBuilder().setId(string3).setTopic(string2).setUnsub(true)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)clientMsg, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string3, clientMsg, false, 4, null).filter((Predicate)unsubscribeFromTopic.1.INSTANCE).map(new Function<T, R>(this, string2, string3){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $topicId;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$topicId = string2;
                this.$id = string3;
            }

            public final boolean apply(@NotNull ServerResponse serverResponse) {
                unsubscribeFromTopic.2 v0 = this_;
                Intrinsics.checkParameterIsNotNull((Object)serverResponse, (String)"it");
                TinodeService.access$dismissRequest(v0.this$0, this_.$topicId);
                TinodeService.access$dismissRequest(v0.this$0, this_.$id);
                unsubscribeFromTopic.2 this_ = serverResponse.getCtrl();
                return this_ != null && this_.getCode() == 200;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026code == 200\n            }");
        return observable;
    }

    @NotNull
    public final Observable<Boolean> getMessages(@NotNull String string2, int n, int n2, int n3) {
        TinodeService tinodeService = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        String string3 = tinodeService.getNextId();
        string2 = Model.ClientMsg.newBuilder().setGet(Model.ClientGet.newBuilder().setId(string3).setTopic(string2).setQuery(Model.GetQuery.newBuilder().setWhat("data").setData(Model.GetOpts.newBuilder().setBeforeId(n2).setSinceId(n).setLimit(n3)))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string3, (Model.ClientMsg)string2, false, 4, null).filter((Predicate)getMessages.1.INSTANCE).map(new Function<T, R>(this, string3){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
            }

            public final boolean apply(@NotNull ServerResponse serverResponse) {
                Intrinsics.checkParameterIsNotNull((Object)serverResponse, (String)"it");
                TinodeService.access$dismissRequest(this_.this$0, this_.$id);
                getMessages.2 this_ = serverResponse.getCtrl();
                return this_ != null && this_.getCode() == 200;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026code == 200\n            }");
        return observable;
    }

    @NotNull
    public final Observable<List<TinodeContact>> getParticipants(@NotNull String string2) {
        TinodeService tinodeService = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        String string3 = tinodeService.getNextId();
        string2 = Model.ClientMsg.newBuilder().setGet(Model.ClientGet.newBuilder().setId(string3).setTopic(string2).setQuery(Model.GetQuery.newBuilder().setWhat("sub"))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string3, (Model.ClientMsg)string2, false, 4, null).filter((Predicate)getParticipants.1.INSTANCE).map(new Function<T, R>(this, string3){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
            }

            @Nullable
            public final List<TinodeContact> apply(@NotNull ServerResponse object) {
                Intrinsics.checkParameterIsNotNull((Object)object, (String)"response");
                TinodeService.access$dismissRequest(iterator.this$0, iterator.$id);
                Iterator<T> iterator = ((ServerResponse)object).getMeta();
                if (iterator != null && (iterator = iterator.getSubList()) != null) {
                    ArrayList<E> arrayList;
                    object = arrayList;
                    arrayList = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Model.TopicSub topicSub = (Model.TopicSub)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)topicSub, (String)"it");
                        object.add(TinodeContactKt.toDomain(topicSub));
                    }
                } else {
                    object = null;
                }
                return object;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026oDomain() }\n            }");
        return observable;
    }

    @NotNull
    public final Observable<Chat> getChat(@NotNull String string2) {
        TinodeService tinodeService = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        String string3 = tinodeService.getNextId();
        string2 = Model.ClientMsg.newBuilder().setGet(Model.ClientGet.newBuilder().setId(string3).setTopic(string2).setQuery(Model.GetQuery.newBuilder().setWhat("desc"))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string3, (Model.ClientMsg)string2, false, 4, null).filter((Predicate)getChat.1.INSTANCE).map(new Function<T, R>(this, string3){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
            }

            @Nullable
            public final Chat apply(@NotNull ServerResponse serverResponse) {
                Intrinsics.checkParameterIsNotNull((Object)serverResponse, (String)"response");
                TinodeService.access$dismissRequest(this_.this$0, this_.$id);
                getChat.2 this_ = serverResponse.getMeta();
                return this_ != null ? ChatKt.toDomainChat$default((Model.ServerMeta)this_, null, 1, null) : null;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026omainChat()\n            }");
        return observable;
    }

    @NotNull
    public final Observable<List<Chat>> getChats() {
        Function function;
        Object object;
        TinodeService tinodeService = this;
        String string2 = tinodeService.getNextId();
        Model.ClientMsg clientMsg = Model.ClientMsg.newBuilder().setGet(Model.ClientGet.newBuilder().setId(string2).setTopic("me").setQuery(Model.GetQuery.newBuilder().setWhat("sub"))).build();
        if (tinodeService.requestMap.contains("me")) {
            object = Observable.just((Object)Boolean.TRUE);
            Intrinsics.checkExpressionValueIsNotNull(object, (String)"Observable.just(true)");
        } else {
            object = this.setSubscriptionToTopic("me", null);
        }
        Observable<Boolean> observable = object;
        object = function;
        function = new Function<T, ObservableSource<? extends R>>(this, string2, clientMsg){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ Model.ClientMsg $message;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
                this.$message = clientMsg;
            }

            public final Observable<List<Chat>> apply(@NotNull Boolean object) {
                Intrinsics.checkParameterIsNotNull((Object)object, (String)"it");
                getChats.1 v0 = this;
                object = v0.$id;
                Model.ClientMsg clientMsg = v0.$message;
                Intrinsics.checkExpressionValueIsNotNull((Object)clientMsg, (String)"message");
                return TinodeService.sendMessage$default(this.this$0, (String)object, clientMsg, false, 4, null).filter((Predicate)getChats.1.INSTANCE).map(new Function<T, R>(this){
                    final /* synthetic */ getChats.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @Nullable
                    public final List<Chat> apply(@NotNull ServerResponse object) {
                        Intrinsics.checkParameterIsNotNull((Object)object, (String)"it");
                        Iterator<T> iterator = iterator.this$0;
                        TinodeService.access$dismissRequest(iterator.this$0, iterator.$id);
                        iterator = ((ServerResponse)object).getMeta();
                        if (iterator != null && (iterator = iterator.getSubList()) != null) {
                            ArrayList<E> arrayList;
                            object = arrayList;
                            arrayList = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
                            iterator = iterator.iterator();
                            while (iterator.hasNext()) {
                                Model.TopicSub topicSub = (Model.TopicSub)iterator.next();
                                Intrinsics.checkExpressionValueIsNotNull((Object)topicSub, (String)"it");
                                object.add(ChatKt.toDomainChat(topicSub));
                            }
                        } else {
                            object = null;
                        }
                        return object;
                    }
                });
            }
        };
        Observable observable2 = observable.flatMap(object);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable2, (String)"if (requestMap.contains(\u2026              }\n        }");
        return observable2;
    }

    @NotNull
    public final Observable<Boolean> sendMessage(@NotNull String string2, @NotNull String string3, @NotNull Map<String, String> object) {
        LinkedHashMap linkedHashMap;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"head");
        String string4 = this.getNextId();
        Model.ClientMsg.Builder builder = Model.ClientMsg.newBuilder();
        string2 = Model.ClientPub.newBuilder().setId(string4).setTopic(string2);
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap(MapsKt.mapCapacity((int)object.size()));
        for (Map.Entry entry : object.entrySet()) {
            linkedHashMap2.put(entry.getKey(), ByteString.copyFromUtf8((String)GsonUtil.INSTANCE.getDefaultGson().toJson((Object)((String)entry.getValue()))));
        }
        string2 = builder.setPub(string2.putAllHead(linkedHashMap2).setContent(ByteString.copyFromUtf8((String)GsonUtil.INSTANCE.getDefaultGson().toJson((Object)string3)))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(this, string4, (Model.ClientMsg)string2, false, 4, null).filter((Predicate)sendMessage.5.INSTANCE).map(new Function<T, R>(this, string4){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
            }

            public final boolean apply(@NotNull ServerResponse serverResponse) {
                Intrinsics.checkParameterIsNotNull((Object)serverResponse, (String)"it");
                TinodeService.access$dismissRequest(this_.this$0, this_.$id);
                sendMessage.6 this_ = serverResponse.getCtrl();
                return this_ != null && this_.getCode() == 202;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026code == 202\n            }");
        return observable;
    }

    @NotNull
    public final Observable<Boolean> setPresenceEnabled(boolean bl) {
        String string2 = tinodeService2.getNextId();
        Model.ClientMsg.Builder builder = Model.ClientMsg.newBuilder();
        Model.ClientSet.Builder builder2 = Model.ClientSet.newBuilder().setId(string2).setTopic("me");
        Model.SetQuery.Builder builder3 = Model.SetQuery.newBuilder();
        Model.SetSub.Builder builder4 = Model.SetSub.newBuilder();
        String string3 = bl ? "JPS" : "JS";
        TinodeService tinodeService = tinodeService2;
        TinodeService tinodeService2 = builder.setSet(builder2.setQuery(builder3.setSub(builder4.setMode(string3)))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)tinodeService2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string2, (Model.ClientMsg)tinodeService2, false, 4, null).filter((Predicate)setPresenceEnabled.1.INSTANCE).map((Function)setPresenceEnabled.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026 { it.ctrl?.code == 200 }");
        return observable;
    }

    @NotNull
    public final Observable<Boolean> triggerOfflineStatus() {
        TinodeService tinodeService = this;
        String string2 = tinodeService.getNextId();
        Model.ClientMsg clientMsg = Model.ClientMsg.newBuilder().setLeave(Model.ClientLeave.newBuilder().setId(string2).setTopic("me").setUnsub(false)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)clientMsg, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string2, clientMsg, false, 4, null).filter((Predicate)triggerOfflineStatus.1.INSTANCE).map(new Function<T, R>(this, string2){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
            }

            public final boolean apply(@NotNull ServerResponse serverResponse) {
                Intrinsics.checkParameterIsNotNull((Object)serverResponse, (String)"it");
                TinodeService.access$dismissRequest(this_.this$0, this_.$id);
                triggerOfflineStatus.2 this_ = serverResponse.getCtrl();
                return this_ != null && this_.getCode() == 200;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026code == 200\n            }");
        return observable;
    }

    @NotNull
    public final Observable<Boolean> triggerOnlineStatus() {
        TinodeService tinodeService = this;
        String string2 = tinodeService.getNextId();
        Model.ClientMsg clientMsg = Model.ClientMsg.newBuilder().setSub(Model.ClientSub.newBuilder().setId(string2).setTopic("me")).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)clientMsg, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string2, clientMsg, false, 4, null).filter((Predicate)triggerOnlineStatus.1.INSTANCE).map(new Function<T, R>(this, string2){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
            }

            public final boolean apply(@NotNull ServerResponse serverResponse) {
                Intrinsics.checkParameterIsNotNull((Object)serverResponse, (String)"it");
                TinodeService.access$dismissRequest(this_.this$0, this_.$id);
                triggerOnlineStatus.2 this_ = serverResponse.getCtrl();
                return this_ != null && this_.getCode() == 200;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026code == 200\n            }");
        return observable;
    }

    @NotNull
    public final Observable<Model.ServerMeta> updatePublicInfo(@NotNull TinodeUserPublic object) {
        TinodeService tinodeService = this;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"publicInfo");
        object = GsonUtil.INSTANCE.getDefaultGson().toJson(object);
        String string2 = tinodeService.getNextId();
        object = Model.ClientMsg.newBuilder().setSet(Model.ClientSet.newBuilder().setId(string2).setTopic("me").setQuery(Model.SetQuery.newBuilder().setDesc(Model.SetDesc.newBuilder().setPublic(ByteString.copyFrom((String)object, (String)"UTF-8"))))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string2, (Model.ClientMsg)object, false, 4, null).filter((Predicate)updatePublicInfo.1.INSTANCE).map(new Function<T, R>(this, string2){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
            }

            @Nullable
            public final Model.ServerMeta apply(@NotNull ServerResponse serverResponse) {
                Intrinsics.checkParameterIsNotNull((Object)serverResponse, (String)"it");
                TinodeService.access$dismissRequest(this.this$0, this.$id);
                return serverResponse.getMeta();
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026    it.meta\n            }");
        return observable;
    }

    @NotNull
    public final Observable<Chat> createTopic(@NotNull TinodeUserPublic tinodeUserPublic) {
        TinodeService tinodeService = this;
        Intrinsics.checkParameterIsNotNull((Object)tinodeUserPublic, (String)"info");
        String string2 = GsonUtil.INSTANCE.getDefaultGson().toJson((Object)tinodeUserPublic);
        String string3 = tinodeService.getNextId();
        string2 = Model.ClientMsg.newBuilder().setSub(Model.ClientSub.newBuilder().setId(string3).setTopic("new").setSetQuery(Model.SetQuery.newBuilder().setDesc(Model.SetDesc.newBuilder().setPublic(ByteString.copyFrom((String)string2, (String)"UTF-8")).setDefaultAcs(Model.DefaultAcsMode.newBuilder().setAnon("N").setAuth("JWRPAS")))).setGetQuery(Model.GetQuery.newBuilder().setWhat("desc"))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string3, (Model.ClientMsg)string2, false, 4, null).filter((Predicate)createTopic.1.INSTANCE).map(new Function<T, R>(this, string3, tinodeUserPublic){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ TinodeUserPublic $info;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
                this.$info = tinodeUserPublic;
            }

            @Nullable
            public final Chat apply(@NotNull ServerResponse serverResponse) {
                Intrinsics.checkParameterIsNotNull((Object)serverResponse, (String)"response");
                TinodeService.access$dismissRequest(this.this$0, this.$id);
                serverResponse = serverResponse.getCtrl();
                return serverResponse != null ? ChatKt.toDomainChat((Model.ServerCtrl)serverResponse, this.$info.getFn()) : null;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026at(info.fn)\n            }");
        return observable;
    }

    @NotNull
    public final Observable<Boolean> inviteUserToTopic(@NotNull String string2, @NotNull String string3) {
        TinodeService tinodeService = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"userId");
        String string4 = tinodeService.getNextId();
        string2 = Model.ClientMsg.newBuilder().setSet(Model.ClientSet.newBuilder().setId(string4).setTopic(string2).setQuery(Model.SetQuery.newBuilder().setSub(Model.SetSub.newBuilder().setUserId(string3).setMode("JWRPAS")))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string4, (Model.ClientMsg)string2, false, 4, null).filter((Predicate)inviteUserToTopic.1.INSTANCE).map(new Function<T, R>(this, string4){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
            }

            public final boolean apply(@NotNull ServerResponse serverResponse) {
                Intrinsics.checkParameterIsNotNull((Object)serverResponse, (String)"it");
                TinodeService.access$dismissRequest(this_.this$0, this_.$id);
                inviteUserToTopic.2 this_ = serverResponse.getCtrl();
                return this_ != null && this_.getCode() == 200;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026code == 200\n            }");
        return observable;
    }

    @NotNull
    public final Observable<Boolean> deleteTopic(@NotNull String string2) {
        TinodeService tinodeService = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        String string3 = tinodeService.getNextId();
        string2 = Model.ClientMsg.newBuilder().setDel(Model.ClientDel.newBuilder().setTopic(string2).setWhat(Model.ClientDel.What.TOPIC).setHard(true)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string3, (Model.ClientMsg)string2, false, 4, null).filter((Predicate)deleteTopic.1.INSTANCE).map(new Function<T, R>(this, string3){
            final /* synthetic */ TinodeService this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = tinodeService;
                this.$id = string2;
            }

            public final boolean apply(@NotNull ServerResponse serverResponse) {
                Intrinsics.checkParameterIsNotNull((Object)serverResponse, (String)"it");
                TinodeService.access$dismissRequest(this_.this$0, this_.$id);
                deleteTopic.2 this_ = serverResponse.getCtrl();
                return this_ != null && this_.getCode() == 200;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026code == 200\n            }");
        return observable;
    }

    @NotNull
    public final Observable<Boolean> updateTopicPermission(@NotNull String string2, @NotNull String string3) {
        TinodeService tinodeService = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"permissions");
        String string4 = tinodeService.getNextId();
        Model.ClientMsg clientMsg = Model.ClientMsg.newBuilder().setSet(Model.ClientSet.newBuilder().setTopic(string2).setQuery(Model.SetQuery.newBuilder().setSub(Model.SetSub.newBuilder().setUserId(this.session.getTinodeUserId()).setMode(string3)))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)clientMsg, (String)"message");
        Observable observable = TinodeService.sendMessage$default(tinodeService, string4, clientMsg, false, 4, null).filter((Predicate)updateTopicPermission.1.INSTANCE).map((Function)updateTopicPermission.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(id, message)\u2026 { it.ctrl?.code == 200 }");
        return observable;
    }

    public final void disconnect() {
        TinodeService tinodeService = this;
        tinodeService.compositeDisposable.dispose();
        tinodeService.compositeDisposable = new CompositeDisposable();
        StreamObserver<Model.ClientMsg> streamObserver = tinodeService.mClient;
        if (streamObserver != null) {
            streamObserver.onCompleted();
        }
        this.mClient = null;
        this.requestMap.clear();
        this.state = State.NOT_CONNECTED;
        Logger.INSTANCE.log("TinodeService", "Client disconnected");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001f\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lio/streamlayer/common/data/tinode/TinodeService$ClientRequest;", "", "id", "", "msg", "Lpbx/Model$ClientMsg;", "(Ljava/lang/String;Lpbx/Model$ClientMsg;)V", "getId", "()Ljava/lang/String;", "listener", "Lio/streamlayer/common/data/tinode/TinodeService$ServerResponseListener;", "getListener", "()Lio/streamlayer/common/data/tinode/TinodeService$ServerResponseListener;", "getMsg", "()Lpbx/Model$ClientMsg;", "numOfListeners", "", "getNumOfListeners", "()I", "setNumOfListeners", "(I)V", "responseStream", "Lio/reactivex/subjects/PublishSubject;", "Lio/streamlayer/common/data/tinode/TinodeService$ServerResponse;", "kotlin.jvm.PlatformType", "getResponseStream", "()Lio/reactivex/subjects/PublishSubject;", "sdk_originalVoximplantRelease"})
    private static final class ClientRequest {
        private int numOfListeners;
        @NotNull
        private final PublishSubject<ServerResponse> responseStream;
        @NotNull
        private final ServerResponseListener listener;
        @NotNull
        private final String id;
        @NotNull
        private final Model.ClientMsg msg;

        public ClientRequest(@NotNull String object, @NotNull Model.ClientMsg clientMsg) {
            ServerResponseListener serverResponseListener;
            Intrinsics.checkParameterIsNotNull((Object)object, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)clientMsg, (String)"msg");
            this.id = object;
            this.msg = clientMsg;
            object = PublishSubject.create();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"PublishSubject.create<ServerResponse>()");
            this.responseStream = object;
            object = serverResponseListener;
            serverResponseListener = new ServerResponseListener(this){
                @NotNull
                private final ServerResponse response;
                final /* synthetic */ ClientRequest this$0;
                {
                    this.this$0 = clientRequest;
                    this.response = new ServerResponse(clientRequest.getId(), null, null, null, null, null, 62, null);
                }

                @NotNull
                public final ServerResponse getResponse() {
                    return this.response;
                }

                public void onCtrl(@NotNull Model.ServerCtrl serverCtrl) {
                    Intrinsics.checkParameterIsNotNull((Object)serverCtrl, (String)"msg");
                    this.this$0.getResponseStream().onNext((Object)ServerResponse.copy$default(this.response, null, serverCtrl, null, null, null, null, 61, null));
                }

                public void onMeta(@NotNull Model.ServerMeta serverMeta) {
                    Intrinsics.checkParameterIsNotNull((Object)serverMeta, (String)"msg");
                    this.this$0.getResponseStream().onNext((Object)ServerResponse.copy$default(this.response, null, null, serverMeta, null, null, null, 59, null));
                }

                public void onData(@NotNull Model.ServerData serverData) {
                    Intrinsics.checkParameterIsNotNull((Object)serverData, (String)"msg");
                    this.this$0.getResponseStream().onNext((Object)ServerResponse.copy$default(this.response, null, null, null, serverData, null, null, 55, null));
                }

                public void onInfo(@NotNull Model.ServerInfo serverInfo) {
                    Intrinsics.checkParameterIsNotNull((Object)serverInfo, (String)"msg");
                    this.this$0.getResponseStream().onNext((Object)ServerResponse.copy$default(this.response, null, null, null, null, serverInfo, null, 47, null));
                }

                public void onPres(@NotNull Model.ServerPres serverPres) {
                    Intrinsics.checkParameterIsNotNull((Object)serverPres, (String)"msg");
                    this.this$0.getResponseStream().onNext((Object)ServerResponse.copy$default(this.response, null, null, null, null, null, serverPres, 31, null));
                }

                public void onError(@NotNull Throwable throwable) {
                    Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"t");
                    Logger.INSTANCE.log("TinodeService", "onError: " + this.this$0.getId());
                    this.this$0.getResponseStream().onError(throwable);
                }

                public void onCompleted() {
                    this.this$0.getResponseStream().onComplete();
                }
            };
            this.listener = object;
        }

        public final int getNumOfListeners() {
            return this.numOfListeners;
        }

        public final void setNumOfListeners(int n) {
            this.numOfListeners = n;
        }

        @NotNull
        public final PublishSubject<ServerResponse> getResponseStream() {
            return this.responseStream;
        }

        @NotNull
        public final ServerResponseListener getListener() {
            return this.listener;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final Model.ClientMsg getMsg() {
            return this.msg;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BK\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\rH\u00c6\u0003JO\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lio/streamlayer/common/data/tinode/TinodeService$ServerResponse;", "", "id", "", "ctrl", "Lpbx/Model$ServerCtrl;", "meta", "Lpbx/Model$ServerMeta;", "data", "Lpbx/Model$ServerData;", "info", "Lpbx/Model$ServerInfo;", "pres", "Lpbx/Model$ServerPres;", "(Ljava/lang/String;Lpbx/Model$ServerCtrl;Lpbx/Model$ServerMeta;Lpbx/Model$ServerData;Lpbx/Model$ServerInfo;Lpbx/Model$ServerPres;)V", "getCtrl", "()Lpbx/Model$ServerCtrl;", "getData", "()Lpbx/Model$ServerData;", "getId", "()Ljava/lang/String;", "getInfo", "()Lpbx/Model$ServerInfo;", "getMeta", "()Lpbx/Model$ServerMeta;", "getPres", "()Lpbx/Model$ServerPres;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "sdk_originalVoximplantRelease"})
    private static final class ServerResponse {
        @NotNull
        private final String id;
        @Nullable
        private final Model.ServerCtrl ctrl;
        @Nullable
        private final Model.ServerMeta meta;
        @Nullable
        private final Model.ServerData data;
        @Nullable
        private final Model.ServerInfo info;
        @Nullable
        private final Model.ServerPres pres;

        public ServerResponse(@NotNull String string2, @Nullable Model.ServerCtrl serverCtrl, @Nullable Model.ServerMeta serverMeta, @Nullable Model.ServerData serverData, @Nullable Model.ServerInfo serverInfo, @Nullable Model.ServerPres serverPres) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"id");
            this.id = string2;
            this.ctrl = serverCtrl;
            this.meta = serverMeta;
            this.data = serverData;
            this.info = serverInfo;
            this.pres = serverPres;
        }

        public /* synthetic */ ServerResponse(String string2, Model.ServerCtrl serverCtrl, Model.ServerMeta serverMeta, Model.ServerData serverData, Model.ServerInfo serverInfo, Model.ServerPres serverPres, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string2 = "";
            }
            if ((n & 2) != 0) {
                serverCtrl = null;
            }
            if ((n & 4) != 0) {
                serverMeta = null;
            }
            if ((n & 8) != 0) {
                serverData = null;
            }
            if ((n & 0x10) != 0) {
                serverInfo = null;
            }
            if ((n & 0x20) != 0) {
                serverPres = null;
            }
            this(string2, serverCtrl, serverMeta, serverData, serverInfo, serverPres);
        }

        public ServerResponse() {
            this(null, null, null, null, null, null, 63, null);
        }

        public static /* synthetic */ ServerResponse copy$default(ServerResponse serverResponse, String string2, Model.ServerCtrl serverCtrl, Model.ServerMeta serverMeta, Model.ServerData serverData, Model.ServerInfo serverInfo, Model.ServerPres serverPres, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = serverResponse.id;
            }
            if ((n & 2) != 0) {
                serverCtrl = serverResponse.ctrl;
            }
            if ((n & 4) != 0) {
                serverMeta = serverResponse.meta;
            }
            if ((n & 8) != 0) {
                serverData = serverResponse.data;
            }
            if ((n & 0x10) != 0) {
                serverInfo = serverResponse.info;
            }
            if ((n & 0x20) != 0) {
                serverPres = serverResponse.pres;
            }
            return serverResponse.copy(string2, serverCtrl, serverMeta, serverData, serverInfo, serverPres);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final Model.ServerCtrl getCtrl() {
            return this.ctrl;
        }

        @Nullable
        public final Model.ServerMeta getMeta() {
            return this.meta;
        }

        @Nullable
        public final Model.ServerData getData() {
            return this.data;
        }

        @Nullable
        public final Model.ServerInfo getInfo() {
            return this.info;
        }

        @Nullable
        public final Model.ServerPres getPres() {
            return this.pres;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @Nullable
        public final Model.ServerCtrl component2() {
            return this.ctrl;
        }

        @Nullable
        public final Model.ServerMeta component3() {
            return this.meta;
        }

        @Nullable
        public final Model.ServerData component4() {
            return this.data;
        }

        @Nullable
        public final Model.ServerInfo component5() {
            return this.info;
        }

        @Nullable
        public final Model.ServerPres component6() {
            return this.pres;
        }

        @NotNull
        public final ServerResponse copy(@NotNull String string2, @Nullable Model.ServerCtrl serverCtrl, @Nullable Model.ServerMeta serverMeta, @Nullable Model.ServerData serverData, @Nullable Model.ServerInfo serverInfo, @Nullable Model.ServerPres serverPres) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"id");
            return new ServerResponse(string2, serverCtrl, serverMeta, serverData, serverInfo, serverPres);
        }

        @NotNull
        public String toString() {
            return "ServerResponse(id=" + this.id + ", ctrl=" + this.ctrl + ", meta=" + this.meta + ", data=" + this.data + ", info=" + this.info + ", pres=" + this.pres + ")";
        }

        public int hashCode() {
            String string2 = this.id;
            int n = (string2 != null ? string2.hashCode() : 0) * 31;
            Model.ServerCtrl serverCtrl = this.ctrl;
            int n2 = serverCtrl != null ? serverCtrl.hashCode() : 0;
            n = (n + n2) * 31;
            Model.ServerMeta serverMeta = this.meta;
            int n3 = serverMeta != null ? serverMeta.hashCode() : 0;
            n = (n + n3) * 31;
            Model.ServerData serverData = this.data;
            int n4 = serverData != null ? serverData.hashCode() : 0;
            n = (n + n4) * 31;
            Model.ServerInfo serverInfo = this.info;
            int n5 = serverInfo != null ? serverInfo.hashCode() : 0;
            int n6 = (n + n5) * 31;
            Model.ServerPres serverPres = this.pres;
            int n7 = serverPres != null ? serverPres.hashCode() : 0;
            return n6 + n7;
        }

        public boolean equals(@Nullable Object object) {
            block2: {
                block3: {
                    if (this == object) break block2;
                    if (!(object instanceof ServerResponse)) break block3;
                    object = (ServerResponse)object;
                    if (Intrinsics.areEqual((Object)this.id, (Object)((ServerResponse)object).id) && Intrinsics.areEqual((Object)this.ctrl, (Object)((ServerResponse)object).ctrl) && Intrinsics.areEqual((Object)this.meta, (Object)((ServerResponse)object).meta) && Intrinsics.areEqual((Object)this.data, (Object)((ServerResponse)object).data) && Intrinsics.areEqual((Object)this.info, (Object)((ServerResponse)object).info) && Intrinsics.areEqual((Object)this.pres, (Object)((ServerResponse)object).pres)) break block2;
                }
                return false;
            }
            return true;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\rH&J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u000fH&J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0011H&\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/common/data/tinode/TinodeService$ServerResponseListener;", "", "onCompleted", "", "onCtrl", "msg", "Lpbx/Model$ServerCtrl;", "onData", "Lpbx/Model$ServerData;", "onError", "t", "", "onInfo", "Lpbx/Model$ServerInfo;", "onMeta", "Lpbx/Model$ServerMeta;", "onPres", "Lpbx/Model$ServerPres;", "sdk_originalVoximplantRelease"})
    private static interface ServerResponseListener {
        public void onCtrl(@NotNull Model.ServerCtrl var1);

        public void onMeta(@NotNull Model.ServerMeta var1);

        public void onData(@NotNull Model.ServerData var1);

        public void onInfo(@NotNull Model.ServerInfo var1);

        public void onPres(@NotNull Model.ServerPres var1);

        public void onError(@NotNull Throwable var1);

        public void onCompleted();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/common/data/tinode/TinodeService$State;", "", "(Ljava/lang/String;I)V", "NOT_CONNECTED", "CONNECTING", "CONNECTED", "sdk_originalVoximplantRelease"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State NOT_CONNECTED;
        public static final /* enum */ State CONNECTING;
        public static final /* enum */ State CONNECTED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State state;
            State state2;
            State state3;
            State[] stateArray = new State[3];
            State state4 = state3;
            NOT_CONNECTED = new State();
            stateArray[0] = state4;
            state4 = state2;
            CONNECTING = new State();
            stateArray[1] = state4;
            state4 = state;
            CONNECTED = new State();
            stateArray[2] = state4;
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }
    }
}

