/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.analytics;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.analytics.AnalyticsEvent;
import io.streamlayer.sdk.model.analytics.AnalyticsEventType;
import io.streamlayer.sdk.repository.analytics.AnalyticsDao;
import java.util.ArrayList;
import java.util.List;

public final class AnalyticsDao_Impl
implements AnalyticsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AnalyticsEvent> __insertionAdapterOfAnalyticsEvent;
    private final Converters __converters;
    private final EntityDeletionOrUpdateAdapter<AnalyticsEvent> __deletionAdapterOfAnalyticsEvent;

    public AnalyticsDao_Impl(RoomDatabase roomDatabase) {
        EntityDeletionOrUpdateAdapter<AnalyticsEvent> entityDeletionOrUpdateAdapter;
        EntityInsertionAdapter<AnalyticsEvent> entityInsertionAdapter;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<AnalyticsEvent>(roomDatabase){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `AnalyticsEvent` (`id`,`type`,`payload`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, AnalyticsEvent analyticsEvent) {
                if (analyticsEvent.getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    long l = analyticsEvent.getId();
                    supportSQLiteStatement.bindLong(1, l);
                }
                Object object = object.AnalyticsDao_Impl.this.__converters.analyticsEventTypeToString(analyticsEvent.getType());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                if (analyticsEvent.getPayload() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, analyticsEvent.getPayload());
                }
            }
        };
        this.__insertionAdapterOfAnalyticsEvent = converters2;
        converters2 = entityDeletionOrUpdateAdapter;
        entityDeletionOrUpdateAdapter = new EntityDeletionOrUpdateAdapter<AnalyticsEvent>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `AnalyticsEvent` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, AnalyticsEvent analyticsEvent) {
                if (analyticsEvent.getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    long l = analyticsEvent.getId();
                    supportSQLiteStatement.bindLong(1, l);
                }
            }
        };
        this.__deletionAdapterOfAnalyticsEvent = converters2;
    }

    @Override
    public void saveAnalyticsEvent(AnalyticsEvent analyticsEvent) {
        AnalyticsDao_Impl analyticsDao_Impl = this;
        analyticsDao_Impl.__db.assertNotSuspendingTransaction();
        analyticsDao_Impl.__db.beginTransaction();
        try {
            analyticsDao_Impl.__insertionAdapterOfAnalyticsEvent.insert((Object)analyticsEvent);
            analyticsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        analyticsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteAnalyticsEvents(List<AnalyticsEvent> list) {
        AnalyticsDao_Impl analyticsDao_Impl = this;
        analyticsDao_Impl.__db.assertNotSuspendingTransaction();
        analyticsDao_Impl.__db.beginTransaction();
        try {
            analyticsDao_Impl.__deletionAdapterOfAnalyticsEvent.handleMultiple(list);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        analyticsDao_Impl.__db.setTransactionSuccessful();
        analyticsDao_Impl.__db.endTransaction();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<AnalyticsEvent> getAnalyticsEvents(int n) {
        ArrayList<AnalyticsEvent> arrayList;
        int n2;
        int n3;
        int n4;
        AnalyticsDao_Impl analyticsDao_Impl = this;
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM AnalyticsEvent LIMIT ?", (int)1);
        long l = n;
        roomSQLiteQuery.bindLong(1, l);
        analyticsDao_Impl.__db.assertNotSuspendingTransaction();
        Cursor cursor = DBUtil.query((RoomDatabase)analyticsDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        try {
            n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"id");
            n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
            n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"payload");
        }
        catch (Throwable throwable) {
            cursor.close();
            roomSQLiteQuery.release();
            throw throwable;
        }
        ArrayList<AnalyticsEvent> arrayList2 = arrayList;
        arrayList = new ArrayList<AnalyticsEvent>(cursor.getCount());
        while (cursor.moveToNext()) {
            Long l2 = cursor.isNull(n4) ? null : Long.valueOf(cursor.getLong(n4));
            String string2 = cursor.getString(n3);
            AnalyticsEventType analyticsEventType = this.__converters.stringToAnalyticsEventType(string2);
            String string3 = cursor.getString(n2);
            arrayList2.add(new AnalyticsEvent(l2, analyticsEventType, string3));
        }
        cursor.close();
        roomSQLiteQuery.release();
        return arrayList2;
    }
}

