/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.callstatus;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.sdk.model.calls.CallConnectionStatus;
import io.streamlayer.sdk.model.calls.CallParticipantStatus;
import io.streamlayer.sdk.model.calls.CallStatus;
import io.streamlayer.sdk.model.calls.ParticipantStatus;
import io.streamlayer.sdk.model.tinodecontact.TinodePres;
import io.streamlayer.sdk.repository.callstatus.CallStatusRepo;
import io.streamlayer.sdk.repository.callstatus.CallStatusRepoImplKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/sdk/repository/callstatus/CallStatusRepoImpl;", "Lio/streamlayer/sdk/repository/callstatus/CallStatusRepo;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "(Lio/streamlayer/common/data/database/AppDatabase;)V", "observeCallStatus", "Lio/reactivex/Observable;", "Lio/streamlayer/sdk/model/calls/CallStatus;", "callId", "", "processParticipantPresence", "presence", "Lio/streamlayer/sdk/model/tinodecontact/TinodePres;", "reduceParticipantCallStates", "Lio/streamlayer/sdk/model/calls/CallConnectionStatus;", "states", "", "Lio/streamlayer/sdk/model/calls/ParticipantStatus;", "sdk_originalVoximplantRelease"})
public final class CallStatusRepoImpl
implements CallStatusRepo {
    private final AppDatabase database;

    /*
     * Enabled aggressive block sorting
     */
    private final CallConnectionStatus reduceParticipantCallStates(List<? extends ParticipantStatus> object) {
        boolean bl;
        CallConnectionStatus callConnectionStatus;
        if (object.contains((Object)ParticipantStatus.Online)) {
            callConnectionStatus = CallConnectionStatus.Connected;
            return callConnectionStatus;
        }
        if (!(object instanceof Collection) || !object.isEmpty()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ParticipantStatus participantStatus = (ParticipantStatus)((Object)iterator.next());
                if (!ArraysKt.contains((Object[])new ParticipantStatus[]{ParticipantStatus.Pending}, (Object)((Object)participantStatus))) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            callConnectionStatus = CallConnectionStatus.Connecting;
            return callConnectionStatus;
        }
        callConnectionStatus = CallConnectionStatus.Idle;
        return callConnectionStatus;
    }

    @Inject
    public CallStatusRepoImpl(@NotNull AppDatabase appDatabase) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"database");
        this.database = appDatabase;
    }

    public static final /* synthetic */ CallConnectionStatus access$reduceParticipantCallStates(CallStatusRepoImpl callStatusRepoImpl, List list) {
        return callStatusRepoImpl.reduceParticipantCallStates(list);
    }

    public static final /* synthetic */ AppDatabase access$getDatabase$p(CallStatusRepoImpl callStatusRepoImpl) {
        return callStatusRepoImpl.database;
    }

    @Override
    @NotNull
    public Observable<CallStatus> processParticipantPresence(@NotNull TinodePres tinodePres) {
        Intrinsics.checkParameterIsNotNull((Object)tinodePres, (String)"presence");
        String cfr_ignored_0 = "processParticipantPresence: " + tinodePres;
        Observable observable = this.database.callDao().getCallStatus(tinodePres.getTopic()).defaultIfEmpty((Object)new CallStatus(tinodePres.getTopic(), CallConnectionStatus.Idle, CollectionsKt.emptyList())).flatMapObservable(new Function<T, ObservableSource<? extends R>>(this, tinodePres){
            final /* synthetic */ CallStatusRepoImpl this$0;
            final /* synthetic */ TinodePres $presence;
            {
                this.this$0 = callStatusRepoImpl;
                this.$presence = tinodePres;
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Observable<CallStatus> apply(@NotNull CallStatus callStatus) {
                ArrayList<E> arrayList;
                Object object;
                Object object2;
                boolean bl;
                Object object32;
                CallStatus callStatus2 = callStatus;
                Intrinsics.checkParameterIsNotNull((Object)callStatus2, (String)"callStatus");
                List list = CollectionsKt.toMutableList(callStatus2.getParticipantStatuses());
                if (!(list instanceof Collection) || !list.isEmpty()) {
                    for (Object object32 : list) {
                        if (!Intrinsics.areEqual((Object)this.$presence.getChatUserId(), (Object)((CallParticipantStatus)object32).getUserId())) continue;
                        bl = false;
                        break;
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    list.add(CallStatusRepoImplKt.toCallParticipantStatus(this.$presence));
                } else {
                    block9: {
                        for (Object object32 : list) {
                            object2 = (CallParticipantStatus)object32;
                            if (!Intrinsics.areEqual((Object)this.$presence.getChatUserId(), (Object)((CallParticipantStatus)object2).getUserId())) continue;
                            break block9;
                        }
                        object32 = null;
                    }
                    object = object32;
                    if (object != null) {
                        list.remove(object);
                        list.add(CallParticipantStatus.copy$default((CallParticipantStatus)object, null, CallStatusRepoImplKt.toParticipantStatus(this.$presence), 1, null));
                    }
                }
                object = null;
                object32 = this.this$0;
                object2 = arrayList;
                arrayList = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)list, (int)10));
                Iterator<T> iterator = list.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        callStatus = CallStatus.copy$default(callStatus, (String)object, CallStatusRepoImpl.access$reduceParticipantCallStates((CallStatusRepoImpl)object32, CollectionsKt.toList((Iterable)object2)), list, 1, null);
                        String cfr_ignored_0 = "processParticipantPresence newCallStatus: " + callStatus;
                        CallStatusRepoImpl.access$getDatabase$p(this.this$0).callDao().saveCallStatus(callStatus);
                        return Observable.just((Object)callStatus);
                    }
                    object2.add(((CallParticipantStatus)iterator.next()).getStatus());
                }
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"database.callDao().getCa\u2026CallStatus)\n            }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<CallStatus> observeCallStatus(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"callId");
        Observable observable = this.database.callDao().observeCallStatus(string2).defaultIfEmpty((Object)new CallStatus(string2, CallConnectionStatus.Idle, CollectionsKt.emptyList()));
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"database.callDao()\n     \u2026tatus.Idle, emptyList()))");
        return observable;
    }
}

