/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.calls.recent;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.Chronometer;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.bornfight.utils.adapters.GenericAdapter;
import com.google.android.material.button.MaterialButton;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.calls.recent.CallsAdapter;
import io.streamlayer.sdk.messaging.MessagingExtensionsKt;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import io.streamlayer.utils.AcronymDrawable;
import io.streamlayer.utils.DateUtil;
import io.streamlayer.utils.ExtensionsKt;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0014J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\tH\u0014J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/streamlayer/sdk/calls/recent/CallsAdapter;", "Lcom/bornfight/utils/adapters/GenericAdapter;", "Lio/streamlayer/sdk/model/messaging/Chat;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "(Lio/streamlayer/common/session/SessionPrefImpl;)V", "listener", "Lio/streamlayer/sdk/calls/recent/CallsAdapter$CallsInteractionListener;", "getItemViewType", "", "position", "getLayoutId", "viewType", "getViewHolder", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "view", "Landroid/view/View;", "setInteractionListener", "", "setItems", "listItems", "", "ActiveCallViewHolder", "CallsInteractionListener", "ChatsDiffCallback", "RecentCallViewHolder", "sdk_originalVoximplantRelease"})
public final class CallsAdapter
extends GenericAdapter<Chat> {
    private CallsInteractionListener listener;
    private final SessionPrefImpl session;

    public CallsAdapter(@NotNull SessionPrefImpl sessionPrefImpl) {
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        this.session = sessionPrefImpl;
    }

    public static final /* synthetic */ void access$setListener$p(CallsAdapter callsAdapter, CallsInteractionListener callsInteractionListener) {
        callsAdapter.listener = callsInteractionListener;
    }

    public final void setInteractionListener(@NotNull CallsInteractionListener callsInteractionListener) {
        Intrinsics.checkParameterIsNotNull((Object)callsInteractionListener, (String)"listener");
        this.listener = callsInteractionListener;
    }

    public void setItems(@NotNull List<Chat> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"listItems");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new ChatsDiffCallback(this.getListItems(), list));
        CallsAdapter callsAdapter = this;
        Intrinsics.checkExpressionValueIsNotNull((Object)diffResult, (String)"DiffUtil.calculateDiff(\n\u2026s\n            )\n        )");
        callsAdapter.getListItems().clear();
        callsAdapter.getListItems().addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)callsAdapter);
    }

    public int getItemViewType(int n) {
        Chat cfr_ignored_0 = (Chat)this.getItem(n);
        return n < 0 ? 1 : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getLayoutId(int n) {
        int n2;
        if (n != 0) {
            if (n != 1) throw new RuntimeException("Invalid ViewHolder type: " + n);
            n2 = R.layout.slr_item_call_active;
            return n2;
        } else {
            n2 = R.layout.slr_item_call_recent;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected GenericAdapter.GenericViewHolder<Chat> getViewHolder(@NotNull View view, int n) {
        RecentCallViewHolder recentCallViewHolder;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (n != 0) {
            ActiveCallViewHolder activeCallViewHolder;
            if (n != 1) throw new RuntimeException("Invalid ViewHolder type: " + n);
            recentCallViewHolder = activeCallViewHolder;
            activeCallViewHolder = new ActiveCallViewHolder(this, view);
            return recentCallViewHolder;
        } else {
            RecentCallViewHolder recentCallViewHolder2;
            recentCallViewHolder = recentCallViewHolder2;
            recentCallViewHolder2 = new RecentCallViewHolder(this, view);
        }
        return recentCallViewHolder;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0096\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/calls/recent/CallsAdapter$RecentCallViewHolder;", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/messaging/Chat;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/calls/recent/CallsAdapter;Landroid/view/View;)V", "bind", "", "data", "getChatName", "", "loadImage", "sdk_originalVoximplantRelease"})
    public class RecentCallViewHolder
    extends GenericAdapter.GenericViewHolder<Chat> {
        final /* synthetic */ CallsAdapter this$0;

        private final String getChatName(Chat chat) {
            Object object = ((RecentCallViewHolder)((Object)object)).this$0.session.getTinodeUserId();
            if (object == null) {
                object = "";
            }
            Chat chat2 = chat;
            object = MessagingExtensionsKt.participantsWithoutUser(chat2, (String)object);
            if (chat2.getChatType() == ChatType.P2P) {
                return chat.getName();
            }
            if (object.size() <= 1) {
                if ((object = (TinodeContact)CollectionsKt.firstOrNull((List)object)) == null || (object = ((TinodeContact)object).getChatName()) == null) {
                    object = chat.getName();
                }
                return object;
            }
            Object object2 = object;
            object = getChatName.1.INSTANCE;
            return CollectionsKt.joinToString$default((Iterable)object2, (CharSequence)", ", null, null, (int)0, null, (Function1)object, (int)30, null);
        }

        private final void loadImage(Chat chat) {
            Object object = this.this$0.session.getTinodeUserId();
            if (object == null) {
                object = "";
            }
            Chat chat2 = chat;
            object = MessagingExtensionsKt.participantsWithoutUser(chat2, (String)object);
            if (chat2.getChatType() != ChatType.P2P && object.size() != 1) {
                RecentCallViewHolder recentCallViewHolder = this;
                View view = recentCallViewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                ((ImageView)view.findViewById(R.id.slVoiceCallIV)).setBackgroundResource(R.drawable.slr_shape_circle);
                View view2 = recentCallViewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView");
                ((ImageView)view2.findViewById(R.id.slVoiceCallIV)).setImageResource(R.drawable.slr_ic_contact_group);
                if (recentCallViewHolder instanceof ActiveCallViewHolder) {
                    RecentCallViewHolder recentCallViewHolder2 = this;
                    View view3 = recentCallViewHolder2.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"itemView");
                    ImageView imageView = (ImageView)view3.findViewById(R.id.slVoiceCallIV);
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"itemView.slVoiceCallIV");
                    Drawable drawable2 = imageView.getBackground();
                    View view4 = this.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"itemView");
                    drawable2.setTint(ContextCompat.getColor((Context)view4.getContext(), (int)R.color.slr_white));
                    View view5 = recentCallViewHolder2.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"itemView");
                    ImageView imageView2 = (ImageView)view5.findViewById(R.id.slVoiceCallIV);
                    View view6 = this.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view6, (String)"itemView");
                    imageView2.setColorFilter(ContextCompat.getColor((Context)view6.getContext(), (int)R.color.slr_green_a80));
                } else {
                    RecentCallViewHolder recentCallViewHolder3 = this;
                    View view7 = recentCallViewHolder3.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view7, (String)"itemView");
                    ImageView imageView = (ImageView)view7.findViewById(R.id.slVoiceCallIV);
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"itemView.slVoiceCallIV");
                    Drawable drawable3 = imageView.getBackground();
                    View view8 = this.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view8, (String)"itemView");
                    drawable3.setTint(ContextCompat.getColor((Context)view8.getContext(), (int)R.color.slr_primaryBlue));
                    View view9 = recentCallViewHolder3.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view9, (String)"itemView");
                    ImageView imageView3 = (ImageView)view9.findViewById(R.id.slVoiceCallIV);
                    View view10 = this.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view10, (String)"itemView");
                    imageView3.setColorFilter(ContextCompat.getColor((Context)view10.getContext(), (int)R.color.slr_white));
                }
            } else {
                RecentCallViewHolder recentCallViewHolder = this;
                View view = recentCallViewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                ImageView imageView = (ImageView)view.findViewById(R.id.slVoiceCallIV);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"itemView.slVoiceCallIV");
                imageView.setColorFilter(null);
                View view11 = recentCallViewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view11, (String)"itemView");
                ImageView imageView4 = (ImageView)view11.findViewById(R.id.slVoiceCallIV);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView4, (String)"itemView.slVoiceCallIV");
                imageView4.setBackground(null);
                object = (TinodeContact)CollectionsKt.firstOrNull((List)object);
                if (object != null) {
                    if (this instanceof ActiveCallViewHolder) {
                        View view12 = this.itemView;
                        Intrinsics.checkExpressionValueIsNotNull((Object)view12, (String)"itemView");
                        ImageView imageView5 = (ImageView)view12.findViewById(R.id.slVoiceCallIV);
                        Intrinsics.checkExpressionValueIsNotNull((Object)imageView5, (String)"itemView.slVoiceCallIV");
                        ProfileExtensionsKt.loadContactAvatar$default(imageView5, (TinodeContact)object, null, 2, null);
                    } else {
                        View view13 = this.itemView;
                        Intrinsics.checkExpressionValueIsNotNull((Object)view13, (String)"itemView");
                        ImageView imageView6 = (ImageView)view13.findViewById(R.id.slVoiceCallIV);
                        Intrinsics.checkExpressionValueIsNotNull((Object)imageView6, (String)"itemView.slVoiceCallIV");
                        ProfileExtensionsKt.loadContactAvatarWithStatus$default(imageView6, (TinodeContact)object, null, 2, null);
                    }
                } else {
                    View view14 = this.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view14, (String)"itemView");
                    ((ImageView)view14.findViewById(R.id.slVoiceCallIV)).setImageDrawable((Drawable)new AcronymDrawable(chat.getName(), 0.0f, false, null, null, 30, null));
                }
            }
        }

        public RecentCallViewHolder(@NotNull CallsAdapter callsAdapter, View view) {
            View view2 = view;
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            this.this$0 = callsAdapter;
            super(view);
            view2.setOnClickListener(new View.OnClickListener(){

                public final void onClick(View object) {
                    object = this$0.listener;
                    if (object != null) {
                        Object object2 = object2.this;
                        object.onCallClick((Chat)((RecentCallViewHolder)((Object)object2)).this$0.getItem(object2.getLayoutPosition()));
                    }
                }
            });
            callsAdapter = (ImageButton)view2.findViewById(R.id.slVoiceCallCallNudgeBtn);
            if (callsAdapter != null) {
                View.OnClickListener onClickListener;
                CallsAdapter callsAdapter2 = callsAdapter;
                callsAdapter = onClickListener;
                onClickListener = new View.OnClickListener(){

                    public final void onClick(View object) {
                        object = this$0.listener;
                        if (object != null) {
                            Object object2 = object2.this;
                            object.onNudgeSendClick((Chat)((RecentCallViewHolder)((Object)object2)).this$0.getItem(object2.getLayoutPosition()));
                        }
                    }
                };
                callsAdapter2.setOnClickListener((View.OnClickListener)callsAdapter);
            }
        }

        public void bind(@NotNull Chat chat) {
            RecentCallViewHolder recentCallViewHolder = object2;
            Chat chat2 = chat;
            Intrinsics.checkParameterIsNotNull((Object)chat2, (String)"data");
            recentCallViewHolder.loadImage(chat2);
            View view = recentCallViewHolder.itemView;
            Object object = (TextView)view.findViewById(R.id.slVoiceCallNameTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"slVoiceCallNameTV");
            object.setText((CharSequence)((RecentCallViewHolder)((Object)object2)).getChatName(chat));
            object = chat.getLastMessage();
            TextView textView = (TextView)view.findViewById(R.id.slVoiceCallTimeTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"slVoiceCallTimeTV");
            object = (object != null ? ((ChatMessage)object).getDate() : null) != null ? DateUtil.INSTANCE.toRelativeTimeString(((ChatMessage)object).getDate()) : (chat.getUpdatedAt() != null ? DateUtil.INSTANCE.toRelativeTimeString(chat.getUpdatedAt()) : "");
            textView.setText((CharSequence)object);
            Object object2 = MessagingExtensionsKt.participantsWithoutUser(chat, ((RecentCallViewHolder)((Object)object2)).this$0.session.getTinodeUserId());
            if (object2.size() == 1 && (object2 = (TinodeContact)CollectionsKt.firstOrNull((List)object2)) != null && !((TinodeContact)object2).getOnline()) {
                object2 = (ImageButton)view.findViewById(R.id.slVoiceCallCallNudgeBtn);
                if (object2 != null) {
                    io.streamlayer.common.kotlin.ExtensionsKt.visible((View)object2);
                }
            } else {
                object2 = (ImageButton)view.findViewById(R.id.slVoiceCallCallNudgeBtn);
                if (object2 != null) {
                    io.streamlayer.common.kotlin.ExtensionsKt.gone((View)object2);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/streamlayer/sdk/calls/recent/CallsAdapter$ActiveCallViewHolder;", "Lio/streamlayer/sdk/calls/recent/CallsAdapter$RecentCallViewHolder;", "Lio/streamlayer/sdk/calls/recent/CallsAdapter;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/calls/recent/CallsAdapter;Landroid/view/View;)V", "bind", "", "data", "Lio/streamlayer/sdk/model/messaging/Chat;", "sdk_originalVoximplantRelease"})
    public final class ActiveCallViewHolder
    extends RecentCallViewHolder {
        final /* synthetic */ CallsAdapter this$0;

        public ActiveCallViewHolder(@NotNull CallsAdapter callsAdapter, View view) {
            View view2 = view;
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            this.this$0 = callsAdapter;
            super(callsAdapter, view);
            view2.setOnClickListener(new View.OnClickListener(){

                public final void onClick(View object) {
                    object = this$0.listener;
                    if (object != null) {
                        Object object2 = object2.this;
                        object.onActiveCallJoinClick((Chat)((ActiveCallViewHolder)((Object)object2)).this$0.getItem(object2.getLayoutPosition()));
                    }
                }
            });
            ((MaterialButton)view2.findViewById(R.id.slVoiceCallJoinBtn)).setOnClickListener(new View.OnClickListener(){

                public final void onClick(View object) {
                    object = this$0.listener;
                    if (object != null) {
                        Object object2 = object2.this;
                        object.onActiveCallJoinClick((Chat)((ActiveCallViewHolder)((Object)object2)).this$0.getItem(object2.getLayoutPosition()));
                    }
                }
            });
        }

        @Override
        public void bind(@NotNull Chat object) {
            ActiveCallViewHolder activeCallViewHolder = activeCallViewHolder2;
            Chat chat = object;
            Intrinsics.checkParameterIsNotNull((Object)chat, (String)"data");
            super.bind(chat);
            ActiveCallViewHolder activeCallViewHolder2 = (Chronometer)activeCallViewHolder.itemView.findViewById(R.id.slVoiceCallActiveChronometer);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)activeCallViewHolder2), (String)"slVoiceCallActiveChronometer");
            object = ((Chat)object).getUpdatedAt();
            object = object != null ? Long.valueOf(((Date)object).getTime()) : null;
            ExtensionsKt.startTimer((Chronometer)activeCallViewHolder2, (Long)object);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/sdk/calls/recent/CallsAdapter$ChatsDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldItems", "", "Lio/streamlayer/sdk/model/messaging/Chat;", "newItems", "(Ljava/util/List;Ljava/util/List;)V", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "getNewListSize", "getOldListSize", "sdk_originalVoximplantRelease"})
    private static final class ChatsDiffCallback
    extends DiffUtil.Callback {
        private final List<Chat> oldItems;
        private final List<Chat> newItems;

        public ChatsDiffCallback(@NotNull List<Chat> list, @NotNull List<Chat> list2) {
            Intrinsics.checkParameterIsNotNull(list, (String)"oldItems");
            Intrinsics.checkParameterIsNotNull(list2, (String)"newItems");
            this.oldItems = list;
            this.newItems = list2;
        }

        public boolean areItemsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldItems.get(n).getChatId(), (Object)this.newItems.get(n2).getChatId());
        }

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        public boolean areContentsTheSame(int n, int n2) {
            Chat chat = ((ChatsDiffCallback)((Object)chat2)).oldItems.get(n);
            Chat chat2 = ((ChatsDiffCallback)((Object)chat2)).newItems.get(n2);
            return Intrinsics.areEqual((Object)chat.getUpdatedAt(), (Object)chat2.getUpdatedAt()) && Intrinsics.areEqual(chat.getParticipants(), chat2.getParticipants());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lio/streamlayer/sdk/calls/recent/CallsAdapter$CallsInteractionListener;", "", "onActiveCallJoinClick", "", "item", "Lio/streamlayer/sdk/model/messaging/Chat;", "onCallClick", "onNudgeSendClick", "sdk_originalVoximplantRelease"})
    public static interface CallsInteractionListener {
        public void onCallClick(@NotNull Chat var1);

        public void onNudgeSendClick(@NotNull Chat var1);

        public void onActiveCallJoinClick(@NotNull Chat var1);
    }
}

