/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.call;

import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.sdk.model.calls.CallIdiom;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.repository.call.CallRepo;
import io.streamlayer.sdk.repository.call.CallRepoImpl;
import io.streamlayer.sdk.repository.messaging.MessagingRepo;
import java.nio.charset.Charset;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0016J8\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000e2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/streamlayer/sdk/repository/call/CallRepoImpl;", "Lio/streamlayer/sdk/repository/call/CallRepo;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "messagingRepo", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "(Lio/streamlayer/common/data/database/AppDatabase;Lio/streamlayer/sdk/repository/messaging/MessagingRepo;)V", "getOldCallMessages", "Lio/reactivex/Single;", "", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "topicId", "", "observeCallMessages", "Lio/reactivex/Observable;", "userId", "sendCallIdiom", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "", "chatId", "idiom", "Lio/streamlayer/sdk/model/calls/CallIdiom;", "payload", "reply", "sdk_originalVoximplantRelease"})
public final class CallRepoImpl
implements CallRepo {
    private final AppDatabase database;
    private final MessagingRepo messagingRepo;

    @Inject
    public CallRepoImpl(@NotNull AppDatabase appDatabase, @NotNull MessagingRepo messagingRepo) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)messagingRepo, (String)"messagingRepo");
        this.database = appDatabase;
        this.messagingRepo = messagingRepo;
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> sendCallIdiom(@NotNull String string2, @NotNull CallIdiom callIdiom, @Nullable String string3, @Nullable String string4) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)callIdiom), (String)"idiom");
        Object object = string3 != null ? string3 : "";
        Object object2 = Charsets.UTF_8;
        if (object != null) {
            String string5;
            CallRepoImpl callRepoImpl = object3;
            byte[] byArray = ((String)object).getBytes((Charset)object2);
            Object object3 = byArray;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            object = Charsets.UTF_8;
            object2 = string5;
            string5 = new String((byte[])object3, (Charset)object);
            String cfr_ignored_0 = "\u2b06\ufe0f [idiom=" + callIdiom.getKey() + "; payload=" + string3 + "; reply=" + string4 + ']';
            object3 = callIdiom.getKey();
            return callRepoImpl.messagingRepo.sendMessage(string2, (String)object2, "voice", (String)object3, string4);
        }
        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
    }

    @Override
    @NotNull
    public Observable<ChatMessage> observeCallMessages(@NotNull String string2, @Nullable String string3) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        Observable observable = MessagingRepo.DefaultImpls.subscribeToChat$default(this.messagingRepo, string2, null, false, 4, null).filter(new Predicate<ChatMessage>(string3){
            final /* synthetic */ String $userId;
            {
                this.$userId = string2;
            }

            public final boolean test(@NotNull ChatMessage chatMessage) {
                ChatMessage chatMessage2 = chatMessage;
                Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"it");
                return Intrinsics.areEqual((Object)chatMessage2.getType(), (Object)"voice") && Intrinsics.areEqual((Object)this.$userId, (Object)chatMessage.getSenderUserId()) ^ true;
            }
        }).distinctUntilChanged((BiPredicate)observeCallMessages.2.INSTANCE).doOnNext((Consumer)observeCallMessages.3.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"messagingRepo.subscribeT\u2026          )\n            }");
        return observable;
    }

    @Override
    @NotNull
    public Single<List<ChatMessage>> getOldCallMessages(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        Single single = this.database.messagingDao().getChatMessages(string2, null, null, 100).map((Function)getOldCallMessages.1.INSTANCE).first((Object)CollectionsKt.emptyList());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"database.messagingDao().\u2026     }.first(emptyList())");
        return single;
    }
}

