/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.messaging;

import androidx.lifecycle.LiveData;
import androidx.paging.LivePagedListKt;
import androidx.paging.PagedList;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.common.data.notifications.InAppNotificationsService;
import io.streamlayer.common.data.tinode.TinodeService;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.mvvm.basemodels.Status;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.messaging.MessagingExtensionsKt;
import io.streamlayer.sdk.model.calls.CallStatus;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef;
import io.streamlayer.sdk.model.messaging.WaveMessage;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.model.tinodecontact.TinodePres;
import io.streamlayer.sdk.model.tinodecontact.TinodeUserPublic;
import io.streamlayer.sdk.model.tinodecontact.TinodeWhat;
import io.streamlayer.sdk.repository.RxRepoExtKt;
import io.streamlayer.sdk.repository.callstatus.CallStatusRepo;
import io.streamlayer.sdk.repository.messaging.MessagingDao;
import io.streamlayer.sdk.repository.messaging.MessagingRepo;
import io.streamlayer.sdk.repository.messaging.MessagingRepoImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ2\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0015H\u0016J7\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00140\u000f0\u000e2\u0006\u0010 \u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J2\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\u0006\u0010 \u001a\u00020\u00152\b\b\u0002\u0010'\u001a\u00020\"2\b\b\u0002\u0010(\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\"J\u001c\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u001e\u001a\u00020\u0015H\u0016J\"\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00140\u000f0\u000e2\u0006\u0010+\u001a\u00020\u0017H\u0016J9\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00140\u000f0\u000e2\u0006\u0010 \u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0002\u0010$J\"\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u00140\u000f0\u000e2\u0006\u0010\u001e\u001a\u00020\u0015H\u0016J*\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000f0\u000e2\u0006\u0010\u001e\u001a\u00020\u00152\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001c\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c02012\u0006\u0010 \u001a\u00020\u0015H\u0016J\u001c\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000f0\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001c\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000f0\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J$\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000f0\u000e2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u0015H\u0016JB\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000f0\u000e2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u00152\b\u00107\u001a\u0004\u0018\u00010\u00152\b\u00108\u001a\u0004\u0018\u00010\u00152\b\u00109\u001a\u0004\u0018\u00010\u0015H\u0016J$\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000f0\u000e2\u0006\u0010;\u001a\u00020.2\u0006\u00106\u001a\u00020\u0015H\u0016J(\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\u0006\u0010 \u001a\u00020\u00152\b\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020\u0017H\u0016J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eH\u0016J.\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lio/streamlayer/sdk/repository/messaging/MessagingRepoImpl;", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "tinode", "Lio/streamlayer/common/data/tinode/TinodeService;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "callStatusRepo", "Lio/streamlayer/sdk/repository/callstatus/CallStatusRepo;", "inAppNotificationsService", "Lio/streamlayer/common/data/notifications/InAppNotificationsService;", "(Lio/streamlayer/common/data/database/AppDatabase;Lio/streamlayer/common/data/tinode/TinodeService;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/sdk/repository/callstatus/CallStatusRepo;Lio/streamlayer/common/data/notifications/InAppNotificationsService;)V", "createChat", "Lio/reactivex/Observable;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "Lio/streamlayer/sdk/model/messaging/Chat;", "data", "Lio/streamlayer/sdk/model/tinodecontact/TinodeUserPublic;", "userIds", "", "", "forceNewChat", "", "createNewChat", "deleteMessage", "", "item", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "deleteUnsentMessages", "chatId", "fetchMessages", "topicId", "beforeSeqId", "", "limit", "(Ljava/lang/String;Ljava/lang/Integer;I)Lio/reactivex/Observable;", "fetchTinodeParticipants", "fetchTopicMessages", "sinceId", "beforeId", "getChat", "getChats", "isCall", "getMessages", "getParticipants", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "inviteUsersToChat", "paginatedMessagesSource", "Landroidx/lifecycle/LiveData;", "Landroidx/paging/PagedList;", "resendMessage", "resendMessageProcessing", "sendMessage", "content", "type", "subtype", "reply", "sendWaveMessage", "contact", "subscribeToChat", "access", "Lio/streamlayer/sdk/model/messaging/Access;", "isVoiceCall", "subscribeToWaveMessages", "triggerMessageLoad", "sdk_originalVoximplantRelease"})
public final class MessagingRepoImpl
implements MessagingRepo {
    private final AppDatabase database;
    private final TinodeService tinode;
    private final SessionPrefImpl session;
    private final CallStatusRepo callStatusRepo;
    private final InAppNotificationsService inAppNotificationsService;

    public static /* synthetic */ Observable fetchTopicMessages$default(MessagingRepoImpl messagingRepoImpl, String string2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 30;
        }
        return messagingRepoImpl.fetchTopicMessages(string2, n, n2, n3);
    }

    private final Observable<Boolean> fetchTinodeParticipants(String string2) {
        Observable observable = this.tinode.getParticipants(string2).flatMap(new Function<T, ObservableSource<? extends R>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = messagingRepoImpl;
                this.$chatId = string2;
            }

            @NotNull
            public final Observable<Boolean> apply(@NotNull List<TinodeContact> object) {
                ArrayList<E> arrayList;
                Object object2;
                ArrayList<ChatParticipantCrossRef> arrayList2;
                ArrayList<E> arrayList3;
                Iterator<T> iterator = object;
                Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"it");
                object = arrayList3;
                arrayList3 = new ArrayList<E>();
                Object object4 = iterator.iterator();
                while (object4.hasNext()) {
                    T object32 = object4.next();
                    if (!StringsKt.startsWith$default((String)((TinodeContact)object32).getChatUserId(), (String)"usr", (boolean)false, (int)2, null)) continue;
                    object.add(object32);
                }
                fetchTinodeParticipants.1 v2 = this;
                MessagingRepoImpl.access$getDatabase$p(v2.this$0).tinodeContactDao().insertTinodeContacts((List<TinodeContact>)((Object)object));
                object4 = MessagingRepoImpl.access$getDatabase$p(v2.this$0).messagingDao();
                ArrayList<ChatParticipantCrossRef> arrayList4 = arrayList2;
                arrayList2 = new ArrayList<ChatParticipantCrossRef>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)object), (int)10));
                Object object3 = object.iterator();
                while (object3.hasNext()) {
                    object2 = (TinodeContact)object3.next();
                    TinodeContact tinodeContact = object2;
                    object2 = this.$chatId;
                    arrayList4.add(new ChatParticipantCrossRef((String)object2, tinodeContact.getChatUserId()));
                }
                object4.saveChatParticipantCrossRefs(arrayList4);
                object4 = arrayList;
                arrayList = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)object), (int)10));
                object = object.iterator();
                while (object.hasNext()) {
                    TinodeContact tinodeContact = (TinodeContact)object.next();
                    object3 = tinodeContact.getOnline() && (object3 = tinodeContact.getAccess()) != null && (object3 = ((Access)object3).getWant()) != null && StringsKt.contains$default((CharSequence)object3, (char)'W', (boolean)false, (int)2, null) ? TinodeWhat.ON : (!tinodeContact.getOnline() && (object3 = tinodeContact.getAccess()) != null && (object3 = ((Access)object3).getWant()) != null && !StringsKt.contains$default((CharSequence)object3, (char)'W', (boolean)false, (int)2, null) ? TinodeWhat.OFF : TinodeWhat.UNRECOGNIZED);
                    TinodeContact tinodeContact2 = tinodeContact;
                    String string2 = this.$chatId;
                    object2 = tinodeContact2.getChatUserId();
                    Access access = tinodeContact2.getAccess();
                    object4.add(MessagingRepoImpl.access$getCallStatusRepo$p(this.this$0).processParticipantPresence(new TinodePres(string2, (String)object2, (TinodeWhat)((Object)object3), access)));
                }
                return Observable.merge((Iterable)object4).toList().flatMapObservable((Function)fetchTinodeParticipants.3.INSTANCE);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"tinode.getParticipants(c\u2026le.just(true) }\n        }");
        return observable;
    }

    private final Observable<Chat> createNewChat(TinodeUserPublic tinodeUserPublic, List<String> list) {
        Observable observable = this.tinode.createTopic(tinodeUserPublic).flatMap(new Function<T, ObservableSource<? extends R>>(this, list){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ List $userIds;
            {
                this.this$0 = messagingRepoImpl;
                this.$userIds = list;
            }

            @NotNull
            public final Observable<Chat> apply(@NotNull Chat chat) {
                Intrinsics.checkParameterIsNotNull((Object)chat, (String)"newChat");
                return Observable.fromIterable((Iterable)this.$userIds).flatMapSingle(new Function<T, SingleSource<? extends R>>(this, chat){
                    final /* synthetic */ createNewChat.1 this$0;
                    final /* synthetic */ Chat $newChat;
                    {
                        this.this$0 = var1_1;
                        this.$newChat = chat;
                    }

                    public final Single<Boolean> apply(@NotNull String string2) {
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"userId");
                        return MessagingRepoImpl.access$getTinode$p(this.this$0.this$0).inviteUserToTopic(this.$newChat.getChatId(), string2).first((Object)Boolean.FALSE);
                    }
                }).toList().flatMapObservable(new Function<T, ObservableSource<? extends R>>(this, chat){
                    final /* synthetic */ createNewChat.1 this$0;
                    final /* synthetic */ Chat $newChat;
                    {
                        this.this$0 = var1_1;
                        this.$newChat = chat;
                    }

                    @NotNull
                    public final Observable<Chat> apply(@NotNull List<Boolean> object) {
                        ArrayList<ChatParticipantCrossRef> arrayList;
                        createNewChat.2 v0 = this;
                        Intrinsics.checkParameterIsNotNull(object, (String)"it");
                        MessagingRepoImpl.access$getDatabase$p(v0.this$0.this$0).messagingDao().saveChats(CollectionsKt.listOf((Object)this.$newChat));
                        object = MessagingRepoImpl.access$getDatabase$p(v0.this$0.this$0).messagingDao();
                        Object object2 = v0.this$0.$userIds;
                        ArrayList<ChatParticipantCrossRef> arrayList2 = arrayList;
                        arrayList = new ArrayList<ChatParticipantCrossRef>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
                        object2 = object2.iterator();
                        while (object2.hasNext()) {
                            String string2 = (String)object2.next();
                            arrayList2.add(new ChatParticipantCrossRef(this.$newChat.getChatId(), string2));
                        }
                        object.saveChatParticipantCrossRefs(arrayList2);
                        return Observable.just((Object)this.$newChat);
                    }
                });
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"tinode.createTopic(data)\u2026              }\n        }");
        return observable;
    }

    @Inject
    public MessagingRepoImpl(@NotNull AppDatabase appDatabase, @NotNull TinodeService tinodeService, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull CallStatusRepo callStatusRepo, @NotNull InAppNotificationsService inAppNotificationsService) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)tinodeService, (String)"tinode");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)callStatusRepo, (String)"callStatusRepo");
        Intrinsics.checkParameterIsNotNull((Object)inAppNotificationsService, (String)"inAppNotificationsService");
        this.database = appDatabase;
        this.tinode = tinodeService;
        this.session = sessionPrefImpl;
        this.callStatusRepo = callStatusRepo;
        this.inAppNotificationsService = inAppNotificationsService;
    }

    public static final /* synthetic */ AppDatabase access$getDatabase$p(MessagingRepoImpl messagingRepoImpl) {
        return messagingRepoImpl.database;
    }

    public static final /* synthetic */ TinodeService access$getTinode$p(MessagingRepoImpl messagingRepoImpl) {
        return messagingRepoImpl.tinode;
    }

    public static final /* synthetic */ InAppNotificationsService access$getInAppNotificationsService$p(MessagingRepoImpl messagingRepoImpl) {
        return messagingRepoImpl.inAppNotificationsService;
    }

    public static final /* synthetic */ Observable access$fetchTinodeParticipants(MessagingRepoImpl messagingRepoImpl, String string2) {
        return messagingRepoImpl.fetchTinodeParticipants(string2);
    }

    public static final /* synthetic */ CallStatusRepo access$getCallStatusRepo$p(MessagingRepoImpl messagingRepoImpl) {
        return messagingRepoImpl.callStatusRepo;
    }

    public static final /* synthetic */ SessionPrefImpl access$getSession$p(MessagingRepoImpl messagingRepoImpl) {
        return messagingRepoImpl.session;
    }

    public static final /* synthetic */ Observable access$createNewChat(MessagingRepoImpl messagingRepoImpl, TinodeUserPublic tinodeUserPublic, List list) {
        return messagingRepoImpl.createNewChat(tinodeUserPublic, list);
    }

    @Override
    @NotNull
    public LiveData<PagedList<ChatMessage>> paginatedMessagesSource(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        return LivePagedListKt.toLiveData$default(this.database.messagingDao().getChatMessagesLiveData(string2), (int)30, null, null, null, (int)14, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<List<ChatMessage>>> getMessages(@NotNull String string2, @Nullable Integer n, int n2) {
        Function1<List<? extends ChatMessage>, Unit> function1;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        Function0<Observable<List<? extends ChatMessage>>> function0 = new Function0<Observable<List<? extends ChatMessage>>>(this, string2, n, n2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            final /* synthetic */ Integer $beforeSeqId;
            final /* synthetic */ int $limit;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
                this.$beforeSeqId = n;
                this.$limit = n2;
                super(0);
            }

            public final Observable<List<ChatMessage>> invoke() {
                getMessages.1 v0 = object;
                Object object = v0.$topicId;
                Integer n = v0.$beforeSeqId;
                int n2 = v0.$limit;
                return MessagingRepoImpl.access$getDatabase$p(object.this$0).messagingDao().getChatMessages((String)object, n, null, n2);
            }
        };
        Function0<Observable<List<ChatMessage>>> function02 = new Function0<Observable<List<ChatMessage>>>(this, string2, n, n2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            final /* synthetic */ Integer $beforeSeqId;
            final /* synthetic */ int $limit;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
                this.$beforeSeqId = n;
                this.$limit = n2;
                super(0);
            }

            public final Observable<List<ChatMessage>> invoke() {
                getMessages.2 v0 = this;
                MessagingRepoImpl messagingRepoImpl = v0.this$0;
                String string2 = v0.$topicId;
                int n = 0;
                Integer n2 = v0.$beforeSeqId;
                int n3 = n2 != null ? n2 : 0;
                int n4 = this.$limit;
                Observable observable = messagingRepoImpl.fetchTopicMessages(string2, n, n3, n4).toList().toObservable();
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"fetchTopicMessages(topic\u2026).toList().toObservable()");
                return observable;
            }
        };
        string2 = function1;
        function1 = new Function1<List<? extends ChatMessage>, Unit>(this){
            final /* synthetic */ MessagingRepoImpl this$0;
            {
                this.this$0 = messagingRepoImpl;
                super(1);
            }

            public final void invoke(List<ChatMessage> list) {
                MessagingDao messagingDao = MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao();
                List<ChatMessage> list2 = list;
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it");
                messagingDao.saveChatMessages(list2);
            }
        };
        return RxRepoExtKt.twoSideCall(function0, function02, string2);
    }

    @NotNull
    public final Observable<ResourceState<List<ChatMessage>>> fetchMessages(@NotNull String string2, @Nullable Integer n, int n2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        return RxRepoExtKt.oneSideCall$default((Function0)new Function0<Observable<List<ChatMessage>>>(this, string2, n, n2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            final /* synthetic */ Integer $beforeSeqId;
            final /* synthetic */ int $limit;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
                this.$beforeSeqId = n;
                this.$limit = n2;
                super(0);
            }

            public final Observable<List<ChatMessage>> invoke() {
                fetchMessages.1 v0 = this;
                MessagingRepoImpl messagingRepoImpl = v0.this$0;
                String string2 = v0.$topicId;
                int n = 0;
                Integer n2 = v0.$beforeSeqId;
                int n3 = n2 != null ? n2 : 0;
                int n4 = this.$limit;
                return messagingRepoImpl.fetchTopicMessages(string2, n, n3, n4).toList().toObservable();
            }
        }, null, null, 6, null);
    }

    @NotNull
    public final Observable<ChatMessage> fetchTopicMessages(@NotNull String string2, int n, int n2, int n3) {
        MessagingRepoImpl messagingRepoImpl = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        messagingRepoImpl.inAppNotificationsService.pauseNotifications(true, string2);
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        Observable observable = Observable.mergeDelayError((ObservableSource)messagingRepoImpl.tinode.subscribeToTopic(string2, null, false).flatMap(new Function<T, ObservableSource<? extends R>>(this){
            final /* synthetic */ MessagingRepoImpl this$0;
            {
                this.this$0 = messagingRepoImpl;
            }

            @NotNull
            public final Observable<ChatMessage> apply(@NotNull ChatMessage chatMessage) {
                Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"message");
                MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().saveOrUpdateChatMessage(chatMessage);
                return Observable.just((Object)chatMessage);
            }
        }), (ObservableSource)Observable.just((Object)Boolean.TRUE).delay(100L, timeUnit).flatMap(new Function<T, ObservableSource<? extends R>>(this, string2, n, n2, n3){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            final /* synthetic */ int $sinceId;
            final /* synthetic */ int $beforeId;
            final /* synthetic */ int $limit;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
                this.$sinceId = n;
                this.$beforeId = n2;
                this.$limit = n3;
            }

            public final Observable<ChatMessage> apply(@NotNull Boolean object) {
                Intrinsics.checkParameterIsNotNull((Object)object, (String)"it");
                fetchTopicMessages.2 v0 = this;
                object = v0.$topicId;
                int n = v0.$sinceId;
                int n2 = v0.$beforeId;
                int n3 = v0.$limit;
                return MessagingRepoImpl.access$getTinode$p(this.this$0).getMessages((String)object, n, n2, n3).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ fetchTopicMessages.2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<ChatMessage> apply(@NotNull Boolean bl) {
                        Intrinsics.checkParameterIsNotNull((Object)bl, (String)"it");
                        MessagingRepoImpl.access$getInAppNotificationsService$p(this.this$0.this$0).pauseNotifications(false, this.this$0.$topicId);
                        return Observable.empty();
                    }
                });
            }
        }), (ObservableSource)this.tinode.subscribeToTopicPresence(string2, null, false).flatMap(new Function<T, ObservableSource<? extends R>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
            }

            public final Observable<ChatMessage> apply(@NotNull TinodePres tinodePres) {
                TinodePres tinodePres2 = tinodePres;
                Intrinsics.checkParameterIsNotNull((Object)tinodePres2, (String)"presence");
                return tinodePres2.getWhat() == TinodeWhat.ACS ? MessagingRepoImpl.access$fetchTinodeParticipants(this.this$0, this.$topicId).flatMap((Function)fetchTopicMessages.1.INSTANCE) : Observable.empty();
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.mergeDelayErr\u2026             }\n\n        )");
        return observable;
    }

    @Override
    @NotNull
    public Observable<Boolean> triggerMessageLoad(@NotNull String string2, int n, int n2, int n3) {
        MessagingRepoImpl messagingRepoImpl = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        messagingRepoImpl.inAppNotificationsService.pauseNotifications(true, string2);
        Observable observable = messagingRepoImpl.tinode.getMessages(string2, n, n2, n3).doOnNext(new Consumer<Boolean>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
            }

            public final void accept(Boolean bl) {
                MessagingRepoImpl.access$getInAppNotificationsService$p(this.this$0).pauseNotifications(false, this.$topicId);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"tinode.getMessages(topic\u2026cations(false, topicId) }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<ChatMessage> subscribeToChat(@NotNull String string2, @Nullable Access access, boolean bl) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        Observable observable = Observable.merge((ObservableSource)this.tinode.subscribeToTopic(string2, access, bl).flatMap(new Function<T, ObservableSource<? extends R>>(this){
            final /* synthetic */ MessagingRepoImpl this$0;
            {
                this.this$0 = messagingRepoImpl;
            }

            @NotNull
            public final Observable<ChatMessage> apply(@NotNull ChatMessage chatMessage) {
                Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"message");
                MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().saveOrUpdateChatMessage(chatMessage);
                return Observable.just((Object)chatMessage);
            }
        }).flatMap(new Function<T, ObservableSource<? extends R>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
            }

            @NotNull
            public final Observable<ChatMessage> apply(@NotNull ChatMessage object) {
                Observable observable;
                ChatMessage chatMessage = object;
                Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"it");
                if (Intrinsics.areEqual((Object)chatMessage.getType(), (Object)"voice") ^ true && StringsKt.isBlank((CharSequence)((ChatMessage)object).getText()) ^ true) {
                    ChatMessage chatMessage2 = object;
                    object = this.$topicId;
                    observable = MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getChatMessage((String)object, chatMessage2.getSeq()).flatMapObservable(new Function<T, ObservableSource<? extends R>>(this){
                        final /* synthetic */ subscribeToChat.2 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        @NotNull
                        public final Observable<ChatMessage> apply(@NotNull ChatMessage chatMessage) {
                            Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"it");
                            MessagingRepoImpl.access$getInAppNotificationsService$p(this.this$0.this$0).notifyChatMessage(chatMessage);
                            return Observable.just((Object)chatMessage);
                        }
                    });
                } else {
                    observable = Observable.just((Object)object);
                }
                return observable;
            }
        }), (ObservableSource)this.tinode.subscribeToTopicPresence(string2, null, bl).flatMap(new Function<T, ObservableSource<? extends R>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
            }

            public final Observable<ChatMessage> apply(@NotNull TinodePres tinodePres) {
                TinodePres tinodePres2 = tinodePres;
                Intrinsics.checkParameterIsNotNull((Object)tinodePres2, (String)"presence");
                return tinodePres2.getWhat() == TinodeWhat.ACS ? MessagingRepoImpl.access$fetchTinodeParticipants(this.this$0, this.$topicId).flatMap((Function)subscribeToChat.1.INSTANCE) : MessagingRepoImpl.access$getCallStatusRepo$p(this.this$0).processParticipantPresence(tinodePres).flatMap((Function)subscribeToChat.2.INSTANCE);
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.merge(\n      \u2026              }\n        )");
        return observable;
    }

    @Override
    @NotNull
    public Observable<ResourceState<List<Chat>>> getChats(boolean bl) {
        return RxRepoExtKt.twoSideCall(new Function0<Observable<List<? extends Chat>>>(this, bl){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ boolean $isCall;
            {
                this.this$0 = messagingRepoImpl;
                this.$isCall = bl;
                super(0);
            }

            public final Observable<List<Chat>> invoke() {
                return MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getChats(this.$isCall);
            }
        }, new Function0<Observable<List<? extends Chat>>>(this, bl){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ boolean $isCall;
            {
                this.this$0 = messagingRepoImpl;
                this.$isCall = bl;
                super(0);
            }

            @NotNull
            public final Observable<List<Chat>> invoke() {
                getChats.2 this_;
                if (this_.$isCall) {
                    this_ = Observable.empty();
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)this_), (String)"Observable.empty<List<Chat>>()");
                } else {
                    this_ = MessagingRepoImpl.access$getTinode$p(this_.this$0).getChats().map((Function)getChats.1.INSTANCE).flatMap(new Function<T, ObservableSource<? extends R>>(this_){
                        final /* synthetic */ getChats.2 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final Observable<List<Chat>> apply(@NotNull List<Chat> list) {
                            ArrayList<T> arrayList;
                            List<Chat> list2 = list;
                            Intrinsics.checkParameterIsNotNull(list2, (String)"chats");
                            Object object = arrayList;
                            arrayList = new ArrayList<T>();
                            for (T object2 : list2) {
                                if (!(((Chat)object2).isCallChat() ^ true)) continue;
                                object.add(object2);
                            }
                            for (Chat chat : object) {
                                if (MessagingRepoImpl.access$getSession$p(this.this$0.this$0).getLastReadMessageSeq(chat.getChatId()) != 0) continue;
                                Chat chat2 = chat;
                                String string2 = chat2.getChatId();
                                MessagingRepoImpl.access$getSession$p(this.this$0.this$0).setLastReadMessageSeq(string2, chat2.getSeq());
                            }
                            Object object3 = TimeUnit.MILLISECONDS;
                            Observable observable = Observable.fromIterable(object).delay(1000L, object3).flatMap(new Function<T, ObservableSource<? extends R>>(this, (List)object){
                                final /* synthetic */ getChats.2 this$0;
                                final /* synthetic */ List $nonVoiceCallChats;
                                {
                                    this.this$0 = var1_1;
                                    this.$nonVoiceCallChats = list;
                                }

                                @NotNull
                                public final Observable<Chat> apply(@NotNull Chat chat) {
                                    Intrinsics.checkParameterIsNotNull((Object)chat, (String)"chat");
                                    return MessagingRepoImpl.access$getDatabase$p(this.this$0.this$0.this$0).messagingDao().getLastSeqId(chat.getChatId()).defaultIfEmpty((Object)0).filter(new Predicate<Integer>(chat){
                                        final /* synthetic */ Chat $chat;
                                        {
                                            this.$chat = chat;
                                        }

                                        public final boolean test(@NotNull Integer n) {
                                            Intrinsics.checkParameterIsNotNull((Object)n, (String)"it");
                                            int n2 = this.$chat.getSeq();
                                            return n != n2;
                                        }
                                    }).delay((long)this.$nonVoiceCallChats.indexOf(chat) * 100L, TimeUnit.MILLISECONDS).flatMapObservable(new Function<T, ObservableSource<? extends R>>(this, chat){
                                        final /* synthetic */ getChats.4 this$0;
                                        final /* synthetic */ Chat $chat;
                                        {
                                            this.this$0 = var1_1;
                                            this.$chat = chat;
                                        }

                                        public final Observable<Chat> apply(@NotNull Integer object) {
                                            Integer n = object;
                                            getChats.2 v1 = messagingRepoImpl;
                                            Intrinsics.checkParameterIsNotNull((Object)object, (String)"lastSeqId");
                                            MessagingRepoImpl messagingRepoImpl = v1.this$0.this$0.this$0.this$0;
                                            object = v1.$chat.getChatId();
                                            int n2 = n + 1;
                                            int n3 = 0;
                                            int n4 = n == 0 ? 20 : 0;
                                            return MessagingRepo.DefaultImpls.triggerMessageLoad$default(messagingRepoImpl, (String)object, n2, n3, n4, 4, null).flatMap((Function)getChats.1.INSTANCE);
                                        }
                                    });
                                }
                            }).flatMap((Function)getChats.5.INSTANCE);
                            object = TimeUnit.MILLISECONDS;
                            return Observable.mergeDelayError((ObservableSource)Observable.just(list), (ObservableSource)Observable.fromIterable(list).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                                final /* synthetic */ getChats.2 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final Observable<Chat> apply(@NotNull Chat chat) {
                                    Ref.ObjectRef objectRef;
                                    getChats.2 v0 = this;
                                    Intrinsics.checkParameterIsNotNull((Object)chat, (String)"chat");
                                    MessagingRepoImpl.access$getDatabase$p(v0.this$0.this$0.this$0).messagingDao().saveChats(CollectionsKt.listOf((Object)chat));
                                    Ref.ObjectRef objectRef2 = objectRef;
                                    objectRef2();
                                    objectRef.element = Chat.copy$default(chat, null, null, null, 0, 0, 0, null, null, null, null, 1023, null);
                                    Chat chat2 = chat;
                                    String string2 = chat2.getChatId();
                                    Access access = chat2.getAccess();
                                    boolean bl = chat2.isCallChat();
                                    return v0.this$0.this$0.this$0.subscribeToChat(string2, access, bl).flatMap(new Function<T, ObservableSource<? extends R>>(this, objectRef2, chat){
                                        final /* synthetic */ getChats.2 this$0;
                                        final /* synthetic */ Ref.ObjectRef $updatingChat;
                                        final /* synthetic */ Chat $chat;
                                        {
                                            this.this$0 = var1_1;
                                            this.$updatingChat = objectRef;
                                            this.$chat = chat;
                                        }

                                        public final Observable<Chat> apply(@NotNull ChatMessage chatMessage) {
                                            ChatMessage chatMessage2 = chatMessage;
                                            Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"newMessage");
                                            if (chatMessage2.getSeq() > ((Chat)this.$updatingChat.element).getSeq()) {
                                                getChats.1 v1 = this;
                                                Ref.ObjectRef objectRef = v1.$updatingChat;
                                                ChatMessage chatMessage3 = chatMessage;
                                                int n = chatMessage3.getSeq();
                                                Date date = chatMessage3.getDate();
                                                Chat chat = Chat.copy$default(this.$chat, null, null, null, n, 0, 0, date, null, null, null, 951, null);
                                                chat.setLastMessage(chatMessage);
                                                objectRef.element = chat;
                                                MessagingRepoImpl.access$getDatabase$p(v1.this$0.this$0.this$0.this$0).messagingDao().saveChats(CollectionsKt.listOf((Object)((Chat)this.$updatingChat.element)));
                                            }
                                            return Observable.empty();
                                        }
                                    });
                                }
                            }).flatMap((Function)getChats.3.INSTANCE), (ObservableSource)observable, (ObservableSource)Observable.just((Object)Boolean.TRUE).delay(200L, object).flatMap(new Function<T, ObservableSource<? extends R>>(this, list){
                                final /* synthetic */ getChats.2 this$0;
                                final /* synthetic */ List $chats;
                                {
                                    this.this$0 = var1_1;
                                    this.$chats = list;
                                }

                                public final Observable<List<Chat>> apply(@NotNull Boolean bl) {
                                    Intrinsics.checkParameterIsNotNull((Object)bl, (String)"it");
                                    return Observable.fromIterable((Iterable)this.$chats).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                                        final /* synthetic */ getChats.6 this$0;
                                        {
                                            this.this$0 = var1_1;
                                        }

                                        public final Observable<Chat> apply(@NotNull Chat chat) {
                                            Intrinsics.checkParameterIsNotNull((Object)chat, (String)"chat");
                                            return MessagingRepoImpl.access$fetchTinodeParticipants(this.this$0.this$0.this$0.this$0, chat.getChatId()).flatMap((Function)getChats.1.INSTANCE);
                                        }
                                    }).flatMap((Function)getChats.2.INSTANCE);
                                }
                            })).distinctUntilChanged().flatMap(new Function<T, ObservableSource<? extends R>>(this){
                                final /* synthetic */ getChats.2 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final Observable<List<Chat>> apply(@NotNull List<Chat> list) {
                                    Intrinsics.checkParameterIsNotNull(list, (String)"it");
                                    MessagingRepoImpl.access$getDatabase$p(this.this$0.this$0.this$0).messagingDao().saveChats(list);
                                    return Observable.empty();
                                }
                            });
                        }
                    }).distinctUntilChanged();
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)this_), (String)"tinode.getChats()\n      \u2026 }.distinctUntilChanged()");
                }
                return this_;
            }
        }, getChats.3.INSTANCE);
    }

    @Override
    @NotNull
    public Observable<ResourceState<Chat>> getChat(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        return RxRepoExtKt.twoSideCall(new Function0<Observable<Chat>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = messagingRepoImpl;
                this.$chatId = string2;
                super(0);
            }

            public final Observable<Chat> invoke() {
                return MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getChat(this.$chatId).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ getChat.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<Chat> apply(@NotNull Chat chat) {
                        Observable observable;
                        ChatMessage chatMessage;
                        Chat chat2 = chat;
                        Intrinsics.checkParameterIsNotNull((Object)chat2, (String)"chat");
                        if (chat2.isCallChat() && Intrinsics.areEqual((Object)((chatMessage = chat.getLastMessage()) != null ? chatMessage.getSenderUserId() : null), (Object)MessagingRepoImpl.access$getSession$p(this.this$0.this$0).getTinodeUserId()) ^ true && chat.getParticipants().isEmpty() ^ true && !MessagingRepoImpl.access$getSession$p(this.this$0.this$0).isTopicMuted(chat.getChatId())) {
                            String cfr_ignored_0 = "Notify call: " + chat.toString();
                            observable = Observable.merge((ObservableSource)Observable.just((Object)chat), (ObservableSource)MessagingRepoImpl.access$getCallStatusRepo$p(this.this$0.this$0).observeCallStatus(this.this$0.$chatId).distinctUntilChanged().flatMap(new Function<T, ObservableSource<? extends R>>(this, chat){
                                final /* synthetic */ getChat.1 this$0;
                                final /* synthetic */ Chat $chat;
                                {
                                    this.this$0 = var1_1;
                                    this.$chat = chat;
                                }

                                public final Observable<Chat> apply(@NotNull CallStatus callStatus) {
                                    Intrinsics.checkParameterIsNotNull((Object)callStatus, (String)"callStatus");
                                    String cfr_ignored_0 = "Notify call: " + callStatus.toString() + this.$chat.toString();
                                    InAppNotificationsService inAppNotificationsService = MessagingRepoImpl.access$getInAppNotificationsService$p(this.this$0.this$0.this$0);
                                    Chat chat = this.$chat;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)chat, (String)"chat");
                                    inAppNotificationsService.notifyCall(chat, callStatus);
                                    return Observable.empty();
                                }
                            }));
                        } else {
                            observable = Observable.just((Object)chat);
                        }
                        return observable;
                    }
                });
            }
        }, new Function0<Observable<Chat>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = messagingRepoImpl;
                this.$chatId = string2;
                super(0);
            }

            public final Observable<Chat> invoke() {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                Observable observable = MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getLastSeqId(this.$chatId).delay(1000L, timeUnit).defaultIfEmpty((Object)0).flatMapObservable(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ getChat.2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<Chat> apply(@NotNull Integer n) {
                        Intrinsics.checkParameterIsNotNull((Object)n, (String)"seqId");
                        Object object = object.this$0;
                        return MessagingRepoImpl.fetchTopicMessages$default(object.this$0, object.$chatId, n + 1, 0, 0, 12, null).flatMap((Function)getChat.1.INSTANCE);
                    }
                });
                timeUnit = TimeUnit.MILLISECONDS;
                Observable observable2 = Observable.mergeDelayError((ObservableSource)MessagingRepoImpl.access$getTinode$p(this.this$0).getChat(this.$chatId).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ getChat.2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<Chat> apply(@NotNull Chat chat) {
                        Ref.ObjectRef objectRef;
                        getChat.1 v0 = this;
                        Intrinsics.checkParameterIsNotNull((Object)chat, (String)"chat");
                        MessagingRepoImpl.access$getDatabase$p(v0.this$0.this$0).messagingDao().saveChats(CollectionsKt.listOf((Object)chat));
                        Ref.ObjectRef objectRef2 = objectRef;
                        objectRef2();
                        objectRef.element = Chat.copy$default(chat, null, null, null, 0, 0, 0, null, null, null, null, 1023, null);
                        Chat chat2 = chat;
                        String string2 = chat2.getChatId();
                        Access access = chat2.getAccess();
                        boolean bl = chat2.isCallChat();
                        return v0.this$0.this$0.subscribeToChat(string2, access, bl).flatMap(new Function<T, ObservableSource<? extends R>>(this, chat, objectRef2){
                            final /* synthetic */ getChat.1 this$0;
                            final /* synthetic */ Chat $chat;
                            final /* synthetic */ Ref.ObjectRef $updatingChat;
                            {
                                this.this$0 = var1_1;
                                this.$chat = chat;
                                this.$updatingChat = objectRef;
                            }

                            public final Observable<Chat> apply(@NotNull ChatMessage chatMessage) {
                                Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"newMessage");
                                if (MessagingRepoImpl.access$getSession$p(this.this$0.this$0.this$0).getLastReadMessageSeq(this.$chat.getChatId()) == 0) {
                                    String string2 = this.$chat.getChatId();
                                    MessagingRepoImpl.access$getSession$p(this.this$0.this$0.this$0).setLastReadMessageSeq(string2, chatMessage.getSeq());
                                }
                                if (chatMessage.getSeq() > ((Chat)this.$updatingChat.element).getSeq()) {
                                    getChat.1 v0 = this;
                                    Ref.ObjectRef objectRef = v0.$updatingChat;
                                    ChatMessage chatMessage2 = chatMessage;
                                    int n = chatMessage2.getSeq();
                                    Date date = chatMessage2.getDate();
                                    Chat chat = Chat.copy$default(this.$chat, null, null, null, n, 0, 0, date, null, null, null, 951, null);
                                    chat.setLastMessage(chatMessage);
                                    objectRef.element = chat;
                                    MessagingRepoImpl.access$getDatabase$p(v0.this$0.this$0.this$0).messagingDao().saveChats(CollectionsKt.listOf((Object)((Chat)this.$updatingChat.element)));
                                }
                                return Observable.empty();
                            }
                        });
                    }
                }), (ObservableSource)observable, (ObservableSource)Observable.just((Object)Boolean.TRUE).delay(500L, timeUnit).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ getChat.2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<Chat> apply(@NotNull Boolean bl) {
                        Intrinsics.checkParameterIsNotNull((Object)bl, (String)"it");
                        Object object = object.this$0;
                        return MessagingRepoImpl.access$fetchTinodeParticipants(object.this$0, object.$chatId).flatMap((Function)getChat.1.INSTANCE);
                    }
                }));
                Intrinsics.checkExpressionValueIsNotNull((Object)observable2, (String)"Observable.mergeDelayErr\u2026      }\n                )");
                return observable2;
            }
        }, getChat.3.INSTANCE);
    }

    @Override
    @NotNull
    public Observable<ResourceState<List<TinodeContact>>> getParticipants(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        return RxRepoExtKt.twoSideCall(new Function0<Observable<List<? extends TinodeContact>>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = messagingRepoImpl;
                this.$chatId = string2;
                super(0);
            }

            public final Observable<List<TinodeContact>> invoke() {
                return MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getChat(this.$chatId).map((Function)getParticipants.1.INSTANCE);
            }
        }, new Function0<Observable<List<? extends TinodeContact>>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = messagingRepoImpl;
                this.$chatId = string2;
                super(0);
            }

            public final Observable<List<TinodeContact>> invoke() {
                Observable observable = MessagingRepoImpl.access$fetchTinodeParticipants(this.this$0, this.$chatId).flatMap((Function)getParticipants.1.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"fetchTinodeParticipants(\u2026<List<TinodeContact>>() }");
                return observable;
            }
        }, getParticipants.3.INSTANCE);
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> sendMessage(@NotNull String string2, @NotNull String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"content");
        return RxRepoExtKt.oneSideCall$default((Function0)new Function0<Observable<Boolean>>(this, string2, string3, string4, string5, string6){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $chatId;
            final /* synthetic */ String $content;
            final /* synthetic */ String $type;
            final /* synthetic */ String $subtype;
            final /* synthetic */ String $reply;
            {
                this.this$0 = messagingRepoImpl;
                this.$chatId = string2;
                this.$content = string3;
                this.$type = string4;
                this.$subtype = string5;
                this.$reply = string6;
                super(0);
            }

            @NotNull
            public final Observable<Boolean> invoke() {
                return MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getLastSeqId(this.$chatId).defaultIfEmpty((Object)0).flatMapObservable(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ sendMessage.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<Boolean> apply(@NotNull Integer n) {
                        LinkedHashMap<K, V> linkedHashMap;
                        ChatMessage chatMessage;
                        Date date;
                        Integer n2 = n;
                        Intrinsics.checkParameterIsNotNull((Object)n2, (String)"it");
                        int n3 = n2 + 1;
                        sendMessage.1 v1 = this.this$0;
                        String string2 = v1.$chatId;
                        String string3 = MessagingRepoImpl.access$getSession$p(v1.this$0).getTinodeUserId();
                        if (string3 == null) {
                            string3 = "";
                        }
                        Cloneable cloneable = date;
                        date = new Date();
                        sendMessage.1 v3 = this.this$0;
                        String string4 = v3.$content;
                        ChatMessageStatus chatMessageStatus = ChatMessageStatus.Sending;
                        String string5 = v3.$type;
                        if (string5 == null) {
                            string5 = "";
                        }
                        String string6 = this.this$0.$subtype;
                        if (string6 == null) {
                            string6 = "";
                        }
                        String string7 = this.this$0.$reply;
                        if (string7 == null) {
                            string7 = "";
                        }
                        sendMessage.1 v4 = this;
                        ChatMessage chatMessage2 = chatMessage;
                        chatMessage = new ChatMessage(string2, n3, string3, (Date)cloneable, string4, string5, string6, string7, chatMessageStatus);
                        MessagingRepoImpl.access$getDatabase$p(v4.this$0.this$0).messagingDao().saveChatMessage(chatMessage2);
                        TinodeService tinodeService = MessagingRepoImpl.access$getTinode$p(v4.this$0.this$0);
                        sendMessage.1 v6 = v4.this$0;
                        string2 = v6.$chatId;
                        string3 = v6.$content;
                        cloneable = linkedHashMap;
                        linkedHashMap = new LinkedHashMap<K, V>();
                        string4 = v4.this$0.$type;
                        if (string4 != null) {
                            cloneable.put("x-slr-type", string4);
                        }
                        if ((string4 = this.this$0.$subtype) != null) {
                            cloneable.put("x-slr-subtype", string4);
                        }
                        if ((string4 = this.this$0.$reply) != null) {
                            cloneable.put("x-slr-reply", string4);
                        }
                        return tinodeService.sendMessage(string2, string3, (Map<String, String>)((Object)cloneable)).flatMap(new Function<T, ObservableSource<? extends R>>(this, chatMessage2){
                            final /* synthetic */ sendMessage.1 this$0;
                            final /* synthetic */ ChatMessage $message;
                            {
                                this.this$0 = var1_1;
                                this.$message = chatMessage;
                            }

                            @NotNull
                            public final Observable<Boolean> apply(@NotNull Boolean bl) {
                                Boolean bl2 = bl;
                                Intrinsics.checkParameterIsNotNull((Object)bl2, (String)"it");
                                if (!bl2.booleanValue()) {
                                    sendMessage.2 v1 = this;
                                    v1.this$0.this$0.this$0.deleteMessage(this.$message);
                                    v1.$message.updateStatus(ChatMessageStatus.Failed);
                                    MessagingRepoImpl.access$getDatabase$p(v1.this$0.this$0.this$0).messagingDao().saveChatMessage(this.$message);
                                }
                                return Observable.just((Object)bl);
                            }
                        }).doOnError(new Consumer<Throwable>(this, chatMessage2){
                            final /* synthetic */ sendMessage.1 this$0;
                            final /* synthetic */ ChatMessage $message;
                            {
                                this.this$0 = var1_1;
                                this.$message = chatMessage;
                            }

                            public final void accept(Throwable throwable) {
                                sendMessage.3 v0 = this;
                                v0.this$0.this$0.this$0.deleteMessage(this.$message);
                                v0.$message.updateStatus(ChatMessageStatus.Failed);
                                MessagingRepoImpl.access$getDatabase$p(v0.this$0.this$0.this$0).messagingDao().saveChatMessage(this.$message);
                            }
                        });
                    }
                });
            }
        }, null, null, 6, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> resendMessage(@NotNull ChatMessage chatMessage) {
        Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"item");
        Observable observable = this.tinode.setSubscriptionToTopic(chatMessage.getTopicId(), null).flatMap(new Function<T, ObservableSource<? extends R>>(this, chatMessage){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ ChatMessage $item;
            {
                this.this$0 = messagingRepoImpl;
                this.$item = chatMessage;
            }

            @NotNull
            public final Observable<ResourceState<Boolean>> apply(@NotNull Boolean bl) {
                Intrinsics.checkParameterIsNotNull((Object)bl, (String)"it");
                return this.this$0.resendMessageProcessing(this.$item);
            }
        }).doOnError(new Consumer<Throwable>(this, chatMessage){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ ChatMessage $item;
            {
                this.this$0 = messagingRepoImpl;
                this.$item = chatMessage;
            }

            public final void accept(Throwable throwable) {
                resendMessage.2 v0 = this;
                v0.$item.updateStatus(ChatMessageStatus.Failed);
                MessagingRepoImpl.access$getDatabase$p(v0.this$0).messagingDao().saveChatMessage(this.$item);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"tinode.setSubscriptionTo\u2026ssage(item)\n            }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> resendMessageProcessing(@NotNull ChatMessage chatMessage) {
        Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"item");
        return RxRepoExtKt.oneSideCall$default((Function0)new Function0<Observable<Boolean>>(this, chatMessage){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ ChatMessage $item;
            {
                this.this$0 = messagingRepoImpl;
                this.$item = chatMessage;
                super(0);
            }

            public final Observable<Boolean> invoke() {
                LinkedHashMap linkedHashMap;
                Date date;
                resendMessageProcessing.1 v0 = this;
                LinkedHashMap<String, String> linkedHashMap2 = v0.$item.getTopicId();
                int n = v0.$item.getSeq();
                Object object = MessagingRepoImpl.access$getSession$p(v0.this$0).getTinodeUserId();
                if (object == null) {
                    object = "";
                }
                resendMessageProcessing.1 v1 = this;
                String string2 = linkedHashMap2;
                String string3 = object;
                resendMessageProcessing.1 v4 = this;
                linkedHashMap2 = date;
                date = new Date();
                String string4 = v4.$item.getText();
                object = ChatMessageStatus.Sending;
                String string5 = v4.$item.getType();
                String string6 = v4.$item.getSubtype();
                String string7 = v4.$item.getReplyTo();
                ChatMessage chatMessage = new ChatMessage(string2, n, string3, (Date)((Object)linkedHashMap2), string4, string5, string6, string7, (ChatMessageStatus)((Object)object));
                MessagingRepoImpl.access$getDatabase$p(v1.this$0).messagingDao().saveChatMessage(chatMessage);
                TinodeService tinodeService = MessagingRepoImpl.access$getTinode$p(v1.this$0);
                String string8 = this.$item.getTopicId();
                String string9 = this.$item.getText();
                linkedHashMap2 = linkedHashMap;
                linkedHashMap2();
                linkedHashMap2.put("x-slr-type", this.$item.getType());
                linkedHashMap2.put("x-slr-subtype", this.$item.getSubtype());
                linkedHashMap.put("x-slr-reply", this.$item.getReplyTo());
                return tinodeService.sendMessage(string8, string9, linkedHashMap).flatMap(new Function<T, ObservableSource<? extends R>>(this, chatMessage){
                    final /* synthetic */ resendMessageProcessing.1 this$0;
                    final /* synthetic */ ChatMessage $message;
                    {
                        this.this$0 = var1_1;
                        this.$message = chatMessage;
                    }

                    @NotNull
                    public final Observable<Boolean> apply(@NotNull Boolean bl) {
                        Boolean bl2 = bl;
                        Intrinsics.checkParameterIsNotNull((Object)bl2, (String)"it");
                        if (!bl2.booleanValue()) {
                            resendMessageProcessing.2 v1 = this;
                            v1.this$0.this$0.deleteMessage(this.$message);
                            v1.$message.updateStatus(ChatMessageStatus.Failed);
                            MessagingRepoImpl.access$getDatabase$p(v1.this$0.this$0).messagingDao().saveChatMessage(this.$message);
                        }
                        return Observable.just((Object)bl);
                    }
                }).doOnError(new Consumer<Throwable>(this, chatMessage){
                    final /* synthetic */ resendMessageProcessing.1 this$0;
                    final /* synthetic */ ChatMessage $message;
                    {
                        this.this$0 = var1_1;
                        this.$message = chatMessage;
                    }

                    public final void accept(Throwable throwable) {
                        resendMessageProcessing.3 v0 = this;
                        v0.this$0.this$0.deleteMessage(this.$message);
                        v0.$message.updateStatus(ChatMessageStatus.Failed);
                        MessagingRepoImpl.access$getDatabase$p(v0.this$0.this$0).messagingDao().saveChatMessage(this.$message);
                    }
                });
            }
        }, null, null, 6, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> sendWaveMessage(@NotNull TinodeContact tinodeContact, @NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)tinodeContact, (String)"contact");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"content");
        Observable observable = this.sendMessage(tinodeContact.getChatUserId(), string2).flatMap(new Function<T, ObservableSource<? extends R>>(this, tinodeContact){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ TinodeContact $contact;
            {
                this.this$0 = messagingRepoImpl;
                this.$contact = tinodeContact;
            }

            @NotNull
            public final Observable<ResourceState<Boolean>> apply(@NotNull ResourceState<Boolean> resourceState) {
                Object object;
                ResourceState<Boolean> resourceState2 = resourceState;
                Intrinsics.checkParameterIsNotNull(resourceState2, (String)"it");
                if (resourceState2.getStatus() == Status.SUCCESS && Intrinsics.areEqual((Object)resourceState.getData(), (Object)Boolean.TRUE) && (object = string3.$contact.getChatName()) != null) {
                    Date date;
                    String string2 = object;
                    String string3 = string3.$contact.getPhotoData();
                    object = date;
                    date = new Date();
                    MessagingRepoImpl.access$getDatabase$p(string3.this$0).messagingDao().saveWaveMessage(new WaveMessage(string3.$contact.getChatUserId(), string2, string3, (Date)object));
                }
                return Observable.just(resourceState);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sendMessage(contact.chat\u2026rvable.just(it)\n        }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<Boolean> subscribeToWaveMessages() {
        Observable observable = this.tinode.subscribeToContactPresence().flatMap(new Function<T, ObservableSource<? extends R>>(this){
            final /* synthetic */ MessagingRepoImpl this$0;
            {
                this.this$0 = messagingRepoImpl;
            }

            @NotNull
            public final Observable<Boolean> apply(@NotNull TinodePres object) {
                TinodePres tinodePres = object;
                Intrinsics.checkParameterIsNotNull((Object)tinodePres, (String)"it");
                if (tinodePres.getWhat() == TinodeWhat.ON) {
                    Date date;
                    Date date2 = date;
                    date = new Date(new Date().getTime() - 10800000L);
                    MessagingDao messagingDao = MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao();
                    object = messagingDao.getWaveByIdAndDate(((TinodePres)object).getChatUserId(), date2);
                    if (object != null) {
                        MessagingRepoImpl.access$getInAppNotificationsService$p(this.this$0).notifyWaveMessage((WaveMessage)object);
                        messagingDao.deleteWaveMessage((WaveMessage)object);
                    }
                    messagingDao.deleteWaveEvents(date2);
                }
                return Observable.just((Object)Boolean.TRUE);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"tinode.subscribeToContac\u2026servable.just(true)\n    }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> sendMessage(@NotNull String string2, @NotNull String string3) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"content");
        return this.sendMessage(string2, string3, null, null, null);
    }

    @Override
    public void deleteUnsentMessages(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        this.database.messagingDao().deleteMessages(string2, ChatMessageStatus.Sending);
    }

    @Override
    public void deleteMessage(@NotNull ChatMessage chatMessage) {
        Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"item");
        this.database.messagingDao().deleteChatMessage(chatMessage);
    }

    @Override
    @NotNull
    public Observable<ResourceState<Chat>> createChat(@NotNull TinodeUserPublic tinodeUserPublic, @NotNull List<String> list, boolean bl) {
        Intrinsics.checkParameterIsNotNull((Object)tinodeUserPublic, (String)"data");
        Intrinsics.checkParameterIsNotNull(list, (String)"userIds");
        return RxRepoExtKt.oneSideCall$default((Function0)new Function0<Observable<Chat>>(this, list, bl, tinodeUserPublic){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ List $userIds;
            final /* synthetic */ boolean $forceNewChat;
            final /* synthetic */ TinodeUserPublic $data;
            {
                this.this$0 = messagingRepoImpl;
                this.$userIds = list;
                this.$forceNewChat = bl;
                this.$data = tinodeUserPublic;
                super(0);
            }

            @NotNull
            public final Observable<Chat> invoke() {
                return MessagingDao.DefaultImpls.getChats$default(MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao(), false, 1, null).first((Object)CollectionsKt.emptyList()).flatMapObservable(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ createChat.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final Observable<Chat> apply(@NotNull List<Chat> object) {
                        Object object2;
                        Object var2_2;
                        block4: {
                            Iterator<T> iterator = object;
                            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"chats");
                            object = iterator.iterator();
                            while (object.hasNext()) {
                                ArrayList<String> arrayList;
                                T t = object.next();
                                var2_2 = t;
                                Object object3 = MessagingExtensionsKt.participantsWithoutUser((Chat)t, MessagingRepoImpl.access$getSession$p(object2.this$0.this$0).getTinodeUserId());
                                ArrayList<String> arrayList2 = arrayList;
                                arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault(object3, (int)10));
                                object3 = object3.iterator();
                                while (object3.hasNext()) {
                                    arrayList2.add(((TinodeContact)object3.next()).getChatUserId());
                                }
                                if (!Intrinsics.areEqual((Object)CollectionsKt.sorted(arrayList2), (Object)CollectionsKt.sorted((Iterable)object2.this$0.$userIds))) continue;
                                break block4;
                            }
                            var2_2 = null;
                        }
                        object = var2_2;
                        if (object != null && !object2.this$0.$forceNewChat) {
                            object2 = Observable.just((Object)object);
                            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"Observable.just(existingChat)");
                        } else {
                            createChat.1 v3 = object2.this$0;
                            Object object3 = object2 = v3;
                            object2 = object3.$data;
                            object2 = MessagingRepoImpl.access$createNewChat(v3.this$0, (TinodeUserPublic)object2, object3.$userIds);
                        }
                        return object2;
                    }
                });
            }
        }, null, null, 6, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> inviteUsersToChat(@NotNull String string2, @NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        Intrinsics.checkParameterIsNotNull(list, (String)"userIds");
        return RxRepoExtKt.oneSideCall$default((Function0)new Function0<Observable<Boolean>>(this, list, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ List $userIds;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = messagingRepoImpl;
                this.$userIds = list;
                this.$chatId = string2;
                super(0);
            }

            @NotNull
            public final Observable<Boolean> invoke() {
                return Observable.fromIterable((Iterable)this.$userIds).flatMapSingle(new Function<T, SingleSource<? extends R>>(this){
                    final /* synthetic */ inviteUsersToChat.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final Single<Boolean> apply(@NotNull String string2) {
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"userId");
                        return MessagingRepoImpl.access$getTinode$p(this.this$0.this$0).inviteUserToTopic(this.this$0.$chatId, string2).first((Object)Boolean.FALSE).flatMap(new Function<T, SingleSource<? extends R>>(this, string2){
                            final /* synthetic */ inviteUsersToChat.1 this$0;
                            final /* synthetic */ String $userId;
                            {
                                this.this$0 = var1_1;
                                this.$userId = string2;
                            }

                            @NotNull
                            public final Single<Boolean> apply(@NotNull Boolean bl) {
                                Boolean bl2 = bl;
                                Intrinsics.checkParameterIsNotNull((Object)bl2, (String)"success");
                                if (bl2.booleanValue()) {
                                    MessagingDao messagingDao = MessagingRepoImpl.access$getDatabase$p(string2.this$0.this$0.this$0).messagingDao();
                                    inviteUsersToChat.1 v2 = string2;
                                    String string2 = v2.this$0.this$0.$chatId;
                                    String string3 = v2.$userId;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"userId");
                                    messagingDao.saveChatParticipantCrossRefs(CollectionsKt.listOf((Object)new ChatParticipantCrossRef(string2, string3)));
                                }
                                return Single.just((Object)bl);
                            }
                        });
                    }
                }).toList().flatMapObservable((Function)inviteUsersToChat.2.INSTANCE);
            }
        }, null, null, 6, null);
    }
}

