/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.notifications;

import android.net.Uri;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationKt$WhenMappings;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.utils.GsonUtil;
import io.streamlayer.utils.NavigationUtils;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0004*\u00020\u0005H\u0000\u00a8\u0006\b"}, d2={"deepLink", "Landroid/net/Uri;", "Lio/streamlayer/sdk/model/notifications/Notification;", "isCallMissedType", "", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "isCallType", "isCallingType", "sdk_originalVoximplantRelease"})
public final class NotificationKt {
    public static final boolean isCallType(@NotNull NotificationType notificationType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)notificationType), (String)"$this$isCallType");
        return ArraysKt.contains((Object[])new NotificationType[]{NotificationType.Call, NotificationType.GroupCall, NotificationType.MissedCall, NotificationType.MissedGroupCall, NotificationType.GroupCallActive}, (Object)((Object)notificationType));
    }

    public static final boolean isCallingType(@NotNull NotificationType notificationType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)notificationType), (String)"$this$isCallingType");
        return ArraysKt.contains((Object[])new NotificationType[]{NotificationType.Call, NotificationType.GroupCall, NotificationType.GroupCallActive}, (Object)((Object)notificationType));
    }

    public static final boolean isCallMissedType(@NotNull NotificationType notificationType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)notificationType), (String)"$this$isCallMissedType");
        return ArraysKt.contains((Object[])new NotificationType[]{NotificationType.MissedCall, NotificationType.MissedGroupCall}, (Object)((Object)notificationType));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Uri deepLink(@NotNull Notification object) {
        Uri uri;
        Object object2 = object;
        Intrinsics.checkParameterIsNotNull((Object)object2, (String)"$this$deepLink");
        switch (NotificationKt$WhenMappings.$EnumSwitchMapping$0[((Notification)object2).getType().ordinal()]) {
            default: {
                return null;
            }
            case 6: {
                uri = NavigationUtils.INSTANCE.buildTweetDeepLink(((Notification)object).getSourceUniqueId());
                return uri;
            }
            case 3: 
            case 4: 
            case 5: {
                String string2 = ((Notification)object).getDataJson();
                object = string2 != null && StringsKt.contains$default((CharSequence)string2, (CharSequence)"chatId", (boolean)false, (int)2, null) ? GsonUtil.INSTANCE.getDefaultGson().fromJson(((Notification)object).getDataJson(), Chat.class) : GsonUtil.INSTANCE.getDefaultGson().fromJson(((Notification)object).getDataJson(), ChatMessage.class);
                if (object instanceof Chat) {
                    uri = NavigationUtils.INSTANCE.buildVoiceCallDeepLink(((Chat)object).getChatId());
                    return uri;
                }
                if (!(object instanceof ChatMessage)) return null;
                uri = NavigationUtils.INSTANCE.buildVoiceCallDeepLink(((ChatMessage)object).getTopicId());
                return uri;
            }
            case 2: {
                object = (ChatMessage)GsonUtil.INSTANCE.getDefaultGson().fromJson(((Notification)object).getDataJson(), ChatMessage.class);
                NavigationUtils navigationUtils = NavigationUtils.INSTANCE;
                object = object != null ? ((ChatMessage)object).getTopicId() : null;
                uri = navigationUtils.buildChatMessageDeepLink((String)object);
                return uri;
            }
            case 1: {
                uri = NavigationUtils.INSTANCE.buildChatMessageDeepLink(NotificationUtilKt.fromWaveSourceId(((Notification)object).getSourceUniqueId()));
            }
        }
        return uri;
    }
}

