/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.messaging;

import android.database.Cursor;
import androidx.collection.ArrayMap;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.calls.CallConnectionStatus;
import io.streamlayer.sdk.model.calls.CallParticipantStatus;
import io.streamlayer.sdk.model.calls.CallStatus;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.calls.WatchPartyRelation;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageRelation;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageUpdate;
import io.streamlayer.sdk.model.messaging.ChatOwnerCrossRef;
import io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef;
import io.streamlayer.sdk.model.messaging.ChatRelation;
import io.streamlayer.sdk.model.messaging.WaveMessage;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.model.tinodecontact.TinodePhoto;
import io.streamlayer.sdk.model.tinodecontact.TinodeUserPublic;
import io.streamlayer.sdk.repository.messaging.MessagingDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public final class MessagingDao_Impl
implements MessagingDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage;
    private final Converters __converters;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage_1;
    private final EntityInsertionAdapter<ChatOwnerCrossRef> __insertionAdapterOfChatOwnerCrossRef;
    private final EntityInsertionAdapter<Chat> __insertionAdapterOfChat;
    private final EntityInsertionAdapter<ChatParticipantCrossRef> __insertionAdapterOfChatParticipantCrossRef;
    private final EntityInsertionAdapter<WaveMessage> __insertionAdapterOfWaveMessage;
    private final EntityDeletionOrUpdateAdapter<ChatMessage> __deletionAdapterOfChatMessage;
    private final EntityDeletionOrUpdateAdapter<WaveMessage> __deletionAdapterOfWaveMessage;
    private final EntityDeletionOrUpdateAdapter<ChatMessageUpdate> __updateAdapterOfChatMessageUpdateAsChatMessage;
    private final SharedSQLiteStatement __preparedStmtOfDeleteMessages;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChats;
    private final SharedSQLiteStatement __preparedStmtOfDeleteWaveEvents;

    public MessagingDao_Impl(RoomDatabase roomDatabase) {
        SharedSQLiteStatement sharedSQLiteStatement;
        SharedSQLiteStatement sharedSQLiteStatement2;
        SharedSQLiteStatement sharedSQLiteStatement3;
        EntityDeletionOrUpdateAdapter<ChatMessageUpdate> entityDeletionOrUpdateAdapter;
        EntityDeletionOrUpdateAdapter<WaveMessage> entityDeletionOrUpdateAdapter2;
        EntityDeletionOrUpdateAdapter<ChatMessage> entityDeletionOrUpdateAdapter3;
        EntityInsertionAdapter<WaveMessage> entityInsertionAdapter;
        EntityInsertionAdapter<ChatParticipantCrossRef> entityInsertionAdapter2;
        EntityInsertionAdapter<Chat> entityInsertionAdapter3;
        EntityInsertionAdapter<ChatOwnerCrossRef> entityInsertionAdapter4;
        EntityInsertionAdapter<ChatMessage> entityInsertionAdapter5;
        EntityInsertionAdapter<ChatMessage> entityInsertionAdapter6;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter6;
        entityInsertionAdapter6 = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `ChatMessage` (`chatMessageTopicId`,`chatMessageSeq`,`senderUserId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                long l = chatMessage.getSeq();
                supportSQLiteStatement.bindLong(2, l);
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, chatMessage.getSenderUserId());
                }
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(4, l3);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, (String)object);
                }
            }
        };
        this.__insertionAdapterOfChatMessage = converters2;
        converters2 = entityInsertionAdapter5;
        entityInsertionAdapter5 = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatMessage` (`chatMessageTopicId`,`chatMessageSeq`,`senderUserId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                long l = chatMessage.getSeq();
                supportSQLiteStatement.bindLong(2, l);
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, chatMessage.getSenderUserId());
                }
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(4, l3);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, (String)object);
                }
            }
        };
        this.__insertionAdapterOfChatMessage_1 = converters2;
        converters2 = entityInsertionAdapter4;
        entityInsertionAdapter4 = new EntityInsertionAdapter<ChatOwnerCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatOwnerCrossRef` (`chatId`,`chatUserId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatOwnerCrossRef chatOwnerCrossRef) {
                if (chatOwnerCrossRef.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatOwnerCrossRef.getChatId());
                }
                if (chatOwnerCrossRef.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatOwnerCrossRef.getChatUserId());
                }
            }
        };
        this.__insertionAdapterOfChatOwnerCrossRef = converters2;
        converters2 = entityInsertionAdapter3;
        entityInsertionAdapter3 = new EntityInsertionAdapter<Chat>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Chat` (`chatId`,`name`,`seq`,`readSeq`,`recvSeq`,`updatedAt`,`touchedAt`,`externalId`,`fn`,`title`,`tags`,`data`,`format`,`want`,`given`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Chat chat) {
                Object object;
                if (chat.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chat.getChatId());
                }
                if (chat.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chat.getName());
                }
                long l = chat.getSeq();
                supportSQLiteStatement.bindLong(3, l);
                l = chat.getReadSeq();
                supportSQLiteStatement.bindLong(4, l);
                l = chat.getRecvSeq();
                supportSQLiteStatement.bindLong(5, l);
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chat.getUpdatedAt());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(6, l3);
                }
                Long l4 = object.MessagingDao_Impl.this.__converters.dateToString(chat.getTouchedAt());
                if (l4 == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    long l5 = l4;
                    supportSQLiteStatement.bindLong(7, l5);
                }
                TinodeUserPublic tinodeUserPublic = chat.getPublicData();
                if (tinodeUserPublic != null) {
                    if (tinodeUserPublic.getExternalId() == null) {
                        supportSQLiteStatement.bindNull(8);
                    } else {
                        supportSQLiteStatement.bindString(8, tinodeUserPublic.getExternalId());
                    }
                    if (tinodeUserPublic.getFn() == null) {
                        supportSQLiteStatement.bindNull(9);
                    } else {
                        supportSQLiteStatement.bindString(9, tinodeUserPublic.getFn());
                    }
                    if (tinodeUserPublic.getTitle() == null) {
                        supportSQLiteStatement.bindNull(10);
                    } else {
                        supportSQLiteStatement.bindString(10, tinodeUserPublic.getTitle());
                    }
                    object = object.MessagingDao_Impl.this.__converters.stringListToString(tinodeUserPublic.getTags());
                    if (object == null) {
                        supportSQLiteStatement.bindNull(11);
                    } else {
                        supportSQLiteStatement.bindString(11, (String)object);
                    }
                    object = tinodeUserPublic.getPhoto();
                    if (object != null) {
                        if (((TinodePhoto)object).getData() == null) {
                            supportSQLiteStatement.bindNull(12);
                        } else {
                            supportSQLiteStatement.bindString(12, ((TinodePhoto)object).getData());
                        }
                        if (((TinodePhoto)object).getFormat() == null) {
                            supportSQLiteStatement.bindNull(13);
                        } else {
                            supportSQLiteStatement.bindString(13, ((TinodePhoto)object).getFormat());
                        }
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                        supportSQLiteStatement2.bindNull(12);
                        supportSQLiteStatement2.bindNull(13);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                    supportSQLiteStatement3.bindNull(8);
                    supportSQLiteStatement3.bindNull(9);
                    supportSQLiteStatement3.bindNull(10);
                    supportSQLiteStatement3.bindNull(11);
                    supportSQLiteStatement3.bindNull(12);
                    supportSQLiteStatement3.bindNull(13);
                }
                object = chat.getAccess();
                if (object != null) {
                    if (((Access)object).getWant() == null) {
                        supportSQLiteStatement.bindNull(14);
                    } else {
                        supportSQLiteStatement.bindString(14, ((Access)object).getWant());
                    }
                    if (((Access)object).getGiven() == null) {
                        supportSQLiteStatement.bindNull(15);
                    } else {
                        supportSQLiteStatement.bindString(15, ((Access)object).getGiven());
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement4 = supportSQLiteStatement;
                    supportSQLiteStatement4.bindNull(14);
                    supportSQLiteStatement4.bindNull(15);
                }
            }
        };
        this.__insertionAdapterOfChat = converters2;
        converters2 = entityInsertionAdapter2;
        entityInsertionAdapter2 = new EntityInsertionAdapter<ChatParticipantCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatParticipantCrossRef` (`chatId`,`chatUserId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatParticipantCrossRef chatParticipantCrossRef) {
                if (chatParticipantCrossRef.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatParticipantCrossRef.getChatId());
                }
                if (chatParticipantCrossRef.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatParticipantCrossRef.getChatUserId());
                }
            }
        };
        this.__insertionAdapterOfChatParticipantCrossRef = converters2;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<WaveMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `WaveMessage` (`chatUserId`,`userName`,`userAvatar`,`sentAt`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WaveMessage waveMessage) {
                if (waveMessage.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, waveMessage.getChatUserId());
                }
                if (waveMessage.getUserName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, waveMessage.getUserName());
                }
                if (waveMessage.getUserAvatar() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, waveMessage.getUserAvatar());
                }
                Long l = l.MessagingDao_Impl.this.__converters.dateToString(waveMessage.getSentAt());
                if (l == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    long l2 = l;
                    supportSQLiteStatement.bindLong(4, l2);
                }
            }
        };
        this.__insertionAdapterOfWaveMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter3;
        entityDeletionOrUpdateAdapter3 = new EntityDeletionOrUpdateAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `ChatMessage` WHERE `chatMessageTopicId` = ? AND `chatMessageSeq` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                long l = chatMessage.getSeq();
                supportSQLiteStatement.bindLong(2, l);
            }
        };
        this.__deletionAdapterOfChatMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter2;
        entityDeletionOrUpdateAdapter2 = new EntityDeletionOrUpdateAdapter<WaveMessage>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `WaveMessage` WHERE `chatUserId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WaveMessage waveMessage) {
                if (waveMessage.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, waveMessage.getChatUserId());
                }
            }
        };
        this.__deletionAdapterOfWaveMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter;
        entityDeletionOrUpdateAdapter = new EntityDeletionOrUpdateAdapter<ChatMessageUpdate>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `ChatMessage` SET `chatMessageTopicId` = ?,`chatMessageSeq` = ?,`status` = ? WHERE `chatMessageTopicId` = ? AND `chatMessageSeq` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessageUpdate chatMessageUpdate) {
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessageUpdate.getTopicId());
                }
                long l = chatMessageUpdate.getSeq();
                supportSQLiteStatement.bindLong(2, l);
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessageUpdate.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, chatMessageUpdate.getTopicId());
                }
                long l2 = chatMessageUpdate.getSeq();
                supportSQLiteStatement.bindLong(5, l2);
            }
        };
        this.__updateAdapterOfChatMessageUpdateAsChatMessage = converters2;
        converters2 = sharedSQLiteStatement3;
        sharedSQLiteStatement3 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatMessage WHERE chatMessageTopicId = ? AND status = ?";
            }
        };
        this.__preparedStmtOfDeleteMessages = converters2;
        converters2 = sharedSQLiteStatement2;
        sharedSQLiteStatement2 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Chat";
            }
        };
        this.__preparedStmtOfDeleteChats = converters2;
        converters2 = sharedSQLiteStatement;
        sharedSQLiteStatement = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM WaveMessage WHERE sentAt <= ?";
            }
        };
        this.__preparedStmtOfDeleteWaveEvents = converters2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact(ArrayMap<String, TinodeContact> var1_1) {
        block92: {
            var2_2 = var1_1.keySet();
            if (var2_2.isEmpty()) {
                return;
            }
            if (var1_1.size() > 999) {
                var2_2 = v0;
                v0 = new ArrayMap(999);
                var3_5 = 0;
                var5_10 = var1_1.size();
                for (var4_7 = 0; var4_7 < var5_10; ++var4_7) {
                    var2_2.put(var1_1.keyAt(var4_7), null);
                    if (++var3_5 != 999) continue;
                    this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)var2_2);
                    var1_1.putAll((Map)var2_2);
                    var2_2 = v1;
                    v1 = new ArrayMap(999);
                    var3_5 = 0;
                }
                if (var3_5 > 0) {
                    this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)var2_2);
                    var1_1.putAll((Map)var2_2);
                }
                return;
            }
            v2 = StringUtil.newStringBuilder();
            v2.append("SELECT `chatUserId`,`chatToken`,`chatExpiration`,`chatName`,`online`,`lastFullSync`,`photoData`,`privateData`,`externalId`,`fn`,`title`,`tags`,`data`,`format` FROM `TinodeContact` WHERE `chatUserId` IN (");
            var2_3 = var2_2.size();
            StringUtil.appendPlaceholders((StringBuilder)v2, (int)var2_3);
            v2.append(")");
            var2_4 = RoomSQLiteQuery.acquire((String)v2.toString(), (int)(var2_3 + 0));
            var3_6 = 1;
            for (String var5_11 : var2_2) {
                if (var5_11 == null) {
                    var2_4.bindNull(var3_6);
                } else {
                    var2_4.bindString(var3_6, var5_11);
                }
                ++var3_6;
            }
            var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)false, null);
            var3_6 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatUserId");
            if (var3_6 != -1) break block92;
            var2_4.close();
            return;
        }
        v3 = var2_4;
        v4 = v3;
        v5 = v3;
        v6 = v3;
        v7 = v3;
        v8 = v3;
        v9 = v3;
        v10 = v3;
        v11 = v3;
        v12 = v3;
        v13 = v3;
        v14 = v3;
        v15 = v3;
        v16 = v3;
        var4_9 = CursorUtil.getColumnIndex((Cursor)v3, (String)"chatUserId");
        var5_12 = CursorUtil.getColumnIndex((Cursor)v14, (String)"chatToken");
        var6_13 = CursorUtil.getColumnIndex((Cursor)v15, (String)"chatExpiration");
        var7_14 = CursorUtil.getColumnIndex((Cursor)v16, (String)"chatName");
        var8_15 = CursorUtil.getColumnIndex((Cursor)v12, (String)"online");
        var9_16 = CursorUtil.getColumnIndex((Cursor)v13, (String)"lastFullSync");
        var10_17 = CursorUtil.getColumnIndex((Cursor)v10, (String)"photoData");
        var11_18 = CursorUtil.getColumnIndex((Cursor)v11, (String)"privateData");
        var12_19 = CursorUtil.getColumnIndex((Cursor)v8, (String)"externalId");
        var13_20 = CursorUtil.getColumnIndex((Cursor)v9, (String)"fn");
        var14_21 = CursorUtil.getColumnIndex((Cursor)v6, (String)"title");
        var15_22 = CursorUtil.getColumnIndex((Cursor)v7, (String)"tags");
        var16_23 = CursorUtil.getColumnIndex((Cursor)v4, (String)"data");
        try {
            var17_24 = CursorUtil.getColumnIndex((Cursor)v5, (String)"format");
        }
        catch (Throwable v21) {
            var2_4.close();
            throw v21;
        }
        while (true) {
            block104: {
                block100: {
                    block103: {
                        block102: {
                            block101: {
                                block99: {
                                    block94: {
                                        block93: {
                                            if (!var2_4.moveToNext()) break;
                                            v17 = var1_1;
                                            var18_25 = var2_4.getString(var3_6);
                                            if (!v17.containsKey((Object)var18_25)) continue;
                                            if (var4_9 != -1) break block93;
                                            var19_26 = null;
                                            break block94;
                                        }
                                        var19_26 = var2_4.getString(var4_9);
                                    }
                                    if (var5_12 == -1) {
                                        var20_27 = null;
                                    } else {
                                        var20_27 = var2_4.getString(var5_12);
                                    }
                                    if (var6_13 == -1) {
                                        var21_28 /* !! */  = null;
                                    } else {
                                        block96: {
                                            block95: {
                                                if (!var2_4.isNull(var6_13)) break block95;
                                                var21_28 /* !! */  = null;
                                                break block96;
                                            }
                                            var21_28 /* !! */  = var2_4.getLong(var6_13);
                                        }
                                        var21_28 /* !! */  = this.__converters.timestampToDate(var21_28 /* !! */ );
                                    }
                                    if (var7_14 == -1) {
                                        var22_29 = null;
                                    } else {
                                        var22_29 = var2_4.getString(var7_14);
                                    }
                                    if (var8_15 == -1) {
                                        while (true) {
                                            var23_30 = false;
                                            break;
                                        }
                                    } else {
                                        if (var2_4.getInt(var8_15) == 0) ** continue;
                                        var23_30 = true;
                                    }
                                    if (var9_16 == -1) {
                                        var24_31 /* !! */  = null;
                                    } else {
                                        block98: {
                                            block97: {
                                                if (!var2_4.isNull(var9_16)) break block97;
                                                var24_31 /* !! */  = null;
                                                break block98;
                                            }
                                            var24_31 /* !! */  = var2_4.getLong(var9_16);
                                        }
                                        var24_31 /* !! */  = this.__converters.timestampToDate(var24_31 /* !! */ );
                                    }
                                    if (var10_17 == -1) {
                                        var25_32 = null;
                                    } else {
                                        var25_32 = var2_4.getString(var10_17);
                                    }
                                    if (var11_18 == -1) {
                                        var26_33 = null;
                                    } else {
                                        var26_33 = var2_4.getString(var11_18);
                                    }
                                    if (var12_19 != -1) {
                                        if (!var2_4.isNull(var12_19)) break block99;
                                    }
                                    if (var13_20 != -1) {
                                        if (!var2_4.isNull(var13_20)) break block99;
                                    }
                                    if (var14_21 != -1) {
                                        if (!var2_4.isNull(var14_21)) break block99;
                                    }
                                    if (var15_22 != -1) {
                                        if (!var2_4.isNull(var15_22)) break block99;
                                    }
                                    if (var16_23 != -1) {
                                        if (!var2_4.isNull(var16_23)) break block99;
                                    }
                                    if (var17_24 == -1) break block100;
                                    if (var2_4.isNull(var17_24)) break block100;
                                }
                                if (var12_19 == -1) {
                                    var27_34 = null;
                                } else {
                                    var27_34 = var2_4.getString(var12_19);
                                }
                                if (var13_20 == -1) {
                                    var28_35 = null;
                                } else {
                                    var28_35 = var2_4.getString(var13_20);
                                }
                                if (var14_21 == -1) {
                                    var29_36 = null;
                                } else {
                                    var29_36 = var2_4.getString(var14_21);
                                }
                                if (var15_22 == -1) {
                                    var30_37 = null;
                                } else {
                                    v18 = this;
                                    var30_37 = var2_4.getString(var15_22);
                                    var30_37 = v18.__converters.stringToStringList((String)var30_37);
                                }
                                if (var16_23 != -1) {
                                    if (!var2_4.isNull(var16_23)) break block101;
                                }
                                if (var17_24 == -1) break block102;
                                if (var2_4.isNull(var17_24)) break block102;
                            }
                            if (var16_23 == -1) {
                                var31_38 = null;
                            } else {
                                var31_38 = var2_4.getString(var16_23);
                            }
                            if (var17_24 == -1) {
                                var32_39 = null;
                            } else {
                                var32_39 = var2_4.getString(var17_24);
                            }
                            var33_40 = v19;
                            v19 = new TinodePhoto((String)var31_38, var32_39);
                            break block103;
                        }
                        var33_40 = null;
                    }
                    var31_38 = v20;
                    v20 = new TinodeUserPublic(var27_34, var28_35, var29_36, var33_40, (List<String>)var30_37);
                    break block104;
                }
                var31_38 = null;
            }
            var1_1.put((Object)var18_25, (Object)new TinodeContact(var19_26, var20_27, (Date)var21_28 /* !! */ , var22_29, var23_30, (Date)var24_31 /* !! */ , var25_32, var26_33, (TinodeUserPublic)var31_38));
        }
        var2_4.close();
        return;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1(ArrayMap<String, ArrayList<TinodeContact>> var1_1) {
        var2_2 = var1_1.keySet();
        if (var2_2.isEmpty()) {
            return;
        }
        if (var1_1.size() > 999) {
            var2_2 = v0;
            v0 = new ArrayMap(999);
            var3_5 = 0;
            var5_11 = var1_1.size();
            for (var4_8 = 0; var4_8 < var5_11; ++var4_8) {
                v1 = var1_1;
                var3_6 = v1.keyAt(var4_8);
                var2_2.put(var3_6, v1.valueAt(var4_8));
                if (++var3_5 != 999) continue;
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)var2_2);
                var2_2 = v2;
                v2 = new ArrayMap(999);
                var3_5 = 0;
            }
            if (var3_5 > 0) {
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)var2_2);
            }
            return;
        }
        v3 = StringUtil.newStringBuilder();
        v3.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`chatToken` AS `chatToken`,`TinodeContact`.`chatExpiration` AS `chatExpiration`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`lastFullSync` AS `lastFullSync`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`fn` AS `fn`,`TinodeContact`.`title` AS `title`,`TinodeContact`.`tags` AS `tags`,`TinodeContact`.`data` AS `data`,`TinodeContact`.`format` AS `format`,_junction.`chatId` FROM `ChatParticipantCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        var2_3 = var2_2.size();
        StringUtil.appendPlaceholders((StringBuilder)v3, (int)var2_3);
        v3.append(")");
        var2_4 = RoomSQLiteQuery.acquire((String)v3.toString(), (int)(var2_3 + 0));
        var3_7 = 1;
        for (String var5_12 : var2_2) {
            if (var5_12 == null) {
                var2_4.bindNull(var3_7);
            } else {
                var2_4.bindString(var3_7, var5_12);
            }
            ++var3_7;
        }
        var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)false, null);
        var3_7 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatUserId");
        var4_10 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatToken");
        var5_13 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatExpiration");
        var6_14 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatName");
        var7_15 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"online");
        var8_16 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"lastFullSync");
        var9_17 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"photoData");
        var10_18 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"privateData");
        var11_19 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"externalId");
        var12_20 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"fn");
        var13_21 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"title");
        var14_22 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"tags");
        var15_23 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"data");
        try {
            var16_24 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"format");
        }
        catch (Throwable v7) {
            var2_4.close();
            throw v7;
        }
        while (true) {
            block101: {
                block97: {
                    block100: {
                        block99: {
                            block98: {
                                block96: {
                                    block91: {
                                        block90: {
                                            if (!var2_4.moveToNext()) break;
                                            var17_25 = (ArrayList)var1_1.get((Object)var2_4.getString(14));
                                            if (var17_25 == null) continue;
                                            if (var3_7 != -1) break block90;
                                            var18_26 = null;
                                            break block91;
                                        }
                                        var18_26 = var2_4.getString(var3_7);
                                    }
                                    if (var4_10 == -1) {
                                        var19_27 = null;
                                    } else {
                                        var19_27 = var2_4.getString(var4_10);
                                    }
                                    if (var5_13 == -1) {
                                        var20_28 /* !! */  = null;
                                    } else {
                                        block93: {
                                            block92: {
                                                if (!var2_4.isNull(var5_13)) break block92;
                                                var20_28 /* !! */  = null;
                                                break block93;
                                            }
                                            var20_28 /* !! */  = var2_4.getLong(var5_13);
                                        }
                                        var20_28 /* !! */  = this.__converters.timestampToDate(var20_28 /* !! */ );
                                    }
                                    if (var6_14 == -1) {
                                        var21_29 = null;
                                    } else {
                                        var21_29 = var2_4.getString(var6_14);
                                    }
                                    if (var7_15 == -1) {
                                        while (true) {
                                            var22_30 = false;
                                            break;
                                        }
                                    } else {
                                        if (var2_4.getInt(var7_15) == 0) ** continue;
                                        var22_30 = true;
                                    }
                                    if (var8_16 == -1) {
                                        var23_31 /* !! */  = null;
                                    } else {
                                        block95: {
                                            block94: {
                                                if (!var2_4.isNull(var8_16)) break block94;
                                                var23_31 /* !! */  = null;
                                                break block95;
                                            }
                                            var23_31 /* !! */  = var2_4.getLong(var8_16);
                                        }
                                        var23_31 /* !! */  = this.__converters.timestampToDate(var23_31 /* !! */ );
                                    }
                                    if (var9_17 == -1) {
                                        var24_32 = null;
                                    } else {
                                        var24_32 = var2_4.getString(var9_17);
                                    }
                                    if (var10_18 == -1) {
                                        var25_33 = null;
                                    } else {
                                        var25_33 = var2_4.getString(var10_18);
                                    }
                                    if (var11_19 != -1) {
                                        if (!var2_4.isNull(var11_19)) break block96;
                                    }
                                    if (var12_20 != -1) {
                                        if (!var2_4.isNull(var12_20)) break block96;
                                    }
                                    if (var13_21 != -1) {
                                        if (!var2_4.isNull(var13_21)) break block96;
                                    }
                                    if (var14_22 != -1) {
                                        if (!var2_4.isNull(var14_22)) break block96;
                                    }
                                    if (var15_23 != -1) {
                                        if (!var2_4.isNull(var15_23)) break block96;
                                    }
                                    if (var16_24 == -1) break block97;
                                    if (var2_4.isNull(var16_24)) break block97;
                                }
                                if (var11_19 == -1) {
                                    var26_34 = null;
                                } else {
                                    var26_34 = var2_4.getString(var11_19);
                                }
                                if (var12_20 == -1) {
                                    var27_35 = null;
                                } else {
                                    var27_35 = var2_4.getString(var12_20);
                                }
                                if (var13_21 == -1) {
                                    var28_36 = null;
                                } else {
                                    var28_36 = var2_4.getString(var13_21);
                                }
                                if (var14_22 == -1) {
                                    var29_37 = null;
                                } else {
                                    v4 = this;
                                    var29_37 = var2_4.getString(var14_22);
                                    var29_37 = v4.__converters.stringToStringList((String)var29_37);
                                }
                                if (var15_23 != -1) {
                                    if (!var2_4.isNull(var15_23)) break block98;
                                }
                                if (var16_24 == -1) break block99;
                                if (var2_4.isNull(var16_24)) break block99;
                            }
                            if (var15_23 == -1) {
                                var30_38 = null;
                            } else {
                                var30_38 = var2_4.getString(var15_23);
                            }
                            if (var16_24 == -1) {
                                var31_39 = null;
                            } else {
                                var31_39 = var2_4.getString(var16_24);
                            }
                            var32_40 = v5;
                            v5 = new TinodePhoto((String)var30_38, var31_39);
                            break block100;
                        }
                        var32_40 = null;
                    }
                    var30_38 = v6;
                    v6 = new TinodeUserPublic(var26_34, var27_35, var28_36, var32_40, (List<String>)var29_37);
                    break block101;
                }
                var30_38 = null;
            }
            var17_25.add(new TinodeContact(var18_26, var19_27, (Date)var20_28 /* !! */ , var21_29, var22_30, (Date)var23_31 /* !! */ , var24_32, var25_33, (TinodeUserPublic)var30_38));
        }
        var2_4.close();
        return;
    }

    private void __fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage(ArrayMap<String, ArrayList<ChatMessage>> arrayMap) {
        int n;
        int n2;
        RoomSQLiteQuery roomSQLiteQuery;
        block50: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n3 = 0;
                int n4 = arrayMap.size();
                for (int j = 0; j < n4; ++j) {
                    ArrayMap arrayMap3;
                    ArrayMap<String, ArrayList<ChatMessage>> arrayMap4 = arrayMap;
                    Object object = arrayMap4.keyAt(j);
                    set.put(object, arrayMap4.valueAt(j));
                    if (++n3 != 999) continue;
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatMessageTopicId`,`chatMessageSeq`,`senderUserId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status` FROM `ChatMessage` WHERE `chatMessageTopicId` IN (");
            int n5 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
            n2 = 1;
            for (String string2 : set) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                ++n2;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatMessageTopicId");
            if (n2 != -1) break block50;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery7 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery8 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery9 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery10 = roomSQLiteQuery2;
        int n6 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery2, (String)"chatMessageTopicId");
        int n7 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery8, (String)"chatMessageSeq");
        int n8 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery9, (String)"senderUserId");
        int n9 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery10, (String)"date");
        int n10 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery6, (String)"text");
        int n11 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery7, (String)"type");
        int n12 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery4, (String)"subtype");
        int n13 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery5, (String)"replyTo");
        try {
            n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery3, (String)"status");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            Object object;
            String string3;
            String string4;
            String string5;
            String string6;
            Comparable<Long> comparable;
            String string7;
            int n14;
            String string8;
            ArrayList arrayList;
            block52: {
                block51: {
                    if (!roomSQLiteQuery.moveToNext()) break;
                    arrayList = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(n2));
                    if (arrayList == null) continue;
                    if (n6 != -1) break block51;
                    string8 = null;
                    break block52;
                }
                string8 = roomSQLiteQuery.getString(n6);
            }
            if (n7 == -1) {
                n14 = 0;
            } else {
                n14 = roomSQLiteQuery.getInt(n7);
            }
            if (n8 == -1) {
                string7 = null;
            } else {
                string7 = roomSQLiteQuery.getString(n8);
            }
            if (n9 == -1) {
                comparable = null;
            } else {
                block54: {
                    block53: {
                        if (!roomSQLiteQuery.isNull(n9)) break block53;
                        comparable = null;
                        break block54;
                    }
                    comparable = roomSQLiteQuery.getLong(n9);
                }
                comparable = this.__converters.timestampToDate((Long)comparable);
            }
            if (n10 == -1) {
                string6 = null;
            } else {
                string6 = roomSQLiteQuery.getString(n10);
            }
            if (n11 == -1) {
                string5 = null;
            } else {
                string5 = roomSQLiteQuery.getString(n11);
            }
            if (n12 == -1) {
                string4 = null;
            } else {
                string4 = roomSQLiteQuery.getString(n12);
            }
            if (n13 == -1) {
                string3 = null;
            } else {
                string3 = roomSQLiteQuery.getString(n13);
            }
            if (n == -1) {
                object = null;
            } else {
                MessagingDao_Impl messagingDao_Impl = this;
                object = roomSQLiteQuery.getString(n);
                object = messagingDao_Impl.__converters.stringToChatStatus((String)object);
            }
            arrayList.add(new ChatMessage(string8, n14, string7, (Date)comparable, string6, string5, string4, string3, (ChatMessageStatus)((Object)object)));
        }
        roomSQLiteQuery.close();
        return;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_2(ArrayMap<String, TinodeContact> var1_1) {
        var2_2 = var1_1.keySet();
        if (var2_2.isEmpty()) {
            return;
        }
        if (var1_1.size() > 999) {
            var2_2 = v0;
            v0 = new ArrayMap(999);
            var3_5 = 0;
            var5_10 = var1_1.size();
            for (var4_7 = 0; var4_7 < var5_10; ++var4_7) {
                var2_2.put(var1_1.keyAt(var4_7), null);
                if (++var3_5 != 999) continue;
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_2((ArrayMap<String, TinodeContact>)var2_2);
                var1_1.putAll((Map)var2_2);
                var2_2 = v1;
                v1 = new ArrayMap(999);
                var3_5 = 0;
            }
            if (var3_5 > 0) {
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_2((ArrayMap<String, TinodeContact>)var2_2);
                var1_1.putAll((Map)var2_2);
            }
            return;
        }
        v2 = StringUtil.newStringBuilder();
        v2.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`chatToken` AS `chatToken`,`TinodeContact`.`chatExpiration` AS `chatExpiration`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`lastFullSync` AS `lastFullSync`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`fn` AS `fn`,`TinodeContact`.`title` AS `title`,`TinodeContact`.`tags` AS `tags`,`TinodeContact`.`data` AS `data`,`TinodeContact`.`format` AS `format`,_junction.`chatId` FROM `ChatOwnerCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        var2_3 = var2_2.size();
        StringUtil.appendPlaceholders((StringBuilder)v2, (int)var2_3);
        v2.append(")");
        var2_4 = RoomSQLiteQuery.acquire((String)v2.toString(), (int)(var2_3 + 0));
        var3_6 = 1;
        for (String var5_11 : var2_2) {
            if (var5_11 == null) {
                var2_4.bindNull(var3_6);
            } else {
                var2_4.bindString(var3_6, var5_11);
            }
            ++var3_6;
        }
        var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)false, null);
        var3_6 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatUserId");
        var4_9 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatToken");
        var5_12 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatExpiration");
        var6_13 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatName");
        var7_14 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"online");
        var8_15 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"lastFullSync");
        var9_16 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"photoData");
        var10_17 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"privateData");
        var11_18 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"externalId");
        var12_19 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"fn");
        var13_20 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"title");
        var14_21 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"tags");
        var15_22 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"data");
        try {
            var16_23 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"format");
        }
        catch (Throwable v7) {
            var2_4.close();
            throw v7;
        }
        while (true) {
            block102: {
                block98: {
                    block101: {
                        block100: {
                            block99: {
                                block97: {
                                    block92: {
                                        block91: {
                                            if (!var2_4.moveToNext()) break;
                                            v3 = var1_1;
                                            var17_24 = var2_4.getString(14);
                                            if (!v3.containsKey((Object)var17_24)) continue;
                                            if (var3_6 != -1) break block91;
                                            var18_25 = null;
                                            break block92;
                                        }
                                        var18_25 = var2_4.getString(var3_6);
                                    }
                                    if (var4_9 == -1) {
                                        var19_26 = null;
                                    } else {
                                        var19_26 = var2_4.getString(var4_9);
                                    }
                                    if (var5_12 == -1) {
                                        var20_27 /* !! */  = null;
                                    } else {
                                        block94: {
                                            block93: {
                                                if (!var2_4.isNull(var5_12)) break block93;
                                                var20_27 /* !! */  = null;
                                                break block94;
                                            }
                                            var20_27 /* !! */  = var2_4.getLong(var5_12);
                                        }
                                        var20_27 /* !! */  = this.__converters.timestampToDate(var20_27 /* !! */ );
                                    }
                                    if (var6_13 == -1) {
                                        var21_28 = null;
                                    } else {
                                        var21_28 = var2_4.getString(var6_13);
                                    }
                                    if (var7_14 == -1) {
                                        while (true) {
                                            var22_29 = false;
                                            break;
                                        }
                                    } else {
                                        if (var2_4.getInt(var7_14) == 0) ** continue;
                                        var22_29 = true;
                                    }
                                    if (var8_15 == -1) {
                                        var23_30 /* !! */  = null;
                                    } else {
                                        block96: {
                                            block95: {
                                                if (!var2_4.isNull(var8_15)) break block95;
                                                var23_30 /* !! */  = null;
                                                break block96;
                                            }
                                            var23_30 /* !! */  = var2_4.getLong(var8_15);
                                        }
                                        var23_30 /* !! */  = this.__converters.timestampToDate(var23_30 /* !! */ );
                                    }
                                    if (var9_16 == -1) {
                                        var24_31 = null;
                                    } else {
                                        var24_31 = var2_4.getString(var9_16);
                                    }
                                    if (var10_17 == -1) {
                                        var25_32 = null;
                                    } else {
                                        var25_32 = var2_4.getString(var10_17);
                                    }
                                    if (var11_18 != -1) {
                                        if (!var2_4.isNull(var11_18)) break block97;
                                    }
                                    if (var12_19 != -1) {
                                        if (!var2_4.isNull(var12_19)) break block97;
                                    }
                                    if (var13_20 != -1) {
                                        if (!var2_4.isNull(var13_20)) break block97;
                                    }
                                    if (var14_21 != -1) {
                                        if (!var2_4.isNull(var14_21)) break block97;
                                    }
                                    if (var15_22 != -1) {
                                        if (!var2_4.isNull(var15_22)) break block97;
                                    }
                                    if (var16_23 == -1) break block98;
                                    if (var2_4.isNull(var16_23)) break block98;
                                }
                                if (var11_18 == -1) {
                                    var26_33 = null;
                                } else {
                                    var26_33 = var2_4.getString(var11_18);
                                }
                                if (var12_19 == -1) {
                                    var27_34 = null;
                                } else {
                                    var27_34 = var2_4.getString(var12_19);
                                }
                                if (var13_20 == -1) {
                                    var28_35 = null;
                                } else {
                                    var28_35 = var2_4.getString(var13_20);
                                }
                                if (var14_21 == -1) {
                                    var29_36 = null;
                                } else {
                                    v4 = this;
                                    var29_36 = var2_4.getString(var14_21);
                                    var29_36 = v4.__converters.stringToStringList((String)var29_36);
                                }
                                if (var15_22 != -1) {
                                    if (!var2_4.isNull(var15_22)) break block99;
                                }
                                if (var16_23 == -1) break block100;
                                if (var2_4.isNull(var16_23)) break block100;
                            }
                            if (var15_22 == -1) {
                                var30_37 = null;
                            } else {
                                var30_37 = var2_4.getString(var15_22);
                            }
                            if (var16_23 == -1) {
                                var31_38 = null;
                            } else {
                                var31_38 = var2_4.getString(var16_23);
                            }
                            var32_39 = v5;
                            v5 = new TinodePhoto((String)var30_37, var31_38);
                            break block101;
                        }
                        var32_39 = null;
                    }
                    var30_37 = v6;
                    v6 = new TinodeUserPublic(var26_33, var27_34, var28_35, var32_39, (List<String>)var29_36);
                    break block102;
                }
                var30_37 = null;
            }
            var1_1.put((Object)var17_24, (Object)new TinodeContact(var18_25, var19_26, (Date)var20_27 /* !! */ , var21_28, var22_29, (Date)var23_30 /* !! */ , var24_31, var25_32, (TinodeUserPublic)var30_37));
        }
        var2_4.close();
        return;
    }

    private void __fetchRelationshipCallStatusAsioStreamlayerSdkModelCallsCallStatus(ArrayMap<String, CallStatus> arrayMap) {
        int n;
        int n2;
        RoomSQLiteQuery roomSQLiteQuery;
        block26: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n3 = 0;
                int n4 = arrayMap.size();
                for (int j = 0; j < n4; ++j) {
                    ArrayMap arrayMap3;
                    set.put(arrayMap.keyAt(j), null);
                    if (++n3 != 999) continue;
                    this.__fetchRelationshipCallStatusAsioStreamlayerSdkModelCallsCallStatus((ArrayMap<String, CallStatus>)set);
                    arrayMap.putAll((Map)((Object)set));
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.__fetchRelationshipCallStatusAsioStreamlayerSdkModelCallsCallStatus((ArrayMap<String, CallStatus>)set);
                    arrayMap.putAll((Map)((Object)set));
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `callId`,`status`,`participantStatuses` FROM `CallStatus` WHERE `callId` IN (");
            int n5 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
            n2 = 1;
            for (String string2 : set) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                ++n2;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"callId");
            if (n2 != -1) break block26;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        int n6 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery2, (String)"callId");
        int n7 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery4, (String)"status");
        try {
            n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery3, (String)"participantStatuses");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            Object object;
            Object object2;
            String string3;
            String string4;
            block28: {
                block27: {
                    if (!roomSQLiteQuery.moveToNext()) break;
                    ArrayMap<String, CallStatus> arrayMap4 = arrayMap;
                    string4 = roomSQLiteQuery.getString(n2);
                    if (!arrayMap4.containsKey((Object)string4)) continue;
                    if (n6 != -1) break block27;
                    string3 = null;
                    break block28;
                }
                string3 = roomSQLiteQuery.getString(n6);
            }
            if (n7 == -1) {
                object2 = null;
            } else {
                MessagingDao_Impl messagingDao_Impl = this;
                object2 = roomSQLiteQuery.getString(n7);
                object2 = messagingDao_Impl.__converters.stringToCallConnectionStatus((String)object2);
            }
            if (n == -1) {
                object = null;
            } else {
                MessagingDao_Impl messagingDao_Impl = this;
                object = roomSQLiteQuery.getString(n);
                object = messagingDao_Impl.__converters.stringToParticipantStatuses((String)object);
            }
            arrayMap.put((Object)string4, (Object)new CallStatus(string3, (CallConnectionStatus)((Object)object2), (List<CallParticipantStatus>)object));
        }
        roomSQLiteQuery.close();
        return;
    }

    static /* synthetic */ void access$300(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)arrayMap);
    }

    static /* synthetic */ void access$400(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)arrayMap);
    }

    static /* synthetic */ void access$500(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_2((ArrayMap<String, TinodeContact>)arrayMap);
    }

    static /* synthetic */ void access$600(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipCallStatusAsioStreamlayerSdkModelCallsCallStatus((ArrayMap<String, CallStatus>)arrayMap);
    }

    @Override
    public long saveChatMessage(ChatMessage chatMessage) {
        long l;
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            l = messagingDao_Impl.__insertionAdapterOfChatMessage.insertAndReturnId((Object)chatMessage);
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.setTransactionSuccessful();
            messagingDao_Impl2.__db.endTransaction();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        return l;
    }

    @Override
    public void saveChatMessages(List<ChatMessage> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatMessage_1.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatOwner(ChatOwnerCrossRef chatOwnerCrossRef) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatOwnerCrossRef.insert((Object)chatOwnerCrossRef);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveChats(List<Chat> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChat.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatParticipantCrossRefs(List<ChatParticipantCrossRef> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatParticipantCrossRef.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public long saveWaveMessage(WaveMessage waveMessage) {
        long l;
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            l = messagingDao_Impl.__insertionAdapterOfWaveMessage.insertAndReturnId((Object)waveMessage);
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.setTransactionSuccessful();
            messagingDao_Impl2.__db.endTransaction();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        return l;
    }

    @Override
    public void deleteChatMessage(ChatMessage chatMessage) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__deletionAdapterOfChatMessage.handle((Object)chatMessage);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteWaveMessage(WaveMessage waveMessage) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__deletionAdapterOfWaveMessage.handle((Object)waveMessage);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateChatMessage(ChatMessageUpdate chatMessageUpdate) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__updateAdapterOfChatMessageUpdateAsChatMessage.handle((Object)chatMessageUpdate);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChats(List<Chat> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__db.beginTransaction();
        try {
            MessagingDao.DefaultImpls.saveChats(messagingDao_Impl, list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatParticipants(String string2, List<TinodeContact> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__db.beginTransaction();
        try {
            MessagingDao.DefaultImpls.saveChatParticipants(messagingDao_Impl, string2, list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteMessages(String string2, ChatMessageStatus object) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteMessages.acquire();
        int n = 1;
        if (string2 == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, string2);
        }
        int n2 = 2;
        object = this.__converters.chatStatusToString((ChatMessageStatus)((Object)object));
        if (object == null) {
            supportSQLiteStatement.bindNull(n2);
        } else {
            supportSQLiteStatement.bindString(n2, (String)object);
        }
        MessagingDao_Impl messagingDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl3 = this;
            messagingDao_Impl3.__db.endTransaction();
            messagingDao_Impl3.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl2.__db.setTransactionSuccessful();
        messagingDao_Impl2.__db.endTransaction();
        messagingDao_Impl2.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
    }

    @Override
    public void deleteChats() {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteChats.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.endTransaction();
            messagingDao_Impl2.__preparedStmtOfDeleteChats.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
        messagingDao_Impl.__preparedStmtOfDeleteChats.release(supportSQLiteStatement);
    }

    @Override
    public void deleteWaveEvents(Date comparable) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteWaveEvents.acquire();
        int n = 1;
        comparable = messagingDao_Impl.__converters.dateToString((Date)comparable);
        if (comparable == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindLong(n, ((Long)comparable).longValue());
        }
        MessagingDao_Impl messagingDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl3 = this;
            messagingDao_Impl3.__db.endTransaction();
            messagingDao_Impl3.__preparedStmtOfDeleteWaveEvents.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl2.__db.setTransactionSuccessful();
        messagingDao_Impl2.__db.endTransaction();
        messagingDao_Impl2.__preparedStmtOfDeleteWaveEvents.release(supportSQLiteStatement);
    }

    @Override
    public Maybe<Integer> getLastSeqId(String string2) {
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT ChatMessage.chatMessageSeq FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? ORDER BY ChatMessage.chatMessageSeq DESC LIMIT 1", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        return Maybe.fromCallable((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Integer n;
                block5: {
                    block4: {
                        13 this_ = DBUtil.query((RoomDatabase)this_.MessagingDao_Impl.this.__db, (SupportSQLiteQuery)this_.roomSQLiteQuery, (boolean)false, null);
                        try {
                            if (!this_.moveToFirst()) break block4;
                        }
                        catch (Throwable throwable) {
                            this_.close();
                            throw throwable;
                        }
                        if (this_.isNull(0)) break block4;
                        n = this_.getInt(0);
                        break block5;
                    }
                    n = null;
                }
                this_.close();
                return n;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        });
    }

    @Override
    public Maybe<ChatMessageRelation> getChatMessageRelation(String string2, int n) {
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? AND ChatMessage.chatMessageSeq = ?", (int)2);
        int n2 = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, string2);
        }
        long l = n;
        roomSQLiteQuery.bindLong(2, l);
        return Maybe.fromCallable((Callable)new Callable<ChatMessageRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public ChatMessageRelation call() throws Exception {
                block50: {
                    block46: {
                        block49: {
                            block48: {
                                block47: {
                                    v0 = this;
                                    MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                                    var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                    var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageTopicId");
                                    var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageSeq");
                                    var4_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"senderUserId");
                                    var5_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"date");
                                    var6_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"text");
                                    var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                                    var8_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"subtype");
                                    var9_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"replyTo");
                                    var10_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"status");
                                    var11_20 = v1;
                                    v1 = new ArrayMap();
                                    ** while (var1_1.moveToNext())
lbl-1000:
                                    // 1 sources

                                    {
                                        var11_20.put((Object)var1_1.getString(var4_7), null);
                                        continue;
                                    }
lbl32:
                                    // 2 sources

                                    v2 = var1_1;
                                    v3 = this;
                                    var1_1.moveToPosition(-1);
                                    MessagingDao_Impl.access$200(v3.MessagingDao_Impl.this, var11_20);
                                    if (!v2.moveToFirst()) break block46;
                                    if (!var1_1.isNull(var2_2)) break block47;
                                    if (!var1_1.isNull(var3_5)) break block47;
                                    if (!var1_1.isNull(var4_7)) break block47;
                                    if (!var1_1.isNull(var5_8)) break block47;
                                    if (!var1_1.isNull(var6_10)) break block47;
                                    if (!var1_1.isNull(var7_12)) break block47;
                                    if (!var1_1.isNull(var8_14)) break block47;
                                    if (!var1_1.isNull(var9_16)) break block47;
                                    if (!var1_1.isNull(var10_18)) break block47;
                                    var13_21 = var2_3 = null;
                                    ** GOTO lbl108
                                }
                                v4 = var1_1;
                                v5 = var5_8;
                                v6 = var1_1;
                                v7 = var4_7;
                                v8 = var1_1;
                                v9 = var3_5;
                                var2_3 = var1_1.getString(var2_2);
                                var3_5 = v8.getInt(v9);
                                var12_22 = v6.getString(v7);
                                if (!v4.isNull(v5)) break block48;
                                var5_9 /* !! */  = null;
                                break block49;
                            }
                            var5_9 /* !! */  = var1_1.getLong(var5_8);
                        }
                        v10 = this;
                        v11 = var1_1;
                        v12 = var10_18;
                        v13 = var1_1;
                        v14 = var9_16;
                        v15 = var1_1;
                        v16 = var8_14;
                        v17 = var1_1;
                        v18 = var7_12;
                        v19 = var1_1;
                        v20 = var6_10;
                        var5_9 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var5_9 /* !! */ );
                        var6_11 = v19.getString(v20);
                        var7_13 = v17.getString(v18);
                        var8_15 = v15.getString(v16);
                        var9_17 = v13.getString(v14);
                        var10_19 /* !! */  = v11.getString(v12);
                        var10_19 /* !! */  = MessagingDao_Impl.access$000(v10.MessagingDao_Impl.this).stringToChatStatus(var10_19 /* !! */ );
                        var13_21 = v21;
                        v21 = new ChatMessage((String)var2_3, var3_5, var12_22, (Date)var5_9 /* !! */ , var6_11, var7_13, var8_15, var9_17, (ChatMessageStatus)var10_19 /* !! */ );
lbl108:
                        // 2 sources

                        var2_3 = (TinodeContact)var11_20.get((Object)var1_1.getString(var4_7));
                        var3_6 = v22;
                        v22 = new ChatMessageRelation((ChatMessage)var13_21, (TinodeContact)var2_3);
                        break block50;
                    }
                    var3_6 = null;
                }
                v23 = var3_6;
                v24 = this;
                v25 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v25.close();
                {
                    catch (Throwable v26) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v26;
                    }
                }
                MessagingDao_Impl.access$100(v24.MessagingDao_Impl.this).endTransaction();
                return v23;
                catch (Throwable var2_4) {
                    var1_1.close();
                    throw var2_4;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        });
    }

    @Override
    public DataSource.Factory<Integer, ChatMessageRelation> getChatMessagesRelationLiveData(String string2) {
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? ORDER BY ChatMessage.chatMessageSeq DESC", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        return new DataSource.Factory<Integer, ChatMessageRelation>(){

            public LimitOffsetDataSource<ChatMessageRelation> create() {
                15 v0 = this_;
                15 this_ = v0.MessagingDao_Impl.this.__db;
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                stringArray[0] = "TinodeContact";
                stringArray[1] = "ChatMessage";
                return new LimitOffsetDataSource<ChatMessageRelation>((RoomDatabase)this_, v0.roomSQLiteQuery, true, stringArray2){

                    protected List<ChatMessageRelation> convertRows(Cursor cursor) {
                        ArrayList<ChatMessageRelation> arrayList;
                        ArrayMap arrayMap;
                        Cursor cursor2 = cursor;
                        int n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"chatMessageTopicId");
                        int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"chatMessageSeq");
                        int n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"senderUserId");
                        int n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"date");
                        int n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"text");
                        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"type");
                        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"subtype");
                        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"replyTo");
                        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"status");
                        ArrayMap arrayMap2 = arrayMap;
                        arrayMap = new ArrayMap();
                        while (cursor.moveToNext()) {
                            arrayMap2.put((Object)cursor.getString(n3), null);
                        }
                        cursor.moveToPosition(-1);
                        MessagingDao_Impl.this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)arrayMap2);
                        ArrayList<ChatMessageRelation> arrayList2 = arrayList;
                        arrayList = new ArrayList<ChatMessageRelation>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Object object;
                            Object object2;
                            if (cursor.isNull(n) && cursor.isNull(n2) && cursor.isNull(n3) && cursor.isNull(n4) && cursor.isNull(n5) && cursor.isNull(n6) && cursor.isNull(n7) && cursor.isNull(n8) && cursor.isNull(n9)) {
                                object = object2 = null;
                            } else {
                                ChatMessage chatMessage;
                                object2 = cursor.getString(n);
                                int n10 = cursor.getInt(n2);
                                String string2 = cursor.getString(n3);
                                Comparable<Long> comparable = cursor.isNull(n4) ? null : Long.valueOf(cursor.getLong(n4));
                                comparable = MessagingDao_Impl.this.__converters.timestampToDate((Long)comparable);
                                String string3 = cursor.getString(n5);
                                String string4 = cursor.getString(n6);
                                String string5 = cursor.getString(n7);
                                String string6 = cursor.getString(n8);
                                Object object3 = cursor.getString(n9);
                                object3 = MessagingDao_Impl.this.__converters.stringToChatStatus((String)object3);
                                object = chatMessage;
                                chatMessage = new ChatMessage((String)object2, n10, string2, (Date)comparable, string3, string4, string5, string6, (ChatMessageStatus)((Object)object3));
                            }
                            object2 = (TinodeContact)arrayMap2.get((Object)cursor.getString(n3));
                            arrayList2.add(new ChatMessageRelation((ChatMessage)object, (TinodeContact)object2));
                        }
                        return arrayList2;
                    }
                };
            }
        };
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public List<ChatMessageRelation> getChatMessagesRelationList(String var1_1, Integer var2_5, Integer var3_8, int var4_10) {
        var5_11 = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? AND (chatMessageSeq < ? OR ? IS NULL) AND (chatMessageSeq >= ? OR ? IS NULL) ORDER BY ChatMessage.chatMessageSeq DESC LIMIT ?", (int)6);
        var6_12 = 1;
        if (var1_1 == null) {
            var5_11.bindNull(var6_12);
        } else {
            var5_11.bindString(var6_12, var1_1);
        }
        var1_2 = 2;
        if (var2_5 == null) {
            var5_11.bindNull(var1_2);
        } else {
            var5_11.bindLong(var1_2, (long)var2_5.intValue());
        }
        var1_2 = 3;
        if (var2_5 == null) {
            var5_11.bindNull(var1_2);
        } else {
            var5_11.bindLong(var1_2, (long)var2_5.intValue());
        }
        var1_2 = 4;
        if (var3_8 == null) {
            var5_11.bindNull(var1_2);
        } else {
            var5_11.bindLong(var1_2, (long)var3_8.intValue());
        }
        var1_2 = 5;
        if (var3_8 == null) {
            var5_11.bindNull(var1_2);
        } else {
            var5_11.bindLong(var1_2, (long)var3_8.intValue());
        }
        v0 = this;
        var1_3 = var4_10;
        var5_11.bindLong(6, var1_3);
        v0.__db.assertNotSuspendingTransaction();
        v0.__db.beginTransaction();
        var1_4 = DBUtil.query((RoomDatabase)v0.__db, (SupportSQLiteQuery)var5_11, (boolean)true, null);
        var2_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"chatMessageTopicId");
        var3_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"chatMessageSeq");
        var4_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"senderUserId");
        var6_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"date");
        var7_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"text");
        var8_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"type");
        var9_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"subtype");
        var10_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"replyTo");
        var11_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"status");
        var12_18 = v1;
        v1 = new ArrayMap();
        ** while (var1_4.moveToNext())
lbl-1000:
        // 1 sources

        {
            var12_18.put((Object)var1_4.getString(var4_10), null);
            continue;
        }
lbl61:
        // 2 sources

        v2 = this;
        v3 = var12_18;
        var1_4.moveToPosition(-1);
        v2.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)v3);
        var13_19 = v4;
        v4 = new ArrayList<ChatMessageRelation>(var1_4.getCount());
        ** while (var1_4.moveToNext())
lbl-1000:
        // 1 sources

        {
            block59: {
                block58: {
                    block57: {
                        if (!var1_4.isNull(var2_6)) break block57;
                        if (!var1_4.isNull(var3_9)) break block57;
                        if (!var1_4.isNull(var4_10)) break block57;
                        if (!var1_4.isNull(var6_12)) break block57;
                        if (!var1_4.isNull(var7_13)) break block57;
                        if (!var1_4.isNull(var8_14)) break block57;
                        if (!var1_4.isNull(var9_15)) break block57;
                        if (!var1_4.isNull(var10_16)) break block57;
                        if (!var1_4.isNull(var11_17)) break block57;
                        var23_29 = var14_20 = null;
                        ** GOTO lbl140
                    }
                    v5 = var1_4;
                    v6 = var6_12;
                    v7 = var1_4;
                    v8 = var4_10;
                    v9 = var1_4;
                    v10 = var3_9;
                    var14_20 = var1_4.getString(var2_6);
                    var15_21 = v9.getInt(v10);
                    var16_22 = v7.getString(v8);
                    if (!v5.isNull(v6)) break block58;
                    var17_23 /* !! */  = null;
                    break block59;
                }
                var17_23 /* !! */  = var1_4.getLong(var6_12);
            }
            v11 = this;
            v12 = var1_4;
            v13 = var11_17;
            v14 = var1_4;
            v15 = var10_16;
            v16 = var1_4;
            v17 = var9_15;
            v18 = var1_4;
            v19 = var8_14;
            v20 = var1_4;
            v21 = var7_13;
            var17_23 /* !! */  = this.__converters.timestampToDate(var17_23 /* !! */ );
            var18_24 = v20.getString(v21);
            var19_25 = v18.getString(v19);
            var20_26 = v16.getString(v17);
            var21_27 = v14.getString(v15);
            var22_28 /* !! */  = v12.getString(v13);
            var22_28 /* !! */  = v11.__converters.stringToChatStatus(var22_28 /* !! */ );
            var23_29 = v22;
            v22 = new ChatMessage((String)var14_20, var15_21, var16_22, (Date)var17_23 /* !! */ , var18_24, var19_25, var20_26, var21_27, (ChatMessageStatus)var22_28 /* !! */ );
lbl140:
            // 2 sources

            v23 = var13_19;
            var14_20 = (TinodeContact)var12_18.get((Object)var1_4.getString(var4_10));
            v23.add(new ChatMessageRelation((ChatMessage)var23_29, (TinodeContact)var14_20));
            continue;
        }
lbl147:
        // 2 sources

        v24 = var13_19;
        v25 = this;
        v26 = var5_11;
        v27 = var1_4;
        this.__db.setTransactionSuccessful();
        v27.close();
        v26.release();
        {
            catch (Throwable v28) {
                this.__db.endTransaction();
                throw v28;
            }
        }
        v25.__db.endTransaction();
        return v24;
        catch (Throwable var2_7) {
            var1_4.close();
            var5_11.release();
            throw var2_7;
        }
    }

    @Override
    public Observable<List<ChatMessageRelation>> getChatMessagesRelation(String string2, Integer object, Integer n, int n2) {
        Callable<List<ChatMessageRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? AND (chatMessageSeq < ? OR ? IS NULL) AND (chatMessageSeq >= ? OR ? IS NULL) ORDER BY ChatMessage.chatMessageSeq DESC LIMIT ?", (int)6);
        int n3 = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n3);
        } else {
            roomSQLiteQuery.bindString(n3, string2);
        }
        int n4 = 2;
        if (object == null) {
            roomSQLiteQuery.bindNull(n4);
        } else {
            roomSQLiteQuery.bindLong(n4, (long)((Integer)object).intValue());
        }
        n4 = 3;
        if (object == null) {
            roomSQLiteQuery.bindNull(n4);
        } else {
            roomSQLiteQuery.bindLong(n4, (long)((Integer)object).intValue());
        }
        n4 = 4;
        if (n == null) {
            roomSQLiteQuery.bindNull(n4);
        } else {
            roomSQLiteQuery.bindLong(n4, (long)n.intValue());
        }
        n4 = 5;
        if (n == null) {
            roomSQLiteQuery.bindNull(n4);
        } else {
            roomSQLiteQuery.bindLong(n4, (long)n.intValue());
        }
        long l = n2;
        roomSQLiteQuery.bindLong(6, l);
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "TinodeContact";
        stringArray[1] = "ChatMessage";
        object = callable;
        callable = new Callable<List<ChatMessageRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<ChatMessageRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageTopicId");
                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageSeq");
                var4_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"senderUserId");
                var5_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"date");
                var6_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"text");
                var7_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                var8_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"subtype");
                var9_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"replyTo");
                var10_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"status");
                var11_12 = v1;
                v1 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    var11_12.put((Object)var1_1.getString(var4_5), null);
                    continue;
                }
lbl32:
                // 2 sources

                v2 = this;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$200(v2.MessagingDao_Impl.this, var11_12);
                var12_13 = v3;
                v3 = new ArrayList<ChatMessageRelation>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block49: {
                        block48: {
                            block47: {
                                if (!var1_1.isNull(var2_2)) break block47;
                                if (!var1_1.isNull(var3_4)) break block47;
                                if (!var1_1.isNull(var4_5)) break block47;
                                if (!var1_1.isNull(var5_6)) break block47;
                                if (!var1_1.isNull(var6_7)) break block47;
                                if (!var1_1.isNull(var7_8)) break block47;
                                if (!var1_1.isNull(var8_9)) break block47;
                                if (!var1_1.isNull(var9_10)) break block47;
                                if (!var1_1.isNull(var10_11)) break block47;
                                var22_23 = var13_14 = null;
                                ** GOTO lbl110
                            }
                            v4 = var1_1;
                            v5 = var5_6;
                            v6 = var1_1;
                            v7 = var4_5;
                            v8 = var1_1;
                            v9 = var3_4;
                            var13_14 = var1_1.getString(var2_2);
                            var14_15 = v8.getInt(v9);
                            var15_16 = v6.getString(v7);
                            if (!v4.isNull(v5)) break block48;
                            var16_17 /* !! */  = null;
                            break block49;
                        }
                        var16_17 /* !! */  = var1_1.getLong(var5_6);
                    }
                    v10 = this;
                    v11 = var1_1;
                    v12 = var10_11;
                    v13 = var1_1;
                    v14 = var9_10;
                    v15 = var1_1;
                    v16 = var8_9;
                    v17 = var1_1;
                    v18 = var7_8;
                    v19 = var1_1;
                    v20 = var6_7;
                    var16_17 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var16_17 /* !! */ );
                    var17_18 = v19.getString(v20);
                    var18_19 = v17.getString(v18);
                    var19_20 = v15.getString(v16);
                    var20_21 = v13.getString(v14);
                    var21_22 /* !! */  = v11.getString(v12);
                    var21_22 /* !! */  = MessagingDao_Impl.access$000(v10.MessagingDao_Impl.this).stringToChatStatus(var21_22 /* !! */ );
                    var22_23 = v21;
                    v21 = new ChatMessage((String)var13_14, var14_15, var15_16, (Date)var16_17 /* !! */ , var17_18, var18_19, var19_20, var20_21, (ChatMessageStatus)var21_22 /* !! */ );
lbl110:
                    // 2 sources

                    v22 = var12_13;
                    var13_14 = (TinodeContact)var11_12.get((Object)var1_1.getString(var4_5));
                    v22.add(new ChatMessageRelation((ChatMessage)var22_23, (TinodeContact)var13_14));
                    continue;
                }
lbl117:
                // 2 sources

                v23 = var12_13;
                v24 = this;
                v25 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v25.close();
                {
                    catch (Throwable v26) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v26;
                    }
                }
                MessagingDao_Impl.access$100(v24.MessagingDao_Impl.this).endTransaction();
                return v23;
                catch (Throwable var2_3) {
                    var1_1.close();
                    throw var2_3;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)object);
    }

    @Override
    public Observable<List<ChatRelation>> getChatsRelation() {
        Callable<List<ChatRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Chat ORDER BY Chat.updatedAt DESC", (int)0);
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = "ChatParticipantCrossRef";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "ChatMessage";
        stringArray[3] = "Chat";
        Callable<List<ChatRelation>> callable2 = callable;
        callable = new Callable<List<ChatRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<ChatRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                var4_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                var5_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                var6_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                var7_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                var8_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                var9_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"externalId");
                var10_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"fn");
                var11_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"title");
                var12_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"tags");
                var13_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"data");
                var14_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"format");
                var15_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                var16_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                var17_18 = v1;
                v1 = new ArrayMap();
                var18_19 = v2;
                v2 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block89: {
                        v3 = var17_18;
                        var19_20 = var1_1.getString(var2_2);
                        if ((ArrayList)v3.get(var19_20) != null) break block89;
                        var17_18.put(var19_20, new ArrayList<E>());
                    }
                    v4 = var18_19;
                    var19_20 = var1_1.getString(var2_2);
                    if ((ArrayList)v4.get(var19_20) != null) continue;
                    var18_19.put(var19_20, new ArrayList<E>());
                    continue;
                }
lbl61:
                // 2 sources

                v5 = this;
                v6 = v5;
                v7 = v5;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$300(v6.MessagingDao_Impl.this, var17_18);
                MessagingDao_Impl.access$400(v7.MessagingDao_Impl.this, var18_19);
                var19_20 = v8;
                v8 = new ArrayList<E>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block99: {
                        block98: {
                            block97: {
                                block96: {
                                    block95: {
                                        block94: {
                                            block93: {
                                                block92: {
                                                    block91: {
                                                        block90: {
                                                            if (!var1_1.isNull(var2_2)) break block90;
                                                            if (!var1_1.isNull(var3_4)) break block90;
                                                            if (!var1_1.isNull(var4_5)) break block90;
                                                            if (!var1_1.isNull(var5_6)) break block90;
                                                            if (!var1_1.isNull(var6_7)) break block90;
                                                            if (!var1_1.isNull(var7_8)) break block90;
                                                            if (!var1_1.isNull(var8_9)) break block90;
                                                            if (!var1_1.isNull(var9_10)) break block90;
                                                            if (!var1_1.isNull(var10_11)) break block90;
                                                            if (!var1_1.isNull(var11_12)) break block90;
                                                            if (!var1_1.isNull(var12_13)) break block90;
                                                            if (!var1_1.isNull(var13_14)) break block90;
                                                            if (!var1_1.isNull(var14_15)) break block90;
                                                            if (!var1_1.isNull(var15_16)) break block90;
                                                            if (!var1_1.isNull(var16_17)) break block90;
                                                            var27_28 = var20_21 = null;
                                                            ** GOTO lbl223
                                                        }
                                                        v9 = var1_1;
                                                        v10 = var7_8;
                                                        v11 = var1_1;
                                                        v12 = var6_7;
                                                        v13 = var1_1;
                                                        v14 = var5_6;
                                                        v15 = var1_1;
                                                        v16 = var4_5;
                                                        v17 = var1_1;
                                                        v18 = var3_4;
                                                        var20_21 = var1_1.getString(var2_2);
                                                        var21_22 = v17.getString(v18);
                                                        var22_23 = v15.getInt(v16);
                                                        var23_24 = v13.getInt(v14);
                                                        var24_25 = v11.getInt(v12);
                                                        if (!v9.isNull(v10)) break block91;
                                                        var25_26 /* !! */  = null;
                                                        break block92;
                                                    }
                                                    var25_26 /* !! */  = var1_1.getLong(var7_8);
                                                }
                                                v19 = var1_1;
                                                v20 = var8_9;
                                                var25_26 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var25_26 /* !! */ );
                                                if (!v19.isNull(v20)) break block93;
                                                var26_27 /* !! */  = null;
                                                break block94;
                                            }
                                            var26_27 /* !! */  = var1_1.getLong(var8_9);
                                        }
                                        v21 = var1_1;
                                        v22 = var9_10;
                                        var26_27 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var26_27 /* !! */ );
                                        if (!v21.isNull(v22)) break block95;
                                        if (!var1_1.isNull(var10_11)) break block95;
                                        if (!var1_1.isNull(var11_12)) break block95;
                                        if (!var1_1.isNull(var12_13)) break block95;
                                        if (!var1_1.isNull(var13_14)) break block95;
                                        if (!var1_1.isNull(var14_15)) break block95;
                                        var31_32 = var27_28 = null;
                                        ** GOTO lbl204
                                    }
                                    v23 = var1_1;
                                    v24 = var13_14;
                                    v25 = this;
                                    v26 = var1_1;
                                    v27 = var12_13;
                                    v28 = var1_1;
                                    v29 = var11_12;
                                    v30 = var1_1;
                                    v31 = var10_11;
                                    var27_28 = var1_1.getString(var9_10);
                                    var28_29 = v30.getString(v31);
                                    var29_30 = v28.getString(v29);
                                    var30_31 = v26.getString(v27);
                                    var30_31 = MessagingDao_Impl.access$000(v25.MessagingDao_Impl.this).stringToStringList((String)var30_31);
                                    if (!v23.isNull(v24)) break block96;
                                    if (!var1_1.isNull(var14_15)) break block96;
                                    var33_34 = var31_32 = null;
                                    break block97;
                                }
                                v32 = var1_1;
                                v33 = var14_15;
                                var31_32 = var1_1.getString(var13_14);
                                var32_33 = v32.getString(v33);
                                var33_34 = v34;
                                v34 = new TinodePhoto((String)var31_32, var32_33);
                            }
                            var31_32 = v35;
                            v35 = new TinodeUserPublic((String)var27_28, var28_29, (String)var29_30, (TinodePhoto)var33_34, (List<String>)var30_31);
lbl204:
                            // 2 sources

                            if (!var1_1.isNull(var15_16)) break block98;
                            if (!var1_1.isNull(var16_17)) break block98;
                            var29_30 = var27_28 = null;
                            break block99;
                        }
                        v36 = var1_1;
                        v37 = var16_17;
                        var27_28 = var1_1.getString(var15_16);
                        var28_29 = v36.getString(v37);
                        var29_30 = v38;
                        v38 = new Access((String)var27_28, var28_29);
                    }
                    var27_28 = v39;
                    v39 = new Chat((String)var20_21, (String)var21_22, var22_23, var23_24, var24_25, (Date)var25_26 /* !! */ , (Date)var26_27 /* !! */ , (TinodeUserPublic)var31_32, (Access)var29_30);
lbl223:
                    // 2 sources

                    var20_21 = (ArrayList)var17_18.get((Object)var1_1.getString(var2_2));
                    if (var20_21 != null) ** GOTO lbl228
                    var20_21 = v40;
                    v40 = new ArrayList<E>();
lbl228:
                    // 2 sources

                    if ((var21_22 = (ArrayList)var18_19.get((Object)var1_1.getString(var2_2))) != null) ** GOTO lbl232
                    var21_22 = v41;
                    v41 = new ArrayList<E>();
lbl232:
                    // 2 sources

                    var19_20.add(new ChatRelation((Chat)var27_28, (List<TinodeContact>)var20_21, (List<ChatMessage>)var21_22));
                    continue;
                }
lbl236:
                // 2 sources

                v42 = var19_20;
                v43 = this;
                v44 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v44.close();
                {
                    catch (Throwable v45) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v45;
                    }
                }
                MessagingDao_Impl.access$100(v43.MessagingDao_Impl.this).endTransaction();
                return v42;
                catch (Throwable var2_3) {
                    var1_1.close();
                    throw var2_3;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<ChatRelation> getChatRelation(String stringArray) {
        Callable<ChatRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Chat WHERE Chat.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[4];
        stringArray = stringArray2;
        stringArray2[0] = "ChatParticipantCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "ChatMessage";
        stringArray2[3] = "Chat";
        Callable<ChatRelation> callable2 = callable;
        callable = new Callable<ChatRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public ChatRelation call() throws Exception {
                block101: {
                    block89: {
                        block100: {
                            block99: {
                                block98: {
                                    block97: {
                                        block96: {
                                            block95: {
                                                block94: {
                                                    block93: {
                                                        block92: {
                                                            block91: {
                                                                block90: {
                                                                    v0 = this;
                                                                    MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                                                                    var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                    var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                    var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                    var4_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                    var5_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                    var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                    var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                    var8_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                    var9_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"externalId");
                                                                    var10_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"fn");
                                                                    var11_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"title");
                                                                    var12_24 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"tags");
                                                                    var13_26 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"data");
                                                                    var14_28 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"format");
                                                                    var15_30 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                    var16_31 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                    var17_32 = v1;
                                                                    v1 = new ArrayMap();
                                                                    var18_33 = v2;
                                                                    v2 = new ArrayMap();
                                                                    ** while (var1_1.moveToNext())
lbl-1000:
                                                                    // 1 sources

                                                                    {
                                                                        block88: {
                                                                            v3 = var17_32;
                                                                            var19_34 = var1_1.getString(var2_2);
                                                                            if ((ArrayList)v3.get((Object)var19_34) != null) break block88;
                                                                            var17_32.put((Object)var19_34, new ArrayList<E>());
                                                                        }
                                                                        v4 = var18_33;
                                                                        var19_34 = var1_1.getString(var2_2);
                                                                        if ((ArrayList)v4.get((Object)var19_34) != null) continue;
                                                                        var18_33.put((Object)var19_34, new ArrayList<E>());
                                                                        continue;
                                                                    }
lbl61:
                                                                    // 2 sources

                                                                    v5 = var1_1;
                                                                    v6 = this;
                                                                    v7 = v6;
                                                                    v8 = v6;
                                                                    var1_1.moveToPosition(-1);
                                                                    MessagingDao_Impl.access$300(v7.MessagingDao_Impl.this, var17_32);
                                                                    MessagingDao_Impl.access$400(v8.MessagingDao_Impl.this, var18_33);
                                                                    if (!v5.moveToFirst()) break block89;
                                                                    if (!var1_1.isNull(var2_2)) break block90;
                                                                    if (!var1_1.isNull(var3_5)) break block90;
                                                                    if (!var1_1.isNull(var4_7)) break block90;
                                                                    if (!var1_1.isNull(var5_10)) break block90;
                                                                    if (!var1_1.isNull(var6_11)) break block90;
                                                                    if (!var1_1.isNull(var7_12)) break block90;
                                                                    if (!var1_1.isNull(var8_14)) break block90;
                                                                    if (!var1_1.isNull(var9_16)) break block90;
                                                                    if (!var1_1.isNull(var10_18)) break block90;
                                                                    if (!var1_1.isNull(var11_21)) break block90;
                                                                    if (!var1_1.isNull(var12_24)) break block90;
                                                                    if (!var1_1.isNull(var13_26)) break block90;
                                                                    if (!var1_1.isNull(var14_28)) break block90;
                                                                    if (!var1_1.isNull(var15_30)) break block90;
                                                                    if (!var1_1.isNull(var16_31)) break block90;
                                                                    var9_17 = var3_6 = null;
                                                                    ** GOTO lbl221
                                                                }
                                                                v9 = var1_1;
                                                                v10 = var7_12;
                                                                v11 = var1_1;
                                                                v12 = var6_11;
                                                                v13 = var1_1;
                                                                v14 = var5_10;
                                                                v15 = var1_1;
                                                                v16 = var4_7;
                                                                v17 = var1_1;
                                                                v18 = var3_5;
                                                                var3_6 = var1_1.getString(var2_2);
                                                                var4_8 = v17.getString(v18);
                                                                var5_10 = v15.getInt(v16);
                                                                var6_11 = v13.getInt(v14);
                                                                var19_35 = v11.getInt(v12);
                                                                if (!v9.isNull(v10)) break block91;
                                                                var7_13 /* !! */  = null;
                                                                break block92;
                                                            }
                                                            var7_13 /* !! */  = var1_1.getLong(var7_12);
                                                        }
                                                        v19 = var1_1;
                                                        v20 = var8_14;
                                                        var7_13 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var7_13 /* !! */ );
                                                        if (!v19.isNull(v20)) break block93;
                                                        var8_15 /* !! */  = null;
                                                        break block94;
                                                    }
                                                    var8_15 /* !! */  = var1_1.getLong(var8_14);
                                                }
                                                v21 = var1_1;
                                                v22 = var9_16;
                                                var8_15 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var8_15 /* !! */ );
                                                if (!v21.isNull(v22)) break block95;
                                                if (!var1_1.isNull(var10_18)) break block95;
                                                if (!var1_1.isNull(var11_21)) break block95;
                                                if (!var1_1.isNull(var12_24)) break block95;
                                                if (!var1_1.isNull(var13_26)) break block95;
                                                if (!var1_1.isNull(var14_28)) break block95;
                                                var13_27 = var9_17 = null;
                                                ** GOTO lbl202
                                            }
                                            v23 = var1_1;
                                            v24 = var13_26;
                                            v25 = this;
                                            v26 = var1_1;
                                            v27 = var12_24;
                                            v28 = var1_1;
                                            v29 = var11_21;
                                            v30 = var1_1;
                                            v31 = var10_18;
                                            var9_17 = var1_1.getString(var9_16);
                                            var10_19 = v30.getString(v31);
                                            var11_22 = v28.getString(v29);
                                            var12_25 = v26.getString(v27);
                                            var12_25 = MessagingDao_Impl.access$000(v25.MessagingDao_Impl.this).stringToStringList((String)var12_25);
                                            if (!v23.isNull(v24)) break block96;
                                            if (!var1_1.isNull(var14_28)) break block96;
                                            var20_36 = var13_27 = null;
                                            break block97;
                                        }
                                        v32 = var1_1;
                                        v33 = var14_28;
                                        var13_27 = var1_1.getString(var13_26);
                                        var14_29 = v32.getString(v33);
                                        var20_36 = v34;
                                        v34 = new TinodePhoto((String)var13_27, var14_29);
                                    }
                                    var13_27 = v35;
                                    v35 = new TinodeUserPublic((String)var9_17, var10_19, var11_22, (TinodePhoto)var20_36, (List<String>)var12_25);
lbl202:
                                    // 2 sources

                                    if (!var1_1.isNull(var15_30)) break block98;
                                    if (!var1_1.isNull(var16_31)) break block98;
                                    var11_23 = var9_17 = null;
                                    break block99;
                                }
                                v36 = var1_1;
                                v37 = var16_31;
                                var9_17 = var1_1.getString(var15_30);
                                var10_20 = v36.getString(v37);
                                var11_23 = v38;
                                v38 = new Access((String)var9_17, var10_20);
                            }
                            var9_17 = v39;
                            v39 = new Chat((String)var3_6, var4_8, var5_10, var6_11, var19_35, (Date)var7_13 /* !! */ , (Date)var8_15 /* !! */ , (TinodeUserPublic)var13_27, (Access)var11_23);
lbl221:
                            // 2 sources

                            var3_6 = (ArrayList)var17_32.get((Object)var1_1.getString(var2_2));
                            if (var3_6 != null) ** GOTO lbl226
                            var3_6 = v40;
                            v40 = new ArrayList<E>();
lbl226:
                            // 2 sources

                            if ((var2_3 = (ArrayList)var18_33.get((Object)var1_1.getString(var2_2))) != null) break block100;
                            var2_3 = v41;
                            v41 = new ArrayList<E>();
                        }
                        var4_9 = v42;
                        v42 = new ChatRelation((Chat)var9_17, (List<TinodeContact>)var3_6, var2_3);
                        break block101;
                    }
                    var4_9 = null;
                }
                v43 = var4_9;
                v44 = this;
                v45 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v45.close();
                {
                    catch (Throwable v46) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v46;
                    }
                }
                MessagingDao_Impl.access$100(v44.MessagingDao_Impl.this).endTransaction();
                return v43;
                catch (Throwable var2_4) {
                    var1_1.close();
                    throw var2_4;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Observable<List<WatchPartyRelation>> getWatchPartiesRelation() {
        Callable<List<WatchPartyRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Chat ORDER BY Chat.updatedAt DESC", (int)0);
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "ChatOwnerCrossRef";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "CallStatus";
        stringArray[3] = "ChatParticipantCrossRef";
        stringArray[4] = "ChatMessage";
        stringArray[5] = "Chat";
        Callable<List<WatchPartyRelation>> callable2 = callable;
        callable = new Callable<List<WatchPartyRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<WatchPartyRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                var4_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                var5_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                var6_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                var7_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                var8_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                var9_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"externalId");
                var10_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"fn");
                var11_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"title");
                var12_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"tags");
                var13_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"data");
                var14_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"format");
                var15_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                var16_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                var17_18 = v1;
                v1 = new ArrayMap();
                var18_19 = v2;
                v2 = new ArrayMap();
                var19_20 = v3;
                v3 = new ArrayMap();
                var20_21 = v4;
                v4 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block111: {
                        v5 = var19_20;
                        v6 = var1_1;
                        v7 = var2_2;
                        v8 = var18_19;
                        v9 = var1_1;
                        v10 = var2_2;
                        var17_18.put((Object)var1_1.getString(var2_2), null);
                        v8.put((Object)v9.getString(v10), null);
                        var21_22 = v6.getString(v7);
                        if ((ArrayList)v5.get(var21_22) != null) break block111;
                        var19_20.put(var21_22, new ArrayList<E>());
                    }
                    v11 = var20_21;
                    var21_22 = var1_1.getString(var2_2);
                    if ((ArrayList)v11.get(var21_22) != null) continue;
                    var20_21.put(var21_22, new ArrayList<E>());
                    continue;
                }
lbl78:
                // 2 sources

                v12 = this;
                v13 = v12;
                v14 = v12;
                v15 = v12;
                v16 = v12;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$500(v13.MessagingDao_Impl.this, var17_18);
                MessagingDao_Impl.access$600(v14.MessagingDao_Impl.this, var18_19);
                MessagingDao_Impl.access$300(v15.MessagingDao_Impl.this, var19_20);
                MessagingDao_Impl.access$400(v16.MessagingDao_Impl.this, var20_21);
                var21_22 = v17;
                v17 = new ArrayList<E>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block123: {
                        block122: {
                            block121: {
                                block120: {
                                    block119: {
                                        block118: {
                                            block117: {
                                                block116: {
                                                    block115: {
                                                        block114: {
                                                            block113: {
                                                                block112: {
                                                                    if (!var1_1.isNull(var2_2)) break block112;
                                                                    if (!var1_1.isNull(var3_4)) break block112;
                                                                    if (!var1_1.isNull(var4_5)) break block112;
                                                                    if (!var1_1.isNull(var5_6)) break block112;
                                                                    if (!var1_1.isNull(var6_7)) break block112;
                                                                    if (!var1_1.isNull(var7_8)) break block112;
                                                                    if (!var1_1.isNull(var8_9)) break block112;
                                                                    if (!var1_1.isNull(var9_10)) break block112;
                                                                    if (!var1_1.isNull(var10_11)) break block112;
                                                                    if (!var1_1.isNull(var11_12)) break block112;
                                                                    if (!var1_1.isNull(var12_13)) break block112;
                                                                    if (!var1_1.isNull(var13_14)) break block112;
                                                                    if (!var1_1.isNull(var14_15)) break block112;
                                                                    if (!var1_1.isNull(var15_16)) break block112;
                                                                    if (!var1_1.isNull(var16_17)) break block112;
                                                                    var24_25 = var22_23 = null;
                                                                    ** GOTO lbl290
                                                                }
                                                                if (!var1_1.isNull(var2_2)) break block113;
                                                                if (!var1_1.isNull(var3_4)) break block113;
                                                                if (!var1_1.isNull(var4_5)) break block113;
                                                                if (!var1_1.isNull(var5_6)) break block113;
                                                                if (!var1_1.isNull(var6_7)) break block113;
                                                                if (!var1_1.isNull(var7_8)) break block113;
                                                                if (!var1_1.isNull(var8_9)) break block113;
                                                                if (!var1_1.isNull(var9_10)) break block113;
                                                                if (!var1_1.isNull(var10_11)) break block113;
                                                                if (!var1_1.isNull(var11_12)) break block113;
                                                                if (!var1_1.isNull(var12_13)) break block113;
                                                                if (!var1_1.isNull(var13_14)) break block113;
                                                                if (!var1_1.isNull(var14_15)) break block113;
                                                                if (!var1_1.isNull(var15_16)) break block113;
                                                                if (!var1_1.isNull(var16_17)) break block113;
                                                                var29_32 = var22_23 = null;
                                                                ** GOTO lbl277
                                                            }
                                                            v18 = var1_1;
                                                            v19 = var7_8;
                                                            v20 = var1_1;
                                                            v21 = var6_7;
                                                            v22 = var1_1;
                                                            v23 = var5_6;
                                                            v24 = var1_1;
                                                            v25 = var4_5;
                                                            v26 = var1_1;
                                                            v27 = var3_4;
                                                            var22_23 = var1_1.getString(var2_2);
                                                            var23_24 = v26.getString(v27);
                                                            var24_26 = v24.getInt(v25);
                                                            var25_28 = v22.getInt(v23);
                                                            var26_29 = v20.getInt(v21);
                                                            if (!v18.isNull(v19)) break block114;
                                                            var27_30 /* !! */  = null;
                                                            break block115;
                                                        }
                                                        var27_30 /* !! */  = var1_1.getLong(var7_8);
                                                    }
                                                    v28 = var1_1;
                                                    v29 = var8_9;
                                                    var27_30 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var27_30 /* !! */ );
                                                    if (!v28.isNull(v29)) break block116;
                                                    var28_31 /* !! */  = null;
                                                    break block117;
                                                }
                                                var28_31 /* !! */  = var1_1.getLong(var8_9);
                                            }
                                            v30 = var1_1;
                                            v31 = var9_10;
                                            var28_31 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var28_31 /* !! */ );
                                            if (!v30.isNull(v31)) break block118;
                                            if (!var1_1.isNull(var10_11)) break block118;
                                            if (!var1_1.isNull(var11_12)) break block118;
                                            if (!var1_1.isNull(var12_13)) break block118;
                                            if (!var1_1.isNull(var13_14)) break block118;
                                            if (!var1_1.isNull(var14_15)) break block118;
                                            var33_36 = var29_32 = null;
                                            ** GOTO lbl258
                                        }
                                        v32 = var1_1;
                                        v33 = var13_14;
                                        v34 = this;
                                        v35 = var1_1;
                                        v36 = var12_13;
                                        v37 = var1_1;
                                        v38 = var11_12;
                                        v39 = var1_1;
                                        v40 = var10_11;
                                        var29_32 = var1_1.getString(var9_10);
                                        var30_33 = v39.getString(v40);
                                        var31_34 = v37.getString(v38);
                                        var32_35 = v35.getString(v36);
                                        var32_35 = MessagingDao_Impl.access$000(v34.MessagingDao_Impl.this).stringToStringList((String)var32_35);
                                        if (!v32.isNull(v33)) break block119;
                                        if (!var1_1.isNull(var14_15)) break block119;
                                        var35_38 = var33_36 = null;
                                        break block120;
                                    }
                                    v41 = var1_1;
                                    v42 = var14_15;
                                    var33_36 = var1_1.getString(var13_14);
                                    var34_37 = v41.getString(v42);
                                    var35_38 = v43;
                                    v43 = new TinodePhoto((String)var33_36, var34_37);
                                }
                                var33_36 = v44;
                                v44 = new TinodeUserPublic((String)var29_32, var30_33, (String)var31_34, (TinodePhoto)var35_38, (List<String>)var32_35);
lbl258:
                                // 2 sources

                                if (!var1_1.isNull(var15_16)) break block121;
                                if (!var1_1.isNull(var16_17)) break block121;
                                var31_34 = var29_32 = null;
                                break block122;
                            }
                            v45 = var1_1;
                            v46 = var16_17;
                            var29_32 = var1_1.getString(var15_16);
                            var30_33 = v45.getString(v46);
                            var31_34 = v47;
                            v47 = new Access((String)var29_32, var30_33);
                        }
                        var29_32 = v48;
                        v48 = new Chat((String)var22_23, (String)var23_24, var24_26, var25_28, var26_29, (Date)var27_30 /* !! */ , (Date)var28_31 /* !! */ , (TinodeUserPublic)var33_36, (Access)var31_34);
lbl277:
                        // 2 sources

                        var22_23 = (ArrayList)var19_20.get((Object)var1_1.getString(var2_2));
                        if (var22_23 != null) ** GOTO lbl282
                        var22_23 = v49;
                        v49 = new ArrayList<E>();
lbl282:
                        // 2 sources

                        if ((var23_24 = (ArrayList)var20_21.get((Object)var1_1.getString(var2_2))) != null) break block123;
                        var23_24 = v50;
                        v50 = new ArrayList<E>();
                    }
                    var24_25 = v51;
                    v51 = new ChatRelation((Chat)var29_32, (List<TinodeContact>)var22_23, (List<ChatMessage>)var23_24);
lbl290:
                    // 2 sources

                    v52 = var21_22;
                    v53 = var18_19;
                    v54 = var1_1;
                    v55 = var2_2;
                    var22_23 = (TinodeContact)var17_18.get((Object)var1_1.getString(var2_2));
                    var23_24 = (CallStatus)v53.get((Object)v54.getString(v55));
                    v52.add(new WatchPartyRelation((ChatRelation)var24_25, (TinodeContact)var22_23, (CallStatus)var23_24));
                    continue;
                }
lbl302:
                // 2 sources

                v56 = var21_22;
                v57 = this;
                v58 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v58.close();
                {
                    catch (Throwable v59) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v59;
                    }
                }
                MessagingDao_Impl.access$100(v57.MessagingDao_Impl.this).endTransaction();
                return v56;
                catch (Throwable var2_3) {
                    var1_1.close();
                    throw var2_3;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public WaveMessage getWaveByIdAndDate(String string2, Date comparable) {
        Object object;
        Cursor cursor;
        RoomSQLiteQuery roomSQLiteQuery;
        block21: {
            block18: {
                WaveMessage waveMessage;
                String string3;
                String string4;
                String string5;
                block20: {
                    int n;
                    block19: {
                        int n2;
                        roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WaveMessage WHERE chatUserId = ? AND sentAt >= ?", (int)2);
                        int n3 = 1;
                        if (string2 == null) {
                            roomSQLiteQuery.bindNull(n3);
                        } else {
                            roomSQLiteQuery.bindString(n3, string2);
                        }
                        int n4 = 2;
                        comparable = ((MessagingDao_Impl)((Object)date)).__converters.dateToString((Date)comparable);
                        if (comparable == null) {
                            roomSQLiteQuery.bindNull(n4);
                        } else {
                            roomSQLiteQuery.bindLong(n4, ((Long)comparable).longValue());
                        }
                        MessagingDao_Impl messagingDao_Impl = date;
                        messagingDao_Impl.__db.assertNotSuspendingTransaction();
                        cursor = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                        try {
                            n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatUserId");
                        }
                        catch (Throwable throwable) {
                            cursor.close();
                            roomSQLiteQuery.release();
                            throw throwable;
                        }
                        n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userName");
                        int n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userAvatar");
                        n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sentAt");
                        if (!cursor.moveToFirst()) break block18;
                        Cursor cursor2 = cursor;
                        int n6 = n;
                        Cursor cursor3 = cursor;
                        int n7 = n5;
                        Cursor cursor4 = cursor;
                        int n8 = n3;
                        string5 = cursor.getString(n2);
                        string4 = cursor4.getString(n8);
                        string3 = cursor3.getString(n7);
                        if (!cursor2.isNull(n6)) break block19;
                        object = null;
                        break block20;
                    }
                    object = cursor.getLong(n);
                }
                Date date = ((MessagingDao_Impl)((Object)date)).__converters.timestampToDate((Long)object);
                object = waveMessage;
                waveMessage = new WaveMessage(string5, string4, string3, date);
                break block21;
            }
            object = null;
        }
        cursor.close();
        roomSQLiteQuery.release();
        return object;
    }

    @Override
    public void saveOrUpdateChatMessage(ChatMessage chatMessage) {
        MessagingDao.DefaultImpls.saveOrUpdateChatMessage(this, chatMessage);
    }

    @Override
    public Maybe<ChatMessage> getChatMessage(String string2, int n) {
        return MessagingDao.DefaultImpls.getChatMessage(this, string2, n);
    }

    @Override
    public DataSource.Factory<Integer, ChatMessage> getChatMessagesLiveData(String string2) {
        return MessagingDao.DefaultImpls.getChatMessagesLiveData(this, string2);
    }

    @Override
    public List<ChatMessage> getChatMessagesList(String string2, Integer n, Integer n2, int n3) {
        return MessagingDao.DefaultImpls.getChatMessagesList(this, string2, n, n2, n3);
    }

    @Override
    public Observable<List<ChatMessage>> getChatMessages(String string2, Integer n, Integer n2, int n3) {
        return MessagingDao.DefaultImpls.getChatMessages(this, string2, n, n2, n3);
    }

    @Override
    public Observable<List<Chat>> getChats(boolean bl) {
        return MessagingDao.DefaultImpls.getChats(this, bl);
    }

    @Override
    public Observable<Chat> getChat(String string2) {
        return MessagingDao.DefaultImpls.getChat(this, string2);
    }

    @Override
    public Observable<List<WatchParty>> getWatchParties() {
        return MessagingDao.DefaultImpls.getWatchParties(this);
    }
}

