/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.callstatus;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.calls.CallConnectionStatus;
import io.streamlayer.sdk.model.calls.CallParticipantStatus;
import io.streamlayer.sdk.model.calls.CallStatus;
import io.streamlayer.sdk.model.calls.ParticipantStatus;
import io.streamlayer.sdk.model.tinodecontact.TinodePres;
import io.streamlayer.sdk.repository.callstatus.CallStatusRepo;
import io.streamlayer.sdk.repository.callstatus.CallStatusRepoImplKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/streamlayer/sdk/repository/callstatus/CallStatusRepoImpl;", "Lio/streamlayer/sdk/repository/callstatus/CallStatusRepo;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "(Lio/streamlayer/common/data/database/AppDatabase;Lio/streamlayer/common/session/SessionPrefImpl;)V", "observeCallStatus", "Lio/reactivex/Observable;", "Lio/streamlayer/sdk/model/calls/CallStatus;", "callId", "", "processParticipantPresence", "presence", "Lio/streamlayer/sdk/model/tinodecontact/TinodePres;", "reduceParticipantCallStates", "Lio/streamlayer/sdk/model/calls/CallConnectionStatus;", "states", "", "Lio/streamlayer/sdk/model/calls/ParticipantStatus;", "sdk_originalVoximplantRelease"})
public final class CallStatusRepoImpl
implements CallStatusRepo {
    private final AppDatabase database;
    private final SessionPrefImpl session;

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private final CallConnectionStatus reduceParticipantCallStates(List<? extends ParticipantStatus> list) {
        CallConnectionStatus callConnectionStatus;
        block11: {
            boolean bl;
            block8: {
                Iterator iterator;
                boolean bl2;
                boolean bl3;
                block7: {
                    Iterator iterator2;
                    if (list.contains((Object)ParticipantStatus.Online)) {
                        callConnectionStatus = CallConnectionStatus.Connected;
                        return callConnectionStatus;
                    }
                    boolean bl4 = true;
                    do {
                        block10: {
                            block9: {
                                if (!bl4 || (bl4 = false)) break block9;
                                bl3 = list instanceof Collection;
                                if (bl3 && list.isEmpty()) break block10;
                                iterator2 = list.iterator();
                            }
                            if (iterator2.hasNext()) continue;
                        }
                        bl2 = false;
                        break block7;
                    } while (!((ParticipantStatus)((Object)iterator2.next()) == ParticipantStatus.Pending));
                    bl2 = true;
                }
                if (bl2) {
                    callConnectionStatus = CallConnectionStatus.Connecting;
                    return callConnectionStatus;
                }
                if (list.isEmpty()) break block11;
                boolean bl5 = true;
                do {
                    block13: {
                        block12: {
                            if (!bl5 || (bl5 = false)) break block12;
                            if (bl3 && list.isEmpty()) break block13;
                            iterator = list.iterator();
                        }
                        if (iterator.hasNext()) continue;
                    }
                    bl = true;
                    break block8;
                } while ((ParticipantStatus)((Object)iterator.next()) == ParticipantStatus.Pending);
                bl = false;
            }
            if (!bl) {
                callConnectionStatus = CallConnectionStatus.Ended;
                return callConnectionStatus;
            }
        }
        callConnectionStatus = CallConnectionStatus.Idle;
        return callConnectionStatus;
    }

    @Inject
    public CallStatusRepoImpl(@NotNull AppDatabase appDatabase, @NotNull SessionPrefImpl sessionPrefImpl) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        this.database = appDatabase;
        this.session = sessionPrefImpl;
    }

    public static final /* synthetic */ CallConnectionStatus access$reduceParticipantCallStates(CallStatusRepoImpl callStatusRepoImpl, List list) {
        return callStatusRepoImpl.reduceParticipantCallStates(list);
    }

    public static final /* synthetic */ SessionPrefImpl access$getSession$p(CallStatusRepoImpl callStatusRepoImpl) {
        return callStatusRepoImpl.session;
    }

    public static final /* synthetic */ AppDatabase access$getDatabase$p(CallStatusRepoImpl callStatusRepoImpl) {
        return callStatusRepoImpl.database;
    }

    @Override
    @NotNull
    public Observable<CallStatus> processParticipantPresence(@NotNull TinodePres tinodePres) {
        Intrinsics.checkParameterIsNotNull((Object)tinodePres, (String)"presence");
        String cfr_ignored_0 = "processParticipantPresence: " + tinodePres;
        Observable observable = this.database.callDao().getCallStatus(tinodePres.getTopic()).defaultIfEmpty((Object)new CallStatus(tinodePres.getTopic(), CallConnectionStatus.Idle, CollectionsKt.emptyList())).flatMapObservable(new Function<T, ObservableSource<? extends R>>(this, tinodePres){
            final /* synthetic */ CallStatusRepoImpl this$0;
            final /* synthetic */ TinodePres $presence;
            {
                this.this$0 = callStatusRepoImpl;
                this.$presence = tinodePres;
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Observable<CallStatus> apply(@NotNull CallStatus callStatus) {
                ArrayList<E> arrayList;
                ArrayList<E> arrayList2;
                Iterator<T> iterator;
                Object object;
                boolean bl;
                Object object22;
                CallStatus callStatus2 = callStatus;
                Intrinsics.checkParameterIsNotNull((Object)callStatus2, (String)"callStatus");
                List list = CollectionsKt.toMutableList(callStatus2.getParticipantStatuses());
                if (!(list instanceof Collection) || !list.isEmpty()) {
                    for (Object object22 : list) {
                        if (!Intrinsics.areEqual((Object)this.$presence.getChatUserId(), (Object)((CallParticipantStatus)object22).getUserId())) continue;
                        bl = false;
                        break;
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    object = CallStatusRepoImplKt.toCallParticipantStatus(this.$presence);
                    if (((CallParticipantStatus)object).getStatus() == ParticipantStatus.Online) {
                        ((CallParticipantStatus)object).setWasParticipant(true);
                    }
                    list.add(object);
                } else {
                    block11: {
                        for (Object object22 : list) {
                            iterator = (CallParticipantStatus)object22;
                            if (!Intrinsics.areEqual((Object)this.$presence.getChatUserId(), (Object)((CallParticipantStatus)((Object)iterator)).getUserId())) continue;
                            break block11;
                        }
                        object22 = null;
                    }
                    object = object22;
                    if (object != null) {
                        list.remove(object);
                        list.add(CallParticipantStatus.copy$default((CallParticipantStatus)object, null, CallStatusRepoImplKt.toParticipantStatus(this.$presence), 1, null));
                    }
                }
                object = null;
                object22 = this.this$0;
                iterator = arrayList2;
                arrayList2 = new ArrayList<E>();
                for (T t : list) {
                    if (!(Intrinsics.areEqual((Object)((CallParticipantStatus)t).getUserId(), (Object)CallStatusRepoImpl.access$getSession$p(this.this$0).getTinodeUserId()) ^ true)) continue;
                    iterator.add(t);
                }
                ArrayList<E> arrayList3 = arrayList;
                arrayList = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
                iterator = iterator.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        callStatus = CallStatus.copy$default(callStatus, (String)object, CallStatusRepoImpl.access$reduceParticipantCallStates((CallStatusRepoImpl)object22, CollectionsKt.toList((Iterable)arrayList3)), list, 1, null);
                        String cfr_ignored_0 = "processParticipantPresence newCallStatus: " + callStatus;
                        CallStatusRepoImpl.access$getDatabase$p(this.this$0).callDao().saveCallStatus(callStatus);
                        return Observable.just((Object)callStatus);
                    }
                    arrayList3.add(((CallParticipantStatus)iterator.next()).getStatus());
                }
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"database.callDao().getCa\u2026CallStatus)\n            }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<CallStatus> observeCallStatus(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"callId");
        Observable observable = this.database.callDao().observeCallStatus(string2).defaultIfEmpty((Object)new CallStatus(string2, CallConnectionStatus.Idle, CollectionsKt.emptyList()));
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"database.callDao()\n     \u2026tatus.Idle, emptyList()))");
        return observable;
    }
}

