/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.messaging;

import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.model.tinodecontact.TinodeUserPublic;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u001e\b\u0081\b\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\t\u00108\u001a\u00020\u0006H\u00c6\u0003J\t\u00109\u001a\u00020\u0006H\u00c6\u0003J\t\u0010:\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010=\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u0010>\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003Jk\u0010?\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00c6\u0001J\u0013\u0010@\u001a\u00020\u001a2\b\u0010A\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\t\u0010B\u001a\u00020\u0006H\u00d6\u0001J\t\u0010C\u001a\u00020\u0003H\u00d6\u0001R\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001bR \u0010\u001d\u001a\u0004\u0018\u00010\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0014R$\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0018\u0010\f\u001a\u0004\u0018\u00010\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010.R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010.\"\u0004\b1\u00102R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00104\u00a8\u0006D"}, d2={"Lio/streamlayer/sdk/model/messaging/Chat;", "", "chatId", "", "name", "seq", "", "readSeq", "recvSeq", "updatedAt", "Ljava/util/Date;", "touchedAt", "publicData", "Lio/streamlayer/sdk/model/tinodecontact/TinodeUserPublic;", "access", "Lio/streamlayer/sdk/model/messaging/Access;", "(Ljava/lang/String;Ljava/lang/String;IIILjava/util/Date;Ljava/util/Date;Lio/streamlayer/sdk/model/tinodecontact/TinodeUserPublic;Lio/streamlayer/sdk/model/messaging/Access;)V", "getAccess", "()Lio/streamlayer/sdk/model/messaging/Access;", "getChatId", "()Ljava/lang/String;", "chatType", "Lio/streamlayer/sdk/model/messaging/ChatType;", "getChatType", "()Lio/streamlayer/sdk/model/messaging/ChatType;", "isCallChat", "", "()Z", "isOwner", "lastMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "getLastMessage", "()Lio/streamlayer/sdk/model/messaging/ChatMessage;", "setLastMessage", "(Lio/streamlayer/sdk/model/messaging/ChatMessage;)V", "getName", "participants", "", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "getParticipants", "()Ljava/util/List;", "setParticipants", "(Ljava/util/List;)V", "getPublicData", "()Lio/streamlayer/sdk/model/tinodecontact/TinodeUserPublic;", "getReadSeq", "()I", "getRecvSeq", "getSeq", "setSeq", "(I)V", "getTouchedAt", "()Ljava/util/Date;", "getUpdatedAt", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "sdk_originalVoximplantRelease"})
@Entity
public final class Chat {
    @Ignore
    @NotNull
    private List<TinodeContact> participants;
    @Ignore
    @Nullable
    private ChatMessage lastMessage;
    @PrimaryKey
    @NotNull
    private final String chatId;
    @NotNull
    private final String name;
    private int seq;
    private final int readSeq;
    private final int recvSeq;
    @Nullable
    private final Date updatedAt;
    @Nullable
    private final Date touchedAt;
    @Embedded
    @Nullable
    private final TinodeUserPublic publicData;
    @Embedded
    @Nullable
    private final Access access;

    public Chat(@NotNull String string, @NotNull String string2, int n, int n2, int n3, @Nullable Date date, @Nullable Date date2, @Nullable TinodeUserPublic tinodeUserPublic, @Nullable Access access) {
        Chat chat = this;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"chatId");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"name");
        this.chatId = string;
        this.name = string2;
        this.seq = n;
        this.readSeq = n2;
        this.recvSeq = n3;
        this.updatedAt = date;
        this.touchedAt = date2;
        this.publicData = tinodeUserPublic;
        chat.access = access;
        chat.participants = CollectionsKt.emptyList();
    }

    public /* synthetic */ Chat(String string, String string2, int n, int n2, int n3, Date date, Date date2, TinodeUserPublic tinodeUserPublic, Access access, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x20) != 0) {
            date = null;
        }
        if ((n4 & 0x40) != 0) {
            date2 = null;
        }
        if ((n4 & 0x80) != 0) {
            tinodeUserPublic = null;
        }
        if ((n4 & 0x100) != 0) {
            access = null;
        }
        this(string, string2, n, n2, n3, date, date2, tinodeUserPublic, access);
    }

    public static /* synthetic */ Chat copy$default(Chat chat, String string, String string2, int n, int n2, int n3, Date date, Date date2, TinodeUserPublic tinodeUserPublic, Access access, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = chat.chatId;
        }
        if ((n4 & 2) != 0) {
            string2 = chat.name;
        }
        if ((n4 & 4) != 0) {
            n = chat.seq;
        }
        if ((n4 & 8) != 0) {
            n2 = chat.readSeq;
        }
        if ((n4 & 0x10) != 0) {
            n3 = chat.recvSeq;
        }
        if ((n4 & 0x20) != 0) {
            date = chat.updatedAt;
        }
        if ((n4 & 0x40) != 0) {
            date2 = chat.touchedAt;
        }
        if ((n4 & 0x80) != 0) {
            tinodeUserPublic = chat.publicData;
        }
        if ((n4 & 0x100) != 0) {
            access = chat.access;
        }
        return chat.copy(string, string2, n, n2, n3, date, date2, tinodeUserPublic, access);
    }

    @NotNull
    public final ChatType getChatType() {
        return StringsKt.startsWith$default((String)this.chatId, (String)"usr", (boolean)false, (int)2, null) ? ChatType.P2P : (StringsKt.startsWith$default((String)this.chatId, (String)"grp", (boolean)false, (int)2, null) ? ChatType.Group : ChatType.Unknown);
    }

    public final boolean isCallChat() {
        Object object = ((Chat)object).publicData;
        return object != null && (object = ((TinodeUserPublic)object).getTags()) != null && object.contains("voiceChatDev7:");
    }

    public final boolean isOwner() {
        Object object = ((Chat)object).access;
        return object != null && (object = ((Access)object).getGiven()) != null && StringsKt.contains$default((CharSequence)object, (CharSequence)"O", (boolean)false, (int)2, null);
    }

    @NotNull
    public final List<TinodeContact> getParticipants() {
        return this.participants;
    }

    public final void setParticipants(@NotNull List<TinodeContact> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.participants = list;
    }

    @Nullable
    public final ChatMessage getLastMessage() {
        return this.lastMessage;
    }

    public final void setLastMessage(@Nullable ChatMessage chatMessage) {
        this.lastMessage = chatMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        if (!super.equals(object)) return false;
        if (!(object instanceof Chat)) return false;
        Object object2 = ((Chat)object2).lastMessage;
        object2 = object2 != null ? Integer.valueOf(((ChatMessage)object2).getSeq()) : null;
        object = ((Chat)object).lastMessage;
        object = object != null ? Integer.valueOf(((ChatMessage)object).getSeq()) : null;
        if (!Intrinsics.areEqual((Object)object2, (Object)object)) return false;
        return true;
    }

    @NotNull
    public final String getChatId() {
        return this.chatId;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getSeq() {
        return this.seq;
    }

    public final void setSeq(int n) {
        this.seq = n;
    }

    public final int getReadSeq() {
        return this.readSeq;
    }

    public final int getRecvSeq() {
        return this.recvSeq;
    }

    @Nullable
    public final Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public final Date getTouchedAt() {
        return this.touchedAt;
    }

    @Nullable
    public final TinodeUserPublic getPublicData() {
        return this.publicData;
    }

    @Nullable
    public final Access getAccess() {
        return this.access;
    }

    @NotNull
    public final String component1() {
        return this.chatId;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    public final int component3() {
        return this.seq;
    }

    public final int component4() {
        return this.readSeq;
    }

    public final int component5() {
        return this.recvSeq;
    }

    @Nullable
    public final Date component6() {
        return this.updatedAt;
    }

    @Nullable
    public final Date component7() {
        return this.touchedAt;
    }

    @Nullable
    public final TinodeUserPublic component8() {
        return this.publicData;
    }

    @Nullable
    public final Access component9() {
        return this.access;
    }

    @NotNull
    public final Chat copy(@NotNull String string, @NotNull String string2, int n, int n2, int n3, @Nullable Date date, @Nullable Date date2, @Nullable TinodeUserPublic tinodeUserPublic, @Nullable Access access) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"chatId");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"name");
        return new Chat(string, string2, n, n2, n3, date, date2, tinodeUserPublic, access);
    }

    @NotNull
    public String toString() {
        return "Chat(chatId=" + this.chatId + ", name=" + this.name + ", seq=" + this.seq + ", readSeq=" + this.readSeq + ", recvSeq=" + this.recvSeq + ", updatedAt=" + this.updatedAt + ", touchedAt=" + this.touchedAt + ", publicData=" + this.publicData + ", access=" + this.access + ")";
    }

    public int hashCode() {
        String string = this.chatId;
        int n = (string != null ? string.hashCode() : 0) * 31;
        String string2 = this.name;
        int n2 = string2 != null ? string2.hashCode() : 0;
        n = ((((n + n2) * 31 + Integer.hashCode(this.seq)) * 31 + Integer.hashCode(this.readSeq)) * 31 + Integer.hashCode(this.recvSeq)) * 31;
        Date date = this.updatedAt;
        int n3 = date != null ? ((Object)date).hashCode() : 0;
        n = (n + n3) * 31;
        Date date2 = this.touchedAt;
        int n4 = date2 != null ? ((Object)date2).hashCode() : 0;
        n = (n + n4) * 31;
        TinodeUserPublic tinodeUserPublic = this.publicData;
        int n5 = tinodeUserPublic != null ? tinodeUserPublic.hashCode() : 0;
        int n6 = (n + n5) * 31;
        Access access = this.access;
        int n7 = access != null ? access.hashCode() : 0;
        return n6 + n7;
    }
}

