/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.mvvm.pagination;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.paging.LivePagedListBuilder;
import androidx.paging.PagedList;
import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;
import io.streamlayer.common.mvvm.basemodels.BaseError;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.mvvm.pagination.GenericPaginationDataSource;
import io.streamlayer.common.mvvm.pagination.GenericPaginationDataSourceFactory;
import io.streamlayer.common.mvvm.pagination.GenericPaginationParams;
import io.streamlayer.common.mvvm.pagination.PaginationBuilderKt;
import io.streamlayer.common.mvvm.pagination.PaginationBuilderKt$WhenMappings;
import io.streamlayer.common.mvvm.pagination.PaginationBuilderKt$buildLivePagedListWithState$1$$special$;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001c\u0010\n\u001a\u00020\t\"\u0004\b\u0000\u0010\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\fH\u0000\u001aq\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0007\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\f29\u0010\u000e\u001a5\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00050\f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u00140\u00020\u00130\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001aJ\u0010\u0017\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00040\u00022\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u00030\u00012\u0018\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u00030\u00020\u001cH\u0000\u00a8\u0006\u001d"}, d2={"buildLivePagedListWithState", "Landroidx/lifecycle/LiveData;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "Landroidx/paging/PagedList;", "DataType", "PaginationParams", "dataSourceFactory", "Lio/streamlayer/common/mvvm/pagination/GenericPaginationDataSourceFactory;", "paginationConfig", "Landroidx/paging/PagedList$Config;", "generateDefaultPaginationConfig", "paginationParams", "Lio/streamlayer/common/mvvm/pagination/GenericPaginationParams;", "generatePaginationDataSourceFactory", "call", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "params", "Lio/reactivex/Observable;", "", "compositeDisposable", "Lio/reactivex/disposables/CompositeDisposable;", "setMergedSourceDataByFetchState", "", "fetchState", "pagedDataList", "mergedSource", "Landroidx/lifecycle/MediatorLiveData;", "sdk_originalVoximplantRelease"})
public final class PaginationBuilderKt {
    @NotNull
    public static final <DataType, PaginationParams> GenericPaginationDataSourceFactory<DataType, PaginationParams> generatePaginationDataSourceFactory(@NotNull GenericPaginationParams<PaginationParams> genericPaginationParams, @NotNull Function1<? super GenericPaginationParams<PaginationParams>, ? extends Observable<ResourceState<List<DataType>>>> function1, @NotNull CompositeDisposable compositeDisposable) {
        Intrinsics.checkParameterIsNotNull(genericPaginationParams, (String)"paginationParams");
        Intrinsics.checkParameterIsNotNull(function1, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)compositeDisposable, (String)"compositeDisposable");
        return new GenericPaginationDataSourceFactory(genericPaginationParams, function1, compositeDisposable);
    }

    @NotNull
    public static final <PaginationParams> PagedList.Config generateDefaultPaginationConfig(@NotNull GenericPaginationParams<PaginationParams> genericPaginationParams) {
        Intrinsics.checkParameterIsNotNull(genericPaginationParams, (String)"paginationParams");
        PagedList.Config config = new PagedList.Config.Builder().setPageSize(genericPaginationParams.getPageSize()).setInitialLoadSizeHint(genericPaginationParams.getPageSize() * 2).setEnablePlaceholders(false).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"PagedList.Config.Builder\u2026isabled.\n        .build()");
        return config;
    }

    @NotNull
    public static final <DataType, PaginationParams> LiveData<ResourceState<PagedList<DataType>>> buildLivePagedListWithState(@NotNull GenericPaginationDataSourceFactory<DataType, PaginationParams> mediatorLiveData, @NotNull PagedList.Config config) {
        Observer observer;
        MediatorLiveData mediatorLiveData2;
        Ref.ObjectRef objectRef;
        Intrinsics.checkParameterIsNotNull(mediatorLiveData, (String)"dataSourceFactory");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"paginationConfig");
        config = new LivePagedListBuilder(mediatorLiveData, config).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"LivePagedListBuilder<Int\u2026paginationConfig).build()");
        Ref.ObjectRef objectRef2 = objectRef;
        objectRef2();
        objectRef.element = mediatorLiveData.getFetchState();
        mediatorLiveData = mediatorLiveData2;
        mediatorLiveData();
        Observer observer2 = observer;
        observer = new Observer<S>(mediatorLiveData, objectRef2, (LiveData)config){
            final /* synthetic */ MediatorLiveData $mergedSource;
            final /* synthetic */ Ref.ObjectRef $fetchState;
            final /* synthetic */ LiveData $pagedDataList;
            {
                this.$mergedSource = mediatorLiveData;
                this.$fetchState = objectRef;
                this.$pagedDataList = liveData;
            }

            public final void onChanged(PagedList<DataType> pagedList) {
                Object object = pagedList != null ? pagedList.getDataSource() : null;
                if (!(object instanceof GenericPaginationDataSource)) {
                    object = null;
                }
                if ((object = (GenericPaginationDataSource)((Object)object)) != null) {
                    buildLivePagedListWithState.1 v0 = this_;
                    v0.$mergedSource.removeSource((LiveData)((MutableLiveData)this_.$fetchState.element));
                    v0.$fetchState.element = object.getFetchState();
                    v0.$mergedSource.addSource((LiveData)((MutableLiveData)this_.$fetchState.element), new Observer<S>(this_){
                        final /* synthetic */ buildLivePagedListWithState.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void onChanged(ResourceState<? extends DataType> resourceState) {
                            Intrinsics.checkExpressionValueIsNotNull(resourceState, (String)"newFetchState");
                            buildLivePagedListWithState.1 v0 = this_.this$0;
                            buildLivePagedListWithState$1$$special$$inlined$let$lambda$1 this_ = v0.$pagedDataList;
                            PaginationBuilderKt.setMergedSourceDataByFetchState(resourceState, this_, v0.$mergedSource);
                        }
                    });
                }
                if ((object = (object = (ResourceState)((MutableLiveData)this_.$fetchState.element).getValue()) != null ? object.getStatus() : null) != null) {
                    int n = PaginationBuilderKt$WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
                    if (n != 1) {
                        if (n != 2) {
                            if (n == 3) {
                                buildLivePagedListWithState.1 v1 = this_;
                                buildLivePagedListWithState.1 this_ = v1.$mergedSource;
                                ResourceState.Companion companion = ResourceState.Companion;
                                Object object2 = (ResourceState)((MutableLiveData)v1.$fetchState.element).getValue();
                                if (object2 == null || (object2 = ((ResourceState)object2).getError()) == null) {
                                    BaseError baseError;
                                    object2 = baseError;
                                    baseError = new BaseError(null, 0, null, 7, null);
                                }
                                this_.setValue(companion.error((BaseError)object2, pagedList));
                            }
                        } else {
                            this_.$mergedSource.setValue(ResourceState.Companion.loading(pagedList));
                        }
                    } else {
                        this_.$mergedSource.setValue(ResourceState.Companion.success(pagedList));
                    }
                }
            }
        };
        mediatorLiveData2.addSource((LiveData)config, observer2);
        return mediatorLiveData2;
    }

    public static final <DataType> void setMergedSourceDataByFetchState(@NotNull ResourceState<? extends DataType> object, @NotNull LiveData<PagedList<DataType>> object2, @NotNull MediatorLiveData<ResourceState<PagedList<DataType>>> mediatorLiveData) {
        Intrinsics.checkParameterIsNotNull(object, (String)"fetchState");
        Intrinsics.checkParameterIsNotNull(object2, (String)"pagedDataList");
        Intrinsics.checkParameterIsNotNull(mediatorLiveData, (String)"mergedSource");
        int n = PaginationBuilderKt$WhenMappings.$EnumSwitchMapping$1[((ResourceState)object).getStatus().ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    ResourceState<DataType> resourceState = object;
                    object = ResourceState.Companion;
                    object2 = object2.getValue();
                    BaseError baseError = resourceState.getError();
                    if (baseError == null) {
                        BaseError baseError2;
                        baseError = baseError2;
                        baseError2 = new BaseError(null, 0, null, 7, null);
                    }
                    mediatorLiveData.setValue(((ResourceState.Companion)object).error(baseError, object2));
                }
            } else {
                mediatorLiveData.setValue(ResourceState.Companion.loading(object2.getValue()));
            }
        } else {
            mediatorLiveData.setValue(ResourceState.Companion.success(object2.getValue()));
        }
    }
}

