/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.chat;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.emoji.widget.EmojiEditText;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentContainerView;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentViewModelLazyKt;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.NavArgsLazy;
import androidx.navigation.fragment.FragmentKt;
import androidx.paging.PagingData;
import androidx.recyclerview.widget.ConcatAdapter;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.mvvm.BaseFragment;
import io.streamlayer.common.mvvm.Event;
import io.streamlayer.common.mvvm.ResourceStateObserver;
import io.streamlayer.common.mvvm.basemodels.BaseError;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.mvvm.basemodels.Status;
import io.streamlayer.common.views.SLREmptyStatusView;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.calls.call.WatchPartyRouter;
import io.streamlayer.sdk.main.StreamLayerViewModel;
import io.streamlayer.sdk.messaging.ChatInviteViewModel;
import io.streamlayer.sdk.messaging.MessagingExtensionsKt;
import io.streamlayer.sdk.messaging.chat.ChatViewModel;
import io.streamlayer.sdk.messaging.chat.MessagingAdapter;
import io.streamlayer.sdk.messaging.chat.MessagingChatFragment;
import io.streamlayer.sdk.messaging.chat.MessagingChatFragment$setupUI$;
import io.streamlayer.sdk.messaging.chat.MessagingChatFragmentArgs;
import io.streamlayer.sdk.messaging.chat.ResendMessageDialog;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.usecases.CreateChatType;
import io.streamlayer.utils.ExtensionsKt;
import io.streamlayer.utils.TopSheetBehavior;
import java.util.ArrayList;
import java.util.HashMap;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b*\u0010\bJ\u0019\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0012\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0006J!\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0017\u0010\bJ\u000f\u0010\u0018\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0018\u0010\bJ\u0017\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0006R\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001d\u0010#\u001a\u00020\u001e8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u0016\u0010$\u001a\u00020\u001b8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b$\u0010\u001dR\u001d\u0010)\u001a\u00020%8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010 \u001a\u0004\b'\u0010(\u00a8\u0006+"}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingChatFragment;", "Lio/streamlayer/common/mvvm/BaseFragment;", "Landroid/os/Bundle;", "savedInstanceState", "", "setupUI", "(Landroid/os/Bundle;)V", "submitMessage", "()V", "bind", "", "hasMessages", "showMessagesEmpty", "(Z)V", "Lio/streamlayer/sdk/model/messaging/Topic;", "topic", "setCallButton", "(Lio/streamlayer/sdk/model/messaging/Topic;)V", "onCreate", "Landroid/view/View;", "view", "onViewCreated", "(Landroid/view/View;Landroid/os/Bundle;)V", "onResume", "onPause", "outState", "onSaveInstanceState", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;", "messagingAdapter", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;", "Lio/streamlayer/sdk/main/StreamLayerViewModel;", "streamLayerViewModel$delegate", "Lkotlin/Lazy;", "getStreamLayerViewModel", "()Lio/streamlayer/sdk/main/StreamLayerViewModel;", "streamLayerViewModel", "failedMessageAdapter", "Lio/streamlayer/sdk/messaging/chat/ChatViewModel;", "viewModel$delegate", "getViewModel", "()Lio/streamlayer/sdk/messaging/chat/ChatViewModel;", "viewModel", "<init>", "sdk_originalRelease"})
public final class MessagingChatFragment
extends BaseFragment {
    private final Lazy streamLayerViewModel$delegate;
    private final Lazy viewModel$delegate;
    private MessagingAdapter messagingAdapter;
    private MessagingAdapter failedMessageAdapter;
    private HashMap _$_findViewCache;

    private final StreamLayerViewModel getStreamLayerViewModel() {
        return (StreamLayerViewModel)this.streamLayerViewModel$delegate.getValue();
    }

    private final ChatViewModel getViewModel() {
        return (ChatViewModel)((Object)this.viewModel$delegate.getValue());
    }

    private final void setupUI(Bundle object) {
        LinearLayoutManager linearLayoutManager;
        MessagingAdapter messagingAdapter;
        Function1<ChatMessage, Unit> function1;
        MessagingChatFragment messagingChatFragment = this;
        ExtensionsKt.setupToolbarWithNavController$default(messagingChatFragment, 0, null, null, 0, 0, 0, false, null, 255, null);
        TopSheetBehavior<FragmentContainerView> topSheetBehavior = TopSheetBehavior.from((FragmentContainerView)messagingChatFragment._$_findCachedViewById(R.id.chatParticipantsOverlayContainer));
        topSheetBehavior.setTopSheetCallback(new TopSheetBehavior.TopSheetCallback(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
            }

            public void onSlide(@NotNull View view, float f, @Nullable Boolean bl) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"topSheet");
            }

            public void onStateChanged(@NotNull View view, int n) {
                float f;
                Intrinsics.checkNotNullParameter((Object)view, (String)"topSheet");
                if (n != 3) {
                    if (n != 4) {
                        return;
                    }
                    f = 0.0f;
                } else {
                    f = 90.0f;
                }
                ((AppCompatImageView)this.this$0._$_findCachedViewById(R.id.toolbarChatChevron)).animate().rotation(f).start();
            }
        });
        if (object != null) {
            TopSheetBehavior<FragmentContainerView> topSheetBehavior2 = topSheetBehavior;
            int n = object.getInt("participantsSheetState");
            Intrinsics.checkNotNullExpressionValue(topSheetBehavior2, (String)"overlayBehavior");
            topSheetBehavior2.setState(n);
        }
        TopSheetBehavior<FragmentContainerView> topSheetBehavior3 = topSheetBehavior;
        object = (AppCompatImageView)this._$_findCachedViewById(R.id.toolbarChatChevron);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toolbarChatChevron");
        Intrinsics.checkNotNullExpressionValue(topSheetBehavior3, (String)"overlayBehavior");
        float f = topSheetBehavior3.getState() == 3 ? 90.0f : 0.0f;
        object.setRotation(f);
        object = function1;
        function1 = new Function1<ChatMessage, Unit>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(1);
            }

            public final void invoke(@NotNull ChatMessage chatMessage) {
                ResendMessageDialog resendMessageDialog;
                Function0<Unit> function0;
                Function0<Unit> function02;
                setupUI.alertClickListener.1 v0 = object;
                Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"message");
                Function0<Unit> function03 = function02;
                function02 = new Function0<Unit>(object, chatMessage){
                    final /* synthetic */ setupUI.alertClickListener.1 this$0;
                    final /* synthetic */ ChatMessage $message;
                    {
                        this.this$0 = var1_1;
                        this.$message = chatMessage;
                        super(0);
                    }

                    public final void invoke() {
                        setupUI.alertClickListener.resendClickHandler.1 v0 = this;
                        AnalyticsRepo.DefaultImpls.triggerInteractionEvent$default(v0.this$0.this$0.getAnalyticsRepo(), null, null, 3, null);
                        MessagingChatFragment.access$getViewModel$p(v0.this$0.this$0).resendMessage(this.$message);
                    }
                };
                Function0<Unit> function04 = function0;
                function0 = new Function0<Unit>(object, chatMessage){
                    final /* synthetic */ setupUI.alertClickListener.1 this$0;
                    final /* synthetic */ ChatMessage $message;
                    {
                        this.this$0 = var1_1;
                        this.$message = chatMessage;
                        super(0);
                    }

                    public final void invoke() {
                        setupUI.alertClickListener.removeClickHandler.1 v0 = this;
                        AnalyticsRepo.DefaultImpls.triggerInteractionEvent$default(v0.this$0.this$0.getAnalyticsRepo(), null, null, 3, null);
                        MessagingChatFragment.access$getViewModel$p(v0.this$0.this$0).removeMessage(this.$message);
                    }
                };
                Object object = resendMessageDialog;
                resendMessageDialog = new ResendMessageDialog(function03, (Function0<? extends Object>)function04);
                chatMessage = v0.this$0.getActivity();
                if (chatMessage != null && (chatMessage = chatMessage.getSupportFragmentManager()) != null) {
                    object.show((FragmentManager)chatMessage, null);
                }
            }
        };
        String string2 = this.getSession().getTinodeUserId();
        if (string2 == null) {
            string2 = "";
        }
        MessagingAdapter messagingAdapter2 = messagingAdapter;
        messagingAdapter2(string2, (Function1<? super ChatMessage, Unit>)object);
        this.messagingAdapter = messagingAdapter2;
        string2 = this.getSession().getTinodeUserId();
        if (string2 == null) {
            string2 = "";
        }
        MessagingChatFragment messagingChatFragment2 = this;
        MessagingAdapter messagingAdapter3 = messagingAdapter;
        messagingAdapter3(string2, (Function1<? super ChatMessage, Unit>)object);
        messagingChatFragment2.failedMessageAdapter = messagingAdapter3;
        object = linearLayoutManager;
        linearLayoutManager = new LinearLayoutManager(this.requireContext(), 1, true);
        RecyclerView recyclerView = (RecyclerView)messagingChatFragment2._$_findCachedViewById(R.id.messagesList);
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"messagesList");
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)object);
        messagingAdapter = messagingChatFragment2.messagingAdapter;
        if (messagingAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messagingAdapter");
        }
        MessagingChatFragment messagingChatFragment3 = this;
        messagingAdapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(this, (LinearLayoutManager)object){
            final /* synthetic */ MessagingChatFragment this$0;
            final /* synthetic */ LinearLayoutManager $chatLayoutManager;
            {
                this.this$0 = messagingChatFragment;
                this.$chatLayoutManager = linearLayoutManager;
            }

            public void onItemRangeInserted(int n, int n2) {
                super.onItemRangeInserted(n, n2);
                if (n == 0 && this.$chatLayoutManager.findFirstVisibleItemPosition() < 2) {
                    this.$chatLayoutManager.scrollToPosition(0);
                }
                if (MessagingChatFragment.access$getMessagingAdapter$p(this.this$0).snapshot().getItems().isEmpty() ^ true) {
                    MessagingChatFragment.access$getViewModel$p(this.this$0).messageRead(MessagingChatFragment.access$getMessagingAdapter$p(this.this$0).snapshot().getItems());
                }
            }
        });
        EmojiEditText emojiEditText = (EmojiEditText)messagingChatFragment3._$_findCachedViewById(R.id.chatMessageInput);
        Intrinsics.checkNotNullExpressionValue((Object)emojiEditText, (String)"chatMessageInput");
        emojiEditText.addTextChangedListener(new TextWatcher(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
            }

            public void afterTextChanged(@Nullable Editable editable) {
                setupUI$$inlined$addTextChangedListener$1 this_ = (ImageButton)this_.this$0._$_findCachedViewById(R.id.chatMessageSendFAB);
                Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"chatMessageSendFAB");
                boolean bl = editable == null || editable.length() == 0;
                io.streamlayer.common.kotlin.ExtensionsKt.visibleIfElse$default((View)this_, bl ^ true, 0, 2, null);
            }

            public void beforeTextChanged(@Nullable CharSequence charSequence, int n, int n2, int n3) {
            }

            public void onTextChanged(@Nullable CharSequence charSequence, int n, int n2, int n3) {
            }
        });
        ((ImageButton)messagingChatFragment3._$_findCachedViewById(R.id.chatMessageSendFAB)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
            }

            public final void onClick(View view) {
                setupUI.5 v0 = this;
                AnalyticsRepo.DefaultImpls.triggerInteractionEvent$default(v0.this$0.getAnalyticsRepo(), null, null, 3, null);
                MessagingChatFragment.access$submitMessage(v0.this$0);
            }
        });
        ((ConstraintLayout)messagingChatFragment3._$_findCachedViewById(R.id.toolbarTitleContainer)).setOnClickListener(new View.OnClickListener(this, topSheetBehavior){
            final /* synthetic */ MessagingChatFragment this$0;
            final /* synthetic */ TopSheetBehavior $overlayBehavior;
            {
                this.this$0 = messagingChatFragment;
                this.$overlayBehavior = topSheetBehavior;
            }

            public final void onClick(View view) {
                setupUI.6 v0 = this;
                AnalyticsRepo.DefaultImpls.triggerInteractionEvent$default(v0.this$0.getAnalyticsRepo(), null, null, 3, null);
                TopSheetBehavior topSheetBehavior = v0.$overlayBehavior;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)topSheetBehavior), (String)"overlayBehavior");
                if (topSheetBehavior.getState() == 3) {
                    setupUI.6 v2 = this;
                    ((AppCompatImageView)v2.this$0._$_findCachedViewById(R.id.toolbarChatChevron)).animate().rotation(0.0f).start();
                    TopSheetBehavior topSheetBehavior2 = v2.$overlayBehavior;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)topSheetBehavior2), (String)"overlayBehavior");
                    topSheetBehavior2.setState(4);
                } else {
                    setupUI.6 v4 = this;
                    ((AppCompatImageView)v4.this$0._$_findCachedViewById(R.id.toolbarChatChevron)).animate().rotation(90.0f).start();
                    TopSheetBehavior topSheetBehavior3 = v4.$overlayBehavior;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)topSheetBehavior3), (String)"overlayBehavior");
                    topSheetBehavior3.setState(3);
                }
            }
        });
    }

    private final void submitMessage() {
        MessagingChatFragment messagingChatFragment = string2;
        EmojiEditText emojiEditText = (EmojiEditText)messagingChatFragment._$_findCachedViewById(R.id.chatMessageInput);
        Intrinsics.checkNotNullExpressionValue((Object)emojiEditText, (String)"chatMessageInput");
        String string2 = emojiEditText.getText().toString();
        EmojiEditText emojiEditText2 = (EmojiEditText)messagingChatFragment._$_findCachedViewById(R.id.chatMessageInput);
        Intrinsics.checkNotNullExpressionValue((Object)emojiEditText2, (String)"chatMessageInput");
        emojiEditText2.setText(null);
        messagingChatFragment.getViewModel().sendMessage(string2);
    }

    private final void bind() {
        Function1<BaseError, Unit> function1;
        MessagingChatFragment messagingChatFragment = this;
        Function1<BaseError, Unit> function12 = function1;
        function1 = new Function1<BaseError, Unit>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(1);
            }

            public final void invoke(@NotNull BaseError baseError) {
                bind.2 v0 = this;
                Intrinsics.checkNotNullParameter((Object)baseError, (String)"it");
                v0.this$0.showProgressCircle(false);
                v0.this$0.showError(baseError.getErrorMessage());
                RecyclerView recyclerView = (RecyclerView)v0.this$0._$_findCachedViewById(R.id.messagesList);
                Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"messagesList");
                if (recyclerView.getAdapter() == null) {
                    RecyclerView recyclerView2 = (RecyclerView)this.this$0._$_findCachedViewById(R.id.messagesList);
                    Intrinsics.checkNotNullExpressionValue((Object)recyclerView2, (String)"messagesList");
                    recyclerView2.setAdapter((RecyclerView.Adapter)new ConcatAdapter(new RecyclerView.Adapter[]{MessagingChatFragment.access$getFailedMessageAdapter$p(this.this$0), MessagingChatFragment.access$getMessagingAdapter$p(this.this$0)}));
                }
            }
        };
        messagingChatFragment.getViewModel().getTopic().observe(this.getViewLifecycleOwner(), new ResourceStateObserver(this, (Function1)new Function1<Topic, Unit>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(1);
            }

            public final void invoke(@Nullable Topic topic) {
                if (topic != null) {
                    Object object;
                    String string2 = this.this$0.getSession().getTinodeUserId();
                    if (string2 == null) {
                        string2 = "";
                    }
                    ChatType chatType = ChatType.P2P;
                    if (topic.getChatType() != chatType && MessagingExtensionsKt.participantsWithoutUser(topic, string2).size() != 1) {
                        bind.1 v0 = this;
                        object = (AppCompatTextView)v0.this$0._$_findCachedViewById(R.id.toolbarTitle);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toolbarTitle");
                        Object object2 = v0.this$0.getContext();
                        object2 = object2 != null ? object2.getString(R.string.slr_messaging_chat_group_title, new Object[]{MessagingExtensionsKt.participantsWithoutUser(topic, string2).size()}) : null;
                        object.setText((CharSequence)object2);
                        ImageView imageView = (ImageView)this.this$0._$_findCachedViewById(R.id.toolbarChatAvatar);
                        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"toolbarChatAvatar");
                        io.streamlayer.common.kotlin.ExtensionsKt.gone((View)imageView);
                    } else {
                        bind.1 v2 = this;
                        AppCompatTextView appCompatTextView = (AppCompatTextView)v2.this$0._$_findCachedViewById(R.id.toolbarTitle);
                        Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"toolbarTitle");
                        MessagingExtensionsKt.setChatName((TextView)appCompatTextView, topic, string2);
                        ImageView imageView = (ImageView)v2.this$0._$_findCachedViewById(R.id.toolbarChatAvatar);
                        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"toolbarChatAvatar");
                        MessagingExtensionsKt.loadChatImage(imageView, topic, string2);
                        ImageView imageView2 = (ImageView)v2.this$0._$_findCachedViewById(R.id.toolbarChatAvatar);
                        Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"toolbarChatAvatar");
                        io.streamlayer.common.kotlin.ExtensionsKt.visible((View)imageView2);
                    }
                    object = MessagingChatFragment.access$getMessagingAdapter$p(this.this$0);
                    if (topic.getChatType() != chatType && MessagingExtensionsKt.participantsWithoutUser(topic, string2).size() != 1) {
                        chatType = ChatType.Group;
                    }
                    ((MessagingAdapter)((Object)object)).setMode(chatType);
                    RecyclerView recyclerView = (RecyclerView)this.this$0._$_findCachedViewById(R.id.messagesList);
                    Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"messagesList");
                    if (recyclerView.getAdapter() == null) {
                        RecyclerView recyclerView2 = (RecyclerView)this.this$0._$_findCachedViewById(R.id.messagesList);
                        Intrinsics.checkNotNullExpressionValue((Object)recyclerView2, (String)"messagesList");
                        recyclerView2.setAdapter((RecyclerView.Adapter)new ConcatAdapter(new RecyclerView.Adapter[]{MessagingChatFragment.access$getFailedMessageAdapter$p(this.this$0), MessagingChatFragment.access$getMessagingAdapter$p(this.this$0)}));
                    }
                    bind.1 v8 = this;
                    v8.this$0.getSession().decreaseTotalUnreadMessagesCount(topic.getSeq() - topic.getReadSeq());
                    MessagingChatFragment.access$setCallButton(v8.this$0, topic);
                }
            }
        }, null, (Function1)function12, false, 20, null));
        LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)messagingChatFragment).launchWhenCreated((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object);
                    return Unit.INSTANCE;
                } else {
                    Function2<PagingData<ChatMessage>, Continuation<? super Unit>, Object> function2;
                    ResultKt.throwOnFailure((Object)object);
                    Function2<PagingData<ChatMessage>, Continuation<? super Unit>, Object> function22 = function2;
                    function2 = new Function2<PagingData<ChatMessage>, Continuation<? super Unit>, Object>(this, null){
                        private /* synthetic */ Object L$0;
                        int label;
                        final /* synthetic */ bind.3 this$0;
                        {
                            this.this$0 = var1_1;
                            super(2, continuation);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            int n = this.label;
                            if (n != 0) {
                                if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                ResultKt.throwOnFailure((Object)object);
                                return Unit.INSTANCE;
                            } else {
                                bind.1 v0 = this;
                                ResultKt.throwOnFailure((Object)object);
                                object = (PagingData)v0.L$0;
                                this.label = 1;
                                if (MessagingChatFragment.access$getMessagingAdapter$p(v0.this$0.this$0).submitData((PagingData)object, (Continuation)this) != object2) return Unit.INSTANCE;
                                return object2;
                            }
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                            Intrinsics.checkNotNullParameter(continuation, (String)"completion");
                            new /* invalid duplicate definition of identical inner class */.L$0 = object;
                            return new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(Object object, Object object2) {
                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                        }
                    };
                    this.label = 1;
                    if (FlowKt.collectLatest((Flow)FlowKt.distinctUntilChanged(MessagingChatFragment.access$getViewModel$p(this.this$0).getChatMessages()), (Function2)function22, (Continuation)this) != object2) return Unit.INSTANCE;
                    return object2;
                }
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                Intrinsics.checkNotNullParameter(continuation, (String)"completion");
                return new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)messagingChatFragment).launchWhenCreated((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object);
                    return Unit.INSTANCE;
                } else {
                    Function2<PagingData<ChatMessage>, Continuation<? super Unit>, Object> function2;
                    ResultKt.throwOnFailure((Object)object);
                    Function2<PagingData<ChatMessage>, Continuation<? super Unit>, Object> function22 = function2;
                    function2 = new Function2<PagingData<ChatMessage>, Continuation<? super Unit>, Object>(this, null){
                        private /* synthetic */ Object L$0;
                        int label;
                        final /* synthetic */ bind.4 this$0;
                        {
                            this.this$0 = var1_1;
                            super(2, continuation);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            int n = this.label;
                            if (n != 0) {
                                if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                ResultKt.throwOnFailure((Object)object);
                                return Unit.INSTANCE;
                            } else {
                                bind.1 v0 = this;
                                ResultKt.throwOnFailure((Object)object);
                                object = (PagingData)v0.L$0;
                                this.label = 1;
                                if (MessagingChatFragment.access$getFailedMessageAdapter$p(v0.this$0.this$0).submitData((PagingData)object, (Continuation)this) != object2) return Unit.INSTANCE;
                                return object2;
                            }
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                            Intrinsics.checkNotNullParameter(continuation, (String)"completion");
                            new /* invalid duplicate definition of identical inner class */.L$0 = object;
                            return new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(Object object, Object object2) {
                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                        }
                    };
                    this.label = 1;
                    if (FlowKt.collectLatest((Flow)FlowKt.distinctUntilChanged(MessagingChatFragment.access$getViewModel$p(this.this$0).getFailedChatMessages()), (Function2)function22, (Continuation)this) != object2) return Unit.INSTANCE;
                    return object2;
                }
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                Intrinsics.checkNotNullParameter(continuation, (String)"completion");
                return new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        messagingChatFragment.getViewModel().getLoading().observe(this.getViewLifecycleOwner(), new ResourceStateObserver(this, (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(1);
            }

            public final void invoke(@Nullable Boolean bl) {
                MessagingChatFragment messagingChatFragment = messagingChatFragment.this$0;
                boolean bl2 = bl != null ? bl : false;
                messagingChatFragment.showProgressCircle(bl2);
            }
        }, null, null, false, 28, null));
        messagingChatFragment.getViewModel().getNetworkConnectionLiveData().observe(this.getViewLifecycleOwner(), new Observer<Boolean>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
            }

            public final void onChanged(Boolean bl) {
                View view = this.this$0._$_findCachedViewById(R.id.slWaitingNetworkView);
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"slWaitingNetworkView");
                io.streamlayer.common.kotlin.ExtensionsKt.visibleIf(view, bl ^ true);
            }
        });
        messagingChatFragment.getViewModel().getShowCallButton().observe(this.getViewLifecycleOwner(), new ResourceStateObserver(this, (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(1);
            }

            public final void invoke(@Nullable Boolean bl) {
                if (bl != null) {
                    boolean bl2 = bl;
                    AppCompatImageButton appCompatImageButton = (AppCompatImageButton)this.this$0._$_findCachedViewById(R.id.toolbarRightOptionBtn);
                    Intrinsics.checkNotNullExpressionValue((Object)appCompatImageButton, (String)"toolbarRightOptionBtn");
                    io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)appCompatImageButton, bl2);
                }
            }
        }, null, null, false, 28, null));
        messagingChatFragment.getViewModel().getCreatedTopic().observe(this.getViewLifecycleOwner(), new Observer<ResourceState<? extends Event<? extends Topic>>>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
            }

            public final void onChanged(ResourceState<? extends Event<Topic>> object) {
                Object object2 = watchPartyRouter.this$0;
                boolean bl = ((ResourceState)object).getStatus() == Status.LOADING;
                ((BaseFragment)object2).showLoader(bl);
                object2 = ((ResourceState)object).getError();
                if (object2 != null && (object2 = ((BaseError)object2).getErrorMessage()) != null) {
                    watchPartyRouter.this$0.showError((String)object2);
                }
                if ((object = ((ResourceState)object).getData()) != null && (object = (Topic)((Event)object).getContentIfNotHandled()) != null) {
                    if (((Topic)object).isWPTopic()) {
                        WatchPartyRouter watchPartyRouter = MessagingChatFragment.access$getStreamLayerViewModel$p(watchPartyRouter.this$0).getWatchPartyRouter();
                        if (watchPartyRouter != null) {
                            WatchPartyRouter.openWatchParty$default(watchPartyRouter, ((Topic)object).getChatId(), true, null, 4, null);
                        }
                    } else {
                        FragmentKt.findNavController((Fragment)watchPartyRouter.this$0).navigate(R.id.fragmentMessagingChat, new MessagingChatFragmentArgs(((Topic)object).getChatId()).toBundle());
                    }
                }
            }
        });
        messagingChatFragment.getViewModel().getHasMessages().observe(this.getViewLifecycleOwner(), new ResourceStateObserver(this, (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(1);
            }

            public final void invoke(@Nullable Boolean bl) {
                if (bl != null) {
                    boolean bl2 = bl;
                    MessagingChatFragment.access$showMessagesEmpty(this.this$0, bl2);
                }
            }
        }, null, null, false, 28, null));
    }

    private final void showMessagesEmpty(boolean bl) {
        MessagingChatFragment messagingChatFragment = this;
        SLREmptyStatusView sLREmptyStatusView = (SLREmptyStatusView)messagingChatFragment._$_findCachedViewById(R.id.messagingChatEmpty);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sLREmptyStatusView), (String)"messagingChatEmpty");
        io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)sLREmptyStatusView, bl ^ true);
        RecyclerView recyclerView = (RecyclerView)messagingChatFragment._$_findCachedViewById(R.id.messagesList);
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"messagesList");
        io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)recyclerView, bl);
    }

    private final void setCallButton(Topic topic) {
        ((AppCompatImageButton)this._$_findCachedViewById(R.id.toolbarRightOptionBtn)).setOnClickListener(new View.OnClickListener(this, topic){
            final /* synthetic */ MessagingChatFragment this$0;
            final /* synthetic */ Topic $topic;
            {
                this.this$0 = messagingChatFragment;
                this.$topic = topic;
            }

            public final void onClick(View view) {
                ArrayList<String> arrayList;
                if (MessagingExtensionsKt.participantsWithoutUser(object.$topic, object.this$0.getSession().getTinodeUserId()).size() > 8) {
                    MessagingChatFragment messagingChatFragment = object.this$0;
                    String string2 = messagingChatFragment.getResources().getString(R.string.slr_max_count_of_participants_is_reached, new Object[]{String.valueOf(9)});
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(\n   \u2026g()\n                    )");
                    messagingChatFragment.showError(string2);
                    return;
                }
                setCallButton.1 v2 = object;
                Object object = MessagingChatFragment.access$getViewModel$p(v2.this$0);
                view = null;
                Object object2 = v2.$topic.getParticipants();
                ArrayList<String> arrayList2 = arrayList;
                arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    arrayList2.add(((TinodeContact)object2.next()).getChatUserId());
                }
                Object object3 = object;
                object = CreateChatType.Call;
                ChatInviteViewModel.createOrInvite$default((ChatInviteViewModel)((Object)object3), (String)view, arrayList2, null, (CreateChatType)((Object)object), 5, null);
            }
        });
    }

    public MessagingChatFragment() {
        Function0<Fragment> function0;
        Function0<ViewModelProvider.Factory> function02;
        Function0<ViewModelProvider.Factory> function03;
        Function0<ViewModelStoreOwner> function04;
        MessagingChatFragment messagingChatFragment = this;
        super(R.layout.slr_fragment_chat);
        Object object = function04;
        function04 = new Function0<ViewModelStoreOwner>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(0);
            }

            @NotNull
            public final ViewModelStoreOwner invoke() {
                Fragment fragment = this.this$0.requireParentFragment().requireParentFragment();
                Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"requireParentFragment().requireParentFragment()");
                return fragment;
            }
        };
        Object object2 = function03;
        function03 = new Function0<ViewModelProvider.Factory>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                return this.this$0.getViewModelFactory();
            }
        };
        messagingChatFragment.streamLayerViewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)messagingChatFragment, (KClass)Reflection.getOrCreateKotlinClass(StreamLayerViewModel.class), (Function0)new Function0<ViewModelStore>((Function0)object){
            final /* synthetic */ Function0 $ownerProducer;
            {
                this.$ownerProducer = function0;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = ((ViewModelStoreOwner)this.$ownerProducer.invoke()).getViewModelStore();
                Intrinsics.checkExpressionValueIsNotNull((Object)viewModelStore, (String)"ownerProducer().viewModelStore");
                return viewModelStore;
            }
        }, (Function0)object2);
        object = function02;
        function02 = new Function0<ViewModelProvider.Factory>(this){
            final /* synthetic */ MessagingChatFragment this$0;
            {
                this.this$0 = messagingChatFragment;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                return this.this$0.getViewModelFactory();
            }
        };
        object2 = function0;
        function0 = new Function0<Fragment>((Fragment)this){
            final /* synthetic */ Fragment $this_viewModels;
            {
                this.$this_viewModels = fragment;
                super(0);
            }

            @NotNull
            public final Fragment invoke() {
                return this.$this_viewModels;
            }
        };
        messagingChatFragment.viewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)messagingChatFragment, (KClass)Reflection.getOrCreateKotlinClass(ChatViewModel.class), (Function0)new Function0<ViewModelStore>((Function0)object2){
            final /* synthetic */ Function0 $ownerProducer;
            {
                this.$ownerProducer = function0;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = ((ViewModelStoreOwner)this.$ownerProducer.invoke()).getViewModelStore();
                Intrinsics.checkExpressionValueIsNotNull((Object)viewModelStore, (String)"ownerProducer().viewModelStore");
                return viewModelStore;
            }
        }, (Function0)object);
    }

    public static final /* synthetic */ ChatViewModel access$getViewModel$p(MessagingChatFragment messagingChatFragment) {
        return messagingChatFragment.getViewModel();
    }

    public static final /* synthetic */ MessagingAdapter access$getMessagingAdapter$p(MessagingChatFragment object) {
        object = object.messagingAdapter;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messagingAdapter");
        }
        return object;
    }

    public static final /* synthetic */ void access$setMessagingAdapter$p(MessagingChatFragment messagingChatFragment, MessagingAdapter messagingAdapter) {
        messagingChatFragment.messagingAdapter = messagingAdapter;
    }

    public static final /* synthetic */ void access$submitMessage(MessagingChatFragment messagingChatFragment) {
        messagingChatFragment.submitMessage();
    }

    public static final /* synthetic */ MessagingAdapter access$getFailedMessageAdapter$p(MessagingChatFragment object) {
        object = object.failedMessageAdapter;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"failedMessageAdapter");
        }
        return object;
    }

    public static final /* synthetic */ void access$setFailedMessageAdapter$p(MessagingChatFragment messagingChatFragment, MessagingAdapter messagingAdapter) {
        messagingChatFragment.failedMessageAdapter = messagingAdapter;
    }

    public static final /* synthetic */ void access$setCallButton(MessagingChatFragment messagingChatFragment, Topic topic) {
        messagingChatFragment.setCallButton(topic);
    }

    public static final /* synthetic */ StreamLayerViewModel access$getStreamLayerViewModel$p(MessagingChatFragment messagingChatFragment) {
        return messagingChatFragment.getStreamLayerViewModel();
    }

    public static final /* synthetic */ void access$showMessagesEmpty(MessagingChatFragment messagingChatFragment, boolean bl) {
        messagingChatFragment.showMessagesEmpty(bl);
    }

    public void onCreate(@Nullable Bundle bundle) {
        MessagingChatFragment messagingChatFragment = this;
        super.onCreate(bundle);
        messagingChatFragment.getViewModel().init(((MessagingChatFragmentArgs)new NavArgsLazy(Reflection.getOrCreateKotlinClass(MessagingChatFragmentArgs.class), (Function0)new Function0<Bundle>((Fragment)this){
            final /* synthetic */ Fragment $this_navArgs;
            {
                this.$this_navArgs = fragment;
                super(0);
            }

            @NotNull
            public final Bundle invoke() {
                Bundle bundle = this.$this_navArgs.getArguments();
                if (bundle != null) {
                    return bundle;
                }
                throw new IllegalStateException("Fragment " + this.$this_navArgs + " has null arguments");
            }
        }).getValue()).getChatId());
    }

    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle bundle) {
        MessagingChatFragment messagingChatFragment = this;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, bundle);
        messagingChatFragment.setupUI(bundle);
        messagingChatFragment.bind();
    }

    public void onResume() {
        MessagingChatFragment messagingChatFragment = this;
        super.onResume();
        messagingChatFragment.getInAppNotificationsService().pauseNotifications(true, ((MessagingChatFragmentArgs)new NavArgsLazy(Reflection.getOrCreateKotlinClass(MessagingChatFragmentArgs.class), (Function0)new Function0<Bundle>((Fragment)this){
            final /* synthetic */ Fragment $this_navArgs;
            {
                this.$this_navArgs = fragment;
                super(0);
            }

            @NotNull
            public final Bundle invoke() {
                Bundle bundle = this.$this_navArgs.getArguments();
                if (bundle != null) {
                    return bundle;
                }
                throw new IllegalStateException("Fragment " + this.$this_navArgs + " has null arguments");
            }
        }).getValue()).getChatId());
    }

    public void onPause() {
        MessagingChatFragment messagingChatFragment = this;
        super.onPause();
        messagingChatFragment.getInAppNotificationsService().pauseNotifications(false, ((MessagingChatFragmentArgs)new NavArgsLazy(Reflection.getOrCreateKotlinClass(MessagingChatFragmentArgs.class), (Function0)new Function0<Bundle>((Fragment)this){
            final /* synthetic */ Fragment $this_navArgs;
            {
                this.$this_navArgs = fragment;
                super(0);
            }

            @NotNull
            public final Bundle invoke() {
                Bundle bundle = this.$this_navArgs.getArguments();
                if (bundle != null) {
                    return bundle;
                }
                throw new IllegalStateException("Fragment " + this.$this_navArgs + " has null arguments");
            }
        }).getValue()).getChatId());
    }

    public void onSaveInstanceState(@NotNull Bundle bundle) {
        MessagingChatFragment messagingChatFragment = messagingChatFragment2;
        Bundle bundle2 = bundle;
        Intrinsics.checkNotNullParameter((Object)bundle2, (String)"outState");
        super.onSaveInstanceState(bundle2);
        MessagingChatFragment messagingChatFragment2 = (FragmentContainerView)messagingChatFragment._$_findCachedViewById(R.id.chatParticipantsOverlayContainer);
        if (messagingChatFragment2 != null) {
            TopSheetBehavior<MessagingChatFragment> topSheetBehavior = TopSheetBehavior.from(messagingChatFragment2);
            Intrinsics.checkNotNullExpressionValue(topSheetBehavior, (String)"TopSheetBehavior.from(it)");
            bundle.putInt("participantsSheetState", topSheetBehavior.getState());
        }
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            View view2;
            view = view2;
            view2 = new HashMap();
            this._$_findViewCache = view;
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.getView();
            if (view == null) {
                return null;
            }
            view = view.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        HashMap hashMap = ((MessagingChatFragment)((Object)hashMap))._$_findViewCache;
        if (hashMap != null) {
            hashMap.clear();
        }
    }

    @Override
    public /* synthetic */ void onDestroyView() {
        MessagingChatFragment messagingChatFragment = this;
        super.onDestroyView();
        messagingChatFragment._$_clearFindViewByIdCache();
    }
}

