/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.media;

import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.social.TweetExtendedEntities;
import io.streamlayer.sdk.model.social.TweetMedia;
import io.streamlayer.sdk.model.social.TweetMediaVideoVariant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class TweetMediaUtils {
    public static final String PHOTO_TYPE = "photo";
    public static final String VIDEO_TYPE = "video";
    public static final String GIF_TYPE = "animated_gif";
    private static final String CONTENT_TYPE_MP4 = "video/mp4";
    private static final String CONTENT_TYPE_HLS = "application/x-mpegURL";
    private static final int LOOP_VIDEO_IN_MILLIS = 6500;
    private static final String TIME_FORMAT_LONG = "%1$d:%2$02d:%3$02d";
    private static final String TIME_FORMAT_SHORT = "%1$d:%2$02d";

    private TweetMediaUtils() {
    }

    public static String getPlaybackTime(long l) {
        int n = (int)(l / 1000L);
        int n2 = n % 60;
        int n3 = n / 60 % 60;
        int n4 = n / 3600;
        if (n4 > 0) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = n4;
            objectArray2[1] = n3;
            objectArray[2] = n2;
            return String.format(Locale.getDefault(), TIME_FORMAT_LONG, objectArray2);
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray3 = objectArray;
        objectArray3[0] = n3;
        objectArray[1] = n2;
        return String.format(Locale.getDefault(), TIME_FORMAT_SHORT, objectArray3);
    }

    public static TweetMedia getPhotoEntity(Tweet object) {
        object = TweetMediaUtils.getAllMediaEntities((Tweet)object);
        for (int j = object.size() - 1; j >= 0; --j) {
            TweetMedia tweetMedia = (TweetMedia)object.get(j);
            if (tweetMedia.getType() == null || !TweetMediaUtils.isPhotoType(tweetMedia)) continue;
            return tweetMedia;
        }
        return null;
    }

    public static List<TweetMedia> getPhotoEntities(Tweet object) {
        ArrayList arrayList;
        Tweet tweet = object;
        object = arrayList;
        arrayList = new ArrayList();
        TweetExtendedEntities tweetExtendedEntities = tweet.getMetaData().getExtendedEntities();
        if (tweetExtendedEntities != null && tweetExtendedEntities.getMedia() != null && tweetExtendedEntities.getMedia().size() > 0) {
            for (int j = 0; j <= tweetExtendedEntities.getMedia().size() - 1; ++j) {
                TweetMedia tweetMedia = tweetExtendedEntities.getMedia().get(j);
                if (tweetMedia.getType() == null || !TweetMediaUtils.isPhotoType(tweetMedia)) continue;
                object.add(tweetMedia);
            }
            return object;
        }
        return object;
    }

    public static boolean hasPhoto(Tweet tweet) {
        return TweetMediaUtils.getPhotoEntity(tweet) != null;
    }

    public static TweetMedia getVideoEntity(Tweet object) {
        for (TweetMedia tweetMedia : TweetMediaUtils.getAllMediaEntities((Tweet)object)) {
            if (tweetMedia.getType() == null || !TweetMediaUtils.isVideoType(tweetMedia)) continue;
            return tweetMedia;
        }
        return null;
    }

    public static boolean isHlsVideo(TweetMediaVideoVariant tweetMediaVideoVariant) {
        return CONTENT_TYPE_HLS.equals(tweetMediaVideoVariant.getContentType());
    }

    public static boolean isPhotoType(TweetMedia tweetMedia) {
        return PHOTO_TYPE.equals(tweetMedia.getType());
    }

    public static boolean isVideoType(TweetMedia tweetMedia) {
        return VIDEO_TYPE.equals(tweetMedia.getType()) || GIF_TYPE.equals(tweetMedia.getType());
    }

    public static TweetMediaVideoVariant getSupportedVariant(TweetMedia object) {
        for (TweetMediaVideoVariant tweetMediaVideoVariant : ((TweetMedia)object).getVideoInfo().getVariants()) {
            if (!TweetMediaUtils.isVariantSupported(tweetMediaVideoVariant)) continue;
            return tweetMediaVideoVariant;
        }
        return null;
    }

    public static boolean isLooping(TweetMedia tweetMedia) {
        return GIF_TYPE.equals(tweetMedia.getType()) || VIDEO_TYPE.endsWith(tweetMedia.getType()) && tweetMedia.getVideoInfo().getDurationMillis() < 6500;
    }

    public static boolean showVideoControls(TweetMedia tweetMedia) {
        return GIF_TYPE.equals(tweetMedia.getType()) ^ true;
    }

    public static boolean isVariantSupported(TweetMediaVideoVariant tweetMediaVideoVariant) {
        if (CONTENT_TYPE_HLS.equals(tweetMediaVideoVariant.getContentType())) {
            return true;
        }
        return CONTENT_TYPE_MP4.equals(tweetMediaVideoVariant.getContentType());
    }

    public static List<TweetMedia> getAllMediaEntities(Tweet tweet) {
        ArrayList<TweetMedia> arrayList;
        ArrayList<TweetMedia> arrayList2 = arrayList;
        arrayList = new ArrayList<TweetMedia>();
        if (tweet.getMetaData() != null && tweet.getMetaData().getEntities() != null) {
            arrayList2.addAll(tweet.getMetaData().getEntities().getMedia());
        }
        if (tweet.getMetaData() != null && tweet.getMetaData().getExtendedEntities() != null) {
            arrayList2.addAll(tweet.getMetaData().getExtendedEntities().getMedia());
        }
        return arrayList2;
    }
}

