/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.kotlin;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.content.ContextCompat;
import androidx.core.widget.TextViewCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.RecyclerView;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.protobuf.ByteString;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.common.mvvm.BaseFragment;
import io.streamlayer.sdk.R;
import io.streamlayer.utils.GsonUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\u001a\u001b\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001aV\u0010\u0012\u001a\u00020\u0010*\u00020\u00062\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012#\b\u0002\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\fH\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u001b\u0010\u0015\u001a\u00020\u0010*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0013\u0010\u0017\u001a\u00020\u0010*\u00020\u0003H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a\u0013\u0010\u0019\u001a\u00020\u0010*\u00020\u0003H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u0018\u001a\u0013\u0010\u001a\u001a\u00020\u0010*\u00020\u0003H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u0018\u001a\u001c\u0010\u001c\u001a\u00020\u0010*\u00020\u00032\u0006\u0010\u001b\u001a\u00020\tH\u0080\u0004\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a%\u0010 \u001a\u00020\u0010*\u00020\u00032\u0006\u0010\u001e\u001a\u00020\t2\b\b\u0002\u0010\u001f\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b \u0010!\u001a\u0017\u0010#\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\"H\u0000\u00a2\u0006\u0004\b#\u0010$\u001a\u0017\u0010%\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\"H\u0000\u00a2\u0006\u0004\b%\u0010$\u001a\u0017\u0010&\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\"H\u0000\u00a2\u0006\u0004\b&\u0010$\u001a\u0015\u0010(\u001a\u0004\u0018\u00010\u0007*\u00020'H\u0000\u00a2\u0006\u0004\b(\u0010)\u001a\u0017\u0010+\u001a\u0004\u0018\u00010**\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0004\b+\u0010,\u001a\u001d\u0010/\u001a\u0004\u0018\u00010\u0001*\u00020-2\u0006\u0010.\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b/\u00100\u001a#\u0010/\u001a\u00020\u0001*\u0002012\u0006\u0010.\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b/\u00103\u001a#\u00107\u001a\u00020\u0010*\u0002042\u0006\u00106\u001a\u0002052\u0006\u0010.\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b7\u00108\u001a\u0013\u0010:\u001a\u00020\u0010*\u000209H\u0000\u00a2\u0006\u0004\b:\u0010;\u001a\u001d\u0010>\u001a\u00020\u0010*\u00020<2\b\u0010=\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0004\b>\u0010?\u001a9\u0010C\u001a\u00020\u0010*\u0002012\b\u0010=\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010@\u001a\u00020\t2\u0010\b\u0002\u0010B\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010AH\u0000\u00a2\u0006\u0004\bC\u0010D\"\u001a\u0010H\u001a\u00020\u0001*\u00020E8@@\u0000X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u00a8\u0006I"}, d2={"Landroid/view/ViewGroup;", "", "layoutRes", "Landroid/view/View;", "inflate", "(Landroid/view/ViewGroup;I)Landroid/view/View;", "Landroid/widget/ImageView;", "", "url", "", "crossFade", "errorResId", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "success", "", "onLoadingFinished", "loadUrl", "(Landroid/widget/ImageView;Ljava/lang/String;ZLjava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "resId", "setDrawable", "(Landroid/widget/ImageView;I)V", "visible", "(Landroid/view/View;)V", "invisible", "gone", "boolean", "visibleIf", "(Landroid/view/View;Z)V", "condition", "elseValue", "visibleIfElse", "(Landroid/view/View;ZI)V", "Lcom/google/android/material/bottomsheet/BottomSheetBehavior;", "expand", "(Lcom/google/android/material/bottomsheet/BottomSheetBehavior;)V", "collapse", "toggle", "Lcom/google/protobuf/ByteString;", "parseUtf8", "(Lcom/google/protobuf/ByteString;)Ljava/lang/String;", "", "toSaveLong", "(Ljava/lang/String;)Ljava/lang/Long;", "Lio/streamlayer/common/mvvm/BaseFragment;", "attr", "resoleAttributeResId", "(Lio/streamlayer/common/mvvm/BaseFragment;I)Ljava/lang/Integer;", "Landroid/content/Context;", "defRes", "(Landroid/content/Context;II)I", "Landroid/content/res/TypedArray;", "Landroid/widget/TextView;", "view", "setTextStyle", "(Landroid/content/res/TypedArray;Landroid/widget/TextView;I)V", "Landroidx/recyclerview/widget/RecyclerView;", "addDivider", "(Landroidx/recyclerview/widget/RecyclerView;)V", "Landroidx/fragment/app/Fragment;", "message", "toast", "(Landroidx/fragment/app/Fragment;Ljava/lang/String;)V", "cancelable", "Lkotlin/Function0;", "ok", "showAlert", "(Landroid/content/Context;Ljava/lang/String;ZLkotlin/jvm/functions/Function0;)V", "", "getDp", "(F)I", "dp", "sdk_originalRelease"})
public final class ExtensionsKt {
    @NotNull
    public static final View inflate(@NotNull ViewGroup viewGroup, int n) {
        ViewGroup viewGroup2 = viewGroup;
        Intrinsics.checkNotNullParameter((Object)viewGroup2, (String)"$this$inflate");
        View view = LayoutInflater.from((Context)viewGroup2.getContext()).inflate(n, viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"LayoutInflater.from(cont\u2026e(layoutRes, this, false)");
        return view;
    }

    public static final void loadUrl(@NotNull ImageView imageView, @NotNull String string2, boolean bl, @Nullable Integer n, @NotNull Function1<? super Boolean, Unit> requestOptions) {
        RequestListener<Drawable> requestListener;
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"$this$loadUrl");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"url");
        Intrinsics.checkNotNullParameter(requestOptions, (String)"onLoadingFinished");
        RequestListener<Drawable> requestListener2 = requestListener;
        requestListener = new RequestListener<Drawable>(requestOptions){
            final /* synthetic */ Function1 $onLoadingFinished;
            {
                this.$onLoadingFinished = function1;
            }

            public boolean onLoadFailed(@Nullable GlideException glideException, @Nullable Object object, @Nullable Target<Drawable> target, boolean bl) {
                this.$onLoadingFinished.invoke((Object)Boolean.FALSE);
                return false;
            }

            public boolean onResourceReady(@Nullable Drawable drawable2, @Nullable Object object, @Nullable Target<Drawable> target, @Nullable DataSource dataSource, boolean bl) {
                this.$onLoadingFinished.invoke((Object)Boolean.TRUE);
                return false;
            }
        };
        BaseRequestOptions baseRequestOptions = new RequestOptions().dontTransform();
        Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions, (String)"RequestOptions().dontTransform()");
        requestOptions = (RequestOptions)baseRequestOptions;
        string2 = Glide.with((View)imageView).load(string2);
        if (bl) {
            string2.transition((TransitionOptions)new DrawableTransitionOptions().crossFade(200));
        }
        if (n != null) {
            string2.error(((Number)n).intValue());
        }
        string2.apply((BaseRequestOptions)requestOptions).listener((RequestListener)requestListener2).into(imageView);
    }

    public static /* synthetic */ void loadUrl$default(ImageView imageView, String string2, boolean bl, Integer n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            function1 = loadUrl.1.INSTANCE;
        }
        ExtensionsKt.loadUrl(imageView, string2, bl, n, (Function1<? super Boolean, Unit>)function1);
    }

    public static final void setDrawable(@NotNull ImageView imageView, int n) {
        ImageView imageView2 = imageView;
        Intrinsics.checkNotNullParameter((Object)imageView2, (String)"$this$setDrawable");
        imageView2.setImageDrawable((Drawable)VectorDrawableCompat.create((Resources)imageView2.getResources(), (int)n, null));
    }

    public static final void visible(@NotNull View view) {
        View view2 = view;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"$this$visible");
        view2.setVisibility(0);
    }

    public static final void invisible(@NotNull View view) {
        View view2 = view;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"$this$invisible");
        view2.setVisibility(4);
    }

    public static final void gone(@NotNull View view) {
        View view2 = view;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"$this$gone");
        view2.setVisibility(8);
    }

    public static final void visibleIf(@NotNull View view, boolean n) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"$this$visibleIf");
        n = n != 0 ? 0 : 8;
        view.setVisibility(n);
    }

    public static final void visibleIfElse(@NotNull View view, boolean bl, int n) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"$this$visibleIfElse");
        if (bl) {
            n = 0;
        }
        view.setVisibility(n);
    }

    public static /* synthetic */ void visibleIfElse$default(View view, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 4;
        }
        ExtensionsKt.visibleIfElse(view, bl, n);
    }

    public static final int getDp(float f) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        return (int)(f * resources.getDisplayMetrics().density);
    }

    public static final void expand(@NotNull BottomSheetBehavior<?> bottomSheetBehavior) {
        BottomSheetBehavior<?> bottomSheetBehavior2 = bottomSheetBehavior;
        Intrinsics.checkNotNullParameter(bottomSheetBehavior2, (String)"$this$expand");
        bottomSheetBehavior2.setState(3);
    }

    public static final void collapse(@NotNull BottomSheetBehavior<?> bottomSheetBehavior) {
        BottomSheetBehavior<?> bottomSheetBehavior2 = bottomSheetBehavior;
        Intrinsics.checkNotNullParameter(bottomSheetBehavior2, (String)"$this$collapse");
        bottomSheetBehavior2.setState(4);
    }

    public static final void toggle(@NotNull BottomSheetBehavior<?> bottomSheetBehavior) {
        BottomSheetBehavior<?> bottomSheetBehavior2 = bottomSheetBehavior;
        Intrinsics.checkNotNullParameter(bottomSheetBehavior2, (String)"$this$toggle");
        if (bottomSheetBehavior2.getState() == 3) {
            ExtensionsKt.collapse(bottomSheetBehavior);
        } else {
            ExtensionsKt.expand(bottomSheetBehavior);
        }
    }

    @Nullable
    public static final String parseUtf8(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"$this$parseUtf8");
        return (String)GsonUtil.INSTANCE.getDefaultGson().fromJson(byteString.toStringUtf8(), String.class);
    }

    @Nullable
    public static final Long toSaveLong(@Nullable String object) {
        if (object != null) {
            try {
                object = Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        object = null;
        return object;
    }

    @Nullable
    public static final Integer resoleAttributeResId(@NotNull BaseFragment baseFragment, int n) {
        TypedValue typedValue;
        Intrinsics.checkNotNullParameter((Object)baseFragment, (String)"$this$resoleAttributeResId");
        TypedValue typedValue2 = typedValue;
        typedValue2();
        baseFragment.getTheme().resolveAttribute(n, typedValue2, true);
        return typedValue.resourceId;
    }

    public static final int resoleAttributeResId(@NotNull Context context, int n, int n2) {
        TypedValue typedValue;
        Intrinsics.checkNotNullParameter((Object)context, (String)"$this$resoleAttributeResId");
        TypedValue typedValue2 = typedValue;
        typedValue2();
        context.getTheme().resolveAttribute(n, typedValue2, true);
        int n3 = typedValue.resourceId;
        if (n3 == 0) {
            n3 = n2;
        }
        return n3;
    }

    public static final void setTextStyle(@NotNull TypedArray typedArray, @NotNull TextView textView, int n) {
        Intrinsics.checkNotNullParameter((Object)typedArray, (String)"$this$setTextStyle");
        Intrinsics.checkNotNullParameter((Object)textView, (String)"view");
        int n2 = typedArray.getResourceId(n, 0);
        if (n2 != 0) {
            TextViewCompat.setTextAppearance((TextView)textView, (int)n2);
        }
    }

    public static final void addDivider(@NotNull RecyclerView recyclerView) {
        DividerItemDecoration dividerItemDecoration;
        RecyclerView recyclerView2 = recyclerView;
        Intrinsics.checkNotNullParameter((Object)recyclerView2, (String)"$this$addDivider");
        DividerItemDecoration dividerItemDecoration2 = dividerItemDecoration;
        dividerItemDecoration = new DividerItemDecoration(recyclerView.getContext(), 1);
        Drawable drawable2 = ContextCompat.getDrawable((Context)recyclerView2.getContext(), (int)R.drawable.slr_contacts_divider);
        if (drawable2 != null) {
            dividerItemDecoration2.setDrawable(drawable2);
        }
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)dividerItemDecoration2);
    }

    public static final void toast(@NotNull Fragment fragment, @Nullable String string2) {
        Fragment fragment2 = fragment;
        Intrinsics.checkNotNullParameter((Object)fragment2, (String)"$this$toast");
        Toast.makeText((Context)fragment2.requireContext(), (CharSequence)string2, (int)0).show();
    }

    public static final void showAlert(@NotNull Context context, @Nullable String string2, boolean bl, @Nullable Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"$this$showAlert");
        new MaterialAlertDialogBuilder(context, R.style.StreamLayerSDK_AlertDialog).setCancelable(bl).setMessage((CharSequence)string2).setPositiveButton(R.string.slr_ok, new DialogInterface.OnClickListener(function0){
            final /* synthetic */ Function0 $ok;
            {
                this.$ok = function0;
            }

            public final void onClick(DialogInterface dialogInterface, int n) {
                showAlert.1 this_ = this_.$ok;
                if (this_ != null) {
                    Unit cfr_ignored_0 = (Unit)this_.invoke();
                }
            }
        }).show();
    }

    public static /* synthetic */ void showAlert$default(Context context, String string2, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function0 = null;
        }
        ExtensionsKt.showAlert(context, string2, bl, (Function0<Unit>)function0);
    }
}

