/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.format;

import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import io.streamlayer.sdk.twitter.view.internal.format.FormattedMediaEntity;
import io.streamlayer.sdk.twitter.view.internal.format.FormattedText;
import io.streamlayer.sdk.twitter.view.internal.format.FormattedUrlEntity;
import io.streamlayer.sdk.twitter.view.internal.format.TweetLinkifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J[\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0019\u0010 \u001a\u00020\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010$\u001a\u0004\u0018\u00010\u00022\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b$\u0010%\u00a8\u0006("}, d2={"Lio/streamlayer/sdk/twitter/view/internal/format/TweetLinkifier;", "", "", "charSequence", "trimEnd", "(Ljava/lang/CharSequence;)Ljava/lang/CharSequence;", "", "Lio/streamlayer/sdk/twitter/view/internal/format/FormattedUrlEntity;", "urls", "Lio/streamlayer/sdk/twitter/view/internal/format/FormattedMediaEntity;", "media", "hashtags", "mentions", "symbols", "mergeAndSortEntities", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)Ljava/util/List;", "Landroid/text/SpannableStringBuilder;", "spannable", "entities", "strippedEntity", "", "addUrlEntities", "(Landroid/text/SpannableStringBuilder;Ljava/util/List;Lio/streamlayer/sdk/twitter/view/internal/format/FormattedUrlEntity;)V", "", "tweetText", "combined", "getEntityToStrip", "(Ljava/lang/String;Ljava/util/List;)Lio/streamlayer/sdk/twitter/view/internal/format/FormattedUrlEntity;", "stripLtrMarker", "(Ljava/lang/String;)Ljava/lang/String;", "urlEntity", "", "isPhotoEntity", "(Lio/streamlayer/sdk/twitter/view/internal/format/FormattedUrlEntity;)Z", "Lio/streamlayer/sdk/twitter/view/internal/format/FormattedText;", "text", "linkifyUrls", "(Lio/streamlayer/sdk/twitter/view/internal/format/FormattedText;)Ljava/lang/CharSequence;", "<init>", "()V", "sdk_originalRelease"})
public final class TweetLinkifier {
    @NotNull
    public static final TweetLinkifier INSTANCE = new TweetLinkifier();

    private final CharSequence trimEnd(CharSequence charSequence) {
        int n;
        for (n = charSequence.length(); n > 0 && Intrinsics.compare((int)charSequence.charAt(n - 1), (int)32) <= 0; --n) {
        }
        if (n < charSequence.length()) {
            charSequence = charSequence.subSequence(0, n);
        }
        return charSequence;
    }

    private final List<FormattedUrlEntity> mergeAndSortEntities(List<? extends FormattedUrlEntity> list, List<FormattedMediaEntity> list2, List<? extends FormattedUrlEntity> list3, List<? extends FormattedUrlEntity> list4, List<? extends FormattedUrlEntity> list5) {
        ArrayList arrayList;
        ArrayList<? extends FormattedUrlEntity> arrayList2 = arrayList;
        arrayList2(list);
        arrayList2.addAll(list2);
        arrayList2.addAll(list3);
        arrayList2.addAll(list4);
        arrayList.addAll(list5);
        CollectionsKt.sortWith((List)arrayList, (Comparator)mergeAndSortEntities.1.INSTANCE);
        return arrayList;
    }

    private final void addUrlEntities(SpannableStringBuilder spannableStringBuilder, List<? extends FormattedUrlEntity> object, FormattedUrlEntity formattedUrlEntity) {
        if (object.isEmpty()) {
            return;
        }
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (FormattedUrlEntity)object.next();
            int n2 = ((FormattedUrlEntity)object2).getStart() - n;
            int n3 = ((FormattedUrlEntity)object2).getEnd() - n;
            if (n2 < 0 || n3 > spannableStringBuilder.length()) continue;
            if (formattedUrlEntity != null && formattedUrlEntity.getStart() == ((FormattedUrlEntity)object2).getStart()) {
                spannableStringBuilder.replace(n2, n3, (CharSequence)"");
                n += n3 - n2;
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)((FormattedUrlEntity)object2).getDisplayUrl())) continue;
            FormattedUrlEntity formattedUrlEntity2 = object2;
            object2 = ((FormattedUrlEntity)object2).getDisplayUrl();
            spannableStringBuilder.replace(n2, n3, (CharSequence)object2);
            object2 = formattedUrlEntity2.getDisplayUrl();
            int n4 = object2 != null ? ((String)object2).length() : 0;
            n += n3 - (n2 + n4);
        }
    }

    private final FormattedUrlEntity getEntityToStrip(String string2, List<? extends FormattedUrlEntity> object) {
        if (object.isEmpty()) {
            return null;
        }
        List<? extends FormattedUrlEntity> list = object;
        object = list.get(list.size() - 1);
        string2 = this.stripLtrMarker(string2);
        String string3 = ((FormattedUrlEntity)object).getUrl();
        if (string3 == null) {
            string3 = "";
        }
        if (!StringsKt.endsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null) || !this.isPhotoEntity((FormattedUrlEntity)object)) {
            object = null;
        }
        return object;
    }

    private final String stripLtrMarker(String string2) {
        if (StringsKt.endsWith$default((String)string2, (String)String.valueOf('\u200e'), (boolean)false, (int)2, null)) {
            String string3 = string2;
            int n = 0;
            int n2 = string3.length() - 1;
            if (string3 != null) {
                string2 = string2.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
        }
        return string2;
    }

    private final boolean isPhotoEntity(FormattedUrlEntity formattedUrlEntity) {
        return formattedUrlEntity instanceof FormattedMediaEntity && Intrinsics.areEqual((Object)"photo", (Object)((FormattedMediaEntity)formattedUrlEntity).getType());
    }

    private TweetLinkifier() {
    }

    @Nullable
    public final CharSequence linkifyUrls(@NotNull FormattedText list) {
        SpannableStringBuilder spannableStringBuilder;
        FormattedText formattedText = list;
        Intrinsics.checkNotNullParameter((Object)formattedText, (String)"text");
        if (TextUtils.isEmpty((CharSequence)formattedText.getText())) {
            return ((FormattedText)((Object)list)).getText();
        }
        TweetLinkifier tweetLinkifier = tweetLinkifier3;
        FormattedText formattedText2 = list;
        TweetLinkifier tweetLinkifier2 = tweetLinkifier3;
        FormattedText formattedText3 = list;
        TweetLinkifier tweetLinkifier3 = spannableStringBuilder;
        spannableStringBuilder = new SpannableStringBuilder((CharSequence)((FormattedText)((Object)list)).getText());
        list = formattedText3.getUrlEntities();
        Object object = formattedText3.getMediaEntities();
        List<FormattedUrlEntity> list2 = formattedText3.getHashtagEntities();
        List<FormattedUrlEntity> list3 = formattedText3.getMentionEntities();
        List<FormattedUrlEntity> list4 = formattedText3.getSymbolEntities();
        list = tweetLinkifier2.mergeAndSortEntities((List<? extends FormattedUrlEntity>)list, (List<FormattedMediaEntity>)object, (List<? extends FormattedUrlEntity>)list2, (List<? extends FormattedUrlEntity>)list3, (List<? extends FormattedUrlEntity>)list4);
        String string2 = formattedText2.getText();
        Intrinsics.checkNotNull((Object)string2);
        object = tweetLinkifier.getEntityToStrip(string2, list);
        tweetLinkifier.addUrlEntities((SpannableStringBuilder)tweetLinkifier3, list, (FormattedUrlEntity)object);
        return tweetLinkifier.trimEnd((CharSequence)((Object)tweetLinkifier3));
    }
}

