/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.media;

import android.content.Context;
import android.net.Uri;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideo;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoPlayerCache;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ!\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u001d\u0010\u0013\u001a\u00020\u000e8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00060\u00148\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoComponent;", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoPlayerCache;", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;", "video", "", "forceCreate", "Lcom/google/android/exoplayer2/SimpleExoPlayer;", "getPlayer", "(Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;Z)Lcom/google/android/exoplayer2/SimpleExoPlayer;", "", "releasePlayer", "(Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;)V", "release", "()V", "Lcom/google/android/exoplayer2/upstream/DefaultDataSourceFactory;", "defaultSourceFactory$delegate", "Lkotlin/Lazy;", "getDefaultSourceFactory", "()Lcom/google/android/exoplayer2/upstream/DefaultDataSourceFactory;", "defaultSourceFactory", "", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo$Url;", "playersCache", "Ljava/util/Map;", "Landroid/content/Context;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "sdk_originalRelease"})
public final class TweetVideoComponent
implements TweetVideoPlayerCache {
    private final Map<TweetVideo.Url, SimpleExoPlayer> playersCache;
    private final Lazy defaultSourceFactory$delegate;
    private final Context context;

    private final DefaultDataSourceFactory getDefaultSourceFactory() {
        return (DefaultDataSourceFactory)this.defaultSourceFactory$delegate.getValue();
    }

    public TweetVideoComponent(@NotNull Context context) {
        TweetVideoComponent tweetVideoComponent = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        tweetVideoComponent.context = context;
        tweetVideoComponent.playersCache = new LinkedHashMap<TweetVideo.Url, SimpleExoPlayer>();
        tweetVideoComponent.defaultSourceFactory$delegate = LazyKt.lazy((Function0)new Function0<DefaultDataSourceFactory>(this){
            final /* synthetic */ TweetVideoComponent this$0;
            {
                this.this$0 = tweetVideoComponent;
                super(0);
            }

            @NotNull
            public final DefaultDataSourceFactory invoke() {
                return new DefaultDataSourceFactory(TweetVideoComponent.access$getContext$p(this.this$0), Util.getUserAgent((Context)TweetVideoComponent.access$getContext$p(this.this$0), (String)"streamlayer"), (TransferListener)new DefaultBandwidthMeter.Builder(TweetVideoComponent.access$getContext$p(this.this$0)).build());
            }
        });
    }

    public static final /* synthetic */ Context access$getContext$p(TweetVideoComponent tweetVideoComponent) {
        return tweetVideoComponent.context;
    }

    @Override
    @Nullable
    public SimpleExoPlayer getPlayer(@NotNull TweetVideo tweetVideo, boolean bl) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"video");
        Object object2 = tweetVideoComponent.playersCache.get(tweetVideo.getUrl());
        if (object2 != null) {
            object = object2;
        } else if (!bl) {
            TweetVideoComponent tweetVideoComponent = null;
            object = tweetVideoComponent;
        } else {
            TweetVideo tweetVideo2 = tweetVideo;
            object = ExoPlayerFactory.newSimpleInstance((Context)tweetVideoComponent.context);
            object2 = Uri.parse((String)tweetVideo2.getUrl().getValue());
            object2 = tweetVideo2.isHlsType() ? new HlsMediaSource.Factory((DataSource.Factory)tweetVideoComponent.getDefaultSourceFactory()).createMediaSource((Uri)object2) : new ProgressiveMediaSource.Factory((DataSource.Factory)tweetVideoComponent.getDefaultSourceFactory()).createMediaSource((Uri)object2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player");
            object.setRepeatMode(tweetVideo.isLooping() ? 1 : 0);
            object.prepare((MediaSource)object2);
            tweetVideoComponent.playersCache.put(tweetVideo.getUrl(), (SimpleExoPlayer)object);
        }
        return object;
    }

    @Override
    public void releasePlayer(@NotNull TweetVideo tweetVideo) {
        Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"video");
        SimpleExoPlayer simpleExoPlayer = this.playersCache.get(tweetVideo.getUrl());
        if (simpleExoPlayer != null) {
            simpleExoPlayer.release();
        }
        this.playersCache.remove(tweetVideo.getUrl());
    }

    @Override
    public void release() {
        Iterator<Map.Entry<TweetVideo.Url, SimpleExoPlayer>> iterator = this.playersCache.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().getValue().release();
        }
        this.playersCache.clear();
    }
}

